//
//  Copyright (C) 1998 Matthias Hoelzer
//  email:  hoelzer@physik.uni-wuerzburg.de
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the7 implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#ifndef _KTABLE_H_
#define _KTABLE_H_

#include <qdialog.h>
#include <qlist.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qstrlist.h>


class KTableBox : public QDialog
{
  Q_OBJECT
  
public:

  KTableBox(int width, int tabheight, QString text, QWidget *parent=0);
  ~KTableBox() {};  
  
protected:

  QListBox *table;
  QPushButton *ok, *cancel;
  QLabel *label;
    
};


class KMenuTable : public KTableBox 
{
  Q_OBJECT
  
public:

  KMenuTable(int width, int tabheight, QString text, QWidget *parent=0)
    : KTableBox(width, tabheight, text, parent) {};
  ~KMenuTable() {};  
  
  void insertItems(QStrList items);
  void insertItem(QString item);
  int getItem();
};


class KCheckTable : public KTableBox 
{
  Q_OBJECT
  
public:

  KCheckTable(int width, int tabheight, QString text, QWidget *parent=0)
    : KTableBox(width, tabheight, text, parent) {};
  ~KCheckTable() {};  
  
  QListBox &getTable() { return *table; };
  
};


#endif
