//
//  Copyright (C) 1998 Matthias Hoelzer
//  email:  hoelzer@physik.uni-wuerzburg.de
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the7 implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#include <kapp.h>
#include <stream.h>
#include <qfile.h>
#include <qtstream.h>

#include "ktextbox.h"
#include "ktextbox.moc"

#include "klocale.h"


KTextBox::KTextBox(QWidget *parent, const char *name, bool modal, int w, int h, QString file) 
  : QDialog(parent,name,modal)
{
  QMultiLineEdit *edit = new QMultiLineEdit(this);

  int width = w * fontMetrics().width("x");
  int height = h * fontMetrics().height();

  edit->setGeometry(0,0,width,height);
  edit->setReadOnly(TRUE);

  ok = new QPushButton(i18n("&Ok"), this);
  ok->setDefault(TRUE);
  ok->adjustSize();

  ok->move((width - ok->width())/2, height + 8);

  connect(ok, SIGNAL(pressed()), this, SLOT(accept()));

  QFile f(file);
  if (!f.open(IO_ReadOnly))
  {
    cerr << i18n("kdialog: could not open file ") << file << endl;
    exit(-1);
  }
  QTextStream s(&f);
  
  while (!s.eof())
    edit->append(s.readLine());

  f.close();

  adjustSize();
  setFixedSize(this->width(), this->height());
}
