/***************************************************************************
                          cleanupwizard.cpp  -  description
                             -------------------
    begin                : Mon Dec 20 1999
    copyright            : (C) 1999 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cleanupwizard.h"
#include <stdlib.h>
#include <klocale.h>
#include "info.h"

CleanUpWizard::CleanUpWizard(FileGroupExt * f, QWidget* parent,const char* name, bool modal) : KWizard(parent,name,modal){
	fileGroup = f;
	this -> setFixedSize(420,360);

	cleanUpWizard_1 = new CleanUpWizard_1();
 	addPage(cleanUpWizard_1,i18n("Choose action"));
	connect(cleanUpWizard_1 -> QRadioButton_1,SIGNAL(clicked()),SLOT(slotDeleteClicked()));
	connect(cleanUpWizard_1 -> QRadioButton_2,SIGNAL(clicked()),SLOT(slotArchiveClicked()));
	connect(cleanUpWizard_1 -> QRadioButton_3,SIGNAL(clicked()),SLOT(slotMoveClicked()));

	cleanUpWizard_2 = new CleanUpWizard_2();
	cleanUpWizard_2 -> QLabel_1 -> setText(i18n("Do you want to backup the files?"));
	cleanUpWizard_2 -> QLabel_2 -> setText(i18n("Backup Folder:"));
	addPage(cleanUpWizard_2,i18n("Delete Files"));
	connect(cleanUpWizard_2 -> QPushButton_1,SIGNAL(clicked()),SLOT(slotBrowseClicked()));

	cleanUpWizard_3 = new CleanUpWizard_3();
	addPage(cleanUpWizard_3,i18n("Clean Up"));
	setTextPage_3(i18n("will be deleted, containing"));
 	cleanUpWizard_3 -> QLabel_1 -> setAlignment(WordBreak);
	connect(cleanUpWizard_3 -> QPushButton_1,SIGNAL(clicked()),SLOT(slotViewLog()));
  cleanUpWizard_3 -> QPushButton_1 -> hide();
	setFinishEnabled(cleanUpWizard_3, true);
	
	batch = new Batch(true);
	logViewer = 0;
}

CleanUpWizard::~CleanUpWizard(){
	delete cleanUpWizard_1;
	delete cleanUpWizard_2;
	delete cleanUpWizard_3;
	if (batch){}
		delete batch;
	if (logViewer)
		delete logViewer;
}

void CleanUpWizard::slotDeleteClicked(){
	setTitle(cleanUpWizard_2,i18n("Delete Files"));
	cleanUpWizard_2 -> QLabel_1 -> setText(i18n("Do you want to backup the files?"));
	cleanUpWizard_2 -> QLabel_2 -> setText(i18n("Backup Folder:"));
	cleanUpWizard_2 -> QRadioButton_1 -> show();
	cleanUpWizard_2 -> QRadioButton_2 -> show();
	setTextPage_3(i18n("will be deleted, containing"));
}

void CleanUpWizard::slotArchiveClicked(){
	setTitle(cleanUpWizard_2,i18n("Archive Files"));
	cleanUpWizard_2 -> QLabel_1 -> setText(i18n("In which folder do you want to archive the files?"));
	cleanUpWizard_2 -> QLabel_2 -> setText(i18n("Archive Folder:"));
	cleanUpWizard_2 -> QLineEdit_1 -> setText(defaultArchiveDir());
	cleanUpWizard_2 -> QButtonGroup_1 -> hide();
	setTextPage_3(i18n("will be archived, containing"));
}

void CleanUpWizard::slotMoveClicked(){
	setTitle(cleanUpWizard_2,i18n("Move Files"));
	cleanUpWizard_2 -> QLabel_1 -> setText(i18n("To which folder do you want to move the files?"));
	cleanUpWizard_2 -> QLabel_2 -> setText(i18n(" Move to Folder:"));
	cleanUpWizard_2 -> QLineEdit_1 -> setText(getenv("HOME"));
	cleanUpWizard_2 -> QButtonGroup_1 -> hide();
	setTextPage_3(i18n("will be moved, containing"));
}

void CleanUpWizard::slotBrowseClicked(){
	cleanUpWizard_2 -> QLineEdit_1 -> setText(KFileDialog::getExistingDirectory(getenv("HOME")));		
}

void CleanUpWizard::setTextPage_3(QString s){
	QString n_1,n_2;
	n_1.setNum(fileGroup -> numMarked());
	n_2.setNum(fileGroup -> sizeMarked());
	cleanUpWizard_3 -> QLabel_1 -> setText(i18n("A total of " + n_1 + " files " + s + " " + n_2 + " bytes"));
}

void CleanUpWizard::slotCleanUpCompleted(){
	delete progress;
	if (batch){
		system(fileGroup -> command());
		logViewer = new LogViewer(batch -> procList);	
		cleanUpWizard_3 -> QPushButton_1 -> show();
		if (batch -> error())
			cleanUpWizard_3 -> QLabel_1 -> setText(i18n("Errors occured! See log for more information"));
		else
			cleanUpWizard_3 -> QLabel_1 -> setText(i18n("The cleaning ended succesfully."));
		}	
	finishButton() -> hide();
	backButton() -> hide();
	cancelButton() -> setText(i18n("Close"));
}

void CleanUpWizard::slotViewLog(){
	logViewer -> show();
}

void CleanUpWizard::accept(){
	progress = new ABProgress();
	progress -> show();
	progress -> QProgressBar_1 -> setTotalSteps(fileGroup -> numMarked());
	connect (progress -> QPushButton_1, SIGNAL(clicked()), SLOT(slotCancel()));
	if (cleanUpWizard_1 -> QRadioButton_1 -> isChecked() & cleanUpWizard_2 -> QRadioButton_1 -> isChecked()){
		progress -> QLabel_1 -> setText(i18n("Backup & Delete Files"));
		proc = fileGroup -> archive(fileGroup -> nextArchiveFileName(cleanUpWizard_2 -> QLineEdit_1 -> text()),fileGroup -> archiveRoot(),false);
		connect(proc, SIGNAL(receivedOutput(int,QString)), progress, SLOT(slotProgress(int,QString)));
		batch -> append(proc, fileGroup);
		proc = fileGroup -> remove();
		connect(proc, SIGNAL(receivedOutput(int,QString)), progress, SLOT(slotProgress(int,QString)));
		batch -> append(proc, fileGroup );
		connect(batch, SIGNAL(batchExited()),SLOT(slotCleanUpCompleted()));
		batch -> start();
	}
	if (cleanUpWizard_1 -> QRadioButton_1 -> isChecked() & cleanUpWizard_2 -> QRadioButton_2 -> isChecked()){
		progress -> QLabel_1 -> setText(i18n("Delete Files"));
		proc = fileGroup -> remove();
		connect(proc, SIGNAL(receivedOutput(int,QString)), progress, SLOT(slotProgress(int,QString)));
		batch -> append(proc, fileGroup );
		connect(batch, SIGNAL(batchExited()),SLOT(slotCleanUpCompleted()));
		batch -> start();
	}
	if (cleanUpWizard_1 -> QRadioButton_2 -> isChecked()){
		progress -> QLabel_1 -> setText(i18n("Archive Files"));
		proc = fileGroup -> archive(fileGroup -> nextArchiveFileName(cleanUpWizard_2 -> QLineEdit_1 -> text()), fileGroup -> archiveRoot(),true);
		connect(proc, SIGNAL(receivedOutput(int,QString)), progress, SLOT(slotProgress(int,QString)));
		batch -> append(proc, fileGroup );
		connect(batch, SIGNAL(batchExited()),SLOT(slotCleanUpCompleted()));
		batch -> start();
	}
	if (cleanUpWizard_1 -> QRadioButton_3 -> isChecked()){
		progress -> QLabel_1 -> setText(i18n("Move Files"));
		proc = fileGroup -> move(cleanUpWizard_2 -> QLineEdit_1 -> text());
		connect(proc, SIGNAL(receivedOutput(int,QString)), progress, SLOT(slotProgress(int,QString)));
		batch -> append(proc, fileGroup );
		connect(batch, SIGNAL(batchExited()),SLOT(slotCleanUpCompleted()));
		batch -> start();
	}
}

void CleanUpWizard::slotCancel(){
	disconnect(batch, SIGNAL(batchExited()),this,SLOT(slotCleanUpCompleted()));
	delete batch;
	batch = NULL;
	slotCleanUpCompleted();
}
