/***************************************************************************
                          groupitem.h  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GROUPITEM_H
#define GROUPITEM_H

#include <qobject.h>
#include <qstring.h>
#include <qlistview.h>
#include <qpopupmenu.h>	
#include "groupmanager.h"
#include "cleanupwizard.h"
#include "filegroupbase.h"

/**
  *@author Arjan Buursink
  */
class GroupViewWidget;

class GroupItem : public QObject {
	Q_OBJECT
public:
	GroupItem(GroupManager *,GroupViewWidget *);
	~GroupItem();
	void deleteChilderen();
	void deleteItem(QString);
	QListViewItem * topItem() { return _topItem;};
	QListViewItem * item(QListViewItem *, QString);
	QString name(QListViewItem *);
	grouptype type() { return _type; };
	void setType(grouptype t) { _type = t; };
	GroupViewWidget * groupViewWidget() { return _groupViewWidget; };
protected:
	GroupManager * groupManager(){return _groupManager;};
	QListView * parent() { return _parent; };
	void groupToItem(FileGroupBase *, QListViewItem *);
	QPopupMenu * popup;
	QListViewItem * selectedItem(){	return parent() -> currentItem();};
	bool hasAncestor(QListViewItem *, QListViewItem *);
	QListViewItem * itemHasChild(QListViewItem *, QString);
	grouptype _type;
	CleanUpWizard * cleanUpWizard;
	GroupViewWidget * _groupViewWidget;
private:
	QListViewItem * _topItem;
	QListView * _parent;
	GroupManager * _groupManager;
private slots:
	virtual void slotItemClicked(QListViewItem *, const QPoint &, int){};
	virtual void slotUpdateReady(){};
	virtual void slotPopup(QListViewItem *, const QPoint &, int){};
	virtual void slotCleanupEnded(){};
	void slotCleanup(FileGroupExt*);
signals:
	void setupFileList(FileGroupBase*);
	void setProperties(FileGroupBase*);
	
};

#endif
