/***************************************************************************
                          logviewer.cpp  -  description
                             -------------------
    begin                : Mon Aug 30 1999
    copyright            : (C) 1999 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "logviewer.h"

#include <stdlib.h>

#include <qstring.h>
#include <qfile.h>
#include <qfileinfo.h>

#include <kapp.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kmessagebox.h>

LogViewer::LogViewer( QList<ABProcess> * p, QStrList * l, QWidget * parent = 0, const char * name = 0) : QDialog(parent,name,true){
	initDialog();
	pl = p;
	tl = l;
	connect(exitButton,SIGNAL(clicked()),SLOT(slotExit()));
	connect(saveButton,SIGNAL(clicked()),SLOT(slotSave()));
	connect(printButton,SIGNAL(clicked()),SLOT(slotPrint()));
	setLog();
}

LogViewer::~LogViewer(){
	delete tl;
}

void LogViewer::slotExit(){
	this -> hide();
}

void LogViewer::slotSave(){
	bool b = true;
	QString filename;
	QString t("");
	filename = KFileDialog::getSaveFileName(getenv("HOME"),0);
	QFileInfo fi(filename);
	if (fi.exists()){
		b = false;
		QString t(i18n("Overwrite file\n"));
		t = t + fi.absFilePath() + "?";
		if (KMessageBox::questionYesNo(this,i18n("Overwrite file?"),t) == KMessageBox::Yes)
			b = true;
	}
	if (b){
		QFile file(filename);
		file.open(IO_WriteOnly);
		file.writeBlock(logText -> text(), logText -> text().length());
		file.close();
	}
}

void LogViewer::slotPrint(){
	QString filename("/tmp/kleandisk.log");
	QFile file(filename);
	file.open(IO_WriteOnly);
	file.writeBlock(logText -> text(), logText -> text().length());
	file.close();
	printLog = new KProcess();
	*printLog << "lpr";
	*printLog << "/tmp/kleandisk.log";
	connect(printLog, SIGNAL(processExited(KProcess *)), SLOT(slotPrintExited()));
	printLog -> start(KProcess::NotifyOnExit, KProcess::AllOutput);

}

void LogViewer::slotPrintExited(){
	delete printLog;
}

void LogViewer::setLog(){
	QString l("");
	if (tl){
		for (uint i = 0; i < tl -> count(); i++)
			l += QString(tl -> at(i)) + "\n";
		l += "\n";
	}
	for (uint i = 0; i < pl -> count(); i++){
		l += i18n("Output from process: ");
		l += pl -> at(i) -> name();
		l += "\n";
		l += "-----\n";
		for (uint j = 0; j < pl -> at(i) -> output -> count(); j++)
		l += QString (pl -> at(i) -> output -> at(j)) + "\n";
		l += "-----\n\n";
		l += i18n("Exit status: ");
		l += pl -> at(i) -> name();
		if (pl -> at(i) -> std_err.length() == 0)
			l += i18n(" ended without errors.");
		else{
			l += i18n(" ended with errros!");
			l += "\n";
			l += "Error log:\n";
			l += "-----\n";
			l += pl -> at(i) -> std_err;
			l += "-----";
		}
		l += "\n\n\n";
	}
	logText -> setText(l);
}


