/***************************************************************************
                          restorewizard.cpp  -  description
                             -------------------
    begin                : Fri Jan 7 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "restorewizard.h"
#include <klocale.h>
#include <kmessagebox.h>

RestoreWizard::RestoreWizard(QWidget * parent = 0, const char * name = 0, bool modal = true): KWizard(parent,name,modal){
	restoreWizard_1 = new RestoreWizard_1();
  addPage(restoreWizard_1,i18n("Select the archive/backup you wish to restore"));
	setNextEnabled(restoreWizard_1,false);

	restoreWizard_2 = new RestoreWizard_2();
	addPage(restoreWizard_2,i18n("Select the files you wish to restore"));
	setFinishEnabled(restoreWizard_2, true);

	this -> setFixedSize(580,550);
	
	finishButton() -> setText(i18n("Restore"));

	tar = new ABProcess("tar");

	connect(restoreWizard_1 -> QListView_1,SIGNAL(selectionChanged(QListViewItem*)),SLOT(slotArchiveSelected(QListViewItem*)));
	connect(restoreWizard_2 -> tar,SIGNAL(processExited(KProcess *)),SLOT(slotTar2Exited()));
}

RestoreWizard::~RestoreWizard(){
	delete restoreWizard_1;
	delete restoreWizard_2;
}

void RestoreWizard::slotArchiveSelected(QListViewItem* i){
	setCursor(waitCursor);
	nextButton() -> setEnabled(false);
	restoreWizard_1 -> enableItems(false);
	restoreWizard_2 -> setArchive(i);
}

void RestoreWizard::accept(){
	bool go = true;
	if (go && currentPage() != restoreWizard_2)
		go = false;
	if (go && restoreWizard_2 -> numSelected() == 0){
		go = false;
		KMessageBox::information(0,i18n("Please select one or more files"));
	}
	if (go && restoreWizard_2 -> overWrite() > 0){
		QString txt(i18n("Are you sure you want to overwrite "));
		QString n;
		n.setNum(restoreWizard_2 -> overWrite());
		txt += n;
		txt += i18n(" existing file(s)?");
		if (KMessageBox::questionYesNo(0,txt) == KMessageBox::No)
			go = false;
	}
	if (go){
		cancelButton() -> setText(i18n("Close"));
		int nf = restoreWizard_2 -> QListView_1 -> childCount();
		tar -> init();
		tar -> clearArguments();
		*tar << "tar";
		*tar << "zxvf";
		*tar << restoreWizard_2 -> archive();
		*tar << "-C";
		*tar << restoreWizard_2 -> QLineEdit_1 -> text();
		if (restoreWizard_2 -> QRadioButton_2 -> isChecked()){
			nf = 0;
			QListViewItem * item = restoreWizard_2 -> QListView_1 -> firstChild();
			while (item != 0){
				if (item -> isSelected()){
					* tar << QString(item -> text(1)) + "/" + item -> text(0);
					nf++;
				}
				item = item -> itemBelow();
			}
		}
		progress = new ABProgress();
		progress -> show();
		progress -> QProgressBar_1 -> setTotalSteps(nf);
		connect(tar, SIGNAL(receivedOutput(int,QString)), progress, SLOT(slotProgress(int,QString)));
		connect(tar, SIGNAL(processExited(KProcess *)), SLOT(slotTarExited()));
		tar -> start(KProcess::NotifyOnExit,KProcess::AllOutput);
	}
	if (currentPage() == restoreWizard_3)
		delete this;
}

void RestoreWizard::slotTarExited(){
	delete progress;
	QList<ABProcess> * pl = new QList<ABProcess>;
	pl -> append(tar);
	QStrList *tl = new QStrList;
	tl -> append(i18n("Restore archive: "));
	tl ->	append(restoreWizard_2 -> archive());
	tl -> append("");
	tl -> append(i18n("Restore to folder: "));
	tl -> append(restoreWizard_2 -> QLineEdit_1 -> text());
	logViewer = new LogViewer(pl,tl);
	restoreWizard_3 = new RestoreWizard_3(this);
	addPage(restoreWizard_3,i18n("Restore finished"));
	setBackEnabled(restoreWizard_3,false);
	setNextEnabled(restoreWizard_3,false);

	if (pl -> at(0) -> error())
		restoreWizard_3 -> QLabel_1 -> setText(i18n("Errors occured! See log for more information"));
	else
		restoreWizard_3 -> QLabel_1 -> setText(i18n("The cleaning ended succesfully."));
	delete pl;
	delete tl;
	showPage(restoreWizard_3);
	connect(restoreWizard_3 -> QPushButton_1,SIGNAL(clicked()),SLOT(slotViewLog()));
}

void RestoreWizard::slotTar2Exited(){
	restoreWizard_1 -> enableItems(true);
	setNextEnabled(restoreWizard_1, true);
	setCursor(arrowCursor);
}

void RestoreWizard::slotViewLog(){
	logViewer -> show();
}

void RestoreWizard::slotClose(){
	delete this;
}

