/***************************************************************************
                          tgz.cpp  -  description
                             -------------------
    begin                : Fri Dec 17 1999
    copyright            : (C) 1999 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tgz.h"
#include <stdlib.h>
#include <qtextstream.h>
#include <ksimpleconfig.h>
#include "info.h"

TGZ::TGZ(const QString s){
	bfn = s;
}

TGZ::TGZ(const QString f, const QString d){
	QFileInfo fi(f);
	setName(fi.baseName());
	setArchiveRoot(d);
	p = new ABProcess("tar");
	connect(p, SIGNAL(processExited(KProcess *)),SLOT(slotTarExtractProcessEnded()));
	*p << "tar";
	*p << "zxvf";
	*p << f;
	*p << "-C";
	*p << d;
	p -> start(KProcess::NotifyOnExit, KProcess::AllOutput);
}

TGZ::~TGZ(){
}

void TGZ::saveConfig(){
	KSimpleConfig config(tgzDir() + baseFileName() + ".config");
	config.writeEntry("Description",description());
	config.writeEntry("Archive Root",archiveRoot());
	config.writeEntry("Icon",icon());
	config.writeEntry("Name",name());
}

void TGZ::saveFiles(){
	QFile f(tgzDir() + baseFileName() + ".files");
	if (f.open(IO_WriteOnly)){
		QTextStream t(&f);
		for (uint i = 0; i < numFiles(); i++)
			t << file(i) << "\n";
		f.close();
	}	
}

void TGZ::save(){
	saveConfig();
	saveFiles();
}

void TGZ::loadConfig(){
	KSimpleConfig config(tgzDir() + baseFileName() + ".config");
	setDescription(config.readEntry("Description"));
	setArchiveRoot(config.readEntry("Archive Root"));
	setIcon(config.readEntry("Icon"));
	setName(config.readEntry("Name"));
}

void TGZ::loadFiles(){
	unloadFiles();
	QFile f(tgzDir() + baseFileName() + ".files");
	if (f.open(IO_ReadOnly)){
		QTextStream t(&f);
		while (!t.eof())
			addFile (t.readLine());
		f.close();
	}
}

void TGZ::load(){
	loadConfig();
	loadFiles();
}

void TGZ::slotTarExtractProcessEnded(){
	QString s;
	for (unsigned int i = 0; i < p -> output -> count(); i++){
		s = archiveRoot() + p -> output -> at(i);
		QFileInfo f(s);
		if (f.isFile())
			addFile(s);
		if (f.isDir())
			addDir(s);
	}
	delete p;
	save();
}

// not used for the moment. Will it ever be used?

bool TGZ::dirHasChild(QString s){
	bool b = false;
	int l = s.length();
	QString t;
	for (unsigned int i = 0; i < dirList -> count(); i++){
		t = QString(dirList -> at(i));
		t = t.left(l);
		if (t == s & dirList -> at(i) != s){
			b = true;
			break;
		}
	}
	return b;
}

void TGZ::setArchiveRoot(QString s){
	// remove slashes
	while (s.right(1) == "/")
		s = s.left(s.length() - 1);
	// now append 1 slash		
	archrt = s + "/";
}