/**
 * hosttoken.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KONFIG_HOSTTOKEN_H
#define KONFIG_HOSTTOKEN_H

#include "token.h"

#include <kurl.h>
#include <qptrlist.h>

namespace KCfgCreator
{
    class ApplicationToken;
    class HostToken : public Token
    {
    public:
        /**
         * Creates the parent host for the configuration data.
         */
        HostToken( const KURL& url, const QString& name );

        /**
         * The url of the host from the config has been read.
         */
        KURL url() const;

        /**
         * Returns the parsed configs from this host.
         */
        QPtrList<ApplicationToken> applications();
        ApplicationToken* application( const KURL& url );

        void addApp( ApplicationToken* );
        void removeApp( const QString& name );

    private:
        KURL m_url;
        QPtrList<ApplicationToken> m_tokens;
    };
}

#endif
