#ifndef __KMTRACE_LEAKS_FIND_HH__
#define __KMTRACE_LEAKS_FIND_HH__

// Qt includes
#include <qwidget.h>
#include <qstring.h>
#include <qbutton.h>
#include <qvbuttongroup.h>
#include <qcheckbox.h>

// KDE includes
#include <kdialogbase.h>
#include <kcombobox.h>

/**
 * A dialog letting the user search for memory leaks matching
 * either the function, source file or library name. The memory leaks found
 * are then expanded in the @ref KMtraceLeaksView and the hit is marked
 * in the function call stack.
 * 
 * This dialog is normally shown in non-modal mode, so the user can
 * have view on all the data of the memory leak.
 *
 * This code has been copied from kdectl2.cpp (class KEdFind in the kdelib
 * package) and has been extended to search memory leaks instead of plain
 * text.
 *
 * @short The dialog letting the user search for specific memory leaks
 * @author Andreas Baumann <andreas_baumann@users.sourceforge.net>
 * @see KMtraceLeaksViewItem, KMtraceLeak
 * @version $ProjectMajorVersion: 0 $
 */
class KMtraceLeaksFindDialog : public KDialogBase
{
    Q_OBJECT
    Q_PROPERTY( int type READ getType WRITE setType )
    Q_PROPERTY( QString text READ getText WRITE setText )
    Q_PROPERTY( bool caseSensitivity READ case_sensitive WRITE setCaseSensitive )
public:

    KMtraceLeaksFindDialog( QWidget *parent = 0, const char *name=0, bool modal=true);
    ~KMtraceLeaksFindDialog();

    int getType() const;
    void setType(int index);
    QString getText() const;
    void setText(QString string);
    void setCaseSensitive( bool b );
    bool case_sensitive() const;

    /**
     * @returns the combobox containing the history of searches. Can be used
     * to save and restore the history.
     */
    KHistoryCombo *searchCombo() const;

protected slots:
    void slotCancel( void );
    void slotUser1( void );
    void textSearchChanged ( const QString & );

protected:
    QVButtonGroup* group;

private:
    QCheckBox *sensitive;

    virtual void done(int i ) { KDialogBase::done(i); }

signals:

    void search();
    void done();
protected:
    virtual void virtual_hook( int id, void* data );
private:
    class KMtraceLeaksFindPrivate;
    KMtraceLeaksFindPrivate *d;
};

#endif
