/***************************************************************************
                          dockwidget.cpp  -  description
                             -------------------
    begin                : Fri Nov 14 2000
    copyright            : (C) 2000 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dockwidget.h"

#include <kapp.h>
#include <kdatetbl.h>
#include <klineeditdlg.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kpopupmenu.h>
#include <ksystemtray.h>

#include <qcursor.h>
#include <qclipboard.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qtextview.h>

/*************************************************
 * create dockwidget with popup-menu             *
 *************************************************/
dockwidget::dockwidget(QWidget *, const char * name) : KSystemTray(0, name)
{
  mypop = new KPopupFrame(this);						/* create Popup-window */
  mypop->setFrameStyle(QFrame::Box | QFrame::Plain);	/* we don't need decorations */
  mypop->setLineWidth(2); 								/* black frame */
  myview = new QTextView(mypop);						/* QTextView as display */
  myview->setFrameStyle(QFrame::NoFrame);				/* no decorations */

  popup_menu = new KPopupMenu(this);					/* popup menu */
//   popup_menu->setTitle("KSteak");
//   popup_menu->insertItem(SmallIcon("window_new"), i18n("Input Dialog"), MENU_DIALOG_ID);
//   popup_menu->insertSeparator();
//   popup_menu->insertItem(SmallIcon("window_fullscreen"), i18n("Undock"), MENU_UNDOCK_ID);
//   popup_menu->insertItem(SmallIcon("viewmag"), i18n("Toggle Watching"), MENU_WATCH_ID);
//   popup_menu->insertItem(SmallIcon("configure"), i18n("Configure KSteak"), MENU_CONFIG_ID);
//   popup_menu->insertSeparator();
//   popup_menu->insertItem(SmallIcon("exit"), i18n("Quit"), MENU_EXIT_ID);
  connect(popup_menu, SIGNAL(activated(int)), this, SLOT(slotMenuClicked(int)));
}

/*************************************************
 * destructor                                    *
 *************************************************/
dockwidget::~dockwidget()
{
  delete popup_menu;
  delete mypop;
  delete myview;
}

/**************************************************
 * exec popup menu + history                      *
 **************************************************/
void dockwidget::execPopup(void)
{
  int i;

  //disconnect(popup_menu, 0, this, 0);
  popup_menu->clear();
  popup_menu->setTitle("KSteak");

  QStringList::Iterator lit = strHistory.begin();
  for ( i=1; ((lit != strHistory.end()) & (i < 6)); ++lit )
	if (! (*lit).isEmpty())
	{
    	if ( (*lit).length() > 35 )
        	popup_menu->insertItem( (*lit).left(35)+"...", i );
        else
			popup_menu->insertItem( (*lit), i );
		i++;
	}
  popup_menu->insertSeparator();
  popup_menu->insertItem(SmallIcon("window_new"), i18n("Quick Search"), MENU_DIALOG_ID);
  popup_menu->insertSeparator();
  popup_menu->insertItem(SmallIcon("window_fullscreen"), i18n("Undock"), MENU_UNDOCK_ID);
  popup_menu->insertItem(SmallIcon("viewmag"), i18n("Toggle Watching"), MENU_WATCH_ID);
  popup_menu->insertItem(SmallIcon("configure"), i18n("Configure KSteak"), MENU_CONFIG_ID);
  popup_menu->insertSeparator();
  popup_menu->insertItem(SmallIcon("exit"), i18n("Quit"), MENU_EXIT_ID);
  // connect(popup_menu, SIGNAL(activated(int)), this, SLOT(slotMenuClicked(int)));
   popup_menu->exec(QCursor::pos());
}

/*************************************************
 * exec popup-menu on mousepressevent            *
 *************************************************/
void dockwidget::mousePressEvent(QMouseEvent* e)
{
  if (e->button() == RightButton) execPopup();	/* popup menu */
  if (e->button() == MidButton) emit toggleWatchCb();				/* toogle watching cb */
  if (e->button() == LeftButton)									/* translate */
  {
  	if (myview->hasSelectedText())
  		getTranslation( myview->selectedText() );
	else
		getTranslation( kapp->clipboard()->text() );
  }
}

/*************************************************
 * emit signals when (un-)dock                   *
 *************************************************/
void dockwidget::slotMenuClicked(int i)
{
  switch (i)
  {
  	case MENU_EXIT_ID:    	disconnect(popup_menu, 0, this, 0); // dont call other functions
				emit done();
				break;
  	case MENU_UNDOCK_ID:  	emit undock();
				break;
  	case MENU_WATCH_ID:   	emit toggleWatchCb();
				break;
  	case MENU_CONFIG_ID:  	emit configure();
				break;
  	case MENU_DIALOG_ID:   	quickDialog();
				break;
  	default: 		translate(i);
				break;
  }
}

void dockwidget::translate(int n)
{
  int i;

  QStringList::Iterator lit = strHistory.begin();

  for ( i=1; ((lit != strHistory.end()) & (i != n)); ++lit )
  {
  	i=i+1;
  }
  getTranslation(*lit);
}

void dockwidget::quickDialog(void)
{
	QString search;
    bool result;

	search = KLineEditDlg::getText(i18n("Look for:"), "", &result, this);
    if ( result==true )
    getTranslation( search );
}


/*************************************************
 * get and show translations                     *
 *************************************************/
void dockwidget::getTranslation(const QString & szWord)
{
	int x, y;

	if (_fPopup)		/* popup at systray */
	{
		QPoint mpos = mapToGlobal(QPoint(this->x(), this->y()));
		x = mpos.x();
		y = mpos.y();
	}
	else				/* popup at cursor */
	{
		x = QCursor::pos().x();
		y = QCursor::pos().y();
	}
	/* get translation (engine) */
	emit translate( szWord );
	/* set size */
	int w = myview->width();
	int h = myview->height();
	/* clever placement */
	if (x-w < 1) w = 0;
	if (y-h < 1) h = 0;
	/* show popup window */
	mypop->resize(myview->width()+3, myview->height()+3); // fit to size of myview
	mypop->setMainWidget( myview );
	//mypop->popup( QPoint(x-w, y-h) );	//killed by ESC
	mypop->exec( QPoint(x-w, y-h) );
}
