/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.PathResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.ETag;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.TreeSet;
import org.jboss.logging.Logger;

public class PathResourceManager
implements ResourceManager {
    private static final Logger log = Logger.getLogger((String)PathResourceManager.class.getName());
    private static final boolean DEFAULT_CHANGE_LISTENERS_ALLOWED = !Boolean.getBoolean("io.undertow.disable-file-system-watcher");
    private static final long DEFAULT_TRANSFER_MIN_SIZE = 1024L;
    private static final ETagFunction NULL_ETAG_FUNCTION = new ETagFunction(){

        @Override
        public ETag generate(Path path) {
            return null;
        }
    };
    protected volatile String base;
    private final long transferMinSize;
    private final boolean caseSensitive;
    private final boolean followLinks;
    private final TreeSet<String> safePaths = new TreeSet();
    private final ETagFunction eTagFunction;
    private final boolean allowResourceChangeListeners;

    public PathResourceManager(Path base) {
        this(base, 1024L, true, false, null);
    }

    public PathResourceManager(Path base, long transferMinSize) {
        this(base, transferMinSize, true, false, null);
    }

    public PathResourceManager(Path base, long transferMinSize, boolean caseSensitive) {
        this(base, transferMinSize, caseSensitive, false, null);
    }

    public PathResourceManager(Path base, long transferMinSize, boolean followLinks, String ... safePaths) {
        this(base, transferMinSize, true, followLinks, safePaths);
    }

    protected PathResourceManager(long transferMinSize, boolean caseSensitive, boolean followLinks, String ... safePaths) {
        this(transferMinSize, caseSensitive, followLinks, DEFAULT_CHANGE_LISTENERS_ALLOWED, safePaths);
    }

    protected PathResourceManager(long transferMinSize, boolean caseSensitive, boolean followLinks, boolean allowResourceChangeListeners, String ... safePaths) {
        this.caseSensitive = caseSensitive;
        this.followLinks = followLinks;
        this.transferMinSize = transferMinSize;
        this.allowResourceChangeListeners = allowResourceChangeListeners;
        if (this.followLinks) {
            if (safePaths == null) {
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("safePaths");
            }
            for (String safePath : safePaths) {
                if (safePath != null) continue;
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("safePaths");
            }
            this.safePaths.addAll(Arrays.asList(safePaths));
        }
        this.eTagFunction = NULL_ETAG_FUNCTION;
    }

    public PathResourceManager(Path base, long transferMinSize, boolean caseSensitive, boolean followLinks, String ... safePaths) {
        this(base, transferMinSize, caseSensitive, followLinks, DEFAULT_CHANGE_LISTENERS_ALLOWED, safePaths);
    }

    public PathResourceManager(Path base, long transferMinSize, boolean caseSensitive, boolean followLinks, boolean allowResourceChangeListeners, String ... safePaths) {
        this(PathResourceManager.builder().setBase(base).setTransferMinSize(transferMinSize).setCaseSensitive(caseSensitive).setFollowLinks(followLinks).setAllowResourceChangeListeners(allowResourceChangeListeners).setSafePaths(safePaths));
    }

    private PathResourceManager(Builder builder) {
        this.allowResourceChangeListeners = builder.allowResourceChangeListeners;
        if (builder.base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        String basePath = builder.base.normalize().toAbsolutePath().toString();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separatorChar;
        }
        this.base = basePath;
        this.transferMinSize = builder.transferMinSize;
        this.caseSensitive = builder.caseSensitive;
        this.followLinks = builder.followLinks;
        if (this.followLinks) {
            if (builder.safePaths == null) {
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("safePaths");
            }
            for (String safePath : builder.safePaths) {
                if (safePath != null) continue;
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("safePaths");
            }
            this.safePaths.addAll(Arrays.asList(builder.safePaths));
        }
        this.eTagFunction = builder.eTagFunction;
    }

    public Path getBasePath() {
        return Paths.get(this.base, new String[0]);
    }

    public PathResourceManager setBase(Path base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        String basePath = base.toAbsolutePath().toString();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separatorChar;
        }
        this.base = basePath;
        return this;
    }

    public PathResourceManager setBase(File base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        String basePath = base.getAbsolutePath();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separatorChar;
        }
        this.base = basePath;
        return this;
    }

    @Override
    public Resource getResource(String p) {
        String path = p.startsWith("/") ? p.substring(1) : p;
        try {
            Path file = Paths.get(this.base, path);
            String normalizedFile = file.normalize().toString();
            if (!normalizedFile.startsWith(this.base)) {
                if (normalizedFile.length() == this.base.length() - 1) {
                    if (!this.base.startsWith(normalizedFile)) {
                        log.tracef("Failed to get path resource %s from path resource manager with base %s, as file was outside the base directory", (Object)p, (Object)this.base);
                        return null;
                    }
                } else {
                    log.tracef("Failed to get path resource %s from path resource manager with base %s, as file was outside the base directory", (Object)p, (Object)this.base);
                    return null;
                }
            }
            if (Files.exists(file, new LinkOption[0])) {
                if (path.endsWith("/") && !Files.isDirectory(file, new LinkOption[0])) {
                    log.tracef("Failed to get path resource %s from path resource manager with base %s, as path ended with a / but was not a directory", (Object)p, (Object)this.base);
                    return null;
                }
                boolean followAll = this.followLinks && this.safePaths.isEmpty();
                SymlinkResult symlinkBase = this.getSymlinkBase(this.base, file);
                if (!followAll && symlinkBase != null && symlinkBase.requiresCheck) {
                    if (this.followLinks && this.isSymlinkSafe(file)) {
                        return this.getFileResource(file, path, symlinkBase.path, normalizedFile);
                    }
                    log.tracef("Failed to get path resource %s from path resource manager with base %s, as it was not a safe symlink path", (Object)p, (Object)this.base);
                    return null;
                }
                return this.getFileResource(file, path, symlinkBase == null ? null : symlinkBase.path, normalizedFile);
            }
            log.tracef("Failed to get path resource %s from path resource manager with base %s, as the path did not exist", (Object)p, (Object)this.base);
            return null;
        }
        catch (Exception e) {
            UndertowLogger.REQUEST_LOGGER.debugf(e, "Invalid path %s", p);
            return null;
        }
    }

    public long getTransferMinSize() {
        return this.transferMinSize;
    }

    @Override
    public synchronized void close() throws IOException {
    }

    private SymlinkResult getSymlinkBase(String base, Path file) throws IOException {
        int nameCount = file.getNameCount();
        Path root = Paths.get(base, new String[0]);
        int rootCount = root.getNameCount();
        Path f = file;
        for (int i = nameCount - 1; i >= 0; --i) {
            if (Files.isSymbolicLink(f)) {
                return new SymlinkResult(i + 1 > rootCount, f);
            }
            f = f.getParent();
        }
        return null;
    }

    private boolean isFileSameCase(Path file, String normalizeFile) throws IOException {
        String canonicalName = file.toRealPath(new LinkOption[0]).toString();
        return canonicalName.equals(normalizeFile);
    }

    private boolean isSymlinkSafe(Path file) throws IOException {
        String canonicalPath = file.toRealPath(new LinkOption[0]).toString();
        for (String safePath : this.safePaths) {
            String absSafePath;
            Path absSafePathFile;
            String canonicalSafePath;
            if (safePath.length() <= 0 || !(safePath.charAt(0) == File.separatorChar ? safePath.length() > 0 && canonicalPath.length() >= safePath.length() && canonicalPath.startsWith(safePath) : (canonicalSafePath = (absSafePathFile = Paths.get(absSafePath = this.base + File.separatorChar + safePath, new String[0])).toRealPath(new LinkOption[0]).toString()).length() > 0 && canonicalPath.length() >= canonicalSafePath.length() && canonicalPath.startsWith(canonicalSafePath))) continue;
            return true;
        }
        return false;
    }

    protected PathResource getFileResource(Path file, String path, Path symlinkBase, String normalizedFile) throws IOException {
        if (this.caseSensitive) {
            if (symlinkBase != null) {
                String symlinkBaseResolved;
                String relative = symlinkBase.relativize(file.normalize()).toString();
                String fileResolved = file.toRealPath(new LinkOption[0]).toString();
                if (!fileResolved.startsWith(symlinkBaseResolved = symlinkBase.toRealPath(new LinkOption[0]).toString())) {
                    log.tracef("Rejected path resource %s from path resource manager with base %s, as the case did not match actual case of %s", (Object)path, (Object)this.base, (Object)normalizedFile);
                    return null;
                }
                String compare = fileResolved.substring(symlinkBaseResolved.length());
                if (compare.startsWith(File.separator)) {
                    compare = compare.substring(1);
                }
                if (relative.startsWith(File.separator)) {
                    relative = relative.substring(1);
                }
                if (relative.equals(compare)) {
                    log.tracef("Found path resource %s from path resource manager with base %s", (Object)path, (Object)this.base);
                    return new PathResource(file, this, path, this.eTagFunction.generate(file));
                }
                log.tracef("Rejected path resource %s from path resource manager with base %s, as the case did not match actual case of %s", (Object)path, (Object)this.base, (Object)normalizedFile);
                return null;
            }
            if (this.isFileSameCase(file, normalizedFile)) {
                log.tracef("Found path resource %s from path resource manager with base %s", (Object)path, (Object)this.base);
                return new PathResource(file, this, path, this.eTagFunction.generate(file));
            }
            log.tracef("Rejected path resource %s from path resource manager with base %s, as the case did not match actual case of %s", (Object)path, (Object)this.base, (Object)normalizedFile);
            return null;
        }
        log.tracef("Found path resource %s from path resource manager with base %s", (Object)path, (Object)this.base);
        return new PathResource(file, this, path, this.eTagFunction.generate(file));
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ boolean access$900() {
        return DEFAULT_CHANGE_LISTENERS_ALLOWED;
    }

    static /* synthetic */ ETagFunction access$1000() {
        return NULL_ETAG_FUNCTION;
    }

    public static final class Builder {
        private Path base;
        private long transferMinSize = 1024L;
        private boolean caseSensitive = true;
        private boolean followLinks = false;
        private boolean allowResourceChangeListeners = PathResourceManager.access$900();
        private ETagFunction eTagFunction = PathResourceManager.access$1000();
        private String[] safePaths;

        private Builder() {
        }

        public Builder setBase(Path base) {
            this.base = base;
            return this;
        }

        public Builder setTransferMinSize(long transferMinSize) {
            this.transferMinSize = transferMinSize;
            return this;
        }

        public Builder setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public Builder setFollowLinks(boolean followLinks) {
            this.followLinks = followLinks;
            return this;
        }

        public Builder setAllowResourceChangeListeners(boolean allowResourceChangeListeners) {
            this.allowResourceChangeListeners = allowResourceChangeListeners;
            return this;
        }

        public Builder setETagFunction(ETagFunction eTagFunction) {
            this.eTagFunction = eTagFunction;
            return this;
        }

        public Builder setSafePaths(String[] safePaths) {
            this.safePaths = safePaths;
            return this;
        }

        public ResourceManager build() {
            return new PathResourceManager(this);
        }
    }

    public static interface ETagFunction {
        public ETag generate(Path var1);
    }

    private static class SymlinkResult {
        public final boolean requiresCheck;
        public final Path path;

        private SymlinkResult(boolean requiresCheck, Path path) {
            this.requiresCheck = requiresCheck;
            this.path = path;
        }
    }
}

