/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.code.decoders;

import jadx.api.plugins.input.data.ICallSite;
import jadx.api.plugins.input.data.IMethodProto;
import jadx.api.plugins.input.data.IMethodRef;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.insns.Opcode;
import jadx.api.plugins.input.insns.custom.ICustomPayload;
import jadx.plugins.input.java.data.DataReader;
import jadx.plugins.input.java.data.code.CodeDecodeState;
import jadx.plugins.input.java.data.code.JavaInsnData;
import jadx.plugins.input.java.data.code.decoders.IJavaInsnDecoder;

public class InvokeDecoder
implements IJavaInsnDecoder {
    private final int payloadSize;
    private final Opcode apiOpcode;

    public InvokeDecoder(int payloadSize, Opcode apiOpcode) {
        this.payloadSize = payloadSize;
        this.apiOpcode = apiOpcode;
    }

    @Override
    public void decode(CodeDecodeState state) {
        boolean instanceCall;
        IMethodRef mthProto;
        DataReader reader = state.reader();
        int mthIdx = reader.readS2();
        if (this.payloadSize == 4) {
            reader.skip(2);
        }
        JavaInsnData insn = state.insn();
        insn.setIndex(mthIdx);
        if (this.apiOpcode == Opcode.INVOKE_CUSTOM) {
            ICallSite callSite = insn.getIndexAsCallSite();
            insn.setPayload((ICustomPayload)callSite);
            mthProto = (IMethodProto)((EncodedValue)callSite.getValues().get(2)).getValue();
            instanceCall = false;
        } else {
            IMethodRef mthRef = insn.getIndexAsMethod();
            mthRef.load();
            insn.setPayload((ICustomPayload)mthRef);
            mthProto = mthRef;
            instanceCall = this.apiOpcode != Opcode.INVOKE_STATIC;
        }
        int argsCount = mthProto.getArgTypes().size();
        if (instanceCall) {
            ++argsCount;
        }
        insn.setRegsCount(argsCount * 2);
        int[] regs = insn.getRegsArray();
        int regsCount = 0;
        if (instanceCall) {
            regs[regsCount++] = 1;
        }
        for (String type : mthProto.getArgTypes()) {
            int size = this.getRegsCountForType(type);
            regs[regsCount++] = 1;
            if (size != 2) continue;
            regs[regsCount++] = 0;
        }
        insn.setRegsCount(regsCount);
        for (int i = regsCount - 1; i >= 0; --i) {
            if (regs[i] != 1) continue;
            state.pop(i);
        }
        String returnType = mthProto.getReturnType();
        if (!returnType.equals("V")) {
            insn.setResultReg(state.push(returnType));
        } else {
            insn.setResultReg(-1);
        }
    }

    private int getRegsCountForType(String type) {
        char c = type.charAt(0);
        if (c == 'J' || c == 'D') {
            return 2;
        }
        return 1;
    }
}

