/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.concurrent.Future;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;

public final class DownloadNotesInViewAction
extends JosmAction {
    private DownloadNotesInViewAction(String iconName) {
        super(I18n.tr("Download notes in current view", new Object[0]), iconName, I18n.tr("Download notes in current view", new Object[0]), null, false, "dialogs/notes/download_in_view", true);
    }

    public static DownloadNotesInViewAction newActionWithNoteIcon() {
        return new DownloadNotesInViewAction("dialogs/notes/note_open");
    }

    public static DownloadNotesInViewAction newActionWithDownloadIcon() {
        return new DownloadNotesInViewAction("download");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Bounds bounds = MainApplication.getMap().mapView.getRealBounds();
        DownloadNotesTask task = new DownloadNotesTask();
        task.setZoomAfterDownload(false);
        Future<?> future = task.download(new DownloadParams(), bounds, null);
        MainApplication.worker.submit(new PostDownloadHandler(task, future));
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getActiveLayer() != null && !NetworkManager.isOffline(OnlineResource.OSM_API));
    }
}

