/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.dissect.fields;

import java.util.Map;
import org.logstash.Event;
import org.logstash.dissect.Delimiter;
import org.logstash.dissect.ValueResolver;
import org.logstash.dissect.fields.AbstractField;
import org.logstash.dissect.fields.Field;

public final class IndirectField
extends AbstractField {
    private IndirectField(int id, String name, String suffix, Delimiter previous, Delimiter next) {
        super(id, name, suffix, 1000, previous, next);
    }

    public static Field create(int id, String name, String suffix, Delimiter previous, Delimiter next) {
        return new IndirectField(id, name, suffix, previous, next);
    }

    @Override
    public boolean saveable() {
        return true;
    }

    @Override
    public void append(Map<String, Object> keyValueMap, ValueResolver values) {
        String indirectName = this.anyValue(this.name(), keyValueMap, values);
        if (!indirectName.isEmpty()) {
            keyValueMap.put(indirectName, values.get(this.id()));
        }
    }

    @Override
    public void append(Event event, ValueResolver values) {
        String indirectName = this.anyValue(this.name(), event, values);
        if (!indirectName.isEmpty()) {
            event.setField(indirectName, (Object)values.get(this.id()));
        }
    }

    private String anyValue(String key, Event event, ValueResolver values) {
        if (event.includes(key)) {
            Object val = event.getField(key);
            return String.valueOf(val);
        }
        return values.getOtherByName(key, this.id());
    }

    private String anyValue(String key, Map<String, Object> map, ValueResolver values) {
        if (map.containsKey(key)) {
            Object val = map.get(key);
            return String.valueOf(val);
        }
        return values.getOtherByName(key, this.id());
    }

    public String toString() {
        return this.buildToString(this.getClass().getName());
    }
}

