/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientFactory;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.rules.ErrorAction;
import io.confluent.kafka.schemaregistry.rules.NoneAction;
import io.confluent.kafka.schemaregistry.rules.RuleAction;
import io.confluent.kafka.schemaregistry.rules.RuleBase;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.confluent.kafka.schemaregistry.rules.RuleExecutor;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDeConfig;
import io.confluent.kafka.serializers.context.NullContextNameStrategy;
import io.confluent.kafka.serializers.context.strategy.ContextNameStrategy;
import io.confluent.kafka.serializers.subject.SubjectNameStrategy;
import io.confluent.kafka.serializers.subject.TopicNameStrategy;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKafkaSchemaSerDe
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AbstractKafkaSchemaSerDe.class);
    protected static final byte MAGIC_BYTE = 0;
    protected static final int idSize = 4;
    protected static final int DEFAULT_CACHE_CAPACITY = 1000;
    protected SchemaRegistryClient schemaRegistry;
    protected Ticker ticker = Ticker.systemTicker();
    protected ContextNameStrategy contextNameStrategy = new NullContextNameStrategy();
    protected Object keySubjectNameStrategy = new TopicNameStrategy();
    protected Object valueSubjectNameStrategy = new TopicNameStrategy();
    protected Cache<SubjectSchema, ParsedSchema> latestVersions;
    protected Cache<String, ParsedSchema> latestWithMetadata;
    protected boolean useSchemaReflection;
    protected boolean useLatestVersion;
    protected Map<String, String> metadata;
    protected Map<String, Map<String, RuleBase>> ruleExecutors;
    protected Map<String, Map<String, RuleBase>> ruleActions;
    protected boolean isKey;
    private static final ErrorAction ERROR_ACTION = new ErrorAction();
    private static final NoneAction NONE_ACTION = new NoneAction();
    private static final ThreadLocal<Object> key = new ThreadLocal();

    public static Object key() {
        return key.get();
    }

    public static void setKey(Object obj) {
        key.set(obj);
    }

    public static void clearKey() {
        key.remove();
    }

    protected Ticker ticker(SchemaRegistryClient client) {
        return client != null ? client.ticker() : Ticker.systemTicker();
    }

    protected void configureClientProperties(AbstractKafkaSchemaSerDeConfig config, SchemaProvider provider) {
        if (this.schemaRegistry == null) {
            List<String> urls = config.getSchemaRegistryUrls();
            int maxSchemaObject = config.getMaxSchemasPerSubject();
            Map originals = config.originalsWithPrefix("");
            this.schemaRegistry = SchemaRegistryClientFactory.newClient(urls, (int)maxSchemaObject, Collections.singletonList(provider), (Map)originals, config.requestHeaders());
        }
        this.contextNameStrategy = config.contextNameStrategy();
        this.keySubjectNameStrategy = config.keySubjectNameStrategy();
        this.valueSubjectNameStrategy = config.valueSubjectNameStrategy();
        this.useSchemaReflection = config.useSchemaReflection();
        this.useLatestVersion = config.useLatestVersion();
        int latestCacheSize = config.getLatestCacheSize();
        int latestCacheTtl = config.getLatestCacheTtl();
        CacheBuilder latestVersionsBuilder = CacheBuilder.newBuilder().maximumSize((long)latestCacheSize).ticker(this.ticker);
        if (latestCacheTtl >= 0) {
            latestVersionsBuilder = latestVersionsBuilder.expireAfterWrite((long)latestCacheTtl, TimeUnit.SECONDS);
        }
        this.latestVersions = latestVersionsBuilder.build();
        CacheBuilder latestWithMetadataBuilder = CacheBuilder.newBuilder().maximumSize((long)latestCacheSize).ticker(this.ticker);
        if (latestCacheTtl >= 0) {
            latestWithMetadataBuilder = latestWithMetadataBuilder.expireAfterWrite((long)latestCacheTtl, TimeUnit.SECONDS);
        }
        this.latestWithMetadata = latestWithMetadataBuilder.build();
        if (config.getLatestWithMetadataSpec() != null) {
            MapPropertyParser parser = new MapPropertyParser();
            this.metadata = parser.parse(config.getLatestWithMetadataSpec());
        }
        this.ruleExecutors = this.initRuleObjects(config, "rule.executors");
        this.ruleActions = this.initRuleObjects(config, "rule.actions");
    }

    protected void postOp(Object payload) {
        if (this.isKey) {
            AbstractKafkaSchemaSerDe.setKey(payload);
        } else {
            AbstractKafkaSchemaSerDe.clearKey();
        }
    }

    private Map<String, Map<String, RuleBase>> initRuleObjects(AbstractKafkaSchemaSerDeConfig config, String configName) {
        List names = config.getList(configName);
        return names.stream().flatMap(n -> this.initRuleObject((String)n, config, configName).map(r -> new AbstractMap.SimpleEntry<String, RuleBase>((String)n, (RuleBase)r))).collect(Collectors.groupingBy(e -> ((RuleBase)e.getValue()).type(), Collectors.toMap(AbstractMap.SimpleEntry::getKey, e -> {
            log.info("Registering rule object {} for {}: {}", new Object[]{e.getKey(), ((RuleBase)e.getValue()).type(), ((RuleBase)e.getValue()).getClass().getName()});
            return (RuleBase)e.getValue();
        }, (e1, e2) -> e1, LinkedHashMap::new)));
    }

    private Stream<RuleBase> initRuleObject(String name, AbstractKafkaSchemaSerDeConfig config, String configName) {
        String propertyName = configName + "." + name + ".class";
        Object propertyValue = config.originals().get(propertyName);
        if (propertyValue == null) {
            return Stream.empty();
        }
        String className = propertyValue.toString();
        String prefix = configName + "." + name + ".param.";
        Map params = config.originalsWithPrefix(prefix);
        try {
            RuleBase ruleObject = (RuleBase)Utils.newInstance((String)className, RuleBase.class);
            ruleObject.configure(params);
            return Stream.of(ruleObject);
        }
        catch (ClassNotFoundException e) {
            log.error("Could not load rule object class " + name, (Throwable)e);
            throw new ConfigException("Could not load rule object class " + name);
        }
    }

    public Map<String, Map<String, RuleBase>> getRuleExecutors() {
        return this.ruleExecutors;
    }

    private RuleExecutor getRuleExecutor(RuleContext ctx) {
        return (RuleExecutor)this.getRuleObject(ctx, this.ruleExecutors, ctx.rule().getType());
    }

    private RuleAction getRuleAction(RuleContext ctx, String actionName) {
        if (actionName.equals("ERROR")) {
            return ERROR_ACTION;
        }
        if (actionName.equals("NONE")) {
            return NONE_ACTION;
        }
        return (RuleAction)this.getRuleObject(ctx, this.ruleActions, actionName);
    }

    private RuleBase getRuleObject(RuleContext ctx, Map<String, Map<String, RuleBase>> ruleBases, String type) {
        Rule rule = ctx.rule();
        Map<String, RuleBase> ruleObjects = ruleBases.get(type.toUpperCase(Locale.ROOT));
        if (ruleObjects != null && !ruleObjects.isEmpty()) {
            RuleBase ruleObject = ruleObjects.get(ctx.subject() + ":" + rule.getName());
            if (ruleObject != null) {
                return ruleObject;
            }
            ruleObject = ruleObjects.get(rule.getName());
            if (ruleObject != null) {
                return ruleObject;
            }
            return ruleObjects.entrySet().iterator().next().getValue();
        }
        return null;
    }

    public boolean isKey() {
        return this.isKey;
    }

    protected Map<SubjectSchema, ParsedSchema> latestVersionsCache() {
        return this.latestVersions != null ? this.latestVersions.asMap() : new HashMap();
    }

    protected Map<String, ParsedSchema> latestWithMetadataCache() {
        return this.latestWithMetadata != null ? this.latestWithMetadata.asMap() : new HashMap();
    }

    protected ParsedSchema getLatestWithMetadata(String subject) throws IOException, RestClientException {
        if (this.metadata == null || this.metadata.isEmpty()) {
            return null;
        }
        ParsedSchema schema = (ParsedSchema)this.latestWithMetadata.getIfPresent((Object)subject);
        if (schema == null) {
            SchemaMetadata schemaMetadata = this.schemaRegistry.getLatestWithMetadata(subject, this.metadata, true);
            Optional optSchema = this.schemaRegistry.parseSchema(new io.confluent.kafka.schemaregistry.client.rest.entities.Schema(null, schemaMetadata));
            schema = (ParsedSchema)optSchema.orElseThrow(() -> new IOException("Invalid schema " + schemaMetadata.getSchema() + " with refs " + schemaMetadata.getReferences() + " of type " + schemaMetadata.getSchemaType()));
            schema = schema.copy(Integer.valueOf(schemaMetadata.getVersion()));
            this.latestWithMetadata.put((Object)subject, (Object)schema);
        }
        return schema;
    }

    private ParsedSchema getSchemaMetadata(String subject, int version) throws IOException, RestClientException {
        SchemaMetadata schemaMetadata = this.schemaRegistry.getSchemaMetadata(subject, version, true);
        Optional optSchema = this.schemaRegistry.parseSchema(new io.confluent.kafka.schemaregistry.client.rest.entities.Schema(null, schemaMetadata));
        ParsedSchema schema = (ParsedSchema)optSchema.orElseThrow(() -> new IOException("Invalid schema " + schemaMetadata.getSchema() + " with refs " + schemaMetadata.getReferences() + " of type " + schemaMetadata.getSchemaType()));
        return schema.copy(Integer.valueOf(schemaMetadata.getVersion()));
    }

    protected List<Migration> getMigrations(String subject, ParsedSchema writerSchema, ParsedSchema readerSchema) throws IOException, RestClientException {
        ParsedSchema last;
        ParsedSchema first;
        RuleMode migrationMode = null;
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        if (writerSchema.version() < readerSchema.version()) {
            migrationMode = RuleMode.UPGRADE;
            first = writerSchema;
            last = readerSchema;
        } else if (writerSchema.version() > readerSchema.version()) {
            migrationMode = RuleMode.DOWNGRADE;
            first = readerSchema;
            last = writerSchema;
        } else {
            return migrations;
        }
        List<ParsedSchema> versions = this.getSchemasBetween(subject, first, last);
        ParsedSchema previous = null;
        for (int i = 0; i < versions.size(); ++i) {
            ParsedSchema current = versions.get(i);
            if (i == 0) {
                previous = current;
                continue;
            }
            if (current.ruleSet() != null && current.ruleSet().hasRules(migrationMode)) {
                Migration m = migrationMode == RuleMode.UPGRADE ? new Migration(migrationMode, previous, current) : new Migration(migrationMode, current, previous);
                migrations.add(m);
            }
            previous = current;
        }
        if (migrationMode == RuleMode.DOWNGRADE) {
            Collections.reverse(migrations);
        }
        return migrations;
    }

    private List<ParsedSchema> getSchemasBetween(String subject, ParsedSchema first, ParsedSchema last) throws IOException, RestClientException {
        if (last.version() - first.version() <= 1) {
            return ImmutableList.of((Object)first, (Object)last);
        }
        int version1 = first.version();
        int version2 = last.version();
        ArrayList<ParsedSchema> schemas = new ArrayList<ParsedSchema>();
        for (int i = version1 + 1; i < version2; ++i) {
            schemas.add(this.getSchemaMetadata(subject, i));
        }
        ArrayList<ParsedSchema> result = new ArrayList<ParsedSchema>();
        result.add(first);
        result.addAll(schemas);
        result.add(last);
        return result;
    }

    protected String getSubjectName(String topic, boolean isKey, Object value, ParsedSchema schema) {
        Object subjectNameStrategy = this.subjectNameStrategy(isKey);
        String subject = subjectNameStrategy instanceof io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy ? ((io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy)subjectNameStrategy).subjectName(topic, isKey, schema) : ((SubjectNameStrategy)subjectNameStrategy).getSubjectName(topic, isKey, value);
        return this.getContextName(topic, subject);
    }

    protected String getContextName(String topic) {
        return this.getContextName(topic, null);
    }

    protected String getContextName(String topic, String subject) {
        String contextName = this.contextNameStrategy.contextName(topic);
        if (contextName != null) {
            contextName = QualifiedSubject.normalizeContext((String)contextName);
            return subject != null ? contextName + subject : contextName;
        }
        return subject;
    }

    protected boolean strategyUsesSchema(boolean isKey) {
        Object subjectNameStrategy = this.subjectNameStrategy(isKey);
        if (subjectNameStrategy instanceof io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy) {
            return ((io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy)subjectNameStrategy).usesSchema();
        }
        return false;
    }

    protected boolean isDeprecatedSubjectNameStrategy(boolean isKey) {
        Object subjectNameStrategy = this.subjectNameStrategy(isKey);
        return !(subjectNameStrategy instanceof io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy);
    }

    private Object subjectNameStrategy(boolean isKey) {
        return isKey ? this.keySubjectNameStrategy : this.valueSubjectNameStrategy;
    }

    protected String getOldSubjectName(Object value) {
        if (value instanceof GenericContainer) {
            return ((GenericContainer)value).getSchema().getName() + "-value";
        }
        throw new SerializationException("Primitive types are not supported yet");
    }

    @Deprecated
    public int register(String subject, Schema schema) throws IOException, RestClientException {
        return this.schemaRegistry.register(subject, schema);
    }

    public int register(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.schemaRegistry.register(subject, schema);
    }

    public int register(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.schemaRegistry.register(subject, schema, normalize);
    }

    @Deprecated
    public Schema getById(int id) throws IOException, RestClientException {
        return this.schemaRegistry.getById(id);
    }

    public ParsedSchema getSchemaById(int id) throws IOException, RestClientException {
        return this.schemaRegistry.getSchemaById(id);
    }

    @Deprecated
    public Schema getBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        return this.schemaRegistry.getBySubjectAndId(subject, id);
    }

    public ParsedSchema getSchemaBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        return this.schemaRegistry.getSchemaBySubjectAndId(subject, id);
    }

    protected ParsedSchema lookupSchemaBySubjectAndId(String subject, int id, ParsedSchema schema, boolean idCompatStrict) throws IOException, RestClientException {
        ParsedSchema lookupSchema = this.getSchemaBySubjectAndId(subject, id);
        if (idCompatStrict && !lookupSchema.isBackwardCompatible(schema).isEmpty()) {
            throw new IOException("Incompatible schema " + lookupSchema.canonicalString() + " with refs " + lookupSchema.references() + " of type " + lookupSchema.schemaType() + " for schema " + schema.canonicalString() + ". Set id.compatibility.strict=false to disable this check");
        }
        return lookupSchema;
    }

    protected ParsedSchema lookupLatestVersion(String subject, ParsedSchema schema, boolean latestCompatStrict) throws IOException, RestClientException {
        return AbstractKafkaSchemaSerDe.lookupLatestVersion(this.schemaRegistry, subject, schema, this.latestVersionsCache(), latestCompatStrict);
    }

    protected static ParsedSchema lookupLatestVersion(SchemaRegistryClient schemaRegistry, String subject, ParsedSchema schema, Map<SubjectSchema, ParsedSchema> cache, boolean latestCompatStrict) throws IOException, RestClientException {
        SubjectSchema ss = new SubjectSchema(subject, schema);
        ParsedSchema latestVersion = null;
        if (cache != null) {
            latestVersion = cache.get(ss);
        }
        if (latestVersion == null) {
            SchemaMetadata schemaMetadata = schemaRegistry.getLatestSchemaMetadata(subject);
            Optional optSchema = schemaRegistry.parseSchema(new io.confluent.kafka.schemaregistry.client.rest.entities.Schema(null, schemaMetadata));
            latestVersion = (ParsedSchema)optSchema.orElseThrow(() -> new IOException("Invalid schema " + schemaMetadata.getSchema() + " with refs " + schemaMetadata.getReferences() + " of type " + schemaMetadata.getSchemaType()));
            latestVersion = latestVersion.copy(Integer.valueOf(schemaMetadata.getVersion()));
            if (latestCompatStrict && !latestVersion.isBackwardCompatible(schema).isEmpty()) {
                throw new IOException("Incompatible schema " + schemaMetadata.getSchema() + " with refs " + schemaMetadata.getReferences() + " of type " + schemaMetadata.getSchemaType() + " for schema " + schema.canonicalString() + ". Set latest.compatibility.strict=false to disable this check");
            }
            if (cache != null) {
                cache.put(ss, latestVersion);
            }
        }
        return latestVersion;
    }

    protected ByteBuffer getByteBuffer(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        if (buffer.get() != 0) {
            throw new SerializationException("Unknown magic byte!");
        }
        return buffer;
    }

    protected Object executeMigrations(List<Migration> migrations, String subject, String topic, Headers headers, Object message) throws IOException {
        for (int i = 0; i < migrations.size(); ++i) {
            Migration m = migrations.get(i);
            if (i == 0) {
                message = m.getSource().toJson(message);
            }
            message = this.executeRules(subject, topic, headers, m.getRuleMode(), m.getSource(), m.getTarget(), message);
        }
        return message;
    }

    protected Object executeRules(String subject, String topic, Headers headers, RuleMode ruleMode, ParsedSchema source, ParsedSchema target, Object message) {
        return this.executeRules(subject, topic, headers, message, ruleMode, source, target, message);
    }

    protected Object executeRules(String subject, String topic, Headers headers, Object original, RuleMode ruleMode, ParsedSchema source, ParsedSchema target, Object message) {
        if (message == null || target == null) {
            return message;
        }
        ArrayList rules = Collections.emptyList();
        if (ruleMode == RuleMode.UPGRADE) {
            if (target.ruleSet() != null) {
                rules = target.ruleSet().getMigrationRules();
            }
        } else if (ruleMode == RuleMode.DOWNGRADE) {
            if (source.ruleSet() != null) {
                rules = new ArrayList(source.ruleSet().getMigrationRules());
                Collections.reverse(rules);
            }
        } else if (target.ruleSet() != null) {
            rules = target.ruleSet().getDomainRules();
            if (ruleMode == RuleMode.READ) {
                rules = new ArrayList(rules);
                Collections.reverse(rules);
            }
        }
        for (int i = 0; i < rules.size(); ++i) {
            RuleContext ctx;
            RuleExecutor ruleExecutor;
            Rule rule = (Rule)rules.get(i);
            if (rule.isDisabled()) continue;
            if (rule.getMode() == RuleMode.WRITEREAD) {
                if (ruleMode != RuleMode.READ && ruleMode != RuleMode.WRITE) {
                    continue;
                }
            } else if (rule.getMode() != RuleMode.UPDOWN ? ruleMode != rule.getMode() : ruleMode != RuleMode.UPGRADE && ruleMode != RuleMode.DOWNGRADE) continue;
            if ((ruleExecutor = this.getRuleExecutor(ctx = new RuleContext(source, target, subject, topic, headers, this.isKey ? original : AbstractKafkaSchemaSerDe.key(), this.isKey ? null : original, this.isKey, ruleMode, rule, i, rules))) != null) {
                try {
                    message = ruleExecutor.transform(ctx, message);
                    this.runAction(ctx, ruleMode, rule, message != null ? rule.getOnSuccess() : rule.getOnFailure(), message, null, message != null ? null : "ERROR");
                }
                catch (RuleException e) {
                    this.runAction(ctx, ruleMode, rule, rule.getOnFailure(), message, e, "ERROR");
                }
                continue;
            }
            this.runAction(ctx, ruleMode, rule, rule.getOnFailure(), message, new RuleException("Could not find rule executor of type " + rule.getType()), "ERROR");
        }
        return message;
    }

    private void runAction(RuleContext ctx, RuleMode ruleMode, Rule rule, String action, Object message, RuleException ex, String defaultAction) {
        String actionName = this.getRuleActionName(rule, ruleMode, action);
        if (actionName == null) {
            actionName = defaultAction;
        }
        if (actionName != null) {
            RuleAction ruleAction = this.getRuleAction(ctx, actionName);
            try {
                ruleAction.run(ctx, message, ex);
            }
            catch (RuleException e) {
                log.error("Could not run post-rule action " + action, (Throwable)e);
            }
        }
    }

    private String getRuleActionName(Rule rule, RuleMode ruleMode, String actionName) {
        if ((rule.getMode() == RuleMode.WRITEREAD || rule.getMode() == RuleMode.UPDOWN) && actionName != null && actionName.contains(",")) {
            String[] parts = actionName.split(",");
            switch (ruleMode) {
                case WRITE: 
                case UPGRADE: {
                    return parts[0];
                }
                case READ: 
                case DOWNGRADE: {
                    return parts[1];
                }
            }
            throw new IllegalStateException("Unsupported rule mode " + ruleMode);
        }
        return actionName;
    }

    @Override
    public void close() {
        this.closeRuleObjects(this.ruleActions);
        this.closeRuleObjects(this.ruleExecutors);
    }

    private void closeRuleObjects(Map<String, Map<String, RuleBase>> ruleBases) {
        if (ruleBases != null) {
            for (Map.Entry<String, Map<String, RuleBase>> outer : ruleBases.entrySet()) {
                for (Map.Entry<String, RuleBase> inner : outer.getValue().entrySet()) {
                    AbstractKafkaSchemaSerDe.closeQuietly((AutoCloseable)inner.getValue(), "rule object " + inner.getKey() + " for " + outer.getKey());
                }
            }
        }
    }

    private static void closeQuietly(AutoCloseable closeable, String name) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                log.error("Failed to close {} with type {}", new Object[]{name, closeable.getClass().getName(), t});
            }
        }
    }

    protected static KafkaException toKafkaException(RestClientException e, String errorMessage) {
        if (e.getErrorCode() / 100 == 4) {
            return new InvalidConfigurationException(e.getMessage());
        }
        return new SerializationException(errorMessage, (Throwable)e);
    }

    static class MapPropertyParser {
        private final ListPropertyParser parser = new ListPropertyParser();

        public Map<String, String> parse(String str) {
            List<String> strings = this.parser.parse(str);
            return strings.stream().collect(Collectors.toMap(s -> s.substring(0, s.indexOf(61)), s -> s.substring(s.indexOf(61) + 1)));
        }

        public String asString(Map<String, String> map) {
            List<String> entries = map.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.toList());
            return this.parser.asString(entries);
        }
    }

    static class ListPropertyParser {
        private static final char DELIM_CHAR = ',';
        private static final char QUOTE_CHAR = '\'';
        private final CsvMapper mapper = new CsvMapper().enable(CsvGenerator.Feature.STRICT_CHECK_FOR_QUOTING).enable(CsvParser.Feature.WRAP_AS_ARRAY);
        private final CsvSchema schema = CsvSchema.builder().setColumnSeparator(',').setQuoteChar('\'').setLineSeparator("").build();

        public List<String> parse(String str) {
            try {
                ObjectReader reader = this.mapper.readerFor(String[].class).with((FormatSchema)this.schema);
                MappingIterator iter = reader.readValues(str);
                String[] strings = iter.hasNext() ? (String[])iter.next() : new String[]{};
                return Arrays.asList(strings);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not parse string " + str, e);
            }
        }

        public String asString(List<String> list) {
            try {
                String[] array = list.toArray(new String[0]);
                ObjectWriter writer = this.mapper.writerFor(Object[].class).with((FormatSchema)this.schema);
                return writer.writeValueAsString((Object)array);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Could not parse list " + list, e);
            }
        }
    }

    protected static class Migration {
        private final RuleMode ruleMode;
        private final ParsedSchema source;
        private final ParsedSchema target;

        public Migration(RuleMode ruleMode, ParsedSchema source, ParsedSchema target) {
            this.ruleMode = ruleMode;
            this.source = source;
            this.target = target;
        }

        public RuleMode getRuleMode() {
            return this.ruleMode;
        }

        public ParsedSchema getSource() {
            return this.source;
        }

        public ParsedSchema getTarget() {
            return this.target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Migration migration = (Migration)o;
            return this.ruleMode == migration.ruleMode && Objects.equals(this.source, migration.source) && Objects.equals(this.target, migration.target);
        }

        public int hashCode() {
            return Objects.hash(this.ruleMode, this.source, this.target);
        }
    }

    protected static class SubjectSchema {
        private final String subject;
        private final ParsedSchema schema;

        public SubjectSchema(String subject, ParsedSchema schema) {
            this.subject = subject;
            this.schema = schema;
        }

        public String getSubject() {
            return this.subject;
        }

        public ParsedSchema getSchema() {
            return this.schema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubjectSchema that = (SubjectSchema)o;
            return this.subject.equals(that.subject) && this.schema.equals(that.schema);
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.schema);
        }
    }
}

