/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ingest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.logstash.ingest.IngestConverter;

public class IngestGrok {
    public static String toLogstash(String json, boolean appendStdio) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        HashMap<String, Object> jsonDefinition = mapper.readValue(json, typeRef);
        List processors = (List)jsonDefinition.get("processors");
        List<String> filters_pipeline = processors.stream().map(IngestGrok::mapProcessor).collect(Collectors.toList());
        return IngestConverter.filtersToFile(IngestConverter.appendIoPlugins(filters_pipeline, appendStdio));
    }

    private static String mapProcessor(Map processor) {
        return IngestConverter.filterHash(IngestConverter.createHash("grok", IngestGrok.grokHash(processor)));
    }

    static String grokHash(Map<String, Map> processor) {
        Map grok_data = processor.get("grok");
        String grok_contents = IngestGrok.createHashField("match", IngestConverter.createField(IngestConverter.quoteString((String)grok_data.get("field")), IngestConverter.createPatternArrayOrField(((List)grok_data.get("patterns")).toArray(new String[0]))));
        if (grok_data.containsKey("pattern_definitions")) {
            grok_contents = IngestConverter.joinHashFields(grok_contents, IngestGrok.createPatternDefinitionHash((Map)grok_data.get("pattern_definitions")));
        }
        return grok_contents;
    }

    private static String createHashField(String name, String content) {
        return IngestConverter.createField(name, IngestConverter.wrapInCurly(content));
    }

    private static String createPatternDefinitionHash(Map<String, String> definitions) {
        ArrayList<String> content = new ArrayList<String>();
        for (Map.Entry<String, String> entry : definitions.entrySet()) {
            content.add(IngestConverter.createField(IngestConverter.quoteString(entry.getKey()), IngestConverter.quoteString(entry.getValue())));
        }
        String patternDefs = content.stream().map(IngestConverter::dotsToSquareBrackets).collect(Collectors.joining("\n"));
        return IngestGrok.createHashField("pattern_definitions", patternDefs);
    }

    public static boolean has_grok(Map<String, Object> processor) {
        return processor.containsKey(IngestGrok.get_name());
    }

    public static String get_name() {
        return "grok";
    }
}

