/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.joni.exception.JOniException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.parser.ReOptions;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.MarshalEncoding;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RegexpSupport;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.WeakValuedMap;
import org.jruby.util.io.EncodingUtils;

@JRubyClass(name={"Regexp"})
public class RubyRegexp
extends RubyObject
implements ReOptions,
EncodingCapable,
MarshalEncoding {
    Regex pattern;
    private ByteList str = ByteList.EMPTY_BYTELIST;
    private RegexpOptions options;
    private static final ThreadLocal<IRubyObject[]> TL_HOLDER = ThreadLocal.withInitial(() -> new IRubyObject[1]);
    public static final int ARG_ENCODING_FIXED = 16;
    public static final int ARG_ENCODING_NONE = 32;
    static final WeakValuedMap<ByteList, Regex> patternCache = new WeakValuedMap();
    static final WeakValuedMap<ByteList, Regex> quotedPatternCache = new WeakValuedMap();
    static final WeakValuedMap<ByteList, Regex> preprocessedPatternCache = new WeakValuedMap();
    private static final int QUOTED_V = 11;
    private static final int EMBEDDABLE = 7;

    public void setLiteral() {
        this.setFrozen(true);
        this.options.setLiteral(true);
    }

    public void clearLiteral() {
        this.options.setLiteral(false);
    }

    public boolean isLiteral() {
        return this.options.isLiteral();
    }

    public boolean isKCodeDefault() {
        return this.options.isKcodeDefault();
    }

    public void setEncodingNone() {
        this.options.setEncodingNone(true);
    }

    public void clearEncodingNone() {
        this.options.setEncodingNone(false);
    }

    public boolean isEncodingNone() {
        return this.options.isEncodingNone();
    }

    public KCode getKCode() {
        return this.options.getKCode();
    }

    @Override
    public Encoding getEncoding() {
        return this.pattern.getEncoding();
    }

    @Override
    public void setEncoding(Encoding encoding2) {
    }

    @Override
    public boolean shouldMarshalEncoding() {
        return this.getEncoding() != ASCIIEncoding.INSTANCE;
    }

    @Override
    public Encoding getMarshalEncoding() {
        return this.getEncoding();
    }

    private static Regex makeRegexp(Ruby runtime2, ByteList bytes2, RegexpOptions options2, Encoding enc) {
        try {
            int p2 = bytes2.getBegin();
            return new Regex(bytes2.getUnsafeBytes(), p2, p2 + bytes2.getRealSize(), options2.toJoniOptions(), enc, Syntax.DEFAULT, runtime2.getRegexpWarnings());
        }
        catch (Exception e) {
            RegexpSupport.raiseRegexpError19(runtime2, bytes2, enc, options2, e.getMessage());
            return null;
        }
    }

    public static Regex getRegexpFromCache(Ruby runtime2, ByteList bytes2, Encoding enc, RegexpOptions options2) {
        Regex regex = patternCache.get(bytes2);
        if (regex != null && regex.getEncoding() == enc && regex.getOptions() == options2.toJoniOptions()) {
            return regex;
        }
        regex = RubyRegexp.makeRegexp(runtime2, bytes2, options2, enc);
        regex.setUserObject(bytes2);
        patternCache.put(bytes2, regex);
        return regex;
    }

    static Regex getQuotedRegexpFromCache(Ruby runtime2, RubyString str, RegexpOptions options2) {
        Encoding enc;
        ByteList bytes2 = str.getByteList();
        Regex regex = quotedPatternCache.get(bytes2);
        Encoding encoding2 = enc = str.isAsciiOnly() ? USASCIIEncoding.INSTANCE : bytes2.getEncoding();
        if (regex != null && regex.getEncoding() == enc && regex.getOptions() == options2.toJoniOptions()) {
            return regex;
        }
        ByteList quoted = RubyRegexp.quote(str);
        regex = RubyRegexp.makeRegexp(runtime2, quoted, options2, quoted.getEncoding());
        regex.setUserObject(quoted);
        quotedPatternCache.put(bytes2, regex);
        return regex;
    }

    private static Regex getPreprocessedRegexpFromCache(Ruby runtime2, ByteList bytes2, Encoding enc, RegexpOptions options2, RegexpSupport.ErrorMode mode2) {
        Regex regex = preprocessedPatternCache.get(bytes2);
        if (regex != null && regex.getEncoding() == enc && regex.getOptions() == options2.toJoniOptions()) {
            return regex;
        }
        ByteList preprocessed = RegexpSupport.preprocess(runtime2, bytes2, enc, new Encoding[]{null}, RegexpSupport.ErrorMode.RAISE);
        regex = RubyRegexp.makeRegexp(runtime2, preprocessed, options2, enc);
        regex.setUserObject(preprocessed);
        preprocessedPatternCache.put(bytes2, regex);
        return regex;
    }

    public static RubyClass createRegexpClass(Ruby runtime2) {
        RubyClass regexpClass = runtime2.defineClass("Regexp", runtime2.getObject(), RubyRegexp::new);
        regexpClass.setClassIndex(ClassIndex.REGEXP);
        regexpClass.setReifiedClass(RubyRegexp.class);
        regexpClass.kindOf = new RubyModule.JavaClassKindOf(RubyRegexp.class);
        regexpClass.defineConstant("IGNORECASE", runtime2.newFixnum(1));
        regexpClass.defineConstant("EXTENDED", runtime2.newFixnum(2));
        regexpClass.defineConstant("MULTILINE", runtime2.newFixnum(4));
        regexpClass.defineConstant("FIXEDENCODING", runtime2.newFixnum(16));
        regexpClass.defineConstant("NOENCODING", runtime2.newFixnum(32));
        regexpClass.defineAnnotatedMethods(RubyRegexp.class);
        regexpClass.getSingletonClass().defineAlias("compile", "new");
        return regexpClass;
    }

    public static int matcherSearch(ThreadContext context, Matcher matcher, int start2, int range, int option) {
        if (!context.runtime.getInstanceConfig().isInterruptibleRegexps()) {
            return matcher.search(start2, range, option);
        }
        try {
            return context.getThread().executeRegexp(context, matcher, start2, range, option, Matcher::searchInterruptible);
        }
        catch (InterruptedException e) {
            throw context.runtime.newInterruptedRegexpError("Regexp Interrupted");
        }
    }

    public static int matcherMatch(ThreadContext context, Matcher matcher, int start2, int range, int option) {
        if (!context.runtime.getInstanceConfig().isInterruptibleRegexps()) {
            return matcher.match(start2, range, option);
        }
        try {
            return context.getThread().executeRegexp(context, matcher, start2, range, option, Matcher::matchInterruptible);
        }
        catch (InterruptedException e) {
            throw context.runtime.newInterruptedRegexpError("Regexp Interrupted");
        }
    }

    @Deprecated
    public static int matcherSearch(Ruby runtime2, Matcher matcher, int start2, int range, int option) {
        return RubyRegexp.matcherSearch(runtime2.getCurrentContext(), matcher, start2, range, option);
    }

    @Deprecated
    public static int matcherMatch(Ruby runtime2, Matcher matcher, int start2, int range, int option) {
        return RubyRegexp.matcherMatch(runtime2.getCurrentContext(), matcher, start2, range, option);
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.REGEXP;
    }

    private RubyRegexp(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.options = new RegexpOptions();
    }

    RubyRegexp(Ruby runtime2) {
        super(runtime2, runtime2.getRegexp());
        this.options = new RegexpOptions();
    }

    public RubyRegexp(Ruby runtime2, Regex pattern, ByteList str, RegexpOptions options2) {
        super(runtime2, runtime2.getRegexp());
        this.pattern = pattern;
        this.str = str;
        this.options = options2;
    }

    private RubyRegexp(Ruby runtime2, ByteList str) {
        this(runtime2);
        assert (str != null);
        this.str = str;
        this.pattern = RubyRegexp.getRegexpFromCache(runtime2, str, str.getEncoding(), RegexpOptions.NULL_OPTIONS);
    }

    private RubyRegexp(Ruby runtime2, ByteList str, RegexpOptions options2) {
        this(runtime2);
        assert (str != null);
        this.regexpInitialize(str, str.getEncoding(), options2);
    }

    public static RubyRegexp newRegexp(Ruby runtime2, String pattern, RegexpOptions options2) {
        return RubyRegexp.newRegexp(runtime2, ByteList.create(pattern), options2);
    }

    public static RubyRegexp newRegexp(Ruby runtime2, ByteList pattern, int options2) {
        return RubyRegexp.newRegexp(runtime2, pattern, RegexpOptions.fromEmbeddedOptions(options2));
    }

    public static RubyRegexp newRegexp(Ruby runtime2, ByteList pattern, RegexpOptions options2) {
        try {
            return new RubyRegexp(runtime2, pattern, options2.clone());
        }
        catch (RaiseException re) {
            throw runtime2.newSyntaxError(re.getMessage());
        }
    }

    public static RubyRegexp newRegexpParser(Ruby runtime2, ByteList pattern, RegexpOptions options2) {
        return new RubyRegexp(runtime2, pattern, options2.clone());
    }

    public static RubyRegexp newDRegexp(Ruby runtime2, RubyString pattern, RegexpOptions options2) {
        try {
            return new RubyRegexp(runtime2, pattern.getByteList(), options2.clone());
        }
        catch (RaiseException re) {
            throw runtime2.newRegexpError(re.getMessage());
        }
    }

    public static RubyRegexp newDRegexp(Ruby runtime2, RubyString pattern, int joniOptions) {
        try {
            RegexpOptions options2 = RegexpOptions.fromJoniOptions(joniOptions);
            return new RubyRegexp(runtime2, pattern.getByteList(), options2);
        }
        catch (RaiseException re) {
            throw runtime2.newRegexpError(re.getMessage());
        }
    }

    public static RubyRegexp newRegexp(Ruby runtime2, ByteList pattern) {
        return new RubyRegexp(runtime2, pattern);
    }

    static RubyRegexp newRegexp(Ruby runtime2, ByteList str, Regex pattern) {
        RubyRegexp regexp2 = new RubyRegexp(runtime2);
        assert (str != null);
        regexp2.str = str;
        regexp2.options = RegexpOptions.fromJoniOptions(pattern.getOptions());
        regexp2.pattern = pattern;
        return regexp2;
    }

    static RubyRegexp newDummyRegexp(Ruby runtime2, Regex regex) {
        RubyRegexp regexp2 = new RubyRegexp(runtime2);
        regexp2.pattern = regex;
        regexp2.str = ByteList.EMPTY_BYTELIST;
        regexp2.options.setFixed(true);
        return regexp2;
    }

    public static RubyRegexp newRegexpFromStr(Ruby runtime2, RubyString s2, int options2) {
        RubyRegexp re = (RubyRegexp)runtime2.getRegexp().allocate();
        re.regexpInitializeString(s2, RegexpOptions.fromJoniOptions(options2));
        return re;
    }

    public final RegexpOptions getOptions() {
        this.check();
        return this.options;
    }

    public final Regex getPattern() {
        this.check();
        return this.pattern;
    }

    private static void encodingMatchError(Ruby runtime2, Regex pattern, Encoding strEnc) {
        throw runtime2.newEncodingCompatibilityError("incompatible encoding regexp match (" + pattern.getEncoding() + " regexp with " + strEnc + " string)");
    }

    private Encoding prepareEncoding(RubyString str, boolean warn2) {
        Encoding enc = str.getEncoding();
        int cr = str.scanForCodeRange();
        if (cr == 48) {
            throw this.getRuntime().newArgumentError("invalid byte sequence in " + enc);
        }
        this.check();
        Encoding patternEnc = this.pattern.getEncoding();
        if (patternEnc != enc) {
            if (cr == 16 && patternEnc == USASCIIEncoding.INSTANCE) {
                enc = patternEnc;
            } else if (!enc.isAsciiCompatible()) {
                RubyRegexp.encodingMatchError(this.getRuntime(), this.pattern, enc);
            } else if (this.options.isFixed()) {
                if (!(enc == patternEnc || patternEnc.isAsciiCompatible() && cr == 16)) {
                    RubyRegexp.encodingMatchError(this.getRuntime(), this.pattern, enc);
                }
                enc = patternEnc;
            }
        }
        if (warn2 && this.isEncodingNone() && enc != ASCIIEncoding.INSTANCE && cr != 16) {
            this.metaClass.runtime.getWarnings().warn(IRubyWarnings.ID.REGEXP_MATCH_AGAINST_STRING, "historical binary regexp match /.../n against " + enc + " string");
        }
        return enc;
    }

    public final Regex preparePattern(RubyString str) {
        Encoding enc = this.prepareEncoding(str, true);
        if (enc == this.pattern.getEncoding()) {
            return this.pattern;
        }
        return RubyRegexp.getPreprocessedRegexpFromCache(this.metaClass.runtime, this.str, enc, this.options, RegexpSupport.ErrorMode.PREPROCESS);
    }

    private static void preprocessLight(Ruby runtime2, ByteList str, Encoding enc, Encoding[] fixedEnc, RegexpSupport.ErrorMode mode2) {
        fixedEnc[0] = enc.isAsciiCompatible() ? null : enc;
        boolean hasProperty = RegexpSupport.unescapeNonAscii(runtime2, null, str.getUnsafeBytes(), str.getBegin(), str.getBegin() + str.getRealSize(), enc, fixedEnc, str, mode2);
        if (hasProperty && fixedEnc[0] == null) {
            fixedEnc[0] = enc;
        }
    }

    public static void preprocessCheck(Ruby runtime2, ByteList bytes2) {
        RegexpSupport.preprocess(runtime2, bytes2, bytes2.getEncoding(), new Encoding[]{null}, RegexpSupport.ErrorMode.RAISE);
    }

    @Deprecated
    public static RubyString preprocessDRegexp(Ruby runtime2, RubyString[] strings, int embeddedOptions) {
        return RubyRegexp.preprocessDRegexp(runtime2, (IRubyObject[])strings, RegexpOptions.fromEmbeddedOptions(embeddedOptions));
    }

    public static RubyString preprocessDRegexp(Ruby runtime2, IRubyObject[] strings, RegexpOptions options2) {
        return RubyRegexp.preprocessDRegexp(runtime2.getCurrentContext(), options2, strings);
    }

    public static RubyString preprocessDRegexp(ThreadContext context, RegexpOptions options2, IRubyObject ... args2) {
        RubyString string2 = null;
        Encoding regexpEnc = null;
        for (int i2 = 0; i2 < args2.length; ++i2) {
            RubyString str = args2[i2].convertToString();
            regexpEnc = RubyRegexp.processDRegexpElement(context.runtime, options2, regexpEnc, context.encodingHolder(), str);
            string2 = string2 == null ? (RubyString)str.dup() : string2.append19(str);
        }
        if (regexpEnc != null) {
            string2.setEncoding(regexpEnc);
        }
        return string2;
    }

    public static RubyString preprocessDRegexp(ThreadContext context, RegexpOptions options2, IRubyObject arg0) {
        return RubyRegexp.processElementIntoResult(context.runtime, null, arg0, options2, null, context.encodingHolder());
    }

    @Deprecated
    public static RubyString preprocessDRegexp(Ruby runtime2, IRubyObject arg0, RegexpOptions options2) {
        return RubyRegexp.processElementIntoResult(runtime2, null, arg0, options2, null, runtime2.getCurrentContext().encodingHolder());
    }

    public static RubyString preprocessDRegexp(ThreadContext context, RegexpOptions options2, IRubyObject arg0, IRubyObject arg1) {
        return RubyRegexp.processElementIntoResult(context.runtime, null, arg0, arg1, options2, null, context.encodingHolder());
    }

    @Deprecated
    public static RubyString preprocessDRegexp(Ruby runtime2, IRubyObject arg0, IRubyObject arg1, RegexpOptions options2) {
        return RubyRegexp.processElementIntoResult(runtime2, null, arg0, arg1, options2, null, runtime2.getCurrentContext().encodingHolder());
    }

    public static RubyString preprocessDRegexp(ThreadContext context, RegexpOptions options2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RubyRegexp.processElementIntoResult(context.runtime, null, arg0, arg1, arg2, options2, null, context.encodingHolder());
    }

    @Deprecated
    public static RubyString preprocessDRegexp(Ruby runtime2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, RegexpOptions options2) {
        return RubyRegexp.processElementIntoResult(runtime2, null, arg0, arg1, arg2, options2, null, runtime2.getCurrentContext().encodingHolder());
    }

    @Deprecated
    public static RubyString preprocessDRegexp(Ruby runtime2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, RegexpOptions options2) {
        return RubyRegexp.processElementIntoResult(runtime2, null, arg0, arg1, arg2, arg3, options2, null, runtime2.getCurrentContext().encodingHolder());
    }

    @Deprecated
    public static RubyString preprocessDRegexp(Ruby runtime2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, RegexpOptions options2) {
        return RubyRegexp.processElementIntoResult(runtime2, null, arg0, arg1, arg2, arg3, arg4, options2, null, runtime2.getCurrentContext().encodingHolder());
    }

    private static RubyString processElementIntoResult(Ruby runtime2, RubyString result2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, RegexpOptions options2, Encoding regexpEnc, Encoding[] fixedEnc) {
        RubyString str = arg0.convertToString();
        regexpEnc = RubyRegexp.processDRegexpElement(runtime2, options2, regexpEnc, fixedEnc, str);
        return RubyRegexp.processElementIntoResult(runtime2, result2 == null ? str.strDup(runtime2) : result2.append19(str), arg1, arg2, arg3, arg4, options2, regexpEnc, fixedEnc);
    }

    private static RubyString processElementIntoResult(Ruby runtime2, RubyString result2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, RegexpOptions options2, Encoding regexpEnc, Encoding[] fixedEnc) {
        RubyString str = arg0.convertToString();
        regexpEnc = RubyRegexp.processDRegexpElement(runtime2, options2, regexpEnc, fixedEnc, str);
        return RubyRegexp.processElementIntoResult(runtime2, result2 == null ? str.strDup(runtime2) : result2.append19(str), arg1, arg2, arg3, options2, regexpEnc, fixedEnc);
    }

    private static RubyString processElementIntoResult(Ruby runtime2, RubyString result2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, RegexpOptions options2, Encoding regexpEnc, Encoding[] fixedEnc) {
        RubyString str = arg0.convertToString();
        regexpEnc = RubyRegexp.processDRegexpElement(runtime2, options2, regexpEnc, fixedEnc, str);
        return RubyRegexp.processElementIntoResult(runtime2, result2 == null ? str.strDup(runtime2) : result2.append19(str), arg1, arg2, options2, regexpEnc, fixedEnc);
    }

    private static RubyString processElementIntoResult(Ruby runtime2, RubyString result2, IRubyObject arg0, IRubyObject arg1, RegexpOptions options2, Encoding regexpEnc, Encoding[] fixedEnc) {
        RubyString str = arg0.convertToString();
        regexpEnc = RubyRegexp.processDRegexpElement(runtime2, options2, regexpEnc, fixedEnc, str);
        return RubyRegexp.processElementIntoResult(runtime2, result2 == null ? str.strDup(runtime2) : result2.append19(str), arg1, options2, regexpEnc, fixedEnc);
    }

    private static RubyString processElementIntoResult(Ruby runtime2, RubyString result2, IRubyObject arg0, RegexpOptions options2, Encoding regexpEnc, Encoding[] fixedEnc) {
        RubyString str = arg0.convertToString();
        regexpEnc = RubyRegexp.processDRegexpElement(runtime2, options2, regexpEnc, fixedEnc, str);
        RubyString rubyString = result2 = result2 == null ? str.strDup(runtime2) : result2.append19(str);
        if (regexpEnc != null) {
            result2.setEncoding(regexpEnc);
        }
        return result2;
    }

    private static Encoding processDRegexpElement(Ruby runtime2, RegexpOptions options2, Encoding regexpEnc, Encoding[] fixedEnc, RubyString str) {
        Encoding strEnc = str.getEncoding();
        if (options2.isEncodingNone() && strEnc != ASCIIEncoding.INSTANCE) {
            if (str.scanForCodeRange() != 16) {
                throw runtime2.newRegexpError("/.../n has a non escaped non ASCII character in non ASCII-8BIT script");
            }
            strEnc = ASCIIEncoding.INSTANCE;
        }
        RubyRegexp.preprocessLight(runtime2, str.getByteList(), strEnc, fixedEnc, RegexpSupport.ErrorMode.PREPROCESS);
        if (fixedEnc[0] != null) {
            if (regexpEnc != null && regexpEnc != fixedEnc[0]) {
                throw runtime2.newRegexpError("encoding mismatch in dynamic regexp: " + new String(regexpEnc.getName()) + " and " + new String(fixedEnc[0].getName()));
            }
            regexpEnc = fixedEnc[0];
        }
        return regexpEnc;
    }

    private void check() {
        if (this.pattern == null) {
            throw this.metaClass.runtime.newTypeError("uninitialized Regexp");
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject recv2, IRubyObject args2) {
        return TypeConverter.convertToTypeWithCheck(args2, context.runtime.getRegexp(), "to_regexp");
    }

    @JRubyMethod(name={"quote", "escape"}, meta=true)
    public static RubyString quote(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RubyString str = RubyRegexp.operandCheck(arg2);
        return RubyString.newStringShared(context.runtime, RubyRegexp.quote(str));
    }

    @Deprecated
    public static IRubyObject quote19(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyRegexp.quote(context, recv2, arg2);
    }

    static ByteList quote(RubyString str) {
        ByteList bytes2 = str.getByteList();
        ByteList qBytes = RubyRegexp.quote(bytes2, str.isAsciiOnly());
        if (qBytes == bytes2) {
            str.setByteListShared();
        }
        return qBytes;
    }

    static ByteList quote(ByteList bs, boolean asciiOnly) {
        Encoding enc;
        byte[] bytes2;
        int end2;
        int p2;
        block23: {
            p2 = bs.getBegin();
            end2 = p2 + bs.getRealSize();
            bytes2 = bs.getUnsafeBytes();
            enc = bs.getEncoding();
            while (p2 < end2) {
                int c;
                int cl;
                if (enc.isAsciiCompatible()) {
                    cl = 1;
                    c = bytes2[p2] & 0xFF;
                } else {
                    cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                    if (cl < 0) {
                        p2 += StringSupport.length(enc, bytes2, p2, end2);
                        continue;
                    }
                    c = enc.mbcToCode(bytes2, p2, end2);
                }
                if (!Encoding.isAscii(c)) {
                    p2 += StringSupport.length(enc, bytes2, p2, end2);
                    continue;
                }
                switch (c) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 45: 
                    case 46: 
                    case 63: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 123: 
                    case 124: 
                    case 125: {
                        break block23;
                    }
                    default: {
                        p2 += cl;
                        break;
                    }
                }
            }
            if (asciiOnly) {
                ByteList tmp = bs.shallowDup();
                tmp.setEncoding(USASCIIEncoding.INSTANCE);
                return tmp;
            }
            return bs;
        }
        ByteList result2 = new ByteList(end2 * 2);
        result2.setEncoding(asciiOnly ? USASCIIEncoding.INSTANCE : bs.getEncoding());
        byte[] obytes = result2.getUnsafeBytes();
        int op = p2 - bs.getBegin();
        System.arraycopy(bytes2, bs.getBegin(), obytes, 0, op);
        block13: while (p2 < end2) {
            int c;
            int cl;
            if (enc.isAsciiCompatible()) {
                cl = 1;
                c = bytes2[p2] & 0xFF;
            } else {
                cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                c = enc.mbcToCode(bytes2, p2, end2);
            }
            if (!Encoding.isAscii(c)) {
                int n = StringSupport.length(enc, bytes2, p2, end2);
                while (n-- > 0) {
                    obytes[op++] = bytes2[p2++];
                }
                continue;
            }
            p2 += cl;
            switch (c) {
                case 35: 
                case 36: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 45: 
                case 46: 
                case 63: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 123: 
                case 124: 
                case 125: {
                    op += enc.codeToMbc(92, obytes, op);
                    break;
                }
                case 32: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(32, obytes, op);
                    continue block13;
                }
                case 9: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(116, obytes, op);
                    continue block13;
                }
                case 10: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(110, obytes, op);
                    continue block13;
                }
                case 13: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(114, obytes, op);
                    continue block13;
                }
                case 12: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(102, obytes, op);
                    continue block13;
                }
                case 11: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(118, obytes, op);
                    continue block13;
                }
            }
            op += enc.codeToMbc(c, obytes, op);
        }
        result2.setRealSize(op);
        return result2;
    }

    @Deprecated
    public static ByteList quote19(ByteList bs, boolean asciiOnly) {
        return RubyRegexp.quote(bs, asciiOnly);
    }

    @JRubyMethod(name={"last_match"}, meta=true, reads={FrameField.BACKREF})
    public static IRubyObject last_match_s(ThreadContext context, IRubyObject recv2) {
        return context.getBackRef();
    }

    @JRubyMethod(name={"last_match"}, meta=true, reads={FrameField.BACKREF})
    public static IRubyObject last_match_s(ThreadContext context, IRubyObject recv2, IRubyObject nth) {
        IRubyObject backref = context.getBackRef();
        if (backref instanceof RubyMatchData) {
            RubyMatchData match2 = (RubyMatchData)backref;
            return RubyRegexp.nth_match(match2.backrefNumber(context.runtime, nth), match2);
        }
        return backref;
    }

    @JRubyMethod(name={"union"}, rest=true, meta=true)
    public static IRubyObject union(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject obj;
        if (args2.length == 1 && !(obj = args2[0].checkArrayType()).isNil()) {
            RubyArray ary = (RubyArray)obj;
            IRubyObject[] tmp = new IRubyObject[ary.size()];
            ary.copyInto(tmp, 0);
            args2 = tmp;
        }
        Ruby runtime2 = context.runtime;
        if (args2.length == 0) {
            return runtime2.getRegexp().newInstance(context, runtime2.newString("(?!)"), Block.NULL_BLOCK);
        }
        if (args2.length == 1) {
            IRubyObject re = TypeConverter.convertToTypeWithCheck(args2[0], runtime2.getRegexp(), "to_regexp");
            return !re.isNil() ? re : RubyRegexp.newRegexpFromStr(runtime2, RubyRegexp.quote(context, recv2, args2[0]), 0);
        }
        boolean hasAsciiOnly = false;
        RubyString source2 = runtime2.newString();
        Encoding hasAsciiCompatFixed = null;
        Encoding hasAsciiIncompat = null;
        byte[] verticalVarBytes = new byte[]{124};
        for (int i2 = 0; i2 < args2.length; ++i2) {
            ByteList re;
            Encoding enc;
            IRubyObject v;
            IRubyObject e = args2[i2];
            if (i2 > 0) {
                source2.catAscii(verticalVarBytes, 0, 1);
            }
            if ((v = TypeConverter.convertToTypeWithCheck(e, runtime2.getRegexp(), "to_regexp")) != context.nil) {
                RubyRegexp regex = (RubyRegexp)v;
                enc = regex.getEncoding();
                if (!enc.isAsciiCompatible()) {
                    if (hasAsciiIncompat == null) {
                        hasAsciiIncompat = enc;
                    } else if (hasAsciiIncompat != enc) {
                        throw runtime2.newArgumentError("incompatible encodings: " + hasAsciiIncompat + " and " + enc);
                    }
                } else if (regex.getOptions().isFixed()) {
                    if (hasAsciiCompatFixed == null) {
                        hasAsciiCompatFixed = enc;
                    } else if (hasAsciiCompatFixed != enc) {
                        throw runtime2.newArgumentError("incompatible encodings: " + hasAsciiCompatFixed + " and " + enc);
                    }
                } else {
                    hasAsciiOnly = true;
                }
                re = regex.to_s().getByteList();
            } else {
                RubyString str = e.convertToString();
                enc = str.getEncoding();
                if (!enc.isAsciiCompatible()) {
                    if (hasAsciiIncompat == null) {
                        hasAsciiIncompat = enc;
                    } else if (hasAsciiIncompat != enc) {
                        throw runtime2.newArgumentError("incompatible encodings: " + hasAsciiIncompat + " and " + enc);
                    }
                } else if (str.isAsciiOnly()) {
                    hasAsciiOnly = true;
                } else if (hasAsciiCompatFixed == null) {
                    hasAsciiCompatFixed = enc;
                } else if (hasAsciiCompatFixed != enc) {
                    throw runtime2.newArgumentError("incompatible encodings: " + hasAsciiCompatFixed + " and " + enc);
                }
                re = RubyRegexp.quote(str);
            }
            if (hasAsciiIncompat != null) {
                if (hasAsciiOnly) {
                    throw runtime2.newArgumentError("ASCII incompatible encoding: " + hasAsciiIncompat);
                }
                if (hasAsciiCompatFixed != null) {
                    throw runtime2.newArgumentError("incompatible encodings: " + hasAsciiIncompat + " and " + hasAsciiCompatFixed);
                }
            }
            if (i2 == 0) {
                source2.setEncoding(enc);
            }
            source2.cat(re);
        }
        if (hasAsciiIncompat != null) {
            source2.setEncoding(hasAsciiIncompat);
        } else if (hasAsciiCompatFixed != null) {
            source2.setEncoding(hasAsciiCompatFixed);
        } else {
            source2.setEncoding(ASCIIEncoding.INSTANCE);
        }
        return runtime2.getRegexp().newInstance(context, source2, Block.NULL_BLOCK);
    }

    @Deprecated
    public static IRubyObject union19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyRegexp.union(context, recv2, args2);
    }

    @Override
    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject re) {
        if (this == re) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != re.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("wrong argument type");
        }
        RubyRegexp regexp2 = (RubyRegexp)re;
        regexp2.check();
        return this.regexpInitialize(regexp2.str, regexp2.str.getEncoding(), regexp2.getOptions());
    }

    private static int objectAsJoniOptions(IRubyObject arg2) {
        if (arg2 instanceof RubyFixnum) {
            return RubyNumeric.fix2int(arg2);
        }
        if (arg2.isTrue()) {
            return 1;
        }
        return 0;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_m(IRubyObject arg2) {
        if (arg2 instanceof RubyRegexp) {
            return this.initializeByRegexp((RubyRegexp)arg2);
        }
        return this.regexpInitializeString(arg2.convertToString(), new RegexpOptions());
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_m(IRubyObject arg0, IRubyObject arg1) {
        if (arg0 instanceof RubyRegexp && Options.PARSER_WARN_FLAGS_IGNORED.load().booleanValue()) {
            this.metaClass.runtime.getWarnings().warn(IRubyWarnings.ID.REGEXP_IGNORED_FLAGS, "flags ignored");
            return this.initializeByRegexp((RubyRegexp)arg0);
        }
        return this.regexpInitializeString(arg0.convertToString(), RegexpOptions.fromJoniOptions(RubyRegexp.objectAsJoniOptions(arg1)));
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_m(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (arg0 instanceof RubyRegexp && Options.PARSER_WARN_FLAGS_IGNORED.load().booleanValue()) {
            this.metaClass.runtime.getWarnings().warn(IRubyWarnings.ID.REGEXP_IGNORED_FLAGS, "flags ignored");
            return this.initializeByRegexp((RubyRegexp)arg0);
        }
        RegexpOptions newOptions = RegexpOptions.fromJoniOptions(RubyRegexp.objectAsJoniOptions(arg1));
        if (!arg2.isNil()) {
            ByteList kcodeBytes = arg2.convertToString().getByteList();
            if (kcodeBytes.getRealSize() > 0 && (kcodeBytes.get(0) == 110 || kcodeBytes.get(0) == 78)) {
                newOptions.setEncodingNone(true);
                return this.regexpInitialize(arg0.convertToString().getByteList(), ASCIIEncoding.INSTANCE, newOptions);
            }
            this.metaClass.runtime.getWarnings().warn("encoding option is ignored - " + kcodeBytes);
        }
        return this.regexpInitializeString(arg0.convertToString(), newOptions);
    }

    @Deprecated
    public IRubyObject initialize_m19(IRubyObject arg2) {
        return this.initialize_m(arg2);
    }

    @Deprecated
    public IRubyObject initialize_m19(IRubyObject arg0, IRubyObject arg1) {
        return this.initialize_m(arg0, arg1);
    }

    @Deprecated
    public IRubyObject initialize_m19(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.initialize_m(arg0, arg1, arg2);
    }

    private IRubyObject initializeByRegexp(RubyRegexp regexp2) {
        RegexpOptions newOptions = regexp2.getOptions().clone();
        newOptions.setLiteral(false);
        return this.regexpInitialize(regexp2.str, regexp2.getEncoding(), newOptions);
    }

    private RubyRegexp regexpInitializeString(RubyString str, RegexpOptions options2) {
        if (this.isLiteral()) {
            throw this.metaClass.runtime.newFrozenError(this);
        }
        ByteList bytes2 = str.getByteList();
        Encoding enc = bytes2.getEncoding();
        if (options2.isEncodingNone() && enc != ASCIIEncoding.INSTANCE) {
            if (str.scanForCodeRange() != 16) {
                RegexpSupport.raiseRegexpError19(this.metaClass.runtime, bytes2, enc, options2, "/.../n has a non escaped non ASCII character in non ASCII-8BIT script");
            }
            enc = ASCIIEncoding.INSTANCE;
        }
        return this.regexpInitialize(bytes2, enc, options2);
    }

    public final RubyRegexp regexpInitialize(ByteList bytes2, Encoding enc, RegexpOptions options2) {
        Ruby runtime2 = this.metaClass.runtime;
        this.options = options2;
        this.checkFrozen();
        if (this.pattern != null) {
            throw runtime2.newTypeError("already initialized regexp");
        }
        if (enc.isDummy()) {
            RegexpSupport.raiseRegexpError19(runtime2, bytes2, enc, options2, "can't make regexp with dummy encoding");
        }
        Encoding[] fixedEnc = new Encoding[]{null};
        ByteList unescaped = RegexpSupport.preprocess(runtime2, bytes2, enc, fixedEnc, RegexpSupport.ErrorMode.RAISE);
        if (fixedEnc[0] != null) {
            if (fixedEnc[0] != enc && options2.isFixed() || fixedEnc[0] != ASCIIEncoding.INSTANCE && options2.isEncodingNone()) {
                RegexpSupport.raiseRegexpError19(runtime2, bytes2, enc, options2, "incompatible character encoding");
            }
            if (fixedEnc[0] != ASCIIEncoding.INSTANCE) {
                options2.setFixed(true);
                enc = fixedEnc[0];
            }
        } else if (!options2.isFixed()) {
            enc = USASCIIEncoding.INSTANCE;
        }
        if (fixedEnc[0] != null) {
            options2.setFixed(true);
        }
        if (options2.isEncodingNone()) {
            this.setEncodingNone();
        }
        this.pattern = RubyRegexp.getRegexpFromCache(runtime2, unescaped, enc, options2);
        assert (bytes2 != null);
        this.str = bytes2;
        return this;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        this.check();
        int hash2 = this.pattern.getOptions();
        int len = this.str.getRealSize();
        int p2 = this.str.getBegin();
        byte[] bytes2 = this.str.getUnsafeBytes();
        while (len-- > 0) {
            hash2 = hash2 * 33 + bytes2[p2++];
        }
        return this.metaClass.runtime.newFixnum(hash2 + (hash2 >> 5));
    }

    @Override
    @JRubyMethod(name={"==", "eql?"}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.tru;
        }
        if (!(other instanceof RubyRegexp)) {
            return context.fals;
        }
        RubyRegexp otherRegex = (RubyRegexp)other;
        this.check();
        otherRegex.check();
        return RubyBoolean.newBoolean(context, this.str.equal(otherRegex.str) && this.options.equals(otherRegex.options));
    }

    @Deprecated
    public IRubyObject op_match219(ThreadContext context) {
        return this.op_match2(context);
    }

    @JRubyMethod(name={"~"}, reads={FrameField.LASTLINE}, writes={FrameField.BACKREF})
    public IRubyObject op_match2(ThreadContext context) {
        int start2;
        Ruby runtime2 = context.runtime;
        IRubyObject line = context.getLastLine();
        if (line instanceof RubyString && (start2 = this.searchString(context, (RubyString)line, 0, false)) >= 0) {
            context.updateBackref();
            return runtime2.newFixnum(start2);
        }
        context.clearBackRef();
        return context.nil;
    }

    @JRubyMethod(name={"==="}, required=1, writes={FrameField.BACKREF})
    public IRubyObject eqq(ThreadContext context, IRubyObject arg2) {
        int start2;
        if (!(arg2 = RubyRegexp.operandNoCheck(arg2)).isNil() && (start2 = this.searchString(context, (RubyString)arg2, 0, false)) >= 0) {
            context.updateBackref();
            return context.tru;
        }
        context.clearBackRef();
        return context.fals;
    }

    @Deprecated
    public IRubyObject eqq19(ThreadContext context, IRubyObject arg2) {
        return this.eqq(context, arg2);
    }

    @Override
    @JRubyMethod(name={"=~"}, required=1, writes={FrameField.BACKREF})
    public IRubyObject op_match(ThreadContext context, IRubyObject str) {
        RubyString[] strp = new RubyString[]{null};
        int pos2 = this.matchPos(context, str, strp, true, 0);
        if (pos2 < 0) {
            return context.nil;
        }
        pos2 = strp[0].subLength(pos2);
        return RubyFixnum.newFixnum(context.runtime, pos2);
    }

    @JRubyMethod(name={"match"}, writes={FrameField.BACKREF})
    public IRubyObject match_m(ThreadContext context, IRubyObject str, Block block) {
        return this.matchCommon(context, str, 0, true, block);
    }

    @JRubyMethod(name={"match"}, writes={FrameField.BACKREF})
    public IRubyObject match_m(ThreadContext context, IRubyObject str, IRubyObject pos2, Block block) {
        return this.matchCommon(context, str, RubyNumeric.num2int(pos2), true, block);
    }

    public final IRubyObject match_m(ThreadContext context, IRubyObject str, boolean useBackref) {
        return this.matchCommon(context, str, 0, useBackref, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"match?"})
    public IRubyObject match_p(ThreadContext context, IRubyObject str) {
        return this.matchP(context, str, 0);
    }

    @JRubyMethod(name={"match?"})
    public IRubyObject match_p(ThreadContext context, IRubyObject str, IRubyObject pos2) {
        return this.matchP(context, str, RubyNumeric.num2int(pos2));
    }

    private IRubyObject matchCommon(ThreadContext context, IRubyObject str, int pos2, boolean setBackref, Block block) {
        if (this.matchPos(context, str, null, setBackref, pos2) < 0) {
            return context.nil;
        }
        IRubyObject backref = context.getLocalMatchOrNil();
        if (block.isGiven()) {
            return block.yield(context, backref);
        }
        return backref;
    }

    private int matchPos(ThreadContext context, IRubyObject arg2, RubyString[] strp, boolean useBackref, int pos2) {
        if (arg2 == context.nil) {
            context.clearLocalMatch();
            if (useBackref) {
                context.updateBackref();
            }
            return -1;
        }
        RubyString str = RubyRegexp.operandCheck(arg2);
        if (strp != null) {
            strp[0] = str;
        }
        if (pos2 != 0) {
            if (pos2 < 0 && (pos2 += str.strLength()) < 0) {
                return pos2;
            }
            pos2 = str.rbStrOffset(pos2);
        }
        int result2 = this.searchString(context, str, pos2, false);
        if (useBackref) {
            context.updateBackref();
        }
        return result2;
    }

    private RubyBoolean matchP(ThreadContext context, IRubyObject arg2, int pos2) {
        if (arg2 == context.nil) {
            return context.fals;
        }
        RubyString str = arg2 instanceof RubySymbol ? ((RubySymbol)arg2).to_s(context.runtime) : arg2.convertToString();
        return this.matchP(context, str, pos2);
    }

    final RubyBoolean matchP(ThreadContext context, RubyString str, int pos2) {
        if (pos2 != 0) {
            if (pos2 < 0 && (pos2 += str.strLength()) < 0) {
                return context.fals;
            }
            pos2 = str.rbStrOffset(pos2);
        }
        Regex reg = this.preparePattern(str);
        ByteList strBL = str.getByteList();
        int beg = strBL.begin();
        Matcher matcher = reg.matcherNoRegion(strBL.unsafeBytes(), beg, beg + strBL.realSize());
        try {
            int result2 = RubyRegexp.matcherSearch(context, matcher, beg + pos2, beg + strBL.realSize(), 0);
            return result2 == -1 ? context.fals : context.tru;
        }
        catch (JOniException je) {
            throw context.runtime.newRegexpError(je.getMessage());
        }
    }

    public final int search(ThreadContext context, RubyString str, int pos2, boolean reverse2) {
        int result2 = this.searchString(context, str, pos2, reverse2);
        context.updateBackref();
        return result2;
    }

    final boolean startsWith(ThreadContext context, RubyString str) {
        ByteList strBL = str.getByteList();
        int beg = strBL.begin();
        Regex reg = this.preparePattern(str);
        Matcher matcher = reg.matcher(strBL.unsafeBytes(), beg, beg + strBL.realSize());
        try {
            int result2 = RubyRegexp.matcherMatch(context, matcher, beg, beg + strBL.realSize(), 0);
            if (result2 == -1) {
                context.setLocalMatch(null);
                context.updateBackref();
                return false;
            }
            RubyMatchData match2 = context.getLocalMatch();
            if (match2 == null || match2.used()) {
                match2 = RubyRegexp.createMatchData(context, str, matcher, reg);
            } else {
                match2.initMatchData(str, matcher, reg);
            }
            match2.regexp = this;
            context.setLocalMatch(match2);
            context.updateBackref();
            return true;
        }
        catch (JOniException je) {
            throw context.runtime.newRegexpError(je.getMessage());
        }
    }

    @Deprecated
    public final RubyBoolean startWithP(ThreadContext context, RubyString str) {
        return this.startsWith(context, str) ? context.tru : context.fals;
    }

    public final int searchString(ThreadContext context, RubyString str, int pos2, boolean reverse2) {
        int beg;
        ByteList strBL = str.getByteList();
        int range = beg = strBL.begin();
        if (pos2 > str.size() || pos2 < 0) {
            context.setLocalMatch(null);
            return -1;
        }
        Regex reg = this.preparePattern(str);
        if (!reverse2) {
            range += str.size();
        }
        Matcher matcher = reg.matcher(strBL.unsafeBytes(), beg, beg + strBL.realSize());
        try {
            int result2 = RubyRegexp.matcherSearch(context, matcher, beg + pos2, range, 0);
            if (result2 == -1) {
                context.setLocalMatch(null);
                return -1;
            }
            RubyMatchData match2 = context.getLocalMatch();
            if (match2 == null || match2.used()) {
                match2 = RubyRegexp.createMatchData(context, str, matcher, reg);
            } else {
                match2.initMatchData(str, matcher, reg);
            }
            match2.regexp = this;
            context.setLocalMatch(match2);
            return result2;
        }
        catch (JOniException je) {
            throw context.runtime.newRegexpError(je.getMessage());
        }
    }

    static RubyMatchData createMatchData(ThreadContext context, RubyString str, Matcher matcher, Regex pattern) {
        RubyMatchData match2 = new RubyMatchData(context.runtime);
        match2.initMatchData(str, matcher, pattern);
        return match2;
    }

    static RubyMatchData createMatchData(ThreadContext context, RubyString str, int pos2, RubyString pattern) {
        RubyMatchData match2 = new RubyMatchData(context.runtime);
        match2.initMatchData(str, pos2, pattern);
        return match2;
    }

    @JRubyMethod
    public IRubyObject options() {
        return this.metaClass.runtime.newFixnum(this.getOptions().toOptions());
    }

    @JRubyMethod(name={"casefold?"})
    public IRubyObject casefold_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.getOptions().isIgnorecase());
    }

    @JRubyMethod
    public IRubyObject source() {
        this.check();
        Encoding enc = this.pattern == null ? this.str.getEncoding() : this.pattern.getEncoding();
        ByteList newStr = this.str.dup();
        newStr.setEncoding(enc);
        return RubyString.newString(this.metaClass.runtime, newStr);
    }

    public ByteList rawSource() {
        return this.str;
    }

    public final int length() {
        return this.str.getRealSize();
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        if (this.pattern == null) {
            return this.anyToString();
        }
        Ruby runtime2 = this.metaClass.runtime;
        return RubyString.newString(runtime2, RegexpSupport.regexpDescription19(runtime2, this.str, this.options, this.str.getEncoding()));
    }

    @Deprecated
    public IRubyObject inspect19() {
        return this.inspect();
    }

    @Override
    @JRubyMethod
    public RubyString to_s() {
        this.check();
        Ruby runtime2 = this.metaClass.runtime;
        RegexpOptions newOptions = this.options.clone();
        int p2 = this.str.getBegin();
        int len = this.str.getRealSize();
        byte[] bytes2 = this.str.getUnsafeBytes();
        ByteList result2 = new ByteList(len);
        result2.append((byte)40).append((byte)63);
        while (len >= 4 && bytes2[p2] == 40 && bytes2[p2 + 1] == 63) {
            boolean err = true;
            p2 += 2;
            if ((len -= 2) > 0) {
                do {
                    if (bytes2[p2] == 109) {
                        newOptions.setMultiline(true);
                    } else if (bytes2[p2] == 105) {
                        newOptions.setIgnorecase(true);
                    } else {
                        if (bytes2[p2] != 120) break;
                        newOptions.setExtended(true);
                    }
                    ++p2;
                } while (--len > 0);
            }
            if (len > 1 && bytes2[p2] == 45) {
                ++p2;
                --len;
                do {
                    if (bytes2[p2] == 109) {
                        newOptions.setMultiline(false);
                    } else if (bytes2[p2] == 105) {
                        newOptions.setIgnorecase(false);
                    } else {
                        if (bytes2[p2] != 120) break;
                        newOptions.setExtended(false);
                    }
                    ++p2;
                } while (--len > 0);
            }
            if (bytes2[p2] == 41) {
                --len;
                ++p2;
                continue;
            }
            if (bytes2[p2] == 58 && bytes2[p2 + len - 1] == 41) {
                try {
                    Regex regex = new Regex(bytes2, ++p2, p2 + (len -= 2), 0, this.str.getEncoding(), Syntax.DEFAULT, WarnCallback.NONE);
                    err = false;
                }
                catch (JOniException e) {
                    err = true;
                }
            }
            if (!err) break;
            newOptions = this.options;
            p2 = this.str.getBegin();
            len = this.str.getRealSize();
            break;
        }
        RegexpSupport.appendOptions(result2, newOptions);
        if (!newOptions.isEmbeddable()) {
            result2.append((byte)45);
            if (!newOptions.isMultiline()) {
                result2.append((byte)109);
            }
            if (!newOptions.isIgnorecase()) {
                result2.append((byte)105);
            }
            if (!newOptions.isExtended()) {
                result2.append((byte)120);
            }
        }
        result2.append((byte)58);
        RegexpSupport.appendRegexpString19(runtime2, result2, bytes2, p2, len, this.str.getEncoding(), null);
        result2.append((byte)41);
        return RubyString.newString(runtime2, result2, this.getEncoding());
    }

    public String[] getNames() {
        int nameLength = this.pattern.numberOfNames();
        if (nameLength == 0) {
            return StringSupport.EMPTY_STRING_ARRAY;
        }
        String[] names2 = new String[nameLength];
        int j = 0;
        Iterator<NameEntry> i2 = this.pattern.namedBackrefIterator();
        while (i2.hasNext()) {
            NameEntry e = i2.next();
            names2[j++] = new String(e.name, e.nameP, e.nameEnd - e.nameP).intern();
        }
        return names2;
    }

    @JRubyMethod
    public IRubyObject names(ThreadContext context) {
        this.check();
        Ruby runtime2 = context.runtime;
        if (this.pattern.numberOfNames() == 0) {
            return runtime2.newEmptyArray();
        }
        RubyArray ary = RubyArray.newBlankArray(runtime2, this.pattern.numberOfNames());
        int index2 = 0;
        Iterator<NameEntry> i2 = this.pattern.namedBackrefIterator();
        while (i2.hasNext()) {
            NameEntry e = i2.next();
            RubyString name2 = RubyString.newStringShared(runtime2, e.name, e.nameP, e.nameEnd - e.nameP, this.pattern.getEncoding());
            ary.storeInternal(index2++, name2);
        }
        return ary;
    }

    @JRubyMethod
    public IRubyObject named_captures(ThreadContext context) {
        this.check();
        Ruby runtime2 = context.runtime;
        RubyHash hash2 = RubyHash.newHash(runtime2);
        if (this.pattern.numberOfNames() == 0) {
            return hash2;
        }
        Iterator<NameEntry> i2 = this.pattern.namedBackrefIterator();
        while (i2.hasNext()) {
            NameEntry e = i2.next();
            int[] backrefs = e.getBackRefs();
            RubyArray ary = RubyArray.newBlankArrayInternal(runtime2, backrefs.length);
            for (int idx = 0; idx < backrefs.length; ++idx) {
                ary.storeInternal(idx, RubyFixnum.newFixnum(runtime2, backrefs[idx]));
            }
            RubyString name2 = RubyString.newStringShared(runtime2, e.name, e.nameP, e.nameEnd - e.nameP);
            hash2.fastASet(name2.freeze(context), ary);
        }
        return hash2;
    }

    @JRubyMethod
    public IRubyObject encoding(ThreadContext context) {
        Encoding enc = this.pattern == null ? this.str.getEncoding() : this.pattern.getEncoding();
        return context.runtime.getEncodingService().getEncoding(enc);
    }

    @JRubyMethod(name={"fixed_encoding?"})
    public IRubyObject fixed_encoding_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.options.isFixed());
    }

    public static IRubyObject nth_match(int nth, IRubyObject match2) {
        if (match2.isNil()) {
            return match2;
        }
        return RubyRegexp.nth_match(nth, (RubyMatchData)match2);
    }

    static IRubyObject nth_match(int nth, RubyMatchData match2) {
        int end2;
        int start2;
        match2.check();
        if (match2.regs == null) {
            if (nth >= 1 || nth < 0 && ++nth <= 0) {
                return match2.getRuntime().getNil();
            }
            start2 = match2.begin;
            end2 = match2.end;
        } else {
            if (nth >= match2.regs.getNumRegs() || nth < 0 && (nth += match2.regs.getNumRegs()) <= 0) {
                return match2.getRuntime().getNil();
            }
            start2 = match2.regs.getBeg(nth);
            end2 = match2.regs.getEnd(nth);
        }
        if (start2 == -1) {
            return match2.getRuntime().getNil();
        }
        return match2.str.makeSharedString(match2.metaClass.runtime, start2, end2 - start2);
    }

    public static IRubyObject last_match(IRubyObject match2) {
        return RubyRegexp.nth_match(0, match2);
    }

    public static IRubyObject match_pre(IRubyObject match2) {
        if (match2.isNil()) {
            return match2;
        }
        RubyMatchData m = (RubyMatchData)match2;
        m.check();
        Ruby runtime2 = m.getRuntime();
        if (m.begin == -1) {
            return runtime2.getNil();
        }
        return m.str.makeShared(runtime2, 0, m.begin);
    }

    public static IRubyObject match_post(IRubyObject match2) {
        if (match2.isNil()) {
            return match2;
        }
        RubyMatchData m = (RubyMatchData)match2;
        m.check();
        Ruby runtime2 = m.getRuntime();
        if (m.begin == -1) {
            return runtime2.getNil();
        }
        return m.str.makeShared(runtime2, m.end, m.str.getByteList().getRealSize() - m.end);
    }

    public static IRubyObject match_last(IRubyObject match2) {
        int i2;
        if (match2.isNil()) {
            return match2;
        }
        RubyMatchData m = (RubyMatchData)match2;
        m.check();
        if (m.regs == null || m.regs.getBeg(0) == -1) {
            return m.getRuntime().getNil();
        }
        for (i2 = m.regs.getNumRegs() - 1; m.regs.getBeg(i2) == -1 && i2 > 0; --i2) {
        }
        if (i2 == 0) {
            return m.getRuntime().getNil();
        }
        return RubyRegexp.nth_match(i2, m);
    }

    private static final int ASCGET(boolean acompat, byte[] sBytes, int s2, int e, int[] cl, Encoding strEnc) {
        if (acompat) {
            cl[0] = 1;
            return Encoding.isAscii(sBytes[s2]) ? sBytes[s2] & 0xFF : -1;
        }
        return EncodingUtils.encAscget(sBytes, s2, e, cl, strEnc);
    }

    static RubyString regsub(ThreadContext context, RubyString str, RubyString src, Regex pattern, Matcher matcher) {
        return RubyRegexp.regsub(context, str, src, pattern, matcher.getRegion(), matcher.getBegin(), matcher.getEnd());
    }

    static RubyString regsub(ThreadContext context, RubyString str, RubyString src, Regex pattern, Region regs, int begin2, int end2) {
        int s2;
        Ruby runtime2 = context.runtime;
        RubyString val = null;
        int no = 0;
        int[] clen = new int[]{0};
        Encoding strEnc = EncodingUtils.encGet(context, str);
        Encoding srcEnc = EncodingUtils.encGet(context, src);
        boolean acompat = EncodingUtils.encAsciicompat(strEnc);
        ByteList bs = str.getByteList();
        ByteList srcbs = src.getByteList();
        byte[] sBytes = bs.getUnsafeBytes();
        int p2 = s2 = bs.getBegin();
        int e = p2 + bs.getRealSize();
        block11: while (s2 < e) {
            int c = RubyRegexp.ASCGET(acompat, sBytes, s2, e, clen, strEnc);
            if (c == -1) {
                s2 += StringSupport.length(strEnc, sBytes, s2, e);
                continue;
            }
            int ss = s2;
            if (c != 92 || (s2 += clen[0]) == e) continue;
            if (val == null) {
                val = RubyString.newString(runtime2, new ByteList(ss - p2));
            }
            EncodingUtils.encStrBufCat(runtime2, val, sBytes, p2, ss - p2, strEnc);
            c = RubyRegexp.ASCGET(acompat, sBytes, s2, e, clen, strEnc);
            if (c == -1) {
                s2 += StringSupport.length(strEnc, sBytes, s2, e);
                EncodingUtils.encStrBufCat(runtime2, val, sBytes, ss, s2 - ss, strEnc);
                p2 = s2;
                continue;
            }
            p2 = s2 += clen[0];
            switch (c) {
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (!pattern.noNameGroupIsActive(Syntax.RUBY)) continue block11;
                    no = c - 48;
                    break;
                }
                case 107: {
                    if (s2 < e && RubyRegexp.ASCGET(acompat, sBytes, s2, e, clen, strEnc) == 60) {
                        int name2;
                        int nameEnd;
                        for (nameEnd = name2 = s2 + clen[0]; nameEnd < e && (c = RubyRegexp.ASCGET(acompat, sBytes, nameEnd, e, clen, strEnc)) != 62; nameEnd += c == -1 ? StringSupport.length(strEnc, sBytes, nameEnd, e) : clen[0]) {
                        }
                        if (nameEnd < e) {
                            try {
                                no = pattern.nameToBackrefNumber(sBytes, name2, nameEnd, regs);
                            }
                            catch (JOniException je) {
                                throw runtime2.newIndexError(je.getMessage());
                            }
                            p2 = s2 = nameEnd + clen[0];
                            break;
                        }
                        throw runtime2.newRuntimeError("invalid group name reference format");
                    }
                    EncodingUtils.encStrBufCat(runtime2, val, sBytes, ss, s2 - ss, strEnc);
                    continue block11;
                }
                case 38: 
                case 48: {
                    no = 0;
                    break;
                }
                case 96: {
                    EncodingUtils.encStrBufCat(runtime2, val, srcbs.getUnsafeBytes(), srcbs.getBegin(), begin2, srcEnc);
                    continue block11;
                }
                case 39: {
                    EncodingUtils.encStrBufCat(runtime2, val, srcbs.getUnsafeBytes(), srcbs.getBegin() + end2, srcbs.getRealSize() - end2, srcEnc);
                    continue block11;
                }
                case 43: {
                    if (regs != null) {
                        for (no = regs.getNumRegs() - 1; regs.getBeg(no) == -1 && no > 0; --no) {
                        }
                    }
                    if (no != 0) break;
                    continue block11;
                }
                case 92: {
                    EncodingUtils.encStrBufCat(runtime2, val, sBytes, s2 - clen[0], clen[0], strEnc);
                    continue block11;
                }
                default: {
                    EncodingUtils.encStrBufCat(runtime2, val, sBytes, ss, s2 - ss, strEnc);
                    continue block11;
                }
            }
            if (regs != null) {
                if (no < 0 || no >= regs.getNumRegs() || regs.getBeg(no) == -1) continue;
                EncodingUtils.encStrBufCat(runtime2, val, srcbs.getUnsafeBytes(), srcbs.getBegin() + regs.getBeg(no), regs.getEnd(no) - regs.getBeg(no), srcEnc);
                continue;
            }
            if (no != 0 || begin2 == -1) continue;
            EncodingUtils.encStrBufCat(runtime2, val, srcbs.getUnsafeBytes(), srcbs.getBegin() + begin2, end2 - begin2, srcEnc);
        }
        if (val == null) {
            return str;
        }
        if (p2 < e) {
            EncodingUtils.encStrBufCat(runtime2, val, sBytes, p2, e - p2, strEnc);
        }
        return val;
    }

    final int adjustStartPos(RubyString str, int pos2, boolean reverse2) {
        this.check();
        return RubyRegexp.adjustStartPosInternal(str, this.pattern.getEncoding(), pos2, reverse2);
    }

    private static int adjustStartPosInternal(RubyString str, Encoding enc, int pos2, boolean reverse2) {
        ByteList value2 = str.getByteList();
        int len = value2.getRealSize();
        if (pos2 > 0 && enc.maxLength() != 1 && pos2 < len) {
            int start2 = value2.getBegin();
            if ((reverse2 ? -pos2 : len - pos2) > 0) {
                return enc.rightAdjustCharHead(value2.getUnsafeBytes(), start2, start2 + pos2, start2 + len) - start2;
            }
            return enc.leftAdjustCharHead(value2.getUnsafeBytes(), start2, start2 + pos2, start2 + len) - start2;
        }
        return pos2;
    }

    private static IRubyObject operandNoCheck(IRubyObject str) {
        return RubyRegexp.regOperand(str, false);
    }

    private static RubyString operandCheck(IRubyObject str) {
        return (RubyString)RubyRegexp.regOperand(str, true);
    }

    private static IRubyObject regOperand(IRubyObject str, boolean check) {
        if (str instanceof RubySymbol) {
            return ((RubySymbol)str).to_s();
        }
        return check ? str.convertToString() : str.checkStringType();
    }

    @Deprecated
    public static RubyRegexp unmarshalFrom(UnmarshalStream input) throws IOException {
        return RubyRegexp.newRegexp(input.getRuntime(), input.unmarshalString(), RegexpOptions.fromJoniOptions(input.readSignedByte()));
    }

    public static void marshalTo(RubyRegexp regexp2, MarshalStream output) throws IOException {
        output.registerLinkTarget(regexp2);
        output.writeString(regexp2.str);
        int options2 = regexp2.pattern.getOptions() & 7;
        if (regexp2.getOptions().isFixed()) {
            options2 |= 0x10;
        }
        output.writeByte(options2);
    }

    @Deprecated
    public final int search19(ThreadContext context, RubyString str, int pos2, boolean reverse2) {
        return this.search(context, str, pos2, reverse2);
    }

    @Deprecated
    public final int search19(ThreadContext context, RubyString str, int pos2, boolean reverse2, IRubyObject[] holder) {
        int result2 = this.searchString(context, str, pos2, reverse2);
        if (holder != null) {
            holder[0] = context.getLocalMatchOrNil();
        }
        return result2;
    }

    @Deprecated
    public final int search(ThreadContext context, RubyString str, int pos2, boolean reverse2, IRubyObject[] holder) {
        int result2 = this.searchString(context, str, pos2, reverse2);
        if (holder != null) {
            holder[0] = context.getLocalMatchOrNil();
        } else {
            context.setBackRef(context.getLocalMatchOrNil());
        }
        return result2;
    }

    @Deprecated
    public static IRubyObject getBackRef(ThreadContext context) {
        return context.getBackRef();
    }

    @Override
    @Deprecated
    public IRubyObject op_match19(ThreadContext context, IRubyObject str) {
        return this.op_match(context, str);
    }

    @Deprecated
    public IRubyObject match_m19(ThreadContext context, IRubyObject str) {
        return this.match_m(context, str, Block.NULL_BLOCK);
    }

    @Deprecated
    public IRubyObject match_m19(ThreadContext context, IRubyObject str, boolean useBackref, Block block) {
        return this.matchCommon(context, str, 0, useBackref, block);
    }

    public boolean isSimpleString() {
        return this.isLiteral() && this.getEncoding().isAsciiCompatible() && RubyString.scanForCodeRange(this.str) == 16 && !this.getOptions().isIgnorecase() && (this.str.realSize() == 1 && this.str.charAt(0) != '.' && this.str.charAt(0) != '^' && this.str.charAt(0) != '$' && this.str.charAt(0) != ' ' || this.isExact(this.str));
    }

    private boolean isExact(ByteList str) {
        int size2 = str.realSize();
        byte[] bytes2 = str.unsafeBytes();
        int begin2 = str.begin();
        for (int i2 = 0; i2 < size2; ++i2) {
            switch (bytes2[begin2 + i2]) {
                case 36: 
                case 40: 
                case 42: 
                case 43: 
                case 46: 
                case 63: 
                case 91: 
                case 92: 
                case 94: 
                case 123: 
                case 124: {
                    return false;
                }
            }
        }
        return true;
    }
}

