/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyClass;
import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.GetInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.VariableAccessor;

public class GetFieldInstr
extends GetInstr
implements FixedArityInstr {
    private transient VariableAccessor accessor = VariableAccessor.DUMMY_ACCESSOR;
    public final boolean rawValue;

    public GetFieldInstr(Variable dest, Operand obj, RubySymbol fieldName, boolean rawValue) {
        super(Operation.GET_FIELD, dest, obj, fieldName);
        this.rawValue = rawValue;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new GetFieldInstr(ii.getRenamedVariable(this.getResult()), this.getSource().cloneForInlining(ii), this.getName(), this.rawValue);
    }

    public static GetFieldInstr decode(IRReaderDecoder d) {
        return new GetFieldInstr(d.decodeVariable(), d.decodeOperand(), d.decodeSymbol(), d.decodeBoolean());
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.rawValue);
    }

    public VariableAccessor getAccessor(IRubyObject o) {
        RubyClass cls = o.getMetaClass().getRealClass();
        VariableAccessor localAccessor = this.accessor;
        if (localAccessor.getClassId() != cls.hashCode()) {
            this.accessor = localAccessor = cls.getVariableAccessorForRead(this.getId());
        }
        return localAccessor;
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject result2;
        IRubyObject object = (IRubyObject)this.getSource().retrieve(context, self2, currScope, currDynScope, temp);
        VariableAccessor a = this.getAccessor(object);
        IRubyObject iRubyObject = result2 = a == null ? null : (IRubyObject)a.get(object);
        if (result2 == null && this.rawValue) {
            return UndefinedValue.UNDEFINED;
        }
        return result2 == null && !this.rawValue ? context.nil : result2;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.GetFieldInstr(this);
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.getName(), "raw: " + this.rawValue};
    }
}

