"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLPlugin = void 0;

var _shared = require("../../common/constants/shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const PPLPlugin = function (Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.ppl = components.clientAction.namespaceFactory();
  const ppl = Client.prototype.ppl.prototype;
  ppl.pplQuery = ca({
    url: {
      fmt: `${_shared.PPL_ENDPOINT}`,
      params: {
        format: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  ppl.sqlQuery = ca({
    url: {
      fmt: `${_shared.SQL_ENDPOINT}`,
      params: {
        format: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  ppl.getDataConnectionById = ca({
    url: {
      fmt: `${_shared.OPENSEARCH_DATACONNECTIONS_API.DATACONNECTION}/<%=dataconnection%>`,
      req: {
        dataconnection: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  ppl.deleteDataConnection = ca({
    url: {
      fmt: `${_shared.OPENSEARCH_DATACONNECTIONS_API.DATACONNECTION}/<%=dataconnection%>`,
      req: {
        dataconnection: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  ppl.createDataSource = ca({
    url: {
      fmt: `${_shared.OPENSEARCH_DATACONNECTIONS_API.DATACONNECTION}`
    },
    needBody: true,
    method: 'POST'
  });
  ppl.modifyDataConnection = ca({
    url: {
      fmt: `${_shared.OPENSEARCH_DATACONNECTIONS_API.DATACONNECTION}`
    },
    needBody: true,
    method: 'PUT'
  });
  ppl.getDataConnections = ca({
    url: {
      fmt: `${_shared.OPENSEARCH_DATACONNECTIONS_API.DATACONNECTION}`
    },
    method: 'GET'
  });
};

exports.PPLPlugin = PPLPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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