"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDslRoute = registerDslRoute;

var _configSchema = require("@osd/config-schema");

var _shared = require("../../common/constants/shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function registerDslRoute({
  router,
  facet
}) {
  router.post({
    path: `${_shared.DSL_BASE}${_shared.DSL_SEARCH}`,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const {
      index,
      size,
      ...rest
    } = request.body;
    const params = {
      index,
      size,
      body: rest
    };

    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.get({
    path: `${_shared.DSL_BASE}${_shared.DSL_CAT}`,
    validate: {
      query: _configSchema.schema.object({
        format: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('cat.indices', request.query);
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.get({
    path: `${_shared.DSL_BASE}${_shared.DSL_MAPPING}`,
    validate: {
      query: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('indices.getMapping', {
        index: request.query.index
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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