"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRoutes = setupRoutes;

var _ppl = require("./ppl");

var _ppl_facet = require("../services/facets/ppl_facet");

var _dsl = require("./dsl");

var _dsl_facet = require("../services/facets/dsl_facet");

var _saved_objects = _interopRequireDefault(require("../services/facets/saved_objects"));

var _panels_router = require("./custom_panels/panels_router");

var _visualizations_router = require("./custom_panels/visualizations_router");

var _trace_analytics_dsl_router = require("./trace_analytics_dsl_router");

var _paraRouter = require("./notebooks/paraRouter");

var _noteRouter = require("./notebooks/noteRouter");

var _vizRouter = require("./notebooks/vizRouter");

var _queryService = require("../services/queryService");

var _sqlRouter = require("./notebooks/sqlRouter");

var _event_analytics_router = require("./event_analytics/event_analytics_router");

var _app_analytics_router = require("./application_analytics/app_analytics_router");

var _metrics_rounter = require("./metrics/metrics_rounter");

var _integrations_router = require("./integrations/integrations_router");

var _data_connections_router = require("./data_connections/data_connections_router");

var _datasources_router = require("./datasources/datasources_router");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupRoutes({
  router,
  client
}) {
  (0, _panels_router.PanelsRouter)(router);
  (0, _visualizations_router.VisualizationsRouter)(router);
  (0, _ppl.registerPplRoute)({
    router,
    facet: new _ppl_facet.PPLFacet(client)
  });
  (0, _dsl.registerDslRoute)({
    router,
    facet: new _dsl_facet.DSLFacet(client)
  });
  (0, _event_analytics_router.registerEventAnalyticsRouter)({
    router,
    savedObjectFacet: new _saved_objects.default(client)
  });
  (0, _app_analytics_router.registerAppAnalyticsRouter)(router); // TODO remove trace analytics route when DSL route for autocomplete is added

  (0, _trace_analytics_dsl_router.registerTraceAnalyticsDslRouter)(router); // notebooks routes

  (0, _paraRouter.registerParaRoute)(router);
  (0, _noteRouter.registerNoteRoute)(router);
  (0, _vizRouter.registerVizRoute)(router);
  const queryService = new _queryService.QueryService(client);
  (0, _sqlRouter.registerSqlRoute)(router, queryService);
  (0, _metrics_rounter.registerMetricsRoute)(router);
  (0, _integrations_router.registerIntegrationsRoute)(router);
  (0, _data_connections_router.registerDataConnectionsRoute)(router);
  (0, _datasources_router.registerDatasourcesRoute)(router);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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