"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addFieldMappingMethods = addFieldMappingMethods;

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function addFieldMappingMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.GET_MAPPINGS_VIEW] = createAction({
    url: {
      fmt: `${_constants.API.MAPPINGS_VIEW}?index_name=<%=indexName%>&rule_topic=<%=ruleTopic%>`,
      req: {
        indexName: {
          type: 'string',
          required: true
        },
        ruleTopic: {
          type: 'string',
          required: false
        }
      }
    },
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.CREATE_MAPPINGS] = createAction({
    url: {
      fmt: `${_constants.API.MAPPINGS_BASE}`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_MAPPINGS] = createAction({
    url: {
      fmt: `${_constants.API.MAPPINGS_BASE}?index_name=<%=indexName%>`,
      req: {
        indexName: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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