"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupNotificationsRoutes = setupNotificationsRoutes;

var _configSchema = require("@osd/config-schema");

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupNotificationsRoutes(services, router) {
  const {
    notificationsService
  } = services;
  router.get({
    path: `${_constants.API.CHANNELS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, notificationsService.getChannel);
  router.get({
    path: _constants.API.CHANNELS,
    validate: false
  }, notificationsService.getChannels);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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