"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogTypeService = void 0;

var _constants = require("../utils/constants");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class LogTypeService {
  constructor(osDriver) {
    this.osDriver = osDriver;

    _defineProperty(this, "createLogType", async (_context, request, response) => {
      try {
        const logType = request.body;
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const createLogTypeResponse = await callWithRequest(_constants.CLIENT_LOGTYPE_METHODS.CREATE_LOGTYPE, {
          body: logType
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: createLogTypeResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - LogTypeService - createLogType:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "searchLogTypes", async (_context, request, response) => {
      try {
        const query = request.body;
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const searchLogTypesResponse = await callWithRequest(_constants.CLIENT_LOGTYPE_METHODS.SEARCH_LOGTYPES, {
          body: {
            size: 10000,
            query: query !== null && query !== void 0 ? query : {
              match_all: {}
            }
          }
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: searchLogTypesResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - LogTypeService - searchLogTypes:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "updateLogType", async (_context, request, response) => {
      try {
        const logType = request.body;
        const {
          logTypeId
        } = request.params;
        const params = {
          body: logType,
          logTypeId
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const updateLogTypeResponse = await callWithRequest(_constants.CLIENT_LOGTYPE_METHODS.UPDATE_LOGTYPE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: updateLogTypeResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - LogTypeService - updateLogType:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "deleteLogType", async (_context, request, response) => {
      try {
        const {
          logTypeId
        } = request.params;
        const params = {
          logTypeId
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const deleteLogTypeResponse = await callWithRequest(_constants.CLIENT_LOGTYPE_METHODS.DELETE_LOGTYPE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: deleteLogTypeResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - deleteDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
  }

}

exports.LogTypeService = LogTypeService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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