"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.globalTenantName = exports.SAML_AUTH_LOGOUT = exports.SAML_AUTH_LOGIN_WITH_FRAGMENT = exports.SAML_AUTH_LOGIN = exports.PRIVATE_TENANT_SYMBOL = exports.PRIVATE_TENANT_RENDERING_TEXT = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OPENID_AUTH_LOGOUT = exports.OPENID_AUTH_LOGIN = exports.OPENDISTRO_SECURITY_ANONYMOUS = exports.MAX_LENGTH_OF_COOKIE_BYTES = exports.MAX_INTEGER = exports.LOGIN_PAGE_URI = exports.GLOBAL_TENANT_SYMBOL = exports.GLOBAL_TENANT_RENDERING_TEXT = exports.ESTIMATED_IRON_COOKIE_OVERHEAD = exports.ERROR_MISSING_ROLE_PATH = exports.DEFAULT_TENANT = exports.CUSTOM_ERROR_PAGE_URI = exports.CONFIGURATION_API_PREFIX = exports.AuthType = exports.AUTH_RESPONSE_TYPE = exports.AUTH_HEADER_NAME = exports.AUTH_GRANT_TYPE = exports.APP_ID_LOGIN = exports.APP_ID_CUSTOMERROR = exports.API_PREFIX = exports.API_ENDPOINT_DASHBOARDSINFO = exports.API_ENDPOINT_AUTHTYPE = exports.API_ENDPOINT_AUTHINFO = exports.API_AUTH_LOGOUT = exports.API_AUTH_LOGIN = exports.ANONYMOUS_AUTH_LOGOUT = exports.ANONYMOUS_AUTH_LOGIN = void 0;
exports.isGlobalTenant = isGlobalTenant;
exports.isPrivateTenant = isPrivateTenant;
exports.isRenderingPrivateTenant = isRenderingPrivateTenant;
exports.isValidResourceName = isValidResourceName;

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */
const PLUGIN_ID = 'opensearchDashboardsSecurity';
exports.PLUGIN_ID = PLUGIN_ID;
const PLUGIN_NAME = 'security-dashboards-plugin';
exports.PLUGIN_NAME = PLUGIN_NAME;
const APP_ID_LOGIN = 'login';
exports.APP_ID_LOGIN = APP_ID_LOGIN;
const APP_ID_CUSTOMERROR = 'customerror';
exports.APP_ID_CUSTOMERROR = APP_ID_CUSTOMERROR;
const OPENDISTRO_SECURITY_ANONYMOUS = 'opendistro_security_anonymous';
exports.OPENDISTRO_SECURITY_ANONYMOUS = OPENDISTRO_SECURITY_ANONYMOUS;
const API_PREFIX = '/api/v1';
exports.API_PREFIX = API_PREFIX;
const CONFIGURATION_API_PREFIX = 'configuration';
exports.CONFIGURATION_API_PREFIX = CONFIGURATION_API_PREFIX;
const API_ENDPOINT_AUTHINFO = API_PREFIX + '/auth/authinfo';
exports.API_ENDPOINT_AUTHINFO = API_ENDPOINT_AUTHINFO;
const API_ENDPOINT_DASHBOARDSINFO = API_PREFIX + '/auth/dashboardsinfo';
exports.API_ENDPOINT_DASHBOARDSINFO = API_ENDPOINT_DASHBOARDSINFO;
const API_ENDPOINT_AUTHTYPE = API_PREFIX + '/auth/type';
exports.API_ENDPOINT_AUTHTYPE = API_ENDPOINT_AUTHTYPE;
const LOGIN_PAGE_URI = '/app/' + APP_ID_LOGIN;
exports.LOGIN_PAGE_URI = LOGIN_PAGE_URI;
const CUSTOM_ERROR_PAGE_URI = '/app/' + APP_ID_CUSTOMERROR;
exports.CUSTOM_ERROR_PAGE_URI = CUSTOM_ERROR_PAGE_URI;
const API_AUTH_LOGIN = '/auth/login';
exports.API_AUTH_LOGIN = API_AUTH_LOGIN;
const API_AUTH_LOGOUT = '/auth/logout';
exports.API_AUTH_LOGOUT = API_AUTH_LOGOUT;
const OPENID_AUTH_LOGIN = '/auth/openid/login';
exports.OPENID_AUTH_LOGIN = OPENID_AUTH_LOGIN;
const SAML_AUTH_LOGIN = '/auth/saml/login';
exports.SAML_AUTH_LOGIN = SAML_AUTH_LOGIN;
const ANONYMOUS_AUTH_LOGIN = '/auth/anonymous';
exports.ANONYMOUS_AUTH_LOGIN = ANONYMOUS_AUTH_LOGIN;
const SAML_AUTH_LOGIN_WITH_FRAGMENT = '/auth/saml/captureUrlFragment';
exports.SAML_AUTH_LOGIN_WITH_FRAGMENT = SAML_AUTH_LOGIN_WITH_FRAGMENT;
const OPENID_AUTH_LOGOUT = '/auth/openid/logout';
exports.OPENID_AUTH_LOGOUT = OPENID_AUTH_LOGOUT;
const SAML_AUTH_LOGOUT = '/auth/saml/logout';
exports.SAML_AUTH_LOGOUT = SAML_AUTH_LOGOUT;
const ANONYMOUS_AUTH_LOGOUT = '/auth/anonymous/logout';
exports.ANONYMOUS_AUTH_LOGOUT = ANONYMOUS_AUTH_LOGOUT;
const ERROR_MISSING_ROLE_PATH = '/missing-role';
exports.ERROR_MISSING_ROLE_PATH = ERROR_MISSING_ROLE_PATH;
const AUTH_HEADER_NAME = 'authorization';
exports.AUTH_HEADER_NAME = AUTH_HEADER_NAME;
const AUTH_GRANT_TYPE = 'authorization_code';
exports.AUTH_GRANT_TYPE = AUTH_GRANT_TYPE;
const AUTH_RESPONSE_TYPE = 'code';
exports.AUTH_RESPONSE_TYPE = AUTH_RESPONSE_TYPE;
const GLOBAL_TENANT_SYMBOL = '';
exports.GLOBAL_TENANT_SYMBOL = GLOBAL_TENANT_SYMBOL;
const PRIVATE_TENANT_SYMBOL = '__user__';
exports.PRIVATE_TENANT_SYMBOL = PRIVATE_TENANT_SYMBOL;
const DEFAULT_TENANT = 'default';
exports.DEFAULT_TENANT = DEFAULT_TENANT;
const GLOBAL_TENANT_RENDERING_TEXT = 'Global';
exports.GLOBAL_TENANT_RENDERING_TEXT = GLOBAL_TENANT_RENDERING_TEXT;
const PRIVATE_TENANT_RENDERING_TEXT = 'Private';
exports.PRIVATE_TENANT_RENDERING_TEXT = PRIVATE_TENANT_RENDERING_TEXT;
const globalTenantName = 'global_tenant';
exports.globalTenantName = globalTenantName;
const MAX_INTEGER = 2147483647;
exports.MAX_INTEGER = MAX_INTEGER;
const MAX_LENGTH_OF_COOKIE_BYTES = 4000;
exports.MAX_LENGTH_OF_COOKIE_BYTES = MAX_LENGTH_OF_COOKIE_BYTES;
const ESTIMATED_IRON_COOKIE_OVERHEAD = 1.5;
exports.ESTIMATED_IRON_COOKIE_OVERHEAD = ESTIMATED_IRON_COOKIE_OVERHEAD;
let AuthType;
/**
 * A valid resource name should not containing percent sign (%) as they raise url injection issue.
 * And also should not be empty.
 * @param resourceName resource name to be validated
 */

exports.AuthType = AuthType;

(function (AuthType) {
  AuthType["BASIC"] = "basicauth";
  AuthType["OPEN_ID"] = "openid";
  AuthType["JWT"] = "jwt";
  AuthType["SAML"] = "saml";
  AuthType["PROXY"] = "proxy";
  AuthType["ANONYMOUS"] = "anonymous";
})(AuthType || (exports.AuthType = AuthType = {}));

function isValidResourceName(resourceName) {
  // see: https://javascript.info/regexp-unicode
  const exp = new RegExp('[\\p{C}%]', 'u');
  return !exp.test(resourceName) && resourceName.length > 0;
}

function isPrivateTenant(selectedTenant) {
  return selectedTenant !== null && selectedTenant === PRIVATE_TENANT_SYMBOL;
}

function isRenderingPrivateTenant(selectedTenant) {
  return selectedTenant !== null && (selectedTenant === null || selectedTenant === void 0 ? void 0 : selectedTenant.startsWith(PRIVATE_TENANT_SYMBOL));
}

function isGlobalTenant(selectedTenant) {
  return selectedTenant !== null && selectedTenant === GLOBAL_TENANT_SYMBOL;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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