/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.traccar.BaseDataHandler;
import org.traccar.config.Keys;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

@Singleton
@ChannelHandler.Sharable
public class MotionHandler
extends BaseDataHandler {
    private final CacheManager cacheManager;

    @Inject
    public MotionHandler(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    protected Position handlePosition(Position position) {
        if (!position.hasAttribute("motion")) {
            double threshold = AttributeUtil.lookup(this.cacheManager, Keys.EVENT_MOTION_SPEED_THRESHOLD, position.getDeviceId());
            position.set("motion", position.getSpeed() > threshold);
        }
        return position;
    }
}

