/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Calendar;
import org.traccar.model.Event;
import org.traccar.model.Geofence;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

@Singleton
@ChannelHandler.Sharable
public class GeofenceEventHandler
extends BaseEventHandler {
    private final CacheManager cacheManager;

    @Inject
    public GeofenceEventHandler(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        long geofenceId;
        if (!PositionUtil.isLatest(this.cacheManager, position)) {
            return null;
        }
        ArrayList<Long> oldGeofences = new ArrayList<Long>();
        Position lastPosition = this.cacheManager.getPosition(position.getDeviceId());
        if (lastPosition != null && lastPosition.getGeofenceIds() != null) {
            oldGeofences.addAll(lastPosition.getGeofenceIds());
        }
        ArrayList<Long> newGeofences = new ArrayList<Long>();
        if (position.getGeofenceIds() != null) {
            newGeofences.addAll(position.getGeofenceIds());
            newGeofences.removeAll(oldGeofences);
            oldGeofences.removeAll(position.getGeofenceIds());
        }
        HashMap<Event, Position> events = new HashMap<Event, Position>();
        Iterator iterator = oldGeofences.iterator();
        while (iterator.hasNext()) {
            Calendar calendar;
            geofenceId = (Long)iterator.next();
            Geofence geofence = this.cacheManager.getObject(Geofence.class, geofenceId);
            if (geofence == null) continue;
            long calendarId = geofence.getCalendarId();
            Calendar calendar2 = calendar = calendarId != 0L ? this.cacheManager.getObject(Calendar.class, calendarId) : null;
            if (calendar != null && !calendar.checkMoment(position.getFixTime())) continue;
            Event event = new Event("geofenceExit", position);
            event.setGeofenceId(geofenceId);
            events.put(event, position);
        }
        iterator = newGeofences.iterator();
        while (iterator.hasNext()) {
            Calendar calendar;
            geofenceId = (Long)iterator.next();
            long calendarId = this.cacheManager.getObject(Geofence.class, geofenceId).getCalendarId();
            Calendar calendar3 = calendar = calendarId != 0L ? this.cacheManager.getObject(Calendar.class, calendarId) : null;
            if (calendar != null && !calendar.checkMoment(position.getFixTime())) continue;
            Event event = new Event("geofenceEnter", position);
            event.setGeofenceId(geofenceId);
            events.put(event, position);
        }
        return events;
    }
}

