/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.ObdDecoder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class NyitechProtocolDecoder
extends BaseProtocolDecoder {
    public static final short MSG_LOGIN = 4097;
    public static final short MSG_COMPREHENSIVE_LIVE = 8193;
    public static final short MSG_COMPREHENSIVE_HISTORY = 8194;
    public static final short MSG_ALARM = 8195;
    public static final short MSG_FIXED = 8196;

    public NyitechProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void decodeLocation(Position position, ByteBuf buf) {
        DateBuilder dateBuilder = new DateBuilder().setDateReverse(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
        position.setTime(dateBuilder.getDate());
        short flags = buf.readUnsignedByte();
        position.setValid(BitUtil.to(flags, 2) > 0);
        double lat = (double)buf.readUnsignedIntLE() / 3600000.0;
        double lon = (double)buf.readUnsignedIntLE() / 3600000.0;
        position.setLatitude(BitUtil.check(flags, 2) ? lat : -lat);
        position.setLongitude(BitUtil.check(flags, 3) ? lon : -lon);
        position.setSpeed(UnitsConverter.knotsFromCps(buf.readUnsignedShortLE()));
        position.setCourse((double)buf.readUnsignedShortLE() * 0.1);
        position.setAltitude((double)buf.readShortLE() * 0.1);
    }

    private String decodeAlarm(int type) {
        switch (type) {
            case 9: {
                return "hardAcceleration";
            }
            case 10: {
                return "hardBraking";
            }
            case 11: {
                return "hardCornering";
            }
            case 14: {
                return "sos";
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        buf.readUnsignedShortLE();
        String id = buf.readCharSequence(12, StandardCharsets.US_ASCII).toString();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        int type = buf.readUnsignedShortLE();
        if (type != 4097 && type != 8193 && type != 8194 && type != 8195 && type != 8196) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        if (type == 8193 || type == 8194) {
            buf.skipBytes(6);
            boolean includeLocation = buf.readUnsignedByte() > 0;
            boolean includeObd = buf.readUnsignedByte() > 0;
            buf.readUnsignedByte();
            if (includeLocation) {
                this.decodeLocation(position, buf);
            } else {
                this.getLastLocation(position, null);
            }
            if (includeObd) {
                int count = buf.readUnsignedByte();
                block5: for (int i = 0; i < count; ++i) {
                    int pid = buf.readUnsignedShortLE();
                    short length = buf.readUnsignedByte();
                    switch (length) {
                        case 1: {
                            position.add(ObdDecoder.decodeData(pid, buf.readByte(), true));
                            continue block5;
                        }
                        case 2: {
                            position.add(ObdDecoder.decodeData(pid, buf.readShortLE(), true));
                            continue block5;
                        }
                        case 4: {
                            position.add(ObdDecoder.decodeData(pid, buf.readIntLE(), true));
                            continue block5;
                        }
                        default: {
                            buf.skipBytes((int)length);
                        }
                    }
                }
            }
            position.set("fuelUsed", (double)buf.readUnsignedInt() * 0.01);
            position.set("tripOdometer", buf.readUnsignedInt());
        } else if (type == 8195) {
            buf.readUnsignedShortLE();
            buf.readUnsignedByte();
            position.set("alarm", this.decodeAlarm(buf.readUnsignedByte()));
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
            buf.skipBytes(6);
            this.decodeLocation(position, buf);
        } else if (type == 8196) {
            buf.skipBytes(6);
            this.decodeLocation(position, buf);
        } else {
            this.decodeLocation(position, buf);
        }
        return position;
    }
}

