/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer.builder;

import com.android.tools.smali.dexlib2.writer.StringSection;
import com.android.tools.smali.dexlib2.writer.builder.BuilderMapEntryCollection;
import com.android.tools.smali.dexlib2.writer.builder.BuilderStringReference;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

class BuilderStringPool
implements StringSection<BuilderStringReference, BuilderStringReference> {
    private final ConcurrentMap<String, BuilderStringReference> internedItems = Maps.newConcurrentMap();

    BuilderStringPool() {
    }

    BuilderStringReference internString(String string) {
        BuilderStringReference ret = (BuilderStringReference)this.internedItems.get(string);
        if (ret != null) {
            return ret;
        }
        BuilderStringReference stringReference = new BuilderStringReference(string);
        ret = this.internedItems.putIfAbsent(string, stringReference);
        return ret == null ? stringReference : ret;
    }

    BuilderStringReference internNullableString(String string) {
        if (string == null) {
            return null;
        }
        return this.internString(string);
    }

    @Override
    public int getNullableItemIndex(BuilderStringReference key) {
        return key == null ? -1 : key.index;
    }

    @Override
    public int getItemIndex(BuilderStringReference key) {
        return key.index;
    }

    @Override
    public boolean hasJumboIndexes() {
        return this.internedItems.size() > 65536;
    }

    @Override
    public Collection<? extends Map.Entry<? extends BuilderStringReference, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderStringReference>(this.internedItems.values()){

            @Override
            protected int getValue(BuilderStringReference key) {
                return key.index;
            }

            @Override
            protected int setValue(BuilderStringReference key, int value) {
                int prev = key.index;
                key.index = value;
                return prev;
            }
        };
    }

    @Override
    public int getItemCount() {
        return this.internedItems.size();
    }
}

