/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.FocusManager;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.auth.AuthenticationAuthority;
import org.jitsi.jicofo.auth.ErrorFactory;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.metrics.JicofoMetricsContainer;
import org.jitsi.jicofo.visitors.VisitorsConfig;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.jicofo.xmpp.VisitorsManager;
import org.jitsi.jicofo.xmpp.XmppConfig;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.jicofo.xmpp.XmppVisitorConnectionConfig;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.jitsimeet.ConferenceIq;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u0014\u0010/\u001a\u0004\u0018\u00010,2\b\u00100\u001a\u0004\u0018\u00010,H\u0016J,\u00101\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.2\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010.2\u0006\u00105\u001a\u00020\fH\u0002R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u00067"}, d2={"Lorg/jitsi/jicofo/xmpp/ConferenceIqHandler;", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Listener;", "Lorg/jivesoftware/smack/iqrequest/AbstractIqRequestHandler;", "xmppProvider", "Lorg/jitsi/jicofo/xmpp/XmppProvider;", "focusManager", "Lorg/jitsi/jicofo/FocusManager;", "focusAuthJid", "", "authAuthority", "Lorg/jitsi/jicofo/auth/AuthenticationAuthority;", "jigasiEnabled", "", "visitorsManager", "Lorg/jitsi/jicofo/xmpp/VisitorsManager;", "(Lorg/jitsi/jicofo/xmpp/XmppProvider;Lorg/jitsi/jicofo/FocusManager;Ljava/lang/String;Lorg/jitsi/jicofo/auth/AuthenticationAuthority;ZLorg/jitsi/jicofo/xmpp/VisitorsManager;)V", "getAuthAuthority", "()Lorg/jitsi/jicofo/auth/AuthenticationAuthority;", "breakoutAddress", "Lorg/jxmpp/jid/DomainBareJid;", "connection", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "()Lorg/jitsi/utils/OrderedJsonObject;", "getFocusAuthJid", "()Ljava/lang/String;", "getFocusManager", "()Lorg/jitsi/jicofo/FocusManager;", "getJigasiEnabled", "()Z", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getVisitorsManager", "()Lorg/jitsi/jicofo/xmpp/VisitorsManager;", "getXmppProvider", "()Lorg/jitsi/jicofo/xmpp/XmppProvider;", "componentsChanged", "", "components", "", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Component;", "handleConferenceIq", "Lorg/jivesoftware/smack/packet/IQ;", "query", "Lorg/jitsi/xmpp/extensions/jitsimeet/ConferenceIq;", "handleIQRequest", "iqRequest", "processExtensions", "room", "Lorg/jxmpp/jid/EntityBareJid;", "response", "roomExists", "Companion", "jicofo"})
@SourceDebugExtension(value={"SMAP\nConferenceIqHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConferenceIqHandler.kt\norg/jitsi/jicofo/xmpp/ConferenceIqHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1747#2,3:234\n1747#2,3:237\n1#3:240\n*S KotlinDebug\n*F\n+ 1 ConferenceIqHandler.kt\norg/jitsi/jicofo/xmpp/ConferenceIqHandler\n*L\n99#1:234,3\n100#1:237,3\n*E\n"})
public final class ConferenceIqHandler
extends AbstractIqRequestHandler
implements XmppProvider.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XmppProvider xmppProvider;
    @NotNull
    private final FocusManager focusManager;
    @NotNull
    private final String focusAuthJid;
    @Nullable
    private final AuthenticationAuthority authAuthority;
    private final boolean jigasiEnabled;
    @NotNull
    private final VisitorsManager visitorsManager;
    @NotNull
    private final AbstractXMPPConnection connection;
    @Nullable
    private DomainBareJid breakoutAddress;
    @NotNull
    private final Logger logger;
    @NotNull
    private static final CounterMetric conferenceRequestCounter = MetricsContainer.registerCounter$default(JicofoMetricsContainer.Companion.getInstance(), "conference_requests", "Number of conference requests received.", 0L, 4, null);
    @NotNull
    private static final CounterMetric newConferenceRequestCounter = MetricsContainer.registerCounter$default(JicofoMetricsContainer.Companion.getInstance(), "conference_requests_new", "Number of conference requests received for new conferences.", 0L, 4, null);

    public ConferenceIqHandler(@NotNull XmppProvider xmppProvider, @NotNull FocusManager focusManager, @NotNull String focusAuthJid, @Nullable AuthenticationAuthority authAuthority, boolean jigasiEnabled, @NotNull VisitorsManager visitorsManager) {
        Intrinsics.checkNotNullParameter(xmppProvider, "xmppProvider");
        Intrinsics.checkNotNullParameter(focusManager, "focusManager");
        Intrinsics.checkNotNullParameter(focusAuthJid, "focusAuthJid");
        Intrinsics.checkNotNullParameter(visitorsManager, "visitorsManager");
        super("conference", "http://jitsi.org/protocol/focus", IQ.Type.set, IQRequestHandler.Mode.sync);
        this.xmppProvider = xmppProvider;
        this.focusManager = focusManager;
        this.focusAuthJid = focusAuthJid;
        this.authAuthority = authAuthority;
        this.jigasiEnabled = jigasiEnabled;
        this.visitorsManager = visitorsManager;
        this.connection = this.xmppProvider.getXmppConnection();
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        this.xmppProvider.addListener(this);
        this.registrationChanged(this.xmppProvider.getRegistered());
        this.componentsChanged(this.xmppProvider.getComponents());
    }

    @NotNull
    public final XmppProvider getXmppProvider() {
        return this.xmppProvider;
    }

    @NotNull
    public final FocusManager getFocusManager() {
        return this.focusManager;
    }

    @NotNull
    public final String getFocusAuthJid() {
        return this.focusAuthJid;
    }

    @Nullable
    public final AuthenticationAuthority getAuthAuthority() {
        return this.authAuthority;
    }

    public final boolean getJigasiEnabled() {
        return this.jigasiEnabled;
    }

    @NotNull
    public final VisitorsManager getVisitorsManager() {
        return this.visitorsManager;
    }

    @NotNull
    public final OrderedJsonObject getDebugState() {
        String string;
        String string2;
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$_get_debugState__u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        ((Map)$this$_get_debugState__u24lambda_u240).put("breakout_address", String.valueOf(this.breakoutAddress));
        ((Map)$this$_get_debugState__u24lambda_u240).put("focus_auth_jid", this.focusAuthJid);
        ((Map)$this$_get_debugState__u24lambda_u240).put("jigasi_enabled", this.jigasiEnabled);
        Map map = $this$_get_debugState__u24lambda_u240;
        String string3 = "auth_authority";
        Object object = this.authAuthority;
        String string4 = string2 = object != null && (object = object.getClass()) != null ? ((Class)object).getSimpleName() : null;
        if (string4 == null) {
            string = "null";
        } else {
            Intrinsics.checkNotNull(string4);
            string = string2;
        }
        string2 = string;
        map.put(string3, string2);
        return orderedJsonObject;
    }

    @NotNull
    public final IQ handleConferenceIq(@NotNull ConferenceIq query) {
        Unit unit;
        Object object;
        String vnode;
        String string;
        boolean visitorRequested;
        boolean visitorSupported;
        JitsiMeetConferenceImpl conference;
        ConferenceIq response;
        EntityBareJid room;
        block22: {
            boolean bl;
            boolean bl2;
            block21: {
                IQ error;
                boolean roomExists;
                ConferenceIq conferenceIq;
                Intrinsics.checkNotNullParameter(query, "query");
                EntityBareJid entityBareJid = query.getRoom();
                if (entityBareJid == null) {
                    ErrorIQ errorIQ = IQ.createErrorResponse((IQ)query, StanzaError.from(StanzaError.Condition.bad_request, "No 'room' specified.").build());
                    Intrinsics.checkNotNullExpressionValue(errorIQ, "createErrorResponse(...)");
                    return errorIQ;
                }
                room = entityBareJid;
                ConferenceIq $this$handleConferenceIq_u24lambda_u241 = conferenceIq = new ConferenceIq();
                boolean bl3 = false;
                $this$handleConferenceIq_u24lambda_u241.setType(IQ.Type.result);
                $this$handleConferenceIq_u24lambda_u241.setStanzaId(query.getStanzaId());
                $this$handleConferenceIq_u24lambda_u241.setFrom(query.getTo());
                $this$handleConferenceIq_u24lambda_u241.setTo(query.getFrom());
                $this$handleConferenceIq_u24lambda_u241.setRoom(query.getRoom());
                $this$handleConferenceIq_u24lambda_u241.setFocusJid(this.focusAuthJid);
                response = conferenceIq;
                this.logger.info("Conference request for room " + room + ", from " + query.getFrom());
                conferenceRequestCounter.inc();
                conference = this.focusManager.getConference(room);
                boolean bl4 = roomExists = conference != null;
                if (!roomExists) {
                    newConferenceRequestCounter.inc();
                }
                if ((error = this.processExtensions(query, room, response, roomExists)) != null) {
                    return error;
                }
                List<ConferenceIq.Property> list = query.getProperties();
                Intrinsics.checkNotNullExpressionValue(list, "getProperties(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConferenceIq.Property it = (ConferenceIq.Property)element$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual(it.getName(), "visitors-version")) continue;
                        bl2 = true;
                        break block21;
                    }
                    bl2 = false;
                }
            }
            visitorSupported = bl2;
            List<ConferenceIq.Property> list = query.getProperties();
            Intrinsics.checkNotNullExpressionValue(list, "getProperties(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConferenceIq.Property it = (ConferenceIq.Property)element$iv;
                    boolean bl6 = false;
                    if (!(Intrinsics.areEqual(it.getName(), "visitor") && Intrinsics.areEqual(it.getValue(), "true"))) continue;
                    bl = true;
                    break block22;
                }
                bl = visitorRequested = false;
            }
        }
        if (visitorRequested && VisitorsConfig.config.getEnableLiveRoom()) {
            Object object2 = conference;
            if (!(object2 != null && (object2 = ((JitsiMeetConferenceImpl)object2).getChatRoom()) != null ? object2.getVisitorsLive() : false)) {
                response.setReady(false);
                response.addProperty(new ConferenceIq.Property("live", "false"));
                return response;
            }
        }
        if (visitorSupported && this.visitorsManager.getEnabled()) {
            JitsiMeetConferenceImpl jitsiMeetConferenceImpl = conference;
            string = jitsiMeetConferenceImpl != null ? jitsiMeetConferenceImpl.redirectVisitor(visitorRequested) : null;
        } else {
            string = vnode = null;
        }
        if (this.visitorsManager.getEnabled() && !visitorSupported) {
            this.logger.info("Endpoint with no visitor support.");
        }
        if ((object = XmppConfig.Companion.getVisitors().get(vnode)) != null && (object = ((XmppVisitorConnectionConfig)object).getJid()) != null) {
            Object it = object;
            boolean bl = false;
            this.logger.info("Redirecting to " + vnode);
            response.setVnode(vnode);
            response.setFocusJid((String)it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            ConferenceIqHandler $this$handleConferenceIq_u24lambda_u245 = this;
            boolean bl = false;
            if (vnode != null) {
                $this$handleConferenceIq_u24lambda_u245.logger.error("No XmppConnectionConfig for vnode=" + vnode);
            }
        }
        Map<String, String> map = query.getPropertiesMap();
        Intrinsics.checkNotNullExpressionValue(map, "getPropertiesMap(...)");
        response.setReady(FocusManager.conferenceRequest$default(this.focusManager, room, map, null, false, 12, null));
        if (this.authAuthority != null) {
            response.addProperty(new ConferenceIq.Property("authentication", "true"));
            response.addProperty(new ConferenceIq.Property("externalAuth", String.valueOf(this.authAuthority.isExternal())));
        } else {
            response.addProperty(new ConferenceIq.Property("authentication", "false"));
        }
        if (this.jigasiEnabled) {
            response.addProperty(new ConferenceIq.Property("sipGatewayEnabled", "true"));
        }
        return response;
    }

    private final IQ processExtensions(ConferenceIq query, EntityBareJid room, ConferenceIq response, boolean roomExists) {
        boolean isBreakoutRoom;
        boolean bl = isBreakoutRoom = this.breakoutAddress != null && Intrinsics.areEqual(room.getDomain(), this.breakoutAddress);
        if (!isBreakoutRoom && this.authAuthority != null) {
            IQ authErrorOrResponse = this.authAuthority.processAuthentication(query, response);
            if (authErrorOrResponse != null) {
                return authErrorOrResponse;
            }
            if (!roomExists && !this.focusManager.hasBreakoutRooms(room) && this.authAuthority.getUserIdentity(query.getFrom()) == null) {
                return ErrorFactory.createNotAuthorizedError(query, "not authorized user domain");
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IQ handleIQRequest(@Nullable IQ iqRequest) {
        if (!(iqRequest instanceof ConferenceIq)) {
            ErrorIQ errorIQ;
            ErrorIQ it = errorIQ = IQ.createErrorResponse(iqRequest, StanzaError.getBuilder(StanzaError.Condition.internal_server_error).build());
            boolean bl = false;
            this.logger.error("Received an unexpected IQ type: " + iqRequest);
            return errorIQ;
        }
        Jid originalFrom = ((ConferenceIq)iqRequest).getFrom();
        ConferenceIq conferenceIq = (ConferenceIq)iqRequest;
        DomainBareJid domainBareJid = XmppConfig.client.getClientProxy();
        Intrinsics.checkNotNull(originalFrom);
        conferenceIq.setFrom(UtilKt.parseJidFromClientProxyJid(domainBareJid, originalFrom));
        TaskPools.Companion.getIoPool().execute(() -> ConferenceIqHandler.handleIQRequest$lambda$8(this, iqRequest, originalFrom));
        return null;
    }

    @Override
    public void componentsChanged(@NotNull Set<XmppProvider.Component> components) {
        DomainBareJid domainBareJid;
        String address;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(components, "components");
            Iterable iterable = components;
            for (Object t : iterable) {
                XmppProvider.Component it = (XmppProvider.Component)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getType(), "breakout_rooms")) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        XmppProvider.Component component = v0;
        String string = address = component != null ? component.getAddress() : null;
        if (address == null) {
            this.logger.info("No breakout room component discovered.");
            domainBareJid = null;
        } else {
            this.logger.info("Using breakout room component at " + address + ".");
            domainBareJid = JidCreate.domainBareFrom(address);
        }
        this.breakoutAddress = domainBareJid;
    }

    @Override
    public void registrationChanged(boolean registered) {
        XmppProvider.Listener.DefaultImpls.registrationChanged(this, registered);
    }

    private static final void handleIQRequest$lambda$8(ConferenceIqHandler this$0, IQ $iqRequest, Jid $originalFrom) {
        IQ iQ;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        IQ $this$handleIQRequest_u24lambda_u248_u24lambda_u247 = iQ = this$0.handleConferenceIq((ConferenceIq)$iqRequest);
        boolean bl = false;
        $this$handleIQRequest_u24lambda_u248_u24lambda_u247.setTo($originalFrom);
        IQ response = iQ;
        try {
            this$0.connection.sendStanza(response);
        }
        catch (Exception e) {
            this$0.logger.error("Failed to send response", e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jitsi/jicofo/xmpp/ConferenceIqHandler$Companion;", "", "()V", "conferenceRequestCounter", "Lorg/jitsi/metrics/CounterMetric;", "getConferenceRequestCounter", "()Lorg/jitsi/metrics/CounterMetric;", "newConferenceRequestCounter", "getNewConferenceRequestCounter", "jicofo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CounterMetric getConferenceRequestCounter() {
            return conferenceRequestCounter;
        }

        @NotNull
        public final CounterMetric getNewConferenceRequestCounter() {
            return newConferenceRequestCounter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

