/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;

public class ScriptOrFnNode
extends Node.Scope {
    private int encodedSourceStart;
    private int encodedSourceEnd;
    private String sourceName;
    private int endLineno = -1;
    private ObjArray functions;
    private ObjArray regexps;
    private ArrayList<Node.Symbol> symbols = new ArrayList(4);
    private int paramCount = 0;
    private String[] variableNames;
    private boolean[] isConsts;
    private Object compilerData;
    private int tempNumber = 0;

    public ScriptOrFnNode(int n) {
        super(n);
        this.setParent(null);
    }

    public final String getSourceName() {
        return this.sourceName;
    }

    public final void setSourceName(String string) {
        this.sourceName = string;
    }

    public final int getEncodedSourceStart() {
        return this.encodedSourceStart;
    }

    public final int getEncodedSourceEnd() {
        return this.encodedSourceEnd;
    }

    public final void setEncodedSourceBounds(int n, int n2) {
        this.encodedSourceStart = n;
        this.encodedSourceEnd = n2;
    }

    public final int getBaseLineno() {
        return this.lineno;
    }

    public final void setBaseLineno(int n) {
        if (n < 0 || this.lineno >= 0) {
            Kit.codeBug();
        }
        this.lineno = n;
    }

    public final int getEndLineno() {
        return this.endLineno;
    }

    public final void setEndLineno(int n) {
        if (n < 0 || this.endLineno >= 0) {
            Kit.codeBug();
        }
        this.endLineno = n;
    }

    public final int getFunctionCount() {
        if (this.functions == null) {
            return 0;
        }
        return this.functions.size();
    }

    public final FunctionNode getFunctionNode(int n) {
        return (FunctionNode)this.functions.get(n);
    }

    public final int addFunction(FunctionNode functionNode) {
        if (functionNode == null) {
            Kit.codeBug();
        }
        if (this.functions == null) {
            this.functions = new ObjArray();
        }
        this.functions.add(functionNode);
        return this.functions.size() - 1;
    }

    public final int getRegexpCount() {
        if (this.regexps == null) {
            return 0;
        }
        return this.regexps.size() / 2;
    }

    public final String getRegexpString(int n) {
        return (String)this.regexps.get(n * 2);
    }

    public final String getRegexpFlags(int n) {
        return (String)this.regexps.get(n * 2 + 1);
    }

    public final int addRegexp(String string, String string2) {
        if (string == null) {
            Kit.codeBug();
        }
        if (this.regexps == null) {
            this.regexps = new ObjArray();
        }
        this.regexps.add(string);
        this.regexps.add(string2);
        return this.regexps.size() / 2 - 1;
    }

    public int getIndexForNameNode(Node node) {
        Node.Symbol symbol;
        if (this.variableNames == null) {
            throw Kit.codeBug();
        }
        Node.Scope scope = node.getScope();
        Node.Symbol symbol2 = symbol = scope == null ? null : scope.getSymbol(node.getString());
        if (symbol == null) {
            return -1;
        }
        return symbol.index;
    }

    public final String getParamOrVarName(int n) {
        if (this.variableNames == null) {
            throw Kit.codeBug();
        }
        return this.variableNames[n];
    }

    public final int getParamCount() {
        return this.paramCount;
    }

    public final int getParamAndVarCount() {
        if (this.variableNames == null) {
            throw Kit.codeBug();
        }
        return this.symbols.size();
    }

    public final String[] getParamAndVarNames() {
        if (this.variableNames == null) {
            throw Kit.codeBug();
        }
        return this.variableNames;
    }

    public final boolean[] getParamAndVarConst() {
        if (this.variableNames == null) {
            throw Kit.codeBug();
        }
        return this.isConsts;
    }

    void addSymbol(Node.Symbol symbol) {
        if (this.variableNames != null) {
            throw Kit.codeBug();
        }
        if (symbol.declType == 86) {
            ++this.paramCount;
        }
        this.symbols.add(symbol);
    }

    void flattenSymbolTable(boolean bl) {
        if (!bl) {
            ArrayList<Node.Symbol> arrayList = new ArrayList<Node.Symbol>();
            if (this.symbolTable != null) {
                int n = 0;
                while (n < this.symbols.size()) {
                    Node.Symbol symbol = this.symbols.get(n);
                    if (symbol.containingTable == this) {
                        arrayList.add(symbol);
                    }
                    ++n;
                }
            }
            this.symbols = arrayList;
        }
        this.variableNames = new String[this.symbols.size()];
        this.isConsts = new boolean[this.symbols.size()];
        int n = 0;
        while (n < this.symbols.size()) {
            Node.Symbol symbol = this.symbols.get(n);
            this.variableNames[n] = symbol.name;
            this.isConsts[n] = symbol.declType == 153;
            symbol.index = n++;
        }
    }

    public final Object getCompilerData() {
        return this.compilerData;
    }

    public final void setCompilerData(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (this.compilerData != null) {
            throw new IllegalStateException();
        }
        this.compilerData = object;
    }

    public String getNextTempName() {
        return "$" + this.tempNumber++;
    }
}

