/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.xslt;

import java.io.IOException;
import java.util.List;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.xslt.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryXSLT
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    public static String FACTORY_JAXP = "JAXP";
    public static String FACTORY_SAXON = "SAXON";
    private String xmlfilename;
    private String xslfilename;
    private String outputfilename;
    public int iffileexists;
    private boolean addfiletoresult;
    private String xsltfactory;

    public JobEntryXSLT(String n) {
        super(n, "");
        this.xmlfilename = null;
        this.xslfilename = null;
        this.outputfilename = null;
        this.iffileexists = 1;
        this.addfiletoresult = false;
        this.xsltfactory = FACTORY_JAXP;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.XSLT);
    }

    public JobEntryXSLT() {
        this("");
    }

    public JobEntryXSLT(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryXSLT je = (JobEntryXSLT)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"xmlfilename", (String)this.xmlfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"xslfilename", (String)this.xslfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"outputfilename", (String)this.outputfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"iffileexists", (int)this.iffileexists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addfiletoresult", (boolean)this.addfiletoresult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"xsltfactory", (String)this.xsltfactory));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.xmlfilename = XMLHandler.getTagValue((Node)entrynode, (String)"xmlfilename");
            this.xslfilename = XMLHandler.getTagValue((Node)entrynode, (String)"xslfilename");
            this.outputfilename = XMLHandler.getTagValue((Node)entrynode, (String)"outputfilename");
            this.iffileexists = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"iffileexists"), (int)-1);
            this.addfiletoresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addfiletoresult"));
            this.xsltfactory = XMLHandler.getTagValue((Node)entrynode, (String)"xsltfactory");
            if (this.xsltfactory == null) {
                this.xsltfactory = FACTORY_JAXP;
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'xslt' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.xmlfilename = rep.getJobEntryAttributeString(id_jobentry, "xmlfilename");
            this.xslfilename = rep.getJobEntryAttributeString(id_jobentry, "xslfilename");
            this.outputfilename = rep.getJobEntryAttributeString(id_jobentry, "outputfilename");
            this.iffileexists = (int)rep.getJobEntryAttributeInteger(id_jobentry, "iffileexists");
            this.addfiletoresult = rep.getJobEntryAttributeBoolean(id_jobentry, "addfiletoresult");
            this.xsltfactory = rep.getJobEntryAttributeString(id_jobentry, "xsltfactory");
            if (this.xsltfactory == null) {
                this.xsltfactory = FACTORY_JAXP;
            }
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'xslt' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "xmlfilename", this.xmlfilename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "xslfilename", this.xslfilename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "outputfilename", this.outputfilename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "iffileexists", this.iffileexists);
            rep.saveJobEntryAttribute(id_job, this.getID(), "addfiletoresult", this.addfiletoresult);
            rep.saveJobEntryAttribute(id_job, this.getID(), "xsltfactory", this.xsltfactory);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'xslt' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getXSLTFactory() {
        return this.xsltfactory;
    }

    public void setXSLTFactory(String xsltfactoryin) {
        this.xsltfactory = xsltfactoryin;
    }

    public String getRealxmlfilename() {
        return this.environmentSubstitute(this.getxmlFilename());
    }

    public String getRealoutputfilename() {
        return this.environmentSubstitute(this.getoutputFilename());
    }

    public String getRealxslfilename() {
        return this.environmentSubstitute(this.getxslFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        Result result;
        block34: {
            FileObject outputfile;
            FileObject xslfile;
            FileObject xmlfile;
            String realxslfilename;
            String realxmlfilename;
            LogWriter log;
            block33: {
                log = LogWriter.getInstance();
                result = previousResult;
                result.setResult(false);
                realxmlfilename = this.getRealxmlfilename();
                realxslfilename = this.getRealxslfilename();
                String realoutputfilename = this.getRealoutputfilename();
                xmlfile = null;
                xslfile = null;
                outputfile = null;
                if (this.xmlfilename != null && this.xslfilename != null && this.outputfilename != null) {
                    xmlfile = KettleVFS.getFileObject((String)realxmlfilename);
                    xslfile = KettleVFS.getFileObject((String)realxslfilename);
                    outputfile = KettleVFS.getFileObject((String)realoutputfilename);
                    if (xmlfile.exists() && xslfile.exists()) {
                        if (outputfile.exists() && this.iffileexists == 2) {
                            log.logError(this.toString(), Messages.getString("JobEntryXSLT.OuputFileExists1.Label") + realoutputfilename + Messages.getString("JobEntryXSLT.OuputFileExists2.Label"), new Object[0]);
                            result.setResult(false);
                            result.setNrErrors(1L);
                        } else if (outputfile.exists() && this.iffileexists == 1) {
                            if (log.isDebug()) {
                                log.logDebug(this.toString(), Messages.getString("JobEntryXSLT.OuputFileExists1.Label") + realoutputfilename + Messages.getString("JobEntryXSLT.OuputFileExists2.Label"), new Object[0]);
                            }
                            result.setResult(true);
                        } else {
                            if (outputfile.exists() && this.iffileexists == 0) {
                                String wildcard = realoutputfilename.substring(realoutputfilename.length() - 4, realoutputfilename.length());
                                realoutputfilename = wildcard.substring(0, 1).equals(".") ? realoutputfilename.substring(0, realoutputfilename.length() - 4) + "_" + StringUtil.getFormattedDateTimeNow((boolean)true) + wildcard : realoutputfilename + "_" + StringUtil.getFormattedDateTimeNow((boolean)true);
                                if (log.isDebug()) {
                                    log.logDebug(this.toString(), Messages.getString("JobEntryXSLT.OuputFileExists1.Label") + realoutputfilename + Messages.getString("JobEntryXSLT.OuputFileExists2.Label"), new Object[0]);
                                    log.logDebug(this.toString(), Messages.getString("JobEntryXSLT.OuputFileNameChange1.Label") + realoutputfilename + Messages.getString("JobEntryXSLT.OuputFileNameChange2.Label"), new Object[0]);
                                }
                            }
                            TransformerFactory factory = TransformerFactory.newInstance();
                            if (this.xsltfactory.equals(FACTORY_SAXON)) {
                                factory = new TransformerFactoryImpl();
                            }
                            if (log.isDetailed()) {
                                log.logDetailed(Messages.getString("JobEntryXSL.Log.TransformerFactoryInfos"), Messages.getString("JobEntryXSL.Log.TransformerFactory", factory.getClass().getName()), new Object[0]);
                            }
                            Templates template = factory.newTemplates(new StreamSource(KettleVFS.getInputStream((FileObject)xslfile)));
                            Transformer xformer = template.newTransformer();
                            if (log.isDetailed()) {
                                log.logDetailed(Messages.getString("JobEntryXSL.Log.TransformerClassInfos"), Messages.getString("JobEntryXSL.Log.TransformerClass", xformer.getClass().getName()), new Object[0]);
                            }
                            StreamSource source = new StreamSource(KettleVFS.getInputStream((FileObject)xmlfile));
                            StreamResult resultat = new StreamResult(KettleVFS.getOutputStream((FileObject)outputfile, (boolean)false));
                            xformer.transform(source, resultat);
                            if (this.isAddFileToResult()) {
                                ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)realoutputfilename), parentJob.getJobname(), this.toString());
                                result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                            }
                            result.setResult(true);
                        }
                    } else {
                        if (!xmlfile.exists()) {
                            log.logError(this.toString(), Messages.getString("JobEntryXSLT.FileDoesNotExist1.Label") + realxmlfilename + Messages.getString("JobEntryXSLT.FileDoesNotExist2.Label"), new Object[0]);
                        }
                        if (!xslfile.exists()) {
                            log.logError(this.toString(), Messages.getString("JobEntryXSLT.FileDoesNotExist1.Label") + realxslfilename + Messages.getString("JobEntryXSLT.FileDoesNotExist2.Label"), new Object[0]);
                        }
                        result.setResult(false);
                        result.setNrErrors(1L);
                    }
                    break block33;
                }
                log.logError(this.toString(), Messages.getString("JobEntryXSLT.AllFilesNotNull.Label"), new Object[0]);
                result.setResult(false);
                result.setNrErrors(1L);
            }
            Object var20_20 = null;
            try {
                if (xmlfile != null) {
                    xmlfile.close();
                }
                if (xslfile != null) {
                    xslfile.close();
                }
                if (outputfile != null) {
                    outputfile.close();
                }
                System.gc();
            }
            catch (IOException e2) {}
            break block34;
            {
                catch (Exception e) {
                    log.logError(this.toString(), Messages.getString("JobEntryXSLT.ErrorXLST.Label") + Messages.getString("JobEntryXSLT.ErrorXLSTXML1.Label") + realxmlfilename + Messages.getString("JobEntryXSLT.ErrorXLSTXML2.Label") + Messages.getString("JobEntryXSLT.ErrorXLSTXSL1.Label") + realxslfilename + Messages.getString("JobEntryXSLT.ErrorXLSTXSL2.Label") + e.getMessage(), new Object[0]);
                    result.setResult(false);
                    result.setNrErrors(1L);
                    Object var20_21 = null;
                    try {
                        if (xmlfile != null) {
                            xmlfile.close();
                        }
                        if (xslfile != null) {
                            xslfile.close();
                        }
                        if (outputfile != null) {
                            outputfile.close();
                        }
                        System.gc();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var20_22 = null;
                try {
                    if (xmlfile != null) {
                        xmlfile.close();
                    }
                    if (xslfile != null) {
                        xslfile.close();
                    }
                    if (outputfile != null) {
                        outputfile.close();
                    }
                    System.gc();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public void setxmlFilename(String filename) {
        this.xmlfilename = filename;
    }

    public String getxmlFilename() {
        return this.xmlfilename;
    }

    public String getoutputFilename() {
        return this.outputfilename;
    }

    public void setoutputFilename(String outputfilename) {
        this.outputfilename = outputfilename;
    }

    public void setxslFilename(String filename) {
        this.xslfilename = filename;
    }

    public String getxslFilename() {
        return this.xslfilename;
    }

    public void setAddFileToResult(boolean addfiletoresultin) {
        this.addfiletoresult = addfiletoresultin;
    }

    public boolean isAddFileToResult() {
        return this.addfiletoresult;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.xslfilename) && !Const.isEmpty((String)this.xmlfilename)) {
            String realXmlFileName = jobMeta.environmentSubstitute(this.xmlfilename);
            String realXslFileName = jobMeta.environmentSubstitute(this.xslfilename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realXmlFileName, ResourceEntry.ResourceType.FILE));
            reference.getEntries().add(new ResourceEntry(realXslFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "xmlFilename", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "xslFilename", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "outputFilename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

