/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.fife.ui.rtextarea.RTextArea;

class LineNumberList
extends JComponent
implements CaretListener,
DocumentListener,
PropertyChangeListener {
    private static final int MIN_CELL_WIDTH = 24;
    private static final int RHS_BORDER_WIDTH = 8;
    private RTextArea textArea;
    private int currentLine;
    private int lastY = -1;
    private int cellHeight;
    private int cellWidth;
    private int ascent;
    private int currentNumLines;

    public LineNumberList(RTextArea rTextArea) {
        this(rTextArea, new Color(128, 128, 128));
    }

    public LineNumberList(RTextArea rTextArea, Color color) {
        this.textArea = rTextArea;
        if (color != null) {
            this.setForeground(color);
        } else {
            this.setForeground(new Color(128, 128, 128));
        }
        Color color2 = rTextArea.getBackground();
        this.setBackground(color2 == null ? Color.WHITE : color2);
        rTextArea.addCaretListener(this);
        rTextArea.addPropertyChangeListener(this);
        rTextArea.getDocument().addDocumentListener(this);
        this.currentLine = 1;
        this.updateCellHeights();
        this.updateCellWidths();
    }

    public void caretUpdate(CaretEvent caretEvent) {
        int n = this.textArea.getCaretPosition();
        if (!this.textArea.getLineWrap()) {
            int n2 = this.textArea.getDocument().getDefaultRootElement().getElementIndex(n) + 1;
            if (this.currentLine != n2) {
                this.currentLine = n2;
                this.repaint();
            }
        } else {
            try {
                int n3 = this.textArea.modelToView((int)n).y;
                if (n3 != this.lastY) {
                    this.lastY = n3;
                    this.currentLine = this.textArea.getDocument().getDefaultRootElement().getElementIndex(n) + 1;
                    this.repaint();
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public Color getLineNumberColor() {
        return this.getForeground();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.cellWidth, this.textArea.getHeight());
    }

    public static final int getTextWidth(String string, FontMetrics fontMetrics) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            n += fontMetrics.charWidth(string.charAt(i));
        }
        return n;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        int n = this.textArea.getDocument().getDefaultRootElement().getElementCount();
        if (n > this.currentNumLines) {
            if (n / 10 > this.currentNumLines / 10) {
                this.updateCellWidths();
            }
            this.currentNumLines = n;
        }
    }

    public void paint(Graphics graphics) {
        Element element = this.textArea.getDocument().getDefaultRootElement();
        Rectangle rectangle = this.textArea.getVisibleRect();
        if (rectangle == null) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.cellWidth, rectangle.height);
        if (this.textArea.getLineWrap()) {
            this.paintWrappedLineNumbers(graphics, element, rectangle);
            return;
        }
        int n = rectangle.y / this.cellHeight + 1;
        int n2 = Math.min(n + rectangle.height / this.cellHeight, element.getElementCount()) + 1;
        int n3 = -(rectangle.y % this.cellHeight);
        Insets insets = this.textArea.getInsets();
        if (insets != null) {
            n3 += insets.top;
        }
        int n4 = n3 + this.ascent;
        if (this.textArea.isCurrentLineHighlightEnabled() && this.currentLine >= n && this.currentLine < n2) {
            graphics.setColor(this.textArea.getCurrentLineHighlightColor());
            graphics.fillRect(0, n3 + (this.currentLine - n) * this.cellHeight, this.cellWidth, this.cellHeight);
        }
        graphics.setColor(Color.BLACK);
        graphics.drawLine(this.cellWidth - 4, 0, this.cellWidth - 4, rectangle.height);
        graphics.setColor(this.getForeground());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = this.getBounds().width - 8;
        for (int i = n; i < n2; ++i) {
            String string = Integer.toString(i);
            int n6 = LineNumberList.getTextWidth(string, fontMetrics);
            graphics.drawString(string, n5 - n6, n4);
            n4 += this.cellHeight;
        }
    }

    public void paintWrappedLineNumbers(Graphics graphics, Element element, Rectangle rectangle) {
        int n;
        int n2 = element.getElementCount();
        int n3 = this.textArea.viewToModel(new Point(rectangle.x, rectangle.y));
        int n4 = element.getElementIndex(n3);
        Element element2 = element.getElement(n4);
        int n5 = element2.getStartOffset();
        int n6 = element2.getEndOffset();
        Rectangle rectangle2 = null;
        try {
            rectangle2 = this.textArea.modelToView(n5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        int n7 = n = rectangle2.y - rectangle.y;
        graphics.setColor(this.getForeground());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n8 = this.getBounds().width - 8;
        int n9 = rectangle.height;
        while (n7 < n9) {
            Rectangle rectangle3 = null;
            try {
                rectangle3 = this.textArea.modelToView(n6 - 1);
                rectangle3.y -= rectangle.y;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                break;
            }
            if (this.textArea.isCurrentLineHighlightEnabled() && n4 == this.currentLine - 1) {
                graphics.setColor(this.textArea.getCurrentLineHighlightColor());
                graphics.fillRect(0, n7, this.cellWidth, rectangle3.y + rectangle3.height - n7);
                graphics.setColor(this.getForeground());
            }
            String string = Integer.toString(n4 + 1);
            int n10 = LineNumberList.getTextWidth(string, fontMetrics);
            graphics.drawString(string, n8 - n10, n7 + this.ascent);
            n7 = rectangle3.y + rectangle3.height;
            if (++n4 >= n2) break;
            n6 = element.getElement(n4).getEndOffset();
        }
        graphics.setColor(Color.BLACK);
        int n11 = this.cellWidth - 4;
        graphics.drawLine(n11, 0, n11, rectangle.height - 1);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("background")) {
            Color color = this.textArea.getBackground();
            this.setBackground(color == null ? Color.WHITE : color);
            this.repaint();
        }
        if (string.equals("background.image")) {
            this.setBackground(Color.WHITE);
            this.repaint();
        } else if (string.equals("lineWrap")) {
            this.lastY = -1;
            this.setSize(this.getWidth(), this.textArea.getHeight());
        } else if (string.equals("font")) {
            this.updateCellHeights();
        } else if (string.equals("RTA.currentLineHighlight") || string.equals("RTA.currentLineHighlightColor")) {
            this.repaint();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        int n = this.textArea.getDocument().getDefaultRootElement().getElementCount();
        if (n < this.currentNumLines) {
            if (n / 10 < this.currentNumLines / 10) {
                this.updateCellWidths();
            }
            this.currentNumLines = n;
            this.repaint();
        }
    }

    public void setFont(Font font) {
        if (font == null) {
            font = new Font("Monospaced", 0, 10);
        }
        super.setFont(font);
    }

    public void setLineNumberColor(Color color) {
        this.setForeground(color);
        this.repaint();
    }

    public void updateCellHeights() {
        this.cellHeight = this.textArea.getLineHeight();
        this.ascent = this.textArea.getMaxAscent();
        this.repaint();
    }

    public void updateCellWidths() {
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n = 0;
            int n2 = this.textArea.getDocument().getDefaultRootElement().getElementCount();
            while (n2 >= 10) {
                n2 /= 10;
                ++n;
            }
            this.cellWidth = Math.max(fontMetrics.charWidth('9') * (n + 2) + 5, 24);
            this.revalidate();
        }
    }
}

