/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import java.net.InetSocketAddress;

public class InetSocketAddressDeserializer
extends FromStringDeserializer<InetSocketAddress> {
    private static final long serialVersionUID = 1L;
    public static final InetSocketAddressDeserializer instance = new InetSocketAddressDeserializer();

    public InetSocketAddressDeserializer() {
        super(InetSocketAddress.class);
    }

    @Override
    protected InetSocketAddress _deserialize(String value, DeserializationContext ctxt) throws IOException {
        if (value.startsWith("[")) {
            int i = value.lastIndexOf(93);
            if (i == -1) {
                throw new InvalidFormatException("Bracketed IPv6 address must contain closing bracket.", value, InetSocketAddress.class);
            }
            int j = value.indexOf(58, i);
            int port = j > -1 ? Integer.parseInt(value.substring(j + 1)) : 0;
            return new InetSocketAddress(value.substring(0, i + 1), port);
        }
        int i = value.indexOf(58);
        if (i != -1 && value.indexOf(58, i + 1) == -1) {
            int port = Integer.parseInt(value.substring(i));
            return new InetSocketAddress(value.substring(0, i), port);
        }
        return new InetSocketAddress(value, 0);
    }
}

