/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryObject {
    public static final String STRING_OBJECT_TYPE_TRANSFORMATION = "Transformation";
    public static final String STRING_OBJECT_TYPE_JOB = "Job";
    private String name;
    private String modifiedUser;
    private Date modifiedDate;
    private String objectType;
    private String description;

    public RepositoryObject() {
    }

    public RepositoryObject(String name, String modifiedUser, Date modifiedDate, String objectType, String description) {
        this();
        this.name = name;
        this.modifiedUser = modifiedUser;
        this.modifiedDate = modifiedDate;
        this.objectType = objectType;
        this.description = description;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public String getModifiedUser() {
        return this.modifiedUser;
    }

    public void setModifiedUser(String modifiedUser) {
        this.modifiedUser = modifiedUser;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static final int compareStrings(String one, String two) {
        if (one == null && two == null) {
            return 0;
        }
        if (one == null && two != null) {
            return -1;
        }
        if (one != null && two == null) {
            return 1;
        }
        return one.compareToIgnoreCase(two);
    }

    public static final int compareDates(Date one, Date two) {
        if (one == null && two == null) {
            return 0;
        }
        if (one == null && two != null) {
            return -1;
        }
        if (one != null && two == null) {
            return 1;
        }
        return one.compareTo(two);
    }

    public static final void sortRepositoryObjects(List<RepositoryObject> objects, final int sortPosition, final boolean ascending) {
        Collections.sort(objects, new Comparator<RepositoryObject>(){

            @Override
            public int compare(RepositoryObject r1, RepositoryObject r2) {
                int result = 0;
                switch (sortPosition) {
                    case 0: {
                        result = RepositoryObject.compareStrings(r1.getName(), r2.getName());
                        break;
                    }
                    case 1: {
                        result = RepositoryObject.compareStrings(r1.getObjectType(), r2.getObjectType());
                        break;
                    }
                    case 2: {
                        result = RepositoryObject.compareStrings(r1.getModifiedUser(), r2.getModifiedUser());
                        break;
                    }
                    case 3: {
                        result = RepositoryObject.compareDates(r1.getModifiedDate(), r2.getModifiedDate());
                        break;
                    }
                    case 4: {
                        result = RepositoryObject.compareStrings(r1.getDescription(), r2.getDescription());
                    }
                }
                if (!ascending) {
                    result *= -1;
                }
                return result;
            }
        });
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

