/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionMuxedListener;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.client.streaming.IncomingConnectionFilter;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.ConnectionManager;
import net.i2p.client.streaming.impl.ConnectionOptions;
import net.i2p.client.streaming.impl.I2PServerSocketFull;
import net.i2p.client.streaming.impl.I2PSocketFull;
import net.i2p.client.streaming.impl.PcapWriter;
import net.i2p.client.streaming.impl.StandardServerSocket;
import net.i2p.client.streaming.impl.StandardSocket;
import net.i2p.client.streaming.impl.TooManyStreamsException;
import net.i2p.crypto.SigAlgo;
import net.i2p.crypto.SigType;
import net.i2p.data.Certificate;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.ByteArrayStream;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.ConvertToHash;
import net.i2p.util.Log;

public class I2PSocketManagerFull
implements I2PSocketManager {
    private final I2PAppContext _context;
    private final Log _log;
    private final I2PSession _session;
    private final Set<I2PSession> _subsessions;
    private final I2PServerSocketFull _serverSocket;
    private StandardServerSocket _realServerSocket;
    private final ConnectionOptions _defaultOptions;
    private long _acceptTimeout;
    private String _name;
    private static final AtomicInteger __managerId;
    private final ConnectionManager _connectionManager;
    private final AtomicBoolean _isDestroyed = new AtomicBoolean();
    private static final Set<Hash> _ecUnsupported;
    private static final String[] EC_UNSUPPORTED_HASHES;
    private static final Set<Hash> _edUnsupported;
    private static final String[] ED_UNSUPPORTED_HASHES;
    private static volatile String _userDsaList;
    private static final Set<Hash> _userDsaOnly;
    private static final String PROP_DSALIST = "i2p.streaming.dsalist";
    private static final long ACCEPT_TIMEOUT_DEFAULT = 5000L;
    private static final Object _pcapInitLock;
    private static boolean _pcapInitialized;
    static PcapWriter pcapWriter;
    static final String PROP_PCAP = "i2p.streaming.pcap";
    private static final String PCAP_FILE = "streaming.pcap";

    @Deprecated
    public I2PSocketManagerFull() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void init(I2PAppContext context, I2PSession session, Properties opts, String name) {
        throw new UnsupportedOperationException();
    }

    public I2PSocketManagerFull(I2PAppContext context, I2PSession session, Properties opts, String name, IncomingConnectionFilter connectionFilter) {
        String senc;
        this._context = context;
        this._session = session;
        this._subsessions = new ConcurrentHashSet(4);
        this._log = this._context.logManager().getLog(I2PSocketManagerFull.class);
        this._name = name + " " + __managerId.incrementAndGet();
        this._acceptTimeout = 5000L;
        this._defaultOptions = new ConnectionOptions(opts);
        if (opts != null && opts.getProperty("i2p.streaming.maxMessageSize") == null && (senc = opts.getProperty("i2cp.leaseSetEncType")) != null && !senc.equals("0")) {
            String[] senca = DataHelper.split((String)senc, (String)",");
            boolean has0 = false;
            boolean has4 = false;
            for (int i = 0; i < senca.length; ++i) {
                if (senca[i].equals("0")) {
                    has0 = true;
                    continue;
                }
                if (!senca[i].equals("4")) continue;
                has4 = true;
            }
            if (has4) {
                this._defaultOptions.setMaxMessageSize(1812);
                if (!has0) {
                    this._defaultOptions.setMaxInitialMessageSize(1812);
                }
            }
        }
        this._connectionManager = new ConnectionManager(this._context, this._session, this._defaultOptions, connectionFilter);
        this._serverSocket = new I2PServerSocketFull(this);
        if (this._log.shouldLog(20)) {
            this._log.info("Socket manager created.  \ndefault options: " + this._defaultOptions + "\noriginal properties: " + opts);
        }
        I2PSocketManagerFull.debugInit(context);
    }

    public I2PSocketOptions buildOptions() {
        return this.buildOptions(null);
    }

    public I2PSocketOptions buildOptions(Properties opts) {
        ConnectionOptions curOpts = new ConnectionOptions(this._defaultOptions);
        curOpts.setProperties(opts);
        return curOpts;
    }

    public I2PSession getSession() {
        return this._session;
    }

    public I2PSession addSubsession(InputStream privateKeyStream, Properties opts) throws I2PSessionException {
        I2PSession rv;
        boolean added;
        if (privateKeyStream == null) {
            ByteArrayStream keyStream = new ByteArrayStream(1024);
            try {
                SigType type = this.getSigType(opts);
                if (type != SigType.DSA_SHA1) {
                    throw new I2PSessionException("type " + type + " unsupported");
                }
                PublicKey pub = this._session.getMyDestination().getPublicKey();
                PrivateKey priv = this._session.getDecryptionKey();
                SimpleDataStructure[] keys = this._context.keyGenerator().generateSigningKeys(type);
                pub.writeBytes((OutputStream)keyStream);
                keys[0].writeBytes((OutputStream)keyStream);
                Certificate.NULL_CERT.writeBytes((OutputStream)keyStream);
                priv.writeBytes((OutputStream)keyStream);
                keys[1].writeBytes((OutputStream)keyStream);
            }
            catch (GeneralSecurityException e) {
                throw new I2PSessionException("Error creating keys", (Throwable)e);
            }
            catch (I2PException e) {
                throw new I2PSessionException("Error creating keys", (Throwable)e);
            }
            catch (IOException e) {
                throw new I2PSessionException("Error creating keys", (Throwable)e);
            }
            catch (RuntimeException e) {
                throw new I2PSessionException("Error creating keys", (Throwable)e);
            }
            privateKeyStream = keyStream.asInputStream();
        }
        if (!(added = this._subsessions.add(rv = this._session.addSubsession(privateKeyStream, opts)))) {
            this._session.removeSubsession(rv);
            throw new I2PSessionException("dup");
        }
        ConnectionOptions defaultOptions = new ConnectionOptions(opts);
        int protocol = defaultOptions.getEnforceProtocol() ? 6 : 0;
        rv.addMuxedSessionListener((I2PSessionMuxedListener)this._connectionManager.getMessageHandler(), protocol, defaultOptions.getLocalPort());
        if (this._log.shouldLog(30)) {
            this._log.warn("Added subsession " + rv);
        }
        return rv;
    }

    private SigType getSigType(Properties opts) {
        String st;
        if (opts != null && (st = opts.getProperty("i2cp.destination.sigType")) != null) {
            SigType rv = SigType.parseSigType((String)st);
            if (rv != null && rv.isAvailable()) {
                return rv;
            }
            if (rv != null) {
                st = rv.toString();
            }
            this._log.logAlways(30, "Tunnel configuration error: Unsupported sig type " + st + ", reverting to " + I2PClient.DEFAULT_SIGTYPE);
        }
        return I2PClient.DEFAULT_SIGTYPE;
    }

    public void removeSubsession(I2PSession session) {
        this._session.removeSubsession(session);
        boolean removed = this._subsessions.remove(session);
        if (removed) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Removed subsession " + session);
            }
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Subsession not found to remove " + session);
        }
    }

    public List<I2PSession> getSubsessions() {
        return this._session.getSubsessions();
    }

    public ConnectionManager getConnectionManager() {
        return this._connectionManager;
    }

    public I2PSocket receiveSocket() throws I2PException, ConnectException, SocketTimeoutException {
        this.verifySession();
        Connection con = this._connectionManager.getConnectionHandler().accept(this._connectionManager.getSoTimeout());
        I2PSocketFull sock = new I2PSocketFull(con, this._context);
        con.setSocket(sock);
        return sock;
    }

    public boolean ping(Destination peer, long timeoutMs) {
        if (timeoutMs <= 0L) {
            throw new IllegalArgumentException("bad timeout");
        }
        return this._connectionManager.ping(peer, this._defaultOptions.getLocalPort(), this._defaultOptions.getPort(), timeoutMs);
    }

    public boolean ping(Destination peer, int localPort, int remotePort, long timeoutMs) {
        if (localPort < 0 || localPort > 65535 || remotePort < 0 || remotePort > 65535) {
            throw new IllegalArgumentException("bad port");
        }
        if (timeoutMs <= 0L) {
            throw new IllegalArgumentException("bad timeout");
        }
        return this._connectionManager.ping(peer, localPort, remotePort, timeoutMs);
    }

    public byte[] ping(Destination peer, int localPort, int remotePort, long timeoutMs, byte[] payload) {
        if (localPort < 0 || localPort > 65535 || remotePort < 0 || remotePort > 65535) {
            throw new IllegalArgumentException("bad port");
        }
        if (timeoutMs <= 0L) {
            throw new IllegalArgumentException("bad timeout");
        }
        return this._connectionManager.ping(peer, localPort, remotePort, timeoutMs, payload);
    }

    public void setAcceptTimeout(long ms) {
        this._acceptTimeout = ms;
    }

    public long getAcceptTimeout() {
        return this._acceptTimeout;
    }

    public void setDefaultOptions(I2PSocketOptions options) {
        if (!(options instanceof ConnectionOptions)) {
            throw new IllegalArgumentException();
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Changing options from:\n " + this._defaultOptions + "\nto:\n " + options);
        }
        this._defaultOptions.updateAll((ConnectionOptions)options);
        this._connectionManager.updateOptions();
    }

    public I2PSocketOptions getDefaultOptions() {
        return this._defaultOptions;
    }

    public I2PServerSocket getServerSocket() {
        this._connectionManager.setAllowIncomingConnections(true);
        return this._serverSocket;
    }

    public synchronized ServerSocket getStandardServerSocket() throws IOException {
        if (this._realServerSocket == null) {
            this._realServerSocket = new StandardServerSocket(this._serverSocket);
        }
        this._connectionManager.setAllowIncomingConnections(true);
        return this._realServerSocket;
    }

    private void verifySession() throws I2PException {
        this.verifySession(this._connectionManager.getSession());
    }

    private void verifySession(I2PSession session) throws I2PException {
        if (this._isDestroyed.get()) {
            throw new I2PSessionException("Session was closed");
        }
        if (!session.isClosed()) {
            return;
        }
        session.connect();
    }

    public I2PSocket connect(Destination peer, I2PSocketOptions options) throws I2PException, NoRouteToHostException {
        if (peer == null) {
            throw new NullPointerException();
        }
        if (options == null) {
            options = this._defaultOptions;
        }
        ConnectionOptions opts = null;
        opts = options instanceof ConnectionOptions ? new ConnectionOptions((ConnectionOptions)options) : new ConnectionOptions(options);
        if (this._log.shouldLog(20)) {
            this._log.info("Connecting to " + peer.calculateHash().toBase64().substring(0, 6) + " with options: " + opts);
        }
        I2PSession session = this._session;
        if (!this._subsessions.isEmpty()) {
            this.updateUserDsaList();
            Hash h = peer.calculateHash();
            SigAlgo myAlgo = session.getMyDestination().getSigType().getBaseAlgorithm();
            if (myAlgo == SigAlgo.EC && _ecUnsupported.contains(h) || myAlgo == SigAlgo.EdDSA && _edUnsupported.contains(h) || !_userDsaOnly.isEmpty() && _userDsaOnly.contains(h)) {
                for (I2PSession sess : this._subsessions) {
                    if (sess.getMyDestination().getSigType() != SigType.DSA_SHA1) continue;
                    session = sess;
                    break;
                }
            }
        }
        this.verifySession(session);
        Connection con = this._connectionManager.connect(peer, opts, session);
        if (con == null) {
            throw new TooManyStreamsException("Too many streams, max " + this._defaultOptions.getMaxConns());
        }
        I2PSocketFull socket = new I2PSocketFull(con, this._context);
        con.setSocket(socket);
        if (con.getConnectionError() != null) {
            con.disconnect(false);
            throw new NoRouteToHostException(con.getConnectionError());
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUserDsaList() {
        String hashes = this._context.getProperty(PROP_DSALIST, "");
        if (!_userDsaList.equals(hashes)) {
            Set<Hash> set = _userDsaOnly;
            synchronized (set) {
                if (hashes.length() > 0) {
                    HashSet<Hash> newSet = new HashSet<Hash>();
                    StringTokenizer tok = new StringTokenizer(hashes, ",; ");
                    while (tok.hasMoreTokens()) {
                        String hashstr = tok.nextToken();
                        Hash hh = ConvertToHash.getHash((String)hashstr);
                        if (hh != null) {
                            newSet.add(hh);
                            continue;
                        }
                        this._log.error("Bad i2p.streaming.dsalist entry: " + hashstr);
                    }
                    _userDsaOnly.addAll(newSet);
                    _userDsaOnly.retainAll(newSet);
                    _userDsaList = hashes;
                } else {
                    _userDsaOnly.clear();
                    _userDsaList = "";
                }
            }
        }
    }

    public I2PSocket connect(Destination peer) throws I2PException, NoRouteToHostException {
        return this.connect(peer, this._defaultOptions);
    }

    public Socket connectToSocket(Destination peer) throws IOException {
        return this.connectToSocket(peer, this._defaultOptions);
    }

    public Socket connectToSocket(Destination peer, int timeout) throws IOException {
        ConnectionOptions opts = new ConnectionOptions(this._defaultOptions);
        opts.setConnectTimeout(timeout);
        if (timeout > 0) {
            opts.setConnectDelay(-1);
        }
        return this.connectToSocket(peer, opts);
    }

    private Socket connectToSocket(Destination peer, I2PSocketOptions options) throws IOException {
        try {
            I2PSocket sock = this.connect(peer, options);
            return new StandardSocket(sock);
        }
        catch (I2PException i2pe) {
            IOException ioe = new IOException("connect fail");
            ioe.initCause(i2pe);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySocketManager() {
        if (!this._isDestroyed.compareAndSet(false, true)) {
            this._log.logCloseLoop(new Object[]{"I2PSocketManager", this.getName()});
            return;
        }
        this._connectionManager.setAllowIncomingConnections(false);
        this._connectionManager.shutdown();
        if (!this._subsessions.isEmpty()) {
            for (I2PSession sess : this._subsessions) {
                this.removeSubsession(sess);
            }
        }
        if (this._session != null && !this._session.isClosed()) {
            try {
                this._session.destroySession();
            }
            catch (I2PSessionException ise) {
                this._log.warn("Unable to destroy the session", (Throwable)ise);
            }
            PcapWriter pcap = null;
            Object object = _pcapInitLock;
            synchronized (object) {
                pcap = pcapWriter;
            }
            if (pcap != null) {
                pcap.flush();
            }
        }
    }

    public boolean isDestroyed() {
        return this._isDestroyed.get();
    }

    public Set<I2PSocket> listSockets() {
        Set<Connection> connections = this._connectionManager.listConnections();
        HashSet<I2PSocket> rv = new HashSet<I2PSocket>(connections.size());
        for (Connection con : connections) {
            if (con.getSocket() == null) continue;
            rv.add(con.getSocket());
        }
        return rv;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void addDisconnectListener(I2PSocketManager.DisconnectListener lsnr) {
        this._connectionManager.getMessageHandler().addDisconnectListener(lsnr);
    }

    public void removeDisconnectListener(I2PSocketManager.DisconnectListener lsnr) {
        this._connectionManager.getMessageHandler().removeDisconnectListener(lsnr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void debugInit(I2PAppContext ctx) {
        if (!ctx.getBooleanProperty(PROP_PCAP)) {
            return;
        }
        Object object = _pcapInitLock;
        synchronized (object) {
            if (!_pcapInitialized) {
                try {
                    pcapWriter = new PcapWriter(ctx, PCAP_FILE);
                }
                catch (IOException ioe) {
                    System.err.println("pcap init ioe: " + ioe);
                }
                _pcapInitialized = true;
            }
        }
    }

    static {
        Hash h;
        String s;
        int i;
        __managerId = new AtomicInteger();
        _ecUnsupported = new HashSet<Hash>(16);
        EC_UNSUPPORTED_HASHES = new String[]{"Cvs1gCZTTkgD2Z2byh2J9atPmh5~I8~L7BNQnQl0hUE=", "WCXV87RdrF6j-mnn6qt7kVSBifHTlPL0PmVMFWwaolo=", "yy2hYtqqfl84N9skwdRkeM7baFMXHKyDWU3XRShlEo8=", "3t5Ar2NCTIOId70uzX2bZyJljR0aBogxMEzNyHirB7A=", "9vaoGZbOaeqdRK2qEunlwRM9mUSW-I9R4OON35TDKK4=", "5rjezx4McFk3bNhoJV-NTLlQW1AR~jiUcN6DOWMCCVc=", "qwtgoFoMSK0TOtbT4ovBX1jHUzCoZCPzrJVxjKD7RCg=", "X5VDzYaoX9-P6bAWnrVSR5seGLkOeORP2l3Mh4drXPo=", "VXwmNIwMy1BcUVmut0oZ72jbWoqFzvxJukmS-G8kAAE=", "DoyMyUUgOSTddvRpqYfKHFPPjkkX~iQmResyfjjBYWs=", "xMxC54BFgyp-~zzrQI3F8m2CK--9XMcNmSAep6RH4Kk=", "zsu3WF~QLBxZXH-gHq9MuZE6y8ROZmMF7dA2MbMMKkY=", "EVkFgKkrDKyGfI7TIuDmlHoAmvHC~FbnY946DfujR0A=", "im9gytzKT15mT1sB5LC9bHXCcwytQ4EPcrGQhoam-4w="};
        _edUnsupported = new HashSet<Hash>(16);
        ED_UNSUPPORTED_HASHES = new String[]{"Cvs1gCZTTkgD2Z2byh2J9atPmh5~I8~L7BNQnQl0hUE=", "WCXV87RdrF6j-mnn6qt7kVSBifHTlPL0PmVMFWwaolo=", "9vaoGZbOaeqdRK2qEunlwRM9mUSW-I9R4OON35TDKK4=", "5rjezx4McFk3bNhoJV-NTLlQW1AR~jiUcN6DOWMCCVc=", "qwtgoFoMSK0TOtbT4ovBX1jHUzCoZCPzrJVxjKD7RCg=", "X5VDzYaoX9-P6bAWnrVSR5seGLkOeORP2l3Mh4drXPo=", "VXwmNIwMy1BcUVmut0oZ72jbWoqFzvxJukmS-G8kAAE=", "DoyMyUUgOSTddvRpqYfKHFPPjkkX~iQmResyfjjBYWs=", "xMxC54BFgyp-~zzrQI3F8m2CK--9XMcNmSAep6RH4Kk=", "EVkFgKkrDKyGfI7TIuDmlHoAmvHC~FbnY946DfujR0A=", "im9gytzKT15mT1sB5LC9bHXCcwytQ4EPcrGQhoam-4w="};
        for (i = 0; i < EC_UNSUPPORTED_HASHES.length; ++i) {
            s = EC_UNSUPPORTED_HASHES[i];
            h = ConvertToHash.getHash((String)s);
            if (h != null) {
                _ecUnsupported.add(h);
                continue;
            }
            System.out.println("Bad hash " + s);
        }
        for (i = 0; i < ED_UNSUPPORTED_HASHES.length; ++i) {
            s = ED_UNSUPPORTED_HASHES[i];
            h = ConvertToHash.getHash((String)s);
            if (h != null) {
                _edUnsupported.add(h);
                continue;
            }
            System.out.println("Bad hash " + s);
        }
        _userDsaList = "";
        _userDsaOnly = new ConcurrentHashSet(4);
        _pcapInitLock = new Object();
    }
}

