/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util.collections;

import java.util.HashMap;
import java.util.Map;

final class PackedMap<K> {
    private long[] values = new long[16];
    private Object[] keys = new Object[16];
    private final Map<K, Integer> mapKeys = new HashMap<K, Integer>();
    private int size = 0;

    PackedMap() {
    }

    public long putWithKey(int high, int low, K key) {
        long packed = PackedMap.pack(high, low);
        this.putWithKey(packed, key);
        return packed;
    }

    public void putWithKey(long element, K key) {
        Integer index = this.mapKeys.get(key);
        if (index != null) {
            int iIndex = index;
            this.values[iIndex] = element;
        } else {
            int iIndex = this.size;
            if (iIndex >= this.values.length) {
                this.resize();
            }
            this.values[iIndex] = element;
            this.keys[iIndex] = key;
            this.mapKeys.put(key, iIndex);
            ++this.size;
        }
    }

    public boolean containsKey(K key) {
        return this.mapKeys.containsKey(key);
    }

    public long getWithKey(K key) {
        Integer integer = this.mapKeys.get(key);
        if (integer == null) {
            throw new IllegalArgumentException("Key not found: " + String.valueOf(key) + " in key map. Use containsKey to check if it exists first!");
        }
        return this.values[integer];
    }

    public long get(int index) {
        return this.values[index];
    }

    public K getKey(int index) {
        return (K)this.keys[index];
    }

    private void resize() {
        long[] newVals = new long[this.size + this.size / 2];
        Object[] newKeys = new Object[this.size + this.size / 2];
        System.arraycopy(this.values, 0, newVals, 0, this.size);
        System.arraycopy(this.keys, 0, newKeys, 0, this.size);
        this.values = newVals;
        this.keys = newKeys;
    }

    public int size() {
        return this.size;
    }

    public static long pack(int high, int low) {
        return (long)low & 0xFFFFFFFFL | ((long)high & 0xFFFFFFFFL) << 32;
    }

    public static int unpackLow(long packed) {
        return (int)(packed & 0xFFFFFFFFL);
    }

    public static int unpackHigh(long packed) {
        return (int)(packed >>> 32 & 0xFFFFFFFFL);
    }
}

