/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

final class AstaDataType {
    private static final ThreadLocal<DateFormat> TIMESTAMP_FORMAT = new ThreadLocal();
    private static final ThreadLocal<DateFormat> DATE_FORMAT1 = new ThreadLocal();
    private static final ThreadLocal<DateFormat> DATE_FORMAT2 = new ThreadLocal();
    private static final ThreadLocal<DateFormat> TIME_FORMAT = new ThreadLocal();
    private static final long JAVA_EPOCH = -2208988800000L;
    private static final long ASTA_EPOCH = 2415021L;
    private static final ThreadLocal<DecimalFormat> DOUBLE_FORMAT = new ThreadLocal();

    AstaDataType() {
    }

    public static String parseString(String string) {
        if (string != null) {
            if (!string.isEmpty() && string.charAt(0) == '<') {
                string = string.substring(1, string.length() - 1);
            }
            if (!string.isEmpty() && string.charAt(0) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
        }
        return string;
    }

    public static Number parseDouble(String object) throws ParseException {
        Number number = null;
        if ((object = AstaDataType.parseString((String)object)) != null && !((String)object).isEmpty() && !((String)object).equals("-1 -1")) {
            int n = ((String)object).indexOf("E+");
            if (n != -1) {
                object = ((String)object).substring(0, n) + "E" + ((String)object).substring(n + 2, ((String)object).length());
            }
            if (((String)object).indexOf(69) != -1) {
                DecimalFormat decimalFormat = DOUBLE_FORMAT.get();
                if (decimalFormat == null) {
                    decimalFormat = new DecimalFormat("#.#E0");
                    DOUBLE_FORMAT.set(decimalFormat);
                }
                number = decimalFormat.parse((String)object);
            } else {
                number = Double.valueOf((String)object);
            }
        }
        return number;
    }

    public static Boolean parseBoolean(String string) throws ParseException {
        Boolean bl = null;
        Integer n = AstaDataType.parseInteger(string);
        if (n != null) {
            bl = n == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return bl;
    }

    public static Integer parseInteger(String string) throws ParseException {
        Integer n = null;
        if (string.length() > 0 && string.indexOf(32) == -1) {
            if (string.indexOf(46) == -1) {
                n = Integer.valueOf(string);
            } else {
                Number number = AstaDataType.parseDouble(string);
                n = number.intValue();
            }
        }
        return n;
    }

    public static Date parseEpochTimestamp(String object) {
        Date date = null;
        if (((String)object).length() > 0 && !((String)object).equals("-1 -1")) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(-2208988800000L);
            int n = ((String)object).indexOf(32);
            if (n == -1) {
                if (((String)object).length() < 6) {
                    object = "000000" + (String)object;
                    object = ((String)object).substring(((String)object).length() - 6);
                }
                int n2 = Integer.parseInt(((String)object).substring(0, 2));
                int n3 = Integer.parseInt(((String)object).substring(2, 4));
                int n4 = Integer.parseInt(((String)object).substring(4));
                calendar.set(10, n2);
                calendar.set(12, n3);
                calendar.set(13, n4);
            } else {
                long l = Long.parseLong(((String)object).substring(0, n));
                int n5 = Integer.parseInt(((String)object).substring(n + 1));
                calendar.add(6, (int)(l - 2415021L));
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(10, 0);
                calendar.add(13, n5);
            }
            date = calendar.getTime();
        }
        return date;
    }

    public static Date parseBasicTimestamp(String object) throws ParseException {
        Date date = null;
        if (((String)object).length() > 0 && !((String)object).equals("-1 -1") && !((String)object).equals("0")) {
            DateFormat dateFormat;
            if (((String)object).endsWith(" 0")) {
                dateFormat = DATE_FORMAT1.get();
                if (dateFormat == null) {
                    dateFormat = new SimpleDateFormat("yyyyMMdd 0");
                    DATE_FORMAT1.set(dateFormat);
                }
            } else if (((String)object).indexOf(32) == -1) {
                dateFormat = DATE_FORMAT2.get();
                if (dateFormat == null) {
                    dateFormat = new SimpleDateFormat("yyyyMMdd");
                    DATE_FORMAT2.set(dateFormat);
                }
            } else {
                int n;
                dateFormat = TIMESTAMP_FORMAT.get();
                if (dateFormat == null) {
                    dateFormat = new SimpleDateFormat("yyyyMMdd HHmmss");
                    TIMESTAMP_FORMAT.set(dateFormat);
                }
                if ((n = ((String)object).indexOf(32) + 1) + 6 > ((String)object).length()) {
                    String string = ((String)object).substring(n);
                    object = ((String)object).substring(0, n) + "0" + string;
                }
            }
            date = dateFormat.parse((String)object);
        }
        return date;
    }

    public static Date parseBasicTime(String object) throws ParseException {
        Date date = null;
        if (((String)object).length() > 0 && !((String)object).equals("0")) {
            DateFormat dateFormat = TIME_FORMAT.get();
            if (dateFormat == null) {
                dateFormat = new SimpleDateFormat("HHmmss");
                TIME_FORMAT.set(dateFormat);
            }
            object = "000000" + (String)object;
            object = ((String)object).substring(((String)object).length() - 6);
            date = dateFormat.parse((String)object);
        }
        return date;
    }
}

