/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class MppDump {
    private static final int BUFFER_SIZE = 16;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 2) {
                System.out.println("Usage: MppDump <input mpp file name> <output text file name>");
            } else {
                System.out.println("Dump started.");
                long l = System.currentTimeMillis();
                MppDump.process(stringArray[0], stringArray[1]);
                long l2 = System.currentTimeMillis() - l;
                System.out.println("Dump completed in " + l2 + "ms");
            }
        }
        catch (Exception exception) {
            System.out.println("Caught " + exception.toString());
        }
    }

    private static void process(String string, String string2) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        PrintWriter printWriter = new PrintWriter(new FileWriter(string2));
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(fileInputStream);
        MppDump.dumpTree(printWriter, pOIFSFileSystem.getRoot(), "", true, true, null);
        fileInputStream.close();
        printWriter.flush();
        printWriter.close();
        pOIFSFileSystem.close();
    }

    private static void dumpTree(PrintWriter printWriter, DirectoryEntry directoryEntry, String string, boolean bl, boolean bl2, String string2) throws Exception {
        Iterator<Entry> iterator = directoryEntry.getEntries();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (entry instanceof DirectoryEntry) {
                Object object = string2;
                if (object != null) {
                    object = (String)object + " ";
                }
                String string3 = string + "[" + entry.getName() + "].";
                printWriter.println("start dir: " + string + entry.getName());
                MppDump.dumpTree(printWriter, (DirectoryEntry)entry, string3, bl, bl2, (String)object);
                printWriter.println("end dir: " + string + entry.getName());
                continue;
            }
            if (entry instanceof DocumentEntry) {
                if (bl) {
                    printWriter.println("start doc: " + string + entry.getName());
                    long l = bl2 ? MppDump.hexdump(new DocumentInputStream((DocumentEntry)entry), printWriter) : MppDump.asciidump(new DocumentInputStream((DocumentEntry)entry), printWriter);
                    printWriter.println("end doc: " + string + entry.getName() + " (" + l + " bytes read)");
                    continue;
                }
                if (string2 != null) {
                    printWriter.print(string2);
                }
                printWriter.println("doc: " + string + entry.getName());
                continue;
            }
            printWriter.println("found unknown: " + string + entry.getName());
        }
    }

    private static long hexdump(InputStream inputStream, PrintWriter printWriter) throws Exception {
        int n;
        byte[] byArray = new byte[16];
        long l = 0L;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = inputStream.read(byArray)) != -1) {
            int n2;
            l += (long)n;
            stringBuilder.setLength(0);
            for (n2 = 0; n2 < n; ++n2) {
                stringBuilder.append(" ");
                stringBuilder.append(HEX_DIGITS[(byArray[n2] & 0xF0) >> 4]);
                stringBuilder.append(HEX_DIGITS[byArray[n2] & 0xF]);
            }
            while (n2 < 16) {
                stringBuilder.append("   ");
                ++n2;
            }
            stringBuilder.append("   ");
            for (n2 = 0; n2 < n; ++n2) {
                char c = (char)byArray[n2];
                if (c > '\u00c8' || c < '\u001b') {
                    c = ' ';
                }
                stringBuilder.append(c);
            }
            printWriter.println(stringBuilder.toString());
        }
        return l;
    }

    private static long asciidump(InputStream inputStream, PrintWriter printWriter) throws Exception {
        int n;
        byte[] byArray = new byte[16];
        long l = 0L;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = inputStream.read(byArray)) != -1) {
            l += (long)n;
            stringBuilder.setLength(0);
            for (int i = 0; i < n; ++i) {
                char c = (char)byArray[i];
                if (c > '\u00c8' || c < '\u001b') {
                    c = ' ';
                }
                stringBuilder.append(c);
            }
            printWriter.print(stringBuilder.toString());
        }
        return l;
    }
}

