/* Autogenerated: unsaturated_solinas --static --use-value-barrier secp521r1 64 9 '2^521 - 1' */
/* curve description: secp521r1 */
/* machine_wordsize = 64 (from "64") */
/* requested operations: (all) */
/* n = 9 (from "9") */
/* s-c = 2^521 - [(1, 1)] (from "2^521 - 1") */
/* tight_bounds_multiplier = 1 (from "") */
/*  */
/* Computed values: */
/*   carry_chain = [0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1] */
/*   eval z = z[0] + (z[1] << 58) + (z[2] << 116) + (z[3] << 174) + (z[4] << 232) + (z[5] << 0x122) + (z[6] << 0x15c) + (z[7] << 0x196) + (z[8] << 0x1d0) */
/*   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) + (z[48] << 0x180) + (z[49] << 0x188) + (z[50] << 0x190) + (z[51] << 0x198) + (z[52] << 0x1a0) + (z[53] << 0x1a8) + (z[54] << 0x1b0) + (z[55] << 0x1b8) + (z[56] << 0x1c0) + (z[57] << 0x1c8) + (z[58] << 0x1d0) + (z[59] << 0x1d8) + (z[60] << 0x1e0) + (z[61] << 0x1e8) + (z[62] << 0x1f0) + (z[63] << 0x1f8) + (z[64] << 2^9) + (z[65] << 0x208) */
/*   balance = [0x7fffffffffffffe, 0x7fffffffffffffe, 0x7fffffffffffffe, 0x7fffffffffffffe, 0x7fffffffffffffe, 0x7fffffffffffffe, 0x7fffffffffffffe, 0x7fffffffffffffe, 0x3fffffffffffffe] */

#include <stdint.h>
typedef unsigned char fiat_secp521r1_uint1;
typedef signed char fiat_secp521r1_int1;
// Pedantic warnings can be disabled by adding prefix __extension__.
__extension__ typedef __int128_t fiat_secp521r1_int128;
__extension__ typedef __uint128_t fiat_secp521r1_uint128;

/* The type fiat_secp521r1_loose_field_element is a field element with loose bounds. */
/* Bounds: [[0x0 ~> 0xc00000000000000], [0x0 ~> 0xc00000000000000], [0x0 ~> 0xc00000000000000], [0x0 ~> 0xc00000000000000], [0x0 ~> 0xc00000000000000], [0x0 ~> 0xc00000000000000], [0x0 ~> 0xc00000000000000], [0x0 ~> 0xc00000000000000], [0x0 ~> 0x600000000000000]] */
typedef uint64_t fiat_secp521r1_loose_field_element[9];

/* The type fiat_secp521r1_tight_field_element is a field element with tight bounds. */
/* Bounds: [[0x0 ~> 0x400000000000000], [0x0 ~> 0x400000000000000], [0x0 ~> 0x400000000000000], [0x0 ~> 0x400000000000000], [0x0 ~> 0x400000000000000], [0x0 ~> 0x400000000000000], [0x0 ~> 0x400000000000000], [0x0 ~> 0x400000000000000], [0x0 ~> 0x200000000000000]] */
typedef uint64_t fiat_secp521r1_tight_field_element[9];

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

OPENSSL_UNUSED static void fiat_secp521r1_selectznz(uint64_t out1[9],
                                     fiat_secp521r1_uint1 arg1,
                                     const uint64_t arg2[9],
                                     const uint64_t arg3[9]);
/*
 * The function fiat_secp521r1_addcarryx_u58 is an addition with carry.
 *
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^58
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^58⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x3ffffffffffffff]
 *   arg3: [0x0 ~> 0x3ffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x3ffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_secp521r1_addcarryx_u58(uint64_t *out1,
                                         fiat_secp521r1_uint1 *out2,
                                         fiat_secp521r1_uint1 arg1,
                                         uint64_t arg2, uint64_t arg3) {
    uint64_t x1;
    uint64_t x2;
    fiat_secp521r1_uint1 x3;
    x1 = ((arg1 + arg2) + arg3);
    x2 = (x1 & UINT64_C(0x3ffffffffffffff));
    x3 = (fiat_secp521r1_uint1)(x1 >> 58);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_secp521r1_subborrowx_u58 is a subtraction with borrow.
 *
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^58
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^58⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x3ffffffffffffff]
 *   arg3: [0x0 ~> 0x3ffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x3ffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_secp521r1_subborrowx_u58(uint64_t *out1,
                                          fiat_secp521r1_uint1 *out2,
                                          fiat_secp521r1_uint1 arg1,
                                          uint64_t arg2, uint64_t arg3) {
    int64_t x1;
    fiat_secp521r1_int1 x2;
    uint64_t x3;
    x1 = ((int64_t)(arg2 - (int64_t)arg1) - (int64_t)arg3);
    x2 = (fiat_secp521r1_int1)(x1 >> 58);
    x3 = (x1 & UINT64_C(0x3ffffffffffffff));
    *out1 = x3;
    *out2 = (fiat_secp521r1_uint1)(0x0 - x2);
}

/*
 * The function fiat_secp521r1_addcarryx_u57 is an addition with carry.
 *
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^57
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^57⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x1ffffffffffffff]
 *   arg3: [0x0 ~> 0x1ffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x1ffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_secp521r1_addcarryx_u57(uint64_t *out1,
                                         fiat_secp521r1_uint1 *out2,
                                         fiat_secp521r1_uint1 arg1,
                                         uint64_t arg2, uint64_t arg3) {
    uint64_t x1;
    uint64_t x2;
    fiat_secp521r1_uint1 x3;
    x1 = ((arg1 + arg2) + arg3);
    x2 = (x1 & UINT64_C(0x1ffffffffffffff));
    x3 = (fiat_secp521r1_uint1)(x1 >> 57);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_secp521r1_subborrowx_u57 is a subtraction with borrow.
 *
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^57
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^57⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x1ffffffffffffff]
 *   arg3: [0x0 ~> 0x1ffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x1ffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_secp521r1_subborrowx_u57(uint64_t *out1,
                                          fiat_secp521r1_uint1 *out2,
                                          fiat_secp521r1_uint1 arg1,
                                          uint64_t arg2, uint64_t arg3) {
    int64_t x1;
    fiat_secp521r1_int1 x2;
    uint64_t x3;
    x1 = ((int64_t)(arg2 - (int64_t)arg1) - (int64_t)arg3);
    x2 = (fiat_secp521r1_int1)(x1 >> 57);
    x3 = (x1 & UINT64_C(0x1ffffffffffffff));
    *out1 = x3;
    *out2 = (fiat_secp521r1_uint1)(0x0 - x2);
}

/*
 * The function fiat_secp521r1_cmovznz_u64 is a single-word conditional move.
 *
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_secp521r1_cmovznz_u64(uint64_t *out1,
                                       fiat_secp521r1_uint1 arg1, uint64_t arg2,
                                       uint64_t arg3) {
    fiat_secp521r1_uint1 x1;
    uint64_t x2;
    uint64_t x3;
    x1 = (!(!arg1));
    x2 = ((fiat_secp521r1_int1)(0x0 - x1) & UINT64_C(0xffffffffffffffff));
    x3 = ((value_barrier_u64(x2) & arg3) |
          (value_barrier_u64((~x2)) & arg2));
    *out1 = x3;
}

/*
 * The function fiat_secp521r1_carry_mul multiplies two field elements and reduces the result.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg2) mod m
 *
 */
static void fiat_secp521r1_carry_mul(
    fiat_secp521r1_tight_field_element out1,
    const fiat_secp521r1_loose_field_element arg1,
    const fiat_secp521r1_loose_field_element arg2) {
    fiat_secp521r1_uint128 x1;
    fiat_secp521r1_uint128 x2;
    fiat_secp521r1_uint128 x3;
    fiat_secp521r1_uint128 x4;
    fiat_secp521r1_uint128 x5;
    fiat_secp521r1_uint128 x6;
    fiat_secp521r1_uint128 x7;
    fiat_secp521r1_uint128 x8;
    fiat_secp521r1_uint128 x9;
    fiat_secp521r1_uint128 x10;
    fiat_secp521r1_uint128 x11;
    fiat_secp521r1_uint128 x12;
    fiat_secp521r1_uint128 x13;
    fiat_secp521r1_uint128 x14;
    fiat_secp521r1_uint128 x15;
    fiat_secp521r1_uint128 x16;
    fiat_secp521r1_uint128 x17;
    fiat_secp521r1_uint128 x18;
    fiat_secp521r1_uint128 x19;
    fiat_secp521r1_uint128 x20;
    fiat_secp521r1_uint128 x21;
    fiat_secp521r1_uint128 x22;
    fiat_secp521r1_uint128 x23;
    fiat_secp521r1_uint128 x24;
    fiat_secp521r1_uint128 x25;
    fiat_secp521r1_uint128 x26;
    fiat_secp521r1_uint128 x27;
    fiat_secp521r1_uint128 x28;
    fiat_secp521r1_uint128 x29;
    fiat_secp521r1_uint128 x30;
    fiat_secp521r1_uint128 x31;
    fiat_secp521r1_uint128 x32;
    fiat_secp521r1_uint128 x33;
    fiat_secp521r1_uint128 x34;
    fiat_secp521r1_uint128 x35;
    fiat_secp521r1_uint128 x36;
    fiat_secp521r1_uint128 x37;
    fiat_secp521r1_uint128 x38;
    fiat_secp521r1_uint128 x39;
    fiat_secp521r1_uint128 x40;
    fiat_secp521r1_uint128 x41;
    fiat_secp521r1_uint128 x42;
    fiat_secp521r1_uint128 x43;
    fiat_secp521r1_uint128 x44;
    fiat_secp521r1_uint128 x45;
    fiat_secp521r1_uint128 x46;
    fiat_secp521r1_uint128 x47;
    fiat_secp521r1_uint128 x48;
    fiat_secp521r1_uint128 x49;
    fiat_secp521r1_uint128 x50;
    fiat_secp521r1_uint128 x51;
    fiat_secp521r1_uint128 x52;
    fiat_secp521r1_uint128 x53;
    fiat_secp521r1_uint128 x54;
    fiat_secp521r1_uint128 x55;
    fiat_secp521r1_uint128 x56;
    fiat_secp521r1_uint128 x57;
    fiat_secp521r1_uint128 x58;
    fiat_secp521r1_uint128 x59;
    fiat_secp521r1_uint128 x60;
    fiat_secp521r1_uint128 x61;
    fiat_secp521r1_uint128 x62;
    fiat_secp521r1_uint128 x63;
    fiat_secp521r1_uint128 x64;
    fiat_secp521r1_uint128 x65;
    fiat_secp521r1_uint128 x66;
    fiat_secp521r1_uint128 x67;
    fiat_secp521r1_uint128 x68;
    fiat_secp521r1_uint128 x69;
    fiat_secp521r1_uint128 x70;
    fiat_secp521r1_uint128 x71;
    fiat_secp521r1_uint128 x72;
    fiat_secp521r1_uint128 x73;
    fiat_secp521r1_uint128 x74;
    fiat_secp521r1_uint128 x75;
    fiat_secp521r1_uint128 x76;
    fiat_secp521r1_uint128 x77;
    fiat_secp521r1_uint128 x78;
    fiat_secp521r1_uint128 x79;
    fiat_secp521r1_uint128 x80;
    fiat_secp521r1_uint128 x81;
    fiat_secp521r1_uint128 x82;
    fiat_secp521r1_uint128 x83;
    uint64_t x84;
    fiat_secp521r1_uint128 x85;
    fiat_secp521r1_uint128 x86;
    fiat_secp521r1_uint128 x87;
    fiat_secp521r1_uint128 x88;
    fiat_secp521r1_uint128 x89;
    fiat_secp521r1_uint128 x90;
    fiat_secp521r1_uint128 x91;
    fiat_secp521r1_uint128 x92;
    fiat_secp521r1_uint128 x93;
    fiat_secp521r1_uint128 x94;
    uint64_t x95;
    fiat_secp521r1_uint128 x96;
    fiat_secp521r1_uint128 x97;
    uint64_t x98;
    fiat_secp521r1_uint128 x99;
    fiat_secp521r1_uint128 x100;
    uint64_t x101;
    fiat_secp521r1_uint128 x102;
    fiat_secp521r1_uint128 x103;
    uint64_t x104;
    fiat_secp521r1_uint128 x105;
    fiat_secp521r1_uint128 x106;
    uint64_t x107;
    fiat_secp521r1_uint128 x108;
    fiat_secp521r1_uint128 x109;
    uint64_t x110;
    fiat_secp521r1_uint128 x111;
    fiat_secp521r1_uint128 x112;
    uint64_t x113;
    fiat_secp521r1_uint128 x114;
    fiat_secp521r1_uint128 x115;
    uint64_t x116;
    fiat_secp521r1_uint128 x117;
    uint64_t x118;
    uint64_t x119;
    uint64_t x120;
    fiat_secp521r1_uint1 x121;
    uint64_t x122;
    uint64_t x123;
    x1 = ((fiat_secp521r1_uint128)(arg1[8]) * ((arg2[8]) * 0x2));
    x2 = ((fiat_secp521r1_uint128)(arg1[8]) * ((arg2[7]) * 0x2));
    x3 = ((fiat_secp521r1_uint128)(arg1[8]) * ((arg2[6]) * 0x2));
    x4 = ((fiat_secp521r1_uint128)(arg1[8]) * ((arg2[5]) * 0x2));
    x5 = ((fiat_secp521r1_uint128)(arg1[8]) * ((arg2[4]) * 0x2));
    x6 = ((fiat_secp521r1_uint128)(arg1[8]) * ((arg2[3]) * 0x2));
    x7 = ((fiat_secp521r1_uint128)(arg1[8]) * ((arg2[2]) * 0x2));
    x8 = ((fiat_secp521r1_uint128)(arg1[8]) * ((arg2[1]) * 0x2));
    x9 = ((fiat_secp521r1_uint128)(arg1[7]) * ((arg2[8]) * 0x2));
    x10 = ((fiat_secp521r1_uint128)(arg1[7]) * ((arg2[7]) * 0x2));
    x11 = ((fiat_secp521r1_uint128)(arg1[7]) * ((arg2[6]) * 0x2));
    x12 = ((fiat_secp521r1_uint128)(arg1[7]) * ((arg2[5]) * 0x2));
    x13 = ((fiat_secp521r1_uint128)(arg1[7]) * ((arg2[4]) * 0x2));
    x14 = ((fiat_secp521r1_uint128)(arg1[7]) * ((arg2[3]) * 0x2));
    x15 = ((fiat_secp521r1_uint128)(arg1[7]) * ((arg2[2]) * 0x2));
    x16 = ((fiat_secp521r1_uint128)(arg1[6]) * ((arg2[8]) * 0x2));
    x17 = ((fiat_secp521r1_uint128)(arg1[6]) * ((arg2[7]) * 0x2));
    x18 = ((fiat_secp521r1_uint128)(arg1[6]) * ((arg2[6]) * 0x2));
    x19 = ((fiat_secp521r1_uint128)(arg1[6]) * ((arg2[5]) * 0x2));
    x20 = ((fiat_secp521r1_uint128)(arg1[6]) * ((arg2[4]) * 0x2));
    x21 = ((fiat_secp521r1_uint128)(arg1[6]) * ((arg2[3]) * 0x2));
    x22 = ((fiat_secp521r1_uint128)(arg1[5]) * ((arg2[8]) * 0x2));
    x23 = ((fiat_secp521r1_uint128)(arg1[5]) * ((arg2[7]) * 0x2));
    x24 = ((fiat_secp521r1_uint128)(arg1[5]) * ((arg2[6]) * 0x2));
    x25 = ((fiat_secp521r1_uint128)(arg1[5]) * ((arg2[5]) * 0x2));
    x26 = ((fiat_secp521r1_uint128)(arg1[5]) * ((arg2[4]) * 0x2));
    x27 = ((fiat_secp521r1_uint128)(arg1[4]) * ((arg2[8]) * 0x2));
    x28 = ((fiat_secp521r1_uint128)(arg1[4]) * ((arg2[7]) * 0x2));
    x29 = ((fiat_secp521r1_uint128)(arg1[4]) * ((arg2[6]) * 0x2));
    x30 = ((fiat_secp521r1_uint128)(arg1[4]) * ((arg2[5]) * 0x2));
    x31 = ((fiat_secp521r1_uint128)(arg1[3]) * ((arg2[8]) * 0x2));
    x32 = ((fiat_secp521r1_uint128)(arg1[3]) * ((arg2[7]) * 0x2));
    x33 = ((fiat_secp521r1_uint128)(arg1[3]) * ((arg2[6]) * 0x2));
    x34 = ((fiat_secp521r1_uint128)(arg1[2]) * ((arg2[8]) * 0x2));
    x35 = ((fiat_secp521r1_uint128)(arg1[2]) * ((arg2[7]) * 0x2));
    x36 = ((fiat_secp521r1_uint128)(arg1[1]) * ((arg2[8]) * 0x2));
    x37 = ((fiat_secp521r1_uint128)(arg1[8]) * (arg2[0]));
    x38 = ((fiat_secp521r1_uint128)(arg1[7]) * (arg2[1]));
    x39 = ((fiat_secp521r1_uint128)(arg1[7]) * (arg2[0]));
    x40 = ((fiat_secp521r1_uint128)(arg1[6]) * (arg2[2]));
    x41 = ((fiat_secp521r1_uint128)(arg1[6]) * (arg2[1]));
    x42 = ((fiat_secp521r1_uint128)(arg1[6]) * (arg2[0]));
    x43 = ((fiat_secp521r1_uint128)(arg1[5]) * (arg2[3]));
    x44 = ((fiat_secp521r1_uint128)(arg1[5]) * (arg2[2]));
    x45 = ((fiat_secp521r1_uint128)(arg1[5]) * (arg2[1]));
    x46 = ((fiat_secp521r1_uint128)(arg1[5]) * (arg2[0]));
    x47 = ((fiat_secp521r1_uint128)(arg1[4]) * (arg2[4]));
    x48 = ((fiat_secp521r1_uint128)(arg1[4]) * (arg2[3]));
    x49 = ((fiat_secp521r1_uint128)(arg1[4]) * (arg2[2]));
    x50 = ((fiat_secp521r1_uint128)(arg1[4]) * (arg2[1]));
    x51 = ((fiat_secp521r1_uint128)(arg1[4]) * (arg2[0]));
    x52 = ((fiat_secp521r1_uint128)(arg1[3]) * (arg2[5]));
    x53 = ((fiat_secp521r1_uint128)(arg1[3]) * (arg2[4]));
    x54 = ((fiat_secp521r1_uint128)(arg1[3]) * (arg2[3]));
    x55 = ((fiat_secp521r1_uint128)(arg1[3]) * (arg2[2]));
    x56 = ((fiat_secp521r1_uint128)(arg1[3]) * (arg2[1]));
    x57 = ((fiat_secp521r1_uint128)(arg1[3]) * (arg2[0]));
    x58 = ((fiat_secp521r1_uint128)(arg1[2]) * (arg2[6]));
    x59 = ((fiat_secp521r1_uint128)(arg1[2]) * (arg2[5]));
    x60 = ((fiat_secp521r1_uint128)(arg1[2]) * (arg2[4]));
    x61 = ((fiat_secp521r1_uint128)(arg1[2]) * (arg2[3]));
    x62 = ((fiat_secp521r1_uint128)(arg1[2]) * (arg2[2]));
    x63 = ((fiat_secp521r1_uint128)(arg1[2]) * (arg2[1]));
    x64 = ((fiat_secp521r1_uint128)(arg1[2]) * (arg2[0]));
    x65 = ((fiat_secp521r1_uint128)(arg1[1]) * (arg2[7]));
    x66 = ((fiat_secp521r1_uint128)(arg1[1]) * (arg2[6]));
    x67 = ((fiat_secp521r1_uint128)(arg1[1]) * (arg2[5]));
    x68 = ((fiat_secp521r1_uint128)(arg1[1]) * (arg2[4]));
    x69 = ((fiat_secp521r1_uint128)(arg1[1]) * (arg2[3]));
    x70 = ((fiat_secp521r1_uint128)(arg1[1]) * (arg2[2]));
    x71 = ((fiat_secp521r1_uint128)(arg1[1]) * (arg2[1]));
    x72 = ((fiat_secp521r1_uint128)(arg1[1]) * (arg2[0]));
    x73 = ((fiat_secp521r1_uint128)(arg1[0]) * (arg2[8]));
    x74 = ((fiat_secp521r1_uint128)(arg1[0]) * (arg2[7]));
    x75 = ((fiat_secp521r1_uint128)(arg1[0]) * (arg2[6]));
    x76 = ((fiat_secp521r1_uint128)(arg1[0]) * (arg2[5]));
    x77 = ((fiat_secp521r1_uint128)(arg1[0]) * (arg2[4]));
    x78 = ((fiat_secp521r1_uint128)(arg1[0]) * (arg2[3]));
    x79 = ((fiat_secp521r1_uint128)(arg1[0]) * (arg2[2]));
    x80 = ((fiat_secp521r1_uint128)(arg1[0]) * (arg2[1]));
    x81 = ((fiat_secp521r1_uint128)(arg1[0]) * (arg2[0]));
    x82 = (x81 + (x36 + (x35 + (x33 + (x30 + (x26 + (x21 + (x15 + x8))))))));
    x83 = (x82 >> 58);
    x84 = (uint64_t)(x82 & UINT64_C(0x3ffffffffffffff));
    x85 = (x73 + (x65 + (x58 + (x52 + (x47 + (x43 + (x40 + (x38 + x37))))))));
    x86 = (x74 + (x66 + (x59 + (x53 + (x48 + (x44 + (x41 + (x39 + x1))))))));
    x87 = (x75 + (x67 + (x60 + (x54 + (x49 + (x45 + (x42 + (x9 + x2))))))));
    x88 = (x76 + (x68 + (x61 + (x55 + (x50 + (x46 + (x16 + (x10 + x3))))))));
    x89 = (x77 + (x69 + (x62 + (x56 + (x51 + (x22 + (x17 + (x11 + x4))))))));
    x90 = (x78 + (x70 + (x63 + (x57 + (x27 + (x23 + (x18 + (x12 + x5))))))));
    x91 = (x79 + (x71 + (x64 + (x31 + (x28 + (x24 + (x19 + (x13 + x6))))))));
    x92 = (x80 + (x72 + (x34 + (x32 + (x29 + (x25 + (x20 + (x14 + x7))))))));
    x93 = (x83 + x92);
    x94 = (x93 >> 58);
    x95 = (uint64_t)(x93 & UINT64_C(0x3ffffffffffffff));
    x96 = (x94 + x91);
    x97 = (x96 >> 58);
    x98 = (uint64_t)(x96 & UINT64_C(0x3ffffffffffffff));
    x99 = (x97 + x90);
    x100 = (x99 >> 58);
    x101 = (uint64_t)(x99 & UINT64_C(0x3ffffffffffffff));
    x102 = (x100 + x89);
    x103 = (x102 >> 58);
    x104 = (uint64_t)(x102 & UINT64_C(0x3ffffffffffffff));
    x105 = (x103 + x88);
    x106 = (x105 >> 58);
    x107 = (uint64_t)(x105 & UINT64_C(0x3ffffffffffffff));
    x108 = (x106 + x87);
    x109 = (x108 >> 58);
    x110 = (uint64_t)(x108 & UINT64_C(0x3ffffffffffffff));
    x111 = (x109 + x86);
    x112 = (x111 >> 58);
    x113 = (uint64_t)(x111 & UINT64_C(0x3ffffffffffffff));
    x114 = (x112 + x85);
    x115 = (x114 >> 57);
    x116 = (uint64_t)(x114 & UINT64_C(0x1ffffffffffffff));
    x117 = (x84 + x115);
    x118 = (uint64_t)(x117 >> 58);
    x119 = (uint64_t)(x117 & UINT64_C(0x3ffffffffffffff));
    x120 = (x118 + x95);
    x121 = (fiat_secp521r1_uint1)(x120 >> 58);
    x122 = (x120 & UINT64_C(0x3ffffffffffffff));
    x123 = (x121 + x98);
    out1[0] = x119;
    out1[1] = x122;
    out1[2] = x123;
    out1[3] = x101;
    out1[4] = x104;
    out1[5] = x107;
    out1[6] = x110;
    out1[7] = x113;
    out1[8] = x116;
}

/*
 * The function fiat_secp521r1_carry_square squares a field element and reduces the result.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg1) mod m
 *
 */
static void fiat_secp521r1_carry_square(
    fiat_secp521r1_tight_field_element out1,
    const fiat_secp521r1_loose_field_element arg1) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint64_t x16;
    fiat_secp521r1_uint128 x17;
    fiat_secp521r1_uint128 x18;
    fiat_secp521r1_uint128 x19;
    fiat_secp521r1_uint128 x20;
    fiat_secp521r1_uint128 x21;
    fiat_secp521r1_uint128 x22;
    fiat_secp521r1_uint128 x23;
    fiat_secp521r1_uint128 x24;
    fiat_secp521r1_uint128 x25;
    fiat_secp521r1_uint128 x26;
    fiat_secp521r1_uint128 x27;
    fiat_secp521r1_uint128 x28;
    fiat_secp521r1_uint128 x29;
    fiat_secp521r1_uint128 x30;
    fiat_secp521r1_uint128 x31;
    fiat_secp521r1_uint128 x32;
    fiat_secp521r1_uint128 x33;
    fiat_secp521r1_uint128 x34;
    fiat_secp521r1_uint128 x35;
    fiat_secp521r1_uint128 x36;
    fiat_secp521r1_uint128 x37;
    fiat_secp521r1_uint128 x38;
    fiat_secp521r1_uint128 x39;
    fiat_secp521r1_uint128 x40;
    fiat_secp521r1_uint128 x41;
    fiat_secp521r1_uint128 x42;
    fiat_secp521r1_uint128 x43;
    fiat_secp521r1_uint128 x44;
    fiat_secp521r1_uint128 x45;
    fiat_secp521r1_uint128 x46;
    fiat_secp521r1_uint128 x47;
    fiat_secp521r1_uint128 x48;
    fiat_secp521r1_uint128 x49;
    fiat_secp521r1_uint128 x50;
    fiat_secp521r1_uint128 x51;
    fiat_secp521r1_uint128 x52;
    fiat_secp521r1_uint128 x53;
    fiat_secp521r1_uint128 x54;
    fiat_secp521r1_uint128 x55;
    fiat_secp521r1_uint128 x56;
    fiat_secp521r1_uint128 x57;
    fiat_secp521r1_uint128 x58;
    fiat_secp521r1_uint128 x59;
    fiat_secp521r1_uint128 x60;
    fiat_secp521r1_uint128 x61;
    fiat_secp521r1_uint128 x62;
    fiat_secp521r1_uint128 x63;
    uint64_t x64;
    fiat_secp521r1_uint128 x65;
    fiat_secp521r1_uint128 x66;
    fiat_secp521r1_uint128 x67;
    fiat_secp521r1_uint128 x68;
    fiat_secp521r1_uint128 x69;
    fiat_secp521r1_uint128 x70;
    fiat_secp521r1_uint128 x71;
    fiat_secp521r1_uint128 x72;
    fiat_secp521r1_uint128 x73;
    fiat_secp521r1_uint128 x74;
    uint64_t x75;
    fiat_secp521r1_uint128 x76;
    fiat_secp521r1_uint128 x77;
    uint64_t x78;
    fiat_secp521r1_uint128 x79;
    fiat_secp521r1_uint128 x80;
    uint64_t x81;
    fiat_secp521r1_uint128 x82;
    fiat_secp521r1_uint128 x83;
    uint64_t x84;
    fiat_secp521r1_uint128 x85;
    fiat_secp521r1_uint128 x86;
    uint64_t x87;
    fiat_secp521r1_uint128 x88;
    fiat_secp521r1_uint128 x89;
    uint64_t x90;
    fiat_secp521r1_uint128 x91;
    fiat_secp521r1_uint128 x92;
    uint64_t x93;
    fiat_secp521r1_uint128 x94;
    fiat_secp521r1_uint128 x95;
    uint64_t x96;
    fiat_secp521r1_uint128 x97;
    uint64_t x98;
    uint64_t x99;
    uint64_t x100;
    fiat_secp521r1_uint1 x101;
    uint64_t x102;
    uint64_t x103;
    x1 = (arg1[8]);
    x2 = (x1 * 0x2);
    x3 = ((arg1[8]) * 0x2);
    x4 = (arg1[7]);
    x5 = (x4 * 0x2);
    x6 = ((arg1[7]) * 0x2);
    x7 = (arg1[6]);
    x8 = (x7 * 0x2);
    x9 = ((arg1[6]) * 0x2);
    x10 = (arg1[5]);
    x11 = (x10 * 0x2);
    x12 = ((arg1[5]) * 0x2);
    x13 = ((arg1[4]) * 0x2);
    x14 = ((arg1[3]) * 0x2);
    x15 = ((arg1[2]) * 0x2);
    x16 = ((arg1[1]) * 0x2);
    x17 = ((fiat_secp521r1_uint128)(arg1[8]) * (x1 * 0x2));
    x18 = ((fiat_secp521r1_uint128)(arg1[7]) * (x2 * 0x2));
    x19 = ((fiat_secp521r1_uint128)(arg1[7]) * (x4 * 0x2));
    x20 = ((fiat_secp521r1_uint128)(arg1[6]) * (x2 * 0x2));
    x21 = ((fiat_secp521r1_uint128)(arg1[6]) * (x5 * 0x2));
    x22 = ((fiat_secp521r1_uint128)(arg1[6]) * (x7 * 0x2));
    x23 = ((fiat_secp521r1_uint128)(arg1[5]) * (x2 * 0x2));
    x24 = ((fiat_secp521r1_uint128)(arg1[5]) * (x5 * 0x2));
    x25 = ((fiat_secp521r1_uint128)(arg1[5]) * (x8 * 0x2));
    x26 = ((fiat_secp521r1_uint128)(arg1[5]) * (x10 * 0x2));
    x27 = ((fiat_secp521r1_uint128)(arg1[4]) * (x2 * 0x2));
    x28 = ((fiat_secp521r1_uint128)(arg1[4]) * (x5 * 0x2));
    x29 = ((fiat_secp521r1_uint128)(arg1[4]) * (x8 * 0x2));
    x30 = ((fiat_secp521r1_uint128)(arg1[4]) * (x11 * 0x2));
    x31 = ((fiat_secp521r1_uint128)(arg1[4]) * (arg1[4]));
    x32 = ((fiat_secp521r1_uint128)(arg1[3]) * (x2 * 0x2));
    x33 = ((fiat_secp521r1_uint128)(arg1[3]) * (x5 * 0x2));
    x34 = ((fiat_secp521r1_uint128)(arg1[3]) * (x8 * 0x2));
    x35 = ((fiat_secp521r1_uint128)(arg1[3]) * x12);
    x36 = ((fiat_secp521r1_uint128)(arg1[3]) * x13);
    x37 = ((fiat_secp521r1_uint128)(arg1[3]) * (arg1[3]));
    x38 = ((fiat_secp521r1_uint128)(arg1[2]) * (x2 * 0x2));
    x39 = ((fiat_secp521r1_uint128)(arg1[2]) * (x5 * 0x2));
    x40 = ((fiat_secp521r1_uint128)(arg1[2]) * x9);
    x41 = ((fiat_secp521r1_uint128)(arg1[2]) * x12);
    x42 = ((fiat_secp521r1_uint128)(arg1[2]) * x13);
    x43 = ((fiat_secp521r1_uint128)(arg1[2]) * x14);
    x44 = ((fiat_secp521r1_uint128)(arg1[2]) * (arg1[2]));
    x45 = ((fiat_secp521r1_uint128)(arg1[1]) * (x2 * 0x2));
    x46 = ((fiat_secp521r1_uint128)(arg1[1]) * x6);
    x47 = ((fiat_secp521r1_uint128)(arg1[1]) * x9);
    x48 = ((fiat_secp521r1_uint128)(arg1[1]) * x12);
    x49 = ((fiat_secp521r1_uint128)(arg1[1]) * x13);
    x50 = ((fiat_secp521r1_uint128)(arg1[1]) * x14);
    x51 = ((fiat_secp521r1_uint128)(arg1[1]) * x15);
    x52 = ((fiat_secp521r1_uint128)(arg1[1]) * (arg1[1]));
    x53 = ((fiat_secp521r1_uint128)(arg1[0]) * x3);
    x54 = ((fiat_secp521r1_uint128)(arg1[0]) * x6);
    x55 = ((fiat_secp521r1_uint128)(arg1[0]) * x9);
    x56 = ((fiat_secp521r1_uint128)(arg1[0]) * x12);
    x57 = ((fiat_secp521r1_uint128)(arg1[0]) * x13);
    x58 = ((fiat_secp521r1_uint128)(arg1[0]) * x14);
    x59 = ((fiat_secp521r1_uint128)(arg1[0]) * x15);
    x60 = ((fiat_secp521r1_uint128)(arg1[0]) * x16);
    x61 = ((fiat_secp521r1_uint128)(arg1[0]) * (arg1[0]));
    x62 = (x61 + (x45 + (x39 + (x34 + x30))));
    x63 = (x62 >> 58);
    x64 = (uint64_t)(x62 & UINT64_C(0x3ffffffffffffff));
    x65 = (x53 + (x46 + (x40 + (x35 + x31))));
    x66 = (x54 + (x47 + (x41 + (x36 + x17))));
    x67 = (x55 + (x48 + (x42 + (x37 + x18))));
    x68 = (x56 + (x49 + (x43 + (x20 + x19))));
    x69 = (x57 + (x50 + (x44 + (x23 + x21))));
    x70 = (x58 + (x51 + (x27 + (x24 + x22))));
    x71 = (x59 + (x52 + (x32 + (x28 + x25))));
    x72 = (x60 + (x38 + (x33 + (x29 + x26))));
    x73 = (x63 + x72);
    x74 = (x73 >> 58);
    x75 = (uint64_t)(x73 & UINT64_C(0x3ffffffffffffff));
    x76 = (x74 + x71);
    x77 = (x76 >> 58);
    x78 = (uint64_t)(x76 & UINT64_C(0x3ffffffffffffff));
    x79 = (x77 + x70);
    x80 = (x79 >> 58);
    x81 = (uint64_t)(x79 & UINT64_C(0x3ffffffffffffff));
    x82 = (x80 + x69);
    x83 = (x82 >> 58);
    x84 = (uint64_t)(x82 & UINT64_C(0x3ffffffffffffff));
    x85 = (x83 + x68);
    x86 = (x85 >> 58);
    x87 = (uint64_t)(x85 & UINT64_C(0x3ffffffffffffff));
    x88 = (x86 + x67);
    x89 = (x88 >> 58);
    x90 = (uint64_t)(x88 & UINT64_C(0x3ffffffffffffff));
    x91 = (x89 + x66);
    x92 = (x91 >> 58);
    x93 = (uint64_t)(x91 & UINT64_C(0x3ffffffffffffff));
    x94 = (x92 + x65);
    x95 = (x94 >> 57);
    x96 = (uint64_t)(x94 & UINT64_C(0x1ffffffffffffff));
    x97 = (x64 + x95);
    x98 = (uint64_t)(x97 >> 58);
    x99 = (uint64_t)(x97 & UINT64_C(0x3ffffffffffffff));
    x100 = (x98 + x75);
    x101 = (fiat_secp521r1_uint1)(x100 >> 58);
    x102 = (x100 & UINT64_C(0x3ffffffffffffff));
    x103 = (x101 + x78);
    out1[0] = x99;
    out1[1] = x102;
    out1[2] = x103;
    out1[3] = x81;
    out1[4] = x84;
    out1[5] = x87;
    out1[6] = x90;
    out1[7] = x93;
    out1[8] = x96;
}

/*
 * The function fiat_secp521r1_carry reduces a field element.
 *
 * Postconditions:
 *   eval out1 mod m = eval arg1 mod m
 *
 */

/*
 * The function fiat_secp521r1_add adds two field elements.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 + eval arg2) mod m
 *
 */

/*
 * The function fiat_secp521r1_sub subtracts two field elements.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 - eval arg2) mod m
 *
 */

/*
 * The function fiat_secp521r1_opp negates a field element.
 *
 * Postconditions:
 *   eval out1 mod m = -eval arg1 mod m
 *
 */

/*
 * The function fiat_secp521r1_carry_add adds two field elements.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 + eval arg2) mod m
 *
 */
static void fiat_secp521r1_carry_add(
    fiat_secp521r1_tight_field_element out1,
    const fiat_secp521r1_tight_field_element arg1,
    const fiat_secp521r1_tight_field_element arg2) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint64_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    uint64_t x20;
    x1 = ((arg1[0]) + (arg2[0]));
    x2 = ((x1 >> 58) + ((arg1[1]) + (arg2[1])));
    x3 = ((x2 >> 58) + ((arg1[2]) + (arg2[2])));
    x4 = ((x3 >> 58) + ((arg1[3]) + (arg2[3])));
    x5 = ((x4 >> 58) + ((arg1[4]) + (arg2[4])));
    x6 = ((x5 >> 58) + ((arg1[5]) + (arg2[5])));
    x7 = ((x6 >> 58) + ((arg1[6]) + (arg2[6])));
    x8 = ((x7 >> 58) + ((arg1[7]) + (arg2[7])));
    x9 = ((x8 >> 58) + ((arg1[8]) + (arg2[8])));
    x10 = ((x1 & UINT64_C(0x3ffffffffffffff)) + (x9 >> 57));
    x11 = ((fiat_secp521r1_uint1)(x10 >> 58) +
           (x2 & UINT64_C(0x3ffffffffffffff)));
    x12 = (x10 & UINT64_C(0x3ffffffffffffff));
    x13 = (x11 & UINT64_C(0x3ffffffffffffff));
    x14 = ((fiat_secp521r1_uint1)(x11 >> 58) +
           (x3 & UINT64_C(0x3ffffffffffffff)));
    x15 = (x4 & UINT64_C(0x3ffffffffffffff));
    x16 = (x5 & UINT64_C(0x3ffffffffffffff));
    x17 = (x6 & UINT64_C(0x3ffffffffffffff));
    x18 = (x7 & UINT64_C(0x3ffffffffffffff));
    x19 = (x8 & UINT64_C(0x3ffffffffffffff));
    x20 = (x9 & UINT64_C(0x1ffffffffffffff));
    out1[0] = x12;
    out1[1] = x13;
    out1[2] = x14;
    out1[3] = x15;
    out1[4] = x16;
    out1[5] = x17;
    out1[6] = x18;
    out1[7] = x19;
    out1[8] = x20;
}

/*
 * The function fiat_secp521r1_carry_sub subtracts two field elements.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 - eval arg2) mod m
 *
 */
static void fiat_secp521r1_carry_sub(
    fiat_secp521r1_tight_field_element out1,
    const fiat_secp521r1_tight_field_element arg1,
    const fiat_secp521r1_tight_field_element arg2) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint64_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    uint64_t x20;
    x1 = ((UINT64_C(0x7fffffffffffffe) + (arg1[0])) - (arg2[0]));
    x2 = ((x1 >> 58) + ((UINT64_C(0x7fffffffffffffe) + (arg1[1])) - (arg2[1])));
    x3 = ((x2 >> 58) + ((UINT64_C(0x7fffffffffffffe) + (arg1[2])) - (arg2[2])));
    x4 = ((x3 >> 58) + ((UINT64_C(0x7fffffffffffffe) + (arg1[3])) - (arg2[3])));
    x5 = ((x4 >> 58) + ((UINT64_C(0x7fffffffffffffe) + (arg1[4])) - (arg2[4])));
    x6 = ((x5 >> 58) + ((UINT64_C(0x7fffffffffffffe) + (arg1[5])) - (arg2[5])));
    x7 = ((x6 >> 58) + ((UINT64_C(0x7fffffffffffffe) + (arg1[6])) - (arg2[6])));
    x8 = ((x7 >> 58) + ((UINT64_C(0x7fffffffffffffe) + (arg1[7])) - (arg2[7])));
    x9 = ((x8 >> 58) + ((UINT64_C(0x3fffffffffffffe) + (arg1[8])) - (arg2[8])));
    x10 = ((x1 & UINT64_C(0x3ffffffffffffff)) + (x9 >> 57));
    x11 = ((fiat_secp521r1_uint1)(x10 >> 58) +
           (x2 & UINT64_C(0x3ffffffffffffff)));
    x12 = (x10 & UINT64_C(0x3ffffffffffffff));
    x13 = (x11 & UINT64_C(0x3ffffffffffffff));
    x14 = ((fiat_secp521r1_uint1)(x11 >> 58) +
           (x3 & UINT64_C(0x3ffffffffffffff)));
    x15 = (x4 & UINT64_C(0x3ffffffffffffff));
    x16 = (x5 & UINT64_C(0x3ffffffffffffff));
    x17 = (x6 & UINT64_C(0x3ffffffffffffff));
    x18 = (x7 & UINT64_C(0x3ffffffffffffff));
    x19 = (x8 & UINT64_C(0x3ffffffffffffff));
    x20 = (x9 & UINT64_C(0x1ffffffffffffff));
    out1[0] = x12;
    out1[1] = x13;
    out1[2] = x14;
    out1[3] = x15;
    out1[4] = x16;
    out1[5] = x17;
    out1[6] = x18;
    out1[7] = x19;
    out1[8] = x20;
}

/*
 * The function fiat_secp521r1_carry_opp negates a field element.
 *
 * Postconditions:
 *   eval out1 mod m = -eval arg1 mod m
 *
 */
static void fiat_secp521r1_carry_opp(
    fiat_secp521r1_tight_field_element out1,
    const fiat_secp521r1_tight_field_element arg1) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint64_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    uint64_t x20;
    x1 = (UINT64_C(0x7fffffffffffffe) - (arg1[0]));
    x2 = ((fiat_secp521r1_uint1)(x1 >> 58) +
          (UINT64_C(0x7fffffffffffffe) - (arg1[1])));
    x3 = ((fiat_secp521r1_uint1)(x2 >> 58) +
          (UINT64_C(0x7fffffffffffffe) - (arg1[2])));
    x4 = ((fiat_secp521r1_uint1)(x3 >> 58) +
          (UINT64_C(0x7fffffffffffffe) - (arg1[3])));
    x5 = ((fiat_secp521r1_uint1)(x4 >> 58) +
          (UINT64_C(0x7fffffffffffffe) - (arg1[4])));
    x6 = ((fiat_secp521r1_uint1)(x5 >> 58) +
          (UINT64_C(0x7fffffffffffffe) - (arg1[5])));
    x7 = ((fiat_secp521r1_uint1)(x6 >> 58) +
          (UINT64_C(0x7fffffffffffffe) - (arg1[6])));
    x8 = ((fiat_secp521r1_uint1)(x7 >> 58) +
          (UINT64_C(0x7fffffffffffffe) - (arg1[7])));
    x9 = ((fiat_secp521r1_uint1)(x8 >> 58) +
          (UINT64_C(0x3fffffffffffffe) - (arg1[8])));
    x10 = ((x1 & UINT64_C(0x3ffffffffffffff)) +
           (uint64_t)(fiat_secp521r1_uint1)(x9 >> 57));
    x11 = ((fiat_secp521r1_uint1)(x10 >> 58) +
           (x2 & UINT64_C(0x3ffffffffffffff)));
    x12 = (x10 & UINT64_C(0x3ffffffffffffff));
    x13 = (x11 & UINT64_C(0x3ffffffffffffff));
    x14 = ((fiat_secp521r1_uint1)(x11 >> 58) +
           (x3 & UINT64_C(0x3ffffffffffffff)));
    x15 = (x4 & UINT64_C(0x3ffffffffffffff));
    x16 = (x5 & UINT64_C(0x3ffffffffffffff));
    x17 = (x6 & UINT64_C(0x3ffffffffffffff));
    x18 = (x7 & UINT64_C(0x3ffffffffffffff));
    x19 = (x8 & UINT64_C(0x3ffffffffffffff));
    x20 = (x9 & UINT64_C(0x1ffffffffffffff));
    out1[0] = x12;
    out1[1] = x13;
    out1[2] = x14;
    out1[3] = x15;
    out1[4] = x16;
    out1[5] = x17;
    out1[6] = x18;
    out1[7] = x19;
    out1[8] = x20;
}

/*
 * The function fiat_secp521r1_relax is the identity function converting from tight field elements to loose field elements.
 *
 * Postconditions:
 *   out1 = arg1
 *
 */

/*
 * The function fiat_secp521r1_selectznz is a multi-limb conditional select.
 *
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_secp521r1_selectznz(uint64_t out1[9],
                                     fiat_secp521r1_uint1 arg1,
                                     const uint64_t arg2[9],
                                     const uint64_t arg3[9]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    fiat_secp521r1_cmovznz_u64(&x1, arg1, (arg2[0]), (arg3[0]));
    fiat_secp521r1_cmovznz_u64(&x2, arg1, (arg2[1]), (arg3[1]));
    fiat_secp521r1_cmovznz_u64(&x3, arg1, (arg2[2]), (arg3[2]));
    fiat_secp521r1_cmovznz_u64(&x4, arg1, (arg2[3]), (arg3[3]));
    fiat_secp521r1_cmovznz_u64(&x5, arg1, (arg2[4]), (arg3[4]));
    fiat_secp521r1_cmovznz_u64(&x6, arg1, (arg2[5]), (arg3[5]));
    fiat_secp521r1_cmovznz_u64(&x7, arg1, (arg2[6]), (arg3[6]));
    fiat_secp521r1_cmovznz_u64(&x8, arg1, (arg2[7]), (arg3[7]));
    fiat_secp521r1_cmovznz_u64(&x9, arg1, (arg2[8]), (arg3[8]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
    out1[8] = x9;
}

/*
 * The function fiat_secp521r1_to_bytes serializes a field element to bytes in little-endian order.
 *
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..65]
 *
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]
 */
static void fiat_secp521r1_to_bytes(
    uint8_t out1[66], const fiat_secp521r1_tight_field_element arg1) {
    uint64_t x1;
    fiat_secp521r1_uint1 x2;
    uint64_t x3;
    fiat_secp521r1_uint1 x4;
    uint64_t x5;
    fiat_secp521r1_uint1 x6;
    uint64_t x7;
    fiat_secp521r1_uint1 x8;
    uint64_t x9;
    fiat_secp521r1_uint1 x10;
    uint64_t x11;
    fiat_secp521r1_uint1 x12;
    uint64_t x13;
    fiat_secp521r1_uint1 x14;
    uint64_t x15;
    fiat_secp521r1_uint1 x16;
    uint64_t x17;
    fiat_secp521r1_uint1 x18;
    uint64_t x19;
    uint64_t x20;
    fiat_secp521r1_uint1 x21;
    uint64_t x22;
    fiat_secp521r1_uint1 x23;
    uint64_t x24;
    fiat_secp521r1_uint1 x25;
    uint64_t x26;
    fiat_secp521r1_uint1 x27;
    uint64_t x28;
    fiat_secp521r1_uint1 x29;
    uint64_t x30;
    fiat_secp521r1_uint1 x31;
    uint64_t x32;
    fiat_secp521r1_uint1 x33;
    uint64_t x34;
    fiat_secp521r1_uint1 x35;
    uint64_t x36;
    fiat_secp521r1_uint1 x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint8_t x44;
    uint64_t x45;
    uint8_t x46;
    uint64_t x47;
    uint8_t x48;
    uint64_t x49;
    uint8_t x50;
    uint64_t x51;
    uint8_t x52;
    uint64_t x53;
    uint8_t x54;
    uint64_t x55;
    uint8_t x56;
    uint8_t x57;
    uint64_t x58;
    uint8_t x59;
    uint64_t x60;
    uint8_t x61;
    uint64_t x62;
    uint8_t x63;
    uint64_t x64;
    uint8_t x65;
    uint64_t x66;
    uint8_t x67;
    uint64_t x68;
    uint8_t x69;
    uint64_t x70;
    uint8_t x71;
    uint8_t x72;
    uint64_t x73;
    uint8_t x74;
    uint64_t x75;
    uint8_t x76;
    uint64_t x77;
    uint8_t x78;
    uint64_t x79;
    uint8_t x80;
    uint64_t x81;
    uint8_t x82;
    uint64_t x83;
    uint8_t x84;
    uint64_t x85;
    uint8_t x86;
    uint8_t x87;
    uint64_t x88;
    uint8_t x89;
    uint64_t x90;
    uint8_t x91;
    uint64_t x92;
    uint8_t x93;
    uint64_t x94;
    uint8_t x95;
    uint64_t x96;
    uint8_t x97;
    uint64_t x98;
    uint8_t x99;
    uint64_t x100;
    uint8_t x101;
    uint8_t x102;
    uint8_t x103;
    uint64_t x104;
    uint8_t x105;
    uint64_t x106;
    uint8_t x107;
    uint64_t x108;
    uint8_t x109;
    uint64_t x110;
    uint8_t x111;
    uint64_t x112;
    uint8_t x113;
    uint64_t x114;
    uint8_t x115;
    uint8_t x116;
    uint64_t x117;
    uint8_t x118;
    uint64_t x119;
    uint8_t x120;
    uint64_t x121;
    uint8_t x122;
    uint64_t x123;
    uint8_t x124;
    uint64_t x125;
    uint8_t x126;
    uint64_t x127;
    uint8_t x128;
    uint64_t x129;
    uint8_t x130;
    uint8_t x131;
    uint64_t x132;
    uint8_t x133;
    uint64_t x134;
    uint8_t x135;
    uint64_t x136;
    uint8_t x137;
    uint64_t x138;
    uint8_t x139;
    uint64_t x140;
    uint8_t x141;
    uint64_t x142;
    uint8_t x143;
    uint64_t x144;
    uint8_t x145;
    uint8_t x146;
    uint64_t x147;
    uint8_t x148;
    uint64_t x149;
    uint8_t x150;
    uint64_t x151;
    uint8_t x152;
    uint64_t x153;
    uint8_t x154;
    uint64_t x155;
    uint8_t x156;
    uint64_t x157;
    uint8_t x158;
    uint64_t x159;
    uint8_t x160;
    uint8_t x161;
    uint8_t x162;
    uint64_t x163;
    uint8_t x164;
    uint64_t x165;
    uint8_t x166;
    uint64_t x167;
    uint8_t x168;
    uint64_t x169;
    uint8_t x170;
    uint64_t x171;
    uint8_t x172;
    uint64_t x173;
    uint8_t x174;
    fiat_secp521r1_uint1 x175;
    fiat_secp521r1_subborrowx_u58(&x1, &x2, 0x0, (arg1[0]),
                                  UINT64_C(0x3ffffffffffffff));
    fiat_secp521r1_subborrowx_u58(&x3, &x4, x2, (arg1[1]),
                                  UINT64_C(0x3ffffffffffffff));
    fiat_secp521r1_subborrowx_u58(&x5, &x6, x4, (arg1[2]),
                                  UINT64_C(0x3ffffffffffffff));
    fiat_secp521r1_subborrowx_u58(&x7, &x8, x6, (arg1[3]),
                                  UINT64_C(0x3ffffffffffffff));
    fiat_secp521r1_subborrowx_u58(&x9, &x10, x8, (arg1[4]),
                                  UINT64_C(0x3ffffffffffffff));
    fiat_secp521r1_subborrowx_u58(&x11, &x12, x10, (arg1[5]),
                                  UINT64_C(0x3ffffffffffffff));
    fiat_secp521r1_subborrowx_u58(&x13, &x14, x12, (arg1[6]),
                                  UINT64_C(0x3ffffffffffffff));
    fiat_secp521r1_subborrowx_u58(&x15, &x16, x14, (arg1[7]),
                                  UINT64_C(0x3ffffffffffffff));
    fiat_secp521r1_subborrowx_u57(&x17, &x18, x16, (arg1[8]),
                                  UINT64_C(0x1ffffffffffffff));
    fiat_secp521r1_cmovznz_u64(&x19, x18, 0x0, UINT64_C(0xffffffffffffffff));
    fiat_secp521r1_addcarryx_u58(&x20, &x21, 0x0, x1,
                                 (x19 & UINT64_C(0x3ffffffffffffff)));
    fiat_secp521r1_addcarryx_u58(&x22, &x23, x21, x3,
                                 (x19 & UINT64_C(0x3ffffffffffffff)));
    fiat_secp521r1_addcarryx_u58(&x24, &x25, x23, x5,
                                 (x19 & UINT64_C(0x3ffffffffffffff)));
    fiat_secp521r1_addcarryx_u58(&x26, &x27, x25, x7,
                                 (x19 & UINT64_C(0x3ffffffffffffff)));
    fiat_secp521r1_addcarryx_u58(&x28, &x29, x27, x9,
                                 (x19 & UINT64_C(0x3ffffffffffffff)));
    fiat_secp521r1_addcarryx_u58(&x30, &x31, x29, x11,
                                 (x19 & UINT64_C(0x3ffffffffffffff)));
    fiat_secp521r1_addcarryx_u58(&x32, &x33, x31, x13,
                                 (x19 & UINT64_C(0x3ffffffffffffff)));
    fiat_secp521r1_addcarryx_u58(&x34, &x35, x33, x15,
                                 (x19 & UINT64_C(0x3ffffffffffffff)));
    fiat_secp521r1_addcarryx_u57(&x36, &x37, x35, x17,
                                 (x19 & UINT64_C(0x1ffffffffffffff)));
    x38 = (x34 << 6);
    x39 = (x32 << 4);
    x40 = (x30 << 2);
    x41 = (x26 << 6);
    x42 = (x24 << 4);
    x43 = (x22 << 2);
    x44 = (uint8_t)(x20 & UINT8_C(0xff));
    x45 = (x20 >> 8);
    x46 = (uint8_t)(x45 & UINT8_C(0xff));
    x47 = (x45 >> 8);
    x48 = (uint8_t)(x47 & UINT8_C(0xff));
    x49 = (x47 >> 8);
    x50 = (uint8_t)(x49 & UINT8_C(0xff));
    x51 = (x49 >> 8);
    x52 = (uint8_t)(x51 & UINT8_C(0xff));
    x53 = (x51 >> 8);
    x54 = (uint8_t)(x53 & UINT8_C(0xff));
    x55 = (x53 >> 8);
    x56 = (uint8_t)(x55 & UINT8_C(0xff));
    x57 = (uint8_t)(x55 >> 8);
    x58 = (x43 + (uint64_t)x57);
    x59 = (uint8_t)(x58 & UINT8_C(0xff));
    x60 = (x58 >> 8);
    x61 = (uint8_t)(x60 & UINT8_C(0xff));
    x62 = (x60 >> 8);
    x63 = (uint8_t)(x62 & UINT8_C(0xff));
    x64 = (x62 >> 8);
    x65 = (uint8_t)(x64 & UINT8_C(0xff));
    x66 = (x64 >> 8);
    x67 = (uint8_t)(x66 & UINT8_C(0xff));
    x68 = (x66 >> 8);
    x69 = (uint8_t)(x68 & UINT8_C(0xff));
    x70 = (x68 >> 8);
    x71 = (uint8_t)(x70 & UINT8_C(0xff));
    x72 = (uint8_t)(x70 >> 8);
    x73 = (x42 + (uint64_t)x72);
    x74 = (uint8_t)(x73 & UINT8_C(0xff));
    x75 = (x73 >> 8);
    x76 = (uint8_t)(x75 & UINT8_C(0xff));
    x77 = (x75 >> 8);
    x78 = (uint8_t)(x77 & UINT8_C(0xff));
    x79 = (x77 >> 8);
    x80 = (uint8_t)(x79 & UINT8_C(0xff));
    x81 = (x79 >> 8);
    x82 = (uint8_t)(x81 & UINT8_C(0xff));
    x83 = (x81 >> 8);
    x84 = (uint8_t)(x83 & UINT8_C(0xff));
    x85 = (x83 >> 8);
    x86 = (uint8_t)(x85 & UINT8_C(0xff));
    x87 = (uint8_t)(x85 >> 8);
    x88 = (x41 + (uint64_t)x87);
    x89 = (uint8_t)(x88 & UINT8_C(0xff));
    x90 = (x88 >> 8);
    x91 = (uint8_t)(x90 & UINT8_C(0xff));
    x92 = (x90 >> 8);
    x93 = (uint8_t)(x92 & UINT8_C(0xff));
    x94 = (x92 >> 8);
    x95 = (uint8_t)(x94 & UINT8_C(0xff));
    x96 = (x94 >> 8);
    x97 = (uint8_t)(x96 & UINT8_C(0xff));
    x98 = (x96 >> 8);
    x99 = (uint8_t)(x98 & UINT8_C(0xff));
    x100 = (x98 >> 8);
    x101 = (uint8_t)(x100 & UINT8_C(0xff));
    x102 = (uint8_t)(x100 >> 8);
    x103 = (uint8_t)(x28 & UINT8_C(0xff));
    x104 = (x28 >> 8);
    x105 = (uint8_t)(x104 & UINT8_C(0xff));
    x106 = (x104 >> 8);
    x107 = (uint8_t)(x106 & UINT8_C(0xff));
    x108 = (x106 >> 8);
    x109 = (uint8_t)(x108 & UINT8_C(0xff));
    x110 = (x108 >> 8);
    x111 = (uint8_t)(x110 & UINT8_C(0xff));
    x112 = (x110 >> 8);
    x113 = (uint8_t)(x112 & UINT8_C(0xff));
    x114 = (x112 >> 8);
    x115 = (uint8_t)(x114 & UINT8_C(0xff));
    x116 = (uint8_t)(x114 >> 8);
    x117 = (x40 + (uint64_t)x116);
    x118 = (uint8_t)(x117 & UINT8_C(0xff));
    x119 = (x117 >> 8);
    x120 = (uint8_t)(x119 & UINT8_C(0xff));
    x121 = (x119 >> 8);
    x122 = (uint8_t)(x121 & UINT8_C(0xff));
    x123 = (x121 >> 8);
    x124 = (uint8_t)(x123 & UINT8_C(0xff));
    x125 = (x123 >> 8);
    x126 = (uint8_t)(x125 & UINT8_C(0xff));
    x127 = (x125 >> 8);
    x128 = (uint8_t)(x127 & UINT8_C(0xff));
    x129 = (x127 >> 8);
    x130 = (uint8_t)(x129 & UINT8_C(0xff));
    x131 = (uint8_t)(x129 >> 8);
    x132 = (x39 + (uint64_t)x131);
    x133 = (uint8_t)(x132 & UINT8_C(0xff));
    x134 = (x132 >> 8);
    x135 = (uint8_t)(x134 & UINT8_C(0xff));
    x136 = (x134 >> 8);
    x137 = (uint8_t)(x136 & UINT8_C(0xff));
    x138 = (x136 >> 8);
    x139 = (uint8_t)(x138 & UINT8_C(0xff));
    x140 = (x138 >> 8);
    x141 = (uint8_t)(x140 & UINT8_C(0xff));
    x142 = (x140 >> 8);
    x143 = (uint8_t)(x142 & UINT8_C(0xff));
    x144 = (x142 >> 8);
    x145 = (uint8_t)(x144 & UINT8_C(0xff));
    x146 = (uint8_t)(x144 >> 8);
    x147 = (x38 + (uint64_t)x146);
    x148 = (uint8_t)(x147 & UINT8_C(0xff));
    x149 = (x147 >> 8);
    x150 = (uint8_t)(x149 & UINT8_C(0xff));
    x151 = (x149 >> 8);
    x152 = (uint8_t)(x151 & UINT8_C(0xff));
    x153 = (x151 >> 8);
    x154 = (uint8_t)(x153 & UINT8_C(0xff));
    x155 = (x153 >> 8);
    x156 = (uint8_t)(x155 & UINT8_C(0xff));
    x157 = (x155 >> 8);
    x158 = (uint8_t)(x157 & UINT8_C(0xff));
    x159 = (x157 >> 8);
    x160 = (uint8_t)(x159 & UINT8_C(0xff));
    x161 = (uint8_t)(x159 >> 8);
    x162 = (uint8_t)(x36 & UINT8_C(0xff));
    x163 = (x36 >> 8);
    x164 = (uint8_t)(x163 & UINT8_C(0xff));
    x165 = (x163 >> 8);
    x166 = (uint8_t)(x165 & UINT8_C(0xff));
    x167 = (x165 >> 8);
    x168 = (uint8_t)(x167 & UINT8_C(0xff));
    x169 = (x167 >> 8);
    x170 = (uint8_t)(x169 & UINT8_C(0xff));
    x171 = (x169 >> 8);
    x172 = (uint8_t)(x171 & UINT8_C(0xff));
    x173 = (x171 >> 8);
    x174 = (uint8_t)(x173 & UINT8_C(0xff));
    x175 = (fiat_secp521r1_uint1)(x173 >> 8);
    out1[0] = x44;
    out1[1] = x46;
    out1[2] = x48;
    out1[3] = x50;
    out1[4] = x52;
    out1[5] = x54;
    out1[6] = x56;
    out1[7] = x59;
    out1[8] = x61;
    out1[9] = x63;
    out1[10] = x65;
    out1[11] = x67;
    out1[12] = x69;
    out1[13] = x71;
    out1[14] = x74;
    out1[15] = x76;
    out1[16] = x78;
    out1[17] = x80;
    out1[18] = x82;
    out1[19] = x84;
    out1[20] = x86;
    out1[21] = x89;
    out1[22] = x91;
    out1[23] = x93;
    out1[24] = x95;
    out1[25] = x97;
    out1[26] = x99;
    out1[27] = x101;
    out1[28] = x102;
    out1[29] = x103;
    out1[30] = x105;
    out1[31] = x107;
    out1[32] = x109;
    out1[33] = x111;
    out1[34] = x113;
    out1[35] = x115;
    out1[36] = x118;
    out1[37] = x120;
    out1[38] = x122;
    out1[39] = x124;
    out1[40] = x126;
    out1[41] = x128;
    out1[42] = x130;
    out1[43] = x133;
    out1[44] = x135;
    out1[45] = x137;
    out1[46] = x139;
    out1[47] = x141;
    out1[48] = x143;
    out1[49] = x145;
    out1[50] = x148;
    out1[51] = x150;
    out1[52] = x152;
    out1[53] = x154;
    out1[54] = x156;
    out1[55] = x158;
    out1[56] = x160;
    out1[57] = x161;
    out1[58] = x162;
    out1[59] = x164;
    out1[60] = x166;
    out1[61] = x168;
    out1[62] = x170;
    out1[63] = x172;
    out1[64] = x174;
    out1[65] = x175;
}

/*
 * The function fiat_secp521r1_from_bytes deserializes a field element from bytes in little-endian order.
 *
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]
 */
static void fiat_secp521r1_from_bytes(fiat_secp521r1_tight_field_element out1,
                                      const uint8_t arg1[66]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint8_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint64_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    uint64_t x23;
    uint64_t x24;
    uint64_t x25;
    uint64_t x26;
    uint64_t x27;
    uint64_t x28;
    uint64_t x29;
    uint64_t x30;
    uint64_t x31;
    uint64_t x32;
    uint64_t x33;
    uint64_t x34;
    uint64_t x35;
    uint64_t x36;
    uint8_t x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    uint64_t x45;
    uint64_t x46;
    uint64_t x47;
    uint64_t x48;
    uint64_t x49;
    uint64_t x50;
    uint64_t x51;
    uint64_t x52;
    uint64_t x53;
    uint64_t x54;
    uint64_t x55;
    uint64_t x56;
    uint64_t x57;
    uint64_t x58;
    uint64_t x59;
    uint64_t x60;
    uint64_t x61;
    uint64_t x62;
    uint64_t x63;
    uint64_t x64;
    uint64_t x65;
    uint8_t x66;
    uint64_t x67;
    uint64_t x68;
    uint64_t x69;
    uint64_t x70;
    uint64_t x71;
    uint64_t x72;
    uint64_t x73;
    uint64_t x74;
    uint8_t x75;
    uint64_t x76;
    uint64_t x77;
    uint64_t x78;
    uint64_t x79;
    uint64_t x80;
    uint64_t x81;
    uint64_t x82;
    uint64_t x83;
    uint8_t x84;
    uint64_t x85;
    uint64_t x86;
    uint64_t x87;
    uint64_t x88;
    uint64_t x89;
    uint64_t x90;
    uint64_t x91;
    uint64_t x92;
    uint8_t x93;
    uint64_t x94;
    uint64_t x95;
    uint64_t x96;
    uint64_t x97;
    uint64_t x98;
    uint64_t x99;
    uint64_t x100;
    uint64_t x101;
    uint64_t x102;
    uint64_t x103;
    uint64_t x104;
    uint64_t x105;
    uint64_t x106;
    uint64_t x107;
    uint64_t x108;
    uint8_t x109;
    uint64_t x110;
    uint64_t x111;
    uint64_t x112;
    uint64_t x113;
    uint64_t x114;
    uint64_t x115;
    uint64_t x116;
    uint64_t x117;
    uint8_t x118;
    uint64_t x119;
    uint64_t x120;
    uint64_t x121;
    uint64_t x122;
    uint64_t x123;
    uint64_t x124;
    uint64_t x125;
    uint64_t x126;
    uint8_t x127;
    uint64_t x128;
    uint64_t x129;
    uint64_t x130;
    uint64_t x131;
    uint64_t x132;
    uint64_t x133;
    uint64_t x134;
    uint64_t x135;
    uint64_t x136;
    uint64_t x137;
    uint64_t x138;
    uint64_t x139;
    uint64_t x140;
    uint64_t x141;
    x1 = ((uint64_t)(fiat_secp521r1_uint1)(arg1[65]) << 56);
    x2 = ((uint64_t)(arg1[64]) << 48);
    x3 = ((uint64_t)(arg1[63]) << 40);
    x4 = ((uint64_t)(arg1[62]) << 32);
    x5 = ((uint64_t)(arg1[61]) << 24);
    x6 = ((uint64_t)(arg1[60]) << 16);
    x7 = ((uint64_t)(arg1[59]) << 8);
    x8 = (arg1[58]);
    x9 = ((uint64_t)(arg1[57]) << 50);
    x10 = ((uint64_t)(arg1[56]) << 42);
    x11 = ((uint64_t)(arg1[55]) << 34);
    x12 = ((uint64_t)(arg1[54]) << 26);
    x13 = ((uint64_t)(arg1[53]) << 18);
    x14 = ((uint64_t)(arg1[52]) << 10);
    x15 = ((uint64_t)(arg1[51]) << 2);
    x16 = ((uint64_t)(arg1[50]) << 52);
    x17 = ((uint64_t)(arg1[49]) << 44);
    x18 = ((uint64_t)(arg1[48]) << 36);
    x19 = ((uint64_t)(arg1[47]) << 28);
    x20 = ((uint64_t)(arg1[46]) << 20);
    x21 = ((uint64_t)(arg1[45]) << 12);
    x22 = ((uint64_t)(arg1[44]) << 4);
    x23 = ((uint64_t)(arg1[43]) << 54);
    x24 = ((uint64_t)(arg1[42]) << 46);
    x25 = ((uint64_t)(arg1[41]) << 38);
    x26 = ((uint64_t)(arg1[40]) << 30);
    x27 = ((uint64_t)(arg1[39]) << 22);
    x28 = ((uint64_t)(arg1[38]) << 14);
    x29 = ((uint64_t)(arg1[37]) << 6);
    x30 = ((uint64_t)(arg1[36]) << 56);
    x31 = ((uint64_t)(arg1[35]) << 48);
    x32 = ((uint64_t)(arg1[34]) << 40);
    x33 = ((uint64_t)(arg1[33]) << 32);
    x34 = ((uint64_t)(arg1[32]) << 24);
    x35 = ((uint64_t)(arg1[31]) << 16);
    x36 = ((uint64_t)(arg1[30]) << 8);
    x37 = (arg1[29]);
    x38 = ((uint64_t)(arg1[28]) << 50);
    x39 = ((uint64_t)(arg1[27]) << 42);
    x40 = ((uint64_t)(arg1[26]) << 34);
    x41 = ((uint64_t)(arg1[25]) << 26);
    x42 = ((uint64_t)(arg1[24]) << 18);
    x43 = ((uint64_t)(arg1[23]) << 10);
    x44 = ((uint64_t)(arg1[22]) << 2);
    x45 = ((uint64_t)(arg1[21]) << 52);
    x46 = ((uint64_t)(arg1[20]) << 44);
    x47 = ((uint64_t)(arg1[19]) << 36);
    x48 = ((uint64_t)(arg1[18]) << 28);
    x49 = ((uint64_t)(arg1[17]) << 20);
    x50 = ((uint64_t)(arg1[16]) << 12);
    x51 = ((uint64_t)(arg1[15]) << 4);
    x52 = ((uint64_t)(arg1[14]) << 54);
    x53 = ((uint64_t)(arg1[13]) << 46);
    x54 = ((uint64_t)(arg1[12]) << 38);
    x55 = ((uint64_t)(arg1[11]) << 30);
    x56 = ((uint64_t)(arg1[10]) << 22);
    x57 = ((uint64_t)(arg1[9]) << 14);
    x58 = ((uint64_t)(arg1[8]) << 6);
    x59 = ((uint64_t)(arg1[7]) << 56);
    x60 = ((uint64_t)(arg1[6]) << 48);
    x61 = ((uint64_t)(arg1[5]) << 40);
    x62 = ((uint64_t)(arg1[4]) << 32);
    x63 = ((uint64_t)(arg1[3]) << 24);
    x64 = ((uint64_t)(arg1[2]) << 16);
    x65 = ((uint64_t)(arg1[1]) << 8);
    x66 = (arg1[0]);
    x67 = (x65 + (uint64_t)x66);
    x68 = (x64 + x67);
    x69 = (x63 + x68);
    x70 = (x62 + x69);
    x71 = (x61 + x70);
    x72 = (x60 + x71);
    x73 = (x59 + x72);
    x74 = (x73 & UINT64_C(0x3ffffffffffffff));
    x75 = (uint8_t)(x73 >> 58);
    x76 = (x58 + (uint64_t)x75);
    x77 = (x57 + x76);
    x78 = (x56 + x77);
    x79 = (x55 + x78);
    x80 = (x54 + x79);
    x81 = (x53 + x80);
    x82 = (x52 + x81);
    x83 = (x82 & UINT64_C(0x3ffffffffffffff));
    x84 = (uint8_t)(x82 >> 58);
    x85 = (x51 + (uint64_t)x84);
    x86 = (x50 + x85);
    x87 = (x49 + x86);
    x88 = (x48 + x87);
    x89 = (x47 + x88);
    x90 = (x46 + x89);
    x91 = (x45 + x90);
    x92 = (x91 & UINT64_C(0x3ffffffffffffff));
    x93 = (uint8_t)(x91 >> 58);
    x94 = (x44 + (uint64_t)x93);
    x95 = (x43 + x94);
    x96 = (x42 + x95);
    x97 = (x41 + x96);
    x98 = (x40 + x97);
    x99 = (x39 + x98);
    x100 = (x38 + x99);
    x101 = (x36 + (uint64_t)x37);
    x102 = (x35 + x101);
    x103 = (x34 + x102);
    x104 = (x33 + x103);
    x105 = (x32 + x104);
    x106 = (x31 + x105);
    x107 = (x30 + x106);
    x108 = (x107 & UINT64_C(0x3ffffffffffffff));
    x109 = (uint8_t)(x107 >> 58);
    x110 = (x29 + (uint64_t)x109);
    x111 = (x28 + x110);
    x112 = (x27 + x111);
    x113 = (x26 + x112);
    x114 = (x25 + x113);
    x115 = (x24 + x114);
    x116 = (x23 + x115);
    x117 = (x116 & UINT64_C(0x3ffffffffffffff));
    x118 = (uint8_t)(x116 >> 58);
    x119 = (x22 + (uint64_t)x118);
    x120 = (x21 + x119);
    x121 = (x20 + x120);
    x122 = (x19 + x121);
    x123 = (x18 + x122);
    x124 = (x17 + x123);
    x125 = (x16 + x124);
    x126 = (x125 & UINT64_C(0x3ffffffffffffff));
    x127 = (uint8_t)(x125 >> 58);
    x128 = (x15 + (uint64_t)x127);
    x129 = (x14 + x128);
    x130 = (x13 + x129);
    x131 = (x12 + x130);
    x132 = (x11 + x131);
    x133 = (x10 + x132);
    x134 = (x9 + x133);
    x135 = (x7 + (uint64_t)x8);
    x136 = (x6 + x135);
    x137 = (x5 + x136);
    x138 = (x4 + x137);
    x139 = (x3 + x138);
    x140 = (x2 + x139);
    x141 = (x1 + x140);
    out1[0] = x74;
    out1[1] = x83;
    out1[2] = x92;
    out1[3] = x100;
    out1[4] = x108;
    out1[5] = x117;
    out1[6] = x126;
    out1[7] = x134;
    out1[8] = x141;
}
