//************************************************************************************
// CheckNeedUpgrade - checks whether upgrade is needed
//
// 	Description: This function queries 

function CheckNeedUpgrade() {
	var wsh;
	var strQumranetToolsVersion;
	var nVer;
	var nVerStart;
	var nVerMid;

	// Get WSH Object
	wsh = WScript.CreateObject("WScript.Shell");

	try {
		strQumranetToolsVersion = wsh.regRead ("HKLM\\SOFTWARE\\RedHat\\RHEV\\Tools\\Version");
		nVerStart = 1;
		nVerMid = strQumranetToolsVersion.indexOf(".",nVerStart);
		nVer = GetVersionAsNumber(strQumranetToolsVersion);
		parseInt (
			strQumranetToolsVersion.substr(nVerStart, nVerMid - nVerStart)) * 10 + 
			parseFloat(strQumranetToolsVersion.substr(nVerMid+1)
		);
	} catch (e) {
		return ("DoInstall");
	}

	if (IsVersionLarger (strUpgradeToVersion,strQumranetToolsVersion)) {
		return ("DoUpgrade");
	} else {
		return ("DoNothing");
	}
}

function DoUpgradeUpgrader() {
// Upgrade upgrader by using it's msi
	var fso;
	var e;
	var x;

	try {
		// Get FileSystemObject Object
		fso = new ActiveXObject("Scripting.FileSystemObject");

		e = new Enumerator(fso.Drives);
		for (; !e.atEnd(); e.moveNext()) {
		    x = e.item();
		    if (x.DriveType == 4) { //4 = CDROM
		        if (fso.FileExists (x.RootFolder + "Upgrade.wsf")) {
				    ClearRebootMode ();
				    ExecAndLog (x.RootFolder + strInstallUpgrader);
				    DoUpgradeUpgrader();
		        }
		    }
		}

        return (0);
	} catch (e) {
		LogEvent (1,"DoUpgradeUpgrader - Encountered a problem, probably, could not find executable on CD: " + e + " " + e.description);
		return (1);
	}
}

function DoInstall() {
// Install
	var fso;
	var e;
	var x;

	try {
		// Get FileSystemObject Object
		fso = new ActiveXObject("Scripting.FileSystemObject");

		e = new Enumerator(fso.Drives);
		for (; !e.atEnd(); e.moveNext()) {
		    x = e.item();
		    if (x.DriveType == 4) { //4 = CDROM
		        if (fso.FileExists (x.RootFolder + "Upgrade.wsf")) {
				    ClearRebootMode ();
				    ExecAndLog (x.RootFolder + strInstallCommand);
				    DoUpgradeUpgrader();
		        }
		    }
		}

        return (0);
	} catch (e) {
		LogEvent (1,"DoInstall - Encountered a problem, probably, could not find executable on CD: " + e + " " + e.description);
		return (1);
	}
}

function DoUpgrade() {
// Upgrade
	var fso;
	var e;
	var x;

	try {
		// Get FileSystemObject Object
		fso = new ActiveXObject("Scripting.FileSystemObject");

		e = new Enumerator(fso.Drives);
		for (; !e.atEnd(); e.moveNext()) {
		    x = e.item();
		    if (x.DriveType == 4) { //4 = CDROM
		        if (fso.FileExists (x.RootFolder + "Upgrade.wsf")) {
				    ClearRebootMode ();
				    ExecAndLog (x.RootFolder + strInstallCommand);
		        }
		    }
		}

        return (0);
	} catch (e) {
		LogEvent (1,"DoUpgrade - Encountered a problem, probably, could not find executable on CD: " + e + " " + e.description);
		return (1);
	}
}

function DoNothing() {
    // Just do nothing ...
    return (0);
}

function IsVersionLarger( strVer1, strVer2) {
    var aVer1;
    var aVer2;
    var nVer1Major;
    var nVer2Major;
    var nVer1Minor;
    var nVer2Minor;
    var nVer1Revision;
    var nVer2Revision;

    try {    
        aVer1 = strVer1.split(".");
        aVer2 = strVer2.split(".");
        
        nVer1Major = parseInt(aVer1[0]);
        nVer1Minor = parseInt(aVer1[1]);
        nVer1Revision = parseInt(aVer1[2]);
        
        nVer2Major = parseInt(aVer2[0]);
        nVer2Minor = parseInt(aVer2[1]);
        nVer2Revision = parseInt(aVer2[2]);
    } catch (e) {
        LogEvent(1,"IsVersionLarger - version are not in the format x.y.z: " + strVer1 + " " + strVer2 + " error: " + e + " " + e.description);    
        return (false);
    }
    
    if (nVer1Major > nVer2Major) {
        return (true);
    }
    
    if (nVer1Major == nVer2Major) {
        if (nVer1Minor > nVer2Minor) {
            return (true);
        }
        
        if (nVer1Minor == nVer2Minor) {
            if (nVer1Revision > nVer2Revision) {
                return (true);
            }
        }
   }
   
   return (false);
}

function GetVersionAsNumber(strVer) {
	var nVerStart;
	var nVerMid;

	nVerStart = strVer.lastIndexOf(" ") + 1;
	nVerMid = strVer.indexOf(".",nVerStart);

	return (
	    parseInt (
	        strVer.substr (
	            nVerStart, 
	            nVerMid - nVerStart
            	) 
	    ) * 10 + parseFloat (strVer.substr(nVerMid+1))
	);
}