; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "USB Filter Editor"
!define PRODUCT_VERSION "1.0"
!define PRODUCT_PUBLISHER "Qumranet"
!define PRODUCT_WEB_SITE "http://www.qumranet.com"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "res\USBFilterEditor.ico"
!define MUI_UNICON "res\USBFilterEditor.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; MUI end ------

Name "${PRODUCT_NAME}"
OutFile "USBFilterEditorSetup.exe"

ShowInstDetails nevershow
ShowUnInstDetails nevershow

; This variable will point to the uninsaller directory.
Var UninstallerDir

Section "MainSection" SEC01

  SetOverwrite on
  SetShellVarContext current

  SetOutPath "$PROGRAMFILES\${PRODUCT_PUBLISHER}\${PRODUCT_NAME}"
  File "Release\USBFilterEditor.exe"
  
  CreateShortCut "$DESKTOP\${PRODUCT_NAME}.lnk" "$OUTDIR\USBFilterEditor.exe"
  
  StrCpy $UninstallerDir "$APPDATA\${PRODUCT_PUBLISHER}\${PRODUCT_NAME}"
  SetOutPath $UninstallerDir
  File "UsbFilterEditor.db"

SectionEnd

Section -Post

  WriteUninstaller "$UninstallerDir\uninst.exe"
  
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$UninstallerDir\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$UninstallerDir\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall

  SetAutoClose true
  
  Delete "$DESKTOP\${PRODUCT_NAME}.lnk"
  
  Delete "$APPDATA\${PRODUCT_PUBLISHER}\${PRODUCT_NAME}\USBFilterEditor.exe"
  RMDir "$APPDATA\${PRODUCT_PUBLISHER}\${PRODUCT_NAME}"
  
  Delete "$INSTDIR\UsbFilterEditor.db"
  Delete "$INSTDIR\uninst.exe"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"

SectionEnd
