// +build !ignore_autogenerated

/*
Copyright 2019 Red Hat Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by conversion-gen. DO NOT EDIT.

package appsv1

import (
	unsafe "unsafe"

	v1 "k8s.io/api/apps/v1"
	v1beta1 "k8s.io/api/apps/v1beta1"
	v1beta2 "k8s.io/api/apps/v1beta2"
	corev1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*v1.ControllerRevision)(nil), (*v1beta1.ControllerRevision)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ControllerRevision_To_v1beta1_ControllerRevision(a.(*v1.ControllerRevision), b.(*v1beta1.ControllerRevision), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ControllerRevision)(nil), (*v1.ControllerRevision)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ControllerRevision_To_v1_ControllerRevision(a.(*v1beta1.ControllerRevision), b.(*v1.ControllerRevision), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ControllerRevisionList)(nil), (*v1beta1.ControllerRevisionList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ControllerRevisionList_To_v1beta1_ControllerRevisionList(a.(*v1.ControllerRevisionList), b.(*v1beta1.ControllerRevisionList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ControllerRevisionList)(nil), (*v1.ControllerRevisionList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ControllerRevisionList_To_v1_ControllerRevisionList(a.(*v1beta1.ControllerRevisionList), b.(*v1.ControllerRevisionList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DaemonSet)(nil), (*v1beta2.DaemonSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSet_To_v1beta2_DaemonSet(a.(*v1.DaemonSet), b.(*v1beta2.DaemonSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta2.DaemonSet)(nil), (*v1.DaemonSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DaemonSet_To_v1_DaemonSet(a.(*v1beta2.DaemonSet), b.(*v1.DaemonSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DaemonSetCondition)(nil), (*v1beta2.DaemonSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSetCondition_To_v1beta2_DaemonSetCondition(a.(*v1.DaemonSetCondition), b.(*v1beta2.DaemonSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta2.DaemonSetCondition)(nil), (*v1.DaemonSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DaemonSetCondition_To_v1_DaemonSetCondition(a.(*v1beta2.DaemonSetCondition), b.(*v1.DaemonSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DaemonSetList)(nil), (*v1beta2.DaemonSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSetList_To_v1beta2_DaemonSetList(a.(*v1.DaemonSetList), b.(*v1beta2.DaemonSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta2.DaemonSetList)(nil), (*v1.DaemonSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DaemonSetList_To_v1_DaemonSetList(a.(*v1beta2.DaemonSetList), b.(*v1.DaemonSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DaemonSetSpec)(nil), (*v1beta2.DaemonSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSetSpec_To_v1beta2_DaemonSetSpec(a.(*v1.DaemonSetSpec), b.(*v1beta2.DaemonSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta2.DaemonSetSpec)(nil), (*v1.DaemonSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DaemonSetSpec_To_v1_DaemonSetSpec(a.(*v1beta2.DaemonSetSpec), b.(*v1.DaemonSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DaemonSetStatus)(nil), (*v1beta2.DaemonSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSetStatus_To_v1beta2_DaemonSetStatus(a.(*v1.DaemonSetStatus), b.(*v1beta2.DaemonSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta2.DaemonSetStatus)(nil), (*v1.DaemonSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DaemonSetStatus_To_v1_DaemonSetStatus(a.(*v1beta2.DaemonSetStatus), b.(*v1.DaemonSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DaemonSetUpdateStrategy)(nil), (*v1beta2.DaemonSetUpdateStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSetUpdateStrategy_To_v1beta2_DaemonSetUpdateStrategy(a.(*v1.DaemonSetUpdateStrategy), b.(*v1beta2.DaemonSetUpdateStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta2.DaemonSetUpdateStrategy)(nil), (*v1.DaemonSetUpdateStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy(a.(*v1beta2.DaemonSetUpdateStrategy), b.(*v1.DaemonSetUpdateStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.Deployment)(nil), (*v1beta1.Deployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_Deployment_To_v1beta1_Deployment(a.(*v1.Deployment), b.(*v1beta1.Deployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Deployment)(nil), (*v1.Deployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Deployment_To_v1_Deployment(a.(*v1beta1.Deployment), b.(*v1.Deployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeploymentCondition)(nil), (*v1beta1.DeploymentCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeploymentCondition_To_v1beta1_DeploymentCondition(a.(*v1.DeploymentCondition), b.(*v1beta1.DeploymentCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.DeploymentCondition)(nil), (*v1.DeploymentCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DeploymentCondition_To_v1_DeploymentCondition(a.(*v1beta1.DeploymentCondition), b.(*v1.DeploymentCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeploymentList)(nil), (*v1beta1.DeploymentList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeploymentList_To_v1beta1_DeploymentList(a.(*v1.DeploymentList), b.(*v1beta1.DeploymentList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.DeploymentList)(nil), (*v1.DeploymentList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DeploymentList_To_v1_DeploymentList(a.(*v1beta1.DeploymentList), b.(*v1.DeploymentList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeploymentSpec)(nil), (*v1beta1.DeploymentSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeploymentSpec_To_v1beta1_DeploymentSpec(a.(*v1.DeploymentSpec), b.(*v1beta1.DeploymentSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeploymentStatus)(nil), (*v1beta1.DeploymentStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeploymentStatus_To_v1beta1_DeploymentStatus(a.(*v1.DeploymentStatus), b.(*v1beta1.DeploymentStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.DeploymentStatus)(nil), (*v1.DeploymentStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DeploymentStatus_To_v1_DeploymentStatus(a.(*v1beta1.DeploymentStatus), b.(*v1.DeploymentStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeploymentStrategy)(nil), (*v1beta1.DeploymentStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeploymentStrategy_To_v1beta1_DeploymentStrategy(a.(*v1.DeploymentStrategy), b.(*v1beta1.DeploymentStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.DeploymentStrategy)(nil), (*v1.DeploymentStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DeploymentStrategy_To_v1_DeploymentStrategy(a.(*v1beta1.DeploymentStrategy), b.(*v1.DeploymentStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ReplicaSet)(nil), (*v1beta2.ReplicaSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ReplicaSet_To_v1beta2_ReplicaSet(a.(*v1.ReplicaSet), b.(*v1beta2.ReplicaSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta2.ReplicaSet)(nil), (*v1.ReplicaSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ReplicaSet_To_v1_ReplicaSet(a.(*v1beta2.ReplicaSet), b.(*v1.ReplicaSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ReplicaSetCondition)(nil), (*v1beta2.ReplicaSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ReplicaSetCondition_To_v1beta2_ReplicaSetCondition(a.(*v1.ReplicaSetCondition), b.(*v1beta2.ReplicaSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta2.ReplicaSetCondition)(nil), (*v1.ReplicaSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ReplicaSetCondition_To_v1_ReplicaSetCondition(a.(*v1beta2.ReplicaSetCondition), b.(*v1.ReplicaSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ReplicaSetList)(nil), (*v1beta2.ReplicaSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ReplicaSetList_To_v1beta2_ReplicaSetList(a.(*v1.ReplicaSetList), b.(*v1beta2.ReplicaSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta2.ReplicaSetList)(nil), (*v1.ReplicaSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ReplicaSetList_To_v1_ReplicaSetList(a.(*v1beta2.ReplicaSetList), b.(*v1.ReplicaSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ReplicaSetSpec)(nil), (*v1beta2.ReplicaSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ReplicaSetSpec_To_v1beta2_ReplicaSetSpec(a.(*v1.ReplicaSetSpec), b.(*v1beta2.ReplicaSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta2.ReplicaSetSpec)(nil), (*v1.ReplicaSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ReplicaSetSpec_To_v1_ReplicaSetSpec(a.(*v1beta2.ReplicaSetSpec), b.(*v1.ReplicaSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ReplicaSetStatus)(nil), (*v1beta2.ReplicaSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ReplicaSetStatus_To_v1beta2_ReplicaSetStatus(a.(*v1.ReplicaSetStatus), b.(*v1beta2.ReplicaSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta2.ReplicaSetStatus)(nil), (*v1.ReplicaSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ReplicaSetStatus_To_v1_ReplicaSetStatus(a.(*v1beta2.ReplicaSetStatus), b.(*v1.ReplicaSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.RollingUpdateDaemonSet)(nil), (*v1beta2.RollingUpdateDaemonSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_RollingUpdateDaemonSet_To_v1beta2_RollingUpdateDaemonSet(a.(*v1.RollingUpdateDaemonSet), b.(*v1beta2.RollingUpdateDaemonSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta2.RollingUpdateDaemonSet)(nil), (*v1.RollingUpdateDaemonSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet(a.(*v1beta2.RollingUpdateDaemonSet), b.(*v1.RollingUpdateDaemonSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.RollingUpdateDeployment)(nil), (*v1beta1.RollingUpdateDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_RollingUpdateDeployment_To_v1beta1_RollingUpdateDeployment(a.(*v1.RollingUpdateDeployment), b.(*v1beta1.RollingUpdateDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.RollingUpdateDeployment)(nil), (*v1.RollingUpdateDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_RollingUpdateDeployment_To_v1_RollingUpdateDeployment(a.(*v1beta1.RollingUpdateDeployment), b.(*v1.RollingUpdateDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.RollingUpdateStatefulSetStrategy)(nil), (*v1beta1.RollingUpdateStatefulSetStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_RollingUpdateStatefulSetStrategy_To_v1beta1_RollingUpdateStatefulSetStrategy(a.(*v1.RollingUpdateStatefulSetStrategy), b.(*v1beta1.RollingUpdateStatefulSetStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.RollingUpdateStatefulSetStrategy)(nil), (*v1.RollingUpdateStatefulSetStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_RollingUpdateStatefulSetStrategy_To_v1_RollingUpdateStatefulSetStrategy(a.(*v1beta1.RollingUpdateStatefulSetStrategy), b.(*v1.RollingUpdateStatefulSetStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.StatefulSet)(nil), (*v1beta1.StatefulSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_StatefulSet_To_v1beta1_StatefulSet(a.(*v1.StatefulSet), b.(*v1beta1.StatefulSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.StatefulSet)(nil), (*v1.StatefulSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_StatefulSet_To_v1_StatefulSet(a.(*v1beta1.StatefulSet), b.(*v1.StatefulSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.StatefulSetCondition)(nil), (*v1beta1.StatefulSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_StatefulSetCondition_To_v1beta1_StatefulSetCondition(a.(*v1.StatefulSetCondition), b.(*v1beta1.StatefulSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.StatefulSetCondition)(nil), (*v1.StatefulSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_StatefulSetCondition_To_v1_StatefulSetCondition(a.(*v1beta1.StatefulSetCondition), b.(*v1.StatefulSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.StatefulSetList)(nil), (*v1beta1.StatefulSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_StatefulSetList_To_v1beta1_StatefulSetList(a.(*v1.StatefulSetList), b.(*v1beta1.StatefulSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.StatefulSetList)(nil), (*v1.StatefulSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_StatefulSetList_To_v1_StatefulSetList(a.(*v1beta1.StatefulSetList), b.(*v1.StatefulSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.StatefulSetSpec)(nil), (*v1beta1.StatefulSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_StatefulSetSpec_To_v1beta1_StatefulSetSpec(a.(*v1.StatefulSetSpec), b.(*v1beta1.StatefulSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.StatefulSetSpec)(nil), (*v1.StatefulSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_StatefulSetSpec_To_v1_StatefulSetSpec(a.(*v1beta1.StatefulSetSpec), b.(*v1.StatefulSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.StatefulSetStatus)(nil), (*v1beta1.StatefulSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_StatefulSetStatus_To_v1beta1_StatefulSetStatus(a.(*v1.StatefulSetStatus), b.(*v1beta1.StatefulSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.StatefulSetStatus)(nil), (*v1.StatefulSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_StatefulSetStatus_To_v1_StatefulSetStatus(a.(*v1beta1.StatefulSetStatus), b.(*v1.StatefulSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.StatefulSetUpdateStrategy)(nil), (*v1beta1.StatefulSetUpdateStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_StatefulSetUpdateStrategy_To_v1beta1_StatefulSetUpdateStrategy(a.(*v1.StatefulSetUpdateStrategy), b.(*v1beta1.StatefulSetUpdateStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.StatefulSetUpdateStrategy)(nil), (*v1.StatefulSetUpdateStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_StatefulSetUpdateStrategy_To_v1_StatefulSetUpdateStrategy(a.(*v1beta1.StatefulSetUpdateStrategy), b.(*v1.StatefulSetUpdateStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.DeploymentSpec)(nil), (*v1.DeploymentSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DeploymentSpec_To_v1_DeploymentSpec(a.(*v1beta1.DeploymentSpec), b.(*v1.DeploymentSpec), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_ControllerRevision_To_v1beta1_ControllerRevision(in *v1.ControllerRevision, out *v1beta1.ControllerRevision, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Data = in.Data
	out.Revision = in.Revision
	return nil
}

// Convert_v1_ControllerRevision_To_v1beta1_ControllerRevision is an autogenerated conversion function.
func Convert_v1_ControllerRevision_To_v1beta1_ControllerRevision(in *v1.ControllerRevision, out *v1beta1.ControllerRevision, s conversion.Scope) error {
	return autoConvert_v1_ControllerRevision_To_v1beta1_ControllerRevision(in, out, s)
}

func autoConvert_v1beta1_ControllerRevision_To_v1_ControllerRevision(in *v1beta1.ControllerRevision, out *v1.ControllerRevision, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Data = in.Data
	out.Revision = in.Revision
	return nil
}

// Convert_v1beta1_ControllerRevision_To_v1_ControllerRevision is an autogenerated conversion function.
func Convert_v1beta1_ControllerRevision_To_v1_ControllerRevision(in *v1beta1.ControllerRevision, out *v1.ControllerRevision, s conversion.Scope) error {
	return autoConvert_v1beta1_ControllerRevision_To_v1_ControllerRevision(in, out, s)
}

func autoConvert_v1_ControllerRevisionList_To_v1beta1_ControllerRevisionList(in *v1.ControllerRevisionList, out *v1beta1.ControllerRevisionList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1beta1.ControllerRevision)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_ControllerRevisionList_To_v1beta1_ControllerRevisionList is an autogenerated conversion function.
func Convert_v1_ControllerRevisionList_To_v1beta1_ControllerRevisionList(in *v1.ControllerRevisionList, out *v1beta1.ControllerRevisionList, s conversion.Scope) error {
	return autoConvert_v1_ControllerRevisionList_To_v1beta1_ControllerRevisionList(in, out, s)
}

func autoConvert_v1beta1_ControllerRevisionList_To_v1_ControllerRevisionList(in *v1beta1.ControllerRevisionList, out *v1.ControllerRevisionList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.ControllerRevision)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta1_ControllerRevisionList_To_v1_ControllerRevisionList is an autogenerated conversion function.
func Convert_v1beta1_ControllerRevisionList_To_v1_ControllerRevisionList(in *v1beta1.ControllerRevisionList, out *v1.ControllerRevisionList, s conversion.Scope) error {
	return autoConvert_v1beta1_ControllerRevisionList_To_v1_ControllerRevisionList(in, out, s)
}

func autoConvert_v1_DaemonSet_To_v1beta2_DaemonSet(in *v1.DaemonSet, out *v1beta2.DaemonSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_DaemonSetSpec_To_v1beta2_DaemonSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_DaemonSetStatus_To_v1beta2_DaemonSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_DaemonSet_To_v1beta2_DaemonSet is an autogenerated conversion function.
func Convert_v1_DaemonSet_To_v1beta2_DaemonSet(in *v1.DaemonSet, out *v1beta2.DaemonSet, s conversion.Scope) error {
	return autoConvert_v1_DaemonSet_To_v1beta2_DaemonSet(in, out, s)
}

func autoConvert_v1beta2_DaemonSet_To_v1_DaemonSet(in *v1beta2.DaemonSet, out *v1.DaemonSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta2_DaemonSetSpec_To_v1_DaemonSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta2_DaemonSetStatus_To_v1_DaemonSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta2_DaemonSet_To_v1_DaemonSet is an autogenerated conversion function.
func Convert_v1beta2_DaemonSet_To_v1_DaemonSet(in *v1beta2.DaemonSet, out *v1.DaemonSet, s conversion.Scope) error {
	return autoConvert_v1beta2_DaemonSet_To_v1_DaemonSet(in, out, s)
}

func autoConvert_v1_DaemonSetCondition_To_v1beta2_DaemonSetCondition(in *v1.DaemonSetCondition, out *v1beta2.DaemonSetCondition, s conversion.Scope) error {
	out.Type = v1beta2.DaemonSetConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_DaemonSetCondition_To_v1beta2_DaemonSetCondition is an autogenerated conversion function.
func Convert_v1_DaemonSetCondition_To_v1beta2_DaemonSetCondition(in *v1.DaemonSetCondition, out *v1beta2.DaemonSetCondition, s conversion.Scope) error {
	return autoConvert_v1_DaemonSetCondition_To_v1beta2_DaemonSetCondition(in, out, s)
}

func autoConvert_v1beta2_DaemonSetCondition_To_v1_DaemonSetCondition(in *v1beta2.DaemonSetCondition, out *v1.DaemonSetCondition, s conversion.Scope) error {
	out.Type = v1.DaemonSetConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1beta2_DaemonSetCondition_To_v1_DaemonSetCondition is an autogenerated conversion function.
func Convert_v1beta2_DaemonSetCondition_To_v1_DaemonSetCondition(in *v1beta2.DaemonSetCondition, out *v1.DaemonSetCondition, s conversion.Scope) error {
	return autoConvert_v1beta2_DaemonSetCondition_To_v1_DaemonSetCondition(in, out, s)
}

func autoConvert_v1_DaemonSetList_To_v1beta2_DaemonSetList(in *v1.DaemonSetList, out *v1beta2.DaemonSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1beta2.DaemonSet)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_DaemonSetList_To_v1beta2_DaemonSetList is an autogenerated conversion function.
func Convert_v1_DaemonSetList_To_v1beta2_DaemonSetList(in *v1.DaemonSetList, out *v1beta2.DaemonSetList, s conversion.Scope) error {
	return autoConvert_v1_DaemonSetList_To_v1beta2_DaemonSetList(in, out, s)
}

func autoConvert_v1beta2_DaemonSetList_To_v1_DaemonSetList(in *v1beta2.DaemonSetList, out *v1.DaemonSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.DaemonSet)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta2_DaemonSetList_To_v1_DaemonSetList is an autogenerated conversion function.
func Convert_v1beta2_DaemonSetList_To_v1_DaemonSetList(in *v1beta2.DaemonSetList, out *v1.DaemonSetList, s conversion.Scope) error {
	return autoConvert_v1beta2_DaemonSetList_To_v1_DaemonSetList(in, out, s)
}

func autoConvert_v1_DaemonSetSpec_To_v1beta2_DaemonSetSpec(in *v1.DaemonSetSpec, out *v1beta2.DaemonSetSpec, s conversion.Scope) error {
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.Template = in.Template
	if err := Convert_v1_DaemonSetUpdateStrategy_To_v1beta2_DaemonSetUpdateStrategy(&in.UpdateStrategy, &out.UpdateStrategy, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	return nil
}

// Convert_v1_DaemonSetSpec_To_v1beta2_DaemonSetSpec is an autogenerated conversion function.
func Convert_v1_DaemonSetSpec_To_v1beta2_DaemonSetSpec(in *v1.DaemonSetSpec, out *v1beta2.DaemonSetSpec, s conversion.Scope) error {
	return autoConvert_v1_DaemonSetSpec_To_v1beta2_DaemonSetSpec(in, out, s)
}

func autoConvert_v1beta2_DaemonSetSpec_To_v1_DaemonSetSpec(in *v1beta2.DaemonSetSpec, out *v1.DaemonSetSpec, s conversion.Scope) error {
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.Template = in.Template
	if err := Convert_v1beta2_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy(&in.UpdateStrategy, &out.UpdateStrategy, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	return nil
}

// Convert_v1beta2_DaemonSetSpec_To_v1_DaemonSetSpec is an autogenerated conversion function.
func Convert_v1beta2_DaemonSetSpec_To_v1_DaemonSetSpec(in *v1beta2.DaemonSetSpec, out *v1.DaemonSetSpec, s conversion.Scope) error {
	return autoConvert_v1beta2_DaemonSetSpec_To_v1_DaemonSetSpec(in, out, s)
}

func autoConvert_v1_DaemonSetStatus_To_v1beta2_DaemonSetStatus(in *v1.DaemonSetStatus, out *v1beta2.DaemonSetStatus, s conversion.Scope) error {
	out.CurrentNumberScheduled = in.CurrentNumberScheduled
	out.NumberMisscheduled = in.NumberMisscheduled
	out.DesiredNumberScheduled = in.DesiredNumberScheduled
	out.NumberReady = in.NumberReady
	out.ObservedGeneration = in.ObservedGeneration
	out.UpdatedNumberScheduled = in.UpdatedNumberScheduled
	out.NumberAvailable = in.NumberAvailable
	out.NumberUnavailable = in.NumberUnavailable
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	out.Conditions = *(*[]v1beta2.DaemonSetCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1_DaemonSetStatus_To_v1beta2_DaemonSetStatus is an autogenerated conversion function.
func Convert_v1_DaemonSetStatus_To_v1beta2_DaemonSetStatus(in *v1.DaemonSetStatus, out *v1beta2.DaemonSetStatus, s conversion.Scope) error {
	return autoConvert_v1_DaemonSetStatus_To_v1beta2_DaemonSetStatus(in, out, s)
}

func autoConvert_v1beta2_DaemonSetStatus_To_v1_DaemonSetStatus(in *v1beta2.DaemonSetStatus, out *v1.DaemonSetStatus, s conversion.Scope) error {
	out.CurrentNumberScheduled = in.CurrentNumberScheduled
	out.NumberMisscheduled = in.NumberMisscheduled
	out.DesiredNumberScheduled = in.DesiredNumberScheduled
	out.NumberReady = in.NumberReady
	out.ObservedGeneration = in.ObservedGeneration
	out.UpdatedNumberScheduled = in.UpdatedNumberScheduled
	out.NumberAvailable = in.NumberAvailable
	out.NumberUnavailable = in.NumberUnavailable
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	out.Conditions = *(*[]v1.DaemonSetCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1beta2_DaemonSetStatus_To_v1_DaemonSetStatus is an autogenerated conversion function.
func Convert_v1beta2_DaemonSetStatus_To_v1_DaemonSetStatus(in *v1beta2.DaemonSetStatus, out *v1.DaemonSetStatus, s conversion.Scope) error {
	return autoConvert_v1beta2_DaemonSetStatus_To_v1_DaemonSetStatus(in, out, s)
}

func autoConvert_v1_DaemonSetUpdateStrategy_To_v1beta2_DaemonSetUpdateStrategy(in *v1.DaemonSetUpdateStrategy, out *v1beta2.DaemonSetUpdateStrategy, s conversion.Scope) error {
	out.Type = v1beta2.DaemonSetUpdateStrategyType(in.Type)
	out.RollingUpdate = (*v1beta2.RollingUpdateDaemonSet)(unsafe.Pointer(in.RollingUpdate))
	return nil
}

// Convert_v1_DaemonSetUpdateStrategy_To_v1beta2_DaemonSetUpdateStrategy is an autogenerated conversion function.
func Convert_v1_DaemonSetUpdateStrategy_To_v1beta2_DaemonSetUpdateStrategy(in *v1.DaemonSetUpdateStrategy, out *v1beta2.DaemonSetUpdateStrategy, s conversion.Scope) error {
	return autoConvert_v1_DaemonSetUpdateStrategy_To_v1beta2_DaemonSetUpdateStrategy(in, out, s)
}

func autoConvert_v1beta2_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy(in *v1beta2.DaemonSetUpdateStrategy, out *v1.DaemonSetUpdateStrategy, s conversion.Scope) error {
	out.Type = v1.DaemonSetUpdateStrategyType(in.Type)
	out.RollingUpdate = (*v1.RollingUpdateDaemonSet)(unsafe.Pointer(in.RollingUpdate))
	return nil
}

// Convert_v1beta2_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy is an autogenerated conversion function.
func Convert_v1beta2_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy(in *v1beta2.DaemonSetUpdateStrategy, out *v1.DaemonSetUpdateStrategy, s conversion.Scope) error {
	return autoConvert_v1beta2_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy(in, out, s)
}

func autoConvert_v1_Deployment_To_v1beta1_Deployment(in *v1.Deployment, out *v1beta1.Deployment, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_DeploymentSpec_To_v1beta1_DeploymentSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_DeploymentStatus_To_v1beta1_DeploymentStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_Deployment_To_v1beta1_Deployment is an autogenerated conversion function.
func Convert_v1_Deployment_To_v1beta1_Deployment(in *v1.Deployment, out *v1beta1.Deployment, s conversion.Scope) error {
	return autoConvert_v1_Deployment_To_v1beta1_Deployment(in, out, s)
}

func autoConvert_v1beta1_Deployment_To_v1_Deployment(in *v1beta1.Deployment, out *v1.Deployment, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_DeploymentSpec_To_v1_DeploymentSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_DeploymentStatus_To_v1_DeploymentStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_Deployment_To_v1_Deployment is an autogenerated conversion function.
func Convert_v1beta1_Deployment_To_v1_Deployment(in *v1beta1.Deployment, out *v1.Deployment, s conversion.Scope) error {
	return autoConvert_v1beta1_Deployment_To_v1_Deployment(in, out, s)
}

func autoConvert_v1_DeploymentCondition_To_v1beta1_DeploymentCondition(in *v1.DeploymentCondition, out *v1beta1.DeploymentCondition, s conversion.Scope) error {
	out.Type = v1beta1.DeploymentConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_DeploymentCondition_To_v1beta1_DeploymentCondition is an autogenerated conversion function.
func Convert_v1_DeploymentCondition_To_v1beta1_DeploymentCondition(in *v1.DeploymentCondition, out *v1beta1.DeploymentCondition, s conversion.Scope) error {
	return autoConvert_v1_DeploymentCondition_To_v1beta1_DeploymentCondition(in, out, s)
}

func autoConvert_v1beta1_DeploymentCondition_To_v1_DeploymentCondition(in *v1beta1.DeploymentCondition, out *v1.DeploymentCondition, s conversion.Scope) error {
	out.Type = v1.DeploymentConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1beta1_DeploymentCondition_To_v1_DeploymentCondition is an autogenerated conversion function.
func Convert_v1beta1_DeploymentCondition_To_v1_DeploymentCondition(in *v1beta1.DeploymentCondition, out *v1.DeploymentCondition, s conversion.Scope) error {
	return autoConvert_v1beta1_DeploymentCondition_To_v1_DeploymentCondition(in, out, s)
}

func autoConvert_v1_DeploymentList_To_v1beta1_DeploymentList(in *v1.DeploymentList, out *v1beta1.DeploymentList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.Deployment, len(*in))
		for i := range *in {
			if err := Convert_v1_Deployment_To_v1beta1_Deployment(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_DeploymentList_To_v1beta1_DeploymentList is an autogenerated conversion function.
func Convert_v1_DeploymentList_To_v1beta1_DeploymentList(in *v1.DeploymentList, out *v1beta1.DeploymentList, s conversion.Scope) error {
	return autoConvert_v1_DeploymentList_To_v1beta1_DeploymentList(in, out, s)
}

func autoConvert_v1beta1_DeploymentList_To_v1_DeploymentList(in *v1beta1.DeploymentList, out *v1.DeploymentList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1.Deployment, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_Deployment_To_v1_Deployment(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_DeploymentList_To_v1_DeploymentList is an autogenerated conversion function.
func Convert_v1beta1_DeploymentList_To_v1_DeploymentList(in *v1beta1.DeploymentList, out *v1.DeploymentList, s conversion.Scope) error {
	return autoConvert_v1beta1_DeploymentList_To_v1_DeploymentList(in, out, s)
}

func autoConvert_v1_DeploymentSpec_To_v1beta1_DeploymentSpec(in *v1.DeploymentSpec, out *v1beta1.DeploymentSpec, s conversion.Scope) error {
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.Template = in.Template
	if err := Convert_v1_DeploymentStrategy_To_v1beta1_DeploymentStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.Paused = in.Paused
	out.ProgressDeadlineSeconds = (*int32)(unsafe.Pointer(in.ProgressDeadlineSeconds))
	return nil
}

// Convert_v1_DeploymentSpec_To_v1beta1_DeploymentSpec is an autogenerated conversion function.
func Convert_v1_DeploymentSpec_To_v1beta1_DeploymentSpec(in *v1.DeploymentSpec, out *v1beta1.DeploymentSpec, s conversion.Scope) error {
	return autoConvert_v1_DeploymentSpec_To_v1beta1_DeploymentSpec(in, out, s)
}

func autoConvert_v1beta1_DeploymentSpec_To_v1_DeploymentSpec(in *v1beta1.DeploymentSpec, out *v1.DeploymentSpec, s conversion.Scope) error {
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.Template = in.Template
	if err := Convert_v1beta1_DeploymentStrategy_To_v1_DeploymentStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.Paused = in.Paused
	// WARNING: in.RollbackTo requires manual conversion: does not exist in peer-type
	out.ProgressDeadlineSeconds = (*int32)(unsafe.Pointer(in.ProgressDeadlineSeconds))
	return nil
}

func autoConvert_v1_DeploymentStatus_To_v1beta1_DeploymentStatus(in *v1.DeploymentStatus, out *v1beta1.DeploymentStatus, s conversion.Scope) error {
	out.ObservedGeneration = in.ObservedGeneration
	out.Replicas = in.Replicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.UnavailableReplicas = in.UnavailableReplicas
	out.Conditions = *(*[]v1beta1.DeploymentCondition)(unsafe.Pointer(&in.Conditions))
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	return nil
}

// Convert_v1_DeploymentStatus_To_v1beta1_DeploymentStatus is an autogenerated conversion function.
func Convert_v1_DeploymentStatus_To_v1beta1_DeploymentStatus(in *v1.DeploymentStatus, out *v1beta1.DeploymentStatus, s conversion.Scope) error {
	return autoConvert_v1_DeploymentStatus_To_v1beta1_DeploymentStatus(in, out, s)
}

func autoConvert_v1beta1_DeploymentStatus_To_v1_DeploymentStatus(in *v1beta1.DeploymentStatus, out *v1.DeploymentStatus, s conversion.Scope) error {
	out.ObservedGeneration = in.ObservedGeneration
	out.Replicas = in.Replicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.UnavailableReplicas = in.UnavailableReplicas
	out.Conditions = *(*[]v1.DeploymentCondition)(unsafe.Pointer(&in.Conditions))
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	return nil
}

// Convert_v1beta1_DeploymentStatus_To_v1_DeploymentStatus is an autogenerated conversion function.
func Convert_v1beta1_DeploymentStatus_To_v1_DeploymentStatus(in *v1beta1.DeploymentStatus, out *v1.DeploymentStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_DeploymentStatus_To_v1_DeploymentStatus(in, out, s)
}

func autoConvert_v1_DeploymentStrategy_To_v1beta1_DeploymentStrategy(in *v1.DeploymentStrategy, out *v1beta1.DeploymentStrategy, s conversion.Scope) error {
	out.Type = v1beta1.DeploymentStrategyType(in.Type)
	out.RollingUpdate = (*v1beta1.RollingUpdateDeployment)(unsafe.Pointer(in.RollingUpdate))
	return nil
}

// Convert_v1_DeploymentStrategy_To_v1beta1_DeploymentStrategy is an autogenerated conversion function.
func Convert_v1_DeploymentStrategy_To_v1beta1_DeploymentStrategy(in *v1.DeploymentStrategy, out *v1beta1.DeploymentStrategy, s conversion.Scope) error {
	return autoConvert_v1_DeploymentStrategy_To_v1beta1_DeploymentStrategy(in, out, s)
}

func autoConvert_v1beta1_DeploymentStrategy_To_v1_DeploymentStrategy(in *v1beta1.DeploymentStrategy, out *v1.DeploymentStrategy, s conversion.Scope) error {
	out.Type = v1.DeploymentStrategyType(in.Type)
	out.RollingUpdate = (*v1.RollingUpdateDeployment)(unsafe.Pointer(in.RollingUpdate))
	return nil
}

// Convert_v1beta1_DeploymentStrategy_To_v1_DeploymentStrategy is an autogenerated conversion function.
func Convert_v1beta1_DeploymentStrategy_To_v1_DeploymentStrategy(in *v1beta1.DeploymentStrategy, out *v1.DeploymentStrategy, s conversion.Scope) error {
	return autoConvert_v1beta1_DeploymentStrategy_To_v1_DeploymentStrategy(in, out, s)
}

func autoConvert_v1_ReplicaSet_To_v1beta2_ReplicaSet(in *v1.ReplicaSet, out *v1beta2.ReplicaSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ReplicaSetSpec_To_v1beta2_ReplicaSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_ReplicaSetStatus_To_v1beta2_ReplicaSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ReplicaSet_To_v1beta2_ReplicaSet is an autogenerated conversion function.
func Convert_v1_ReplicaSet_To_v1beta2_ReplicaSet(in *v1.ReplicaSet, out *v1beta2.ReplicaSet, s conversion.Scope) error {
	return autoConvert_v1_ReplicaSet_To_v1beta2_ReplicaSet(in, out, s)
}

func autoConvert_v1beta2_ReplicaSet_To_v1_ReplicaSet(in *v1beta2.ReplicaSet, out *v1.ReplicaSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta2_ReplicaSetSpec_To_v1_ReplicaSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta2_ReplicaSetStatus_To_v1_ReplicaSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta2_ReplicaSet_To_v1_ReplicaSet is an autogenerated conversion function.
func Convert_v1beta2_ReplicaSet_To_v1_ReplicaSet(in *v1beta2.ReplicaSet, out *v1.ReplicaSet, s conversion.Scope) error {
	return autoConvert_v1beta2_ReplicaSet_To_v1_ReplicaSet(in, out, s)
}

func autoConvert_v1_ReplicaSetCondition_To_v1beta2_ReplicaSetCondition(in *v1.ReplicaSetCondition, out *v1beta2.ReplicaSetCondition, s conversion.Scope) error {
	out.Type = v1beta2.ReplicaSetConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_ReplicaSetCondition_To_v1beta2_ReplicaSetCondition is an autogenerated conversion function.
func Convert_v1_ReplicaSetCondition_To_v1beta2_ReplicaSetCondition(in *v1.ReplicaSetCondition, out *v1beta2.ReplicaSetCondition, s conversion.Scope) error {
	return autoConvert_v1_ReplicaSetCondition_To_v1beta2_ReplicaSetCondition(in, out, s)
}

func autoConvert_v1beta2_ReplicaSetCondition_To_v1_ReplicaSetCondition(in *v1beta2.ReplicaSetCondition, out *v1.ReplicaSetCondition, s conversion.Scope) error {
	out.Type = v1.ReplicaSetConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1beta2_ReplicaSetCondition_To_v1_ReplicaSetCondition is an autogenerated conversion function.
func Convert_v1beta2_ReplicaSetCondition_To_v1_ReplicaSetCondition(in *v1beta2.ReplicaSetCondition, out *v1.ReplicaSetCondition, s conversion.Scope) error {
	return autoConvert_v1beta2_ReplicaSetCondition_To_v1_ReplicaSetCondition(in, out, s)
}

func autoConvert_v1_ReplicaSetList_To_v1beta2_ReplicaSetList(in *v1.ReplicaSetList, out *v1beta2.ReplicaSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1beta2.ReplicaSet)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_ReplicaSetList_To_v1beta2_ReplicaSetList is an autogenerated conversion function.
func Convert_v1_ReplicaSetList_To_v1beta2_ReplicaSetList(in *v1.ReplicaSetList, out *v1beta2.ReplicaSetList, s conversion.Scope) error {
	return autoConvert_v1_ReplicaSetList_To_v1beta2_ReplicaSetList(in, out, s)
}

func autoConvert_v1beta2_ReplicaSetList_To_v1_ReplicaSetList(in *v1beta2.ReplicaSetList, out *v1.ReplicaSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.ReplicaSet)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta2_ReplicaSetList_To_v1_ReplicaSetList is an autogenerated conversion function.
func Convert_v1beta2_ReplicaSetList_To_v1_ReplicaSetList(in *v1beta2.ReplicaSetList, out *v1.ReplicaSetList, s conversion.Scope) error {
	return autoConvert_v1beta2_ReplicaSetList_To_v1_ReplicaSetList(in, out, s)
}

func autoConvert_v1_ReplicaSetSpec_To_v1beta2_ReplicaSetSpec(in *v1.ReplicaSetSpec, out *v1beta2.ReplicaSetSpec, s conversion.Scope) error {
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.MinReadySeconds = in.MinReadySeconds
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.Template = in.Template
	return nil
}

// Convert_v1_ReplicaSetSpec_To_v1beta2_ReplicaSetSpec is an autogenerated conversion function.
func Convert_v1_ReplicaSetSpec_To_v1beta2_ReplicaSetSpec(in *v1.ReplicaSetSpec, out *v1beta2.ReplicaSetSpec, s conversion.Scope) error {
	return autoConvert_v1_ReplicaSetSpec_To_v1beta2_ReplicaSetSpec(in, out, s)
}

func autoConvert_v1beta2_ReplicaSetSpec_To_v1_ReplicaSetSpec(in *v1beta2.ReplicaSetSpec, out *v1.ReplicaSetSpec, s conversion.Scope) error {
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.MinReadySeconds = in.MinReadySeconds
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.Template = in.Template
	return nil
}

// Convert_v1beta2_ReplicaSetSpec_To_v1_ReplicaSetSpec is an autogenerated conversion function.
func Convert_v1beta2_ReplicaSetSpec_To_v1_ReplicaSetSpec(in *v1beta2.ReplicaSetSpec, out *v1.ReplicaSetSpec, s conversion.Scope) error {
	return autoConvert_v1beta2_ReplicaSetSpec_To_v1_ReplicaSetSpec(in, out, s)
}

func autoConvert_v1_ReplicaSetStatus_To_v1beta2_ReplicaSetStatus(in *v1.ReplicaSetStatus, out *v1beta2.ReplicaSetStatus, s conversion.Scope) error {
	out.Replicas = in.Replicas
	out.FullyLabeledReplicas = in.FullyLabeledReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.ObservedGeneration = in.ObservedGeneration
	out.Conditions = *(*[]v1beta2.ReplicaSetCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1_ReplicaSetStatus_To_v1beta2_ReplicaSetStatus is an autogenerated conversion function.
func Convert_v1_ReplicaSetStatus_To_v1beta2_ReplicaSetStatus(in *v1.ReplicaSetStatus, out *v1beta2.ReplicaSetStatus, s conversion.Scope) error {
	return autoConvert_v1_ReplicaSetStatus_To_v1beta2_ReplicaSetStatus(in, out, s)
}

func autoConvert_v1beta2_ReplicaSetStatus_To_v1_ReplicaSetStatus(in *v1beta2.ReplicaSetStatus, out *v1.ReplicaSetStatus, s conversion.Scope) error {
	out.Replicas = in.Replicas
	out.FullyLabeledReplicas = in.FullyLabeledReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.ObservedGeneration = in.ObservedGeneration
	out.Conditions = *(*[]v1.ReplicaSetCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1beta2_ReplicaSetStatus_To_v1_ReplicaSetStatus is an autogenerated conversion function.
func Convert_v1beta2_ReplicaSetStatus_To_v1_ReplicaSetStatus(in *v1beta2.ReplicaSetStatus, out *v1.ReplicaSetStatus, s conversion.Scope) error {
	return autoConvert_v1beta2_ReplicaSetStatus_To_v1_ReplicaSetStatus(in, out, s)
}

func autoConvert_v1_RollingUpdateDaemonSet_To_v1beta2_RollingUpdateDaemonSet(in *v1.RollingUpdateDaemonSet, out *v1beta2.RollingUpdateDaemonSet, s conversion.Scope) error {
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	return nil
}

// Convert_v1_RollingUpdateDaemonSet_To_v1beta2_RollingUpdateDaemonSet is an autogenerated conversion function.
func Convert_v1_RollingUpdateDaemonSet_To_v1beta2_RollingUpdateDaemonSet(in *v1.RollingUpdateDaemonSet, out *v1beta2.RollingUpdateDaemonSet, s conversion.Scope) error {
	return autoConvert_v1_RollingUpdateDaemonSet_To_v1beta2_RollingUpdateDaemonSet(in, out, s)
}

func autoConvert_v1beta2_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet(in *v1beta2.RollingUpdateDaemonSet, out *v1.RollingUpdateDaemonSet, s conversion.Scope) error {
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	return nil
}

// Convert_v1beta2_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet is an autogenerated conversion function.
func Convert_v1beta2_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet(in *v1beta2.RollingUpdateDaemonSet, out *v1.RollingUpdateDaemonSet, s conversion.Scope) error {
	return autoConvert_v1beta2_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet(in, out, s)
}

func autoConvert_v1_RollingUpdateDeployment_To_v1beta1_RollingUpdateDeployment(in *v1.RollingUpdateDeployment, out *v1beta1.RollingUpdateDeployment, s conversion.Scope) error {
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	out.MaxSurge = (*intstr.IntOrString)(unsafe.Pointer(in.MaxSurge))
	return nil
}

// Convert_v1_RollingUpdateDeployment_To_v1beta1_RollingUpdateDeployment is an autogenerated conversion function.
func Convert_v1_RollingUpdateDeployment_To_v1beta1_RollingUpdateDeployment(in *v1.RollingUpdateDeployment, out *v1beta1.RollingUpdateDeployment, s conversion.Scope) error {
	return autoConvert_v1_RollingUpdateDeployment_To_v1beta1_RollingUpdateDeployment(in, out, s)
}

func autoConvert_v1beta1_RollingUpdateDeployment_To_v1_RollingUpdateDeployment(in *v1beta1.RollingUpdateDeployment, out *v1.RollingUpdateDeployment, s conversion.Scope) error {
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	out.MaxSurge = (*intstr.IntOrString)(unsafe.Pointer(in.MaxSurge))
	return nil
}

// Convert_v1beta1_RollingUpdateDeployment_To_v1_RollingUpdateDeployment is an autogenerated conversion function.
func Convert_v1beta1_RollingUpdateDeployment_To_v1_RollingUpdateDeployment(in *v1beta1.RollingUpdateDeployment, out *v1.RollingUpdateDeployment, s conversion.Scope) error {
	return autoConvert_v1beta1_RollingUpdateDeployment_To_v1_RollingUpdateDeployment(in, out, s)
}

func autoConvert_v1_RollingUpdateStatefulSetStrategy_To_v1beta1_RollingUpdateStatefulSetStrategy(in *v1.RollingUpdateStatefulSetStrategy, out *v1beta1.RollingUpdateStatefulSetStrategy, s conversion.Scope) error {
	out.Partition = (*int32)(unsafe.Pointer(in.Partition))
	return nil
}

// Convert_v1_RollingUpdateStatefulSetStrategy_To_v1beta1_RollingUpdateStatefulSetStrategy is an autogenerated conversion function.
func Convert_v1_RollingUpdateStatefulSetStrategy_To_v1beta1_RollingUpdateStatefulSetStrategy(in *v1.RollingUpdateStatefulSetStrategy, out *v1beta1.RollingUpdateStatefulSetStrategy, s conversion.Scope) error {
	return autoConvert_v1_RollingUpdateStatefulSetStrategy_To_v1beta1_RollingUpdateStatefulSetStrategy(in, out, s)
}

func autoConvert_v1beta1_RollingUpdateStatefulSetStrategy_To_v1_RollingUpdateStatefulSetStrategy(in *v1beta1.RollingUpdateStatefulSetStrategy, out *v1.RollingUpdateStatefulSetStrategy, s conversion.Scope) error {
	out.Partition = (*int32)(unsafe.Pointer(in.Partition))
	return nil
}

// Convert_v1beta1_RollingUpdateStatefulSetStrategy_To_v1_RollingUpdateStatefulSetStrategy is an autogenerated conversion function.
func Convert_v1beta1_RollingUpdateStatefulSetStrategy_To_v1_RollingUpdateStatefulSetStrategy(in *v1beta1.RollingUpdateStatefulSetStrategy, out *v1.RollingUpdateStatefulSetStrategy, s conversion.Scope) error {
	return autoConvert_v1beta1_RollingUpdateStatefulSetStrategy_To_v1_RollingUpdateStatefulSetStrategy(in, out, s)
}

func autoConvert_v1_StatefulSet_To_v1beta1_StatefulSet(in *v1.StatefulSet, out *v1beta1.StatefulSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_StatefulSetSpec_To_v1beta1_StatefulSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_StatefulSetStatus_To_v1beta1_StatefulSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_StatefulSet_To_v1beta1_StatefulSet is an autogenerated conversion function.
func Convert_v1_StatefulSet_To_v1beta1_StatefulSet(in *v1.StatefulSet, out *v1beta1.StatefulSet, s conversion.Scope) error {
	return autoConvert_v1_StatefulSet_To_v1beta1_StatefulSet(in, out, s)
}

func autoConvert_v1beta1_StatefulSet_To_v1_StatefulSet(in *v1beta1.StatefulSet, out *v1.StatefulSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_StatefulSetSpec_To_v1_StatefulSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_StatefulSetStatus_To_v1_StatefulSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_StatefulSet_To_v1_StatefulSet is an autogenerated conversion function.
func Convert_v1beta1_StatefulSet_To_v1_StatefulSet(in *v1beta1.StatefulSet, out *v1.StatefulSet, s conversion.Scope) error {
	return autoConvert_v1beta1_StatefulSet_To_v1_StatefulSet(in, out, s)
}

func autoConvert_v1_StatefulSetCondition_To_v1beta1_StatefulSetCondition(in *v1.StatefulSetCondition, out *v1beta1.StatefulSetCondition, s conversion.Scope) error {
	out.Type = v1beta1.StatefulSetConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_StatefulSetCondition_To_v1beta1_StatefulSetCondition is an autogenerated conversion function.
func Convert_v1_StatefulSetCondition_To_v1beta1_StatefulSetCondition(in *v1.StatefulSetCondition, out *v1beta1.StatefulSetCondition, s conversion.Scope) error {
	return autoConvert_v1_StatefulSetCondition_To_v1beta1_StatefulSetCondition(in, out, s)
}

func autoConvert_v1beta1_StatefulSetCondition_To_v1_StatefulSetCondition(in *v1beta1.StatefulSetCondition, out *v1.StatefulSetCondition, s conversion.Scope) error {
	out.Type = v1.StatefulSetConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1beta1_StatefulSetCondition_To_v1_StatefulSetCondition is an autogenerated conversion function.
func Convert_v1beta1_StatefulSetCondition_To_v1_StatefulSetCondition(in *v1beta1.StatefulSetCondition, out *v1.StatefulSetCondition, s conversion.Scope) error {
	return autoConvert_v1beta1_StatefulSetCondition_To_v1_StatefulSetCondition(in, out, s)
}

func autoConvert_v1_StatefulSetList_To_v1beta1_StatefulSetList(in *v1.StatefulSetList, out *v1beta1.StatefulSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.StatefulSet, len(*in))
		for i := range *in {
			if err := Convert_v1_StatefulSet_To_v1beta1_StatefulSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_StatefulSetList_To_v1beta1_StatefulSetList is an autogenerated conversion function.
func Convert_v1_StatefulSetList_To_v1beta1_StatefulSetList(in *v1.StatefulSetList, out *v1beta1.StatefulSetList, s conversion.Scope) error {
	return autoConvert_v1_StatefulSetList_To_v1beta1_StatefulSetList(in, out, s)
}

func autoConvert_v1beta1_StatefulSetList_To_v1_StatefulSetList(in *v1beta1.StatefulSetList, out *v1.StatefulSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1.StatefulSet, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_StatefulSet_To_v1_StatefulSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_StatefulSetList_To_v1_StatefulSetList is an autogenerated conversion function.
func Convert_v1beta1_StatefulSetList_To_v1_StatefulSetList(in *v1beta1.StatefulSetList, out *v1.StatefulSetList, s conversion.Scope) error {
	return autoConvert_v1beta1_StatefulSetList_To_v1_StatefulSetList(in, out, s)
}

func autoConvert_v1_StatefulSetSpec_To_v1beta1_StatefulSetSpec(in *v1.StatefulSetSpec, out *v1beta1.StatefulSetSpec, s conversion.Scope) error {
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.Template = in.Template
	out.VolumeClaimTemplates = *(*[]corev1.PersistentVolumeClaim)(unsafe.Pointer(&in.VolumeClaimTemplates))
	out.ServiceName = in.ServiceName
	out.PodManagementPolicy = v1beta1.PodManagementPolicyType(in.PodManagementPolicy)
	if err := Convert_v1_StatefulSetUpdateStrategy_To_v1beta1_StatefulSetUpdateStrategy(&in.UpdateStrategy, &out.UpdateStrategy, s); err != nil {
		return err
	}
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	return nil
}

// Convert_v1_StatefulSetSpec_To_v1beta1_StatefulSetSpec is an autogenerated conversion function.
func Convert_v1_StatefulSetSpec_To_v1beta1_StatefulSetSpec(in *v1.StatefulSetSpec, out *v1beta1.StatefulSetSpec, s conversion.Scope) error {
	return autoConvert_v1_StatefulSetSpec_To_v1beta1_StatefulSetSpec(in, out, s)
}

func autoConvert_v1beta1_StatefulSetSpec_To_v1_StatefulSetSpec(in *v1beta1.StatefulSetSpec, out *v1.StatefulSetSpec, s conversion.Scope) error {
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.Template = in.Template
	out.VolumeClaimTemplates = *(*[]corev1.PersistentVolumeClaim)(unsafe.Pointer(&in.VolumeClaimTemplates))
	out.ServiceName = in.ServiceName
	out.PodManagementPolicy = v1.PodManagementPolicyType(in.PodManagementPolicy)
	if err := Convert_v1beta1_StatefulSetUpdateStrategy_To_v1_StatefulSetUpdateStrategy(&in.UpdateStrategy, &out.UpdateStrategy, s); err != nil {
		return err
	}
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	return nil
}

// Convert_v1beta1_StatefulSetSpec_To_v1_StatefulSetSpec is an autogenerated conversion function.
func Convert_v1beta1_StatefulSetSpec_To_v1_StatefulSetSpec(in *v1beta1.StatefulSetSpec, out *v1.StatefulSetSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_StatefulSetSpec_To_v1_StatefulSetSpec(in, out, s)
}

func autoConvert_v1_StatefulSetStatus_To_v1beta1_StatefulSetStatus(in *v1.StatefulSetStatus, out *v1beta1.StatefulSetStatus, s conversion.Scope) error {
	if err := metav1.Convert_int64_To_Pointer_int64(&in.ObservedGeneration, &out.ObservedGeneration, s); err != nil {
		return err
	}
	out.Replicas = in.Replicas
	out.ReadyReplicas = in.ReadyReplicas
	out.CurrentReplicas = in.CurrentReplicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.CurrentRevision = in.CurrentRevision
	out.UpdateRevision = in.UpdateRevision
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	out.Conditions = *(*[]v1beta1.StatefulSetCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1_StatefulSetStatus_To_v1beta1_StatefulSetStatus is an autogenerated conversion function.
func Convert_v1_StatefulSetStatus_To_v1beta1_StatefulSetStatus(in *v1.StatefulSetStatus, out *v1beta1.StatefulSetStatus, s conversion.Scope) error {
	return autoConvert_v1_StatefulSetStatus_To_v1beta1_StatefulSetStatus(in, out, s)
}

func autoConvert_v1beta1_StatefulSetStatus_To_v1_StatefulSetStatus(in *v1beta1.StatefulSetStatus, out *v1.StatefulSetStatus, s conversion.Scope) error {
	if err := metav1.Convert_Pointer_int64_To_int64(&in.ObservedGeneration, &out.ObservedGeneration, s); err != nil {
		return err
	}
	out.Replicas = in.Replicas
	out.ReadyReplicas = in.ReadyReplicas
	out.CurrentReplicas = in.CurrentReplicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.CurrentRevision = in.CurrentRevision
	out.UpdateRevision = in.UpdateRevision
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	out.Conditions = *(*[]v1.StatefulSetCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1beta1_StatefulSetStatus_To_v1_StatefulSetStatus is an autogenerated conversion function.
func Convert_v1beta1_StatefulSetStatus_To_v1_StatefulSetStatus(in *v1beta1.StatefulSetStatus, out *v1.StatefulSetStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_StatefulSetStatus_To_v1_StatefulSetStatus(in, out, s)
}

func autoConvert_v1_StatefulSetUpdateStrategy_To_v1beta1_StatefulSetUpdateStrategy(in *v1.StatefulSetUpdateStrategy, out *v1beta1.StatefulSetUpdateStrategy, s conversion.Scope) error {
	out.Type = v1beta1.StatefulSetUpdateStrategyType(in.Type)
	out.RollingUpdate = (*v1beta1.RollingUpdateStatefulSetStrategy)(unsafe.Pointer(in.RollingUpdate))
	return nil
}

// Convert_v1_StatefulSetUpdateStrategy_To_v1beta1_StatefulSetUpdateStrategy is an autogenerated conversion function.
func Convert_v1_StatefulSetUpdateStrategy_To_v1beta1_StatefulSetUpdateStrategy(in *v1.StatefulSetUpdateStrategy, out *v1beta1.StatefulSetUpdateStrategy, s conversion.Scope) error {
	return autoConvert_v1_StatefulSetUpdateStrategy_To_v1beta1_StatefulSetUpdateStrategy(in, out, s)
}

func autoConvert_v1beta1_StatefulSetUpdateStrategy_To_v1_StatefulSetUpdateStrategy(in *v1beta1.StatefulSetUpdateStrategy, out *v1.StatefulSetUpdateStrategy, s conversion.Scope) error {
	out.Type = v1.StatefulSetUpdateStrategyType(in.Type)
	out.RollingUpdate = (*v1.RollingUpdateStatefulSetStrategy)(unsafe.Pointer(in.RollingUpdate))
	return nil
}

// Convert_v1beta1_StatefulSetUpdateStrategy_To_v1_StatefulSetUpdateStrategy is an autogenerated conversion function.
func Convert_v1beta1_StatefulSetUpdateStrategy_To_v1_StatefulSetUpdateStrategy(in *v1beta1.StatefulSetUpdateStrategy, out *v1.StatefulSetUpdateStrategy, s conversion.Scope) error {
	return autoConvert_v1beta1_StatefulSetUpdateStrategy_To_v1_StatefulSetUpdateStrategy(in, out, s)
}
