//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package insights

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/appinsights/mgmt/2022-01-11-preview/insights"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ApplicationType = original.ApplicationType

const (
	ApplicationTypeOther ApplicationType = original.ApplicationTypeOther
	ApplicationTypeWeb   ApplicationType = original.ApplicationTypeWeb
)

type CategoryType = original.CategoryType

const (
	CategoryTypePerformance CategoryType = original.CategoryTypePerformance
	CategoryTypeRetention   CategoryType = original.CategoryTypeRetention
	CategoryTypeTSG         CategoryType = original.CategoryTypeTSG
	CategoryTypeWorkbook    CategoryType = original.CategoryTypeWorkbook
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type FavoriteSourceType = original.FavoriteSourceType

const (
	FavoriteSourceTypeEvents       FavoriteSourceType = original.FavoriteSourceTypeEvents
	FavoriteSourceTypeFunnel       FavoriteSourceType = original.FavoriteSourceTypeFunnel
	FavoriteSourceTypeImpact       FavoriteSourceType = original.FavoriteSourceTypeImpact
	FavoriteSourceTypeNotebook     FavoriteSourceType = original.FavoriteSourceTypeNotebook
	FavoriteSourceTypeRetention    FavoriteSourceType = original.FavoriteSourceTypeRetention
	FavoriteSourceTypeSegmentation FavoriteSourceType = original.FavoriteSourceTypeSegmentation
	FavoriteSourceTypeSessions     FavoriteSourceType = original.FavoriteSourceTypeSessions
	FavoriteSourceTypeUserflows    FavoriteSourceType = original.FavoriteSourceTypeUserflows
)

type FavoriteType = original.FavoriteType

const (
	FavoriteTypeShared FavoriteType = original.FavoriteTypeShared
	FavoriteTypeUser   FavoriteType = original.FavoriteTypeUser
)

type FlowType = original.FlowType

const (
	FlowTypeBluefield FlowType = original.FlowTypeBluefield
)

type IngestionMode = original.IngestionMode

const (
	IngestionModeApplicationInsights                       IngestionMode = original.IngestionModeApplicationInsights
	IngestionModeApplicationInsightsWithDiagnosticSettings IngestionMode = original.IngestionModeApplicationInsightsWithDiagnosticSettings
	IngestionModeLogAnalytics                              IngestionMode = original.IngestionModeLogAnalytics
)

type ItemScope = original.ItemScope

const (
	ItemScopeShared ItemScope = original.ItemScopeShared
	ItemScopeUser   ItemScope = original.ItemScopeUser
)

type ItemScopePath = original.ItemScopePath

const (
	ItemScopePathAnalyticsItems   ItemScopePath = original.ItemScopePathAnalyticsItems
	ItemScopePathMyanalyticsItems ItemScopePath = original.ItemScopePathMyanalyticsItems
)

type ItemType = original.ItemType

const (
	ItemTypeFunction ItemType = original.ItemTypeFunction
	ItemTypeNone     ItemType = original.ItemTypeNone
	ItemTypeQuery    ItemType = original.ItemTypeQuery
	ItemTypeRecent   ItemType = original.ItemTypeRecent
)

type ItemTypeParameter = original.ItemTypeParameter

const (
	ItemTypeParameterFolder   ItemTypeParameter = original.ItemTypeParameterFolder
	ItemTypeParameterFunction ItemTypeParameter = original.ItemTypeParameterFunction
	ItemTypeParameterNone     ItemTypeParameter = original.ItemTypeParameterNone
	ItemTypeParameterQuery    ItemTypeParameter = original.ItemTypeParameterQuery
	ItemTypeParameterRecent   ItemTypeParameter = original.ItemTypeParameterRecent
)

type Kind = original.Kind

const (
	KindShared Kind = original.KindShared
	KindUser   Kind = original.KindUser
)

type ManagedServiceIdentityType = original.ManagedServiceIdentityType

const (
	ManagedServiceIdentityTypeNone                       ManagedServiceIdentityType = original.ManagedServiceIdentityTypeNone
	ManagedServiceIdentityTypeSystemAssigned             ManagedServiceIdentityType = original.ManagedServiceIdentityTypeSystemAssigned
	ManagedServiceIdentityTypeSystemAssignedUserAssigned ManagedServiceIdentityType = original.ManagedServiceIdentityTypeSystemAssignedUserAssigned
	ManagedServiceIdentityTypeUserAssigned               ManagedServiceIdentityType = original.ManagedServiceIdentityTypeUserAssigned
)

type PublicNetworkAccessType = original.PublicNetworkAccessType

const (
	PublicNetworkAccessTypeDisabled PublicNetworkAccessType = original.PublicNetworkAccessTypeDisabled
	PublicNetworkAccessTypeEnabled  PublicNetworkAccessType = original.PublicNetworkAccessTypeEnabled
)

type PurgeState = original.PurgeState

const (
	PurgeStateCompleted PurgeState = original.PurgeStateCompleted
	PurgeStatePending   PurgeState = original.PurgeStatePending
)

type RequestSource = original.RequestSource

const (
	RequestSourceRest RequestSource = original.RequestSourceRest
)

type SharedTypeKind = original.SharedTypeKind

const (
	SharedTypeKindShared SharedTypeKind = original.SharedTypeKindShared
	SharedTypeKindUser   SharedTypeKind = original.SharedTypeKindUser
)

type Type = original.Type

const (
	TypeNone         Type = original.TypeNone
	TypeUserAssigned Type = original.TypeUserAssigned
)

type WebTestKind = original.WebTestKind

const (
	WebTestKindMultistep WebTestKind = original.WebTestKindMultistep
	WebTestKindPing      WebTestKind = original.WebTestKindPing
)

type APIKeyRequest = original.APIKeyRequest
type APIKeysClient = original.APIKeysClient
type AnalyticsItemsClient = original.AnalyticsItemsClient
type Annotation = original.Annotation
type AnnotationError = original.AnnotationError
type AnnotationsClient = original.AnnotationsClient
type AnnotationsListResult = original.AnnotationsListResult
type ApplicationInsightsComponent = original.ApplicationInsightsComponent
type ApplicationInsightsComponentAPIKey = original.ApplicationInsightsComponentAPIKey
type ApplicationInsightsComponentAPIKeyListResult = original.ApplicationInsightsComponentAPIKeyListResult
type ApplicationInsightsComponentAnalyticsItem = original.ApplicationInsightsComponentAnalyticsItem
type ApplicationInsightsComponentAnalyticsItemProperties = original.ApplicationInsightsComponentAnalyticsItemProperties
type ApplicationInsightsComponentAvailableFeatures = original.ApplicationInsightsComponentAvailableFeatures
type ApplicationInsightsComponentBillingFeatures = original.ApplicationInsightsComponentBillingFeatures
type ApplicationInsightsComponentDataVolumeCap = original.ApplicationInsightsComponentDataVolumeCap
type ApplicationInsightsComponentExportConfiguration = original.ApplicationInsightsComponentExportConfiguration
type ApplicationInsightsComponentExportRequest = original.ApplicationInsightsComponentExportRequest
type ApplicationInsightsComponentFavorite = original.ApplicationInsightsComponentFavorite
type ApplicationInsightsComponentFeature = original.ApplicationInsightsComponentFeature
type ApplicationInsightsComponentFeatureCapabilities = original.ApplicationInsightsComponentFeatureCapabilities
type ApplicationInsightsComponentFeatureCapability = original.ApplicationInsightsComponentFeatureCapability
type ApplicationInsightsComponentListResult = original.ApplicationInsightsComponentListResult
type ApplicationInsightsComponentListResultIterator = original.ApplicationInsightsComponentListResultIterator
type ApplicationInsightsComponentListResultPage = original.ApplicationInsightsComponentListResultPage
type ApplicationInsightsComponentProactiveDetectionConfiguration = original.ApplicationInsightsComponentProactiveDetectionConfiguration
type ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions = original.ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions
type ApplicationInsightsComponentProperties = original.ApplicationInsightsComponentProperties
type ApplicationInsightsComponentQuotaStatus = original.ApplicationInsightsComponentQuotaStatus
type ApplicationInsightsComponentWebTestLocation = original.ApplicationInsightsComponentWebTestLocation
type ApplicationInsightsWebTestLocationsListResult = original.ApplicationInsightsWebTestLocationsListResult
type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type ComponentAvailableFeaturesClient = original.ComponentAvailableFeaturesClient
type ComponentCurrentBillingFeaturesClient = original.ComponentCurrentBillingFeaturesClient
type ComponentFeatureCapabilitiesClient = original.ComponentFeatureCapabilitiesClient
type ComponentLinkedStorageAccounts = original.ComponentLinkedStorageAccounts
type ComponentLinkedStorageAccountsClient = original.ComponentLinkedStorageAccountsClient
type ComponentLinkedStorageAccountsPatch = original.ComponentLinkedStorageAccountsPatch
type ComponentPurgeBody = original.ComponentPurgeBody
type ComponentPurgeBodyFilters = original.ComponentPurgeBodyFilters
type ComponentPurgeResponse = original.ComponentPurgeResponse
type ComponentPurgeStatusResponse = original.ComponentPurgeStatusResponse
type ComponentQuotaStatusClient = original.ComponentQuotaStatusClient
type ComponentsClient = original.ComponentsClient
type ComponentsResource = original.ComponentsResource
type ErrorDefinition = original.ErrorDefinition
type ErrorResponse = original.ErrorResponse
type ErrorResponseComponents = original.ErrorResponseComponents
type ErrorResponseComponentsError = original.ErrorResponseComponentsError
type ErrorResponseLinkedStorage = original.ErrorResponseLinkedStorage
type ErrorResponseLinkedStorageError = original.ErrorResponseLinkedStorageError
type ExportConfigurationsClient = original.ExportConfigurationsClient
type FavoritesClient = original.FavoritesClient
type InnerError = original.InnerError
type InnerErrorTrace = original.InnerErrorTrace
type LinkedStorageAccountsProperties = original.LinkedStorageAccountsProperties
type ListAnnotation = original.ListAnnotation
type ListApplicationInsightsComponentAnalyticsItem = original.ListApplicationInsightsComponentAnalyticsItem
type ListApplicationInsightsComponentExportConfiguration = original.ListApplicationInsightsComponentExportConfiguration
type ListApplicationInsightsComponentFavorite = original.ListApplicationInsightsComponentFavorite
type ListApplicationInsightsComponentProactiveDetectionConfiguration = original.ListApplicationInsightsComponentProactiveDetectionConfiguration
type LiveTokenClient = original.LiveTokenClient
type LiveTokenResponse = original.LiveTokenResponse
type ManagedServiceIdentity = original.ManagedServiceIdentity
type MyWorkbook = original.MyWorkbook
type MyWorkbookError = original.MyWorkbookError
type MyWorkbookManagedIdentity = original.MyWorkbookManagedIdentity
type MyWorkbookProperties = original.MyWorkbookProperties
type MyWorkbookResource = original.MyWorkbookResource
type MyWorkbookUserAssignedIdentities = original.MyWorkbookUserAssignedIdentities
type MyWorkbooksClient = original.MyWorkbooksClient
type MyWorkbooksListResult = original.MyWorkbooksListResult
type MyWorkbooksListResultIterator = original.MyWorkbooksListResultIterator
type MyWorkbooksListResultPage = original.MyWorkbooksListResultPage
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationInfo = original.OperationInfo
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationLive = original.OperationLive
type OperationsClient = original.OperationsClient
type OperationsListResult = original.OperationsListResult
type PrivateLinkScopedResource = original.PrivateLinkScopedResource
type ProactiveDetectionConfigurationsClient = original.ProactiveDetectionConfigurationsClient
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type SystemData = original.SystemData
type TagsResource = original.TagsResource
type TrackedResource = original.TrackedResource
type UserAssignedIdentity = original.UserAssignedIdentity
type WebTest = original.WebTest
type WebTestGeolocation = original.WebTestGeolocation
type WebTestListResult = original.WebTestListResult
type WebTestListResultIterator = original.WebTestListResultIterator
type WebTestListResultPage = original.WebTestListResultPage
type WebTestLocationsClient = original.WebTestLocationsClient
type WebTestProperties = original.WebTestProperties
type WebTestPropertiesConfiguration = original.WebTestPropertiesConfiguration
type WebTestsClient = original.WebTestsClient
type WebtestsResource = original.WebtestsResource
type WorkItemConfiguration = original.WorkItemConfiguration
type WorkItemConfigurationError = original.WorkItemConfigurationError
type WorkItemConfigurationsClient = original.WorkItemConfigurationsClient
type WorkItemConfigurationsListResult = original.WorkItemConfigurationsListResult
type WorkItemCreateConfiguration = original.WorkItemCreateConfiguration
type Workbook = original.Workbook
type WorkbookError = original.WorkbookError
type WorkbookErrorDefinition = original.WorkbookErrorDefinition
type WorkbookInnerErrorTrace = original.WorkbookInnerErrorTrace
type WorkbookProperties = original.WorkbookProperties
type WorkbookPropertiesUpdateParameters = original.WorkbookPropertiesUpdateParameters
type WorkbookResource = original.WorkbookResource
type WorkbookResourceIdentity = original.WorkbookResourceIdentity
type WorkbookTemplate = original.WorkbookTemplate
type WorkbookTemplateError = original.WorkbookTemplateError
type WorkbookTemplateErrorBody = original.WorkbookTemplateErrorBody
type WorkbookTemplateErrorFieldContract = original.WorkbookTemplateErrorFieldContract
type WorkbookTemplateGallery = original.WorkbookTemplateGallery
type WorkbookTemplateLocalizedGallery = original.WorkbookTemplateLocalizedGallery
type WorkbookTemplateProperties = original.WorkbookTemplateProperties
type WorkbookTemplateResource = original.WorkbookTemplateResource
type WorkbookTemplateUpdateParameters = original.WorkbookTemplateUpdateParameters
type WorkbookTemplatesClient = original.WorkbookTemplatesClient
type WorkbookTemplatesListResult = original.WorkbookTemplatesListResult
type WorkbookUpdateParameters = original.WorkbookUpdateParameters
type WorkbooksClient = original.WorkbooksClient
type WorkbooksListResult = original.WorkbooksListResult
type WorkbooksListResultIterator = original.WorkbooksListResultIterator
type WorkbooksListResultPage = original.WorkbooksListResultPage

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAPIKeysClient(subscriptionID string) APIKeysClient {
	return original.NewAPIKeysClient(subscriptionID)
}
func NewAPIKeysClientWithBaseURI(baseURI string, subscriptionID string) APIKeysClient {
	return original.NewAPIKeysClientWithBaseURI(baseURI, subscriptionID)
}
func NewAnalyticsItemsClient(subscriptionID string) AnalyticsItemsClient {
	return original.NewAnalyticsItemsClient(subscriptionID)
}
func NewAnalyticsItemsClientWithBaseURI(baseURI string, subscriptionID string) AnalyticsItemsClient {
	return original.NewAnalyticsItemsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAnnotationsClient(subscriptionID string) AnnotationsClient {
	return original.NewAnnotationsClient(subscriptionID)
}
func NewAnnotationsClientWithBaseURI(baseURI string, subscriptionID string) AnnotationsClient {
	return original.NewAnnotationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewApplicationInsightsComponentListResultIterator(page ApplicationInsightsComponentListResultPage) ApplicationInsightsComponentListResultIterator {
	return original.NewApplicationInsightsComponentListResultIterator(page)
}
func NewApplicationInsightsComponentListResultPage(cur ApplicationInsightsComponentListResult, getNextPage func(context.Context, ApplicationInsightsComponentListResult) (ApplicationInsightsComponentListResult, error)) ApplicationInsightsComponentListResultPage {
	return original.NewApplicationInsightsComponentListResultPage(cur, getNextPage)
}
func NewComponentAvailableFeaturesClient(subscriptionID string) ComponentAvailableFeaturesClient {
	return original.NewComponentAvailableFeaturesClient(subscriptionID)
}
func NewComponentAvailableFeaturesClientWithBaseURI(baseURI string, subscriptionID string) ComponentAvailableFeaturesClient {
	return original.NewComponentAvailableFeaturesClientWithBaseURI(baseURI, subscriptionID)
}
func NewComponentCurrentBillingFeaturesClient(subscriptionID string) ComponentCurrentBillingFeaturesClient {
	return original.NewComponentCurrentBillingFeaturesClient(subscriptionID)
}
func NewComponentCurrentBillingFeaturesClientWithBaseURI(baseURI string, subscriptionID string) ComponentCurrentBillingFeaturesClient {
	return original.NewComponentCurrentBillingFeaturesClientWithBaseURI(baseURI, subscriptionID)
}
func NewComponentFeatureCapabilitiesClient(subscriptionID string) ComponentFeatureCapabilitiesClient {
	return original.NewComponentFeatureCapabilitiesClient(subscriptionID)
}
func NewComponentFeatureCapabilitiesClientWithBaseURI(baseURI string, subscriptionID string) ComponentFeatureCapabilitiesClient {
	return original.NewComponentFeatureCapabilitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewComponentLinkedStorageAccountsClient(subscriptionID string) ComponentLinkedStorageAccountsClient {
	return original.NewComponentLinkedStorageAccountsClient(subscriptionID)
}
func NewComponentLinkedStorageAccountsClientWithBaseURI(baseURI string, subscriptionID string) ComponentLinkedStorageAccountsClient {
	return original.NewComponentLinkedStorageAccountsClientWithBaseURI(baseURI, subscriptionID)
}
func NewComponentQuotaStatusClient(subscriptionID string) ComponentQuotaStatusClient {
	return original.NewComponentQuotaStatusClient(subscriptionID)
}
func NewComponentQuotaStatusClientWithBaseURI(baseURI string, subscriptionID string) ComponentQuotaStatusClient {
	return original.NewComponentQuotaStatusClientWithBaseURI(baseURI, subscriptionID)
}
func NewComponentsClient(subscriptionID string) ComponentsClient {
	return original.NewComponentsClient(subscriptionID)
}
func NewComponentsClientWithBaseURI(baseURI string, subscriptionID string) ComponentsClient {
	return original.NewComponentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExportConfigurationsClient(subscriptionID string) ExportConfigurationsClient {
	return original.NewExportConfigurationsClient(subscriptionID)
}
func NewExportConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) ExportConfigurationsClient {
	return original.NewExportConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewFavoritesClient(subscriptionID string) FavoritesClient {
	return original.NewFavoritesClient(subscriptionID)
}
func NewFavoritesClientWithBaseURI(baseURI string, subscriptionID string) FavoritesClient {
	return original.NewFavoritesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLiveTokenClient(subscriptionID string) LiveTokenClient {
	return original.NewLiveTokenClient(subscriptionID)
}
func NewLiveTokenClientWithBaseURI(baseURI string, subscriptionID string) LiveTokenClient {
	return original.NewLiveTokenClientWithBaseURI(baseURI, subscriptionID)
}
func NewMyWorkbooksClient(subscriptionID string) MyWorkbooksClient {
	return original.NewMyWorkbooksClient(subscriptionID)
}
func NewMyWorkbooksClientWithBaseURI(baseURI string, subscriptionID string) MyWorkbooksClient {
	return original.NewMyWorkbooksClientWithBaseURI(baseURI, subscriptionID)
}
func NewMyWorkbooksListResultIterator(page MyWorkbooksListResultPage) MyWorkbooksListResultIterator {
	return original.NewMyWorkbooksListResultIterator(page)
}
func NewMyWorkbooksListResultPage(cur MyWorkbooksListResult, getNextPage func(context.Context, MyWorkbooksListResult) (MyWorkbooksListResult, error)) MyWorkbooksListResultPage {
	return original.NewMyWorkbooksListResultPage(cur, getNextPage)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewProactiveDetectionConfigurationsClient(subscriptionID string) ProactiveDetectionConfigurationsClient {
	return original.NewProactiveDetectionConfigurationsClient(subscriptionID)
}
func NewProactiveDetectionConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) ProactiveDetectionConfigurationsClient {
	return original.NewProactiveDetectionConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWebTestListResultIterator(page WebTestListResultPage) WebTestListResultIterator {
	return original.NewWebTestListResultIterator(page)
}
func NewWebTestListResultPage(cur WebTestListResult, getNextPage func(context.Context, WebTestListResult) (WebTestListResult, error)) WebTestListResultPage {
	return original.NewWebTestListResultPage(cur, getNextPage)
}
func NewWebTestLocationsClient(subscriptionID string) WebTestLocationsClient {
	return original.NewWebTestLocationsClient(subscriptionID)
}
func NewWebTestLocationsClientWithBaseURI(baseURI string, subscriptionID string) WebTestLocationsClient {
	return original.NewWebTestLocationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWebTestsClient(subscriptionID string) WebTestsClient {
	return original.NewWebTestsClient(subscriptionID)
}
func NewWebTestsClientWithBaseURI(baseURI string, subscriptionID string) WebTestsClient {
	return original.NewWebTestsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewWorkItemConfigurationsClient(subscriptionID string) WorkItemConfigurationsClient {
	return original.NewWorkItemConfigurationsClient(subscriptionID)
}
func NewWorkItemConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) WorkItemConfigurationsClient {
	return original.NewWorkItemConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkbookTemplatesClient(subscriptionID string) WorkbookTemplatesClient {
	return original.NewWorkbookTemplatesClient(subscriptionID)
}
func NewWorkbookTemplatesClientWithBaseURI(baseURI string, subscriptionID string) WorkbookTemplatesClient {
	return original.NewWorkbookTemplatesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkbooksClient(subscriptionID string) WorkbooksClient {
	return original.NewWorkbooksClient(subscriptionID)
}
func NewWorkbooksClientWithBaseURI(baseURI string, subscriptionID string) WorkbooksClient {
	return original.NewWorkbooksClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkbooksListResultIterator(page WorkbooksListResultPage) WorkbooksListResultIterator {
	return original.NewWorkbooksListResultIterator(page)
}
func NewWorkbooksListResultPage(cur WorkbooksListResult, getNextPage func(context.Context, WorkbooksListResult) (WorkbooksListResult, error)) WorkbooksListResultPage {
	return original.NewWorkbooksListResultPage(cur, getNextPage)
}
func PossibleApplicationTypeValues() []ApplicationType {
	return original.PossibleApplicationTypeValues()
}
func PossibleCategoryTypeValues() []CategoryType {
	return original.PossibleCategoryTypeValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleFavoriteSourceTypeValues() []FavoriteSourceType {
	return original.PossibleFavoriteSourceTypeValues()
}
func PossibleFavoriteTypeValues() []FavoriteType {
	return original.PossibleFavoriteTypeValues()
}
func PossibleFlowTypeValues() []FlowType {
	return original.PossibleFlowTypeValues()
}
func PossibleIngestionModeValues() []IngestionMode {
	return original.PossibleIngestionModeValues()
}
func PossibleItemScopePathValues() []ItemScopePath {
	return original.PossibleItemScopePathValues()
}
func PossibleItemScopeValues() []ItemScope {
	return original.PossibleItemScopeValues()
}
func PossibleItemTypeParameterValues() []ItemTypeParameter {
	return original.PossibleItemTypeParameterValues()
}
func PossibleItemTypeValues() []ItemType {
	return original.PossibleItemTypeValues()
}
func PossibleKindValues() []Kind {
	return original.PossibleKindValues()
}
func PossibleManagedServiceIdentityTypeValues() []ManagedServiceIdentityType {
	return original.PossibleManagedServiceIdentityTypeValues()
}
func PossiblePublicNetworkAccessTypeValues() []PublicNetworkAccessType {
	return original.PossiblePublicNetworkAccessTypeValues()
}
func PossiblePurgeStateValues() []PurgeState {
	return original.PossiblePurgeStateValues()
}
func PossibleRequestSourceValues() []RequestSource {
	return original.PossibleRequestSourceValues()
}
func PossibleSharedTypeKindValues() []SharedTypeKind {
	return original.PossibleSharedTypeKindValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func PossibleWebTestKindValues() []WebTestKind {
	return original.PossibleWebTestKindValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
