package appplatform

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/appplatform/mgmt/2022-01-01-preview/appplatform"

// ActiveDeploymentCollection object that includes an array of Deployment resource name and set them as
// active.
type ActiveDeploymentCollection struct {
	// ActiveDeploymentNames - Collection of Deployment name.
	ActiveDeploymentNames *[]string `json:"activeDeploymentNames,omitempty"`
}

// APIPortalCustomDomainProperties the properties of custom domain for API portal
type APIPortalCustomDomainProperties struct {
	// Thumbprint - The thumbprint of bound certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// APIPortalCustomDomainResource custom domain of the API portal
type APIPortalCustomDomainResource struct {
	autorest.Response `json:"-"`
	Properties        *APIPortalCustomDomainProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for APIPortalCustomDomainResource.
func (apcdr APIPortalCustomDomainResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apcdr.Properties != nil {
		objectMap["properties"] = apcdr.Properties
	}
	if apcdr.SystemData != nil {
		objectMap["systemData"] = apcdr.SystemData
	}
	return json.Marshal(objectMap)
}

// APIPortalCustomDomainResourceCollection object that includes an array of API portal custom domain
// resources and a possible link for next set
type APIPortalCustomDomainResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of API portal custom domain resources
	Value *[]APIPortalCustomDomainResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// APIPortalCustomDomainResourceCollectionIterator provides access to a complete listing of
// APIPortalCustomDomainResource values.
type APIPortalCustomDomainResourceCollectionIterator struct {
	i    int
	page APIPortalCustomDomainResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *APIPortalCustomDomainResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APIPortalCustomDomainResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *APIPortalCustomDomainResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter APIPortalCustomDomainResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter APIPortalCustomDomainResourceCollectionIterator) Response() APIPortalCustomDomainResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter APIPortalCustomDomainResourceCollectionIterator) Value() APIPortalCustomDomainResource {
	if !iter.page.NotDone() {
		return APIPortalCustomDomainResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the APIPortalCustomDomainResourceCollectionIterator type.
func NewAPIPortalCustomDomainResourceCollectionIterator(page APIPortalCustomDomainResourceCollectionPage) APIPortalCustomDomainResourceCollectionIterator {
	return APIPortalCustomDomainResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (apcdrc APIPortalCustomDomainResourceCollection) IsEmpty() bool {
	return apcdrc.Value == nil || len(*apcdrc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (apcdrc APIPortalCustomDomainResourceCollection) hasNextLink() bool {
	return apcdrc.NextLink != nil && len(*apcdrc.NextLink) != 0
}

// aPIPortalCustomDomainResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (apcdrc APIPortalCustomDomainResourceCollection) aPIPortalCustomDomainResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !apcdrc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(apcdrc.NextLink)))
}

// APIPortalCustomDomainResourceCollectionPage contains a page of APIPortalCustomDomainResource values.
type APIPortalCustomDomainResourceCollectionPage struct {
	fn     func(context.Context, APIPortalCustomDomainResourceCollection) (APIPortalCustomDomainResourceCollection, error)
	apcdrc APIPortalCustomDomainResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *APIPortalCustomDomainResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APIPortalCustomDomainResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.apcdrc)
		if err != nil {
			return err
		}
		page.apcdrc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *APIPortalCustomDomainResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page APIPortalCustomDomainResourceCollectionPage) NotDone() bool {
	return !page.apcdrc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page APIPortalCustomDomainResourceCollectionPage) Response() APIPortalCustomDomainResourceCollection {
	return page.apcdrc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page APIPortalCustomDomainResourceCollectionPage) Values() []APIPortalCustomDomainResource {
	if page.apcdrc.IsEmpty() {
		return nil
	}
	return *page.apcdrc.Value
}

// Creates a new instance of the APIPortalCustomDomainResourceCollectionPage type.
func NewAPIPortalCustomDomainResourceCollectionPage(cur APIPortalCustomDomainResourceCollection, getNextPage func(context.Context, APIPortalCustomDomainResourceCollection) (APIPortalCustomDomainResourceCollection, error)) APIPortalCustomDomainResourceCollectionPage {
	return APIPortalCustomDomainResourceCollectionPage{
		fn:     getNextPage,
		apcdrc: cur,
	}
}

// APIPortalCustomDomainsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type APIPortalCustomDomainsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(APIPortalCustomDomainsClient) (APIPortalCustomDomainResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *APIPortalCustomDomainsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for APIPortalCustomDomainsCreateOrUpdateFuture.Result.
func (future *APIPortalCustomDomainsCreateOrUpdateFuture) result(client APIPortalCustomDomainsClient) (apcdr APIPortalCustomDomainResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.APIPortalCustomDomainsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		apcdr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.APIPortalCustomDomainsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if apcdr.Response.Response, err = future.GetResult(sender); err == nil && apcdr.Response.Response.StatusCode != http.StatusNoContent {
		apcdr, err = client.CreateOrUpdateResponder(apcdr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.APIPortalCustomDomainsCreateOrUpdateFuture", "Result", apcdr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// APIPortalCustomDomainsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type APIPortalCustomDomainsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(APIPortalCustomDomainsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *APIPortalCustomDomainsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for APIPortalCustomDomainsDeleteFuture.Result.
func (future *APIPortalCustomDomainsDeleteFuture) result(client APIPortalCustomDomainsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.APIPortalCustomDomainsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.APIPortalCustomDomainsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// APIPortalInstance collection of instances belong to the API portal
type APIPortalInstance struct {
	// Name - READ-ONLY; Name of the API portal instance
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; Status of the API portal instance
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for APIPortalInstance.
func (API APIPortalInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// APIPortalProperties API portal properties payload
type APIPortalProperties struct {
	// ProvisioningState - READ-ONLY; State of the API portal. Possible values include: 'APIPortalProvisioningStateCreating', 'APIPortalProvisioningStateUpdating', 'APIPortalProvisioningStateSucceeded', 'APIPortalProvisioningStateFailed', 'APIPortalProvisioningStateDeleting'
	ProvisioningState APIPortalProvisioningState `json:"provisioningState,omitempty"`
	// Public - Indicates whether the API portal exposes endpoint.
	Public *bool `json:"public,omitempty"`
	// URL - READ-ONLY; URL of the API portal, exposed when 'public' is true.
	URL *string `json:"url,omitempty"`
	// HTTPSOnly - Indicate if only https is allowed.
	HTTPSOnly *bool `json:"httpsOnly,omitempty"`
	// GatewayIds - The array of resource Ids of gateway to integrate with API portal.
	GatewayIds *[]string `json:"gatewayIds,omitempty"`
	// SourceUrls - Collection of OpenAPI source URL locations.
	SourceUrls    *[]string      `json:"sourceUrls,omitempty"`
	SsoProperties *SsoProperties `json:"ssoProperties,omitempty"`
	// ResourceRequests - READ-ONLY; The requested resource quantity for required CPU and Memory.
	ResourceRequests *APIPortalResourceRequests `json:"resourceRequests,omitempty"`
	// Instances - READ-ONLY; Collection of instances belong to API portal.
	Instances *[]APIPortalInstance `json:"instances,omitempty"`
}

// MarshalJSON is the custom marshaler for APIPortalProperties.
func (app APIPortalProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if app.Public != nil {
		objectMap["public"] = app.Public
	}
	if app.HTTPSOnly != nil {
		objectMap["httpsOnly"] = app.HTTPSOnly
	}
	if app.GatewayIds != nil {
		objectMap["gatewayIds"] = app.GatewayIds
	}
	if app.SourceUrls != nil {
		objectMap["sourceUrls"] = app.SourceUrls
	}
	if app.SsoProperties != nil {
		objectMap["ssoProperties"] = app.SsoProperties
	}
	return json.Marshal(objectMap)
}

// APIPortalResource API portal resource
type APIPortalResource struct {
	autorest.Response `json:"-"`
	Properties        *APIPortalProperties `json:"properties,omitempty"`
	// Sku - Sku of the API portal resource
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for APIPortalResource.
func (apr APIPortalResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apr.Properties != nil {
		objectMap["properties"] = apr.Properties
	}
	if apr.Sku != nil {
		objectMap["sku"] = apr.Sku
	}
	if apr.SystemData != nil {
		objectMap["systemData"] = apr.SystemData
	}
	return json.Marshal(objectMap)
}

// APIPortalResourceCollection object that includes an array of API portal resources and a possible link
// for next set
type APIPortalResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of API portal resources
	Value *[]APIPortalResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// APIPortalResourceCollectionIterator provides access to a complete listing of APIPortalResource values.
type APIPortalResourceCollectionIterator struct {
	i    int
	page APIPortalResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *APIPortalResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APIPortalResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *APIPortalResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter APIPortalResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter APIPortalResourceCollectionIterator) Response() APIPortalResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter APIPortalResourceCollectionIterator) Value() APIPortalResource {
	if !iter.page.NotDone() {
		return APIPortalResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the APIPortalResourceCollectionIterator type.
func NewAPIPortalResourceCollectionIterator(page APIPortalResourceCollectionPage) APIPortalResourceCollectionIterator {
	return APIPortalResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aprc APIPortalResourceCollection) IsEmpty() bool {
	return aprc.Value == nil || len(*aprc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aprc APIPortalResourceCollection) hasNextLink() bool {
	return aprc.NextLink != nil && len(*aprc.NextLink) != 0
}

// aPIPortalResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aprc APIPortalResourceCollection) aPIPortalResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !aprc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aprc.NextLink)))
}

// APIPortalResourceCollectionPage contains a page of APIPortalResource values.
type APIPortalResourceCollectionPage struct {
	fn   func(context.Context, APIPortalResourceCollection) (APIPortalResourceCollection, error)
	aprc APIPortalResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *APIPortalResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APIPortalResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aprc)
		if err != nil {
			return err
		}
		page.aprc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *APIPortalResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page APIPortalResourceCollectionPage) NotDone() bool {
	return !page.aprc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page APIPortalResourceCollectionPage) Response() APIPortalResourceCollection {
	return page.aprc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page APIPortalResourceCollectionPage) Values() []APIPortalResource {
	if page.aprc.IsEmpty() {
		return nil
	}
	return *page.aprc.Value
}

// Creates a new instance of the APIPortalResourceCollectionPage type.
func NewAPIPortalResourceCollectionPage(cur APIPortalResourceCollection, getNextPage func(context.Context, APIPortalResourceCollection) (APIPortalResourceCollection, error)) APIPortalResourceCollectionPage {
	return APIPortalResourceCollectionPage{
		fn:   getNextPage,
		aprc: cur,
	}
}

// APIPortalResourceRequests resource requests of the API portal
type APIPortalResourceRequests struct {
	// CPU - READ-ONLY; Cpu allocated to each API portal instance
	CPU *string `json:"cpu,omitempty"`
	// Memory - READ-ONLY; Memory allocated to each API portal instance
	Memory *string `json:"memory,omitempty"`
}

// MarshalJSON is the custom marshaler for APIPortalResourceRequests.
func (aprr APIPortalResourceRequests) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// APIPortalsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type APIPortalsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(APIPortalsClient) (APIPortalResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *APIPortalsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for APIPortalsCreateOrUpdateFuture.Result.
func (future *APIPortalsCreateOrUpdateFuture) result(client APIPortalsClient) (apr APIPortalResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.APIPortalsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		apr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.APIPortalsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if apr.Response.Response, err = future.GetResult(sender); err == nil && apr.Response.Response.StatusCode != http.StatusNoContent {
		apr, err = client.CreateOrUpdateResponder(apr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.APIPortalsCreateOrUpdateFuture", "Result", apr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// APIPortalsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type APIPortalsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(APIPortalsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *APIPortalsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for APIPortalsDeleteFuture.Result.
func (future *APIPortalsDeleteFuture) result(client APIPortalsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.APIPortalsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.APIPortalsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationInsightsAgentVersions application Insights agent versions properties payload
type ApplicationInsightsAgentVersions struct {
	// Java - READ-ONLY; Indicates the version of application insight java agent
	Java *string `json:"java,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationInsightsAgentVersions.
func (aiav ApplicationInsightsAgentVersions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AppResource app resource payload
type AppResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the App resource
	Properties *AppResourceProperties `json:"properties,omitempty"`
	// Identity - The Managed Identity type of the app resource
	Identity *ManagedIdentityProperties `json:"identity,omitempty"`
	// Location - The GEO location of the application, always the same with its parent resource
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AppResource.
func (ar AppResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.Properties != nil {
		objectMap["properties"] = ar.Properties
	}
	if ar.Identity != nil {
		objectMap["identity"] = ar.Identity
	}
	if ar.Location != nil {
		objectMap["location"] = ar.Location
	}
	if ar.SystemData != nil {
		objectMap["systemData"] = ar.SystemData
	}
	return json.Marshal(objectMap)
}

// AppResourceCollection object that includes an array of App resources and a possible link for next set
type AppResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of App resources
	Value *[]AppResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// AppResourceCollectionIterator provides access to a complete listing of AppResource values.
type AppResourceCollectionIterator struct {
	i    int
	page AppResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AppResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AppResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AppResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AppResourceCollectionIterator) Response() AppResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AppResourceCollectionIterator) Value() AppResource {
	if !iter.page.NotDone() {
		return AppResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AppResourceCollectionIterator type.
func NewAppResourceCollectionIterator(page AppResourceCollectionPage) AppResourceCollectionIterator {
	return AppResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arc AppResourceCollection) IsEmpty() bool {
	return arc.Value == nil || len(*arc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (arc AppResourceCollection) hasNextLink() bool {
	return arc.NextLink != nil && len(*arc.NextLink) != 0
}

// appResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arc AppResourceCollection) appResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !arc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arc.NextLink)))
}

// AppResourceCollectionPage contains a page of AppResource values.
type AppResourceCollectionPage struct {
	fn  func(context.Context, AppResourceCollection) (AppResourceCollection, error)
	arc AppResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AppResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.arc)
		if err != nil {
			return err
		}
		page.arc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AppResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AppResourceCollectionPage) NotDone() bool {
	return !page.arc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AppResourceCollectionPage) Response() AppResourceCollection {
	return page.arc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AppResourceCollectionPage) Values() []AppResource {
	if page.arc.IsEmpty() {
		return nil
	}
	return *page.arc.Value
}

// Creates a new instance of the AppResourceCollectionPage type.
func NewAppResourceCollectionPage(cur AppResourceCollection, getNextPage func(context.Context, AppResourceCollection) (AppResourceCollection, error)) AppResourceCollectionPage {
	return AppResourceCollectionPage{
		fn:  getNextPage,
		arc: cur,
	}
}

// AppResourceProperties app resource properties payload
type AppResourceProperties struct {
	// Public - Indicates whether the App exposes public endpoint
	Public *bool `json:"public,omitempty"`
	// URL - READ-ONLY; URL of the App
	URL *string `json:"url,omitempty"`
	// AddonConfigs - Collection of addons
	AddonConfigs map[string]map[string]interface{} `json:"addonConfigs"`
	// ProvisioningState - READ-ONLY; Provisioning state of the App. Possible values include: 'AppResourceProvisioningStateSucceeded', 'AppResourceProvisioningStateFailed', 'AppResourceProvisioningStateCreating', 'AppResourceProvisioningStateUpdating', 'AppResourceProvisioningStateDeleting'
	ProvisioningState AppResourceProvisioningState `json:"provisioningState,omitempty"`
	// Fqdn - Fully qualified dns Name.
	Fqdn *string `json:"fqdn,omitempty"`
	// HTTPSOnly - Indicate if only https is allowed.
	HTTPSOnly *bool `json:"httpsOnly,omitempty"`
	// TemporaryDisk - Temporary disk settings
	TemporaryDisk *TemporaryDisk `json:"temporaryDisk,omitempty"`
	// PersistentDisk - Persistent disk settings
	PersistentDisk *PersistentDisk `json:"persistentDisk,omitempty"`
	// CustomPersistentDisks - List of custom persistent disks
	CustomPersistentDisks *[]CustomPersistentDiskResource `json:"customPersistentDisks,omitempty"`
	// EnableEndToEndTLS - Indicate if end to end TLS is enabled.
	EnableEndToEndTLS *bool `json:"enableEndToEndTLS,omitempty"`
	// LoadedCertificates - Collection of loaded certificates
	LoadedCertificates *[]LoadedCertificate `json:"loadedCertificates,omitempty"`
}

// MarshalJSON is the custom marshaler for AppResourceProperties.
func (arp AppResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arp.Public != nil {
		objectMap["public"] = arp.Public
	}
	if arp.AddonConfigs != nil {
		objectMap["addonConfigs"] = arp.AddonConfigs
	}
	if arp.Fqdn != nil {
		objectMap["fqdn"] = arp.Fqdn
	}
	if arp.HTTPSOnly != nil {
		objectMap["httpsOnly"] = arp.HTTPSOnly
	}
	if arp.TemporaryDisk != nil {
		objectMap["temporaryDisk"] = arp.TemporaryDisk
	}
	if arp.PersistentDisk != nil {
		objectMap["persistentDisk"] = arp.PersistentDisk
	}
	if arp.CustomPersistentDisks != nil {
		objectMap["customPersistentDisks"] = arp.CustomPersistentDisks
	}
	if arp.EnableEndToEndTLS != nil {
		objectMap["enableEndToEndTLS"] = arp.EnableEndToEndTLS
	}
	if arp.LoadedCertificates != nil {
		objectMap["loadedCertificates"] = arp.LoadedCertificates
	}
	return json.Marshal(objectMap)
}

// AppsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (AppResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AppsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AppsCreateOrUpdateFuture.Result.
func (future *AppsCreateOrUpdateFuture) result(client AppsClient) (ar AppResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.AppsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.AppsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ar.Response.Response, err = future.GetResult(sender); err == nil && ar.Response.Response.StatusCode != http.StatusNoContent {
		ar, err = client.CreateOrUpdateResponder(ar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.AppsCreateOrUpdateFuture", "Result", ar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type AppsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AppsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AppsDeleteFuture.Result.
func (future *AppsDeleteFuture) result(client AppsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.AppsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.AppsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AppsSetActiveDeploymentsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsSetActiveDeploymentsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (AppResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AppsSetActiveDeploymentsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AppsSetActiveDeploymentsFuture.Result.
func (future *AppsSetActiveDeploymentsFuture) result(client AppsClient) (ar AppResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.AppsSetActiveDeploymentsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.AppsSetActiveDeploymentsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ar.Response.Response, err = future.GetResult(sender); err == nil && ar.Response.Response.StatusCode != http.StatusNoContent {
		ar, err = client.SetActiveDeploymentsResponder(ar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.AppsSetActiveDeploymentsFuture", "Result", ar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type AppsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (AppResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AppsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AppsUpdateFuture.Result.
func (future *AppsUpdateFuture) result(client AppsClient) (ar AppResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.AppsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.AppsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ar.Response.Response, err = future.GetResult(sender); err == nil && ar.Response.Response.StatusCode != http.StatusNoContent {
		ar, err = client.UpdateResponder(ar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.AppsUpdateFuture", "Result", ar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AvailableOperations available operations of the service
type AvailableOperations struct {
	autorest.Response `json:"-"`
	// Value - Collection of available operation details
	Value *[]OperationDetail `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// AvailableOperationsIterator provides access to a complete listing of OperationDetail values.
type AvailableOperationsIterator struct {
	i    int
	page AvailableOperationsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailableOperationsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableOperationsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailableOperationsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailableOperationsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailableOperationsIterator) Response() AvailableOperations {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailableOperationsIterator) Value() OperationDetail {
	if !iter.page.NotDone() {
		return OperationDetail{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailableOperationsIterator type.
func NewAvailableOperationsIterator(page AvailableOperationsPage) AvailableOperationsIterator {
	return AvailableOperationsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ao AvailableOperations) IsEmpty() bool {
	return ao.Value == nil || len(*ao.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ao AvailableOperations) hasNextLink() bool {
	return ao.NextLink != nil && len(*ao.NextLink) != 0
}

// availableOperationsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ao AvailableOperations) availableOperationsPreparer(ctx context.Context) (*http.Request, error) {
	if !ao.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ao.NextLink)))
}

// AvailableOperationsPage contains a page of OperationDetail values.
type AvailableOperationsPage struct {
	fn func(context.Context, AvailableOperations) (AvailableOperations, error)
	ao AvailableOperations
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailableOperationsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableOperationsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ao)
		if err != nil {
			return err
		}
		page.ao = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailableOperationsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailableOperationsPage) NotDone() bool {
	return !page.ao.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailableOperationsPage) Response() AvailableOperations {
	return page.ao
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailableOperationsPage) Values() []OperationDetail {
	if page.ao.IsEmpty() {
		return nil
	}
	return *page.ao.Value
}

// Creates a new instance of the AvailableOperationsPage type.
func NewAvailableOperationsPage(cur AvailableOperations, getNextPage func(context.Context, AvailableOperations) (AvailableOperations, error)) AvailableOperationsPage {
	return AvailableOperationsPage{
		fn: getNextPage,
		ao: cur,
	}
}

// AvailableRuntimeVersions ...
type AvailableRuntimeVersions struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A list of all supported runtime versions.
	Value *[]SupportedRuntimeVersion `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailableRuntimeVersions.
func (arv AvailableRuntimeVersions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureFileVolume the properties of the Azure File volume. Azure File shares are mounted as volumes.
type AzureFileVolume struct {
	// ShareName - The share name of the Azure File share.
	ShareName *string `json:"shareName,omitempty"`
	// MountPath - The mount path of the persistent disk.
	MountPath *string `json:"mountPath,omitempty"`
	// ReadOnly - Indicates whether the persistent disk is a readOnly one.
	ReadOnly *bool `json:"readOnly,omitempty"`
	// MountOptions - These are the mount options for a persistent disk.
	MountOptions *[]string `json:"mountOptions,omitempty"`
	// Type - Possible values include: 'TypeCustomPersistentDiskProperties', 'TypeAzureFileVolume'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFileVolume.
func (afv AzureFileVolume) MarshalJSON() ([]byte, error) {
	afv.Type = TypeAzureFileVolume
	objectMap := make(map[string]interface{})
	if afv.ShareName != nil {
		objectMap["shareName"] = afv.ShareName
	}
	if afv.MountPath != nil {
		objectMap["mountPath"] = afv.MountPath
	}
	if afv.ReadOnly != nil {
		objectMap["readOnly"] = afv.ReadOnly
	}
	if afv.MountOptions != nil {
		objectMap["mountOptions"] = afv.MountOptions
	}
	if afv.Type != "" {
		objectMap["type"] = afv.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureFileVolume is the BasicCustomPersistentDiskProperties implementation for AzureFileVolume.
func (afv AzureFileVolume) AsAzureFileVolume() (*AzureFileVolume, bool) {
	return &afv, true
}

// AsCustomPersistentDiskProperties is the BasicCustomPersistentDiskProperties implementation for AzureFileVolume.
func (afv AzureFileVolume) AsCustomPersistentDiskProperties() (*CustomPersistentDiskProperties, bool) {
	return nil, false
}

// AsBasicCustomPersistentDiskProperties is the BasicCustomPersistentDiskProperties implementation for AzureFileVolume.
func (afv AzureFileVolume) AsBasicCustomPersistentDiskProperties() (BasicCustomPersistentDiskProperties, bool) {
	return &afv, true
}

// BindingResource binding resource payload
type BindingResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the Binding resource
	Properties *BindingResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for BindingResource.
func (br BindingResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if br.Properties != nil {
		objectMap["properties"] = br.Properties
	}
	if br.SystemData != nil {
		objectMap["systemData"] = br.SystemData
	}
	return json.Marshal(objectMap)
}

// BindingResourceCollection object that includes an array of Binding resources and a possible link for
// next set
type BindingResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Binding resources
	Value *[]BindingResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// BindingResourceCollectionIterator provides access to a complete listing of BindingResource values.
type BindingResourceCollectionIterator struct {
	i    int
	page BindingResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BindingResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BindingResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BindingResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BindingResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BindingResourceCollectionIterator) Response() BindingResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BindingResourceCollectionIterator) Value() BindingResource {
	if !iter.page.NotDone() {
		return BindingResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BindingResourceCollectionIterator type.
func NewBindingResourceCollectionIterator(page BindingResourceCollectionPage) BindingResourceCollectionIterator {
	return BindingResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (brc BindingResourceCollection) IsEmpty() bool {
	return brc.Value == nil || len(*brc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (brc BindingResourceCollection) hasNextLink() bool {
	return brc.NextLink != nil && len(*brc.NextLink) != 0
}

// bindingResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (brc BindingResourceCollection) bindingResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !brc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(brc.NextLink)))
}

// BindingResourceCollectionPage contains a page of BindingResource values.
type BindingResourceCollectionPage struct {
	fn  func(context.Context, BindingResourceCollection) (BindingResourceCollection, error)
	brc BindingResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BindingResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BindingResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.brc)
		if err != nil {
			return err
		}
		page.brc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BindingResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BindingResourceCollectionPage) NotDone() bool {
	return !page.brc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BindingResourceCollectionPage) Response() BindingResourceCollection {
	return page.brc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BindingResourceCollectionPage) Values() []BindingResource {
	if page.brc.IsEmpty() {
		return nil
	}
	return *page.brc.Value
}

// Creates a new instance of the BindingResourceCollectionPage type.
func NewBindingResourceCollectionPage(cur BindingResourceCollection, getNextPage func(context.Context, BindingResourceCollection) (BindingResourceCollection, error)) BindingResourceCollectionPage {
	return BindingResourceCollectionPage{
		fn:  getNextPage,
		brc: cur,
	}
}

// BindingResourceProperties binding resource properties payload
type BindingResourceProperties struct {
	// ResourceName - READ-ONLY; The name of the bound resource
	ResourceName *string `json:"resourceName,omitempty"`
	// ResourceType - READ-ONLY; The standard Azure resource type of the bound resource
	ResourceType *string `json:"resourceType,omitempty"`
	// ResourceID - The Azure resource id of the bound resource
	ResourceID *string `json:"resourceId,omitempty"`
	// Key - The key of the bound resource
	Key *string `json:"key,omitempty"`
	// BindingParameters - Binding parameters of the Binding resource
	BindingParameters map[string]interface{} `json:"bindingParameters"`
	// GeneratedProperties - READ-ONLY; The generated Spring Boot property file for this binding. The secret will be deducted.
	GeneratedProperties *string `json:"generatedProperties,omitempty"`
	// CreatedAt - READ-ONLY; Creation time of the Binding resource
	CreatedAt *string `json:"createdAt,omitempty"`
	// UpdatedAt - READ-ONLY; Update time of the Binding resource
	UpdatedAt *string `json:"updatedAt,omitempty"`
}

// MarshalJSON is the custom marshaler for BindingResourceProperties.
func (brp BindingResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if brp.ResourceID != nil {
		objectMap["resourceId"] = brp.ResourceID
	}
	if brp.Key != nil {
		objectMap["key"] = brp.Key
	}
	if brp.BindingParameters != nil {
		objectMap["bindingParameters"] = brp.BindingParameters
	}
	return json.Marshal(objectMap)
}

// BindingsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BindingsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BindingsClient) (BindingResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BindingsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BindingsCreateOrUpdateFuture.Result.
func (future *BindingsCreateOrUpdateFuture) result(client BindingsClient) (br BindingResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BindingsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		br.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.BindingsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if br.Response.Response, err = future.GetResult(sender); err == nil && br.Response.Response.StatusCode != http.StatusNoContent {
		br, err = client.CreateOrUpdateResponder(br.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.BindingsCreateOrUpdateFuture", "Result", br.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BindingsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BindingsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BindingsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BindingsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BindingsDeleteFuture.Result.
func (future *BindingsDeleteFuture) result(client BindingsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BindingsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.BindingsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BindingsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BindingsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BindingsClient) (BindingResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BindingsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BindingsUpdateFuture.Result.
func (future *BindingsUpdateFuture) result(client BindingsClient) (br BindingResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BindingsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		br.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.BindingsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if br.Response.Response, err = future.GetResult(sender); err == nil && br.Response.Response.StatusCode != http.StatusNoContent {
		br, err = client.UpdateResponder(br.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.BindingsUpdateFuture", "Result", br.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Build build resource payload
type Build struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the build resource
	Properties *BuildProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Build.
func (b Build) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.Properties != nil {
		objectMap["properties"] = b.Properties
	}
	if b.SystemData != nil {
		objectMap["systemData"] = b.SystemData
	}
	return json.Marshal(objectMap)
}

// BuildCollection object that includes an array of Build resources and a possible link for next set
type BuildCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Build resources
	Value *[]Build `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// BuildCollectionIterator provides access to a complete listing of Build values.
type BuildCollectionIterator struct {
	i    int
	page BuildCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BuildCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BuildCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BuildCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BuildCollectionIterator) Response() BuildCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BuildCollectionIterator) Value() Build {
	if !iter.page.NotDone() {
		return Build{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BuildCollectionIterator type.
func NewBuildCollectionIterator(page BuildCollectionPage) BuildCollectionIterator {
	return BuildCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bc BuildCollection) IsEmpty() bool {
	return bc.Value == nil || len(*bc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bc BuildCollection) hasNextLink() bool {
	return bc.NextLink != nil && len(*bc.NextLink) != 0
}

// buildCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bc BuildCollection) buildCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !bc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bc.NextLink)))
}

// BuildCollectionPage contains a page of Build values.
type BuildCollectionPage struct {
	fn func(context.Context, BuildCollection) (BuildCollection, error)
	bc BuildCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BuildCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bc)
		if err != nil {
			return err
		}
		page.bc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BuildCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BuildCollectionPage) NotDone() bool {
	return !page.bc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BuildCollectionPage) Response() BuildCollection {
	return page.bc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BuildCollectionPage) Values() []Build {
	if page.bc.IsEmpty() {
		return nil
	}
	return *page.bc.Value
}

// Creates a new instance of the BuildCollectionPage type.
func NewBuildCollectionPage(cur BuildCollection, getNextPage func(context.Context, BuildCollection) (BuildCollection, error)) BuildCollectionPage {
	return BuildCollectionPage{
		fn: getNextPage,
		bc: cur,
	}
}

// BuilderProperties kPack Builder properties payload
type BuilderProperties struct {
	// ProvisioningState - READ-ONLY; Builder provision status. Possible values include: 'BuilderProvisioningStateCreating', 'BuilderProvisioningStateUpdating', 'BuilderProvisioningStateSucceeded', 'BuilderProvisioningStateFailed', 'BuilderProvisioningStateDeleting'
	ProvisioningState BuilderProvisioningState `json:"provisioningState,omitempty"`
	// Stack - Builder cluster stack property.
	Stack *StackProperties `json:"stack,omitempty"`
	// BuildpackGroups - Builder buildpack groups.
	BuildpackGroups *[]BuildpacksGroupProperties `json:"buildpackGroups,omitempty"`
}

// MarshalJSON is the custom marshaler for BuilderProperties.
func (bp BuilderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bp.Stack != nil {
		objectMap["stack"] = bp.Stack
	}
	if bp.BuildpackGroups != nil {
		objectMap["buildpackGroups"] = bp.BuildpackGroups
	}
	return json.Marshal(objectMap)
}

// BuilderResource kPack Builder resource
type BuilderResource struct {
	autorest.Response `json:"-"`
	// Properties - Property of the Builder resource.
	Properties *BuilderProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for BuilderResource.
func (br BuilderResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if br.Properties != nil {
		objectMap["properties"] = br.Properties
	}
	if br.SystemData != nil {
		objectMap["systemData"] = br.SystemData
	}
	return json.Marshal(objectMap)
}

// BuilderResourceCollection object that includes an array of Builder resources and a possible link for
// next set
type BuilderResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Builder resources
	Value *[]BuilderResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// BuilderResourceCollectionIterator provides access to a complete listing of BuilderResource values.
type BuilderResourceCollectionIterator struct {
	i    int
	page BuilderResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BuilderResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuilderResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BuilderResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BuilderResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BuilderResourceCollectionIterator) Response() BuilderResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BuilderResourceCollectionIterator) Value() BuilderResource {
	if !iter.page.NotDone() {
		return BuilderResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BuilderResourceCollectionIterator type.
func NewBuilderResourceCollectionIterator(page BuilderResourceCollectionPage) BuilderResourceCollectionIterator {
	return BuilderResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (brc BuilderResourceCollection) IsEmpty() bool {
	return brc.Value == nil || len(*brc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (brc BuilderResourceCollection) hasNextLink() bool {
	return brc.NextLink != nil && len(*brc.NextLink) != 0
}

// builderResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (brc BuilderResourceCollection) builderResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !brc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(brc.NextLink)))
}

// BuilderResourceCollectionPage contains a page of BuilderResource values.
type BuilderResourceCollectionPage struct {
	fn  func(context.Context, BuilderResourceCollection) (BuilderResourceCollection, error)
	brc BuilderResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BuilderResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuilderResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.brc)
		if err != nil {
			return err
		}
		page.brc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BuilderResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BuilderResourceCollectionPage) NotDone() bool {
	return !page.brc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BuilderResourceCollectionPage) Response() BuilderResourceCollection {
	return page.brc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BuilderResourceCollectionPage) Values() []BuilderResource {
	if page.brc.IsEmpty() {
		return nil
	}
	return *page.brc.Value
}

// Creates a new instance of the BuilderResourceCollectionPage type.
func NewBuilderResourceCollectionPage(cur BuilderResourceCollection, getNextPage func(context.Context, BuilderResourceCollection) (BuilderResourceCollection, error)) BuilderResourceCollectionPage {
	return BuilderResourceCollectionPage{
		fn:  getNextPage,
		brc: cur,
	}
}

// BuildpackBindingCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BuildpackBindingCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BuildpackBindingClient) (BuildpackBindingResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BuildpackBindingCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BuildpackBindingCreateOrUpdateFuture.Result.
func (future *BuildpackBindingCreateOrUpdateFuture) result(client BuildpackBindingClient) (bbr BuildpackBindingResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildpackBindingCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bbr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.BuildpackBindingCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bbr.Response.Response, err = future.GetResult(sender); err == nil && bbr.Response.Response.StatusCode != http.StatusNoContent {
		bbr, err = client.CreateOrUpdateResponder(bbr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.BuildpackBindingCreateOrUpdateFuture", "Result", bbr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BuildpackBindingDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BuildpackBindingDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BuildpackBindingClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BuildpackBindingDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BuildpackBindingDeleteFuture.Result.
func (future *BuildpackBindingDeleteFuture) result(client BuildpackBindingClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildpackBindingDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.BuildpackBindingDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BuildpackBindingLaunchProperties buildpack Binding Launch Properties
type BuildpackBindingLaunchProperties struct {
	// Properties - Non-sensitive properties for launchProperties
	Properties map[string]*string `json:"properties"`
	// Secrets - Sensitive properties for launchProperties
	Secrets map[string]*string `json:"secrets"`
}

// MarshalJSON is the custom marshaler for BuildpackBindingLaunchProperties.
func (bblp BuildpackBindingLaunchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bblp.Properties != nil {
		objectMap["properties"] = bblp.Properties
	}
	if bblp.Secrets != nil {
		objectMap["secrets"] = bblp.Secrets
	}
	return json.Marshal(objectMap)
}

// BuildpackBindingProperties properties of a buildpack binding
type BuildpackBindingProperties struct {
	// BindingType - Buildpack Binding Type. Possible values include: 'BindingTypeApplicationInsights', 'BindingTypeApacheSkyWalking', 'BindingTypeAppDynamics', 'BindingTypeDynatrace', 'BindingTypeNewRelic', 'BindingTypeElasticAPM'
	BindingType BindingType `json:"bindingType,omitempty"`
	// ProvisioningState - READ-ONLY; State of the Buildpack Binding. Possible values include: 'BuildpackBindingProvisioningStateCreating', 'BuildpackBindingProvisioningStateUpdating', 'BuildpackBindingProvisioningStateSucceeded', 'BuildpackBindingProvisioningStateFailed', 'BuildpackBindingProvisioningStateDeleting'
	ProvisioningState BuildpackBindingProvisioningState `json:"provisioningState,omitempty"`
	// LaunchProperties - The object describes the buildpack binding launch properties
	LaunchProperties *BuildpackBindingLaunchProperties `json:"launchProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildpackBindingProperties.
func (bbp BuildpackBindingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bbp.BindingType != "" {
		objectMap["bindingType"] = bbp.BindingType
	}
	if bbp.LaunchProperties != nil {
		objectMap["launchProperties"] = bbp.LaunchProperties
	}
	return json.Marshal(objectMap)
}

// BuildpackBindingResource buildpack Binding Resource object
type BuildpackBindingResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of a buildpack binding
	Properties *BuildpackBindingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildpackBindingResource.
func (bbr BuildpackBindingResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bbr.Properties != nil {
		objectMap["properties"] = bbr.Properties
	}
	if bbr.SystemData != nil {
		objectMap["systemData"] = bbr.SystemData
	}
	return json.Marshal(objectMap)
}

// BuildpackBindingResourceCollection object that includes an array of BuildpackBinding resources and a
// possible link for next set
type BuildpackBindingResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of BuildpackBinding resources
	Value *[]BuildpackBindingResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// BuildpackBindingResourceCollectionIterator provides access to a complete listing of
// BuildpackBindingResource values.
type BuildpackBindingResourceCollectionIterator struct {
	i    int
	page BuildpackBindingResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BuildpackBindingResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildpackBindingResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BuildpackBindingResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BuildpackBindingResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BuildpackBindingResourceCollectionIterator) Response() BuildpackBindingResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BuildpackBindingResourceCollectionIterator) Value() BuildpackBindingResource {
	if !iter.page.NotDone() {
		return BuildpackBindingResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BuildpackBindingResourceCollectionIterator type.
func NewBuildpackBindingResourceCollectionIterator(page BuildpackBindingResourceCollectionPage) BuildpackBindingResourceCollectionIterator {
	return BuildpackBindingResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bbrc BuildpackBindingResourceCollection) IsEmpty() bool {
	return bbrc.Value == nil || len(*bbrc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bbrc BuildpackBindingResourceCollection) hasNextLink() bool {
	return bbrc.NextLink != nil && len(*bbrc.NextLink) != 0
}

// buildpackBindingResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bbrc BuildpackBindingResourceCollection) buildpackBindingResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !bbrc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bbrc.NextLink)))
}

// BuildpackBindingResourceCollectionPage contains a page of BuildpackBindingResource values.
type BuildpackBindingResourceCollectionPage struct {
	fn   func(context.Context, BuildpackBindingResourceCollection) (BuildpackBindingResourceCollection, error)
	bbrc BuildpackBindingResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BuildpackBindingResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildpackBindingResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bbrc)
		if err != nil {
			return err
		}
		page.bbrc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BuildpackBindingResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BuildpackBindingResourceCollectionPage) NotDone() bool {
	return !page.bbrc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BuildpackBindingResourceCollectionPage) Response() BuildpackBindingResourceCollection {
	return page.bbrc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BuildpackBindingResourceCollectionPage) Values() []BuildpackBindingResource {
	if page.bbrc.IsEmpty() {
		return nil
	}
	return *page.bbrc.Value
}

// Creates a new instance of the BuildpackBindingResourceCollectionPage type.
func NewBuildpackBindingResourceCollectionPage(cur BuildpackBindingResourceCollection, getNextPage func(context.Context, BuildpackBindingResourceCollection) (BuildpackBindingResourceCollection, error)) BuildpackBindingResourceCollectionPage {
	return BuildpackBindingResourceCollectionPage{
		fn:   getNextPage,
		bbrc: cur,
	}
}

// BuildpackProperties buildpack properties payload
type BuildpackProperties struct {
	// ID - Id of the buildpack
	ID *string `json:"id,omitempty"`
}

// BuildpacksGroupProperties buildpack group properties of the Builder
type BuildpacksGroupProperties struct {
	// Name - Buildpack group name
	Name *string `json:"name,omitempty"`
	// Buildpacks - Buildpacks in the buildpack group
	Buildpacks *[]BuildpackProperties `json:"buildpacks,omitempty"`
}

// BuildProperties build resource properties payload
type BuildProperties struct {
	// RelativePath - The relative path of source code
	RelativePath *string `json:"relativePath,omitempty"`
	// Builder - The resource id of builder to build the source code
	Builder *string `json:"builder,omitempty"`
	// AgentPool - The resource id of agent pool
	AgentPool *string `json:"agentPool,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the KPack build result. Possible values include: 'BuildProvisioningStateCreating', 'BuildProvisioningStateUpdating', 'BuildProvisioningStateSucceeded', 'BuildProvisioningStateFailed', 'BuildProvisioningStateDeleting'
	ProvisioningState BuildProvisioningState `json:"provisioningState,omitempty"`
	// Env - The environment variables for this build
	Env map[string]*string `json:"env"`
	// TriggeredBuildResult -  The build result triggered by this build
	TriggeredBuildResult *TriggeredBuildResult `json:"triggeredBuildResult,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildProperties.
func (bp BuildProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bp.RelativePath != nil {
		objectMap["relativePath"] = bp.RelativePath
	}
	if bp.Builder != nil {
		objectMap["builder"] = bp.Builder
	}
	if bp.AgentPool != nil {
		objectMap["agentPool"] = bp.AgentPool
	}
	if bp.Env != nil {
		objectMap["env"] = bp.Env
	}
	if bp.TriggeredBuildResult != nil {
		objectMap["triggeredBuildResult"] = bp.TriggeredBuildResult
	}
	return json.Marshal(objectMap)
}

// BuildResult build result resource payload
type BuildResult struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the build result resource
	Properties *BuildResultProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildResult.
func (br BuildResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if br.Properties != nil {
		objectMap["properties"] = br.Properties
	}
	if br.SystemData != nil {
		objectMap["systemData"] = br.SystemData
	}
	return json.Marshal(objectMap)
}

// BuildResultCollection object that includes an array of Build result resources and a possible link for
// next set
type BuildResultCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Build result resources
	Value *[]BuildResult `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// BuildResultCollectionIterator provides access to a complete listing of BuildResult values.
type BuildResultCollectionIterator struct {
	i    int
	page BuildResultCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BuildResultCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildResultCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BuildResultCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BuildResultCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BuildResultCollectionIterator) Response() BuildResultCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BuildResultCollectionIterator) Value() BuildResult {
	if !iter.page.NotDone() {
		return BuildResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BuildResultCollectionIterator type.
func NewBuildResultCollectionIterator(page BuildResultCollectionPage) BuildResultCollectionIterator {
	return BuildResultCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (brc BuildResultCollection) IsEmpty() bool {
	return brc.Value == nil || len(*brc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (brc BuildResultCollection) hasNextLink() bool {
	return brc.NextLink != nil && len(*brc.NextLink) != 0
}

// buildResultCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (brc BuildResultCollection) buildResultCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !brc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(brc.NextLink)))
}

// BuildResultCollectionPage contains a page of BuildResult values.
type BuildResultCollectionPage struct {
	fn  func(context.Context, BuildResultCollection) (BuildResultCollection, error)
	brc BuildResultCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BuildResultCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildResultCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.brc)
		if err != nil {
			return err
		}
		page.brc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BuildResultCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BuildResultCollectionPage) NotDone() bool {
	return !page.brc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BuildResultCollectionPage) Response() BuildResultCollection {
	return page.brc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BuildResultCollectionPage) Values() []BuildResult {
	if page.brc.IsEmpty() {
		return nil
	}
	return *page.brc.Value
}

// Creates a new instance of the BuildResultCollectionPage type.
func NewBuildResultCollectionPage(cur BuildResultCollection, getNextPage func(context.Context, BuildResultCollection) (BuildResultCollection, error)) BuildResultCollectionPage {
	return BuildResultCollectionPage{
		fn:  getNextPage,
		brc: cur,
	}
}

// BuildResultLog build result log resource properties payload
type BuildResultLog struct {
	autorest.Response `json:"-"`
	// BlobURL - The public download URL of this build result log
	BlobURL *string `json:"blobUrl,omitempty"`
}

// BuildResultProperties build result resource properties payload
type BuildResultProperties struct {
	// Name - The name of this build result
	Name *string `json:"name,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the KPack build result. Possible values include: 'BuildResultProvisioningStateQueuing', 'BuildResultProvisioningStateBuilding', 'BuildResultProvisioningStateSucceeded', 'BuildResultProvisioningStateFailed', 'BuildResultProvisioningStateDeleting'
	ProvisioningState BuildResultProvisioningState `json:"provisioningState,omitempty"`
	// BuildPodName - The build pod name which can be used to get the build log streaming.
	BuildPodName *string `json:"buildPodName,omitempty"`
	// BuildStages - READ-ONLY; All of the build stage (init-container and container) resources in build pod.
	BuildStages *[]BuildStageProperties `json:"buildStages,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildResultProperties.
func (brp BuildResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if brp.Name != nil {
		objectMap["name"] = brp.Name
	}
	if brp.BuildPodName != nil {
		objectMap["buildPodName"] = brp.BuildPodName
	}
	return json.Marshal(objectMap)
}

// BuildResultUserSourceInfo reference to a build result
type BuildResultUserSourceInfo struct {
	// BuildResultID - Resource id of an existing succeeded build result under the same Spring instance.
	BuildResultID *string `json:"buildResultId,omitempty"`
	// Version - Version of the source
	Version *string `json:"version,omitempty"`
	// Type - Possible values include: 'TypeBasicUserSourceInfoTypeUserSourceInfo', 'TypeBasicUserSourceInfoTypeUploadedUserSourceInfo', 'TypeBasicUserSourceInfoTypeJar', 'TypeBasicUserSourceInfoTypeSource', 'TypeBasicUserSourceInfoTypeNetCoreZip', 'TypeBasicUserSourceInfoTypeBuildResult', 'TypeBasicUserSourceInfoTypeContainer'
	Type TypeBasicUserSourceInfo `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildResultUserSourceInfo.
func (brusi BuildResultUserSourceInfo) MarshalJSON() ([]byte, error) {
	brusi.Type = TypeBasicUserSourceInfoTypeBuildResult
	objectMap := make(map[string]interface{})
	if brusi.BuildResultID != nil {
		objectMap["buildResultId"] = brusi.BuildResultID
	}
	if brusi.Version != nil {
		objectMap["version"] = brusi.Version
	}
	if brusi.Type != "" {
		objectMap["type"] = brusi.Type
	}
	return json.Marshal(objectMap)
}

// AsUploadedUserSourceInfo is the BasicUserSourceInfo implementation for BuildResultUserSourceInfo.
func (brusi BuildResultUserSourceInfo) AsUploadedUserSourceInfo() (*UploadedUserSourceInfo, bool) {
	return nil, false
}

// AsBasicUploadedUserSourceInfo is the BasicUserSourceInfo implementation for BuildResultUserSourceInfo.
func (brusi BuildResultUserSourceInfo) AsBasicUploadedUserSourceInfo() (BasicUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsJarUploadedUserSourceInfo is the BasicUserSourceInfo implementation for BuildResultUserSourceInfo.
func (brusi BuildResultUserSourceInfo) AsJarUploadedUserSourceInfo() (*JarUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsSourceUploadedUserSourceInfo is the BasicUserSourceInfo implementation for BuildResultUserSourceInfo.
func (brusi BuildResultUserSourceInfo) AsSourceUploadedUserSourceInfo() (*SourceUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsNetCoreZipUploadedUserSourceInfo is the BasicUserSourceInfo implementation for BuildResultUserSourceInfo.
func (brusi BuildResultUserSourceInfo) AsNetCoreZipUploadedUserSourceInfo() (*NetCoreZipUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsBuildResultUserSourceInfo is the BasicUserSourceInfo implementation for BuildResultUserSourceInfo.
func (brusi BuildResultUserSourceInfo) AsBuildResultUserSourceInfo() (*BuildResultUserSourceInfo, bool) {
	return &brusi, true
}

// AsCustomContainerUserSourceInfo is the BasicUserSourceInfo implementation for BuildResultUserSourceInfo.
func (brusi BuildResultUserSourceInfo) AsCustomContainerUserSourceInfo() (*CustomContainerUserSourceInfo, bool) {
	return nil, false
}

// AsUserSourceInfo is the BasicUserSourceInfo implementation for BuildResultUserSourceInfo.
func (brusi BuildResultUserSourceInfo) AsUserSourceInfo() (*UserSourceInfo, bool) {
	return nil, false
}

// AsBasicUserSourceInfo is the BasicUserSourceInfo implementation for BuildResultUserSourceInfo.
func (brusi BuildResultUserSourceInfo) AsBasicUserSourceInfo() (BasicUserSourceInfo, bool) {
	return &brusi, true
}

// BuildService build service resource payload
type BuildService struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the build resource
	Properties *BuildServiceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildService.
func (bs BuildService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bs.Properties != nil {
		objectMap["properties"] = bs.Properties
	}
	if bs.SystemData != nil {
		objectMap["systemData"] = bs.SystemData
	}
	return json.Marshal(objectMap)
}

// BuildServiceAgentPoolProperties build service agent pool properties
type BuildServiceAgentPoolProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the build service agent pool
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PoolSize - build service agent pool size properties
	PoolSize *BuildServiceAgentPoolSizeProperties `json:"poolSize,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildServiceAgentPoolProperties.
func (bsapp BuildServiceAgentPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bsapp.PoolSize != nil {
		objectMap["poolSize"] = bsapp.PoolSize
	}
	return json.Marshal(objectMap)
}

// BuildServiceAgentPoolResource the build service agent pool resource
type BuildServiceAgentPoolResource struct {
	autorest.Response `json:"-"`
	// Properties - build service agent pool properties
	Properties *BuildServiceAgentPoolProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildServiceAgentPoolResource.
func (bsapr BuildServiceAgentPoolResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bsapr.Properties != nil {
		objectMap["properties"] = bsapr.Properties
	}
	if bsapr.SystemData != nil {
		objectMap["systemData"] = bsapr.SystemData
	}
	return json.Marshal(objectMap)
}

// BuildServiceAgentPoolResourceCollection object that includes an array of build service agent pool
// resources and a possible link for next set
type BuildServiceAgentPoolResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of build service agent pool resource
	Value *[]BuildServiceAgentPoolResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// BuildServiceAgentPoolResourceCollectionIterator provides access to a complete listing of
// BuildServiceAgentPoolResource values.
type BuildServiceAgentPoolResourceCollectionIterator struct {
	i    int
	page BuildServiceAgentPoolResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BuildServiceAgentPoolResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceAgentPoolResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BuildServiceAgentPoolResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BuildServiceAgentPoolResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BuildServiceAgentPoolResourceCollectionIterator) Response() BuildServiceAgentPoolResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BuildServiceAgentPoolResourceCollectionIterator) Value() BuildServiceAgentPoolResource {
	if !iter.page.NotDone() {
		return BuildServiceAgentPoolResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BuildServiceAgentPoolResourceCollectionIterator type.
func NewBuildServiceAgentPoolResourceCollectionIterator(page BuildServiceAgentPoolResourceCollectionPage) BuildServiceAgentPoolResourceCollectionIterator {
	return BuildServiceAgentPoolResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bsaprc BuildServiceAgentPoolResourceCollection) IsEmpty() bool {
	return bsaprc.Value == nil || len(*bsaprc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bsaprc BuildServiceAgentPoolResourceCollection) hasNextLink() bool {
	return bsaprc.NextLink != nil && len(*bsaprc.NextLink) != 0
}

// buildServiceAgentPoolResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bsaprc BuildServiceAgentPoolResourceCollection) buildServiceAgentPoolResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !bsaprc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bsaprc.NextLink)))
}

// BuildServiceAgentPoolResourceCollectionPage contains a page of BuildServiceAgentPoolResource values.
type BuildServiceAgentPoolResourceCollectionPage struct {
	fn     func(context.Context, BuildServiceAgentPoolResourceCollection) (BuildServiceAgentPoolResourceCollection, error)
	bsaprc BuildServiceAgentPoolResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BuildServiceAgentPoolResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceAgentPoolResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bsaprc)
		if err != nil {
			return err
		}
		page.bsaprc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BuildServiceAgentPoolResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BuildServiceAgentPoolResourceCollectionPage) NotDone() bool {
	return !page.bsaprc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BuildServiceAgentPoolResourceCollectionPage) Response() BuildServiceAgentPoolResourceCollection {
	return page.bsaprc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BuildServiceAgentPoolResourceCollectionPage) Values() []BuildServiceAgentPoolResource {
	if page.bsaprc.IsEmpty() {
		return nil
	}
	return *page.bsaprc.Value
}

// Creates a new instance of the BuildServiceAgentPoolResourceCollectionPage type.
func NewBuildServiceAgentPoolResourceCollectionPage(cur BuildServiceAgentPoolResourceCollection, getNextPage func(context.Context, BuildServiceAgentPoolResourceCollection) (BuildServiceAgentPoolResourceCollection, error)) BuildServiceAgentPoolResourceCollectionPage {
	return BuildServiceAgentPoolResourceCollectionPage{
		fn:     getNextPage,
		bsaprc: cur,
	}
}

// BuildServiceAgentPoolSizeProperties build service agent pool size properties
type BuildServiceAgentPoolSizeProperties struct {
	// Name - The name of build service agent pool size
	Name *string `json:"name,omitempty"`
	// CPU - READ-ONLY; The cpu property of build service agent pool size
	CPU *string `json:"cpu,omitempty"`
	// Memory - READ-ONLY; The memory property of build service agent pool size
	Memory *string `json:"memory,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildServiceAgentPoolSizeProperties.
func (bsapsp BuildServiceAgentPoolSizeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bsapsp.Name != nil {
		objectMap["name"] = bsapsp.Name
	}
	return json.Marshal(objectMap)
}

// BuildServiceAgentPoolUpdatePutFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BuildServiceAgentPoolUpdatePutFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BuildServiceAgentPoolClient) (BuildServiceAgentPoolResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BuildServiceAgentPoolUpdatePutFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BuildServiceAgentPoolUpdatePutFuture.Result.
func (future *BuildServiceAgentPoolUpdatePutFuture) result(client BuildServiceAgentPoolClient) (bsapr BuildServiceAgentPoolResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceAgentPoolUpdatePutFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bsapr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.BuildServiceAgentPoolUpdatePutFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bsapr.Response.Response, err = future.GetResult(sender); err == nil && bsapr.Response.Response.StatusCode != http.StatusNoContent {
		bsapr, err = client.UpdatePutResponder(bsapr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.BuildServiceAgentPoolUpdatePutFuture", "Result", bsapr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BuildServiceBuilderCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BuildServiceBuilderCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BuildServiceBuilderClient) (BuilderResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BuildServiceBuilderCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BuildServiceBuilderCreateOrUpdateFuture.Result.
func (future *BuildServiceBuilderCreateOrUpdateFuture) result(client BuildServiceBuilderClient) (br BuilderResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceBuilderCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		br.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.BuildServiceBuilderCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if br.Response.Response, err = future.GetResult(sender); err == nil && br.Response.Response.StatusCode != http.StatusNoContent {
		br, err = client.CreateOrUpdateResponder(br.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.BuildServiceBuilderCreateOrUpdateFuture", "Result", br.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BuildServiceBuilderDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BuildServiceBuilderDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BuildServiceBuilderClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BuildServiceBuilderDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BuildServiceBuilderDeleteFuture.Result.
func (future *BuildServiceBuilderDeleteFuture) result(client BuildServiceBuilderClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceBuilderDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.BuildServiceBuilderDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BuildServiceCollection object that includes an array of Build service resources and a possible link for
// next set
type BuildServiceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Build service resources
	Value *[]BuildService `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// BuildServiceCollectionIterator provides access to a complete listing of BuildService values.
type BuildServiceCollectionIterator struct {
	i    int
	page BuildServiceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BuildServiceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BuildServiceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BuildServiceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BuildServiceCollectionIterator) Response() BuildServiceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BuildServiceCollectionIterator) Value() BuildService {
	if !iter.page.NotDone() {
		return BuildService{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BuildServiceCollectionIterator type.
func NewBuildServiceCollectionIterator(page BuildServiceCollectionPage) BuildServiceCollectionIterator {
	return BuildServiceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bsc BuildServiceCollection) IsEmpty() bool {
	return bsc.Value == nil || len(*bsc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bsc BuildServiceCollection) hasNextLink() bool {
	return bsc.NextLink != nil && len(*bsc.NextLink) != 0
}

// buildServiceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bsc BuildServiceCollection) buildServiceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !bsc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bsc.NextLink)))
}

// BuildServiceCollectionPage contains a page of BuildService values.
type BuildServiceCollectionPage struct {
	fn  func(context.Context, BuildServiceCollection) (BuildServiceCollection, error)
	bsc BuildServiceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BuildServiceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bsc)
		if err != nil {
			return err
		}
		page.bsc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BuildServiceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BuildServiceCollectionPage) NotDone() bool {
	return !page.bsc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BuildServiceCollectionPage) Response() BuildServiceCollection {
	return page.bsc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BuildServiceCollectionPage) Values() []BuildService {
	if page.bsc.IsEmpty() {
		return nil
	}
	return *page.bsc.Value
}

// Creates a new instance of the BuildServiceCollectionPage type.
func NewBuildServiceCollectionPage(cur BuildServiceCollection, getNextPage func(context.Context, BuildServiceCollection) (BuildServiceCollection, error)) BuildServiceCollectionPage {
	return BuildServiceCollectionPage{
		fn:  getNextPage,
		bsc: cur,
	}
}

// BuildServiceProperties build service resource properties payload
type BuildServiceProperties struct {
	// KPackVersion - The installed KPack version in this build service.
	KPackVersion *string `json:"kPackVersion,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the KPack build result. Possible values include: 'BuildServiceProvisioningStateCreating', 'BuildServiceProvisioningStateUpdating', 'BuildServiceProvisioningStateSucceeded', 'BuildServiceProvisioningStateFailed', 'BuildServiceProvisioningStateDeleting'
	ProvisioningState BuildServiceProvisioningState `json:"provisioningState,omitempty"`
	// ResourceRequests - The runtime resource configuration of this build service.
	ResourceRequests *BuildServicePropertiesResourceRequests `json:"resourceRequests,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildServiceProperties.
func (bsp BuildServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bsp.KPackVersion != nil {
		objectMap["kPackVersion"] = bsp.KPackVersion
	}
	if bsp.ResourceRequests != nil {
		objectMap["resourceRequests"] = bsp.ResourceRequests
	}
	return json.Marshal(objectMap)
}

// BuildServicePropertiesResourceRequests the runtime resource configuration of this build service.
type BuildServicePropertiesResourceRequests struct {
	// CPU - READ-ONLY; vCPU allocated to the entire build service node pool.
	CPU *string `json:"cpu,omitempty"`
	// Memory - READ-ONLY; Memory allocated to the entire build service node pool.
	Memory *string `json:"memory,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildServicePropertiesResourceRequests.
func (bspR BuildServicePropertiesResourceRequests) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BuildStageProperties the build stage (init-container and container) resources in build pod.
type BuildStageProperties struct {
	// Name - READ-ONLY; The name of this build stage resource.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The provisioning state of this build stage resource. Possible values include: 'KPackBuildStageProvisioningStateNotStarted', 'KPackBuildStageProvisioningStateRunning', 'KPackBuildStageProvisioningStateSucceeded', 'KPackBuildStageProvisioningStateFailed'
	Status KPackBuildStageProvisioningState `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildStageProperties.
func (bsp BuildStageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BasicCertificateProperties certificate resource payload.
type BasicCertificateProperties interface {
	AsKeyVaultCertificateProperties() (*KeyVaultCertificateProperties, bool)
	AsContentCertificateProperties() (*ContentCertificateProperties, bool)
	AsCertificateProperties() (*CertificateProperties, bool)
}

// CertificateProperties certificate resource payload.
type CertificateProperties struct {
	// Thumbprint - READ-ONLY; The thumbprint of certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Issuer - READ-ONLY; The issuer of certificate.
	Issuer *string `json:"issuer,omitempty"`
	// IssuedDate - READ-ONLY; The issue date of certificate.
	IssuedDate *string `json:"issuedDate,omitempty"`
	// ExpirationDate - READ-ONLY; The expiration date of certificate.
	ExpirationDate *string `json:"expirationDate,omitempty"`
	// ActivateDate - READ-ONLY; The activate date of certificate.
	ActivateDate *string `json:"activateDate,omitempty"`
	// SubjectName - READ-ONLY; The subject name of certificate.
	SubjectName *string `json:"subjectName,omitempty"`
	// DNSNames - READ-ONLY; The domain list of certificate.
	DNSNames *[]string `json:"dnsNames,omitempty"`
	// Type - Possible values include: 'TypeBasicCertificatePropertiesTypeCertificateProperties', 'TypeBasicCertificatePropertiesTypeKeyVaultCertificate', 'TypeBasicCertificatePropertiesTypeContentCertificate'
	Type TypeBasicCertificateProperties `json:"type,omitempty"`
}

func unmarshalBasicCertificateProperties(body []byte) (BasicCertificateProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicCertificatePropertiesTypeKeyVaultCertificate):
		var kvcp KeyVaultCertificateProperties
		err := json.Unmarshal(body, &kvcp)
		return kvcp, err
	case string(TypeBasicCertificatePropertiesTypeContentCertificate):
		var ccp ContentCertificateProperties
		err := json.Unmarshal(body, &ccp)
		return ccp, err
	default:
		var cp CertificateProperties
		err := json.Unmarshal(body, &cp)
		return cp, err
	}
}
func unmarshalBasicCertificatePropertiesArray(body []byte) ([]BasicCertificateProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cpArray := make([]BasicCertificateProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cp, err := unmarshalBasicCertificateProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		cpArray[index] = cp
	}
	return cpArray, nil
}

// MarshalJSON is the custom marshaler for CertificateProperties.
func (cp CertificateProperties) MarshalJSON() ([]byte, error) {
	cp.Type = TypeBasicCertificatePropertiesTypeCertificateProperties
	objectMap := make(map[string]interface{})
	if cp.Type != "" {
		objectMap["type"] = cp.Type
	}
	return json.Marshal(objectMap)
}

// AsKeyVaultCertificateProperties is the BasicCertificateProperties implementation for CertificateProperties.
func (cp CertificateProperties) AsKeyVaultCertificateProperties() (*KeyVaultCertificateProperties, bool) {
	return nil, false
}

// AsContentCertificateProperties is the BasicCertificateProperties implementation for CertificateProperties.
func (cp CertificateProperties) AsContentCertificateProperties() (*ContentCertificateProperties, bool) {
	return nil, false
}

// AsCertificateProperties is the BasicCertificateProperties implementation for CertificateProperties.
func (cp CertificateProperties) AsCertificateProperties() (*CertificateProperties, bool) {
	return &cp, true
}

// AsBasicCertificateProperties is the BasicCertificateProperties implementation for CertificateProperties.
func (cp CertificateProperties) AsBasicCertificateProperties() (BasicCertificateProperties, bool) {
	return &cp, true
}

// CertificateResource certificate resource payload.
type CertificateResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the certificate resource payload.
	Properties BasicCertificateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateResource.
func (cr CertificateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = cr.Properties
	if cr.SystemData != nil {
		objectMap["systemData"] = cr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateResource struct.
func (cr *CertificateResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicCertificateProperties(*v)
				if err != nil {
					return err
				}
				cr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				cr.SystemData = &systemData
			}
		}
	}

	return nil
}

// CertificateResourceCollection collection compose of certificate resources list and a possible link for
// next page.
type CertificateResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - The certificate resources list.
	Value *[]CertificateResource `json:"value,omitempty"`
	// NextLink - The link to next page of certificate list.
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateResourceCollectionIterator provides access to a complete listing of CertificateResource
// values.
type CertificateResourceCollectionIterator struct {
	i    int
	page CertificateResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateResourceCollectionIterator) Response() CertificateResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateResourceCollectionIterator) Value() CertificateResource {
	if !iter.page.NotDone() {
		return CertificateResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateResourceCollectionIterator type.
func NewCertificateResourceCollectionIterator(page CertificateResourceCollectionPage) CertificateResourceCollectionIterator {
	return CertificateResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (crc CertificateResourceCollection) IsEmpty() bool {
	return crc.Value == nil || len(*crc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (crc CertificateResourceCollection) hasNextLink() bool {
	return crc.NextLink != nil && len(*crc.NextLink) != 0
}

// certificateResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (crc CertificateResourceCollection) certificateResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !crc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(crc.NextLink)))
}

// CertificateResourceCollectionPage contains a page of CertificateResource values.
type CertificateResourceCollectionPage struct {
	fn  func(context.Context, CertificateResourceCollection) (CertificateResourceCollection, error)
	crc CertificateResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.crc)
		if err != nil {
			return err
		}
		page.crc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateResourceCollectionPage) NotDone() bool {
	return !page.crc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateResourceCollectionPage) Response() CertificateResourceCollection {
	return page.crc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateResourceCollectionPage) Values() []CertificateResource {
	if page.crc.IsEmpty() {
		return nil
	}
	return *page.crc.Value
}

// Creates a new instance of the CertificateResourceCollectionPage type.
func NewCertificateResourceCollectionPage(cur CertificateResourceCollection, getNextPage func(context.Context, CertificateResourceCollection) (CertificateResourceCollection, error)) CertificateResourceCollectionPage {
	return CertificateResourceCollectionPage{
		fn:  getNextPage,
		crc: cur,
	}
}

// CertificatesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CertificatesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CertificatesClient) (CertificateResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CertificatesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CertificatesCreateOrUpdateFuture.Result.
func (future *CertificatesCreateOrUpdateFuture) result(client CertificatesClient) (cr CertificateResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.CertificatesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.CertificatesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cr.Response.Response, err = future.GetResult(sender); err == nil && cr.Response.Response.StatusCode != http.StatusNoContent {
		cr, err = client.CreateOrUpdateResponder(cr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.CertificatesCreateOrUpdateFuture", "Result", cr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CertificatesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CertificatesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CertificatesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CertificatesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CertificatesDeleteFuture.Result.
func (future *CertificatesDeleteFuture) result(client CertificatesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.CertificatesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.CertificatesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudError an error response from the service.
type CloudError struct {
	// Error - An error response from the service.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// ClusterResourceProperties service properties payload
type ClusterResourceProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the Service. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateDeleted', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateMoving', 'ProvisioningStateMoved', 'ProvisioningStateMoveFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// NetworkProfile - Network profile of the Service
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`
	// Version - READ-ONLY; Version of the Service
	Version *int32 `json:"version,omitempty"`
	// ServiceID - READ-ONLY; ServiceInstanceEntity GUID which uniquely identifies a created resource
	ServiceID *string `json:"serviceId,omitempty"`
	// PowerState - READ-ONLY; Power state of the Service. Possible values include: 'PowerStateRunning', 'PowerStateStopped'
	PowerState    PowerState `json:"powerState,omitempty"`
	ZoneRedundant *bool      `json:"zoneRedundant,omitempty"`
	// Fqdn - READ-ONLY; Fully qualified dns name of the service instance
	Fqdn *string `json:"fqdn,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterResourceProperties.
func (crp ClusterResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if crp.NetworkProfile != nil {
		objectMap["networkProfile"] = crp.NetworkProfile
	}
	if crp.ZoneRedundant != nil {
		objectMap["zoneRedundant"] = crp.ZoneRedundant
	}
	return json.Marshal(objectMap)
}

// ConfigServerGitProperty property of git.
type ConfigServerGitProperty struct {
	// Repositories - Repositories of git.
	Repositories *[]GitPatternRepository `json:"repositories,omitempty"`
	// URI - URI of the repository
	URI *string `json:"uri,omitempty"`
	// Label - Label of the repository
	Label *string `json:"label,omitempty"`
	// SearchPaths - Searching path of the repository
	SearchPaths *[]string `json:"searchPaths,omitempty"`
	// Username - Username of git repository basic auth.
	Username *string `json:"username,omitempty"`
	// Password - Password of git repository basic auth.
	Password *string `json:"password,omitempty"`
	// HostKey - Public sshKey of git repository.
	HostKey *string `json:"hostKey,omitempty"`
	// HostKeyAlgorithm - SshKey algorithm of git repository.
	HostKeyAlgorithm *string `json:"hostKeyAlgorithm,omitempty"`
	// PrivateKey - Private sshKey algorithm of git repository.
	PrivateKey *string `json:"privateKey,omitempty"`
	// StrictHostKeyChecking - Strict host key checking or not.
	StrictHostKeyChecking *bool `json:"strictHostKeyChecking,omitempty"`
}

// ConfigServerProperties config server git properties payload
type ConfigServerProperties struct {
	// ProvisioningState - READ-ONLY; State of the config server. Possible values include: 'ConfigServerStateNotAvailable', 'ConfigServerStateDeleted', 'ConfigServerStateFailed', 'ConfigServerStateSucceeded', 'ConfigServerStateUpdating'
	ProvisioningState ConfigServerState `json:"provisioningState,omitempty"`
	// Error - Error when apply config server settings.
	Error *Error `json:"error,omitempty"`
	// ConfigServer - Settings of config server.
	ConfigServer *ConfigServerSettings `json:"configServer,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigServerProperties.
func (csp ConfigServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csp.Error != nil {
		objectMap["error"] = csp.Error
	}
	if csp.ConfigServer != nil {
		objectMap["configServer"] = csp.ConfigServer
	}
	return json.Marshal(objectMap)
}

// ConfigServerResource config Server resource
type ConfigServerResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the Config Server resource
	Properties *ConfigServerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigServerResource.
func (csr ConfigServerResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csr.Properties != nil {
		objectMap["properties"] = csr.Properties
	}
	if csr.SystemData != nil {
		objectMap["systemData"] = csr.SystemData
	}
	return json.Marshal(objectMap)
}

// ConfigServerSettings the settings of config server.
type ConfigServerSettings struct {
	// GitProperty - Property of git environment.
	GitProperty *ConfigServerGitProperty `json:"gitProperty,omitempty"`
}

// ConfigServerSettingsErrorRecord error record of the config server settings
type ConfigServerSettingsErrorRecord struct {
	// Name - The name of the config server settings error record
	Name *string `json:"name,omitempty"`
	// URI - The uri of the config server settings error record
	URI *string `json:"uri,omitempty"`
	// Messages - The detail error messages of the record
	Messages *[]string `json:"messages,omitempty"`
}

// ConfigServerSettingsValidateResult validation result for config server settings
type ConfigServerSettingsValidateResult struct {
	autorest.Response `json:"-"`
	// IsValid - Indicate if the config server settings are valid
	IsValid *bool `json:"isValid,omitempty"`
	// Details - The detail validation results
	Details *[]ConfigServerSettingsErrorRecord `json:"details,omitempty"`
}

// ConfigServersUpdatePatchFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConfigServersUpdatePatchFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConfigServersClient) (ConfigServerResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConfigServersUpdatePatchFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConfigServersUpdatePatchFuture.Result.
func (future *ConfigServersUpdatePatchFuture) result(client ConfigServersClient) (csr ConfigServerResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ConfigServersUpdatePatchFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		csr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.ConfigServersUpdatePatchFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if csr.Response.Response, err = future.GetResult(sender); err == nil && csr.Response.Response.StatusCode != http.StatusNoContent {
		csr, err = client.UpdatePatchResponder(csr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.ConfigServersUpdatePatchFuture", "Result", csr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ConfigServersUpdatePutFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ConfigServersUpdatePutFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConfigServersClient) (ConfigServerResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConfigServersUpdatePutFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConfigServersUpdatePutFuture.Result.
func (future *ConfigServersUpdatePutFuture) result(client ConfigServersClient) (csr ConfigServerResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ConfigServersUpdatePutFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		csr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.ConfigServersUpdatePutFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if csr.Response.Response, err = future.GetResult(sender); err == nil && csr.Response.Response.StatusCode != http.StatusNoContent {
		csr, err = client.UpdatePutResponder(csr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.ConfigServersUpdatePutFuture", "Result", csr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ConfigServersValidateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ConfigServersValidateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConfigServersClient) (ConfigServerSettingsValidateResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConfigServersValidateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConfigServersValidateFuture.Result.
func (future *ConfigServersValidateFuture) result(client ConfigServersClient) (cssvr ConfigServerSettingsValidateResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ConfigServersValidateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cssvr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.ConfigServersValidateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cssvr.Response.Response, err = future.GetResult(sender); err == nil && cssvr.Response.Response.StatusCode != http.StatusNoContent {
		cssvr, err = client.ValidateResponder(cssvr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.ConfigServersValidateFuture", "Result", cssvr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ConfigurationServiceGitProperty property of git environment.
type ConfigurationServiceGitProperty struct {
	Repositories *[]ConfigurationServiceGitRepository `json:"repositories,omitempty"`
}

// ConfigurationServiceGitPropertyValidateResult validation result for configuration service settings
type ConfigurationServiceGitPropertyValidateResult struct {
	// IsValid - Indicate if the configuration service settings are valid
	IsValid *bool `json:"isValid,omitempty"`
	// GitReposValidationResult - The detail validation results
	GitReposValidationResult *[]ValidationMessages `json:"gitReposValidationResult,omitempty"`
}

// ConfigurationServiceGitRepository git repository property payload for Application Configuration Service
type ConfigurationServiceGitRepository struct {
	// Name - Name of the repository
	Name *string `json:"name,omitempty"`
	// Patterns - Collection of patterns of the repository
	Patterns *[]string `json:"patterns,omitempty"`
	// URI - URI of the repository
	URI *string `json:"uri,omitempty"`
	// Label - Label of the repository
	Label *string `json:"label,omitempty"`
	// SearchPaths - Searching path of the repository
	SearchPaths *[]string `json:"searchPaths,omitempty"`
	// Username - Username of git repository basic auth.
	Username *string `json:"username,omitempty"`
	// Password - Password of git repository basic auth.
	Password *string `json:"password,omitempty"`
	// HostKey - Public sshKey of git repository.
	HostKey *string `json:"hostKey,omitempty"`
	// HostKeyAlgorithm - SshKey algorithm of git repository.
	HostKeyAlgorithm *string `json:"hostKeyAlgorithm,omitempty"`
	// PrivateKey - Private sshKey algorithm of git repository.
	PrivateKey *string `json:"privateKey,omitempty"`
	// StrictHostKeyChecking - Strict host key checking or not.
	StrictHostKeyChecking *bool `json:"strictHostKeyChecking,omitempty"`
}

// ConfigurationServiceInstance collection of instances belong to the Application Configuration Service
type ConfigurationServiceInstance struct {
	// Name - READ-ONLY; Name of the Application Configuration Service instance
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; Status of the Application Configuration Service instance
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationServiceInstance.
func (csi ConfigurationServiceInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConfigurationServiceProperties application Configuration Service properties payload
type ConfigurationServiceProperties struct {
	// ProvisioningState - READ-ONLY; State of the Application Configuration Service. Possible values include: 'ConfigurationServiceProvisioningStateCreating', 'ConfigurationServiceProvisioningStateUpdating', 'ConfigurationServiceProvisioningStateSucceeded', 'ConfigurationServiceProvisioningStateFailed', 'ConfigurationServiceProvisioningStateDeleting'
	ProvisioningState ConfigurationServiceProvisioningState `json:"provisioningState,omitempty"`
	// ResourceRequests - The requested resource quantity for required CPU and Memory.
	ResourceRequests *ConfigurationServiceResourceRequests `json:"resourceRequests,omitempty"`
	// Instances - READ-ONLY; Collection of instances belong to Application Configuration Service.
	Instances *[]ConfigurationServiceInstance `json:"instances,omitempty"`
	Settings  *ConfigurationServiceSettings   `json:"settings,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationServiceProperties.
func (csp ConfigurationServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csp.ResourceRequests != nil {
		objectMap["resourceRequests"] = csp.ResourceRequests
	}
	if csp.Settings != nil {
		objectMap["settings"] = csp.Settings
	}
	return json.Marshal(objectMap)
}

// ConfigurationServiceResource application Configuration Service resource
type ConfigurationServiceResource struct {
	autorest.Response `json:"-"`
	Properties        *ConfigurationServiceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationServiceResource.
func (csr ConfigurationServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csr.Properties != nil {
		objectMap["properties"] = csr.Properties
	}
	if csr.SystemData != nil {
		objectMap["systemData"] = csr.SystemData
	}
	return json.Marshal(objectMap)
}

// ConfigurationServiceResourceCollection object that includes an array of configuration service resources
// and a possible link for next set
type ConfigurationServiceResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of configuration service resources
	Value *[]ConfigurationServiceResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConfigurationServiceResourceCollectionIterator provides access to a complete listing of
// ConfigurationServiceResource values.
type ConfigurationServiceResourceCollectionIterator struct {
	i    int
	page ConfigurationServiceResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConfigurationServiceResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConfigurationServiceResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConfigurationServiceResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConfigurationServiceResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConfigurationServiceResourceCollectionIterator) Response() ConfigurationServiceResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConfigurationServiceResourceCollectionIterator) Value() ConfigurationServiceResource {
	if !iter.page.NotDone() {
		return ConfigurationServiceResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConfigurationServiceResourceCollectionIterator type.
func NewConfigurationServiceResourceCollectionIterator(page ConfigurationServiceResourceCollectionPage) ConfigurationServiceResourceCollectionIterator {
	return ConfigurationServiceResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (csrc ConfigurationServiceResourceCollection) IsEmpty() bool {
	return csrc.Value == nil || len(*csrc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (csrc ConfigurationServiceResourceCollection) hasNextLink() bool {
	return csrc.NextLink != nil && len(*csrc.NextLink) != 0
}

// configurationServiceResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (csrc ConfigurationServiceResourceCollection) configurationServiceResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !csrc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(csrc.NextLink)))
}

// ConfigurationServiceResourceCollectionPage contains a page of ConfigurationServiceResource values.
type ConfigurationServiceResourceCollectionPage struct {
	fn   func(context.Context, ConfigurationServiceResourceCollection) (ConfigurationServiceResourceCollection, error)
	csrc ConfigurationServiceResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConfigurationServiceResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConfigurationServiceResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.csrc)
		if err != nil {
			return err
		}
		page.csrc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConfigurationServiceResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConfigurationServiceResourceCollectionPage) NotDone() bool {
	return !page.csrc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConfigurationServiceResourceCollectionPage) Response() ConfigurationServiceResourceCollection {
	return page.csrc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConfigurationServiceResourceCollectionPage) Values() []ConfigurationServiceResource {
	if page.csrc.IsEmpty() {
		return nil
	}
	return *page.csrc.Value
}

// Creates a new instance of the ConfigurationServiceResourceCollectionPage type.
func NewConfigurationServiceResourceCollectionPage(cur ConfigurationServiceResourceCollection, getNextPage func(context.Context, ConfigurationServiceResourceCollection) (ConfigurationServiceResourceCollection, error)) ConfigurationServiceResourceCollectionPage {
	return ConfigurationServiceResourceCollectionPage{
		fn:   getNextPage,
		csrc: cur,
	}
}

// ConfigurationServiceResourceRequests resource request payload of Application Configuration Service
type ConfigurationServiceResourceRequests struct {
	// CPU - READ-ONLY; Cpu allocated to each Application Configuration Service instance
	CPU *string `json:"cpu,omitempty"`
	// Memory - READ-ONLY; Memory allocated to each Application Configuration Service instance
	Memory *string `json:"memory,omitempty"`
	// InstanceCount - READ-ONLY; Instance count of the Application Configuration Service
	InstanceCount *int32 `json:"instanceCount,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationServiceResourceRequests.
func (csrr ConfigurationServiceResourceRequests) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConfigurationServicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConfigurationServicesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConfigurationServicesClient) (ConfigurationServiceResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConfigurationServicesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConfigurationServicesCreateOrUpdateFuture.Result.
func (future *ConfigurationServicesCreateOrUpdateFuture) result(client ConfigurationServicesClient) (csr ConfigurationServiceResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ConfigurationServicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		csr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.ConfigurationServicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if csr.Response.Response, err = future.GetResult(sender); err == nil && csr.Response.Response.StatusCode != http.StatusNoContent {
		csr, err = client.CreateOrUpdateResponder(csr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.ConfigurationServicesCreateOrUpdateFuture", "Result", csr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ConfigurationServicesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConfigurationServicesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConfigurationServicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConfigurationServicesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConfigurationServicesDeleteFuture.Result.
func (future *ConfigurationServicesDeleteFuture) result(client ConfigurationServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ConfigurationServicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.ConfigurationServicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ConfigurationServiceSettings the settings of Application Configuration Service.
type ConfigurationServiceSettings struct {
	GitProperty *ConfigurationServiceGitProperty `json:"gitProperty,omitempty"`
}

// ConfigurationServiceSettingsValidateResult validation result for configuration service settings
type ConfigurationServiceSettingsValidateResult struct {
	autorest.Response           `json:"-"`
	GitPropertyValidationResult *ConfigurationServiceGitPropertyValidateResult `json:"gitPropertyValidationResult,omitempty"`
}

// ConfigurationServicesValidateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConfigurationServicesValidateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConfigurationServicesClient) (ConfigurationServiceSettingsValidateResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConfigurationServicesValidateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConfigurationServicesValidateFuture.Result.
func (future *ConfigurationServicesValidateFuture) result(client ConfigurationServicesClient) (cssvr ConfigurationServiceSettingsValidateResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ConfigurationServicesValidateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cssvr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.ConfigurationServicesValidateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cssvr.Response.Response, err = future.GetResult(sender); err == nil && cssvr.Response.Response.StatusCode != http.StatusNoContent {
		cssvr, err = client.ValidateResponder(cssvr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.ConfigurationServicesValidateFuture", "Result", cssvr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ContainerProbeSettings container liveness and readiness probe settings
type ContainerProbeSettings struct {
	// DisableProbe - Indicates whether disable the liveness and readiness probe
	DisableProbe *bool `json:"disableProbe,omitempty"`
}

// ContentCertificateProperties properties of certificate imported from key vault.
type ContentCertificateProperties struct {
	// Content - The content of uploaded certificate.
	Content *string `json:"content,omitempty"`
	// Thumbprint - READ-ONLY; The thumbprint of certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Issuer - READ-ONLY; The issuer of certificate.
	Issuer *string `json:"issuer,omitempty"`
	// IssuedDate - READ-ONLY; The issue date of certificate.
	IssuedDate *string `json:"issuedDate,omitempty"`
	// ExpirationDate - READ-ONLY; The expiration date of certificate.
	ExpirationDate *string `json:"expirationDate,omitempty"`
	// ActivateDate - READ-ONLY; The activate date of certificate.
	ActivateDate *string `json:"activateDate,omitempty"`
	// SubjectName - READ-ONLY; The subject name of certificate.
	SubjectName *string `json:"subjectName,omitempty"`
	// DNSNames - READ-ONLY; The domain list of certificate.
	DNSNames *[]string `json:"dnsNames,omitempty"`
	// Type - Possible values include: 'TypeBasicCertificatePropertiesTypeCertificateProperties', 'TypeBasicCertificatePropertiesTypeKeyVaultCertificate', 'TypeBasicCertificatePropertiesTypeContentCertificate'
	Type TypeBasicCertificateProperties `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentCertificateProperties.
func (ccp ContentCertificateProperties) MarshalJSON() ([]byte, error) {
	ccp.Type = TypeBasicCertificatePropertiesTypeContentCertificate
	objectMap := make(map[string]interface{})
	if ccp.Content != nil {
		objectMap["content"] = ccp.Content
	}
	if ccp.Type != "" {
		objectMap["type"] = ccp.Type
	}
	return json.Marshal(objectMap)
}

// AsKeyVaultCertificateProperties is the BasicCertificateProperties implementation for ContentCertificateProperties.
func (ccp ContentCertificateProperties) AsKeyVaultCertificateProperties() (*KeyVaultCertificateProperties, bool) {
	return nil, false
}

// AsContentCertificateProperties is the BasicCertificateProperties implementation for ContentCertificateProperties.
func (ccp ContentCertificateProperties) AsContentCertificateProperties() (*ContentCertificateProperties, bool) {
	return &ccp, true
}

// AsCertificateProperties is the BasicCertificateProperties implementation for ContentCertificateProperties.
func (ccp ContentCertificateProperties) AsCertificateProperties() (*CertificateProperties, bool) {
	return nil, false
}

// AsBasicCertificateProperties is the BasicCertificateProperties implementation for ContentCertificateProperties.
func (ccp ContentCertificateProperties) AsBasicCertificateProperties() (BasicCertificateProperties, bool) {
	return &ccp, true
}

// CustomContainer custom container payload
type CustomContainer struct {
	// Server - The name of the registry that contains the container image
	Server *string `json:"server,omitempty"`
	// ContainerImage - Container image of the custom container. This should be in the form of <repository>:<tag> without the server name of the registry
	ContainerImage *string `json:"containerImage,omitempty"`
	// Command - Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided.
	Command *[]string `json:"command,omitempty"`
	// Args - Arguments to the entrypoint. The docker image's CMD is used if this is not provided.
	Args *[]string `json:"args,omitempty"`
	// ImageRegistryCredential - Credential of the image registry
	ImageRegistryCredential *ImageRegistryCredential `json:"imageRegistryCredential,omitempty"`
}

// CustomContainerUserSourceInfo custom container user source info
type CustomContainerUserSourceInfo struct {
	CustomContainer *CustomContainer `json:"customContainer,omitempty"`
	// Version - Version of the source
	Version *string `json:"version,omitempty"`
	// Type - Possible values include: 'TypeBasicUserSourceInfoTypeUserSourceInfo', 'TypeBasicUserSourceInfoTypeUploadedUserSourceInfo', 'TypeBasicUserSourceInfoTypeJar', 'TypeBasicUserSourceInfoTypeSource', 'TypeBasicUserSourceInfoTypeNetCoreZip', 'TypeBasicUserSourceInfoTypeBuildResult', 'TypeBasicUserSourceInfoTypeContainer'
	Type TypeBasicUserSourceInfo `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomContainerUserSourceInfo.
func (ccusi CustomContainerUserSourceInfo) MarshalJSON() ([]byte, error) {
	ccusi.Type = TypeBasicUserSourceInfoTypeContainer
	objectMap := make(map[string]interface{})
	if ccusi.CustomContainer != nil {
		objectMap["customContainer"] = ccusi.CustomContainer
	}
	if ccusi.Version != nil {
		objectMap["version"] = ccusi.Version
	}
	if ccusi.Type != "" {
		objectMap["type"] = ccusi.Type
	}
	return json.Marshal(objectMap)
}

// AsUploadedUserSourceInfo is the BasicUserSourceInfo implementation for CustomContainerUserSourceInfo.
func (ccusi CustomContainerUserSourceInfo) AsUploadedUserSourceInfo() (*UploadedUserSourceInfo, bool) {
	return nil, false
}

// AsBasicUploadedUserSourceInfo is the BasicUserSourceInfo implementation for CustomContainerUserSourceInfo.
func (ccusi CustomContainerUserSourceInfo) AsBasicUploadedUserSourceInfo() (BasicUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsJarUploadedUserSourceInfo is the BasicUserSourceInfo implementation for CustomContainerUserSourceInfo.
func (ccusi CustomContainerUserSourceInfo) AsJarUploadedUserSourceInfo() (*JarUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsSourceUploadedUserSourceInfo is the BasicUserSourceInfo implementation for CustomContainerUserSourceInfo.
func (ccusi CustomContainerUserSourceInfo) AsSourceUploadedUserSourceInfo() (*SourceUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsNetCoreZipUploadedUserSourceInfo is the BasicUserSourceInfo implementation for CustomContainerUserSourceInfo.
func (ccusi CustomContainerUserSourceInfo) AsNetCoreZipUploadedUserSourceInfo() (*NetCoreZipUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsBuildResultUserSourceInfo is the BasicUserSourceInfo implementation for CustomContainerUserSourceInfo.
func (ccusi CustomContainerUserSourceInfo) AsBuildResultUserSourceInfo() (*BuildResultUserSourceInfo, bool) {
	return nil, false
}

// AsCustomContainerUserSourceInfo is the BasicUserSourceInfo implementation for CustomContainerUserSourceInfo.
func (ccusi CustomContainerUserSourceInfo) AsCustomContainerUserSourceInfo() (*CustomContainerUserSourceInfo, bool) {
	return &ccusi, true
}

// AsUserSourceInfo is the BasicUserSourceInfo implementation for CustomContainerUserSourceInfo.
func (ccusi CustomContainerUserSourceInfo) AsUserSourceInfo() (*UserSourceInfo, bool) {
	return nil, false
}

// AsBasicUserSourceInfo is the BasicUserSourceInfo implementation for CustomContainerUserSourceInfo.
func (ccusi CustomContainerUserSourceInfo) AsBasicUserSourceInfo() (BasicUserSourceInfo, bool) {
	return &ccusi, true
}

// CustomDomainProperties custom domain of app resource payload.
type CustomDomainProperties struct {
	// Thumbprint - The thumbprint of bound certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// AppName - READ-ONLY; The app name of domain.
	AppName *string `json:"appName,omitempty"`
	// CertName - The bound certificate name of domain.
	CertName *string `json:"certName,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDomainProperties.
func (cdp CustomDomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cdp.Thumbprint != nil {
		objectMap["thumbprint"] = cdp.Thumbprint
	}
	if cdp.CertName != nil {
		objectMap["certName"] = cdp.CertName
	}
	return json.Marshal(objectMap)
}

// CustomDomainResource custom domain resource payload.
type CustomDomainResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the custom domain resource.
	Properties *CustomDomainProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDomainResource.
func (cdr CustomDomainResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cdr.Properties != nil {
		objectMap["properties"] = cdr.Properties
	}
	if cdr.SystemData != nil {
		objectMap["systemData"] = cdr.SystemData
	}
	return json.Marshal(objectMap)
}

// CustomDomainResourceCollection collection compose of a custom domain resources list and a possible link
// for next page.
type CustomDomainResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - The custom domain resources list.
	Value *[]CustomDomainResource `json:"value,omitempty"`
	// NextLink - The link to next page of custom domain list.
	NextLink *string `json:"nextLink,omitempty"`
}

// CustomDomainResourceCollectionIterator provides access to a complete listing of CustomDomainResource
// values.
type CustomDomainResourceCollectionIterator struct {
	i    int
	page CustomDomainResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CustomDomainResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomDomainResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CustomDomainResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CustomDomainResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CustomDomainResourceCollectionIterator) Response() CustomDomainResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CustomDomainResourceCollectionIterator) Value() CustomDomainResource {
	if !iter.page.NotDone() {
		return CustomDomainResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CustomDomainResourceCollectionIterator type.
func NewCustomDomainResourceCollectionIterator(page CustomDomainResourceCollectionPage) CustomDomainResourceCollectionIterator {
	return CustomDomainResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cdrc CustomDomainResourceCollection) IsEmpty() bool {
	return cdrc.Value == nil || len(*cdrc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cdrc CustomDomainResourceCollection) hasNextLink() bool {
	return cdrc.NextLink != nil && len(*cdrc.NextLink) != 0
}

// customDomainResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cdrc CustomDomainResourceCollection) customDomainResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !cdrc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cdrc.NextLink)))
}

// CustomDomainResourceCollectionPage contains a page of CustomDomainResource values.
type CustomDomainResourceCollectionPage struct {
	fn   func(context.Context, CustomDomainResourceCollection) (CustomDomainResourceCollection, error)
	cdrc CustomDomainResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CustomDomainResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomDomainResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cdrc)
		if err != nil {
			return err
		}
		page.cdrc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CustomDomainResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CustomDomainResourceCollectionPage) NotDone() bool {
	return !page.cdrc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CustomDomainResourceCollectionPage) Response() CustomDomainResourceCollection {
	return page.cdrc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CustomDomainResourceCollectionPage) Values() []CustomDomainResource {
	if page.cdrc.IsEmpty() {
		return nil
	}
	return *page.cdrc.Value
}

// Creates a new instance of the CustomDomainResourceCollectionPage type.
func NewCustomDomainResourceCollectionPage(cur CustomDomainResourceCollection, getNextPage func(context.Context, CustomDomainResourceCollection) (CustomDomainResourceCollection, error)) CustomDomainResourceCollectionPage {
	return CustomDomainResourceCollectionPage{
		fn:   getNextPage,
		cdrc: cur,
	}
}

// CustomDomainsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CustomDomainsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CustomDomainsClient) (CustomDomainResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CustomDomainsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CustomDomainsCreateOrUpdateFuture.Result.
func (future *CustomDomainsCreateOrUpdateFuture) result(client CustomDomainsClient) (cdr CustomDomainResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.CustomDomainsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cdr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.CustomDomainsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cdr.Response.Response, err = future.GetResult(sender); err == nil && cdr.Response.Response.StatusCode != http.StatusNoContent {
		cdr, err = client.CreateOrUpdateResponder(cdr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.CustomDomainsCreateOrUpdateFuture", "Result", cdr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CustomDomainsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CustomDomainsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CustomDomainsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CustomDomainsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CustomDomainsDeleteFuture.Result.
func (future *CustomDomainsDeleteFuture) result(client CustomDomainsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.CustomDomainsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.CustomDomainsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CustomDomainsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CustomDomainsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CustomDomainsClient) (CustomDomainResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CustomDomainsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CustomDomainsUpdateFuture.Result.
func (future *CustomDomainsUpdateFuture) result(client CustomDomainsClient) (cdr CustomDomainResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.CustomDomainsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cdr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.CustomDomainsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cdr.Response.Response, err = future.GetResult(sender); err == nil && cdr.Response.Response.StatusCode != http.StatusNoContent {
		cdr, err = client.UpdateResponder(cdr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.CustomDomainsUpdateFuture", "Result", cdr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CustomDomainValidatePayload custom domain validate payload.
type CustomDomainValidatePayload struct {
	// Name - Name to be validated
	Name *string `json:"name,omitempty"`
}

// CustomDomainValidateResult validation result for custom domain.
type CustomDomainValidateResult struct {
	autorest.Response `json:"-"`
	// IsValid - Indicates if domain name is valid.
	IsValid *bool `json:"isValid,omitempty"`
	// Message - Message of why domain name is invalid.
	Message *string `json:"message,omitempty"`
}

// BasicCustomPersistentDiskProperties custom persistent disk resource payload.
type BasicCustomPersistentDiskProperties interface {
	AsAzureFileVolume() (*AzureFileVolume, bool)
	AsCustomPersistentDiskProperties() (*CustomPersistentDiskProperties, bool)
}

// CustomPersistentDiskProperties custom persistent disk resource payload.
type CustomPersistentDiskProperties struct {
	// MountPath - The mount path of the persistent disk.
	MountPath *string `json:"mountPath,omitempty"`
	// ReadOnly - Indicates whether the persistent disk is a readOnly one.
	ReadOnly *bool `json:"readOnly,omitempty"`
	// MountOptions - These are the mount options for a persistent disk.
	MountOptions *[]string `json:"mountOptions,omitempty"`
	// Type - Possible values include: 'TypeCustomPersistentDiskProperties', 'TypeAzureFileVolume'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicCustomPersistentDiskProperties(body []byte) (BasicCustomPersistentDiskProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeAzureFileVolume):
		var afv AzureFileVolume
		err := json.Unmarshal(body, &afv)
		return afv, err
	default:
		var cpdp CustomPersistentDiskProperties
		err := json.Unmarshal(body, &cpdp)
		return cpdp, err
	}
}
func unmarshalBasicCustomPersistentDiskPropertiesArray(body []byte) ([]BasicCustomPersistentDiskProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cpdpArray := make([]BasicCustomPersistentDiskProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cpdp, err := unmarshalBasicCustomPersistentDiskProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		cpdpArray[index] = cpdp
	}
	return cpdpArray, nil
}

// MarshalJSON is the custom marshaler for CustomPersistentDiskProperties.
func (cpdp CustomPersistentDiskProperties) MarshalJSON() ([]byte, error) {
	cpdp.Type = TypeCustomPersistentDiskProperties
	objectMap := make(map[string]interface{})
	if cpdp.MountPath != nil {
		objectMap["mountPath"] = cpdp.MountPath
	}
	if cpdp.ReadOnly != nil {
		objectMap["readOnly"] = cpdp.ReadOnly
	}
	if cpdp.MountOptions != nil {
		objectMap["mountOptions"] = cpdp.MountOptions
	}
	if cpdp.Type != "" {
		objectMap["type"] = cpdp.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureFileVolume is the BasicCustomPersistentDiskProperties implementation for CustomPersistentDiskProperties.
func (cpdp CustomPersistentDiskProperties) AsAzureFileVolume() (*AzureFileVolume, bool) {
	return nil, false
}

// AsCustomPersistentDiskProperties is the BasicCustomPersistentDiskProperties implementation for CustomPersistentDiskProperties.
func (cpdp CustomPersistentDiskProperties) AsCustomPersistentDiskProperties() (*CustomPersistentDiskProperties, bool) {
	return &cpdp, true
}

// AsBasicCustomPersistentDiskProperties is the BasicCustomPersistentDiskProperties implementation for CustomPersistentDiskProperties.
func (cpdp CustomPersistentDiskProperties) AsBasicCustomPersistentDiskProperties() (BasicCustomPersistentDiskProperties, bool) {
	return &cpdp, true
}

// CustomPersistentDiskResource custom persistent disk resource payload.
type CustomPersistentDiskResource struct {
	// CustomPersistentDiskProperties - Properties of the custom persistent disk resource payload.
	CustomPersistentDiskProperties BasicCustomPersistentDiskProperties `json:"customPersistentDiskProperties,omitempty"`
	// StorageID - The resource id of Azure Spring Cloud Storage resource.
	StorageID *string `json:"storageId,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CustomPersistentDiskResource struct.
func (cpdr *CustomPersistentDiskResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "customPersistentDiskProperties":
			if v != nil {
				customPersistentDiskProperties, err := unmarshalBasicCustomPersistentDiskProperties(*v)
				if err != nil {
					return err
				}
				cpdr.CustomPersistentDiskProperties = customPersistentDiskProperties
			}
		case "storageId":
			if v != nil {
				var storageID string
				err = json.Unmarshal(*v, &storageID)
				if err != nil {
					return err
				}
				cpdr.StorageID = &storageID
			}
		}
	}

	return nil
}

// DeploymentInstance deployment instance payload
type DeploymentInstance struct {
	// Name - READ-ONLY; Name of the deployment instance
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; Status of the deployment instance
	Status *string `json:"status,omitempty"`
	// Reason - READ-ONLY; Failed reason of the deployment instance
	Reason *string `json:"reason,omitempty"`
	// DiscoveryStatus - READ-ONLY; Discovery status of the deployment instance
	DiscoveryStatus *string `json:"discoveryStatus,omitempty"`
	// StartTime - READ-ONLY; Start time of the deployment instance
	StartTime *string `json:"startTime,omitempty"`
	// Zone - READ-ONLY; Availability zone information of the deployment instance
	Zone *string `json:"zone,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentInstance.
func (di DeploymentInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DeploymentResource deployment resource payload
type DeploymentResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the Deployment resource
	Properties *DeploymentResourceProperties `json:"properties,omitempty"`
	// Sku - Sku of the Deployment resource
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentResource.
func (dr DeploymentResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dr.Properties != nil {
		objectMap["properties"] = dr.Properties
	}
	if dr.Sku != nil {
		objectMap["sku"] = dr.Sku
	}
	if dr.SystemData != nil {
		objectMap["systemData"] = dr.SystemData
	}
	return json.Marshal(objectMap)
}

// DeploymentResourceCollection object that includes an array of App resources and a possible link for next
// set
type DeploymentResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Deployment resources
	Value *[]DeploymentResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeploymentResourceCollectionIterator provides access to a complete listing of DeploymentResource values.
type DeploymentResourceCollectionIterator struct {
	i    int
	page DeploymentResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeploymentResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeploymentResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeploymentResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeploymentResourceCollectionIterator) Response() DeploymentResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeploymentResourceCollectionIterator) Value() DeploymentResource {
	if !iter.page.NotDone() {
		return DeploymentResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeploymentResourceCollectionIterator type.
func NewDeploymentResourceCollectionIterator(page DeploymentResourceCollectionPage) DeploymentResourceCollectionIterator {
	return DeploymentResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (drc DeploymentResourceCollection) IsEmpty() bool {
	return drc.Value == nil || len(*drc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (drc DeploymentResourceCollection) hasNextLink() bool {
	return drc.NextLink != nil && len(*drc.NextLink) != 0
}

// deploymentResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (drc DeploymentResourceCollection) deploymentResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !drc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(drc.NextLink)))
}

// DeploymentResourceCollectionPage contains a page of DeploymentResource values.
type DeploymentResourceCollectionPage struct {
	fn  func(context.Context, DeploymentResourceCollection) (DeploymentResourceCollection, error)
	drc DeploymentResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeploymentResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.drc)
		if err != nil {
			return err
		}
		page.drc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeploymentResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeploymentResourceCollectionPage) NotDone() bool {
	return !page.drc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeploymentResourceCollectionPage) Response() DeploymentResourceCollection {
	return page.drc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeploymentResourceCollectionPage) Values() []DeploymentResource {
	if page.drc.IsEmpty() {
		return nil
	}
	return *page.drc.Value
}

// Creates a new instance of the DeploymentResourceCollectionPage type.
func NewDeploymentResourceCollectionPage(cur DeploymentResourceCollection, getNextPage func(context.Context, DeploymentResourceCollection) (DeploymentResourceCollection, error)) DeploymentResourceCollectionPage {
	return DeploymentResourceCollectionPage{
		fn:  getNextPage,
		drc: cur,
	}
}

// DeploymentResourceProperties deployment resource properties payload
type DeploymentResourceProperties struct {
	// Source - Uploaded source information of the deployment.
	Source BasicUserSourceInfo `json:"source,omitempty"`
	// DeploymentSettings - Deployment settings of the Deployment
	DeploymentSettings *DeploymentSettings `json:"deploymentSettings,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the Deployment. Possible values include: 'DeploymentResourceProvisioningStateCreating', 'DeploymentResourceProvisioningStateUpdating', 'DeploymentResourceProvisioningStateSucceeded', 'DeploymentResourceProvisioningStateFailed'
	ProvisioningState DeploymentResourceProvisioningState `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; Status of the Deployment. Possible values include: 'DeploymentResourceStatusStopped', 'DeploymentResourceStatusRunning'
	Status DeploymentResourceStatus `json:"status,omitempty"`
	// Active - Indicates whether the Deployment is active
	Active *bool `json:"active,omitempty"`
	// Instances - READ-ONLY; Collection of instances belong to the Deployment
	Instances *[]DeploymentInstance `json:"instances,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentResourceProperties.
func (drp DeploymentResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["source"] = drp.Source
	if drp.DeploymentSettings != nil {
		objectMap["deploymentSettings"] = drp.DeploymentSettings
	}
	if drp.Active != nil {
		objectMap["active"] = drp.Active
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeploymentResourceProperties struct.
func (drp *DeploymentResourceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "source":
			if v != nil {
				source, err := unmarshalBasicUserSourceInfo(*v)
				if err != nil {
					return err
				}
				drp.Source = source
			}
		case "deploymentSettings":
			if v != nil {
				var deploymentSettings DeploymentSettings
				err = json.Unmarshal(*v, &deploymentSettings)
				if err != nil {
					return err
				}
				drp.DeploymentSettings = &deploymentSettings
			}
		case "provisioningState":
			if v != nil {
				var provisioningState DeploymentResourceProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				drp.ProvisioningState = provisioningState
			}
		case "status":
			if v != nil {
				var status DeploymentResourceStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				drp.Status = status
			}
		case "active":
			if v != nil {
				var active bool
				err = json.Unmarshal(*v, &active)
				if err != nil {
					return err
				}
				drp.Active = &active
			}
		case "instances":
			if v != nil {
				var instances []DeploymentInstance
				err = json.Unmarshal(*v, &instances)
				if err != nil {
					return err
				}
				drp.Instances = &instances
			}
		}
	}

	return nil
}

// DeploymentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeploymentsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (DeploymentResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsCreateOrUpdateFuture.Result.
func (future *DeploymentsCreateOrUpdateFuture) result(client DeploymentsClient) (dr DeploymentResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.DeploymentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.DeploymentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dr.Response.Response, err = future.GetResult(sender); err == nil && dr.Response.Response.StatusCode != http.StatusNoContent {
		dr, err = client.CreateOrUpdateResponder(dr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.DeploymentsCreateOrUpdateFuture", "Result", dr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsDeleteFuture.Result.
func (future *DeploymentsDeleteFuture) result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.DeploymentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.DeploymentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentSettings deployment settings payload
type DeploymentSettings struct {
	// ResourceRequests - The requested resource quantity for required CPU and Memory. It is recommended that using this field to represent the required CPU and Memory, the old field cpu and memoryInGB will be deprecated later.
	ResourceRequests *ResourceRequests `json:"resourceRequests,omitempty"`
	// EnvironmentVariables - Collection of environment variables
	EnvironmentVariables map[string]*string `json:"environmentVariables"`
	// AddonConfigs - Collection of addons
	AddonConfigs           map[string]map[string]interface{} `json:"addonConfigs"`
	ContainerProbeSettings *ContainerProbeSettings           `json:"containerProbeSettings,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentSettings.
func (ds DeploymentSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ds.ResourceRequests != nil {
		objectMap["resourceRequests"] = ds.ResourceRequests
	}
	if ds.EnvironmentVariables != nil {
		objectMap["environmentVariables"] = ds.EnvironmentVariables
	}
	if ds.AddonConfigs != nil {
		objectMap["addonConfigs"] = ds.AddonConfigs
	}
	if ds.ContainerProbeSettings != nil {
		objectMap["containerProbeSettings"] = ds.ContainerProbeSettings
	}
	return json.Marshal(objectMap)
}

// DeploymentsGenerateHeapDumpFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeploymentsGenerateHeapDumpFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsGenerateHeapDumpFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsGenerateHeapDumpFuture.Result.
func (future *DeploymentsGenerateHeapDumpFuture) result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.DeploymentsGenerateHeapDumpFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.DeploymentsGenerateHeapDumpFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentsGenerateThreadDumpFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeploymentsGenerateThreadDumpFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsGenerateThreadDumpFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsGenerateThreadDumpFuture.Result.
func (future *DeploymentsGenerateThreadDumpFuture) result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.DeploymentsGenerateThreadDumpFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.DeploymentsGenerateThreadDumpFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentsRestartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsRestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsRestartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsRestartFuture.Result.
func (future *DeploymentsRestartFuture) result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.DeploymentsRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.DeploymentsRestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentsStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsStartFuture.Result.
func (future *DeploymentsStartFuture) result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.DeploymentsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.DeploymentsStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentsStartJFRFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsStartJFRFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsStartJFRFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsStartJFRFuture.Result.
func (future *DeploymentsStartJFRFuture) result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.DeploymentsStartJFRFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.DeploymentsStartJFRFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentsStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsStopFuture.Result.
func (future *DeploymentsStopFuture) result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.DeploymentsStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.DeploymentsStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (DeploymentResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsUpdateFuture.Result.
func (future *DeploymentsUpdateFuture) result(client DeploymentsClient) (dr DeploymentResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.DeploymentsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.DeploymentsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dr.Response.Response, err = future.GetResult(sender); err == nil && dr.Response.Response.StatusCode != http.StatusNoContent {
		dr, err = client.UpdateResponder(dr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.DeploymentsUpdateFuture", "Result", dr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DiagnosticParameters diagnostic parameters of diagnostic operations
type DiagnosticParameters struct {
	// AppInstance - App instance name
	AppInstance *string `json:"appInstance,omitempty"`
	// FilePath - Your target file path in your own BYOS
	FilePath *string `json:"filePath,omitempty"`
	// Duration - Duration of your JFR. 1 min can be represented by 1m or 60s.
	Duration *string `json:"duration,omitempty"`
}

// Error the error code compose of code and message.
type Error struct {
	// Code - The code of error.
	Code *string `json:"code,omitempty"`
	// Message - The message of error.
	Message *string `json:"message,omitempty"`
}

// GatewayAPIMetadataProperties API metadata property for Spring Cloud Gateway
type GatewayAPIMetadataProperties struct {
	// Title - Title describing the context of the APIs available on the Gateway instance (default: `Spring Cloud Gateway for K8S`)
	Title *string `json:"title,omitempty"`
	// Description - Detailed description of the APIs available on the Gateway instance (default: `Generated OpenAPI 3 document that describes the API routes configured.`)
	Description *string `json:"description,omitempty"`
	// Documentation - Location of additional documentation for the APIs available on the Gateway instance
	Documentation *string `json:"documentation,omitempty"`
	// Version - Version of APIs available on this Gateway instance (default: `unspecified`).
	Version *string `json:"version,omitempty"`
	// ServerURL - Base URL that API consumers will use to access APIs on the Gateway instance.
	ServerURL *string `json:"serverUrl,omitempty"`
}

// GatewayAPIRoute API route config of the Spring Cloud Gateway
type GatewayAPIRoute struct {
	// Title - A title, will be applied to methods in the generated OpenAPI documentation.
	Title *string `json:"title,omitempty"`
	// Description - A description, will be applied to methods in the generated OpenAPI documentation.
	Description *string `json:"description,omitempty"`
	// URI - Full uri, will override `appName`.
	URI *string `json:"uri,omitempty"`
	// SsoEnabled - Enable sso validation.
	SsoEnabled *bool `json:"ssoEnabled,omitempty"`
	// TokenRelay - Pass currently-authenticated user's identity token to application service, default is 'false'
	TokenRelay *bool `json:"tokenRelay,omitempty"`
	// Predicates - A number of conditions to evaluate a route for each request. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
	Predicates *[]string `json:"predicates,omitempty"`
	// Filters - To modify the request before sending it to the target endpoint, or the received response.
	Filters *[]string `json:"filters,omitempty"`
	// Order - Route processing order.
	Order *int32 `json:"order,omitempty"`
	// Tags - Classification tags, will be applied to methods in the generated OpenAPI documentation.
	Tags *[]string `json:"tags,omitempty"`
}

// GatewayCorsProperties cross-Origin Resource Sharing property
type GatewayCorsProperties struct {
	// AllowedOrigins - Allowed origins to make cross-site requests. The special value `*` allows all domains.
	AllowedOrigins *[]string `json:"allowedOrigins,omitempty"`
	// AllowedMethods - Allowed HTTP methods on cross-site requests. The special value `*` allows all methods. If not set, `GET` and `HEAD` are allowed by default.
	AllowedMethods *[]string `json:"allowedMethods,omitempty"`
	// AllowedHeaders - Allowed headers in cross-site requests. The special value `*` allows actual requests to send any header.
	AllowedHeaders *[]string `json:"allowedHeaders,omitempty"`
	// MaxAge - How long, in seconds, the response from a pre-flight request can be cached by clients.
	MaxAge *int32 `json:"maxAge,omitempty"`
	// AllowCredentials - Whether user credentials are supported on cross-site requests. Valid values: `true`, `false`.
	AllowCredentials *bool `json:"allowCredentials,omitempty"`
	// ExposedHeaders - HTTP response headers to expose for cross-site requests.
	ExposedHeaders *[]string `json:"exposedHeaders,omitempty"`
}

// GatewayCustomDomainProperties the properties of custom domain for Spring Cloud Gateway
type GatewayCustomDomainProperties struct {
	// Thumbprint - The thumbprint of bound certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// GatewayCustomDomainResource custom domain of the Spring Cloud Gateway
type GatewayCustomDomainResource struct {
	autorest.Response `json:"-"`
	Properties        *GatewayCustomDomainProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for GatewayCustomDomainResource.
func (gcdr GatewayCustomDomainResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gcdr.Properties != nil {
		objectMap["properties"] = gcdr.Properties
	}
	if gcdr.SystemData != nil {
		objectMap["systemData"] = gcdr.SystemData
	}
	return json.Marshal(objectMap)
}

// GatewayCustomDomainResourceCollection object that includes an array of Spring Cloud Gateway custom
// domain resources and a possible link for next set
type GatewayCustomDomainResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Spring Cloud Gateway custom domain resources
	Value *[]GatewayCustomDomainResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// GatewayCustomDomainResourceCollectionIterator provides access to a complete listing of
// GatewayCustomDomainResource values.
type GatewayCustomDomainResourceCollectionIterator struct {
	i    int
	page GatewayCustomDomainResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GatewayCustomDomainResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GatewayCustomDomainResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GatewayCustomDomainResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GatewayCustomDomainResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GatewayCustomDomainResourceCollectionIterator) Response() GatewayCustomDomainResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GatewayCustomDomainResourceCollectionIterator) Value() GatewayCustomDomainResource {
	if !iter.page.NotDone() {
		return GatewayCustomDomainResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GatewayCustomDomainResourceCollectionIterator type.
func NewGatewayCustomDomainResourceCollectionIterator(page GatewayCustomDomainResourceCollectionPage) GatewayCustomDomainResourceCollectionIterator {
	return GatewayCustomDomainResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (gcdrc GatewayCustomDomainResourceCollection) IsEmpty() bool {
	return gcdrc.Value == nil || len(*gcdrc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (gcdrc GatewayCustomDomainResourceCollection) hasNextLink() bool {
	return gcdrc.NextLink != nil && len(*gcdrc.NextLink) != 0
}

// gatewayCustomDomainResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (gcdrc GatewayCustomDomainResourceCollection) gatewayCustomDomainResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !gcdrc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(gcdrc.NextLink)))
}

// GatewayCustomDomainResourceCollectionPage contains a page of GatewayCustomDomainResource values.
type GatewayCustomDomainResourceCollectionPage struct {
	fn    func(context.Context, GatewayCustomDomainResourceCollection) (GatewayCustomDomainResourceCollection, error)
	gcdrc GatewayCustomDomainResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GatewayCustomDomainResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GatewayCustomDomainResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.gcdrc)
		if err != nil {
			return err
		}
		page.gcdrc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GatewayCustomDomainResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GatewayCustomDomainResourceCollectionPage) NotDone() bool {
	return !page.gcdrc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GatewayCustomDomainResourceCollectionPage) Response() GatewayCustomDomainResourceCollection {
	return page.gcdrc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GatewayCustomDomainResourceCollectionPage) Values() []GatewayCustomDomainResource {
	if page.gcdrc.IsEmpty() {
		return nil
	}
	return *page.gcdrc.Value
}

// Creates a new instance of the GatewayCustomDomainResourceCollectionPage type.
func NewGatewayCustomDomainResourceCollectionPage(cur GatewayCustomDomainResourceCollection, getNextPage func(context.Context, GatewayCustomDomainResourceCollection) (GatewayCustomDomainResourceCollection, error)) GatewayCustomDomainResourceCollectionPage {
	return GatewayCustomDomainResourceCollectionPage{
		fn:    getNextPage,
		gcdrc: cur,
	}
}

// GatewayCustomDomainsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GatewayCustomDomainsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GatewayCustomDomainsClient) (GatewayCustomDomainResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GatewayCustomDomainsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GatewayCustomDomainsCreateOrUpdateFuture.Result.
func (future *GatewayCustomDomainsCreateOrUpdateFuture) result(client GatewayCustomDomainsClient) (gcdr GatewayCustomDomainResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.GatewayCustomDomainsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		gcdr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.GatewayCustomDomainsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gcdr.Response.Response, err = future.GetResult(sender); err == nil && gcdr.Response.Response.StatusCode != http.StatusNoContent {
		gcdr, err = client.CreateOrUpdateResponder(gcdr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.GatewayCustomDomainsCreateOrUpdateFuture", "Result", gcdr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GatewayCustomDomainsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GatewayCustomDomainsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GatewayCustomDomainsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GatewayCustomDomainsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GatewayCustomDomainsDeleteFuture.Result.
func (future *GatewayCustomDomainsDeleteFuture) result(client GatewayCustomDomainsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.GatewayCustomDomainsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.GatewayCustomDomainsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GatewayInstance collection of instances belong to the Spring Cloud Gateway
type GatewayInstance struct {
	// Name - READ-ONLY; Name of the Spring Cloud Gateway instance
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; Status of the Spring Cloud Gateway instance
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for GatewayInstance.
func (gi GatewayInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GatewayOperatorProperties properties of the Spring Cloud Gateway Operator.
type GatewayOperatorProperties struct {
	// ResourceRequests - The requested resource quantity for required CPU and Memory.
	ResourceRequests *GatewayOperatorResourceRequests `json:"resourceRequests,omitempty"`
	// Instances - READ-ONLY; Collection of instances belong to Spring Cloud Gateway operator.
	Instances *[]GatewayInstance `json:"instances,omitempty"`
}

// MarshalJSON is the custom marshaler for GatewayOperatorProperties.
func (gop GatewayOperatorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gop.ResourceRequests != nil {
		objectMap["resourceRequests"] = gop.ResourceRequests
	}
	return json.Marshal(objectMap)
}

// GatewayOperatorResourceRequests properties of the Spring Cloud Gateway Operator.
type GatewayOperatorResourceRequests struct {
	// CPU - READ-ONLY; Cpu allocated to each Spring Cloud Gateway Operator instance.
	CPU *string `json:"cpu,omitempty"`
	// Memory - READ-ONLY; Memory allocated to each Spring Cloud Gateway Operator instance.
	Memory *string `json:"memory,omitempty"`
	// InstanceCount - READ-ONLY; Instance count of the Spring Cloud Gateway Operator.
	InstanceCount *int32 `json:"instanceCount,omitempty"`
}

// MarshalJSON is the custom marshaler for GatewayOperatorResourceRequests.
func (gorr GatewayOperatorResourceRequests) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GatewayProperties spring Cloud Gateway properties payload
type GatewayProperties struct {
	// ProvisioningState - READ-ONLY; State of the Spring Cloud Gateway. Possible values include: 'GatewayProvisioningStateCreating', 'GatewayProvisioningStateUpdating', 'GatewayProvisioningStateSucceeded', 'GatewayProvisioningStateFailed', 'GatewayProvisioningStateDeleting'
	ProvisioningState GatewayProvisioningState `json:"provisioningState,omitempty"`
	// Public - Indicates whether the Spring Cloud Gateway exposes endpoint.
	Public *bool `json:"public,omitempty"`
	// URL - READ-ONLY; URL of the Spring Cloud Gateway, exposed when 'public' is true.
	URL *string `json:"url,omitempty"`
	// HTTPSOnly - Indicate if only https is allowed.
	HTTPSOnly             *bool                         `json:"httpsOnly,omitempty"`
	SsoProperties         *SsoProperties                `json:"ssoProperties,omitempty"`
	APIMetadataProperties *GatewayAPIMetadataProperties `json:"apiMetadataProperties,omitempty"`
	CorsProperties        *GatewayCorsProperties        `json:"corsProperties,omitempty"`
	// ResourceRequests - The requested resource quantity for required CPU and Memory.
	ResourceRequests *GatewayResourceRequests `json:"resourceRequests,omitempty"`
	// Instances - READ-ONLY; Collection of instances belong to Spring Cloud Gateway.
	Instances *[]GatewayInstance `json:"instances,omitempty"`
	// OperatorProperties - READ-ONLY
	OperatorProperties *GatewayOperatorProperties `json:"operatorProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for GatewayProperties.
func (gp GatewayProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gp.Public != nil {
		objectMap["public"] = gp.Public
	}
	if gp.HTTPSOnly != nil {
		objectMap["httpsOnly"] = gp.HTTPSOnly
	}
	if gp.SsoProperties != nil {
		objectMap["ssoProperties"] = gp.SsoProperties
	}
	if gp.APIMetadataProperties != nil {
		objectMap["apiMetadataProperties"] = gp.APIMetadataProperties
	}
	if gp.CorsProperties != nil {
		objectMap["corsProperties"] = gp.CorsProperties
	}
	if gp.ResourceRequests != nil {
		objectMap["resourceRequests"] = gp.ResourceRequests
	}
	return json.Marshal(objectMap)
}

// GatewayResource spring Cloud Gateway resource
type GatewayResource struct {
	autorest.Response `json:"-"`
	Properties        *GatewayProperties `json:"properties,omitempty"`
	// Sku - Sku of the Spring Cloud Gateway resource
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for GatewayResource.
func (gr GatewayResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gr.Properties != nil {
		objectMap["properties"] = gr.Properties
	}
	if gr.Sku != nil {
		objectMap["sku"] = gr.Sku
	}
	if gr.SystemData != nil {
		objectMap["systemData"] = gr.SystemData
	}
	return json.Marshal(objectMap)
}

// GatewayResourceCollection object that includes an array of gateway resources and a possible link for
// next set
type GatewayResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of gateway resources
	Value *[]GatewayResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// GatewayResourceCollectionIterator provides access to a complete listing of GatewayResource values.
type GatewayResourceCollectionIterator struct {
	i    int
	page GatewayResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GatewayResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GatewayResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GatewayResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GatewayResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GatewayResourceCollectionIterator) Response() GatewayResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GatewayResourceCollectionIterator) Value() GatewayResource {
	if !iter.page.NotDone() {
		return GatewayResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GatewayResourceCollectionIterator type.
func NewGatewayResourceCollectionIterator(page GatewayResourceCollectionPage) GatewayResourceCollectionIterator {
	return GatewayResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (grc GatewayResourceCollection) IsEmpty() bool {
	return grc.Value == nil || len(*grc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (grc GatewayResourceCollection) hasNextLink() bool {
	return grc.NextLink != nil && len(*grc.NextLink) != 0
}

// gatewayResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (grc GatewayResourceCollection) gatewayResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !grc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(grc.NextLink)))
}

// GatewayResourceCollectionPage contains a page of GatewayResource values.
type GatewayResourceCollectionPage struct {
	fn  func(context.Context, GatewayResourceCollection) (GatewayResourceCollection, error)
	grc GatewayResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GatewayResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GatewayResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.grc)
		if err != nil {
			return err
		}
		page.grc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GatewayResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GatewayResourceCollectionPage) NotDone() bool {
	return !page.grc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GatewayResourceCollectionPage) Response() GatewayResourceCollection {
	return page.grc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GatewayResourceCollectionPage) Values() []GatewayResource {
	if page.grc.IsEmpty() {
		return nil
	}
	return *page.grc.Value
}

// Creates a new instance of the GatewayResourceCollectionPage type.
func NewGatewayResourceCollectionPage(cur GatewayResourceCollection, getNextPage func(context.Context, GatewayResourceCollection) (GatewayResourceCollection, error)) GatewayResourceCollectionPage {
	return GatewayResourceCollectionPage{
		fn:  getNextPage,
		grc: cur,
	}
}

// GatewayResourceRequests resource request payload of Spring Cloud Gateway.
type GatewayResourceRequests struct {
	// CPU - Cpu allocated to each Spring Cloud Gateway instance.
	CPU *string `json:"cpu,omitempty"`
	// Memory - Memory allocated to each Spring Cloud Gateway instance.
	Memory *string `json:"memory,omitempty"`
}

// GatewayRouteConfigProperties API route config of the Spring Cloud Gateway
type GatewayRouteConfigProperties struct {
	// ProvisioningState - READ-ONLY; State of the Spring Cloud Gateway route config. Possible values include: 'GatewayProvisioningStateCreating', 'GatewayProvisioningStateUpdating', 'GatewayProvisioningStateSucceeded', 'GatewayProvisioningStateFailed', 'GatewayProvisioningStateDeleting'
	ProvisioningState GatewayProvisioningState `json:"provisioningState,omitempty"`
	// AppResourceID - The resource Id of the Azure Spring Cloud app, required unless route defines `uri`.
	AppResourceID *string `json:"appResourceId,omitempty"`
	// Routes - Array of API routes, each route contains properties such as `title`, `uri`, `ssoEnabled`, `predicates`, `filters`.
	Routes *[]GatewayAPIRoute `json:"routes,omitempty"`
}

// MarshalJSON is the custom marshaler for GatewayRouteConfigProperties.
func (grcp GatewayRouteConfigProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if grcp.AppResourceID != nil {
		objectMap["appResourceId"] = grcp.AppResourceID
	}
	if grcp.Routes != nil {
		objectMap["routes"] = grcp.Routes
	}
	return json.Marshal(objectMap)
}

// GatewayRouteConfigResource spring Cloud Gateway route config resource
type GatewayRouteConfigResource struct {
	autorest.Response `json:"-"`
	Properties        *GatewayRouteConfigProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for GatewayRouteConfigResource.
func (grcr GatewayRouteConfigResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if grcr.Properties != nil {
		objectMap["properties"] = grcr.Properties
	}
	if grcr.SystemData != nil {
		objectMap["systemData"] = grcr.SystemData
	}
	return json.Marshal(objectMap)
}

// GatewayRouteConfigResourceCollection object that includes an array of Spring Cloud Gateway route config
// resources and a possible link for next set
type GatewayRouteConfigResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Spring Cloud Gateway route config resources
	Value *[]GatewayRouteConfigResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// GatewayRouteConfigResourceCollectionIterator provides access to a complete listing of
// GatewayRouteConfigResource values.
type GatewayRouteConfigResourceCollectionIterator struct {
	i    int
	page GatewayRouteConfigResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GatewayRouteConfigResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GatewayRouteConfigResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GatewayRouteConfigResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GatewayRouteConfigResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GatewayRouteConfigResourceCollectionIterator) Response() GatewayRouteConfigResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GatewayRouteConfigResourceCollectionIterator) Value() GatewayRouteConfigResource {
	if !iter.page.NotDone() {
		return GatewayRouteConfigResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GatewayRouteConfigResourceCollectionIterator type.
func NewGatewayRouteConfigResourceCollectionIterator(page GatewayRouteConfigResourceCollectionPage) GatewayRouteConfigResourceCollectionIterator {
	return GatewayRouteConfigResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (grcrc GatewayRouteConfigResourceCollection) IsEmpty() bool {
	return grcrc.Value == nil || len(*grcrc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (grcrc GatewayRouteConfigResourceCollection) hasNextLink() bool {
	return grcrc.NextLink != nil && len(*grcrc.NextLink) != 0
}

// gatewayRouteConfigResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (grcrc GatewayRouteConfigResourceCollection) gatewayRouteConfigResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !grcrc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(grcrc.NextLink)))
}

// GatewayRouteConfigResourceCollectionPage contains a page of GatewayRouteConfigResource values.
type GatewayRouteConfigResourceCollectionPage struct {
	fn    func(context.Context, GatewayRouteConfigResourceCollection) (GatewayRouteConfigResourceCollection, error)
	grcrc GatewayRouteConfigResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GatewayRouteConfigResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GatewayRouteConfigResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.grcrc)
		if err != nil {
			return err
		}
		page.grcrc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GatewayRouteConfigResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GatewayRouteConfigResourceCollectionPage) NotDone() bool {
	return !page.grcrc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GatewayRouteConfigResourceCollectionPage) Response() GatewayRouteConfigResourceCollection {
	return page.grcrc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GatewayRouteConfigResourceCollectionPage) Values() []GatewayRouteConfigResource {
	if page.grcrc.IsEmpty() {
		return nil
	}
	return *page.grcrc.Value
}

// Creates a new instance of the GatewayRouteConfigResourceCollectionPage type.
func NewGatewayRouteConfigResourceCollectionPage(cur GatewayRouteConfigResourceCollection, getNextPage func(context.Context, GatewayRouteConfigResourceCollection) (GatewayRouteConfigResourceCollection, error)) GatewayRouteConfigResourceCollectionPage {
	return GatewayRouteConfigResourceCollectionPage{
		fn:    getNextPage,
		grcrc: cur,
	}
}

// GatewayRouteConfigsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GatewayRouteConfigsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GatewayRouteConfigsClient) (GatewayRouteConfigResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GatewayRouteConfigsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GatewayRouteConfigsCreateOrUpdateFuture.Result.
func (future *GatewayRouteConfigsCreateOrUpdateFuture) result(client GatewayRouteConfigsClient) (grcr GatewayRouteConfigResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.GatewayRouteConfigsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		grcr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.GatewayRouteConfigsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if grcr.Response.Response, err = future.GetResult(sender); err == nil && grcr.Response.Response.StatusCode != http.StatusNoContent {
		grcr, err = client.CreateOrUpdateResponder(grcr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.GatewayRouteConfigsCreateOrUpdateFuture", "Result", grcr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GatewayRouteConfigsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GatewayRouteConfigsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GatewayRouteConfigsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GatewayRouteConfigsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GatewayRouteConfigsDeleteFuture.Result.
func (future *GatewayRouteConfigsDeleteFuture) result(client GatewayRouteConfigsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.GatewayRouteConfigsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.GatewayRouteConfigsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GatewaysCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GatewaysClient) (GatewayResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GatewaysCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GatewaysCreateOrUpdateFuture.Result.
func (future *GatewaysCreateOrUpdateFuture) result(client GatewaysClient) (gr GatewayResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.GatewaysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		gr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.GatewaysCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gr.Response.Response, err = future.GetResult(sender); err == nil && gr.Response.Response.StatusCode != http.StatusNoContent {
		gr, err = client.CreateOrUpdateResponder(gr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.GatewaysCreateOrUpdateFuture", "Result", gr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GatewaysDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GatewaysClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GatewaysDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GatewaysDeleteFuture.Result.
func (future *GatewaysDeleteFuture) result(client GatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.GatewaysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.GatewaysDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GitPatternRepository git repository property payload for config server
type GitPatternRepository struct {
	// Name - Name of the repository
	Name *string `json:"name,omitempty"`
	// Pattern - Collection of pattern of the repository
	Pattern *[]string `json:"pattern,omitempty"`
	// URI - URI of the repository
	URI *string `json:"uri,omitempty"`
	// Label - Label of the repository
	Label *string `json:"label,omitempty"`
	// SearchPaths - Searching path of the repository
	SearchPaths *[]string `json:"searchPaths,omitempty"`
	// Username - Username of git repository basic auth.
	Username *string `json:"username,omitempty"`
	// Password - Password of git repository basic auth.
	Password *string `json:"password,omitempty"`
	// HostKey - Public sshKey of git repository.
	HostKey *string `json:"hostKey,omitempty"`
	// HostKeyAlgorithm - SshKey algorithm of git repository.
	HostKeyAlgorithm *string `json:"hostKeyAlgorithm,omitempty"`
	// PrivateKey - Private sshKey algorithm of git repository.
	PrivateKey *string `json:"privateKey,omitempty"`
	// StrictHostKeyChecking - Strict host key checking or not.
	StrictHostKeyChecking *bool `json:"strictHostKeyChecking,omitempty"`
}

// ImageRegistryCredential credential of the image registry
type ImageRegistryCredential struct {
	// Username - The username of the image registry credential
	Username *string `json:"username,omitempty"`
	// Password - The password of the image registry credential
	Password *string `json:"password,omitempty"`
}

// JarUploadedUserSourceInfo uploaded Jar binary for a deployment
type JarUploadedUserSourceInfo struct {
	// RuntimeVersion - Runtime version of the Jar file
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// JvmOptions - JVM parameter
	JvmOptions *string `json:"jvmOptions,omitempty"`
	// RelativePath - Relative path of the storage which stores the source
	RelativePath *string `json:"relativePath,omitempty"`
	// Version - Version of the source
	Version *string `json:"version,omitempty"`
	// Type - Possible values include: 'TypeBasicUserSourceInfoTypeUserSourceInfo', 'TypeBasicUserSourceInfoTypeUploadedUserSourceInfo', 'TypeBasicUserSourceInfoTypeJar', 'TypeBasicUserSourceInfoTypeSource', 'TypeBasicUserSourceInfoTypeNetCoreZip', 'TypeBasicUserSourceInfoTypeBuildResult', 'TypeBasicUserSourceInfoTypeContainer'
	Type TypeBasicUserSourceInfo `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JarUploadedUserSourceInfo.
func (juusi JarUploadedUserSourceInfo) MarshalJSON() ([]byte, error) {
	juusi.Type = TypeBasicUserSourceInfoTypeJar
	objectMap := make(map[string]interface{})
	if juusi.RuntimeVersion != nil {
		objectMap["runtimeVersion"] = juusi.RuntimeVersion
	}
	if juusi.JvmOptions != nil {
		objectMap["jvmOptions"] = juusi.JvmOptions
	}
	if juusi.RelativePath != nil {
		objectMap["relativePath"] = juusi.RelativePath
	}
	if juusi.Version != nil {
		objectMap["version"] = juusi.Version
	}
	if juusi.Type != "" {
		objectMap["type"] = juusi.Type
	}
	return json.Marshal(objectMap)
}

// AsUploadedUserSourceInfo is the BasicUserSourceInfo implementation for JarUploadedUserSourceInfo.
func (juusi JarUploadedUserSourceInfo) AsUploadedUserSourceInfo() (*UploadedUserSourceInfo, bool) {
	return nil, false
}

// AsBasicUploadedUserSourceInfo is the BasicUserSourceInfo implementation for JarUploadedUserSourceInfo.
func (juusi JarUploadedUserSourceInfo) AsBasicUploadedUserSourceInfo() (BasicUploadedUserSourceInfo, bool) {
	return &juusi, true
}

// AsJarUploadedUserSourceInfo is the BasicUserSourceInfo implementation for JarUploadedUserSourceInfo.
func (juusi JarUploadedUserSourceInfo) AsJarUploadedUserSourceInfo() (*JarUploadedUserSourceInfo, bool) {
	return &juusi, true
}

// AsSourceUploadedUserSourceInfo is the BasicUserSourceInfo implementation for JarUploadedUserSourceInfo.
func (juusi JarUploadedUserSourceInfo) AsSourceUploadedUserSourceInfo() (*SourceUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsNetCoreZipUploadedUserSourceInfo is the BasicUserSourceInfo implementation for JarUploadedUserSourceInfo.
func (juusi JarUploadedUserSourceInfo) AsNetCoreZipUploadedUserSourceInfo() (*NetCoreZipUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsBuildResultUserSourceInfo is the BasicUserSourceInfo implementation for JarUploadedUserSourceInfo.
func (juusi JarUploadedUserSourceInfo) AsBuildResultUserSourceInfo() (*BuildResultUserSourceInfo, bool) {
	return nil, false
}

// AsCustomContainerUserSourceInfo is the BasicUserSourceInfo implementation for JarUploadedUserSourceInfo.
func (juusi JarUploadedUserSourceInfo) AsCustomContainerUserSourceInfo() (*CustomContainerUserSourceInfo, bool) {
	return nil, false
}

// AsUserSourceInfo is the BasicUserSourceInfo implementation for JarUploadedUserSourceInfo.
func (juusi JarUploadedUserSourceInfo) AsUserSourceInfo() (*UserSourceInfo, bool) {
	return nil, false
}

// AsBasicUserSourceInfo is the BasicUserSourceInfo implementation for JarUploadedUserSourceInfo.
func (juusi JarUploadedUserSourceInfo) AsBasicUserSourceInfo() (BasicUserSourceInfo, bool) {
	return &juusi, true
}

// KeyVaultCertificateProperties properties of certificate imported from key vault.
type KeyVaultCertificateProperties struct {
	// VaultURI - The vault uri of user key vault.
	VaultURI *string `json:"vaultUri,omitempty"`
	// KeyVaultCertName - The certificate name of key vault.
	KeyVaultCertName *string `json:"keyVaultCertName,omitempty"`
	// CertVersion - The certificate version of key vault.
	CertVersion *string `json:"certVersion,omitempty"`
	// ExcludePrivateKey - Optional. If set to true, it will not import private key from key vault.
	ExcludePrivateKey *bool `json:"excludePrivateKey,omitempty"`
	// Thumbprint - READ-ONLY; The thumbprint of certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Issuer - READ-ONLY; The issuer of certificate.
	Issuer *string `json:"issuer,omitempty"`
	// IssuedDate - READ-ONLY; The issue date of certificate.
	IssuedDate *string `json:"issuedDate,omitempty"`
	// ExpirationDate - READ-ONLY; The expiration date of certificate.
	ExpirationDate *string `json:"expirationDate,omitempty"`
	// ActivateDate - READ-ONLY; The activate date of certificate.
	ActivateDate *string `json:"activateDate,omitempty"`
	// SubjectName - READ-ONLY; The subject name of certificate.
	SubjectName *string `json:"subjectName,omitempty"`
	// DNSNames - READ-ONLY; The domain list of certificate.
	DNSNames *[]string `json:"dnsNames,omitempty"`
	// Type - Possible values include: 'TypeBasicCertificatePropertiesTypeCertificateProperties', 'TypeBasicCertificatePropertiesTypeKeyVaultCertificate', 'TypeBasicCertificatePropertiesTypeContentCertificate'
	Type TypeBasicCertificateProperties `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyVaultCertificateProperties.
func (kvcp KeyVaultCertificateProperties) MarshalJSON() ([]byte, error) {
	kvcp.Type = TypeBasicCertificatePropertiesTypeKeyVaultCertificate
	objectMap := make(map[string]interface{})
	if kvcp.VaultURI != nil {
		objectMap["vaultUri"] = kvcp.VaultURI
	}
	if kvcp.KeyVaultCertName != nil {
		objectMap["keyVaultCertName"] = kvcp.KeyVaultCertName
	}
	if kvcp.CertVersion != nil {
		objectMap["certVersion"] = kvcp.CertVersion
	}
	if kvcp.ExcludePrivateKey != nil {
		objectMap["excludePrivateKey"] = kvcp.ExcludePrivateKey
	}
	if kvcp.Type != "" {
		objectMap["type"] = kvcp.Type
	}
	return json.Marshal(objectMap)
}

// AsKeyVaultCertificateProperties is the BasicCertificateProperties implementation for KeyVaultCertificateProperties.
func (kvcp KeyVaultCertificateProperties) AsKeyVaultCertificateProperties() (*KeyVaultCertificateProperties, bool) {
	return &kvcp, true
}

// AsContentCertificateProperties is the BasicCertificateProperties implementation for KeyVaultCertificateProperties.
func (kvcp KeyVaultCertificateProperties) AsContentCertificateProperties() (*ContentCertificateProperties, bool) {
	return nil, false
}

// AsCertificateProperties is the BasicCertificateProperties implementation for KeyVaultCertificateProperties.
func (kvcp KeyVaultCertificateProperties) AsCertificateProperties() (*CertificateProperties, bool) {
	return nil, false
}

// AsBasicCertificateProperties is the BasicCertificateProperties implementation for KeyVaultCertificateProperties.
func (kvcp KeyVaultCertificateProperties) AsBasicCertificateProperties() (BasicCertificateProperties, bool) {
	return &kvcp, true
}

// LoadedCertificate loaded certificate payload
type LoadedCertificate struct {
	// ResourceID - Resource Id of loaded certificate
	ResourceID *string `json:"resourceId,omitempty"`
	// LoadTrustStore - Indicate whether the certificate will be loaded into default trust store, only work for Java runtime.
	LoadTrustStore *bool `json:"loadTrustStore,omitempty"`
}

// LogFileURLResponse log file URL payload
type LogFileURLResponse struct {
	autorest.Response `json:"-"`
	// URL - URL of the log file
	URL *string `json:"url,omitempty"`
}

// LogSpecification specifications of the Log for Azure Monitoring
type LogSpecification struct {
	// Name - Name of the log
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the log
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - Blob duration of the log
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// ManagedIdentityProperties managed identity properties retrieved from ARM request headers.
type ManagedIdentityProperties struct {
	// Type - Type of the managed identity. Possible values include: 'ManagedIdentityTypeNone', 'ManagedIdentityTypeSystemAssigned', 'ManagedIdentityTypeUserAssigned', 'ManagedIdentityTypeSystemAssignedUserAssigned'
	Type ManagedIdentityType `json:"type,omitempty"`
	// PrincipalID - Principal Id
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - Tenant Id
	TenantID *string `json:"tenantId,omitempty"`
}

// MetricDimension specifications of the Dimension of metrics
type MetricDimension struct {
	// Name - Name of the dimension
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the dimension
	DisplayName *string `json:"displayName,omitempty"`
	// ToBeExportedForShoebox - Whether this dimension should be included for the Shoebox export scenario
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// MetricSpecification specifications of the Metrics for Azure Monitoring
type MetricSpecification struct {
	// Name - Name of the metric
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the metric
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Localized friendly description of the metric
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Unit that makes sense for the metric
	Unit *string `json:"unit,omitempty"`
	// Category - Name of the metric category that the metric belongs to. A metric can only belong to a single category.
	Category *string `json:"category,omitempty"`
	// AggregationType - Only provide one value for this field. Valid values: Average, Minimum, Maximum, Total, Count.
	AggregationType *string `json:"aggregationType,omitempty"`
	// SupportedAggregationTypes - Supported aggregation types
	SupportedAggregationTypes *[]string `json:"supportedAggregationTypes,omitempty"`
	// SupportedTimeGrainTypes - Supported time grain types
	SupportedTimeGrainTypes *[]string `json:"supportedTimeGrainTypes,omitempty"`
	// FillGapWithZero - Optional. If set to true, then zero will be returned for time duration where no metric is emitted/published.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Dimensions - Dimensions of the metric
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
	// SourceMdmNamespace - Name of the MDM namespace. Optional.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`
}

// MonitoringSettingProperties monitoring Setting properties payload
type MonitoringSettingProperties struct {
	// ProvisioningState - READ-ONLY; State of the Monitoring Setting. Possible values include: 'MonitoringSettingStateNotAvailable', 'MonitoringSettingStateFailed', 'MonitoringSettingStateSucceeded', 'MonitoringSettingStateUpdating'
	ProvisioningState MonitoringSettingState `json:"provisioningState,omitempty"`
	// Error - Error when apply Monitoring Setting changes.
	Error *Error `json:"error,omitempty"`
	// TraceEnabled - Indicates whether enable the trace functionality, which will be deprecated since api version 2020-11-01-preview. Please leverage appInsightsInstrumentationKey to indicate if monitoringSettings enabled or not
	TraceEnabled *bool `json:"traceEnabled,omitempty"`
	// AppInsightsInstrumentationKey - Target application insight instrumentation key, null or whitespace include empty will disable monitoringSettings
	AppInsightsInstrumentationKey *string `json:"appInsightsInstrumentationKey,omitempty"`
	// AppInsightsSamplingRate - Indicates the sampling rate of application insight agent, should be in range [0.0, 100.0]
	AppInsightsSamplingRate *float64 `json:"appInsightsSamplingRate,omitempty"`
	// AppInsightsAgentVersions - Indicates the versions of application insight agent
	AppInsightsAgentVersions *ApplicationInsightsAgentVersions `json:"appInsightsAgentVersions,omitempty"`
}

// MarshalJSON is the custom marshaler for MonitoringSettingProperties.
func (msp MonitoringSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msp.Error != nil {
		objectMap["error"] = msp.Error
	}
	if msp.TraceEnabled != nil {
		objectMap["traceEnabled"] = msp.TraceEnabled
	}
	if msp.AppInsightsInstrumentationKey != nil {
		objectMap["appInsightsInstrumentationKey"] = msp.AppInsightsInstrumentationKey
	}
	if msp.AppInsightsSamplingRate != nil {
		objectMap["appInsightsSamplingRate"] = msp.AppInsightsSamplingRate
	}
	if msp.AppInsightsAgentVersions != nil {
		objectMap["appInsightsAgentVersions"] = msp.AppInsightsAgentVersions
	}
	return json.Marshal(objectMap)
}

// MonitoringSettingResource monitoring Setting resource
type MonitoringSettingResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the Monitoring Setting resource
	Properties *MonitoringSettingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for MonitoringSettingResource.
func (msr MonitoringSettingResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msr.Properties != nil {
		objectMap["properties"] = msr.Properties
	}
	if msr.SystemData != nil {
		objectMap["systemData"] = msr.SystemData
	}
	return json.Marshal(objectMap)
}

// MonitoringSettingsUpdatePatchFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MonitoringSettingsUpdatePatchFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MonitoringSettingsClient) (MonitoringSettingResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MonitoringSettingsUpdatePatchFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MonitoringSettingsUpdatePatchFuture.Result.
func (future *MonitoringSettingsUpdatePatchFuture) result(client MonitoringSettingsClient) (msr MonitoringSettingResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.MonitoringSettingsUpdatePatchFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		msr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.MonitoringSettingsUpdatePatchFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if msr.Response.Response, err = future.GetResult(sender); err == nil && msr.Response.Response.StatusCode != http.StatusNoContent {
		msr, err = client.UpdatePatchResponder(msr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.MonitoringSettingsUpdatePatchFuture", "Result", msr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MonitoringSettingsUpdatePutFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MonitoringSettingsUpdatePutFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MonitoringSettingsClient) (MonitoringSettingResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MonitoringSettingsUpdatePutFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MonitoringSettingsUpdatePutFuture.Result.
func (future *MonitoringSettingsUpdatePutFuture) result(client MonitoringSettingsClient) (msr MonitoringSettingResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.MonitoringSettingsUpdatePutFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		msr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.MonitoringSettingsUpdatePutFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if msr.Response.Response, err = future.GetResult(sender); err == nil && msr.Response.Response.StatusCode != http.StatusNoContent {
		msr, err = client.UpdatePutResponder(msr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.MonitoringSettingsUpdatePutFuture", "Result", msr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// NameAvailability name availability result payload
type NameAvailability struct {
	autorest.Response `json:"-"`
	// NameAvailable - Indicates whether the name is available
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - Reason why the name is not available
	Reason *string `json:"reason,omitempty"`
	// Message - Message why the name is not available
	Message *string `json:"message,omitempty"`
}

// NameAvailabilityParameters name availability parameters payload
type NameAvailabilityParameters struct {
	// Type - Type of the resource to check name availability
	Type *string `json:"type,omitempty"`
	// Name - Name to be checked
	Name *string `json:"name,omitempty"`
}

// NetCoreZipUploadedUserSourceInfo uploaded Jar binary for a deployment
type NetCoreZipUploadedUserSourceInfo struct {
	// NetCoreMainEntryPath - The path to the .NET executable relative to zip root
	NetCoreMainEntryPath *string `json:"netCoreMainEntryPath,omitempty"`
	// RuntimeVersion - Runtime version of the .Net file
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// RelativePath - Relative path of the storage which stores the source
	RelativePath *string `json:"relativePath,omitempty"`
	// Version - Version of the source
	Version *string `json:"version,omitempty"`
	// Type - Possible values include: 'TypeBasicUserSourceInfoTypeUserSourceInfo', 'TypeBasicUserSourceInfoTypeUploadedUserSourceInfo', 'TypeBasicUserSourceInfoTypeJar', 'TypeBasicUserSourceInfoTypeSource', 'TypeBasicUserSourceInfoTypeNetCoreZip', 'TypeBasicUserSourceInfoTypeBuildResult', 'TypeBasicUserSourceInfoTypeContainer'
	Type TypeBasicUserSourceInfo `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NetCoreZipUploadedUserSourceInfo.
func (nczuusi NetCoreZipUploadedUserSourceInfo) MarshalJSON() ([]byte, error) {
	nczuusi.Type = TypeBasicUserSourceInfoTypeNetCoreZip
	objectMap := make(map[string]interface{})
	if nczuusi.NetCoreMainEntryPath != nil {
		objectMap["netCoreMainEntryPath"] = nczuusi.NetCoreMainEntryPath
	}
	if nczuusi.RuntimeVersion != nil {
		objectMap["runtimeVersion"] = nczuusi.RuntimeVersion
	}
	if nczuusi.RelativePath != nil {
		objectMap["relativePath"] = nczuusi.RelativePath
	}
	if nczuusi.Version != nil {
		objectMap["version"] = nczuusi.Version
	}
	if nczuusi.Type != "" {
		objectMap["type"] = nczuusi.Type
	}
	return json.Marshal(objectMap)
}

// AsUploadedUserSourceInfo is the BasicUserSourceInfo implementation for NetCoreZipUploadedUserSourceInfo.
func (nczuusi NetCoreZipUploadedUserSourceInfo) AsUploadedUserSourceInfo() (*UploadedUserSourceInfo, bool) {
	return nil, false
}

// AsBasicUploadedUserSourceInfo is the BasicUserSourceInfo implementation for NetCoreZipUploadedUserSourceInfo.
func (nczuusi NetCoreZipUploadedUserSourceInfo) AsBasicUploadedUserSourceInfo() (BasicUploadedUserSourceInfo, bool) {
	return &nczuusi, true
}

// AsJarUploadedUserSourceInfo is the BasicUserSourceInfo implementation for NetCoreZipUploadedUserSourceInfo.
func (nczuusi NetCoreZipUploadedUserSourceInfo) AsJarUploadedUserSourceInfo() (*JarUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsSourceUploadedUserSourceInfo is the BasicUserSourceInfo implementation for NetCoreZipUploadedUserSourceInfo.
func (nczuusi NetCoreZipUploadedUserSourceInfo) AsSourceUploadedUserSourceInfo() (*SourceUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsNetCoreZipUploadedUserSourceInfo is the BasicUserSourceInfo implementation for NetCoreZipUploadedUserSourceInfo.
func (nczuusi NetCoreZipUploadedUserSourceInfo) AsNetCoreZipUploadedUserSourceInfo() (*NetCoreZipUploadedUserSourceInfo, bool) {
	return &nczuusi, true
}

// AsBuildResultUserSourceInfo is the BasicUserSourceInfo implementation for NetCoreZipUploadedUserSourceInfo.
func (nczuusi NetCoreZipUploadedUserSourceInfo) AsBuildResultUserSourceInfo() (*BuildResultUserSourceInfo, bool) {
	return nil, false
}

// AsCustomContainerUserSourceInfo is the BasicUserSourceInfo implementation for NetCoreZipUploadedUserSourceInfo.
func (nczuusi NetCoreZipUploadedUserSourceInfo) AsCustomContainerUserSourceInfo() (*CustomContainerUserSourceInfo, bool) {
	return nil, false
}

// AsUserSourceInfo is the BasicUserSourceInfo implementation for NetCoreZipUploadedUserSourceInfo.
func (nczuusi NetCoreZipUploadedUserSourceInfo) AsUserSourceInfo() (*UserSourceInfo, bool) {
	return nil, false
}

// AsBasicUserSourceInfo is the BasicUserSourceInfo implementation for NetCoreZipUploadedUserSourceInfo.
func (nczuusi NetCoreZipUploadedUserSourceInfo) AsBasicUserSourceInfo() (BasicUserSourceInfo, bool) {
	return &nczuusi, true
}

// NetworkProfile service network profile payload
type NetworkProfile struct {
	// ServiceRuntimeSubnetID - Fully qualified resource Id of the subnet to host Azure Spring Cloud Service Runtime
	ServiceRuntimeSubnetID *string `json:"serviceRuntimeSubnetId,omitempty"`
	// AppSubnetID - Fully qualified resource Id of the subnet to host Azure Spring Cloud Apps
	AppSubnetID *string `json:"appSubnetId,omitempty"`
	// ServiceCidr - Azure Spring Cloud service reserved CIDR
	ServiceCidr *string `json:"serviceCidr,omitempty"`
	// ServiceRuntimeNetworkResourceGroup - Name of the resource group containing network resources of Azure Spring Cloud Service Runtime
	ServiceRuntimeNetworkResourceGroup *string `json:"serviceRuntimeNetworkResourceGroup,omitempty"`
	// AppNetworkResourceGroup - Name of the resource group containing network resources of Azure Spring Cloud Apps
	AppNetworkResourceGroup *string `json:"appNetworkResourceGroup,omitempty"`
	// OutboundIPs - READ-ONLY; Desired outbound IP resources for Azure Spring Cloud instance.
	OutboundIPs *NetworkProfileOutboundIPs `json:"outboundIPs,omitempty"`
	// RequiredTraffics - READ-ONLY; Required inbound or outbound traffics for Azure Spring Cloud instance.
	RequiredTraffics *[]RequiredTraffic `json:"requiredTraffics,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkProfile.
func (np NetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if np.ServiceRuntimeSubnetID != nil {
		objectMap["serviceRuntimeSubnetId"] = np.ServiceRuntimeSubnetID
	}
	if np.AppSubnetID != nil {
		objectMap["appSubnetId"] = np.AppSubnetID
	}
	if np.ServiceCidr != nil {
		objectMap["serviceCidr"] = np.ServiceCidr
	}
	if np.ServiceRuntimeNetworkResourceGroup != nil {
		objectMap["serviceRuntimeNetworkResourceGroup"] = np.ServiceRuntimeNetworkResourceGroup
	}
	if np.AppNetworkResourceGroup != nil {
		objectMap["appNetworkResourceGroup"] = np.AppNetworkResourceGroup
	}
	return json.Marshal(objectMap)
}

// NetworkProfileOutboundIPs desired outbound IP resources for Azure Spring Cloud instance.
type NetworkProfileOutboundIPs struct {
	// PublicIPs - READ-ONLY; A list of public IP addresses.
	PublicIPs *[]string `json:"publicIPs,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkProfileOutboundIPs.
func (npP NetworkProfileOutboundIPs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationDetail operation detail payload
type OperationDetail struct {
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Display of the operation
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - Origin of the operation
	Origin *string `json:"origin,omitempty"`
	// Properties - Properties of the operation
	Properties *OperationProperties `json:"properties,omitempty"`
}

// OperationDisplay operation display payload
type OperationDisplay struct {
	// Provider - Resource provider of the operation
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource of the operation
	Resource *string `json:"resource,omitempty"`
	// Operation - Localized friendly name for the operation
	Operation *string `json:"operation,omitempty"`
	// Description - Localized friendly description for the operation
	Description *string `json:"description,omitempty"`
}

// OperationProperties extra Operation properties
type OperationProperties struct {
	// ServiceSpecification - Service specifications of the operation
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// PersistentDisk persistent disk payload
type PersistentDisk struct {
	// SizeInGB - Size of the persistent disk in GB
	SizeInGB *int32 `json:"sizeInGB,omitempty"`
	// UsedInGB - READ-ONLY; Size of the used persistent disk in GB
	UsedInGB *int32 `json:"usedInGB,omitempty"`
	// MountPath - Mount path of the persistent disk
	MountPath *string `json:"mountPath,omitempty"`
}

// MarshalJSON is the custom marshaler for PersistentDisk.
func (pd PersistentDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pd.SizeInGB != nil {
		objectMap["sizeInGB"] = pd.SizeInGB
	}
	if pd.MountPath != nil {
		objectMap["mountPath"] = pd.MountPath
	}
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags.
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pr.SystemData != nil {
		objectMap["systemData"] = pr.SystemData
	}
	return json.Marshal(objectMap)
}

// RegenerateTestKeyRequestPayload regenerate test key request payload
type RegenerateTestKeyRequestPayload struct {
	// KeyType - Type of the test key. Possible values include: 'TestKeyTypePrimary', 'TestKeyTypeSecondary'
	KeyType TestKeyType `json:"keyType,omitempty"`
}

// RequiredTraffic required inbound or outbound traffic for Azure Spring Cloud instance.
type RequiredTraffic struct {
	// Protocol - READ-ONLY; The protocol of required traffic
	Protocol *string `json:"protocol,omitempty"`
	// Port - READ-ONLY; The port of required traffic
	Port *int32 `json:"port,omitempty"`
	// Ips - READ-ONLY; The ip list of required traffic
	Ips *[]string `json:"ips,omitempty"`
	// Fqdns - READ-ONLY; The FQDN list of required traffic
	Fqdns *[]string `json:"fqdns,omitempty"`
	// Direction - READ-ONLY; The direction of required traffic. Possible values include: 'TrafficDirectionInbound', 'TrafficDirectionOutbound'
	Direction TrafficDirection `json:"direction,omitempty"`
}

// MarshalJSON is the custom marshaler for RequiredTraffic.
func (rt RequiredTraffic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource the core properties of ARM resources.
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.SystemData != nil {
		objectMap["systemData"] = r.SystemData
	}
	return json.Marshal(objectMap)
}

// ResourceRequests deployment resource request payload
type ResourceRequests struct {
	// CPU - Required CPU. 1 core can be represented by 1 or 1000m. This should be 500m or 1 for Basic tier, and {500m, 1, 2, 3, 4} for Standard tier.
	CPU *string `json:"cpu,omitempty"`
	// Memory - Required memory. 1 GB can be represented by 1Gi or 1024Mi. This should be {512Mi, 1Gi, 2Gi} for Basic tier, and {512Mi, 1Gi, 2Gi, ..., 8Gi} for Standard tier.
	Memory *string `json:"memory,omitempty"`
}

// ResourceSku describes an available Azure Spring Cloud SKU.
type ResourceSku struct {
	// ResourceType - Gets the type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`
	// Name - Gets the name of SKU.
	Name *string `json:"name,omitempty"`
	// Tier - Gets the tier of SKU.
	Tier *string `json:"tier,omitempty"`
	// Capacity - Gets the capacity of SKU.
	Capacity *SkuCapacity `json:"capacity,omitempty"`
	// Locations - Gets the set of locations that the SKU is available.
	Locations *[]string `json:"locations,omitempty"`
	// LocationInfo - Gets a list of locations and availability zones in those locations where the SKU is available.
	LocationInfo *[]ResourceSkuLocationInfo `json:"locationInfo,omitempty"`
	// Restrictions - Gets the restrictions because of which SKU cannot be used. This is
	// empty if there are no restrictions.
	Restrictions *[]ResourceSkuRestrictions `json:"restrictions,omitempty"`
}

// ResourceSkuCapabilities ...
type ResourceSkuCapabilities struct {
	// Name - Gets an invariant to describe the feature.
	Name *string `json:"name,omitempty"`
	// Value - Gets an invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty"`
}

// ResourceSkuCollection object that includes an array of Azure Spring Cloud SKU and a possible link for
// next set
type ResourceSkuCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resource SKU
	Value *[]ResourceSku `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceSkuCollectionIterator provides access to a complete listing of ResourceSku values.
type ResourceSkuCollectionIterator struct {
	i    int
	page ResourceSkuCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceSkuCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkuCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceSkuCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceSkuCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceSkuCollectionIterator) Response() ResourceSkuCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceSkuCollectionIterator) Value() ResourceSku {
	if !iter.page.NotDone() {
		return ResourceSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceSkuCollectionIterator type.
func NewResourceSkuCollectionIterator(page ResourceSkuCollectionPage) ResourceSkuCollectionIterator {
	return ResourceSkuCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rsc ResourceSkuCollection) IsEmpty() bool {
	return rsc.Value == nil || len(*rsc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rsc ResourceSkuCollection) hasNextLink() bool {
	return rsc.NextLink != nil && len(*rsc.NextLink) != 0
}

// resourceSkuCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rsc ResourceSkuCollection) resourceSkuCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !rsc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rsc.NextLink)))
}

// ResourceSkuCollectionPage contains a page of ResourceSku values.
type ResourceSkuCollectionPage struct {
	fn  func(context.Context, ResourceSkuCollection) (ResourceSkuCollection, error)
	rsc ResourceSkuCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceSkuCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkuCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rsc)
		if err != nil {
			return err
		}
		page.rsc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceSkuCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceSkuCollectionPage) NotDone() bool {
	return !page.rsc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceSkuCollectionPage) Response() ResourceSkuCollection {
	return page.rsc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceSkuCollectionPage) Values() []ResourceSku {
	if page.rsc.IsEmpty() {
		return nil
	}
	return *page.rsc.Value
}

// Creates a new instance of the ResourceSkuCollectionPage type.
func NewResourceSkuCollectionPage(cur ResourceSkuCollection, getNextPage func(context.Context, ResourceSkuCollection) (ResourceSkuCollection, error)) ResourceSkuCollectionPage {
	return ResourceSkuCollectionPage{
		fn:  getNextPage,
		rsc: cur,
	}
}

// ResourceSkuLocationInfo locations and availability zones where the SKU is available
type ResourceSkuLocationInfo struct {
	// Location - Gets location of the SKU
	Location *string `json:"location,omitempty"`
	// Zones - Gets list of availability zones where the SKU is supported.
	Zones *[]string `json:"zones,omitempty"`
	// ZoneDetails - Gets details of capabilities available to a SKU in specific zones.
	ZoneDetails *[]ResourceSkuZoneDetails `json:"zoneDetails,omitempty"`
}

// ResourceSkuRestrictionInfo information about the restriction where the SKU cannot be used
type ResourceSkuRestrictionInfo struct {
	// Locations - Gets locations where the SKU is restricted
	Locations *[]string `json:"locations,omitempty"`
	// Zones - Gets list of availability zones where the SKU is restricted.
	Zones *[]string `json:"zones,omitempty"`
}

// ResourceSkuRestrictions restrictions where the SKU cannot be used
type ResourceSkuRestrictions struct {
	// Type - Gets the type of restrictions. Possible values include: 'Location', 'Zone'. Possible values include: 'ResourceSkuRestrictionsTypeLocation', 'ResourceSkuRestrictionsTypeZone'
	Type ResourceSkuRestrictionsType `json:"type,omitempty"`
	// Values - Gets the value of restrictions. If the restriction type is set to
	// location. This would be different locations where the SKU is restricted.
	Values *[]string `json:"values,omitempty"`
	// RestrictionInfo - Gets the information about the restriction where the SKU cannot be used.
	RestrictionInfo *ResourceSkuRestrictionInfo `json:"restrictionInfo,omitempty"`
	// ReasonCode - Gets the reason for restriction. Possible values include: 'QuotaId', 'NotAvailableForSubscription'. Possible values include: 'ResourceSkuRestrictionsReasonCodeQuotaID', 'ResourceSkuRestrictionsReasonCodeNotAvailableForSubscription'
	ReasonCode ResourceSkuRestrictionsReasonCode `json:"reasonCode,omitempty"`
}

// ResourceSkuZoneDetails details of capabilities available to a SKU in specific zones
type ResourceSkuZoneDetails struct {
	// Name - Gets the set of zones that the SKU is available in with the
	// specified capabilities.
	Name *[]string `json:"name,omitempty"`
	// Capabilities - Gets a list of capabilities that are available for the SKU in the
	// specified list of zones.
	Capabilities *[]ResourceSkuCapabilities `json:"capabilities,omitempty"`
}

// ResourceUploadDefinition resource upload definition payload
type ResourceUploadDefinition struct {
	autorest.Response `json:"-"`
	// RelativePath - Source relative path
	RelativePath *string `json:"relativePath,omitempty"`
	// UploadURL - Upload URL
	UploadURL *string `json:"uploadUrl,omitempty"`
}

// ServiceRegistriesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServiceRegistriesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServiceRegistriesClient) (ServiceRegistryResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServiceRegistriesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServiceRegistriesCreateOrUpdateFuture.Result.
func (future *ServiceRegistriesCreateOrUpdateFuture) result(client ServiceRegistriesClient) (srr ServiceRegistryResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ServiceRegistriesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		srr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.ServiceRegistriesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if srr.Response.Response, err = future.GetResult(sender); err == nil && srr.Response.Response.StatusCode != http.StatusNoContent {
		srr, err = client.CreateOrUpdateResponder(srr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.ServiceRegistriesCreateOrUpdateFuture", "Result", srr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServiceRegistriesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServiceRegistriesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServiceRegistriesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServiceRegistriesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServiceRegistriesDeleteFuture.Result.
func (future *ServiceRegistriesDeleteFuture) result(client ServiceRegistriesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ServiceRegistriesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.ServiceRegistriesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceRegistryInstance collection of instances belong to the Service Registry
type ServiceRegistryInstance struct {
	// Name - READ-ONLY; Name of the Service Registry instance
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; Status of the Service Registry instance
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceRegistryInstance.
func (sri ServiceRegistryInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ServiceRegistryProperties service Registry properties payload
type ServiceRegistryProperties struct {
	// ProvisioningState - READ-ONLY; State of the Service Registry. Possible values include: 'ServiceRegistryProvisioningStateCreating', 'ServiceRegistryProvisioningStateUpdating', 'ServiceRegistryProvisioningStateSucceeded', 'ServiceRegistryProvisioningStateFailed', 'ServiceRegistryProvisioningStateDeleting'
	ProvisioningState ServiceRegistryProvisioningState `json:"provisioningState,omitempty"`
	// ResourceRequests - The requested resource quantity for required CPU and Memory.
	ResourceRequests *ServiceRegistryResourceRequests `json:"resourceRequests,omitempty"`
	// Instances - READ-ONLY; Collection of instances belong to Service Registry.
	Instances *[]ServiceRegistryInstance `json:"instances,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceRegistryProperties.
func (srp ServiceRegistryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if srp.ResourceRequests != nil {
		objectMap["resourceRequests"] = srp.ResourceRequests
	}
	return json.Marshal(objectMap)
}

// ServiceRegistryResource service Registry resource
type ServiceRegistryResource struct {
	autorest.Response `json:"-"`
	Properties        *ServiceRegistryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceRegistryResource.
func (srr ServiceRegistryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if srr.Properties != nil {
		objectMap["properties"] = srr.Properties
	}
	if srr.SystemData != nil {
		objectMap["systemData"] = srr.SystemData
	}
	return json.Marshal(objectMap)
}

// ServiceRegistryResourceCollection object that includes an array of Service Registry resources and a
// possible link for next set
type ServiceRegistryResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Service Registry resources
	Value *[]ServiceRegistryResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceRegistryResourceCollectionIterator provides access to a complete listing of
// ServiceRegistryResource values.
type ServiceRegistryResourceCollectionIterator struct {
	i    int
	page ServiceRegistryResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceRegistryResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceRegistryResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceRegistryResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceRegistryResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceRegistryResourceCollectionIterator) Response() ServiceRegistryResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceRegistryResourceCollectionIterator) Value() ServiceRegistryResource {
	if !iter.page.NotDone() {
		return ServiceRegistryResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceRegistryResourceCollectionIterator type.
func NewServiceRegistryResourceCollectionIterator(page ServiceRegistryResourceCollectionPage) ServiceRegistryResourceCollectionIterator {
	return ServiceRegistryResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (srrc ServiceRegistryResourceCollection) IsEmpty() bool {
	return srrc.Value == nil || len(*srrc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (srrc ServiceRegistryResourceCollection) hasNextLink() bool {
	return srrc.NextLink != nil && len(*srrc.NextLink) != 0
}

// serviceRegistryResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srrc ServiceRegistryResourceCollection) serviceRegistryResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !srrc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srrc.NextLink)))
}

// ServiceRegistryResourceCollectionPage contains a page of ServiceRegistryResource values.
type ServiceRegistryResourceCollectionPage struct {
	fn   func(context.Context, ServiceRegistryResourceCollection) (ServiceRegistryResourceCollection, error)
	srrc ServiceRegistryResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceRegistryResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceRegistryResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.srrc)
		if err != nil {
			return err
		}
		page.srrc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceRegistryResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceRegistryResourceCollectionPage) NotDone() bool {
	return !page.srrc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceRegistryResourceCollectionPage) Response() ServiceRegistryResourceCollection {
	return page.srrc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceRegistryResourceCollectionPage) Values() []ServiceRegistryResource {
	if page.srrc.IsEmpty() {
		return nil
	}
	return *page.srrc.Value
}

// Creates a new instance of the ServiceRegistryResourceCollectionPage type.
func NewServiceRegistryResourceCollectionPage(cur ServiceRegistryResourceCollection, getNextPage func(context.Context, ServiceRegistryResourceCollection) (ServiceRegistryResourceCollection, error)) ServiceRegistryResourceCollectionPage {
	return ServiceRegistryResourceCollectionPage{
		fn:   getNextPage,
		srrc: cur,
	}
}

// ServiceRegistryResourceRequests resource request payload of Service Registry
type ServiceRegistryResourceRequests struct {
	// CPU - READ-ONLY; Cpu allocated to each Service Registry instance
	CPU *string `json:"cpu,omitempty"`
	// Memory - READ-ONLY; Memory allocated to each Service Registry instance
	Memory *string `json:"memory,omitempty"`
	// InstanceCount - READ-ONLY; Instance count of the Service Registry
	InstanceCount *int32 `json:"instanceCount,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceRegistryResourceRequests.
func (srrr ServiceRegistryResourceRequests) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ServiceResource service resource
type ServiceResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the Service resource
	Properties *ClusterResourceProperties `json:"properties,omitempty"`
	// Sku - Sku of the Service resource
	Sku *Sku `json:"sku,omitempty"`
	// Location - The GEO location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceResource.
func (sr ServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Properties != nil {
		objectMap["properties"] = sr.Properties
	}
	if sr.Sku != nil {
		objectMap["sku"] = sr.Sku
	}
	if sr.Location != nil {
		objectMap["location"] = sr.Location
	}
	if sr.Tags != nil {
		objectMap["tags"] = sr.Tags
	}
	if sr.SystemData != nil {
		objectMap["systemData"] = sr.SystemData
	}
	return json.Marshal(objectMap)
}

// ServiceResourceList object that includes an array of Service resources and a possible link for next set
type ServiceResourceList struct {
	autorest.Response `json:"-"`
	// Value - Collection of Service resources
	Value *[]ServiceResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceResourceListIterator provides access to a complete listing of ServiceResource values.
type ServiceResourceListIterator struct {
	i    int
	page ServiceResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceResourceListIterator) Response() ServiceResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceResourceListIterator) Value() ServiceResource {
	if !iter.page.NotDone() {
		return ServiceResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceResourceListIterator type.
func NewServiceResourceListIterator(page ServiceResourceListPage) ServiceResourceListIterator {
	return ServiceResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (srl ServiceResourceList) IsEmpty() bool {
	return srl.Value == nil || len(*srl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (srl ServiceResourceList) hasNextLink() bool {
	return srl.NextLink != nil && len(*srl.NextLink) != 0
}

// serviceResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srl ServiceResourceList) serviceResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !srl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srl.NextLink)))
}

// ServiceResourceListPage contains a page of ServiceResource values.
type ServiceResourceListPage struct {
	fn  func(context.Context, ServiceResourceList) (ServiceResourceList, error)
	srl ServiceResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.srl)
		if err != nil {
			return err
		}
		page.srl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceResourceListPage) NotDone() bool {
	return !page.srl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceResourceListPage) Response() ServiceResourceList {
	return page.srl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceResourceListPage) Values() []ServiceResource {
	if page.srl.IsEmpty() {
		return nil
	}
	return *page.srl.Value
}

// Creates a new instance of the ServiceResourceListPage type.
func NewServiceResourceListPage(cur ServiceResourceList, getNextPage func(context.Context, ServiceResourceList) (ServiceResourceList, error)) ServiceResourceListPage {
	return ServiceResourceListPage{
		fn:  getNextPage,
		srl: cur,
	}
}

// ServicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServicesClient) (ServiceResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServicesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServicesCreateOrUpdateFuture.Result.
func (future *ServicesCreateOrUpdateFuture) result(client ServicesClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ServicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.ServicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.CreateOrUpdateResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.ServicesCreateOrUpdateFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServicesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServicesDeleteFuture.Result.
func (future *ServicesDeleteFuture) result(client ServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ServicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.ServicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceSpecification service specification payload
type ServiceSpecification struct {
	// LogSpecifications - Specifications of the Log for Azure Monitoring
	LogSpecifications *[]LogSpecification `json:"logSpecifications,omitempty"`
	// MetricSpecifications - Specifications of the Metrics for Azure Monitoring
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// ServicesStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServicesStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServicesStartFuture.Result.
func (future *ServicesStartFuture) result(client ServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ServicesStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.ServicesStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServicesStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServicesStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServicesStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServicesStopFuture.Result.
func (future *ServicesStopFuture) result(client ServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ServicesStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.ServicesStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServicesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServicesClient) (ServiceResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServicesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServicesUpdateFuture.Result.
func (future *ServicesUpdateFuture) result(client ServicesClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ServicesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.ServicesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.UpdateResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.ServicesUpdateFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Sku sku of Azure Spring Cloud
type Sku struct {
	// Name - Name of the Sku
	Name *string `json:"name,omitempty"`
	// Tier - Tier of the Sku
	Tier *string `json:"tier,omitempty"`
	// Capacity - Current capacity of the target resource
	Capacity *int32 `json:"capacity,omitempty"`
}

// SkuCapacity the SKU capacity
type SkuCapacity struct {
	// Minimum - Gets or sets the minimum.
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - Gets or sets the maximum.
	Maximum *int32 `json:"maximum,omitempty"`
	// Default - Gets or sets the default.
	Default *int32 `json:"default,omitempty"`
	// ScaleType - Gets or sets the type of the scale. Possible values include: 'SkuScaleTypeNone', 'SkuScaleTypeManual', 'SkuScaleTypeAutomatic'
	ScaleType SkuScaleType `json:"scaleType,omitempty"`
}

// SourceUploadedUserSourceInfo uploaded Java source code binary for a deployment
type SourceUploadedUserSourceInfo struct {
	// ArtifactSelector - Selector for the artifact to be used for the deployment for multi-module projects. This should be
	// the relative path to the target module/project.
	ArtifactSelector *string `json:"artifactSelector,omitempty"`
	// RuntimeVersion - Runtime version of the source file
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// RelativePath - Relative path of the storage which stores the source
	RelativePath *string `json:"relativePath,omitempty"`
	// Version - Version of the source
	Version *string `json:"version,omitempty"`
	// Type - Possible values include: 'TypeBasicUserSourceInfoTypeUserSourceInfo', 'TypeBasicUserSourceInfoTypeUploadedUserSourceInfo', 'TypeBasicUserSourceInfoTypeJar', 'TypeBasicUserSourceInfoTypeSource', 'TypeBasicUserSourceInfoTypeNetCoreZip', 'TypeBasicUserSourceInfoTypeBuildResult', 'TypeBasicUserSourceInfoTypeContainer'
	Type TypeBasicUserSourceInfo `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceUploadedUserSourceInfo.
func (suusi SourceUploadedUserSourceInfo) MarshalJSON() ([]byte, error) {
	suusi.Type = TypeBasicUserSourceInfoTypeSource
	objectMap := make(map[string]interface{})
	if suusi.ArtifactSelector != nil {
		objectMap["artifactSelector"] = suusi.ArtifactSelector
	}
	if suusi.RuntimeVersion != nil {
		objectMap["runtimeVersion"] = suusi.RuntimeVersion
	}
	if suusi.RelativePath != nil {
		objectMap["relativePath"] = suusi.RelativePath
	}
	if suusi.Version != nil {
		objectMap["version"] = suusi.Version
	}
	if suusi.Type != "" {
		objectMap["type"] = suusi.Type
	}
	return json.Marshal(objectMap)
}

// AsUploadedUserSourceInfo is the BasicUserSourceInfo implementation for SourceUploadedUserSourceInfo.
func (suusi SourceUploadedUserSourceInfo) AsUploadedUserSourceInfo() (*UploadedUserSourceInfo, bool) {
	return nil, false
}

// AsBasicUploadedUserSourceInfo is the BasicUserSourceInfo implementation for SourceUploadedUserSourceInfo.
func (suusi SourceUploadedUserSourceInfo) AsBasicUploadedUserSourceInfo() (BasicUploadedUserSourceInfo, bool) {
	return &suusi, true
}

// AsJarUploadedUserSourceInfo is the BasicUserSourceInfo implementation for SourceUploadedUserSourceInfo.
func (suusi SourceUploadedUserSourceInfo) AsJarUploadedUserSourceInfo() (*JarUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsSourceUploadedUserSourceInfo is the BasicUserSourceInfo implementation for SourceUploadedUserSourceInfo.
func (suusi SourceUploadedUserSourceInfo) AsSourceUploadedUserSourceInfo() (*SourceUploadedUserSourceInfo, bool) {
	return &suusi, true
}

// AsNetCoreZipUploadedUserSourceInfo is the BasicUserSourceInfo implementation for SourceUploadedUserSourceInfo.
func (suusi SourceUploadedUserSourceInfo) AsNetCoreZipUploadedUserSourceInfo() (*NetCoreZipUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsBuildResultUserSourceInfo is the BasicUserSourceInfo implementation for SourceUploadedUserSourceInfo.
func (suusi SourceUploadedUserSourceInfo) AsBuildResultUserSourceInfo() (*BuildResultUserSourceInfo, bool) {
	return nil, false
}

// AsCustomContainerUserSourceInfo is the BasicUserSourceInfo implementation for SourceUploadedUserSourceInfo.
func (suusi SourceUploadedUserSourceInfo) AsCustomContainerUserSourceInfo() (*CustomContainerUserSourceInfo, bool) {
	return nil, false
}

// AsUserSourceInfo is the BasicUserSourceInfo implementation for SourceUploadedUserSourceInfo.
func (suusi SourceUploadedUserSourceInfo) AsUserSourceInfo() (*UserSourceInfo, bool) {
	return nil, false
}

// AsBasicUserSourceInfo is the BasicUserSourceInfo implementation for SourceUploadedUserSourceInfo.
func (suusi SourceUploadedUserSourceInfo) AsBasicUserSourceInfo() (BasicUserSourceInfo, bool) {
	return &suusi, true
}

// SsoProperties single sign-on related configuration
type SsoProperties struct {
	// Scope - It defines the specific actions applications can be allowed to do on a user's behalf
	Scope *[]string `json:"scope,omitempty"`
	// ClientID - The public identifier for the application
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - The secret known only to the application and the authorization server
	ClientSecret *string `json:"clientSecret,omitempty"`
	// IssuerURI - The URI of Issuer Identifier
	IssuerURI *string `json:"issuerUri,omitempty"`
}

// StackProperties kPack ClusterStack properties payload
type StackProperties struct {
	// ID - Id of the ClusterStack.
	ID *string `json:"id,omitempty"`
	// Version - Version of the ClusterStack
	Version *string `json:"version,omitempty"`
}

// StorageAccount storage resource of type Azure Storage Account.
type StorageAccount struct {
	// AccountName - The account name of the Azure Storage Account.
	AccountName *string `json:"accountName,omitempty"`
	// AccountKey - The account key of the Azure Storage Account.
	AccountKey *string `json:"accountKey,omitempty"`
	// StorageType - Possible values include: 'StorageTypeStorageProperties', 'StorageTypeStorageAccount'
	StorageType StorageType `json:"storageType,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageAccount.
func (sa StorageAccount) MarshalJSON() ([]byte, error) {
	sa.StorageType = StorageTypeStorageAccount
	objectMap := make(map[string]interface{})
	if sa.AccountName != nil {
		objectMap["accountName"] = sa.AccountName
	}
	if sa.AccountKey != nil {
		objectMap["accountKey"] = sa.AccountKey
	}
	if sa.StorageType != "" {
		objectMap["storageType"] = sa.StorageType
	}
	return json.Marshal(objectMap)
}

// AsStorageAccount is the BasicStorageProperties implementation for StorageAccount.
func (sa StorageAccount) AsStorageAccount() (*StorageAccount, bool) {
	return &sa, true
}

// AsStorageProperties is the BasicStorageProperties implementation for StorageAccount.
func (sa StorageAccount) AsStorageProperties() (*StorageProperties, bool) {
	return nil, false
}

// AsBasicStorageProperties is the BasicStorageProperties implementation for StorageAccount.
func (sa StorageAccount) AsBasicStorageProperties() (BasicStorageProperties, bool) {
	return &sa, true
}

// BasicStorageProperties storage resource payload.
type BasicStorageProperties interface {
	AsStorageAccount() (*StorageAccount, bool)
	AsStorageProperties() (*StorageProperties, bool)
}

// StorageProperties storage resource payload.
type StorageProperties struct {
	// StorageType - Possible values include: 'StorageTypeStorageProperties', 'StorageTypeStorageAccount'
	StorageType StorageType `json:"storageType,omitempty"`
}

func unmarshalBasicStorageProperties(body []byte) (BasicStorageProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["storageType"] {
	case string(StorageTypeStorageAccount):
		var sa StorageAccount
		err := json.Unmarshal(body, &sa)
		return sa, err
	default:
		var sp StorageProperties
		err := json.Unmarshal(body, &sp)
		return sp, err
	}
}
func unmarshalBasicStoragePropertiesArray(body []byte) ([]BasicStorageProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	spArray := make([]BasicStorageProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sp, err := unmarshalBasicStorageProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		spArray[index] = sp
	}
	return spArray, nil
}

// MarshalJSON is the custom marshaler for StorageProperties.
func (sp StorageProperties) MarshalJSON() ([]byte, error) {
	sp.StorageType = StorageTypeStorageProperties
	objectMap := make(map[string]interface{})
	if sp.StorageType != "" {
		objectMap["storageType"] = sp.StorageType
	}
	return json.Marshal(objectMap)
}

// AsStorageAccount is the BasicStorageProperties implementation for StorageProperties.
func (sp StorageProperties) AsStorageAccount() (*StorageAccount, bool) {
	return nil, false
}

// AsStorageProperties is the BasicStorageProperties implementation for StorageProperties.
func (sp StorageProperties) AsStorageProperties() (*StorageProperties, bool) {
	return &sp, true
}

// AsBasicStorageProperties is the BasicStorageProperties implementation for StorageProperties.
func (sp StorageProperties) AsBasicStorageProperties() (BasicStorageProperties, bool) {
	return &sp, true
}

// StorageResource storage resource payload.
type StorageResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the storage resource payload.
	Properties BasicStorageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageResource.
func (sr StorageResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = sr.Properties
	if sr.SystemData != nil {
		objectMap["systemData"] = sr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageResource struct.
func (sr *StorageResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicStorageProperties(*v)
				if err != nil {
					return err
				}
				sr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sr.SystemData = &systemData
			}
		}
	}

	return nil
}

// StorageResourceCollection collection compose of storage resources list and a possible link for next
// page.
type StorageResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - The storage resources list.
	Value *[]StorageResource `json:"value,omitempty"`
	// NextLink - The link to next page of storage list.
	NextLink *string `json:"nextLink,omitempty"`
}

// StorageResourceCollectionIterator provides access to a complete listing of StorageResource values.
type StorageResourceCollectionIterator struct {
	i    int
	page StorageResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StorageResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StorageResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StorageResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StorageResourceCollectionIterator) Response() StorageResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StorageResourceCollectionIterator) Value() StorageResource {
	if !iter.page.NotDone() {
		return StorageResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StorageResourceCollectionIterator type.
func NewStorageResourceCollectionIterator(page StorageResourceCollectionPage) StorageResourceCollectionIterator {
	return StorageResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (src StorageResourceCollection) IsEmpty() bool {
	return src.Value == nil || len(*src.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (src StorageResourceCollection) hasNextLink() bool {
	return src.NextLink != nil && len(*src.NextLink) != 0
}

// storageResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (src StorageResourceCollection) storageResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !src.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(src.NextLink)))
}

// StorageResourceCollectionPage contains a page of StorageResource values.
type StorageResourceCollectionPage struct {
	fn  func(context.Context, StorageResourceCollection) (StorageResourceCollection, error)
	src StorageResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StorageResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.src)
		if err != nil {
			return err
		}
		page.src = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StorageResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StorageResourceCollectionPage) NotDone() bool {
	return !page.src.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StorageResourceCollectionPage) Response() StorageResourceCollection {
	return page.src
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StorageResourceCollectionPage) Values() []StorageResource {
	if page.src.IsEmpty() {
		return nil
	}
	return *page.src.Value
}

// Creates a new instance of the StorageResourceCollectionPage type.
func NewStorageResourceCollectionPage(cur StorageResourceCollection, getNextPage func(context.Context, StorageResourceCollection) (StorageResourceCollection, error)) StorageResourceCollectionPage {
	return StorageResourceCollectionPage{
		fn:  getNextPage,
		src: cur,
	}
}

// StoragesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type StoragesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StoragesClient) (StorageResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StoragesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StoragesCreateOrUpdateFuture.Result.
func (future *StoragesCreateOrUpdateFuture) result(client StoragesClient) (sr StorageResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.StoragesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.StoragesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.CreateOrUpdateResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.StoragesCreateOrUpdateFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// StoragesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type StoragesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StoragesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StoragesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StoragesDeleteFuture.Result.
func (future *StoragesDeleteFuture) result(client StoragesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.StoragesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("appplatform.StoragesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SupportedBuildpackResource supported buildpack resource payload
type SupportedBuildpackResource struct {
	autorest.Response `json:"-"`
	Properties        *SupportedBuildpackResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SupportedBuildpackResource.
func (sbr SupportedBuildpackResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sbr.Properties != nil {
		objectMap["properties"] = sbr.Properties
	}
	if sbr.SystemData != nil {
		objectMap["systemData"] = sbr.SystemData
	}
	return json.Marshal(objectMap)
}

// SupportedBuildpackResourceProperties supported buildpack resource properties
type SupportedBuildpackResourceProperties struct {
	// BuildpackID - The id of supported buildpack
	BuildpackID *string `json:"buildpackId,omitempty"`
}

// SupportedBuildpacksCollection object that includes an array of supported buildpacks resources and a
// possible link for next set
type SupportedBuildpacksCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of supported buildpacks resources
	Value *[]SupportedBuildpackResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// SupportedRuntimeVersion supported deployment runtime version descriptor.
type SupportedRuntimeVersion struct {
	// Value - The raw value which could be passed to deployment CRUD operations. Possible values include: 'SupportedRuntimeValueJava8', 'SupportedRuntimeValueJava11', 'SupportedRuntimeValueJava17', 'SupportedRuntimeValueNetCore31'
	Value SupportedRuntimeValue `json:"value,omitempty"`
	// Platform - The platform of this runtime version (possible values: "Java" or ".NET"). Possible values include: 'SupportedRuntimePlatformJava', 'SupportedRuntimePlatformNETCore'
	Platform SupportedRuntimePlatform `json:"platform,omitempty"`
	// Version - The detailed version (major.minor) of the platform.
	Version *string `json:"version,omitempty"`
}

// SupportedStackResource supported stack resource payload
type SupportedStackResource struct {
	autorest.Response `json:"-"`
	Properties        *SupportedStackResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SupportedStackResource.
func (ssr SupportedStackResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssr.Properties != nil {
		objectMap["properties"] = ssr.Properties
	}
	if ssr.SystemData != nil {
		objectMap["systemData"] = ssr.SystemData
	}
	return json.Marshal(objectMap)
}

// SupportedStackResourceProperties supported stack resource properties
type SupportedStackResourceProperties struct {
	// StackID - The id of supported stack
	StackID *string `json:"stackId,omitempty"`
	// Version - The version of supported stack
	Version *string `json:"version,omitempty"`
}

// SupportedStacksCollection object that includes an array of supported stacks resources and a possible
// link for next set
type SupportedStacksCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of supported stacks resources
	Value *[]SupportedStackResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'LastModifiedByTypeUser', 'LastModifiedByTypeApplication', 'LastModifiedByTypeManagedIdentity', 'LastModifiedByTypeKey'
	LastModifiedByType LastModifiedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource modification (UTC).
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TemporaryDisk temporary disk payload
type TemporaryDisk struct {
	// SizeInGB - Size of the temporary disk in GB
	SizeInGB *int32 `json:"sizeInGB,omitempty"`
	// MountPath - Mount path of the temporary disk
	MountPath *string `json:"mountPath,omitempty"`
}

// TestKeys test keys payload
type TestKeys struct {
	autorest.Response `json:"-"`
	// PrimaryKey - Primary key
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary key
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// PrimaryTestEndpoint - Primary test endpoint
	PrimaryTestEndpoint *string `json:"primaryTestEndpoint,omitempty"`
	// SecondaryTestEndpoint - Secondary test endpoint
	SecondaryTestEndpoint *string `json:"secondaryTestEndpoint,omitempty"`
	// Enabled - Indicates whether the test endpoint feature enabled or not
	Enabled *bool `json:"enabled,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource.
type TrackedResource struct {
	// Location - The GEO location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.SystemData != nil {
		objectMap["systemData"] = tr.SystemData
	}
	return json.Marshal(objectMap)
}

// TriggeredBuildResult the build result triggered by a build
type TriggeredBuildResult struct {
	// ID - The unique build id of this build result
	ID *string `json:"id,omitempty"`
}

// BasicUploadedUserSourceInfo source with uploaded location
type BasicUploadedUserSourceInfo interface {
	AsJarUploadedUserSourceInfo() (*JarUploadedUserSourceInfo, bool)
	AsSourceUploadedUserSourceInfo() (*SourceUploadedUserSourceInfo, bool)
	AsNetCoreZipUploadedUserSourceInfo() (*NetCoreZipUploadedUserSourceInfo, bool)
	AsUploadedUserSourceInfo() (*UploadedUserSourceInfo, bool)
}

// UploadedUserSourceInfo source with uploaded location
type UploadedUserSourceInfo struct {
	// RelativePath - Relative path of the storage which stores the source
	RelativePath *string `json:"relativePath,omitempty"`
	// Version - Version of the source
	Version *string `json:"version,omitempty"`
	// Type - Possible values include: 'TypeBasicUserSourceInfoTypeUserSourceInfo', 'TypeBasicUserSourceInfoTypeUploadedUserSourceInfo', 'TypeBasicUserSourceInfoTypeJar', 'TypeBasicUserSourceInfoTypeSource', 'TypeBasicUserSourceInfoTypeNetCoreZip', 'TypeBasicUserSourceInfoTypeBuildResult', 'TypeBasicUserSourceInfoTypeContainer'
	Type TypeBasicUserSourceInfo `json:"type,omitempty"`
}

func unmarshalBasicUploadedUserSourceInfo(body []byte) (BasicUploadedUserSourceInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicUserSourceInfoTypeJar):
		var juusi JarUploadedUserSourceInfo
		err := json.Unmarshal(body, &juusi)
		return juusi, err
	case string(TypeBasicUserSourceInfoTypeSource):
		var suusi SourceUploadedUserSourceInfo
		err := json.Unmarshal(body, &suusi)
		return suusi, err
	case string(TypeBasicUserSourceInfoTypeNetCoreZip):
		var nczuusi NetCoreZipUploadedUserSourceInfo
		err := json.Unmarshal(body, &nczuusi)
		return nczuusi, err
	default:
		var uusi UploadedUserSourceInfo
		err := json.Unmarshal(body, &uusi)
		return uusi, err
	}
}
func unmarshalBasicUploadedUserSourceInfoArray(body []byte) ([]BasicUploadedUserSourceInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	uusiArray := make([]BasicUploadedUserSourceInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		uusi, err := unmarshalBasicUploadedUserSourceInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		uusiArray[index] = uusi
	}
	return uusiArray, nil
}

// MarshalJSON is the custom marshaler for UploadedUserSourceInfo.
func (uusi UploadedUserSourceInfo) MarshalJSON() ([]byte, error) {
	uusi.Type = TypeBasicUserSourceInfoTypeUploadedUserSourceInfo
	objectMap := make(map[string]interface{})
	if uusi.RelativePath != nil {
		objectMap["relativePath"] = uusi.RelativePath
	}
	if uusi.Version != nil {
		objectMap["version"] = uusi.Version
	}
	if uusi.Type != "" {
		objectMap["type"] = uusi.Type
	}
	return json.Marshal(objectMap)
}

// AsUploadedUserSourceInfo is the BasicUserSourceInfo implementation for UploadedUserSourceInfo.
func (uusi UploadedUserSourceInfo) AsUploadedUserSourceInfo() (*UploadedUserSourceInfo, bool) {
	return &uusi, true
}

// AsBasicUploadedUserSourceInfo is the BasicUserSourceInfo implementation for UploadedUserSourceInfo.
func (uusi UploadedUserSourceInfo) AsBasicUploadedUserSourceInfo() (BasicUploadedUserSourceInfo, bool) {
	return &uusi, true
}

// AsJarUploadedUserSourceInfo is the BasicUserSourceInfo implementation for UploadedUserSourceInfo.
func (uusi UploadedUserSourceInfo) AsJarUploadedUserSourceInfo() (*JarUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsSourceUploadedUserSourceInfo is the BasicUserSourceInfo implementation for UploadedUserSourceInfo.
func (uusi UploadedUserSourceInfo) AsSourceUploadedUserSourceInfo() (*SourceUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsNetCoreZipUploadedUserSourceInfo is the BasicUserSourceInfo implementation for UploadedUserSourceInfo.
func (uusi UploadedUserSourceInfo) AsNetCoreZipUploadedUserSourceInfo() (*NetCoreZipUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsBuildResultUserSourceInfo is the BasicUserSourceInfo implementation for UploadedUserSourceInfo.
func (uusi UploadedUserSourceInfo) AsBuildResultUserSourceInfo() (*BuildResultUserSourceInfo, bool) {
	return nil, false
}

// AsCustomContainerUserSourceInfo is the BasicUserSourceInfo implementation for UploadedUserSourceInfo.
func (uusi UploadedUserSourceInfo) AsCustomContainerUserSourceInfo() (*CustomContainerUserSourceInfo, bool) {
	return nil, false
}

// AsUserSourceInfo is the BasicUserSourceInfo implementation for UploadedUserSourceInfo.
func (uusi UploadedUserSourceInfo) AsUserSourceInfo() (*UserSourceInfo, bool) {
	return nil, false
}

// AsBasicUserSourceInfo is the BasicUserSourceInfo implementation for UploadedUserSourceInfo.
func (uusi UploadedUserSourceInfo) AsBasicUserSourceInfo() (BasicUserSourceInfo, bool) {
	return &uusi, true
}

// BasicUserSourceInfo source information for a deployment
type BasicUserSourceInfo interface {
	AsUploadedUserSourceInfo() (*UploadedUserSourceInfo, bool)
	AsBasicUploadedUserSourceInfo() (BasicUploadedUserSourceInfo, bool)
	AsJarUploadedUserSourceInfo() (*JarUploadedUserSourceInfo, bool)
	AsSourceUploadedUserSourceInfo() (*SourceUploadedUserSourceInfo, bool)
	AsNetCoreZipUploadedUserSourceInfo() (*NetCoreZipUploadedUserSourceInfo, bool)
	AsBuildResultUserSourceInfo() (*BuildResultUserSourceInfo, bool)
	AsCustomContainerUserSourceInfo() (*CustomContainerUserSourceInfo, bool)
	AsUserSourceInfo() (*UserSourceInfo, bool)
}

// UserSourceInfo source information for a deployment
type UserSourceInfo struct {
	// Version - Version of the source
	Version *string `json:"version,omitempty"`
	// Type - Possible values include: 'TypeBasicUserSourceInfoTypeUserSourceInfo', 'TypeBasicUserSourceInfoTypeUploadedUserSourceInfo', 'TypeBasicUserSourceInfoTypeJar', 'TypeBasicUserSourceInfoTypeSource', 'TypeBasicUserSourceInfoTypeNetCoreZip', 'TypeBasicUserSourceInfoTypeBuildResult', 'TypeBasicUserSourceInfoTypeContainer'
	Type TypeBasicUserSourceInfo `json:"type,omitempty"`
}

func unmarshalBasicUserSourceInfo(body []byte) (BasicUserSourceInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicUserSourceInfoTypeUploadedUserSourceInfo):
		var uusi UploadedUserSourceInfo
		err := json.Unmarshal(body, &uusi)
		return uusi, err
	case string(TypeBasicUserSourceInfoTypeJar):
		var juusi JarUploadedUserSourceInfo
		err := json.Unmarshal(body, &juusi)
		return juusi, err
	case string(TypeBasicUserSourceInfoTypeSource):
		var suusi SourceUploadedUserSourceInfo
		err := json.Unmarshal(body, &suusi)
		return suusi, err
	case string(TypeBasicUserSourceInfoTypeNetCoreZip):
		var nczuusi NetCoreZipUploadedUserSourceInfo
		err := json.Unmarshal(body, &nczuusi)
		return nczuusi, err
	case string(TypeBasicUserSourceInfoTypeBuildResult):
		var brusi BuildResultUserSourceInfo
		err := json.Unmarshal(body, &brusi)
		return brusi, err
	case string(TypeBasicUserSourceInfoTypeContainer):
		var ccusi CustomContainerUserSourceInfo
		err := json.Unmarshal(body, &ccusi)
		return ccusi, err
	default:
		var usi UserSourceInfo
		err := json.Unmarshal(body, &usi)
		return usi, err
	}
}
func unmarshalBasicUserSourceInfoArray(body []byte) ([]BasicUserSourceInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	usiArray := make([]BasicUserSourceInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		usi, err := unmarshalBasicUserSourceInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		usiArray[index] = usi
	}
	return usiArray, nil
}

// MarshalJSON is the custom marshaler for UserSourceInfo.
func (usi UserSourceInfo) MarshalJSON() ([]byte, error) {
	usi.Type = TypeBasicUserSourceInfoTypeUserSourceInfo
	objectMap := make(map[string]interface{})
	if usi.Version != nil {
		objectMap["version"] = usi.Version
	}
	if usi.Type != "" {
		objectMap["type"] = usi.Type
	}
	return json.Marshal(objectMap)
}

// AsUploadedUserSourceInfo is the BasicUserSourceInfo implementation for UserSourceInfo.
func (usi UserSourceInfo) AsUploadedUserSourceInfo() (*UploadedUserSourceInfo, bool) {
	return nil, false
}

// AsBasicUploadedUserSourceInfo is the BasicUserSourceInfo implementation for UserSourceInfo.
func (usi UserSourceInfo) AsBasicUploadedUserSourceInfo() (BasicUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsJarUploadedUserSourceInfo is the BasicUserSourceInfo implementation for UserSourceInfo.
func (usi UserSourceInfo) AsJarUploadedUserSourceInfo() (*JarUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsSourceUploadedUserSourceInfo is the BasicUserSourceInfo implementation for UserSourceInfo.
func (usi UserSourceInfo) AsSourceUploadedUserSourceInfo() (*SourceUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsNetCoreZipUploadedUserSourceInfo is the BasicUserSourceInfo implementation for UserSourceInfo.
func (usi UserSourceInfo) AsNetCoreZipUploadedUserSourceInfo() (*NetCoreZipUploadedUserSourceInfo, bool) {
	return nil, false
}

// AsBuildResultUserSourceInfo is the BasicUserSourceInfo implementation for UserSourceInfo.
func (usi UserSourceInfo) AsBuildResultUserSourceInfo() (*BuildResultUserSourceInfo, bool) {
	return nil, false
}

// AsCustomContainerUserSourceInfo is the BasicUserSourceInfo implementation for UserSourceInfo.
func (usi UserSourceInfo) AsCustomContainerUserSourceInfo() (*CustomContainerUserSourceInfo, bool) {
	return nil, false
}

// AsUserSourceInfo is the BasicUserSourceInfo implementation for UserSourceInfo.
func (usi UserSourceInfo) AsUserSourceInfo() (*UserSourceInfo, bool) {
	return &usi, true
}

// AsBasicUserSourceInfo is the BasicUserSourceInfo implementation for UserSourceInfo.
func (usi UserSourceInfo) AsBasicUserSourceInfo() (BasicUserSourceInfo, bool) {
	return &usi, true
}

// ValidationMessages validate messages of the configuration service git repositories
type ValidationMessages struct {
	// Name - The name of the configuration service git repository.
	Name *string `json:"name,omitempty"`
	// Messages - Detailed validation messages.
	Messages *[]string `json:"messages,omitempty"`
}
