package workloadmonitor

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AlertGeneration enumerates the values for alert generation.
type AlertGeneration string

const (
	// Disabled ...
	Disabled AlertGeneration = "Disabled"
	// Enabled ...
	Enabled AlertGeneration = "Enabled"
)

// PossibleAlertGenerationValues returns an array of possible values for the AlertGeneration const type.
func PossibleAlertGenerationValues() []AlertGeneration {
	return []AlertGeneration{Disabled, Enabled}
}

// HealthState enumerates the values for health state.
type HealthState string

const (
	// Error ...
	Error HealthState = "Error"
	// Success ...
	Success HealthState = "Success"
	// Uninitialized ...
	Uninitialized HealthState = "Uninitialized"
	// Unknown ...
	Unknown HealthState = "Unknown"
	// Warning ...
	Warning HealthState = "Warning"
)

// PossibleHealthStateValues returns an array of possible values for the HealthState const type.
func PossibleHealthStateValues() []HealthState {
	return []HealthState{Error, Success, Uninitialized, Unknown, Warning}
}

// HealthStateCategory enumerates the values for health state category.
type HealthStateCategory string

const (
	// CustomGroup ...
	CustomGroup HealthStateCategory = "CustomGroup"
	// Identity ...
	Identity HealthStateCategory = "Identity"
)

// PossibleHealthStateCategoryValues returns an array of possible values for the HealthStateCategory const type.
func PossibleHealthStateCategoryValues() []HealthStateCategory {
	return []HealthStateCategory{CustomGroup, Identity}
}

// MonitorCategory enumerates the values for monitor category.
type MonitorCategory string

const (
	// AvailabilityHealth ...
	AvailabilityHealth MonitorCategory = "AvailabilityHealth"
	// Configuration ...
	Configuration MonitorCategory = "Configuration"
	// EntityHealth ...
	EntityHealth MonitorCategory = "EntityHealth"
	// PerformanceHealth ...
	PerformanceHealth MonitorCategory = "PerformanceHealth"
	// Security ...
	Security MonitorCategory = "Security"
)

// PossibleMonitorCategoryValues returns an array of possible values for the MonitorCategory const type.
func PossibleMonitorCategoryValues() []MonitorCategory {
	return []MonitorCategory{AvailabilityHealth, Configuration, EntityHealth, PerformanceHealth, Security}
}

// MonitorState enumerates the values for monitor state.
type MonitorState string

const (
	// MonitorStateDisabled ...
	MonitorStateDisabled MonitorState = "Disabled"
	// MonitorStateEnabled ...
	MonitorStateEnabled MonitorState = "Enabled"
)

// PossibleMonitorStateValues returns an array of possible values for the MonitorState const type.
func PossibleMonitorStateValues() []MonitorState {
	return []MonitorState{MonitorStateDisabled, MonitorStateEnabled}
}

// MonitorType enumerates the values for monitor type.
type MonitorType string

const (
	// Aggregate ...
	Aggregate MonitorType = "Aggregate"
	// Dependency ...
	Dependency MonitorType = "Dependency"
	// Unit ...
	Unit MonitorType = "Unit"
)

// PossibleMonitorTypeValues returns an array of possible values for the MonitorType const type.
func PossibleMonitorTypeValues() []MonitorType {
	return []MonitorType{Aggregate, Dependency, Unit}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// Equals ...
	Equals Operator = "Equals"
	// GreaterThan ...
	GreaterThan Operator = "GreaterThan"
	// GreaterThanOrEqual ...
	GreaterThanOrEqual Operator = "GreaterThanOrEqual"
	// LessThan ...
	LessThan Operator = "LessThan"
	// LessThanOrEqual ...
	LessThanOrEqual Operator = "LessThanOrEqual"
	// NotEquals ...
	NotEquals Operator = "NotEquals"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{Equals, GreaterThan, GreaterThanOrEqual, LessThan, LessThanOrEqual, NotEquals}
}

// WorkloadType enumerates the values for workload type.
type WorkloadType string

const (
	// Apache ...
	Apache WorkloadType = "Apache"
	// BaseOS ...
	BaseOS WorkloadType = "BaseOS"
	// IIS ...
	IIS WorkloadType = "IIS"
	// SQL ...
	SQL WorkloadType = "SQL"
)

// PossibleWorkloadTypeValues returns an array of possible values for the WorkloadType const type.
func PossibleWorkloadTypeValues() []WorkloadType {
	return []WorkloadType{Apache, BaseOS, IIS, SQL}
}
