package compute

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessLevel enumerates the values for access level.
type AccessLevel string

const (
	// AccessLevelNone ...
	AccessLevelNone AccessLevel = "None"
	// AccessLevelRead ...
	AccessLevelRead AccessLevel = "Read"
	// AccessLevelWrite ...
	AccessLevelWrite AccessLevel = "Write"
)

// PossibleAccessLevelValues returns an array of possible values for the AccessLevel const type.
func PossibleAccessLevelValues() []AccessLevel {
	return []AccessLevel{AccessLevelNone, AccessLevelRead, AccessLevelWrite}
}

// AggregatedReplicationState enumerates the values for aggregated replication state.
type AggregatedReplicationState string

const (
	// AggregatedReplicationStateCompleted ...
	AggregatedReplicationStateCompleted AggregatedReplicationState = "Completed"
	// AggregatedReplicationStateFailed ...
	AggregatedReplicationStateFailed AggregatedReplicationState = "Failed"
	// AggregatedReplicationStateInProgress ...
	AggregatedReplicationStateInProgress AggregatedReplicationState = "InProgress"
	// AggregatedReplicationStateUnknown ...
	AggregatedReplicationStateUnknown AggregatedReplicationState = "Unknown"
)

// PossibleAggregatedReplicationStateValues returns an array of possible values for the AggregatedReplicationState const type.
func PossibleAggregatedReplicationStateValues() []AggregatedReplicationState {
	return []AggregatedReplicationState{AggregatedReplicationStateCompleted, AggregatedReplicationStateFailed, AggregatedReplicationStateInProgress, AggregatedReplicationStateUnknown}
}

// AvailabilitySetSkuTypes enumerates the values for availability set sku types.
type AvailabilitySetSkuTypes string

const (
	// AvailabilitySetSkuTypesAligned ...
	AvailabilitySetSkuTypesAligned AvailabilitySetSkuTypes = "Aligned"
	// AvailabilitySetSkuTypesClassic ...
	AvailabilitySetSkuTypesClassic AvailabilitySetSkuTypes = "Classic"
)

// PossibleAvailabilitySetSkuTypesValues returns an array of possible values for the AvailabilitySetSkuTypes const type.
func PossibleAvailabilitySetSkuTypesValues() []AvailabilitySetSkuTypes {
	return []AvailabilitySetSkuTypes{AvailabilitySetSkuTypesAligned, AvailabilitySetSkuTypesClassic}
}

// CachingTypes enumerates the values for caching types.
type CachingTypes string

const (
	// CachingTypesNone ...
	CachingTypesNone CachingTypes = "None"
	// CachingTypesReadOnly ...
	CachingTypesReadOnly CachingTypes = "ReadOnly"
	// CachingTypesReadWrite ...
	CachingTypesReadWrite CachingTypes = "ReadWrite"
)

// PossibleCachingTypesValues returns an array of possible values for the CachingTypes const type.
func PossibleCachingTypesValues() []CachingTypes {
	return []CachingTypes{CachingTypesNone, CachingTypesReadOnly, CachingTypesReadWrite}
}

// CapacityReservationGroupInstanceViewTypes enumerates the values for capacity reservation group instance view
// types.
type CapacityReservationGroupInstanceViewTypes string

const (
	// CapacityReservationGroupInstanceViewTypesInstanceView ...
	CapacityReservationGroupInstanceViewTypesInstanceView CapacityReservationGroupInstanceViewTypes = "instanceView"
)

// PossibleCapacityReservationGroupInstanceViewTypesValues returns an array of possible values for the CapacityReservationGroupInstanceViewTypes const type.
func PossibleCapacityReservationGroupInstanceViewTypesValues() []CapacityReservationGroupInstanceViewTypes {
	return []CapacityReservationGroupInstanceViewTypes{CapacityReservationGroupInstanceViewTypesInstanceView}
}

// CapacityReservationInstanceViewTypes enumerates the values for capacity reservation instance view types.
type CapacityReservationInstanceViewTypes string

const (
	// CapacityReservationInstanceViewTypesInstanceView ...
	CapacityReservationInstanceViewTypesInstanceView CapacityReservationInstanceViewTypes = "instanceView"
)

// PossibleCapacityReservationInstanceViewTypesValues returns an array of possible values for the CapacityReservationInstanceViewTypes const type.
func PossibleCapacityReservationInstanceViewTypesValues() []CapacityReservationInstanceViewTypes {
	return []CapacityReservationInstanceViewTypes{CapacityReservationInstanceViewTypesInstanceView}
}

// CloudServiceUpgradeMode enumerates the values for cloud service upgrade mode.
type CloudServiceUpgradeMode string

const (
	// CloudServiceUpgradeModeAuto ...
	CloudServiceUpgradeModeAuto CloudServiceUpgradeMode = "Auto"
	// CloudServiceUpgradeModeManual ...
	CloudServiceUpgradeModeManual CloudServiceUpgradeMode = "Manual"
	// CloudServiceUpgradeModeSimultaneous ...
	CloudServiceUpgradeModeSimultaneous CloudServiceUpgradeMode = "Simultaneous"
)

// PossibleCloudServiceUpgradeModeValues returns an array of possible values for the CloudServiceUpgradeMode const type.
func PossibleCloudServiceUpgradeModeValues() []CloudServiceUpgradeMode {
	return []CloudServiceUpgradeMode{CloudServiceUpgradeModeAuto, CloudServiceUpgradeModeManual, CloudServiceUpgradeModeSimultaneous}
}

// ComponentNames enumerates the values for component names.
type ComponentNames string

const (
	// ComponentNamesMicrosoftWindowsShellSetup ...
	ComponentNamesMicrosoftWindowsShellSetup ComponentNames = "Microsoft-Windows-Shell-Setup"
)

// PossibleComponentNamesValues returns an array of possible values for the ComponentNames const type.
func PossibleComponentNamesValues() []ComponentNames {
	return []ComponentNames{ComponentNamesMicrosoftWindowsShellSetup}
}

// ConsistencyModeTypes enumerates the values for consistency mode types.
type ConsistencyModeTypes string

const (
	// ConsistencyModeTypesApplicationConsistent ...
	ConsistencyModeTypesApplicationConsistent ConsistencyModeTypes = "ApplicationConsistent"
	// ConsistencyModeTypesCrashConsistent ...
	ConsistencyModeTypesCrashConsistent ConsistencyModeTypes = "CrashConsistent"
	// ConsistencyModeTypesFileSystemConsistent ...
	ConsistencyModeTypesFileSystemConsistent ConsistencyModeTypes = "FileSystemConsistent"
)

// PossibleConsistencyModeTypesValues returns an array of possible values for the ConsistencyModeTypes const type.
func PossibleConsistencyModeTypesValues() []ConsistencyModeTypes {
	return []ConsistencyModeTypes{ConsistencyModeTypesApplicationConsistent, ConsistencyModeTypesCrashConsistent, ConsistencyModeTypesFileSystemConsistent}
}

// DedicatedHostLicenseTypes enumerates the values for dedicated host license types.
type DedicatedHostLicenseTypes string

const (
	// DedicatedHostLicenseTypesNone ...
	DedicatedHostLicenseTypesNone DedicatedHostLicenseTypes = "None"
	// DedicatedHostLicenseTypesWindowsServerHybrid ...
	DedicatedHostLicenseTypesWindowsServerHybrid DedicatedHostLicenseTypes = "Windows_Server_Hybrid"
	// DedicatedHostLicenseTypesWindowsServerPerpetual ...
	DedicatedHostLicenseTypesWindowsServerPerpetual DedicatedHostLicenseTypes = "Windows_Server_Perpetual"
)

// PossibleDedicatedHostLicenseTypesValues returns an array of possible values for the DedicatedHostLicenseTypes const type.
func PossibleDedicatedHostLicenseTypesValues() []DedicatedHostLicenseTypes {
	return []DedicatedHostLicenseTypes{DedicatedHostLicenseTypesNone, DedicatedHostLicenseTypesWindowsServerHybrid, DedicatedHostLicenseTypesWindowsServerPerpetual}
}

// DeleteOptions enumerates the values for delete options.
type DeleteOptions string

const (
	// DeleteOptionsDelete ...
	DeleteOptionsDelete DeleteOptions = "Delete"
	// DeleteOptionsDetach ...
	DeleteOptionsDetach DeleteOptions = "Detach"
)

// PossibleDeleteOptionsValues returns an array of possible values for the DeleteOptions const type.
func PossibleDeleteOptionsValues() []DeleteOptions {
	return []DeleteOptions{DeleteOptionsDelete, DeleteOptionsDetach}
}

// DiffDiskOptions enumerates the values for diff disk options.
type DiffDiskOptions string

const (
	// DiffDiskOptionsLocal ...
	DiffDiskOptionsLocal DiffDiskOptions = "Local"
)

// PossibleDiffDiskOptionsValues returns an array of possible values for the DiffDiskOptions const type.
func PossibleDiffDiskOptionsValues() []DiffDiskOptions {
	return []DiffDiskOptions{DiffDiskOptionsLocal}
}

// DiffDiskPlacement enumerates the values for diff disk placement.
type DiffDiskPlacement string

const (
	// DiffDiskPlacementCacheDisk ...
	DiffDiskPlacementCacheDisk DiffDiskPlacement = "CacheDisk"
	// DiffDiskPlacementResourceDisk ...
	DiffDiskPlacementResourceDisk DiffDiskPlacement = "ResourceDisk"
)

// PossibleDiffDiskPlacementValues returns an array of possible values for the DiffDiskPlacement const type.
func PossibleDiffDiskPlacementValues() []DiffDiskPlacement {
	return []DiffDiskPlacement{DiffDiskPlacementCacheDisk, DiffDiskPlacementResourceDisk}
}

// DiskCreateOption enumerates the values for disk create option.
type DiskCreateOption string

const (
	// DiskCreateOptionAttach Disk will be attached to a VM.
	DiskCreateOptionAttach DiskCreateOption = "Attach"
	// DiskCreateOptionCopy Create a new disk or snapshot by copying from a disk or snapshot specified by the
	// given sourceResourceId.
	DiskCreateOptionCopy DiskCreateOption = "Copy"
	// DiskCreateOptionCopyStart Create a new disk by using a deep copy process, where the resource creation is
	// considered complete only after all data has been copied from the source.
	DiskCreateOptionCopyStart DiskCreateOption = "CopyStart"
	// DiskCreateOptionEmpty Create an empty data disk of a size given by diskSizeGB.
	DiskCreateOptionEmpty DiskCreateOption = "Empty"
	// DiskCreateOptionFromImage Create a new disk from a platform image specified by the given imageReference
	// or galleryImageReference.
	DiskCreateOptionFromImage DiskCreateOption = "FromImage"
	// DiskCreateOptionImport Create a disk by importing from a blob specified by a sourceUri in a storage
	// account specified by storageAccountId.
	DiskCreateOptionImport DiskCreateOption = "Import"
	// DiskCreateOptionImportSecure Similar to Import create option. Create a new Trusted Launch VM or
	// Confidential VM supported disk by importing additional blob for VM guest state specified by
	// securityDataUri in storage account specified by storageAccountId
	DiskCreateOptionImportSecure DiskCreateOption = "ImportSecure"
	// DiskCreateOptionRestore Create a new disk by copying from a backup recovery point.
	DiskCreateOptionRestore DiskCreateOption = "Restore"
	// DiskCreateOptionUpload Create a new disk by obtaining a write token and using it to directly upload the
	// contents of the disk.
	DiskCreateOptionUpload DiskCreateOption = "Upload"
	// DiskCreateOptionUploadPreparedSecure Similar to Upload create option. Create a new Trusted Launch VM or
	// Confidential VM supported disk and upload using write token in both disk and VM guest state
	DiskCreateOptionUploadPreparedSecure DiskCreateOption = "UploadPreparedSecure"
)

// PossibleDiskCreateOptionValues returns an array of possible values for the DiskCreateOption const type.
func PossibleDiskCreateOptionValues() []DiskCreateOption {
	return []DiskCreateOption{DiskCreateOptionAttach, DiskCreateOptionCopy, DiskCreateOptionCopyStart, DiskCreateOptionEmpty, DiskCreateOptionFromImage, DiskCreateOptionImport, DiskCreateOptionImportSecure, DiskCreateOptionRestore, DiskCreateOptionUpload, DiskCreateOptionUploadPreparedSecure}
}

// DiskCreateOptionTypes enumerates the values for disk create option types.
type DiskCreateOptionTypes string

const (
	// DiskCreateOptionTypesAttach ...
	DiskCreateOptionTypesAttach DiskCreateOptionTypes = "Attach"
	// DiskCreateOptionTypesEmpty ...
	DiskCreateOptionTypesEmpty DiskCreateOptionTypes = "Empty"
	// DiskCreateOptionTypesFromImage ...
	DiskCreateOptionTypesFromImage DiskCreateOptionTypes = "FromImage"
)

// PossibleDiskCreateOptionTypesValues returns an array of possible values for the DiskCreateOptionTypes const type.
func PossibleDiskCreateOptionTypesValues() []DiskCreateOptionTypes {
	return []DiskCreateOptionTypes{DiskCreateOptionTypesAttach, DiskCreateOptionTypesEmpty, DiskCreateOptionTypesFromImage}
}

// DiskDeleteOptionTypes enumerates the values for disk delete option types.
type DiskDeleteOptionTypes string

const (
	// DiskDeleteOptionTypesDelete ...
	DiskDeleteOptionTypesDelete DiskDeleteOptionTypes = "Delete"
	// DiskDeleteOptionTypesDetach ...
	DiskDeleteOptionTypesDetach DiskDeleteOptionTypes = "Detach"
)

// PossibleDiskDeleteOptionTypesValues returns an array of possible values for the DiskDeleteOptionTypes const type.
func PossibleDiskDeleteOptionTypesValues() []DiskDeleteOptionTypes {
	return []DiskDeleteOptionTypes{DiskDeleteOptionTypesDelete, DiskDeleteOptionTypesDetach}
}

// DiskDetachOptionTypes enumerates the values for disk detach option types.
type DiskDetachOptionTypes string

const (
	// DiskDetachOptionTypesForceDetach ...
	DiskDetachOptionTypesForceDetach DiskDetachOptionTypes = "ForceDetach"
)

// PossibleDiskDetachOptionTypesValues returns an array of possible values for the DiskDetachOptionTypes const type.
func PossibleDiskDetachOptionTypesValues() []DiskDetachOptionTypes {
	return []DiskDetachOptionTypes{DiskDetachOptionTypesForceDetach}
}

// DiskEncryptionSetIdentityType enumerates the values for disk encryption set identity type.
type DiskEncryptionSetIdentityType string

const (
	// DiskEncryptionSetIdentityTypeNone ...
	DiskEncryptionSetIdentityTypeNone DiskEncryptionSetIdentityType = "None"
	// DiskEncryptionSetIdentityTypeSystemAssigned ...
	DiskEncryptionSetIdentityTypeSystemAssigned DiskEncryptionSetIdentityType = "SystemAssigned"
)

// PossibleDiskEncryptionSetIdentityTypeValues returns an array of possible values for the DiskEncryptionSetIdentityType const type.
func PossibleDiskEncryptionSetIdentityTypeValues() []DiskEncryptionSetIdentityType {
	return []DiskEncryptionSetIdentityType{DiskEncryptionSetIdentityTypeNone, DiskEncryptionSetIdentityTypeSystemAssigned}
}

// DiskEncryptionSetType enumerates the values for disk encryption set type.
type DiskEncryptionSetType string

const (
	// DiskEncryptionSetTypeConfidentialVMEncryptedWithCustomerKey Confidential VM supported disk and VM guest
	// state would be encrypted with customer managed key.
	DiskEncryptionSetTypeConfidentialVMEncryptedWithCustomerKey DiskEncryptionSetType = "ConfidentialVmEncryptedWithCustomerKey"
	// DiskEncryptionSetTypeEncryptionAtRestWithCustomerKey Resource using diskEncryptionSet would be encrypted
	// at rest with Customer managed key that can be changed and revoked by a customer.
	DiskEncryptionSetTypeEncryptionAtRestWithCustomerKey DiskEncryptionSetType = "EncryptionAtRestWithCustomerKey"
	// DiskEncryptionSetTypeEncryptionAtRestWithPlatformAndCustomerKeys Resource using diskEncryptionSet would
	// be encrypted at rest with two layers of encryption. One of the keys is Customer managed and the other
	// key is Platform managed.
	DiskEncryptionSetTypeEncryptionAtRestWithPlatformAndCustomerKeys DiskEncryptionSetType = "EncryptionAtRestWithPlatformAndCustomerKeys"
)

// PossibleDiskEncryptionSetTypeValues returns an array of possible values for the DiskEncryptionSetType const type.
func PossibleDiskEncryptionSetTypeValues() []DiskEncryptionSetType {
	return []DiskEncryptionSetType{DiskEncryptionSetTypeConfidentialVMEncryptedWithCustomerKey, DiskEncryptionSetTypeEncryptionAtRestWithCustomerKey, DiskEncryptionSetTypeEncryptionAtRestWithPlatformAndCustomerKeys}
}

// DiskSecurityTypes enumerates the values for disk security types.
type DiskSecurityTypes string

const (
	// DiskSecurityTypesConfidentialVMDiskEncryptedWithCustomerKey Indicates Confidential VM disk with both OS
	// disk and VM guest state encrypted with a customer managed key
	DiskSecurityTypesConfidentialVMDiskEncryptedWithCustomerKey DiskSecurityTypes = "ConfidentialVM_DiskEncryptedWithCustomerKey"
	// DiskSecurityTypesConfidentialVMDiskEncryptedWithPlatformKey Indicates Confidential VM disk with both OS
	// disk and VM guest state encrypted with a platform managed key
	DiskSecurityTypesConfidentialVMDiskEncryptedWithPlatformKey DiskSecurityTypes = "ConfidentialVM_DiskEncryptedWithPlatformKey"
	// DiskSecurityTypesConfidentialVMVMGuestStateOnlyEncryptedWithPlatformKey Indicates Confidential VM disk
	// with only VM guest state encrypted
	DiskSecurityTypesConfidentialVMVMGuestStateOnlyEncryptedWithPlatformKey DiskSecurityTypes = "ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey"
	// DiskSecurityTypesTrustedLaunch Trusted Launch provides security features such as secure boot and virtual
	// Trusted Platform Module (vTPM)
	DiskSecurityTypesTrustedLaunch DiskSecurityTypes = "TrustedLaunch"
)

// PossibleDiskSecurityTypesValues returns an array of possible values for the DiskSecurityTypes const type.
func PossibleDiskSecurityTypesValues() []DiskSecurityTypes {
	return []DiskSecurityTypes{DiskSecurityTypesConfidentialVMDiskEncryptedWithCustomerKey, DiskSecurityTypesConfidentialVMDiskEncryptedWithPlatformKey, DiskSecurityTypesConfidentialVMVMGuestStateOnlyEncryptedWithPlatformKey, DiskSecurityTypesTrustedLaunch}
}

// DiskState enumerates the values for disk state.
type DiskState string

const (
	// DiskStateActiveSAS The disk currently has an Active SAS Uri associated with it.
	DiskStateActiveSAS DiskState = "ActiveSAS"
	// DiskStateActiveSASFrozen The disk is attached to a VM in hibernated state and has an active SAS URI
	// associated with it.
	DiskStateActiveSASFrozen DiskState = "ActiveSASFrozen"
	// DiskStateActiveUpload A disk is created for upload and a write token has been issued for uploading to
	// it.
	DiskStateActiveUpload DiskState = "ActiveUpload"
	// DiskStateAttached The disk is currently attached to a running VM.
	DiskStateAttached DiskState = "Attached"
	// DiskStateFrozen The disk is attached to a VM which is in hibernated state.
	DiskStateFrozen DiskState = "Frozen"
	// DiskStateReadyToUpload A disk is ready to be created by upload by requesting a write token.
	DiskStateReadyToUpload DiskState = "ReadyToUpload"
	// DiskStateReserved The disk is attached to a stopped-deallocated VM.
	DiskStateReserved DiskState = "Reserved"
	// DiskStateUnattached The disk is not being used and can be attached to a VM.
	DiskStateUnattached DiskState = "Unattached"
)

// PossibleDiskStateValues returns an array of possible values for the DiskState const type.
func PossibleDiskStateValues() []DiskState {
	return []DiskState{DiskStateActiveSAS, DiskStateActiveSASFrozen, DiskStateActiveUpload, DiskStateAttached, DiskStateFrozen, DiskStateReadyToUpload, DiskStateReserved, DiskStateUnattached}
}

// DiskStorageAccountTypes enumerates the values for disk storage account types.
type DiskStorageAccountTypes string

const (
	// DiskStorageAccountTypesPremiumLRS Premium SSD locally redundant storage. Best for production and
	// performance sensitive workloads.
	DiskStorageAccountTypesPremiumLRS DiskStorageAccountTypes = "Premium_LRS"
	// DiskStorageAccountTypesPremiumZRS Premium SSD zone redundant storage. Best for the production workloads
	// that need storage resiliency against zone failures.
	DiskStorageAccountTypesPremiumZRS DiskStorageAccountTypes = "Premium_ZRS"
	// DiskStorageAccountTypesStandardLRS Standard HDD locally redundant storage. Best for backup,
	// non-critical, and infrequent access.
	DiskStorageAccountTypesStandardLRS DiskStorageAccountTypes = "Standard_LRS"
	// DiskStorageAccountTypesStandardSSDLRS Standard SSD locally redundant storage. Best for web servers,
	// lightly used enterprise applications and dev/test.
	DiskStorageAccountTypesStandardSSDLRS DiskStorageAccountTypes = "StandardSSD_LRS"
	// DiskStorageAccountTypesStandardSSDZRS Standard SSD zone redundant storage. Best for web servers, lightly
	// used enterprise applications and dev/test that need storage resiliency against zone failures.
	DiskStorageAccountTypesStandardSSDZRS DiskStorageAccountTypes = "StandardSSD_ZRS"
	// DiskStorageAccountTypesUltraSSDLRS Ultra SSD locally redundant storage. Best for IO-intensive workloads
	// such as SAP HANA, top tier databases (for example, SQL, Oracle), and other transaction-heavy workloads.
	DiskStorageAccountTypesUltraSSDLRS DiskStorageAccountTypes = "UltraSSD_LRS"
)

// PossibleDiskStorageAccountTypesValues returns an array of possible values for the DiskStorageAccountTypes const type.
func PossibleDiskStorageAccountTypesValues() []DiskStorageAccountTypes {
	return []DiskStorageAccountTypes{DiskStorageAccountTypesPremiumLRS, DiskStorageAccountTypesPremiumZRS, DiskStorageAccountTypesStandardLRS, DiskStorageAccountTypesStandardSSDLRS, DiskStorageAccountTypesStandardSSDZRS, DiskStorageAccountTypesUltraSSDLRS}
}

// EncryptionType enumerates the values for encryption type.
type EncryptionType string

const (
	// EncryptionTypeEncryptionAtRestWithCustomerKey Disk is encrypted at rest with Customer managed key that
	// can be changed and revoked by a customer.
	EncryptionTypeEncryptionAtRestWithCustomerKey EncryptionType = "EncryptionAtRestWithCustomerKey"
	// EncryptionTypeEncryptionAtRestWithPlatformAndCustomerKeys Disk is encrypted at rest with 2 layers of
	// encryption. One of the keys is Customer managed and the other key is Platform managed.
	EncryptionTypeEncryptionAtRestWithPlatformAndCustomerKeys EncryptionType = "EncryptionAtRestWithPlatformAndCustomerKeys"
	// EncryptionTypeEncryptionAtRestWithPlatformKey Disk is encrypted at rest with Platform managed key. It is
	// the default encryption type. This is not a valid encryption type for disk encryption sets.
	EncryptionTypeEncryptionAtRestWithPlatformKey EncryptionType = "EncryptionAtRestWithPlatformKey"
)

// PossibleEncryptionTypeValues returns an array of possible values for the EncryptionType const type.
func PossibleEncryptionTypeValues() []EncryptionType {
	return []EncryptionType{EncryptionTypeEncryptionAtRestWithCustomerKey, EncryptionTypeEncryptionAtRestWithPlatformAndCustomerKeys, EncryptionTypeEncryptionAtRestWithPlatformKey}
}

// ExecutionState enumerates the values for execution state.
type ExecutionState string

const (
	// ExecutionStateCanceled ...
	ExecutionStateCanceled ExecutionState = "Canceled"
	// ExecutionStateFailed ...
	ExecutionStateFailed ExecutionState = "Failed"
	// ExecutionStatePending ...
	ExecutionStatePending ExecutionState = "Pending"
	// ExecutionStateRunning ...
	ExecutionStateRunning ExecutionState = "Running"
	// ExecutionStateSucceeded ...
	ExecutionStateSucceeded ExecutionState = "Succeeded"
	// ExecutionStateTimedOut ...
	ExecutionStateTimedOut ExecutionState = "TimedOut"
	// ExecutionStateUnknown ...
	ExecutionStateUnknown ExecutionState = "Unknown"
)

// PossibleExecutionStateValues returns an array of possible values for the ExecutionState const type.
func PossibleExecutionStateValues() []ExecutionState {
	return []ExecutionState{ExecutionStateCanceled, ExecutionStateFailed, ExecutionStatePending, ExecutionStateRunning, ExecutionStateSucceeded, ExecutionStateTimedOut, ExecutionStateUnknown}
}

// ExpandTypesForGetCapacityReservationGroups enumerates the values for expand types for get capacity
// reservation groups.
type ExpandTypesForGetCapacityReservationGroups string

const (
	// ExpandTypesForGetCapacityReservationGroupsVirtualMachineScaleSetVMsref ...
	ExpandTypesForGetCapacityReservationGroupsVirtualMachineScaleSetVMsref ExpandTypesForGetCapacityReservationGroups = "virtualMachineScaleSetVMs/$ref"
	// ExpandTypesForGetCapacityReservationGroupsVirtualMachinesref ...
	ExpandTypesForGetCapacityReservationGroupsVirtualMachinesref ExpandTypesForGetCapacityReservationGroups = "virtualMachines/$ref"
)

// PossibleExpandTypesForGetCapacityReservationGroupsValues returns an array of possible values for the ExpandTypesForGetCapacityReservationGroups const type.
func PossibleExpandTypesForGetCapacityReservationGroupsValues() []ExpandTypesForGetCapacityReservationGroups {
	return []ExpandTypesForGetCapacityReservationGroups{ExpandTypesForGetCapacityReservationGroupsVirtualMachineScaleSetVMsref, ExpandTypesForGetCapacityReservationGroupsVirtualMachinesref}
}

// ExpandTypesForGetVMScaleSets enumerates the values for expand types for get vm scale sets.
type ExpandTypesForGetVMScaleSets string

const (
	// ExpandTypesForGetVMScaleSetsUserData ...
	ExpandTypesForGetVMScaleSetsUserData ExpandTypesForGetVMScaleSets = "userData"
)

// PossibleExpandTypesForGetVMScaleSetsValues returns an array of possible values for the ExpandTypesForGetVMScaleSets const type.
func PossibleExpandTypesForGetVMScaleSetsValues() []ExpandTypesForGetVMScaleSets {
	return []ExpandTypesForGetVMScaleSets{ExpandTypesForGetVMScaleSetsUserData}
}

// ExtendedLocationType enumerates the values for extended location type.
type ExtendedLocationType string

const (
	// ExtendedLocationTypeEdgeZone ...
	ExtendedLocationTypeEdgeZone ExtendedLocationType = "EdgeZone"
)

// PossibleExtendedLocationTypeValues returns an array of possible values for the ExtendedLocationType const type.
func PossibleExtendedLocationTypeValues() []ExtendedLocationType {
	return []ExtendedLocationType{ExtendedLocationTypeEdgeZone}
}

// ExtendedLocationTypes enumerates the values for extended location types.
type ExtendedLocationTypes string

const (
	// ExtendedLocationTypesEdgeZone ...
	ExtendedLocationTypesEdgeZone ExtendedLocationTypes = "EdgeZone"
)

// PossibleExtendedLocationTypesValues returns an array of possible values for the ExtendedLocationTypes const type.
func PossibleExtendedLocationTypesValues() []ExtendedLocationTypes {
	return []ExtendedLocationTypes{ExtendedLocationTypesEdgeZone}
}

// GallerySharingPermissionTypes enumerates the values for gallery sharing permission types.
type GallerySharingPermissionTypes string

const (
	// GallerySharingPermissionTypesGroups ...
	GallerySharingPermissionTypesGroups GallerySharingPermissionTypes = "Groups"
	// GallerySharingPermissionTypesPrivate ...
	GallerySharingPermissionTypesPrivate GallerySharingPermissionTypes = "Private"
)

// PossibleGallerySharingPermissionTypesValues returns an array of possible values for the GallerySharingPermissionTypes const type.
func PossibleGallerySharingPermissionTypesValues() []GallerySharingPermissionTypes {
	return []GallerySharingPermissionTypes{GallerySharingPermissionTypesGroups, GallerySharingPermissionTypesPrivate}
}

// HostCaching enumerates the values for host caching.
type HostCaching string

const (
	// HostCachingNone ...
	HostCachingNone HostCaching = "None"
	// HostCachingReadOnly ...
	HostCachingReadOnly HostCaching = "ReadOnly"
	// HostCachingReadWrite ...
	HostCachingReadWrite HostCaching = "ReadWrite"
)

// PossibleHostCachingValues returns an array of possible values for the HostCaching const type.
func PossibleHostCachingValues() []HostCaching {
	return []HostCaching{HostCachingNone, HostCachingReadOnly, HostCachingReadWrite}
}

// HyperVGeneration enumerates the values for hyper v generation.
type HyperVGeneration string

const (
	// HyperVGenerationV1 ...
	HyperVGenerationV1 HyperVGeneration = "V1"
	// HyperVGenerationV2 ...
	HyperVGenerationV2 HyperVGeneration = "V2"
)

// PossibleHyperVGenerationValues returns an array of possible values for the HyperVGeneration const type.
func PossibleHyperVGenerationValues() []HyperVGeneration {
	return []HyperVGeneration{HyperVGenerationV1, HyperVGenerationV2}
}

// HyperVGenerationType enumerates the values for hyper v generation type.
type HyperVGenerationType string

const (
	// HyperVGenerationTypeV1 ...
	HyperVGenerationTypeV1 HyperVGenerationType = "V1"
	// HyperVGenerationTypeV2 ...
	HyperVGenerationTypeV2 HyperVGenerationType = "V2"
)

// PossibleHyperVGenerationTypeValues returns an array of possible values for the HyperVGenerationType const type.
func PossibleHyperVGenerationTypeValues() []HyperVGenerationType {
	return []HyperVGenerationType{HyperVGenerationTypeV1, HyperVGenerationTypeV2}
}

// HyperVGenerationTypes enumerates the values for hyper v generation types.
type HyperVGenerationTypes string

const (
	// HyperVGenerationTypesV1 ...
	HyperVGenerationTypesV1 HyperVGenerationTypes = "V1"
	// HyperVGenerationTypesV2 ...
	HyperVGenerationTypesV2 HyperVGenerationTypes = "V2"
)

// PossibleHyperVGenerationTypesValues returns an array of possible values for the HyperVGenerationTypes const type.
func PossibleHyperVGenerationTypesValues() []HyperVGenerationTypes {
	return []HyperVGenerationTypes{HyperVGenerationTypesV1, HyperVGenerationTypesV2}
}

// InstanceViewTypes enumerates the values for instance view types.
type InstanceViewTypes string

const (
	// InstanceViewTypesInstanceView ...
	InstanceViewTypesInstanceView InstanceViewTypes = "instanceView"
	// InstanceViewTypesUserData ...
	InstanceViewTypesUserData InstanceViewTypes = "userData"
)

// PossibleInstanceViewTypesValues returns an array of possible values for the InstanceViewTypes const type.
func PossibleInstanceViewTypesValues() []InstanceViewTypes {
	return []InstanceViewTypes{InstanceViewTypesInstanceView, InstanceViewTypesUserData}
}

// IntervalInMins enumerates the values for interval in mins.
type IntervalInMins string

const (
	// IntervalInMinsFiveMins ...
	IntervalInMinsFiveMins IntervalInMins = "FiveMins"
	// IntervalInMinsSixtyMins ...
	IntervalInMinsSixtyMins IntervalInMins = "SixtyMins"
	// IntervalInMinsThirtyMins ...
	IntervalInMinsThirtyMins IntervalInMins = "ThirtyMins"
	// IntervalInMinsThreeMins ...
	IntervalInMinsThreeMins IntervalInMins = "ThreeMins"
)

// PossibleIntervalInMinsValues returns an array of possible values for the IntervalInMins const type.
func PossibleIntervalInMinsValues() []IntervalInMins {
	return []IntervalInMins{IntervalInMinsFiveMins, IntervalInMinsSixtyMins, IntervalInMinsThirtyMins, IntervalInMinsThreeMins}
}

// IPVersion enumerates the values for ip version.
type IPVersion string

const (
	// IPVersionIPv4 ...
	IPVersionIPv4 IPVersion = "IPv4"
	// IPVersionIPv6 ...
	IPVersionIPv6 IPVersion = "IPv6"
)

// PossibleIPVersionValues returns an array of possible values for the IPVersion const type.
func PossibleIPVersionValues() []IPVersion {
	return []IPVersion{IPVersionIPv4, IPVersionIPv6}
}

// IPVersions enumerates the values for ip versions.
type IPVersions string

const (
	// IPVersionsIPv4 ...
	IPVersionsIPv4 IPVersions = "IPv4"
	// IPVersionsIPv6 ...
	IPVersionsIPv6 IPVersions = "IPv6"
)

// PossibleIPVersionsValues returns an array of possible values for the IPVersions const type.
func PossibleIPVersionsValues() []IPVersions {
	return []IPVersions{IPVersionsIPv4, IPVersionsIPv6}
}

// LinuxPatchAssessmentMode enumerates the values for linux patch assessment mode.
type LinuxPatchAssessmentMode string

const (
	// LinuxPatchAssessmentModeAutomaticByPlatform ...
	LinuxPatchAssessmentModeAutomaticByPlatform LinuxPatchAssessmentMode = "AutomaticByPlatform"
	// LinuxPatchAssessmentModeImageDefault ...
	LinuxPatchAssessmentModeImageDefault LinuxPatchAssessmentMode = "ImageDefault"
)

// PossibleLinuxPatchAssessmentModeValues returns an array of possible values for the LinuxPatchAssessmentMode const type.
func PossibleLinuxPatchAssessmentModeValues() []LinuxPatchAssessmentMode {
	return []LinuxPatchAssessmentMode{LinuxPatchAssessmentModeAutomaticByPlatform, LinuxPatchAssessmentModeImageDefault}
}

// LinuxVMGuestPatchMode enumerates the values for linux vm guest patch mode.
type LinuxVMGuestPatchMode string

const (
	// LinuxVMGuestPatchModeAutomaticByPlatform ...
	LinuxVMGuestPatchModeAutomaticByPlatform LinuxVMGuestPatchMode = "AutomaticByPlatform"
	// LinuxVMGuestPatchModeImageDefault ...
	LinuxVMGuestPatchModeImageDefault LinuxVMGuestPatchMode = "ImageDefault"
)

// PossibleLinuxVMGuestPatchModeValues returns an array of possible values for the LinuxVMGuestPatchMode const type.
func PossibleLinuxVMGuestPatchModeValues() []LinuxVMGuestPatchMode {
	return []LinuxVMGuestPatchMode{LinuxVMGuestPatchModeAutomaticByPlatform, LinuxVMGuestPatchModeImageDefault}
}

// MaintenanceOperationResultCodeTypes enumerates the values for maintenance operation result code types.
type MaintenanceOperationResultCodeTypes string

const (
	// MaintenanceOperationResultCodeTypesMaintenanceAborted ...
	MaintenanceOperationResultCodeTypesMaintenanceAborted MaintenanceOperationResultCodeTypes = "MaintenanceAborted"
	// MaintenanceOperationResultCodeTypesMaintenanceCompleted ...
	MaintenanceOperationResultCodeTypesMaintenanceCompleted MaintenanceOperationResultCodeTypes = "MaintenanceCompleted"
	// MaintenanceOperationResultCodeTypesNone ...
	MaintenanceOperationResultCodeTypesNone MaintenanceOperationResultCodeTypes = "None"
	// MaintenanceOperationResultCodeTypesRetryLater ...
	MaintenanceOperationResultCodeTypesRetryLater MaintenanceOperationResultCodeTypes = "RetryLater"
)

// PossibleMaintenanceOperationResultCodeTypesValues returns an array of possible values for the MaintenanceOperationResultCodeTypes const type.
func PossibleMaintenanceOperationResultCodeTypesValues() []MaintenanceOperationResultCodeTypes {
	return []MaintenanceOperationResultCodeTypes{MaintenanceOperationResultCodeTypesMaintenanceAborted, MaintenanceOperationResultCodeTypesMaintenanceCompleted, MaintenanceOperationResultCodeTypesNone, MaintenanceOperationResultCodeTypesRetryLater}
}

// NetworkAccessPolicy enumerates the values for network access policy.
type NetworkAccessPolicy string

const (
	// NetworkAccessPolicyAllowAll The disk can be exported or uploaded to from any network.
	NetworkAccessPolicyAllowAll NetworkAccessPolicy = "AllowAll"
	// NetworkAccessPolicyAllowPrivate The disk can be exported or uploaded to using a DiskAccess resource's
	// private endpoints.
	NetworkAccessPolicyAllowPrivate NetworkAccessPolicy = "AllowPrivate"
	// NetworkAccessPolicyDenyAll The disk cannot be exported.
	NetworkAccessPolicyDenyAll NetworkAccessPolicy = "DenyAll"
)

// PossibleNetworkAccessPolicyValues returns an array of possible values for the NetworkAccessPolicy const type.
func PossibleNetworkAccessPolicyValues() []NetworkAccessPolicy {
	return []NetworkAccessPolicy{NetworkAccessPolicyAllowAll, NetworkAccessPolicyAllowPrivate, NetworkAccessPolicyDenyAll}
}

// NetworkAPIVersion enumerates the values for network api version.
type NetworkAPIVersion string

const (
	// NetworkAPIVersionTwoZeroTwoZeroHyphenMinusOneOneHyphenMinusZeroOne ...
	NetworkAPIVersionTwoZeroTwoZeroHyphenMinusOneOneHyphenMinusZeroOne NetworkAPIVersion = "2020-11-01"
)

// PossibleNetworkAPIVersionValues returns an array of possible values for the NetworkAPIVersion const type.
func PossibleNetworkAPIVersionValues() []NetworkAPIVersion {
	return []NetworkAPIVersion{NetworkAPIVersionTwoZeroTwoZeroHyphenMinusOneOneHyphenMinusZeroOne}
}

// OperatingSystemStateTypes enumerates the values for operating system state types.
type OperatingSystemStateTypes string

const (
	// OperatingSystemStateTypesGeneralized Generalized image. Needs to be provisioned during deployment time.
	OperatingSystemStateTypesGeneralized OperatingSystemStateTypes = "Generalized"
	// OperatingSystemStateTypesSpecialized Specialized image. Contains already provisioned OS Disk.
	OperatingSystemStateTypesSpecialized OperatingSystemStateTypes = "Specialized"
)

// PossibleOperatingSystemStateTypesValues returns an array of possible values for the OperatingSystemStateTypes const type.
func PossibleOperatingSystemStateTypesValues() []OperatingSystemStateTypes {
	return []OperatingSystemStateTypes{OperatingSystemStateTypesGeneralized, OperatingSystemStateTypesSpecialized}
}

// OperatingSystemType enumerates the values for operating system type.
type OperatingSystemType string

const (
	// OperatingSystemTypeLinux ...
	OperatingSystemTypeLinux OperatingSystemType = "Linux"
	// OperatingSystemTypeWindows ...
	OperatingSystemTypeWindows OperatingSystemType = "Windows"
)

// PossibleOperatingSystemTypeValues returns an array of possible values for the OperatingSystemType const type.
func PossibleOperatingSystemTypeValues() []OperatingSystemType {
	return []OperatingSystemType{OperatingSystemTypeLinux, OperatingSystemTypeWindows}
}

// OperatingSystemTypes enumerates the values for operating system types.
type OperatingSystemTypes string

const (
	// OperatingSystemTypesLinux ...
	OperatingSystemTypesLinux OperatingSystemTypes = "Linux"
	// OperatingSystemTypesWindows ...
	OperatingSystemTypesWindows OperatingSystemTypes = "Windows"
)

// PossibleOperatingSystemTypesValues returns an array of possible values for the OperatingSystemTypes const type.
func PossibleOperatingSystemTypesValues() []OperatingSystemTypes {
	return []OperatingSystemTypes{OperatingSystemTypesLinux, OperatingSystemTypesWindows}
}

// OrchestrationMode enumerates the values for orchestration mode.
type OrchestrationMode string

const (
	// OrchestrationModeFlexible ...
	OrchestrationModeFlexible OrchestrationMode = "Flexible"
	// OrchestrationModeUniform ...
	OrchestrationModeUniform OrchestrationMode = "Uniform"
)

// PossibleOrchestrationModeValues returns an array of possible values for the OrchestrationMode const type.
func PossibleOrchestrationModeValues() []OrchestrationMode {
	return []OrchestrationMode{OrchestrationModeFlexible, OrchestrationModeUniform}
}

// OrchestrationServiceNames enumerates the values for orchestration service names.
type OrchestrationServiceNames string

const (
	// OrchestrationServiceNamesAutomaticRepairs ...
	OrchestrationServiceNamesAutomaticRepairs OrchestrationServiceNames = "AutomaticRepairs"
)

// PossibleOrchestrationServiceNamesValues returns an array of possible values for the OrchestrationServiceNames const type.
func PossibleOrchestrationServiceNamesValues() []OrchestrationServiceNames {
	return []OrchestrationServiceNames{OrchestrationServiceNamesAutomaticRepairs}
}

// OrchestrationServiceState enumerates the values for orchestration service state.
type OrchestrationServiceState string

const (
	// OrchestrationServiceStateNotRunning ...
	OrchestrationServiceStateNotRunning OrchestrationServiceState = "NotRunning"
	// OrchestrationServiceStateRunning ...
	OrchestrationServiceStateRunning OrchestrationServiceState = "Running"
	// OrchestrationServiceStateSuspended ...
	OrchestrationServiceStateSuspended OrchestrationServiceState = "Suspended"
)

// PossibleOrchestrationServiceStateValues returns an array of possible values for the OrchestrationServiceState const type.
func PossibleOrchestrationServiceStateValues() []OrchestrationServiceState {
	return []OrchestrationServiceState{OrchestrationServiceStateNotRunning, OrchestrationServiceStateRunning, OrchestrationServiceStateSuspended}
}

// OrchestrationServiceStateAction enumerates the values for orchestration service state action.
type OrchestrationServiceStateAction string

const (
	// OrchestrationServiceStateActionResume ...
	OrchestrationServiceStateActionResume OrchestrationServiceStateAction = "Resume"
	// OrchestrationServiceStateActionSuspend ...
	OrchestrationServiceStateActionSuspend OrchestrationServiceStateAction = "Suspend"
)

// PossibleOrchestrationServiceStateActionValues returns an array of possible values for the OrchestrationServiceStateAction const type.
func PossibleOrchestrationServiceStateActionValues() []OrchestrationServiceStateAction {
	return []OrchestrationServiceStateAction{OrchestrationServiceStateActionResume, OrchestrationServiceStateActionSuspend}
}

// PassNames enumerates the values for pass names.
type PassNames string

const (
	// PassNamesOobeSystem ...
	PassNamesOobeSystem PassNames = "OobeSystem"
)

// PossiblePassNamesValues returns an array of possible values for the PassNames const type.
func PossiblePassNamesValues() []PassNames {
	return []PassNames{PassNamesOobeSystem}
}

// PatchAssessmentState enumerates the values for patch assessment state.
type PatchAssessmentState string

const (
	// PatchAssessmentStateAvailable ...
	PatchAssessmentStateAvailable PatchAssessmentState = "Available"
	// PatchAssessmentStateUnknown ...
	PatchAssessmentStateUnknown PatchAssessmentState = "Unknown"
)

// PossiblePatchAssessmentStateValues returns an array of possible values for the PatchAssessmentState const type.
func PossiblePatchAssessmentStateValues() []PatchAssessmentState {
	return []PatchAssessmentState{PatchAssessmentStateAvailable, PatchAssessmentStateUnknown}
}

// PatchInstallationState enumerates the values for patch installation state.
type PatchInstallationState string

const (
	// PatchInstallationStateExcluded ...
	PatchInstallationStateExcluded PatchInstallationState = "Excluded"
	// PatchInstallationStateFailed ...
	PatchInstallationStateFailed PatchInstallationState = "Failed"
	// PatchInstallationStateInstalled ...
	PatchInstallationStateInstalled PatchInstallationState = "Installed"
	// PatchInstallationStateNotSelected ...
	PatchInstallationStateNotSelected PatchInstallationState = "NotSelected"
	// PatchInstallationStatePending ...
	PatchInstallationStatePending PatchInstallationState = "Pending"
	// PatchInstallationStateUnknown ...
	PatchInstallationStateUnknown PatchInstallationState = "Unknown"
)

// PossiblePatchInstallationStateValues returns an array of possible values for the PatchInstallationState const type.
func PossiblePatchInstallationStateValues() []PatchInstallationState {
	return []PatchInstallationState{PatchInstallationStateExcluded, PatchInstallationStateFailed, PatchInstallationStateInstalled, PatchInstallationStateNotSelected, PatchInstallationStatePending, PatchInstallationStateUnknown}
}

// PatchOperationStatus enumerates the values for patch operation status.
type PatchOperationStatus string

const (
	// PatchOperationStatusCompletedWithWarnings ...
	PatchOperationStatusCompletedWithWarnings PatchOperationStatus = "CompletedWithWarnings"
	// PatchOperationStatusFailed ...
	PatchOperationStatusFailed PatchOperationStatus = "Failed"
	// PatchOperationStatusInProgress ...
	PatchOperationStatusInProgress PatchOperationStatus = "InProgress"
	// PatchOperationStatusSucceeded ...
	PatchOperationStatusSucceeded PatchOperationStatus = "Succeeded"
	// PatchOperationStatusUnknown ...
	PatchOperationStatusUnknown PatchOperationStatus = "Unknown"
)

// PossiblePatchOperationStatusValues returns an array of possible values for the PatchOperationStatus const type.
func PossiblePatchOperationStatusValues() []PatchOperationStatus {
	return []PatchOperationStatus{PatchOperationStatusCompletedWithWarnings, PatchOperationStatusFailed, PatchOperationStatusInProgress, PatchOperationStatusSucceeded, PatchOperationStatusUnknown}
}

// PrivateEndpointConnectionProvisioningState enumerates the values for private endpoint connection
// provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	// PrivateEndpointConnectionProvisioningStateCreating ...
	PrivateEndpointConnectionProvisioningStateCreating PrivateEndpointConnectionProvisioningState = "Creating"
	// PrivateEndpointConnectionProvisioningStateDeleting ...
	PrivateEndpointConnectionProvisioningStateDeleting PrivateEndpointConnectionProvisioningState = "Deleting"
	// PrivateEndpointConnectionProvisioningStateFailed ...
	PrivateEndpointConnectionProvisioningStateFailed PrivateEndpointConnectionProvisioningState = "Failed"
	// PrivateEndpointConnectionProvisioningStateSucceeded ...
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns an array of possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{PrivateEndpointConnectionProvisioningStateCreating, PrivateEndpointConnectionProvisioningStateDeleting, PrivateEndpointConnectionProvisioningStateFailed, PrivateEndpointConnectionProvisioningStateSucceeded}
}

// PrivateEndpointServiceConnectionStatus enumerates the values for private endpoint service connection status.
type PrivateEndpointServiceConnectionStatus string

const (
	// PrivateEndpointServiceConnectionStatusApproved ...
	PrivateEndpointServiceConnectionStatusApproved PrivateEndpointServiceConnectionStatus = "Approved"
	// PrivateEndpointServiceConnectionStatusPending ...
	PrivateEndpointServiceConnectionStatusPending PrivateEndpointServiceConnectionStatus = "Pending"
	// PrivateEndpointServiceConnectionStatusRejected ...
	PrivateEndpointServiceConnectionStatusRejected PrivateEndpointServiceConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointServiceConnectionStatusValues returns an array of possible values for the PrivateEndpointServiceConnectionStatus const type.
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return []PrivateEndpointServiceConnectionStatus{PrivateEndpointServiceConnectionStatusApproved, PrivateEndpointServiceConnectionStatusPending, PrivateEndpointServiceConnectionStatusRejected}
}

// ProtocolTypes enumerates the values for protocol types.
type ProtocolTypes string

const (
	// ProtocolTypesHTTP ...
	ProtocolTypesHTTP ProtocolTypes = "Http"
	// ProtocolTypesHTTPS ...
	ProtocolTypesHTTPS ProtocolTypes = "Https"
)

// PossibleProtocolTypesValues returns an array of possible values for the ProtocolTypes const type.
func PossibleProtocolTypesValues() []ProtocolTypes {
	return []ProtocolTypes{ProtocolTypesHTTP, ProtocolTypesHTTPS}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateMigrating ...
	ProvisioningStateMigrating ProvisioningState = "Migrating"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateMigrating, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// ProvisioningState1 enumerates the values for provisioning state 1.
type ProvisioningState1 string

const (
	// ProvisioningState1Creating ...
	ProvisioningState1Creating ProvisioningState1 = "Creating"
	// ProvisioningState1Deleting ...
	ProvisioningState1Deleting ProvisioningState1 = "Deleting"
	// ProvisioningState1Failed ...
	ProvisioningState1Failed ProvisioningState1 = "Failed"
	// ProvisioningState1Migrating ...
	ProvisioningState1Migrating ProvisioningState1 = "Migrating"
	// ProvisioningState1Succeeded ...
	ProvisioningState1Succeeded ProvisioningState1 = "Succeeded"
	// ProvisioningState1Updating ...
	ProvisioningState1Updating ProvisioningState1 = "Updating"
)

// PossibleProvisioningState1Values returns an array of possible values for the ProvisioningState1 const type.
func PossibleProvisioningState1Values() []ProvisioningState1 {
	return []ProvisioningState1{ProvisioningState1Creating, ProvisioningState1Deleting, ProvisioningState1Failed, ProvisioningState1Migrating, ProvisioningState1Succeeded, ProvisioningState1Updating}
}

// ProvisioningState2 enumerates the values for provisioning state 2.
type ProvisioningState2 string

const (
	// ProvisioningState2Creating ...
	ProvisioningState2Creating ProvisioningState2 = "Creating"
	// ProvisioningState2Deleting ...
	ProvisioningState2Deleting ProvisioningState2 = "Deleting"
	// ProvisioningState2Failed ...
	ProvisioningState2Failed ProvisioningState2 = "Failed"
	// ProvisioningState2Migrating ...
	ProvisioningState2Migrating ProvisioningState2 = "Migrating"
	// ProvisioningState2Succeeded ...
	ProvisioningState2Succeeded ProvisioningState2 = "Succeeded"
	// ProvisioningState2Updating ...
	ProvisioningState2Updating ProvisioningState2 = "Updating"
)

// PossibleProvisioningState2Values returns an array of possible values for the ProvisioningState2 const type.
func PossibleProvisioningState2Values() []ProvisioningState2 {
	return []ProvisioningState2{ProvisioningState2Creating, ProvisioningState2Deleting, ProvisioningState2Failed, ProvisioningState2Migrating, ProvisioningState2Succeeded, ProvisioningState2Updating}
}

// ProvisioningState3 enumerates the values for provisioning state 3.
type ProvisioningState3 string

const (
	// ProvisioningState3Creating ...
	ProvisioningState3Creating ProvisioningState3 = "Creating"
	// ProvisioningState3Deleting ...
	ProvisioningState3Deleting ProvisioningState3 = "Deleting"
	// ProvisioningState3Failed ...
	ProvisioningState3Failed ProvisioningState3 = "Failed"
	// ProvisioningState3Migrating ...
	ProvisioningState3Migrating ProvisioningState3 = "Migrating"
	// ProvisioningState3Succeeded ...
	ProvisioningState3Succeeded ProvisioningState3 = "Succeeded"
	// ProvisioningState3Updating ...
	ProvisioningState3Updating ProvisioningState3 = "Updating"
)

// PossibleProvisioningState3Values returns an array of possible values for the ProvisioningState3 const type.
func PossibleProvisioningState3Values() []ProvisioningState3 {
	return []ProvisioningState3{ProvisioningState3Creating, ProvisioningState3Deleting, ProvisioningState3Failed, ProvisioningState3Migrating, ProvisioningState3Succeeded, ProvisioningState3Updating}
}

// ProximityPlacementGroupType enumerates the values for proximity placement group type.
type ProximityPlacementGroupType string

const (
	// ProximityPlacementGroupTypeStandard ...
	ProximityPlacementGroupTypeStandard ProximityPlacementGroupType = "Standard"
	// ProximityPlacementGroupTypeUltra ...
	ProximityPlacementGroupTypeUltra ProximityPlacementGroupType = "Ultra"
)

// PossibleProximityPlacementGroupTypeValues returns an array of possible values for the ProximityPlacementGroupType const type.
func PossibleProximityPlacementGroupTypeValues() []ProximityPlacementGroupType {
	return []ProximityPlacementGroupType{ProximityPlacementGroupTypeStandard, ProximityPlacementGroupTypeUltra}
}

// PublicIPAddressSkuName enumerates the values for public ip address sku name.
type PublicIPAddressSkuName string

const (
	// PublicIPAddressSkuNameBasic ...
	PublicIPAddressSkuNameBasic PublicIPAddressSkuName = "Basic"
	// PublicIPAddressSkuNameStandard ...
	PublicIPAddressSkuNameStandard PublicIPAddressSkuName = "Standard"
)

// PossiblePublicIPAddressSkuNameValues returns an array of possible values for the PublicIPAddressSkuName const type.
func PossiblePublicIPAddressSkuNameValues() []PublicIPAddressSkuName {
	return []PublicIPAddressSkuName{PublicIPAddressSkuNameBasic, PublicIPAddressSkuNameStandard}
}

// PublicIPAddressSkuTier enumerates the values for public ip address sku tier.
type PublicIPAddressSkuTier string

const (
	// PublicIPAddressSkuTierGlobal ...
	PublicIPAddressSkuTierGlobal PublicIPAddressSkuTier = "Global"
	// PublicIPAddressSkuTierRegional ...
	PublicIPAddressSkuTierRegional PublicIPAddressSkuTier = "Regional"
)

// PossiblePublicIPAddressSkuTierValues returns an array of possible values for the PublicIPAddressSkuTier const type.
func PossiblePublicIPAddressSkuTierValues() []PublicIPAddressSkuTier {
	return []PublicIPAddressSkuTier{PublicIPAddressSkuTierGlobal, PublicIPAddressSkuTierRegional}
}

// PublicIPAllocationMethod enumerates the values for public ip allocation method.
type PublicIPAllocationMethod string

const (
	// PublicIPAllocationMethodDynamic ...
	PublicIPAllocationMethodDynamic PublicIPAllocationMethod = "Dynamic"
	// PublicIPAllocationMethodStatic ...
	PublicIPAllocationMethodStatic PublicIPAllocationMethod = "Static"
)

// PossiblePublicIPAllocationMethodValues returns an array of possible values for the PublicIPAllocationMethod const type.
func PossiblePublicIPAllocationMethodValues() []PublicIPAllocationMethod {
	return []PublicIPAllocationMethod{PublicIPAllocationMethodDynamic, PublicIPAllocationMethodStatic}
}

// PublicNetworkAccess enumerates the values for public network access.
type PublicNetworkAccess string

const (
	// PublicNetworkAccessDisabled You cannot access the underlying data of the disk publicly on the internet
	// even when NetworkAccessPolicy is set to AllowAll. You can access the data via the SAS URI only from your
	// trusted Azure VNET when NetworkAccessPolicy is set to AllowPrivate.
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	// PublicNetworkAccessEnabled You can generate a SAS URI to access the underlying data of the disk publicly
	// on the internet when NetworkAccessPolicy is set to AllowAll. You can access the data via the SAS URI
	// only from your trusted Azure VNET when NetworkAccessPolicy is set to AllowPrivate.
	PublicNetworkAccessEnabled PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns an array of possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{PublicNetworkAccessDisabled, PublicNetworkAccessEnabled}
}

// RepairAction enumerates the values for repair action.
type RepairAction string

const (
	// RepairActionReimage ...
	RepairActionReimage RepairAction = "Reimage"
	// RepairActionReplace ...
	RepairActionReplace RepairAction = "Replace"
	// RepairActionRestart ...
	RepairActionRestart RepairAction = "Restart"
)

// PossibleRepairActionValues returns an array of possible values for the RepairAction const type.
func PossibleRepairActionValues() []RepairAction {
	return []RepairAction{RepairActionReimage, RepairActionReplace, RepairActionRestart}
}

// ReplicationMode enumerates the values for replication mode.
type ReplicationMode string

const (
	// ReplicationModeFull ...
	ReplicationModeFull ReplicationMode = "Full"
	// ReplicationModeShallow ...
	ReplicationModeShallow ReplicationMode = "Shallow"
)

// PossibleReplicationModeValues returns an array of possible values for the ReplicationMode const type.
func PossibleReplicationModeValues() []ReplicationMode {
	return []ReplicationMode{ReplicationModeFull, ReplicationModeShallow}
}

// ReplicationState enumerates the values for replication state.
type ReplicationState string

const (
	// ReplicationStateCompleted ...
	ReplicationStateCompleted ReplicationState = "Completed"
	// ReplicationStateFailed ...
	ReplicationStateFailed ReplicationState = "Failed"
	// ReplicationStateReplicating ...
	ReplicationStateReplicating ReplicationState = "Replicating"
	// ReplicationStateUnknown ...
	ReplicationStateUnknown ReplicationState = "Unknown"
)

// PossibleReplicationStateValues returns an array of possible values for the ReplicationState const type.
func PossibleReplicationStateValues() []ReplicationState {
	return []ReplicationState{ReplicationStateCompleted, ReplicationStateFailed, ReplicationStateReplicating, ReplicationStateUnknown}
}

// ReplicationStatusTypes enumerates the values for replication status types.
type ReplicationStatusTypes string

const (
	// ReplicationStatusTypesReplicationStatus ...
	ReplicationStatusTypesReplicationStatus ReplicationStatusTypes = "ReplicationStatus"
)

// PossibleReplicationStatusTypesValues returns an array of possible values for the ReplicationStatusTypes const type.
func PossibleReplicationStatusTypesValues() []ReplicationStatusTypes {
	return []ReplicationStatusTypes{ReplicationStatusTypesReplicationStatus}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
	// ResourceIdentityTypeSystemAssignedUserAssigned ...
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned, UserAssigned"
	// ResourceIdentityTypeUserAssigned ...
	ResourceIdentityTypeUserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned, ResourceIdentityTypeSystemAssignedUserAssigned, ResourceIdentityTypeUserAssigned}
}

// ResourceSkuCapacityScaleType enumerates the values for resource sku capacity scale type.
type ResourceSkuCapacityScaleType string

const (
	// ResourceSkuCapacityScaleTypeAutomatic ...
	ResourceSkuCapacityScaleTypeAutomatic ResourceSkuCapacityScaleType = "Automatic"
	// ResourceSkuCapacityScaleTypeManual ...
	ResourceSkuCapacityScaleTypeManual ResourceSkuCapacityScaleType = "Manual"
	// ResourceSkuCapacityScaleTypeNone ...
	ResourceSkuCapacityScaleTypeNone ResourceSkuCapacityScaleType = "None"
)

// PossibleResourceSkuCapacityScaleTypeValues returns an array of possible values for the ResourceSkuCapacityScaleType const type.
func PossibleResourceSkuCapacityScaleTypeValues() []ResourceSkuCapacityScaleType {
	return []ResourceSkuCapacityScaleType{ResourceSkuCapacityScaleTypeAutomatic, ResourceSkuCapacityScaleTypeManual, ResourceSkuCapacityScaleTypeNone}
}

// ResourceSkuRestrictionsReasonCode enumerates the values for resource sku restrictions reason code.
type ResourceSkuRestrictionsReasonCode string

const (
	// ResourceSkuRestrictionsReasonCodeNotAvailableForSubscription ...
	ResourceSkuRestrictionsReasonCodeNotAvailableForSubscription ResourceSkuRestrictionsReasonCode = "NotAvailableForSubscription"
	// ResourceSkuRestrictionsReasonCodeQuotaID ...
	ResourceSkuRestrictionsReasonCodeQuotaID ResourceSkuRestrictionsReasonCode = "QuotaId"
)

// PossibleResourceSkuRestrictionsReasonCodeValues returns an array of possible values for the ResourceSkuRestrictionsReasonCode const type.
func PossibleResourceSkuRestrictionsReasonCodeValues() []ResourceSkuRestrictionsReasonCode {
	return []ResourceSkuRestrictionsReasonCode{ResourceSkuRestrictionsReasonCodeNotAvailableForSubscription, ResourceSkuRestrictionsReasonCodeQuotaID}
}

// ResourceSkuRestrictionsType enumerates the values for resource sku restrictions type.
type ResourceSkuRestrictionsType string

const (
	// ResourceSkuRestrictionsTypeLocation ...
	ResourceSkuRestrictionsTypeLocation ResourceSkuRestrictionsType = "Location"
	// ResourceSkuRestrictionsTypeZone ...
	ResourceSkuRestrictionsTypeZone ResourceSkuRestrictionsType = "Zone"
)

// PossibleResourceSkuRestrictionsTypeValues returns an array of possible values for the ResourceSkuRestrictionsType const type.
func PossibleResourceSkuRestrictionsTypeValues() []ResourceSkuRestrictionsType {
	return []ResourceSkuRestrictionsType{ResourceSkuRestrictionsTypeLocation, ResourceSkuRestrictionsTypeZone}
}

// RestorePointCollectionExpandOptions enumerates the values for restore point collection expand options.
type RestorePointCollectionExpandOptions string

const (
	// RestorePointCollectionExpandOptionsRestorePoints ...
	RestorePointCollectionExpandOptionsRestorePoints RestorePointCollectionExpandOptions = "restorePoints"
)

// PossibleRestorePointCollectionExpandOptionsValues returns an array of possible values for the RestorePointCollectionExpandOptions const type.
func PossibleRestorePointCollectionExpandOptionsValues() []RestorePointCollectionExpandOptions {
	return []RestorePointCollectionExpandOptions{RestorePointCollectionExpandOptionsRestorePoints}
}

// RestorePointExpandOptions enumerates the values for restore point expand options.
type RestorePointExpandOptions string

const (
	// RestorePointExpandOptionsInstanceView ...
	RestorePointExpandOptionsInstanceView RestorePointExpandOptions = "instanceView"
)

// PossibleRestorePointExpandOptionsValues returns an array of possible values for the RestorePointExpandOptions const type.
func PossibleRestorePointExpandOptionsValues() []RestorePointExpandOptions {
	return []RestorePointExpandOptions{RestorePointExpandOptionsInstanceView}
}

// RollingUpgradeActionType enumerates the values for rolling upgrade action type.
type RollingUpgradeActionType string

const (
	// RollingUpgradeActionTypeCancel ...
	RollingUpgradeActionTypeCancel RollingUpgradeActionType = "Cancel"
	// RollingUpgradeActionTypeStart ...
	RollingUpgradeActionTypeStart RollingUpgradeActionType = "Start"
)

// PossibleRollingUpgradeActionTypeValues returns an array of possible values for the RollingUpgradeActionType const type.
func PossibleRollingUpgradeActionTypeValues() []RollingUpgradeActionType {
	return []RollingUpgradeActionType{RollingUpgradeActionTypeCancel, RollingUpgradeActionTypeStart}
}

// RollingUpgradeStatusCode enumerates the values for rolling upgrade status code.
type RollingUpgradeStatusCode string

const (
	// RollingUpgradeStatusCodeCancelled ...
	RollingUpgradeStatusCodeCancelled RollingUpgradeStatusCode = "Cancelled"
	// RollingUpgradeStatusCodeCompleted ...
	RollingUpgradeStatusCodeCompleted RollingUpgradeStatusCode = "Completed"
	// RollingUpgradeStatusCodeFaulted ...
	RollingUpgradeStatusCodeFaulted RollingUpgradeStatusCode = "Faulted"
	// RollingUpgradeStatusCodeRollingForward ...
	RollingUpgradeStatusCodeRollingForward RollingUpgradeStatusCode = "RollingForward"
)

// PossibleRollingUpgradeStatusCodeValues returns an array of possible values for the RollingUpgradeStatusCode const type.
func PossibleRollingUpgradeStatusCodeValues() []RollingUpgradeStatusCode {
	return []RollingUpgradeStatusCode{RollingUpgradeStatusCodeCancelled, RollingUpgradeStatusCodeCompleted, RollingUpgradeStatusCodeFaulted, RollingUpgradeStatusCodeRollingForward}
}

// SecurityEncryptionTypes enumerates the values for security encryption types.
type SecurityEncryptionTypes string

const (
	// SecurityEncryptionTypesDiskWithVMGuestState ...
	SecurityEncryptionTypesDiskWithVMGuestState SecurityEncryptionTypes = "DiskWithVMGuestState"
	// SecurityEncryptionTypesVMGuestStateOnly ...
	SecurityEncryptionTypesVMGuestStateOnly SecurityEncryptionTypes = "VMGuestStateOnly"
)

// PossibleSecurityEncryptionTypesValues returns an array of possible values for the SecurityEncryptionTypes const type.
func PossibleSecurityEncryptionTypesValues() []SecurityEncryptionTypes {
	return []SecurityEncryptionTypes{SecurityEncryptionTypesDiskWithVMGuestState, SecurityEncryptionTypesVMGuestStateOnly}
}

// SecurityTypes enumerates the values for security types.
type SecurityTypes string

const (
	// SecurityTypesConfidentialVM ...
	SecurityTypesConfidentialVM SecurityTypes = "ConfidentialVM"
	// SecurityTypesTrustedLaunch ...
	SecurityTypesTrustedLaunch SecurityTypes = "TrustedLaunch"
)

// PossibleSecurityTypesValues returns an array of possible values for the SecurityTypes const type.
func PossibleSecurityTypesValues() []SecurityTypes {
	return []SecurityTypes{SecurityTypesConfidentialVM, SecurityTypesTrustedLaunch}
}

// SelectPermissions enumerates the values for select permissions.
type SelectPermissions string

const (
	// SelectPermissionsPermissions ...
	SelectPermissionsPermissions SelectPermissions = "Permissions"
)

// PossibleSelectPermissionsValues returns an array of possible values for the SelectPermissions const type.
func PossibleSelectPermissionsValues() []SelectPermissions {
	return []SelectPermissions{SelectPermissionsPermissions}
}

// SettingNames enumerates the values for setting names.
type SettingNames string

const (
	// SettingNamesAutoLogon ...
	SettingNamesAutoLogon SettingNames = "AutoLogon"
	// SettingNamesFirstLogonCommands ...
	SettingNamesFirstLogonCommands SettingNames = "FirstLogonCommands"
)

// PossibleSettingNamesValues returns an array of possible values for the SettingNames const type.
func PossibleSettingNamesValues() []SettingNames {
	return []SettingNames{SettingNamesAutoLogon, SettingNamesFirstLogonCommands}
}

// SharedToValues enumerates the values for shared to values.
type SharedToValues string

const (
	// SharedToValuesTenant ...
	SharedToValuesTenant SharedToValues = "tenant"
)

// PossibleSharedToValuesValues returns an array of possible values for the SharedToValues const type.
func PossibleSharedToValuesValues() []SharedToValues {
	return []SharedToValues{SharedToValuesTenant}
}

// SharingProfileGroupTypes enumerates the values for sharing profile group types.
type SharingProfileGroupTypes string

const (
	// SharingProfileGroupTypesAADTenants ...
	SharingProfileGroupTypesAADTenants SharingProfileGroupTypes = "AADTenants"
	// SharingProfileGroupTypesSubscriptions ...
	SharingProfileGroupTypesSubscriptions SharingProfileGroupTypes = "Subscriptions"
)

// PossibleSharingProfileGroupTypesValues returns an array of possible values for the SharingProfileGroupTypes const type.
func PossibleSharingProfileGroupTypesValues() []SharingProfileGroupTypes {
	return []SharingProfileGroupTypes{SharingProfileGroupTypesAADTenants, SharingProfileGroupTypesSubscriptions}
}

// SharingUpdateOperationTypes enumerates the values for sharing update operation types.
type SharingUpdateOperationTypes string

const (
	// SharingUpdateOperationTypesAdd ...
	SharingUpdateOperationTypesAdd SharingUpdateOperationTypes = "Add"
	// SharingUpdateOperationTypesRemove ...
	SharingUpdateOperationTypesRemove SharingUpdateOperationTypes = "Remove"
	// SharingUpdateOperationTypesReset ...
	SharingUpdateOperationTypesReset SharingUpdateOperationTypes = "Reset"
)

// PossibleSharingUpdateOperationTypesValues returns an array of possible values for the SharingUpdateOperationTypes const type.
func PossibleSharingUpdateOperationTypesValues() []SharingUpdateOperationTypes {
	return []SharingUpdateOperationTypes{SharingUpdateOperationTypesAdd, SharingUpdateOperationTypesRemove, SharingUpdateOperationTypesReset}
}

// SnapshotStorageAccountTypes enumerates the values for snapshot storage account types.
type SnapshotStorageAccountTypes string

const (
	// SnapshotStorageAccountTypesPremiumLRS Premium SSD locally redundant storage
	SnapshotStorageAccountTypesPremiumLRS SnapshotStorageAccountTypes = "Premium_LRS"
	// SnapshotStorageAccountTypesStandardLRS Standard HDD locally redundant storage
	SnapshotStorageAccountTypesStandardLRS SnapshotStorageAccountTypes = "Standard_LRS"
	// SnapshotStorageAccountTypesStandardZRS Standard zone redundant storage
	SnapshotStorageAccountTypesStandardZRS SnapshotStorageAccountTypes = "Standard_ZRS"
)

// PossibleSnapshotStorageAccountTypesValues returns an array of possible values for the SnapshotStorageAccountTypes const type.
func PossibleSnapshotStorageAccountTypesValues() []SnapshotStorageAccountTypes {
	return []SnapshotStorageAccountTypes{SnapshotStorageAccountTypesPremiumLRS, SnapshotStorageAccountTypesStandardLRS, SnapshotStorageAccountTypesStandardZRS}
}

// StatusLevelTypes enumerates the values for status level types.
type StatusLevelTypes string

const (
	// StatusLevelTypesError ...
	StatusLevelTypesError StatusLevelTypes = "Error"
	// StatusLevelTypesInfo ...
	StatusLevelTypesInfo StatusLevelTypes = "Info"
	// StatusLevelTypesWarning ...
	StatusLevelTypesWarning StatusLevelTypes = "Warning"
)

// PossibleStatusLevelTypesValues returns an array of possible values for the StatusLevelTypes const type.
func PossibleStatusLevelTypesValues() []StatusLevelTypes {
	return []StatusLevelTypes{StatusLevelTypesError, StatusLevelTypesInfo, StatusLevelTypesWarning}
}

// StorageAccountType enumerates the values for storage account type.
type StorageAccountType string

const (
	// StorageAccountTypePremiumLRS ...
	StorageAccountTypePremiumLRS StorageAccountType = "Premium_LRS"
	// StorageAccountTypeStandardLRS ...
	StorageAccountTypeStandardLRS StorageAccountType = "Standard_LRS"
	// StorageAccountTypeStandardZRS ...
	StorageAccountTypeStandardZRS StorageAccountType = "Standard_ZRS"
)

// PossibleStorageAccountTypeValues returns an array of possible values for the StorageAccountType const type.
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return []StorageAccountType{StorageAccountTypePremiumLRS, StorageAccountTypeStandardLRS, StorageAccountTypeStandardZRS}
}

// StorageAccountTypes enumerates the values for storage account types.
type StorageAccountTypes string

const (
	// StorageAccountTypesPremiumLRS ...
	StorageAccountTypesPremiumLRS StorageAccountTypes = "Premium_LRS"
	// StorageAccountTypesPremiumZRS ...
	StorageAccountTypesPremiumZRS StorageAccountTypes = "Premium_ZRS"
	// StorageAccountTypesStandardLRS ...
	StorageAccountTypesStandardLRS StorageAccountTypes = "Standard_LRS"
	// StorageAccountTypesStandardSSDLRS ...
	StorageAccountTypesStandardSSDLRS StorageAccountTypes = "StandardSSD_LRS"
	// StorageAccountTypesStandardSSDZRS ...
	StorageAccountTypesStandardSSDZRS StorageAccountTypes = "StandardSSD_ZRS"
	// StorageAccountTypesUltraSSDLRS ...
	StorageAccountTypesUltraSSDLRS StorageAccountTypes = "UltraSSD_LRS"
)

// PossibleStorageAccountTypesValues returns an array of possible values for the StorageAccountTypes const type.
func PossibleStorageAccountTypesValues() []StorageAccountTypes {
	return []StorageAccountTypes{StorageAccountTypesPremiumLRS, StorageAccountTypesPremiumZRS, StorageAccountTypesStandardLRS, StorageAccountTypesStandardSSDLRS, StorageAccountTypesStandardSSDZRS, StorageAccountTypesUltraSSDLRS}
}

// UpgradeMode enumerates the values for upgrade mode.
type UpgradeMode string

const (
	// UpgradeModeAutomatic ...
	UpgradeModeAutomatic UpgradeMode = "Automatic"
	// UpgradeModeManual ...
	UpgradeModeManual UpgradeMode = "Manual"
	// UpgradeModeRolling ...
	UpgradeModeRolling UpgradeMode = "Rolling"
)

// PossibleUpgradeModeValues returns an array of possible values for the UpgradeMode const type.
func PossibleUpgradeModeValues() []UpgradeMode {
	return []UpgradeMode{UpgradeModeAutomatic, UpgradeModeManual, UpgradeModeRolling}
}

// UpgradeOperationInvoker enumerates the values for upgrade operation invoker.
type UpgradeOperationInvoker string

const (
	// UpgradeOperationInvokerPlatform ...
	UpgradeOperationInvokerPlatform UpgradeOperationInvoker = "Platform"
	// UpgradeOperationInvokerUnknown ...
	UpgradeOperationInvokerUnknown UpgradeOperationInvoker = "Unknown"
	// UpgradeOperationInvokerUser ...
	UpgradeOperationInvokerUser UpgradeOperationInvoker = "User"
)

// PossibleUpgradeOperationInvokerValues returns an array of possible values for the UpgradeOperationInvoker const type.
func PossibleUpgradeOperationInvokerValues() []UpgradeOperationInvoker {
	return []UpgradeOperationInvoker{UpgradeOperationInvokerPlatform, UpgradeOperationInvokerUnknown, UpgradeOperationInvokerUser}
}

// UpgradeState enumerates the values for upgrade state.
type UpgradeState string

const (
	// UpgradeStateCancelled ...
	UpgradeStateCancelled UpgradeState = "Cancelled"
	// UpgradeStateCompleted ...
	UpgradeStateCompleted UpgradeState = "Completed"
	// UpgradeStateFaulted ...
	UpgradeStateFaulted UpgradeState = "Faulted"
	// UpgradeStateRollingForward ...
	UpgradeStateRollingForward UpgradeState = "RollingForward"
)

// PossibleUpgradeStateValues returns an array of possible values for the UpgradeState const type.
func PossibleUpgradeStateValues() []UpgradeState {
	return []UpgradeState{UpgradeStateCancelled, UpgradeStateCompleted, UpgradeStateFaulted, UpgradeStateRollingForward}
}

// VirtualMachineEvictionPolicyTypes enumerates the values for virtual machine eviction policy types.
type VirtualMachineEvictionPolicyTypes string

const (
	// VirtualMachineEvictionPolicyTypesDeallocate ...
	VirtualMachineEvictionPolicyTypesDeallocate VirtualMachineEvictionPolicyTypes = "Deallocate"
	// VirtualMachineEvictionPolicyTypesDelete ...
	VirtualMachineEvictionPolicyTypesDelete VirtualMachineEvictionPolicyTypes = "Delete"
)

// PossibleVirtualMachineEvictionPolicyTypesValues returns an array of possible values for the VirtualMachineEvictionPolicyTypes const type.
func PossibleVirtualMachineEvictionPolicyTypesValues() []VirtualMachineEvictionPolicyTypes {
	return []VirtualMachineEvictionPolicyTypes{VirtualMachineEvictionPolicyTypesDeallocate, VirtualMachineEvictionPolicyTypesDelete}
}

// VirtualMachinePriorityTypes enumerates the values for virtual machine priority types.
type VirtualMachinePriorityTypes string

const (
	// VirtualMachinePriorityTypesLow ...
	VirtualMachinePriorityTypesLow VirtualMachinePriorityTypes = "Low"
	// VirtualMachinePriorityTypesRegular ...
	VirtualMachinePriorityTypesRegular VirtualMachinePriorityTypes = "Regular"
	// VirtualMachinePriorityTypesSpot ...
	VirtualMachinePriorityTypesSpot VirtualMachinePriorityTypes = "Spot"
)

// PossibleVirtualMachinePriorityTypesValues returns an array of possible values for the VirtualMachinePriorityTypes const type.
func PossibleVirtualMachinePriorityTypesValues() []VirtualMachinePriorityTypes {
	return []VirtualMachinePriorityTypes{VirtualMachinePriorityTypesLow, VirtualMachinePriorityTypesRegular, VirtualMachinePriorityTypesSpot}
}

// VirtualMachineScaleSetScaleInRules enumerates the values for virtual machine scale set scale in rules.
type VirtualMachineScaleSetScaleInRules string

const (
	// VirtualMachineScaleSetScaleInRulesDefault ...
	VirtualMachineScaleSetScaleInRulesDefault VirtualMachineScaleSetScaleInRules = "Default"
	// VirtualMachineScaleSetScaleInRulesNewestVM ...
	VirtualMachineScaleSetScaleInRulesNewestVM VirtualMachineScaleSetScaleInRules = "NewestVM"
	// VirtualMachineScaleSetScaleInRulesOldestVM ...
	VirtualMachineScaleSetScaleInRulesOldestVM VirtualMachineScaleSetScaleInRules = "OldestVM"
)

// PossibleVirtualMachineScaleSetScaleInRulesValues returns an array of possible values for the VirtualMachineScaleSetScaleInRules const type.
func PossibleVirtualMachineScaleSetScaleInRulesValues() []VirtualMachineScaleSetScaleInRules {
	return []VirtualMachineScaleSetScaleInRules{VirtualMachineScaleSetScaleInRulesDefault, VirtualMachineScaleSetScaleInRulesNewestVM, VirtualMachineScaleSetScaleInRulesOldestVM}
}

// VirtualMachineScaleSetSkuScaleType enumerates the values for virtual machine scale set sku scale type.
type VirtualMachineScaleSetSkuScaleType string

const (
	// VirtualMachineScaleSetSkuScaleTypeAutomatic ...
	VirtualMachineScaleSetSkuScaleTypeAutomatic VirtualMachineScaleSetSkuScaleType = "Automatic"
	// VirtualMachineScaleSetSkuScaleTypeNone ...
	VirtualMachineScaleSetSkuScaleTypeNone VirtualMachineScaleSetSkuScaleType = "None"
)

// PossibleVirtualMachineScaleSetSkuScaleTypeValues returns an array of possible values for the VirtualMachineScaleSetSkuScaleType const type.
func PossibleVirtualMachineScaleSetSkuScaleTypeValues() []VirtualMachineScaleSetSkuScaleType {
	return []VirtualMachineScaleSetSkuScaleType{VirtualMachineScaleSetSkuScaleTypeAutomatic, VirtualMachineScaleSetSkuScaleTypeNone}
}

// VirtualMachineSizeTypes enumerates the values for virtual machine size types.
type VirtualMachineSizeTypes string

const (
	// VirtualMachineSizeTypesBasicA0 ...
	VirtualMachineSizeTypesBasicA0 VirtualMachineSizeTypes = "Basic_A0"
	// VirtualMachineSizeTypesBasicA1 ...
	VirtualMachineSizeTypesBasicA1 VirtualMachineSizeTypes = "Basic_A1"
	// VirtualMachineSizeTypesBasicA2 ...
	VirtualMachineSizeTypesBasicA2 VirtualMachineSizeTypes = "Basic_A2"
	// VirtualMachineSizeTypesBasicA3 ...
	VirtualMachineSizeTypesBasicA3 VirtualMachineSizeTypes = "Basic_A3"
	// VirtualMachineSizeTypesBasicA4 ...
	VirtualMachineSizeTypesBasicA4 VirtualMachineSizeTypes = "Basic_A4"
	// VirtualMachineSizeTypesStandardA0 ...
	VirtualMachineSizeTypesStandardA0 VirtualMachineSizeTypes = "Standard_A0"
	// VirtualMachineSizeTypesStandardA1 ...
	VirtualMachineSizeTypesStandardA1 VirtualMachineSizeTypes = "Standard_A1"
	// VirtualMachineSizeTypesStandardA10 ...
	VirtualMachineSizeTypesStandardA10 VirtualMachineSizeTypes = "Standard_A10"
	// VirtualMachineSizeTypesStandardA11 ...
	VirtualMachineSizeTypesStandardA11 VirtualMachineSizeTypes = "Standard_A11"
	// VirtualMachineSizeTypesStandardA1V2 ...
	VirtualMachineSizeTypesStandardA1V2 VirtualMachineSizeTypes = "Standard_A1_v2"
	// VirtualMachineSizeTypesStandardA2 ...
	VirtualMachineSizeTypesStandardA2 VirtualMachineSizeTypes = "Standard_A2"
	// VirtualMachineSizeTypesStandardA2mV2 ...
	VirtualMachineSizeTypesStandardA2mV2 VirtualMachineSizeTypes = "Standard_A2m_v2"
	// VirtualMachineSizeTypesStandardA2V2 ...
	VirtualMachineSizeTypesStandardA2V2 VirtualMachineSizeTypes = "Standard_A2_v2"
	// VirtualMachineSizeTypesStandardA3 ...
	VirtualMachineSizeTypesStandardA3 VirtualMachineSizeTypes = "Standard_A3"
	// VirtualMachineSizeTypesStandardA4 ...
	VirtualMachineSizeTypesStandardA4 VirtualMachineSizeTypes = "Standard_A4"
	// VirtualMachineSizeTypesStandardA4mV2 ...
	VirtualMachineSizeTypesStandardA4mV2 VirtualMachineSizeTypes = "Standard_A4m_v2"
	// VirtualMachineSizeTypesStandardA4V2 ...
	VirtualMachineSizeTypesStandardA4V2 VirtualMachineSizeTypes = "Standard_A4_v2"
	// VirtualMachineSizeTypesStandardA5 ...
	VirtualMachineSizeTypesStandardA5 VirtualMachineSizeTypes = "Standard_A5"
	// VirtualMachineSizeTypesStandardA6 ...
	VirtualMachineSizeTypesStandardA6 VirtualMachineSizeTypes = "Standard_A6"
	// VirtualMachineSizeTypesStandardA7 ...
	VirtualMachineSizeTypesStandardA7 VirtualMachineSizeTypes = "Standard_A7"
	// VirtualMachineSizeTypesStandardA8 ...
	VirtualMachineSizeTypesStandardA8 VirtualMachineSizeTypes = "Standard_A8"
	// VirtualMachineSizeTypesStandardA8mV2 ...
	VirtualMachineSizeTypesStandardA8mV2 VirtualMachineSizeTypes = "Standard_A8m_v2"
	// VirtualMachineSizeTypesStandardA8V2 ...
	VirtualMachineSizeTypesStandardA8V2 VirtualMachineSizeTypes = "Standard_A8_v2"
	// VirtualMachineSizeTypesStandardA9 ...
	VirtualMachineSizeTypesStandardA9 VirtualMachineSizeTypes = "Standard_A9"
	// VirtualMachineSizeTypesStandardB1ms ...
	VirtualMachineSizeTypesStandardB1ms VirtualMachineSizeTypes = "Standard_B1ms"
	// VirtualMachineSizeTypesStandardB1s ...
	VirtualMachineSizeTypesStandardB1s VirtualMachineSizeTypes = "Standard_B1s"
	// VirtualMachineSizeTypesStandardB2ms ...
	VirtualMachineSizeTypesStandardB2ms VirtualMachineSizeTypes = "Standard_B2ms"
	// VirtualMachineSizeTypesStandardB2s ...
	VirtualMachineSizeTypesStandardB2s VirtualMachineSizeTypes = "Standard_B2s"
	// VirtualMachineSizeTypesStandardB4ms ...
	VirtualMachineSizeTypesStandardB4ms VirtualMachineSizeTypes = "Standard_B4ms"
	// VirtualMachineSizeTypesStandardB8ms ...
	VirtualMachineSizeTypesStandardB8ms VirtualMachineSizeTypes = "Standard_B8ms"
	// VirtualMachineSizeTypesStandardD1 ...
	VirtualMachineSizeTypesStandardD1 VirtualMachineSizeTypes = "Standard_D1"
	// VirtualMachineSizeTypesStandardD11 ...
	VirtualMachineSizeTypesStandardD11 VirtualMachineSizeTypes = "Standard_D11"
	// VirtualMachineSizeTypesStandardD11V2 ...
	VirtualMachineSizeTypesStandardD11V2 VirtualMachineSizeTypes = "Standard_D11_v2"
	// VirtualMachineSizeTypesStandardD12 ...
	VirtualMachineSizeTypesStandardD12 VirtualMachineSizeTypes = "Standard_D12"
	// VirtualMachineSizeTypesStandardD12V2 ...
	VirtualMachineSizeTypesStandardD12V2 VirtualMachineSizeTypes = "Standard_D12_v2"
	// VirtualMachineSizeTypesStandardD13 ...
	VirtualMachineSizeTypesStandardD13 VirtualMachineSizeTypes = "Standard_D13"
	// VirtualMachineSizeTypesStandardD13V2 ...
	VirtualMachineSizeTypesStandardD13V2 VirtualMachineSizeTypes = "Standard_D13_v2"
	// VirtualMachineSizeTypesStandardD14 ...
	VirtualMachineSizeTypesStandardD14 VirtualMachineSizeTypes = "Standard_D14"
	// VirtualMachineSizeTypesStandardD14V2 ...
	VirtualMachineSizeTypesStandardD14V2 VirtualMachineSizeTypes = "Standard_D14_v2"
	// VirtualMachineSizeTypesStandardD15V2 ...
	VirtualMachineSizeTypesStandardD15V2 VirtualMachineSizeTypes = "Standard_D15_v2"
	// VirtualMachineSizeTypesStandardD16sV3 ...
	VirtualMachineSizeTypesStandardD16sV3 VirtualMachineSizeTypes = "Standard_D16s_v3"
	// VirtualMachineSizeTypesStandardD16V3 ...
	VirtualMachineSizeTypesStandardD16V3 VirtualMachineSizeTypes = "Standard_D16_v3"
	// VirtualMachineSizeTypesStandardD1V2 ...
	VirtualMachineSizeTypesStandardD1V2 VirtualMachineSizeTypes = "Standard_D1_v2"
	// VirtualMachineSizeTypesStandardD2 ...
	VirtualMachineSizeTypesStandardD2 VirtualMachineSizeTypes = "Standard_D2"
	// VirtualMachineSizeTypesStandardD2sV3 ...
	VirtualMachineSizeTypesStandardD2sV3 VirtualMachineSizeTypes = "Standard_D2s_v3"
	// VirtualMachineSizeTypesStandardD2V2 ...
	VirtualMachineSizeTypesStandardD2V2 VirtualMachineSizeTypes = "Standard_D2_v2"
	// VirtualMachineSizeTypesStandardD2V3 ...
	VirtualMachineSizeTypesStandardD2V3 VirtualMachineSizeTypes = "Standard_D2_v3"
	// VirtualMachineSizeTypesStandardD3 ...
	VirtualMachineSizeTypesStandardD3 VirtualMachineSizeTypes = "Standard_D3"
	// VirtualMachineSizeTypesStandardD32sV3 ...
	VirtualMachineSizeTypesStandardD32sV3 VirtualMachineSizeTypes = "Standard_D32s_v3"
	// VirtualMachineSizeTypesStandardD32V3 ...
	VirtualMachineSizeTypesStandardD32V3 VirtualMachineSizeTypes = "Standard_D32_v3"
	// VirtualMachineSizeTypesStandardD3V2 ...
	VirtualMachineSizeTypesStandardD3V2 VirtualMachineSizeTypes = "Standard_D3_v2"
	// VirtualMachineSizeTypesStandardD4 ...
	VirtualMachineSizeTypesStandardD4 VirtualMachineSizeTypes = "Standard_D4"
	// VirtualMachineSizeTypesStandardD4sV3 ...
	VirtualMachineSizeTypesStandardD4sV3 VirtualMachineSizeTypes = "Standard_D4s_v3"
	// VirtualMachineSizeTypesStandardD4V2 ...
	VirtualMachineSizeTypesStandardD4V2 VirtualMachineSizeTypes = "Standard_D4_v2"
	// VirtualMachineSizeTypesStandardD4V3 ...
	VirtualMachineSizeTypesStandardD4V3 VirtualMachineSizeTypes = "Standard_D4_v3"
	// VirtualMachineSizeTypesStandardD5V2 ...
	VirtualMachineSizeTypesStandardD5V2 VirtualMachineSizeTypes = "Standard_D5_v2"
	// VirtualMachineSizeTypesStandardD64sV3 ...
	VirtualMachineSizeTypesStandardD64sV3 VirtualMachineSizeTypes = "Standard_D64s_v3"
	// VirtualMachineSizeTypesStandardD64V3 ...
	VirtualMachineSizeTypesStandardD64V3 VirtualMachineSizeTypes = "Standard_D64_v3"
	// VirtualMachineSizeTypesStandardD8sV3 ...
	VirtualMachineSizeTypesStandardD8sV3 VirtualMachineSizeTypes = "Standard_D8s_v3"
	// VirtualMachineSizeTypesStandardD8V3 ...
	VirtualMachineSizeTypesStandardD8V3 VirtualMachineSizeTypes = "Standard_D8_v3"
	// VirtualMachineSizeTypesStandardDS1 ...
	VirtualMachineSizeTypesStandardDS1 VirtualMachineSizeTypes = "Standard_DS1"
	// VirtualMachineSizeTypesStandardDS11 ...
	VirtualMachineSizeTypesStandardDS11 VirtualMachineSizeTypes = "Standard_DS11"
	// VirtualMachineSizeTypesStandardDS11V2 ...
	VirtualMachineSizeTypesStandardDS11V2 VirtualMachineSizeTypes = "Standard_DS11_v2"
	// VirtualMachineSizeTypesStandardDS12 ...
	VirtualMachineSizeTypesStandardDS12 VirtualMachineSizeTypes = "Standard_DS12"
	// VirtualMachineSizeTypesStandardDS12V2 ...
	VirtualMachineSizeTypesStandardDS12V2 VirtualMachineSizeTypes = "Standard_DS12_v2"
	// VirtualMachineSizeTypesStandardDS13 ...
	VirtualMachineSizeTypesStandardDS13 VirtualMachineSizeTypes = "Standard_DS13"
	// VirtualMachineSizeTypesStandardDS132V2 ...
	VirtualMachineSizeTypesStandardDS132V2 VirtualMachineSizeTypes = "Standard_DS13-2_v2"
	// VirtualMachineSizeTypesStandardDS134V2 ...
	VirtualMachineSizeTypesStandardDS134V2 VirtualMachineSizeTypes = "Standard_DS13-4_v2"
	// VirtualMachineSizeTypesStandardDS13V2 ...
	VirtualMachineSizeTypesStandardDS13V2 VirtualMachineSizeTypes = "Standard_DS13_v2"
	// VirtualMachineSizeTypesStandardDS14 ...
	VirtualMachineSizeTypesStandardDS14 VirtualMachineSizeTypes = "Standard_DS14"
	// VirtualMachineSizeTypesStandardDS144V2 ...
	VirtualMachineSizeTypesStandardDS144V2 VirtualMachineSizeTypes = "Standard_DS14-4_v2"
	// VirtualMachineSizeTypesStandardDS148V2 ...
	VirtualMachineSizeTypesStandardDS148V2 VirtualMachineSizeTypes = "Standard_DS14-8_v2"
	// VirtualMachineSizeTypesStandardDS14V2 ...
	VirtualMachineSizeTypesStandardDS14V2 VirtualMachineSizeTypes = "Standard_DS14_v2"
	// VirtualMachineSizeTypesStandardDS15V2 ...
	VirtualMachineSizeTypesStandardDS15V2 VirtualMachineSizeTypes = "Standard_DS15_v2"
	// VirtualMachineSizeTypesStandardDS1V2 ...
	VirtualMachineSizeTypesStandardDS1V2 VirtualMachineSizeTypes = "Standard_DS1_v2"
	// VirtualMachineSizeTypesStandardDS2 ...
	VirtualMachineSizeTypesStandardDS2 VirtualMachineSizeTypes = "Standard_DS2"
	// VirtualMachineSizeTypesStandardDS2V2 ...
	VirtualMachineSizeTypesStandardDS2V2 VirtualMachineSizeTypes = "Standard_DS2_v2"
	// VirtualMachineSizeTypesStandardDS3 ...
	VirtualMachineSizeTypesStandardDS3 VirtualMachineSizeTypes = "Standard_DS3"
	// VirtualMachineSizeTypesStandardDS3V2 ...
	VirtualMachineSizeTypesStandardDS3V2 VirtualMachineSizeTypes = "Standard_DS3_v2"
	// VirtualMachineSizeTypesStandardDS4 ...
	VirtualMachineSizeTypesStandardDS4 VirtualMachineSizeTypes = "Standard_DS4"
	// VirtualMachineSizeTypesStandardDS4V2 ...
	VirtualMachineSizeTypesStandardDS4V2 VirtualMachineSizeTypes = "Standard_DS4_v2"
	// VirtualMachineSizeTypesStandardDS5V2 ...
	VirtualMachineSizeTypesStandardDS5V2 VirtualMachineSizeTypes = "Standard_DS5_v2"
	// VirtualMachineSizeTypesStandardE16sV3 ...
	VirtualMachineSizeTypesStandardE16sV3 VirtualMachineSizeTypes = "Standard_E16s_v3"
	// VirtualMachineSizeTypesStandardE16V3 ...
	VirtualMachineSizeTypesStandardE16V3 VirtualMachineSizeTypes = "Standard_E16_v3"
	// VirtualMachineSizeTypesStandardE2sV3 ...
	VirtualMachineSizeTypesStandardE2sV3 VirtualMachineSizeTypes = "Standard_E2s_v3"
	// VirtualMachineSizeTypesStandardE2V3 ...
	VirtualMachineSizeTypesStandardE2V3 VirtualMachineSizeTypes = "Standard_E2_v3"
	// VirtualMachineSizeTypesStandardE3216V3 ...
	VirtualMachineSizeTypesStandardE3216V3 VirtualMachineSizeTypes = "Standard_E32-16_v3"
	// VirtualMachineSizeTypesStandardE328sV3 ...
	VirtualMachineSizeTypesStandardE328sV3 VirtualMachineSizeTypes = "Standard_E32-8s_v3"
	// VirtualMachineSizeTypesStandardE32sV3 ...
	VirtualMachineSizeTypesStandardE32sV3 VirtualMachineSizeTypes = "Standard_E32s_v3"
	// VirtualMachineSizeTypesStandardE32V3 ...
	VirtualMachineSizeTypesStandardE32V3 VirtualMachineSizeTypes = "Standard_E32_v3"
	// VirtualMachineSizeTypesStandardE4sV3 ...
	VirtualMachineSizeTypesStandardE4sV3 VirtualMachineSizeTypes = "Standard_E4s_v3"
	// VirtualMachineSizeTypesStandardE4V3 ...
	VirtualMachineSizeTypesStandardE4V3 VirtualMachineSizeTypes = "Standard_E4_v3"
	// VirtualMachineSizeTypesStandardE6416sV3 ...
	VirtualMachineSizeTypesStandardE6416sV3 VirtualMachineSizeTypes = "Standard_E64-16s_v3"
	// VirtualMachineSizeTypesStandardE6432sV3 ...
	VirtualMachineSizeTypesStandardE6432sV3 VirtualMachineSizeTypes = "Standard_E64-32s_v3"
	// VirtualMachineSizeTypesStandardE64sV3 ...
	VirtualMachineSizeTypesStandardE64sV3 VirtualMachineSizeTypes = "Standard_E64s_v3"
	// VirtualMachineSizeTypesStandardE64V3 ...
	VirtualMachineSizeTypesStandardE64V3 VirtualMachineSizeTypes = "Standard_E64_v3"
	// VirtualMachineSizeTypesStandardE8sV3 ...
	VirtualMachineSizeTypesStandardE8sV3 VirtualMachineSizeTypes = "Standard_E8s_v3"
	// VirtualMachineSizeTypesStandardE8V3 ...
	VirtualMachineSizeTypesStandardE8V3 VirtualMachineSizeTypes = "Standard_E8_v3"
	// VirtualMachineSizeTypesStandardF1 ...
	VirtualMachineSizeTypesStandardF1 VirtualMachineSizeTypes = "Standard_F1"
	// VirtualMachineSizeTypesStandardF16 ...
	VirtualMachineSizeTypesStandardF16 VirtualMachineSizeTypes = "Standard_F16"
	// VirtualMachineSizeTypesStandardF16s ...
	VirtualMachineSizeTypesStandardF16s VirtualMachineSizeTypes = "Standard_F16s"
	// VirtualMachineSizeTypesStandardF16sV2 ...
	VirtualMachineSizeTypesStandardF16sV2 VirtualMachineSizeTypes = "Standard_F16s_v2"
	// VirtualMachineSizeTypesStandardF1s ...
	VirtualMachineSizeTypesStandardF1s VirtualMachineSizeTypes = "Standard_F1s"
	// VirtualMachineSizeTypesStandardF2 ...
	VirtualMachineSizeTypesStandardF2 VirtualMachineSizeTypes = "Standard_F2"
	// VirtualMachineSizeTypesStandardF2s ...
	VirtualMachineSizeTypesStandardF2s VirtualMachineSizeTypes = "Standard_F2s"
	// VirtualMachineSizeTypesStandardF2sV2 ...
	VirtualMachineSizeTypesStandardF2sV2 VirtualMachineSizeTypes = "Standard_F2s_v2"
	// VirtualMachineSizeTypesStandardF32sV2 ...
	VirtualMachineSizeTypesStandardF32sV2 VirtualMachineSizeTypes = "Standard_F32s_v2"
	// VirtualMachineSizeTypesStandardF4 ...
	VirtualMachineSizeTypesStandardF4 VirtualMachineSizeTypes = "Standard_F4"
	// VirtualMachineSizeTypesStandardF4s ...
	VirtualMachineSizeTypesStandardF4s VirtualMachineSizeTypes = "Standard_F4s"
	// VirtualMachineSizeTypesStandardF4sV2 ...
	VirtualMachineSizeTypesStandardF4sV2 VirtualMachineSizeTypes = "Standard_F4s_v2"
	// VirtualMachineSizeTypesStandardF64sV2 ...
	VirtualMachineSizeTypesStandardF64sV2 VirtualMachineSizeTypes = "Standard_F64s_v2"
	// VirtualMachineSizeTypesStandardF72sV2 ...
	VirtualMachineSizeTypesStandardF72sV2 VirtualMachineSizeTypes = "Standard_F72s_v2"
	// VirtualMachineSizeTypesStandardF8 ...
	VirtualMachineSizeTypesStandardF8 VirtualMachineSizeTypes = "Standard_F8"
	// VirtualMachineSizeTypesStandardF8s ...
	VirtualMachineSizeTypesStandardF8s VirtualMachineSizeTypes = "Standard_F8s"
	// VirtualMachineSizeTypesStandardF8sV2 ...
	VirtualMachineSizeTypesStandardF8sV2 VirtualMachineSizeTypes = "Standard_F8s_v2"
	// VirtualMachineSizeTypesStandardG1 ...
	VirtualMachineSizeTypesStandardG1 VirtualMachineSizeTypes = "Standard_G1"
	// VirtualMachineSizeTypesStandardG2 ...
	VirtualMachineSizeTypesStandardG2 VirtualMachineSizeTypes = "Standard_G2"
	// VirtualMachineSizeTypesStandardG3 ...
	VirtualMachineSizeTypesStandardG3 VirtualMachineSizeTypes = "Standard_G3"
	// VirtualMachineSizeTypesStandardG4 ...
	VirtualMachineSizeTypesStandardG4 VirtualMachineSizeTypes = "Standard_G4"
	// VirtualMachineSizeTypesStandardG5 ...
	VirtualMachineSizeTypesStandardG5 VirtualMachineSizeTypes = "Standard_G5"
	// VirtualMachineSizeTypesStandardGS1 ...
	VirtualMachineSizeTypesStandardGS1 VirtualMachineSizeTypes = "Standard_GS1"
	// VirtualMachineSizeTypesStandardGS2 ...
	VirtualMachineSizeTypesStandardGS2 VirtualMachineSizeTypes = "Standard_GS2"
	// VirtualMachineSizeTypesStandardGS3 ...
	VirtualMachineSizeTypesStandardGS3 VirtualMachineSizeTypes = "Standard_GS3"
	// VirtualMachineSizeTypesStandardGS4 ...
	VirtualMachineSizeTypesStandardGS4 VirtualMachineSizeTypes = "Standard_GS4"
	// VirtualMachineSizeTypesStandardGS44 ...
	VirtualMachineSizeTypesStandardGS44 VirtualMachineSizeTypes = "Standard_GS4-4"
	// VirtualMachineSizeTypesStandardGS48 ...
	VirtualMachineSizeTypesStandardGS48 VirtualMachineSizeTypes = "Standard_GS4-8"
	// VirtualMachineSizeTypesStandardGS5 ...
	VirtualMachineSizeTypesStandardGS5 VirtualMachineSizeTypes = "Standard_GS5"
	// VirtualMachineSizeTypesStandardGS516 ...
	VirtualMachineSizeTypesStandardGS516 VirtualMachineSizeTypes = "Standard_GS5-16"
	// VirtualMachineSizeTypesStandardGS58 ...
	VirtualMachineSizeTypesStandardGS58 VirtualMachineSizeTypes = "Standard_GS5-8"
	// VirtualMachineSizeTypesStandardH16 ...
	VirtualMachineSizeTypesStandardH16 VirtualMachineSizeTypes = "Standard_H16"
	// VirtualMachineSizeTypesStandardH16m ...
	VirtualMachineSizeTypesStandardH16m VirtualMachineSizeTypes = "Standard_H16m"
	// VirtualMachineSizeTypesStandardH16mr ...
	VirtualMachineSizeTypesStandardH16mr VirtualMachineSizeTypes = "Standard_H16mr"
	// VirtualMachineSizeTypesStandardH16r ...
	VirtualMachineSizeTypesStandardH16r VirtualMachineSizeTypes = "Standard_H16r"
	// VirtualMachineSizeTypesStandardH8 ...
	VirtualMachineSizeTypesStandardH8 VirtualMachineSizeTypes = "Standard_H8"
	// VirtualMachineSizeTypesStandardH8m ...
	VirtualMachineSizeTypesStandardH8m VirtualMachineSizeTypes = "Standard_H8m"
	// VirtualMachineSizeTypesStandardL16s ...
	VirtualMachineSizeTypesStandardL16s VirtualMachineSizeTypes = "Standard_L16s"
	// VirtualMachineSizeTypesStandardL32s ...
	VirtualMachineSizeTypesStandardL32s VirtualMachineSizeTypes = "Standard_L32s"
	// VirtualMachineSizeTypesStandardL4s ...
	VirtualMachineSizeTypesStandardL4s VirtualMachineSizeTypes = "Standard_L4s"
	// VirtualMachineSizeTypesStandardL8s ...
	VirtualMachineSizeTypesStandardL8s VirtualMachineSizeTypes = "Standard_L8s"
	// VirtualMachineSizeTypesStandardM12832ms ...
	VirtualMachineSizeTypesStandardM12832ms VirtualMachineSizeTypes = "Standard_M128-32ms"
	// VirtualMachineSizeTypesStandardM12864ms ...
	VirtualMachineSizeTypesStandardM12864ms VirtualMachineSizeTypes = "Standard_M128-64ms"
	// VirtualMachineSizeTypesStandardM128ms ...
	VirtualMachineSizeTypesStandardM128ms VirtualMachineSizeTypes = "Standard_M128ms"
	// VirtualMachineSizeTypesStandardM128s ...
	VirtualMachineSizeTypesStandardM128s VirtualMachineSizeTypes = "Standard_M128s"
	// VirtualMachineSizeTypesStandardM6416ms ...
	VirtualMachineSizeTypesStandardM6416ms VirtualMachineSizeTypes = "Standard_M64-16ms"
	// VirtualMachineSizeTypesStandardM6432ms ...
	VirtualMachineSizeTypesStandardM6432ms VirtualMachineSizeTypes = "Standard_M64-32ms"
	// VirtualMachineSizeTypesStandardM64ms ...
	VirtualMachineSizeTypesStandardM64ms VirtualMachineSizeTypes = "Standard_M64ms"
	// VirtualMachineSizeTypesStandardM64s ...
	VirtualMachineSizeTypesStandardM64s VirtualMachineSizeTypes = "Standard_M64s"
	// VirtualMachineSizeTypesStandardNC12 ...
	VirtualMachineSizeTypesStandardNC12 VirtualMachineSizeTypes = "Standard_NC12"
	// VirtualMachineSizeTypesStandardNC12sV2 ...
	VirtualMachineSizeTypesStandardNC12sV2 VirtualMachineSizeTypes = "Standard_NC12s_v2"
	// VirtualMachineSizeTypesStandardNC12sV3 ...
	VirtualMachineSizeTypesStandardNC12sV3 VirtualMachineSizeTypes = "Standard_NC12s_v3"
	// VirtualMachineSizeTypesStandardNC24 ...
	VirtualMachineSizeTypesStandardNC24 VirtualMachineSizeTypes = "Standard_NC24"
	// VirtualMachineSizeTypesStandardNC24r ...
	VirtualMachineSizeTypesStandardNC24r VirtualMachineSizeTypes = "Standard_NC24r"
	// VirtualMachineSizeTypesStandardNC24rsV2 ...
	VirtualMachineSizeTypesStandardNC24rsV2 VirtualMachineSizeTypes = "Standard_NC24rs_v2"
	// VirtualMachineSizeTypesStandardNC24rsV3 ...
	VirtualMachineSizeTypesStandardNC24rsV3 VirtualMachineSizeTypes = "Standard_NC24rs_v3"
	// VirtualMachineSizeTypesStandardNC24sV2 ...
	VirtualMachineSizeTypesStandardNC24sV2 VirtualMachineSizeTypes = "Standard_NC24s_v2"
	// VirtualMachineSizeTypesStandardNC24sV3 ...
	VirtualMachineSizeTypesStandardNC24sV3 VirtualMachineSizeTypes = "Standard_NC24s_v3"
	// VirtualMachineSizeTypesStandardNC6 ...
	VirtualMachineSizeTypesStandardNC6 VirtualMachineSizeTypes = "Standard_NC6"
	// VirtualMachineSizeTypesStandardNC6sV2 ...
	VirtualMachineSizeTypesStandardNC6sV2 VirtualMachineSizeTypes = "Standard_NC6s_v2"
	// VirtualMachineSizeTypesStandardNC6sV3 ...
	VirtualMachineSizeTypesStandardNC6sV3 VirtualMachineSizeTypes = "Standard_NC6s_v3"
	// VirtualMachineSizeTypesStandardND12s ...
	VirtualMachineSizeTypesStandardND12s VirtualMachineSizeTypes = "Standard_ND12s"
	// VirtualMachineSizeTypesStandardND24rs ...
	VirtualMachineSizeTypesStandardND24rs VirtualMachineSizeTypes = "Standard_ND24rs"
	// VirtualMachineSizeTypesStandardND24s ...
	VirtualMachineSizeTypesStandardND24s VirtualMachineSizeTypes = "Standard_ND24s"
	// VirtualMachineSizeTypesStandardND6s ...
	VirtualMachineSizeTypesStandardND6s VirtualMachineSizeTypes = "Standard_ND6s"
	// VirtualMachineSizeTypesStandardNV12 ...
	VirtualMachineSizeTypesStandardNV12 VirtualMachineSizeTypes = "Standard_NV12"
	// VirtualMachineSizeTypesStandardNV24 ...
	VirtualMachineSizeTypesStandardNV24 VirtualMachineSizeTypes = "Standard_NV24"
	// VirtualMachineSizeTypesStandardNV6 ...
	VirtualMachineSizeTypesStandardNV6 VirtualMachineSizeTypes = "Standard_NV6"
)

// PossibleVirtualMachineSizeTypesValues returns an array of possible values for the VirtualMachineSizeTypes const type.
func PossibleVirtualMachineSizeTypesValues() []VirtualMachineSizeTypes {
	return []VirtualMachineSizeTypes{VirtualMachineSizeTypesBasicA0, VirtualMachineSizeTypesBasicA1, VirtualMachineSizeTypesBasicA2, VirtualMachineSizeTypesBasicA3, VirtualMachineSizeTypesBasicA4, VirtualMachineSizeTypesStandardA0, VirtualMachineSizeTypesStandardA1, VirtualMachineSizeTypesStandardA10, VirtualMachineSizeTypesStandardA11, VirtualMachineSizeTypesStandardA1V2, VirtualMachineSizeTypesStandardA2, VirtualMachineSizeTypesStandardA2mV2, VirtualMachineSizeTypesStandardA2V2, VirtualMachineSizeTypesStandardA3, VirtualMachineSizeTypesStandardA4, VirtualMachineSizeTypesStandardA4mV2, VirtualMachineSizeTypesStandardA4V2, VirtualMachineSizeTypesStandardA5, VirtualMachineSizeTypesStandardA6, VirtualMachineSizeTypesStandardA7, VirtualMachineSizeTypesStandardA8, VirtualMachineSizeTypesStandardA8mV2, VirtualMachineSizeTypesStandardA8V2, VirtualMachineSizeTypesStandardA9, VirtualMachineSizeTypesStandardB1ms, VirtualMachineSizeTypesStandardB1s, VirtualMachineSizeTypesStandardB2ms, VirtualMachineSizeTypesStandardB2s, VirtualMachineSizeTypesStandardB4ms, VirtualMachineSizeTypesStandardB8ms, VirtualMachineSizeTypesStandardD1, VirtualMachineSizeTypesStandardD11, VirtualMachineSizeTypesStandardD11V2, VirtualMachineSizeTypesStandardD12, VirtualMachineSizeTypesStandardD12V2, VirtualMachineSizeTypesStandardD13, VirtualMachineSizeTypesStandardD13V2, VirtualMachineSizeTypesStandardD14, VirtualMachineSizeTypesStandardD14V2, VirtualMachineSizeTypesStandardD15V2, VirtualMachineSizeTypesStandardD16sV3, VirtualMachineSizeTypesStandardD16V3, VirtualMachineSizeTypesStandardD1V2, VirtualMachineSizeTypesStandardD2, VirtualMachineSizeTypesStandardD2sV3, VirtualMachineSizeTypesStandardD2V2, VirtualMachineSizeTypesStandardD2V3, VirtualMachineSizeTypesStandardD3, VirtualMachineSizeTypesStandardD32sV3, VirtualMachineSizeTypesStandardD32V3, VirtualMachineSizeTypesStandardD3V2, VirtualMachineSizeTypesStandardD4, VirtualMachineSizeTypesStandardD4sV3, VirtualMachineSizeTypesStandardD4V2, VirtualMachineSizeTypesStandardD4V3, VirtualMachineSizeTypesStandardD5V2, VirtualMachineSizeTypesStandardD64sV3, VirtualMachineSizeTypesStandardD64V3, VirtualMachineSizeTypesStandardD8sV3, VirtualMachineSizeTypesStandardD8V3, VirtualMachineSizeTypesStandardDS1, VirtualMachineSizeTypesStandardDS11, VirtualMachineSizeTypesStandardDS11V2, VirtualMachineSizeTypesStandardDS12, VirtualMachineSizeTypesStandardDS12V2, VirtualMachineSizeTypesStandardDS13, VirtualMachineSizeTypesStandardDS132V2, VirtualMachineSizeTypesStandardDS134V2, VirtualMachineSizeTypesStandardDS13V2, VirtualMachineSizeTypesStandardDS14, VirtualMachineSizeTypesStandardDS144V2, VirtualMachineSizeTypesStandardDS148V2, VirtualMachineSizeTypesStandardDS14V2, VirtualMachineSizeTypesStandardDS15V2, VirtualMachineSizeTypesStandardDS1V2, VirtualMachineSizeTypesStandardDS2, VirtualMachineSizeTypesStandardDS2V2, VirtualMachineSizeTypesStandardDS3, VirtualMachineSizeTypesStandardDS3V2, VirtualMachineSizeTypesStandardDS4, VirtualMachineSizeTypesStandardDS4V2, VirtualMachineSizeTypesStandardDS5V2, VirtualMachineSizeTypesStandardE16sV3, VirtualMachineSizeTypesStandardE16V3, VirtualMachineSizeTypesStandardE2sV3, VirtualMachineSizeTypesStandardE2V3, VirtualMachineSizeTypesStandardE3216V3, VirtualMachineSizeTypesStandardE328sV3, VirtualMachineSizeTypesStandardE32sV3, VirtualMachineSizeTypesStandardE32V3, VirtualMachineSizeTypesStandardE4sV3, VirtualMachineSizeTypesStandardE4V3, VirtualMachineSizeTypesStandardE6416sV3, VirtualMachineSizeTypesStandardE6432sV3, VirtualMachineSizeTypesStandardE64sV3, VirtualMachineSizeTypesStandardE64V3, VirtualMachineSizeTypesStandardE8sV3, VirtualMachineSizeTypesStandardE8V3, VirtualMachineSizeTypesStandardF1, VirtualMachineSizeTypesStandardF16, VirtualMachineSizeTypesStandardF16s, VirtualMachineSizeTypesStandardF16sV2, VirtualMachineSizeTypesStandardF1s, VirtualMachineSizeTypesStandardF2, VirtualMachineSizeTypesStandardF2s, VirtualMachineSizeTypesStandardF2sV2, VirtualMachineSizeTypesStandardF32sV2, VirtualMachineSizeTypesStandardF4, VirtualMachineSizeTypesStandardF4s, VirtualMachineSizeTypesStandardF4sV2, VirtualMachineSizeTypesStandardF64sV2, VirtualMachineSizeTypesStandardF72sV2, VirtualMachineSizeTypesStandardF8, VirtualMachineSizeTypesStandardF8s, VirtualMachineSizeTypesStandardF8sV2, VirtualMachineSizeTypesStandardG1, VirtualMachineSizeTypesStandardG2, VirtualMachineSizeTypesStandardG3, VirtualMachineSizeTypesStandardG4, VirtualMachineSizeTypesStandardG5, VirtualMachineSizeTypesStandardGS1, VirtualMachineSizeTypesStandardGS2, VirtualMachineSizeTypesStandardGS3, VirtualMachineSizeTypesStandardGS4, VirtualMachineSizeTypesStandardGS44, VirtualMachineSizeTypesStandardGS48, VirtualMachineSizeTypesStandardGS5, VirtualMachineSizeTypesStandardGS516, VirtualMachineSizeTypesStandardGS58, VirtualMachineSizeTypesStandardH16, VirtualMachineSizeTypesStandardH16m, VirtualMachineSizeTypesStandardH16mr, VirtualMachineSizeTypesStandardH16r, VirtualMachineSizeTypesStandardH8, VirtualMachineSizeTypesStandardH8m, VirtualMachineSizeTypesStandardL16s, VirtualMachineSizeTypesStandardL32s, VirtualMachineSizeTypesStandardL4s, VirtualMachineSizeTypesStandardL8s, VirtualMachineSizeTypesStandardM12832ms, VirtualMachineSizeTypesStandardM12864ms, VirtualMachineSizeTypesStandardM128ms, VirtualMachineSizeTypesStandardM128s, VirtualMachineSizeTypesStandardM6416ms, VirtualMachineSizeTypesStandardM6432ms, VirtualMachineSizeTypesStandardM64ms, VirtualMachineSizeTypesStandardM64s, VirtualMachineSizeTypesStandardNC12, VirtualMachineSizeTypesStandardNC12sV2, VirtualMachineSizeTypesStandardNC12sV3, VirtualMachineSizeTypesStandardNC24, VirtualMachineSizeTypesStandardNC24r, VirtualMachineSizeTypesStandardNC24rsV2, VirtualMachineSizeTypesStandardNC24rsV3, VirtualMachineSizeTypesStandardNC24sV2, VirtualMachineSizeTypesStandardNC24sV3, VirtualMachineSizeTypesStandardNC6, VirtualMachineSizeTypesStandardNC6sV2, VirtualMachineSizeTypesStandardNC6sV3, VirtualMachineSizeTypesStandardND12s, VirtualMachineSizeTypesStandardND24rs, VirtualMachineSizeTypesStandardND24s, VirtualMachineSizeTypesStandardND6s, VirtualMachineSizeTypesStandardNV12, VirtualMachineSizeTypesStandardNV24, VirtualMachineSizeTypesStandardNV6}
}

// VMDiskTypes enumerates the values for vm disk types.
type VMDiskTypes string

const (
	// VMDiskTypesNone ...
	VMDiskTypesNone VMDiskTypes = "None"
	// VMDiskTypesUnmanaged ...
	VMDiskTypesUnmanaged VMDiskTypes = "Unmanaged"
)

// PossibleVMDiskTypesValues returns an array of possible values for the VMDiskTypes const type.
func PossibleVMDiskTypesValues() []VMDiskTypes {
	return []VMDiskTypes{VMDiskTypesNone, VMDiskTypesUnmanaged}
}

// VMGuestPatchClassificationLinux enumerates the values for vm guest patch classification linux.
type VMGuestPatchClassificationLinux string

const (
	// VMGuestPatchClassificationLinuxCritical ...
	VMGuestPatchClassificationLinuxCritical VMGuestPatchClassificationLinux = "Critical"
	// VMGuestPatchClassificationLinuxOther ...
	VMGuestPatchClassificationLinuxOther VMGuestPatchClassificationLinux = "Other"
	// VMGuestPatchClassificationLinuxSecurity ...
	VMGuestPatchClassificationLinuxSecurity VMGuestPatchClassificationLinux = "Security"
)

// PossibleVMGuestPatchClassificationLinuxValues returns an array of possible values for the VMGuestPatchClassificationLinux const type.
func PossibleVMGuestPatchClassificationLinuxValues() []VMGuestPatchClassificationLinux {
	return []VMGuestPatchClassificationLinux{VMGuestPatchClassificationLinuxCritical, VMGuestPatchClassificationLinuxOther, VMGuestPatchClassificationLinuxSecurity}
}

// VMGuestPatchClassificationWindows enumerates the values for vm guest patch classification windows.
type VMGuestPatchClassificationWindows string

const (
	// VMGuestPatchClassificationWindowsCritical ...
	VMGuestPatchClassificationWindowsCritical VMGuestPatchClassificationWindows = "Critical"
	// VMGuestPatchClassificationWindowsDefinition ...
	VMGuestPatchClassificationWindowsDefinition VMGuestPatchClassificationWindows = "Definition"
	// VMGuestPatchClassificationWindowsFeaturePack ...
	VMGuestPatchClassificationWindowsFeaturePack VMGuestPatchClassificationWindows = "FeaturePack"
	// VMGuestPatchClassificationWindowsSecurity ...
	VMGuestPatchClassificationWindowsSecurity VMGuestPatchClassificationWindows = "Security"
	// VMGuestPatchClassificationWindowsServicePack ...
	VMGuestPatchClassificationWindowsServicePack VMGuestPatchClassificationWindows = "ServicePack"
	// VMGuestPatchClassificationWindowsTools ...
	VMGuestPatchClassificationWindowsTools VMGuestPatchClassificationWindows = "Tools"
	// VMGuestPatchClassificationWindowsUpdateRollUp ...
	VMGuestPatchClassificationWindowsUpdateRollUp VMGuestPatchClassificationWindows = "UpdateRollUp"
	// VMGuestPatchClassificationWindowsUpdates ...
	VMGuestPatchClassificationWindowsUpdates VMGuestPatchClassificationWindows = "Updates"
)

// PossibleVMGuestPatchClassificationWindowsValues returns an array of possible values for the VMGuestPatchClassificationWindows const type.
func PossibleVMGuestPatchClassificationWindowsValues() []VMGuestPatchClassificationWindows {
	return []VMGuestPatchClassificationWindows{VMGuestPatchClassificationWindowsCritical, VMGuestPatchClassificationWindowsDefinition, VMGuestPatchClassificationWindowsFeaturePack, VMGuestPatchClassificationWindowsSecurity, VMGuestPatchClassificationWindowsServicePack, VMGuestPatchClassificationWindowsTools, VMGuestPatchClassificationWindowsUpdateRollUp, VMGuestPatchClassificationWindowsUpdates}
}

// VMGuestPatchRebootBehavior enumerates the values for vm guest patch reboot behavior.
type VMGuestPatchRebootBehavior string

const (
	// VMGuestPatchRebootBehaviorAlwaysRequiresReboot ...
	VMGuestPatchRebootBehaviorAlwaysRequiresReboot VMGuestPatchRebootBehavior = "AlwaysRequiresReboot"
	// VMGuestPatchRebootBehaviorCanRequestReboot ...
	VMGuestPatchRebootBehaviorCanRequestReboot VMGuestPatchRebootBehavior = "CanRequestReboot"
	// VMGuestPatchRebootBehaviorNeverReboots ...
	VMGuestPatchRebootBehaviorNeverReboots VMGuestPatchRebootBehavior = "NeverReboots"
	// VMGuestPatchRebootBehaviorUnknown ...
	VMGuestPatchRebootBehaviorUnknown VMGuestPatchRebootBehavior = "Unknown"
)

// PossibleVMGuestPatchRebootBehaviorValues returns an array of possible values for the VMGuestPatchRebootBehavior const type.
func PossibleVMGuestPatchRebootBehaviorValues() []VMGuestPatchRebootBehavior {
	return []VMGuestPatchRebootBehavior{VMGuestPatchRebootBehaviorAlwaysRequiresReboot, VMGuestPatchRebootBehaviorCanRequestReboot, VMGuestPatchRebootBehaviorNeverReboots, VMGuestPatchRebootBehaviorUnknown}
}

// VMGuestPatchRebootSetting enumerates the values for vm guest patch reboot setting.
type VMGuestPatchRebootSetting string

const (
	// VMGuestPatchRebootSettingAlways ...
	VMGuestPatchRebootSettingAlways VMGuestPatchRebootSetting = "Always"
	// VMGuestPatchRebootSettingIfRequired ...
	VMGuestPatchRebootSettingIfRequired VMGuestPatchRebootSetting = "IfRequired"
	// VMGuestPatchRebootSettingNever ...
	VMGuestPatchRebootSettingNever VMGuestPatchRebootSetting = "Never"
)

// PossibleVMGuestPatchRebootSettingValues returns an array of possible values for the VMGuestPatchRebootSetting const type.
func PossibleVMGuestPatchRebootSettingValues() []VMGuestPatchRebootSetting {
	return []VMGuestPatchRebootSetting{VMGuestPatchRebootSettingAlways, VMGuestPatchRebootSettingIfRequired, VMGuestPatchRebootSettingNever}
}

// VMGuestPatchRebootStatus enumerates the values for vm guest patch reboot status.
type VMGuestPatchRebootStatus string

const (
	// VMGuestPatchRebootStatusCompleted ...
	VMGuestPatchRebootStatusCompleted VMGuestPatchRebootStatus = "Completed"
	// VMGuestPatchRebootStatusFailed ...
	VMGuestPatchRebootStatusFailed VMGuestPatchRebootStatus = "Failed"
	// VMGuestPatchRebootStatusNotNeeded ...
	VMGuestPatchRebootStatusNotNeeded VMGuestPatchRebootStatus = "NotNeeded"
	// VMGuestPatchRebootStatusRequired ...
	VMGuestPatchRebootStatusRequired VMGuestPatchRebootStatus = "Required"
	// VMGuestPatchRebootStatusStarted ...
	VMGuestPatchRebootStatusStarted VMGuestPatchRebootStatus = "Started"
	// VMGuestPatchRebootStatusUnknown ...
	VMGuestPatchRebootStatusUnknown VMGuestPatchRebootStatus = "Unknown"
)

// PossibleVMGuestPatchRebootStatusValues returns an array of possible values for the VMGuestPatchRebootStatus const type.
func PossibleVMGuestPatchRebootStatusValues() []VMGuestPatchRebootStatus {
	return []VMGuestPatchRebootStatus{VMGuestPatchRebootStatusCompleted, VMGuestPatchRebootStatusFailed, VMGuestPatchRebootStatusNotNeeded, VMGuestPatchRebootStatusRequired, VMGuestPatchRebootStatusStarted, VMGuestPatchRebootStatusUnknown}
}

// WindowsPatchAssessmentMode enumerates the values for windows patch assessment mode.
type WindowsPatchAssessmentMode string

const (
	// WindowsPatchAssessmentModeAutomaticByPlatform ...
	WindowsPatchAssessmentModeAutomaticByPlatform WindowsPatchAssessmentMode = "AutomaticByPlatform"
	// WindowsPatchAssessmentModeImageDefault ...
	WindowsPatchAssessmentModeImageDefault WindowsPatchAssessmentMode = "ImageDefault"
)

// PossibleWindowsPatchAssessmentModeValues returns an array of possible values for the WindowsPatchAssessmentMode const type.
func PossibleWindowsPatchAssessmentModeValues() []WindowsPatchAssessmentMode {
	return []WindowsPatchAssessmentMode{WindowsPatchAssessmentModeAutomaticByPlatform, WindowsPatchAssessmentModeImageDefault}
}

// WindowsVMGuestPatchMode enumerates the values for windows vm guest patch mode.
type WindowsVMGuestPatchMode string

const (
	// WindowsVMGuestPatchModeAutomaticByOS ...
	WindowsVMGuestPatchModeAutomaticByOS WindowsVMGuestPatchMode = "AutomaticByOS"
	// WindowsVMGuestPatchModeAutomaticByPlatform ...
	WindowsVMGuestPatchModeAutomaticByPlatform WindowsVMGuestPatchMode = "AutomaticByPlatform"
	// WindowsVMGuestPatchModeManual ...
	WindowsVMGuestPatchModeManual WindowsVMGuestPatchMode = "Manual"
)

// PossibleWindowsVMGuestPatchModeValues returns an array of possible values for the WindowsVMGuestPatchMode const type.
func PossibleWindowsVMGuestPatchModeValues() []WindowsVMGuestPatchMode {
	return []WindowsVMGuestPatchMode{WindowsVMGuestPatchModeAutomaticByOS, WindowsVMGuestPatchModeAutomaticByPlatform, WindowsVMGuestPatchModeManual}
}
