package compute

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"io"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/compute/mgmt/2021-11-01/compute"

// AccessURI a disk access SAS uri.
type AccessURI struct {
	autorest.Response `json:"-"`
	// AccessSAS - READ-ONLY; A SAS uri for accessing a disk.
	AccessSAS *string `json:"accessSAS,omitempty"`
	// SecurityDataAccessSAS - READ-ONLY; A SAS uri for accessing a VM guest state.
	SecurityDataAccessSAS *string `json:"securityDataAccessSAS,omitempty"`
}

// MarshalJSON is the custom marshaler for AccessURI.
func (au AccessURI) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AdditionalCapabilities enables or disables a capability on the virtual machine or virtual machine scale
// set.
type AdditionalCapabilities struct {
	// UltraSSDEnabled - The flag that enables or disables a capability to have one or more managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale set only if this property is enabled.
	UltraSSDEnabled *bool `json:"ultraSSDEnabled,omitempty"`
	// HibernationEnabled - The flag that enables or disables hibernation capability on the VM.
	HibernationEnabled *bool `json:"hibernationEnabled,omitempty"`
}

// AdditionalUnattendContent specifies additional XML formatted information that can be included in the
// Unattend.xml file, which is used by Windows Setup. Contents are defined by setting name, component name,
// and the pass in which the content is applied.
type AdditionalUnattendContent struct {
	// PassName - The pass name. Currently, the only allowable value is OobeSystem. Possible values include: 'PassNamesOobeSystem'
	PassName PassNames `json:"passName,omitempty"`
	// ComponentName - The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup. Possible values include: 'ComponentNamesMicrosoftWindowsShellSetup'
	ComponentName ComponentNames `json:"componentName,omitempty"`
	// SettingName - Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon. Possible values include: 'SettingNamesAutoLogon', 'SettingNamesFirstLogonCommands'
	SettingName SettingNames `json:"settingName,omitempty"`
	// Content - Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted.
	Content *string `json:"content,omitempty"`
}

// APIEntityReference the API entity reference.
type APIEntityReference struct {
	// ID - The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
	ID *string `json:"id,omitempty"`
}

// APIError api error.
type APIError struct {
	// Details - The Api error details
	Details *[]APIErrorBase `json:"details,omitempty"`
	// Innererror - The Api inner error
	Innererror *InnerError `json:"innererror,omitempty"`
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// Target - The target of the particular error.
	Target *string `json:"target,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
}

// APIErrorBase api error base.
type APIErrorBase struct {
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// Target - The target of the particular error.
	Target *string `json:"target,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
}

// ApplicationProfile contains the list of gallery applications that should be made available to the
// VM/VMSS
type ApplicationProfile struct {
	// GalleryApplications - Specifies the gallery applications that should be made available to the VM/VMSS
	GalleryApplications *[]VMGalleryApplication `json:"galleryApplications,omitempty"`
}

// AutomaticOSUpgradePolicy the configuration parameters used for performing automatic OS upgrade.
type AutomaticOSUpgradePolicy struct {
	// EnableAutomaticOSUpgrade - Indicates whether OS upgrades should automatically be applied to scale set instances in a rolling fashion when a newer version of the OS image becomes available. Default value is false. <br><br> If this is set to true for Windows based scale sets, [enableAutomaticUpdates](https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet) is automatically set to false and cannot be set to true.
	EnableAutomaticOSUpgrade *bool `json:"enableAutomaticOSUpgrade,omitempty"`
	// DisableAutomaticRollback - Whether OS image rollback feature should be disabled. Default value is false.
	DisableAutomaticRollback *bool `json:"disableAutomaticRollback,omitempty"`
}

// AutomaticOSUpgradeProperties describes automatic OS upgrade properties on the image.
type AutomaticOSUpgradeProperties struct {
	// AutomaticOSUpgradeSupported - Specifies whether automatic OS upgrade is supported on the image.
	AutomaticOSUpgradeSupported *bool `json:"automaticOSUpgradeSupported,omitempty"`
}

// AutomaticRepairsPolicy specifies the configuration parameters for automatic repairs on the virtual
// machine scale set.
type AutomaticRepairsPolicy struct {
	// Enabled - Specifies whether automatic repairs should be enabled on the virtual machine scale set. The default value is false.
	Enabled *bool `json:"enabled,omitempty"`
	// GracePeriod - The amount of time for which automatic repairs are suspended due to a state change on VM. The grace time starts after the state change has completed. This helps avoid premature or accidental repairs. The time duration should be specified in ISO 8601 format. The minimum allowed grace period is 10 minutes (PT10M), which is also the default value. The maximum allowed grace period is 90 minutes (PT90M).
	GracePeriod *string `json:"gracePeriod,omitempty"`
	// RepairAction - Type of repair action (replace, restart, reimage) that will be used for repairing unhealthy virtual machines in the scale set. Default value is replace. Possible values include: 'RepairActionReplace', 'RepairActionRestart', 'RepairActionReimage'
	RepairAction RepairAction `json:"repairAction,omitempty"`
}

// AvailabilitySet specifies information about the availability set that the virtual machine should be
// assigned to. Virtual machines specified in the same availability set are allocated to different nodes to
// maximize availability. For more information about availability sets, see [Availability sets
// overview](https://docs.microsoft.com/azure/virtual-machines/availability-set-overview). <br><br> For
// more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in
// Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates) <br><br> Currently, a
// VM can only be added to availability set at creation time. An existing VM cannot be added to an
// availability set.
type AvailabilitySet struct {
	autorest.Response          `json:"-"`
	*AvailabilitySetProperties `json:"properties,omitempty"`
	// Sku - Sku of the availability set, only name is required to be set. See AvailabilitySetSkuTypes for possible set of values. Use 'Aligned' for virtual machines with managed disks and 'Classic' for virtual machines with unmanaged disks. Default value is 'Classic'.
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AvailabilitySet.
func (as AvailabilitySet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if as.AvailabilitySetProperties != nil {
		objectMap["properties"] = as.AvailabilitySetProperties
	}
	if as.Sku != nil {
		objectMap["sku"] = as.Sku
	}
	if as.Location != nil {
		objectMap["location"] = as.Location
	}
	if as.Tags != nil {
		objectMap["tags"] = as.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AvailabilitySet struct.
func (as *AvailabilitySet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var availabilitySetProperties AvailabilitySetProperties
				err = json.Unmarshal(*v, &availabilitySetProperties)
				if err != nil {
					return err
				}
				as.AvailabilitySetProperties = &availabilitySetProperties
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				as.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				as.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				as.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				as.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				as.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				as.Tags = tags
			}
		}
	}

	return nil
}

// AvailabilitySetListResult the List Availability Set operation response.
type AvailabilitySetListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of availability sets
	Value *[]AvailabilitySet `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of AvailabilitySets. Call ListNext() with this URI to fetch the next page of AvailabilitySets.
	NextLink *string `json:"nextLink,omitempty"`
}

// AvailabilitySetListResultIterator provides access to a complete listing of AvailabilitySet values.
type AvailabilitySetListResultIterator struct {
	i    int
	page AvailabilitySetListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailabilitySetListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailabilitySetListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailabilitySetListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailabilitySetListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailabilitySetListResultIterator) Response() AvailabilitySetListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailabilitySetListResultIterator) Value() AvailabilitySet {
	if !iter.page.NotDone() {
		return AvailabilitySet{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailabilitySetListResultIterator type.
func NewAvailabilitySetListResultIterator(page AvailabilitySetListResultPage) AvailabilitySetListResultIterator {
	return AvailabilitySetListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aslr AvailabilitySetListResult) IsEmpty() bool {
	return aslr.Value == nil || len(*aslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aslr AvailabilitySetListResult) hasNextLink() bool {
	return aslr.NextLink != nil && len(*aslr.NextLink) != 0
}

// availabilitySetListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aslr AvailabilitySetListResult) availabilitySetListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aslr.NextLink)))
}

// AvailabilitySetListResultPage contains a page of AvailabilitySet values.
type AvailabilitySetListResultPage struct {
	fn   func(context.Context, AvailabilitySetListResult) (AvailabilitySetListResult, error)
	aslr AvailabilitySetListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailabilitySetListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailabilitySetListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aslr)
		if err != nil {
			return err
		}
		page.aslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailabilitySetListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailabilitySetListResultPage) NotDone() bool {
	return !page.aslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailabilitySetListResultPage) Response() AvailabilitySetListResult {
	return page.aslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailabilitySetListResultPage) Values() []AvailabilitySet {
	if page.aslr.IsEmpty() {
		return nil
	}
	return *page.aslr.Value
}

// Creates a new instance of the AvailabilitySetListResultPage type.
func NewAvailabilitySetListResultPage(cur AvailabilitySetListResult, getNextPage func(context.Context, AvailabilitySetListResult) (AvailabilitySetListResult, error)) AvailabilitySetListResultPage {
	return AvailabilitySetListResultPage{
		fn:   getNextPage,
		aslr: cur,
	}
}

// AvailabilitySetProperties the instance view of a resource.
type AvailabilitySetProperties struct {
	// PlatformUpdateDomainCount - Update Domain count.
	PlatformUpdateDomainCount *int32 `json:"platformUpdateDomainCount,omitempty"`
	// PlatformFaultDomainCount - Fault Domain count.
	PlatformFaultDomainCount *int32 `json:"platformFaultDomainCount,omitempty"`
	// VirtualMachines - A list of references to all virtual machines in the availability set.
	VirtualMachines *[]SubResource `json:"virtualMachines,omitempty"`
	// ProximityPlacementGroup - Specifies information about the proximity placement group that the availability set should be assigned to. <br><br>Minimum api-version: 2018-04-01.
	ProximityPlacementGroup *SubResource `json:"proximityPlacementGroup,omitempty"`
	// Statuses - READ-ONLY; The resource status information.
	Statuses *[]InstanceViewStatus `json:"statuses,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailabilitySetProperties.
func (asp AvailabilitySetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asp.PlatformUpdateDomainCount != nil {
		objectMap["platformUpdateDomainCount"] = asp.PlatformUpdateDomainCount
	}
	if asp.PlatformFaultDomainCount != nil {
		objectMap["platformFaultDomainCount"] = asp.PlatformFaultDomainCount
	}
	if asp.VirtualMachines != nil {
		objectMap["virtualMachines"] = asp.VirtualMachines
	}
	if asp.ProximityPlacementGroup != nil {
		objectMap["proximityPlacementGroup"] = asp.ProximityPlacementGroup
	}
	return json.Marshal(objectMap)
}

// AvailabilitySetUpdate specifies information about the availability set that the virtual machine should
// be assigned to. Only tags may be updated.
type AvailabilitySetUpdate struct {
	*AvailabilitySetProperties `json:"properties,omitempty"`
	// Sku - Sku of the availability set
	Sku *Sku `json:"sku,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AvailabilitySetUpdate.
func (asu AvailabilitySetUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asu.AvailabilitySetProperties != nil {
		objectMap["properties"] = asu.AvailabilitySetProperties
	}
	if asu.Sku != nil {
		objectMap["sku"] = asu.Sku
	}
	if asu.Tags != nil {
		objectMap["tags"] = asu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AvailabilitySetUpdate struct.
func (asu *AvailabilitySetUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var availabilitySetProperties AvailabilitySetProperties
				err = json.Unmarshal(*v, &availabilitySetProperties)
				if err != nil {
					return err
				}
				asu.AvailabilitySetProperties = &availabilitySetProperties
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				asu.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asu.Tags = tags
			}
		}
	}

	return nil
}

// AvailablePatchSummary describes the properties of an virtual machine instance view for available patch
// summary.
type AvailablePatchSummary struct {
	// Status - READ-ONLY; The overall success or failure status of the operation. It remains "InProgress" until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded", or "CompletedWithWarnings.". Possible values include: 'PatchOperationStatusUnknown', 'PatchOperationStatusInProgress', 'PatchOperationStatusFailed', 'PatchOperationStatusSucceeded', 'PatchOperationStatusCompletedWithWarnings'
	Status PatchOperationStatus `json:"status,omitempty"`
	// AssessmentActivityID - READ-ONLY; The activity ID of the operation that produced this result. It is used to correlate across CRP and extension logs.
	AssessmentActivityID *string `json:"assessmentActivityId,omitempty"`
	// RebootPending - READ-ONLY; The overall reboot status of the VM. It will be true when partially installed patches require a reboot to complete installation but the reboot has not yet occurred.
	RebootPending *bool `json:"rebootPending,omitempty"`
	// CriticalAndSecurityPatchCount - READ-ONLY; The number of critical or security patches that have been detected as available and not yet installed.
	CriticalAndSecurityPatchCount *int32 `json:"criticalAndSecurityPatchCount,omitempty"`
	// OtherPatchCount - READ-ONLY; The number of all available patches excluding critical and security.
	OtherPatchCount *int32 `json:"otherPatchCount,omitempty"`
	// StartTime - READ-ONLY; The UTC timestamp when the operation began.
	StartTime *date.Time `json:"startTime,omitempty"`
	// LastModifiedTime - READ-ONLY; The UTC timestamp when the operation began.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Error - READ-ONLY; The errors that were encountered during execution of the operation. The details array contains the list of them.
	Error *APIError `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailablePatchSummary.
func (aps AvailablePatchSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BillingProfile specifies the billing related details of a Azure Spot VM or VMSS. <br><br>Minimum
// api-version: 2019-03-01.
type BillingProfile struct {
	// MaxPrice - Specifies the maximum price you are willing to pay for a Azure Spot VM/VMSS. This price is in US Dollars. <br><br> This price will be compared with the current Azure Spot price for the VM size. Also, the prices are compared at the time of create/update of Azure Spot VM/VMSS and the operation will only succeed if  the maxPrice is greater than the current Azure Spot price. <br><br> The maxPrice will also be used for evicting a Azure Spot VM/VMSS if the current Azure Spot price goes beyond the maxPrice after creation of VM/VMSS. <br><br> Possible values are: <br><br> - Any decimal value greater than zero. Example: 0.01538 <br><br> -1 – indicates default price to be up-to on-demand. <br><br> You can set the maxPrice to -1 to indicate that the Azure Spot VM/VMSS should not be evicted for price reasons. Also, the default max price is -1 if it is not provided by you. <br><br>Minimum api-version: 2019-03-01.
	MaxPrice *float64 `json:"maxPrice,omitempty"`
}

// BootDiagnostics boot Diagnostics is a debugging feature which allows you to view Console Output and
// Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br>
// Azure also enables you to see a screenshot of the VM from the hypervisor.
type BootDiagnostics struct {
	// Enabled - Whether boot diagnostics should be enabled on the Virtual Machine.
	Enabled *bool `json:"enabled,omitempty"`
	// StorageURI - Uri of the storage account to use for placing the console output and screenshot. <br><br>If storageUri is not specified while enabling boot diagnostics, managed storage will be used.
	StorageURI *string `json:"storageUri,omitempty"`
}

// BootDiagnosticsInstanceView the instance view of a virtual machine boot diagnostics.
type BootDiagnosticsInstanceView struct {
	// ConsoleScreenshotBlobURI - READ-ONLY; The console screenshot blob URI. <br><br>NOTE: This will **not** be set if boot diagnostics is currently enabled with managed storage.
	ConsoleScreenshotBlobURI *string `json:"consoleScreenshotBlobUri,omitempty"`
	// SerialConsoleLogBlobURI - READ-ONLY; The serial console log blob Uri. <br><br>NOTE: This will **not** be set if boot diagnostics is currently enabled with managed storage.
	SerialConsoleLogBlobURI *string `json:"serialConsoleLogBlobUri,omitempty"`
	// Status - READ-ONLY; The boot diagnostics status information for the VM. <br><br> NOTE: It will be set only if there are errors encountered in enabling boot diagnostics.
	Status *InstanceViewStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for BootDiagnosticsInstanceView.
func (bdiv BootDiagnosticsInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CapacityReservation specifies information about the capacity reservation.
type CapacityReservation struct {
	autorest.Response              `json:"-"`
	*CapacityReservationProperties `json:"properties,omitempty"`
	// Sku - SKU of the resource for which capacity needs be reserved. The SKU name and capacity is required to be set. Currently VM Skus with the capability called 'CapacityReservationSupported' set to true are supported. Refer to List Microsoft.Compute SKUs in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported values.
	Sku *Sku `json:"sku,omitempty"`
	// Zones - Availability Zone to use for this capacity reservation. The zone has to be single value and also should be part for the list of zones specified during the capacity reservation group creation. The zone can be assigned only during creation. If not provided, the reservation supports only non-zonal deployments. If provided, enforces VM/VMSS using this capacity reservation to be in same zone.
	Zones *[]string `json:"zones,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CapacityReservation.
func (cr CapacityReservation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cr.CapacityReservationProperties != nil {
		objectMap["properties"] = cr.CapacityReservationProperties
	}
	if cr.Sku != nil {
		objectMap["sku"] = cr.Sku
	}
	if cr.Zones != nil {
		objectMap["zones"] = cr.Zones
	}
	if cr.Location != nil {
		objectMap["location"] = cr.Location
	}
	if cr.Tags != nil {
		objectMap["tags"] = cr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CapacityReservation struct.
func (cr *CapacityReservation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var capacityReservationProperties CapacityReservationProperties
				err = json.Unmarshal(*v, &capacityReservationProperties)
				if err != nil {
					return err
				}
				cr.CapacityReservationProperties = &capacityReservationProperties
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				cr.Sku = &sku
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				cr.Zones = &zones
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cr.Tags = tags
			}
		}
	}

	return nil
}

// CapacityReservationGroup specifies information about the capacity reservation group that the capacity
// reservations should be assigned to. <br><br> Currently, a capacity reservation can only be added to a
// capacity reservation group at creation time. An existing capacity reservation cannot be added or moved
// to another capacity reservation group.
type CapacityReservationGroup struct {
	autorest.Response                   `json:"-"`
	*CapacityReservationGroupProperties `json:"properties,omitempty"`
	// Zones - Availability Zones to use for this capacity reservation group. The zones can be assigned only during creation. If not provided, the group supports only regional resources in the region. If provided, enforces each capacity reservation in the group to be in one of the zones.
	Zones *[]string `json:"zones,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CapacityReservationGroup.
func (crg CapacityReservationGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if crg.CapacityReservationGroupProperties != nil {
		objectMap["properties"] = crg.CapacityReservationGroupProperties
	}
	if crg.Zones != nil {
		objectMap["zones"] = crg.Zones
	}
	if crg.Location != nil {
		objectMap["location"] = crg.Location
	}
	if crg.Tags != nil {
		objectMap["tags"] = crg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CapacityReservationGroup struct.
func (crg *CapacityReservationGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var capacityReservationGroupProperties CapacityReservationGroupProperties
				err = json.Unmarshal(*v, &capacityReservationGroupProperties)
				if err != nil {
					return err
				}
				crg.CapacityReservationGroupProperties = &capacityReservationGroupProperties
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				crg.Zones = &zones
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				crg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				crg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				crg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				crg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				crg.Tags = tags
			}
		}
	}

	return nil
}

// CapacityReservationGroupInstanceView ...
type CapacityReservationGroupInstanceView struct {
	// CapacityReservations - READ-ONLY; List of instance view of the capacity reservations under the capacity reservation group.
	CapacityReservations *[]CapacityReservationInstanceViewWithName `json:"capacityReservations,omitempty"`
}

// MarshalJSON is the custom marshaler for CapacityReservationGroupInstanceView.
func (crgiv CapacityReservationGroupInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CapacityReservationGroupListResult the List capacity reservation group with resource group response.
type CapacityReservationGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of capacity reservation groups
	Value *[]CapacityReservationGroup `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of capacity reservation groups. Call ListNext() with this URI to fetch the next page of capacity reservation groups.
	NextLink *string `json:"nextLink,omitempty"`
}

// CapacityReservationGroupListResultIterator provides access to a complete listing of
// CapacityReservationGroup values.
type CapacityReservationGroupListResultIterator struct {
	i    int
	page CapacityReservationGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CapacityReservationGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CapacityReservationGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CapacityReservationGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CapacityReservationGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CapacityReservationGroupListResultIterator) Response() CapacityReservationGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CapacityReservationGroupListResultIterator) Value() CapacityReservationGroup {
	if !iter.page.NotDone() {
		return CapacityReservationGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CapacityReservationGroupListResultIterator type.
func NewCapacityReservationGroupListResultIterator(page CapacityReservationGroupListResultPage) CapacityReservationGroupListResultIterator {
	return CapacityReservationGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (crglr CapacityReservationGroupListResult) IsEmpty() bool {
	return crglr.Value == nil || len(*crglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (crglr CapacityReservationGroupListResult) hasNextLink() bool {
	return crglr.NextLink != nil && len(*crglr.NextLink) != 0
}

// capacityReservationGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (crglr CapacityReservationGroupListResult) capacityReservationGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !crglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(crglr.NextLink)))
}

// CapacityReservationGroupListResultPage contains a page of CapacityReservationGroup values.
type CapacityReservationGroupListResultPage struct {
	fn    func(context.Context, CapacityReservationGroupListResult) (CapacityReservationGroupListResult, error)
	crglr CapacityReservationGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CapacityReservationGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CapacityReservationGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.crglr)
		if err != nil {
			return err
		}
		page.crglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CapacityReservationGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CapacityReservationGroupListResultPage) NotDone() bool {
	return !page.crglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CapacityReservationGroupListResultPage) Response() CapacityReservationGroupListResult {
	return page.crglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CapacityReservationGroupListResultPage) Values() []CapacityReservationGroup {
	if page.crglr.IsEmpty() {
		return nil
	}
	return *page.crglr.Value
}

// Creates a new instance of the CapacityReservationGroupListResultPage type.
func NewCapacityReservationGroupListResultPage(cur CapacityReservationGroupListResult, getNextPage func(context.Context, CapacityReservationGroupListResult) (CapacityReservationGroupListResult, error)) CapacityReservationGroupListResultPage {
	return CapacityReservationGroupListResultPage{
		fn:    getNextPage,
		crglr: cur,
	}
}

// CapacityReservationGroupProperties capacity reservation group Properties.
type CapacityReservationGroupProperties struct {
	// CapacityReservations - READ-ONLY; A list of all capacity reservation resource ids that belong to capacity reservation group.
	CapacityReservations *[]SubResourceReadOnly `json:"capacityReservations,omitempty"`
	// VirtualMachinesAssociated - READ-ONLY; A list of references to all virtual machines associated to the capacity reservation group.
	VirtualMachinesAssociated *[]SubResourceReadOnly `json:"virtualMachinesAssociated,omitempty"`
	// InstanceView - READ-ONLY; The capacity reservation group instance view which has the list of instance views for all the capacity reservations that belong to the capacity reservation group.
	InstanceView *CapacityReservationGroupInstanceView `json:"instanceView,omitempty"`
}

// MarshalJSON is the custom marshaler for CapacityReservationGroupProperties.
func (crgp CapacityReservationGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CapacityReservationGroupUpdate specifies information about the capacity reservation group. Only tags can
// be updated.
type CapacityReservationGroupUpdate struct {
	*CapacityReservationGroupProperties `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CapacityReservationGroupUpdate.
func (crgu CapacityReservationGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if crgu.CapacityReservationGroupProperties != nil {
		objectMap["properties"] = crgu.CapacityReservationGroupProperties
	}
	if crgu.Tags != nil {
		objectMap["tags"] = crgu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CapacityReservationGroupUpdate struct.
func (crgu *CapacityReservationGroupUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var capacityReservationGroupProperties CapacityReservationGroupProperties
				err = json.Unmarshal(*v, &capacityReservationGroupProperties)
				if err != nil {
					return err
				}
				crgu.CapacityReservationGroupProperties = &capacityReservationGroupProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				crgu.Tags = tags
			}
		}
	}

	return nil
}

// CapacityReservationInstanceView the instance view of a capacity reservation that provides as snapshot of
// the runtime properties of the capacity reservation that is managed by the platform and can change
// outside of control plane operations.
type CapacityReservationInstanceView struct {
	// UtilizationInfo - Unutilized capacity of the capacity reservation.
	UtilizationInfo *CapacityReservationUtilization `json:"utilizationInfo,omitempty"`
	// Statuses - The resource status information.
	Statuses *[]InstanceViewStatus `json:"statuses,omitempty"`
}

// CapacityReservationInstanceViewWithName the instance view of a capacity reservation that includes the
// name of the capacity reservation. It is used for the response to the instance view of a capacity
// reservation group.
type CapacityReservationInstanceViewWithName struct {
	// Name - READ-ONLY; The name of the capacity reservation.
	Name *string `json:"name,omitempty"`
	// UtilizationInfo - Unutilized capacity of the capacity reservation.
	UtilizationInfo *CapacityReservationUtilization `json:"utilizationInfo,omitempty"`
	// Statuses - The resource status information.
	Statuses *[]InstanceViewStatus `json:"statuses,omitempty"`
}

// MarshalJSON is the custom marshaler for CapacityReservationInstanceViewWithName.
func (crivwn CapacityReservationInstanceViewWithName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if crivwn.UtilizationInfo != nil {
		objectMap["utilizationInfo"] = crivwn.UtilizationInfo
	}
	if crivwn.Statuses != nil {
		objectMap["statuses"] = crivwn.Statuses
	}
	return json.Marshal(objectMap)
}

// CapacityReservationListResult the list capacity reservation operation response.
type CapacityReservationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of capacity reservations
	Value *[]CapacityReservation `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of capacity reservations. Call ListNext() with this URI to fetch the next page of capacity reservations.
	NextLink *string `json:"nextLink,omitempty"`
}

// CapacityReservationListResultIterator provides access to a complete listing of CapacityReservation
// values.
type CapacityReservationListResultIterator struct {
	i    int
	page CapacityReservationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CapacityReservationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CapacityReservationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CapacityReservationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CapacityReservationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CapacityReservationListResultIterator) Response() CapacityReservationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CapacityReservationListResultIterator) Value() CapacityReservation {
	if !iter.page.NotDone() {
		return CapacityReservation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CapacityReservationListResultIterator type.
func NewCapacityReservationListResultIterator(page CapacityReservationListResultPage) CapacityReservationListResultIterator {
	return CapacityReservationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (crlr CapacityReservationListResult) IsEmpty() bool {
	return crlr.Value == nil || len(*crlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (crlr CapacityReservationListResult) hasNextLink() bool {
	return crlr.NextLink != nil && len(*crlr.NextLink) != 0
}

// capacityReservationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (crlr CapacityReservationListResult) capacityReservationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !crlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(crlr.NextLink)))
}

// CapacityReservationListResultPage contains a page of CapacityReservation values.
type CapacityReservationListResultPage struct {
	fn   func(context.Context, CapacityReservationListResult) (CapacityReservationListResult, error)
	crlr CapacityReservationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CapacityReservationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CapacityReservationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.crlr)
		if err != nil {
			return err
		}
		page.crlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CapacityReservationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CapacityReservationListResultPage) NotDone() bool {
	return !page.crlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CapacityReservationListResultPage) Response() CapacityReservationListResult {
	return page.crlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CapacityReservationListResultPage) Values() []CapacityReservation {
	if page.crlr.IsEmpty() {
		return nil
	}
	return *page.crlr.Value
}

// Creates a new instance of the CapacityReservationListResultPage type.
func NewCapacityReservationListResultPage(cur CapacityReservationListResult, getNextPage func(context.Context, CapacityReservationListResult) (CapacityReservationListResult, error)) CapacityReservationListResultPage {
	return CapacityReservationListResultPage{
		fn:   getNextPage,
		crlr: cur,
	}
}

// CapacityReservationProfile the parameters of a capacity reservation Profile.
type CapacityReservationProfile struct {
	// CapacityReservationGroup - Specifies the capacity reservation group resource id that should be used for allocating the virtual machine or scaleset vm instances provided enough capacity has been reserved. Please refer to https://aka.ms/CapacityReservation for more details.
	CapacityReservationGroup *SubResource `json:"capacityReservationGroup,omitempty"`
}

// CapacityReservationProperties properties of the Capacity reservation.
type CapacityReservationProperties struct {
	// ReservationID - READ-ONLY; A unique id generated and assigned to the capacity reservation by the platform which does not change throughout the lifetime of the resource.
	ReservationID *string `json:"reservationId,omitempty"`
	// VirtualMachinesAssociated - READ-ONLY; A list of all virtual machine resource ids that are associated with the capacity reservation.
	VirtualMachinesAssociated *[]SubResourceReadOnly `json:"virtualMachinesAssociated,omitempty"`
	// ProvisioningTime - READ-ONLY; The date time when the capacity reservation was last updated.
	ProvisioningTime *date.Time `json:"provisioningTime,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// InstanceView - READ-ONLY; The Capacity reservation instance view.
	InstanceView *CapacityReservationInstanceView `json:"instanceView,omitempty"`
	// TimeCreated - READ-ONLY; Specifies the time at which the Capacity Reservation resource was created.<br><br>Minimum api-version: 2021-11-01.
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
}

// MarshalJSON is the custom marshaler for CapacityReservationProperties.
func (crp CapacityReservationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CapacityReservationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CapacityReservationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CapacityReservationsClient) (CapacityReservation, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CapacityReservationsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CapacityReservationsCreateOrUpdateFuture.Result.
func (future *CapacityReservationsCreateOrUpdateFuture) result(client CapacityReservationsClient) (cr CapacityReservation, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CapacityReservationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CapacityReservationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cr.Response.Response, err = future.GetResult(sender); err == nil && cr.Response.Response.StatusCode != http.StatusNoContent {
		cr, err = client.CreateOrUpdateResponder(cr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.CapacityReservationsCreateOrUpdateFuture", "Result", cr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CapacityReservationsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CapacityReservationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CapacityReservationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CapacityReservationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CapacityReservationsDeleteFuture.Result.
func (future *CapacityReservationsDeleteFuture) result(client CapacityReservationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CapacityReservationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CapacityReservationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CapacityReservationsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CapacityReservationsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CapacityReservationsClient) (CapacityReservation, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CapacityReservationsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CapacityReservationsUpdateFuture.Result.
func (future *CapacityReservationsUpdateFuture) result(client CapacityReservationsClient) (cr CapacityReservation, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CapacityReservationsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CapacityReservationsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cr.Response.Response, err = future.GetResult(sender); err == nil && cr.Response.Response.StatusCode != http.StatusNoContent {
		cr, err = client.UpdateResponder(cr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.CapacityReservationsUpdateFuture", "Result", cr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CapacityReservationUpdate specifies information about the capacity reservation. Only tags and
// sku.capacity can be updated.
type CapacityReservationUpdate struct {
	*CapacityReservationProperties `json:"properties,omitempty"`
	// Sku - SKU of the resource for which capacity needs be reserved. The SKU name and capacity is required to be set. Currently VM Skus with the capability called 'CapacityReservationSupported' set to true are supported. Refer to List Microsoft.Compute SKUs in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported values.
	Sku *Sku `json:"sku,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CapacityReservationUpdate.
func (cru CapacityReservationUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cru.CapacityReservationProperties != nil {
		objectMap["properties"] = cru.CapacityReservationProperties
	}
	if cru.Sku != nil {
		objectMap["sku"] = cru.Sku
	}
	if cru.Tags != nil {
		objectMap["tags"] = cru.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CapacityReservationUpdate struct.
func (cru *CapacityReservationUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var capacityReservationProperties CapacityReservationProperties
				err = json.Unmarshal(*v, &capacityReservationProperties)
				if err != nil {
					return err
				}
				cru.CapacityReservationProperties = &capacityReservationProperties
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				cru.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cru.Tags = tags
			}
		}
	}

	return nil
}

// CapacityReservationUtilization represents the capacity reservation utilization in terms of resources
// allocated.
type CapacityReservationUtilization struct {
	// VirtualMachinesAllocated - READ-ONLY; A list of all virtual machines resource ids allocated against the capacity reservation.
	VirtualMachinesAllocated *[]SubResourceReadOnly `json:"virtualMachinesAllocated,omitempty"`
}

// MarshalJSON is the custom marshaler for CapacityReservationUtilization.
func (cru CapacityReservationUtilization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CloudError an error response from the Compute service.
type CloudError struct {
	Error *APIError `json:"error,omitempty"`
}

// CloudService describes the cloud service.
type CloudService struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags       map[string]*string      `json:"tags"`
	Properties *CloudServiceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudService.
func (cs CloudService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cs.Location != nil {
		objectMap["location"] = cs.Location
	}
	if cs.Tags != nil {
		objectMap["tags"] = cs.Tags
	}
	if cs.Properties != nil {
		objectMap["properties"] = cs.Properties
	}
	return json.Marshal(objectMap)
}

// CloudServiceExtensionProfile describes a cloud service extension profile.
type CloudServiceExtensionProfile struct {
	// Extensions - List of extensions for the cloud service.
	Extensions *[]Extension `json:"extensions,omitempty"`
}

// CloudServiceExtensionProperties extension Properties.
type CloudServiceExtensionProperties struct {
	// Publisher - The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`
	// Type - Specifies the type of the extension.
	Type *string `json:"type,omitempty"`
	// TypeHandlerVersion - Specifies the version of the extension. Specifies the version of the extension. If this element is not specified or an asterisk (*) is used as the value, the latest version of the extension is used. If the value is specified with a major version number and an asterisk as the minor version number (X.), the latest minor version of the specified major version is selected. If a major version number and a minor version number are specified (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade is performed on the role instance.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
	// AutoUpgradeMinorVersion - Explicitly specify whether platform can automatically upgrade typeHandlerVersion to higher minor versions when they become available.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`
	// Settings - Public settings for the extension. For JSON extensions, this is the JSON settings for the extension. For XML Extension (like RDP), this is the XML setting for the extension.
	Settings *string `json:"settings,omitempty"`
	// ProtectedSettings - Protected settings for the extension which are encrypted before sent to the role instance.
	ProtectedSettings             *string                              `json:"protectedSettings,omitempty"`
	ProtectedSettingsFromKeyVault *CloudServiceVaultAndSecretReference `json:"protectedSettingsFromKeyVault,omitempty"`
	// ForceUpdateTag - Tag to force apply the provided public and protected settings.
	// Changing the tag value allows for re-running the extension without changing any of the public or protected settings.
	// If forceUpdateTag is not changed, updates to public or protected settings would still be applied by the handler.
	// If neither forceUpdateTag nor any of public or protected settings change, extension would flow to the role instance with the same sequence-number, and
	// it is up to handler implementation whether to re-run it or not
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// RolesAppliedTo - Optional list of roles to apply this extension. If property is not specified or '*' is specified, extension is applied to all roles in the cloud service.
	RolesAppliedTo *[]string `json:"rolesAppliedTo,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudServiceExtensionProperties.
func (csep CloudServiceExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csep.Publisher != nil {
		objectMap["publisher"] = csep.Publisher
	}
	if csep.Type != nil {
		objectMap["type"] = csep.Type
	}
	if csep.TypeHandlerVersion != nil {
		objectMap["typeHandlerVersion"] = csep.TypeHandlerVersion
	}
	if csep.AutoUpgradeMinorVersion != nil {
		objectMap["autoUpgradeMinorVersion"] = csep.AutoUpgradeMinorVersion
	}
	if csep.Settings != nil {
		objectMap["settings"] = csep.Settings
	}
	if csep.ProtectedSettings != nil {
		objectMap["protectedSettings"] = csep.ProtectedSettings
	}
	if csep.ProtectedSettingsFromKeyVault != nil {
		objectMap["protectedSettingsFromKeyVault"] = csep.ProtectedSettingsFromKeyVault
	}
	if csep.ForceUpdateTag != nil {
		objectMap["forceUpdateTag"] = csep.ForceUpdateTag
	}
	if csep.RolesAppliedTo != nil {
		objectMap["rolesAppliedTo"] = csep.RolesAppliedTo
	}
	return json.Marshal(objectMap)
}

// CloudServiceInstanceView instanceView of CloudService as a whole
type CloudServiceInstanceView struct {
	autorest.Response `json:"-"`
	RoleInstance      *InstanceViewStatusesSummary `json:"roleInstance,omitempty"`
	// SdkVersion - READ-ONLY; The version of the SDK that was used to generate the package for the cloud service.
	SdkVersion *string `json:"sdkVersion,omitempty"`
	// PrivateIds - READ-ONLY; Specifies a list of unique identifiers generated internally for the cloud service. <br /><br /> NOTE: If you are using Azure Diagnostics extension, this property can be used as 'DeploymentId' for querying details.
	PrivateIds *[]string `json:"privateIds,omitempty"`
	// Statuses - READ-ONLY
	Statuses *[]ResourceInstanceViewStatus `json:"statuses,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudServiceInstanceView.
func (csiv CloudServiceInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csiv.RoleInstance != nil {
		objectMap["roleInstance"] = csiv.RoleInstance
	}
	return json.Marshal(objectMap)
}

// CloudServiceListResult ...
type CloudServiceListResult struct {
	autorest.Response `json:"-"`
	Value             *[]CloudService `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// CloudServiceListResultIterator provides access to a complete listing of CloudService values.
type CloudServiceListResultIterator struct {
	i    int
	page CloudServiceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudServiceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudServiceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CloudServiceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudServiceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudServiceListResultIterator) Response() CloudServiceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudServiceListResultIterator) Value() CloudService {
	if !iter.page.NotDone() {
		return CloudService{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CloudServiceListResultIterator type.
func NewCloudServiceListResultIterator(page CloudServiceListResultPage) CloudServiceListResultIterator {
	return CloudServiceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cslr CloudServiceListResult) IsEmpty() bool {
	return cslr.Value == nil || len(*cslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cslr CloudServiceListResult) hasNextLink() bool {
	return cslr.NextLink != nil && len(*cslr.NextLink) != 0
}

// cloudServiceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cslr CloudServiceListResult) cloudServiceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cslr.NextLink)))
}

// CloudServiceListResultPage contains a page of CloudService values.
type CloudServiceListResultPage struct {
	fn   func(context.Context, CloudServiceListResult) (CloudServiceListResult, error)
	cslr CloudServiceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudServiceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudServiceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cslr)
		if err != nil {
			return err
		}
		page.cslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CloudServiceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudServiceListResultPage) NotDone() bool {
	return !page.cslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudServiceListResultPage) Response() CloudServiceListResult {
	return page.cslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudServiceListResultPage) Values() []CloudService {
	if page.cslr.IsEmpty() {
		return nil
	}
	return *page.cslr.Value
}

// Creates a new instance of the CloudServiceListResultPage type.
func NewCloudServiceListResultPage(cur CloudServiceListResult, getNextPage func(context.Context, CloudServiceListResult) (CloudServiceListResult, error)) CloudServiceListResultPage {
	return CloudServiceListResultPage{
		fn:   getNextPage,
		cslr: cur,
	}
}

// CloudServiceNetworkProfile network Profile for the cloud service.
type CloudServiceNetworkProfile struct {
	// LoadBalancerConfigurations - List of Load balancer configurations. Cloud service can have up to two load balancer configurations, corresponding to a Public Load Balancer and an Internal Load Balancer.
	LoadBalancerConfigurations *[]LoadBalancerConfiguration `json:"loadBalancerConfigurations,omitempty"`
	// SwappableCloudService - The id reference of the cloud service containing the target IP with which the subject cloud service can perform a swap. This property cannot be updated once it is set. The swappable cloud service referred by this id must be present otherwise an error will be thrown.
	SwappableCloudService *SubResource `json:"swappableCloudService,omitempty"`
}

// CloudServiceOsProfile describes the OS profile for the cloud service.
type CloudServiceOsProfile struct {
	// Secrets - Specifies set of certificates that should be installed onto the role instances.
	Secrets *[]CloudServiceVaultSecretGroup `json:"secrets,omitempty"`
}

// CloudServiceProperties cloud service properties
type CloudServiceProperties struct {
	// PackageURL - Specifies a URL that refers to the location of the service package in the Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage account.
	// This is a write-only property and is not returned in GET calls.
	PackageURL *string `json:"packageUrl,omitempty"`
	// Configuration - Specifies the XML service configuration (.cscfg) for the cloud service.
	Configuration *string `json:"configuration,omitempty"`
	// ConfigurationURL - Specifies a URL that refers to the location of the service configuration in the Blob service. The service package URL  can be Shared Access Signature (SAS) URI from any storage account.
	// This is a write-only property and is not returned in GET calls.
	ConfigurationURL *string `json:"configurationUrl,omitempty"`
	// StartCloudService - (Optional) Indicates whether to start the cloud service immediately after it is created. The default value is `true`.
	// If false, the service model is still deployed, but the code is not run immediately. Instead, the service is PoweredOff until you call Start, at which time the service will be started. A deployed service still incurs charges, even if it is poweredoff.
	StartCloudService *bool `json:"startCloudService,omitempty"`
	// AllowModelOverride - (Optional) Indicates whether the role sku properties (roleProfile.roles.sku) specified in the model/template should override the role instance count and vm size specified in the .cscfg and .csdef respectively.
	// The default value is `false`.
	AllowModelOverride *bool `json:"allowModelOverride,omitempty"`
	// UpgradeMode - Possible values include: 'CloudServiceUpgradeModeAuto', 'CloudServiceUpgradeModeManual', 'CloudServiceUpgradeModeSimultaneous'
	UpgradeMode      CloudServiceUpgradeMode       `json:"upgradeMode,omitempty"`
	RoleProfile      *CloudServiceRoleProfile      `json:"roleProfile,omitempty"`
	OsProfile        *CloudServiceOsProfile        `json:"osProfile,omitempty"`
	NetworkProfile   *CloudServiceNetworkProfile   `json:"networkProfile,omitempty"`
	ExtensionProfile *CloudServiceExtensionProfile `json:"extensionProfile,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueID - READ-ONLY; The unique identifier for the cloud service.
	UniqueID *string `json:"uniqueId,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudServiceProperties.
func (csp CloudServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csp.PackageURL != nil {
		objectMap["packageUrl"] = csp.PackageURL
	}
	if csp.Configuration != nil {
		objectMap["configuration"] = csp.Configuration
	}
	if csp.ConfigurationURL != nil {
		objectMap["configurationUrl"] = csp.ConfigurationURL
	}
	if csp.StartCloudService != nil {
		objectMap["startCloudService"] = csp.StartCloudService
	}
	if csp.AllowModelOverride != nil {
		objectMap["allowModelOverride"] = csp.AllowModelOverride
	}
	if csp.UpgradeMode != "" {
		objectMap["upgradeMode"] = csp.UpgradeMode
	}
	if csp.RoleProfile != nil {
		objectMap["roleProfile"] = csp.RoleProfile
	}
	if csp.OsProfile != nil {
		objectMap["osProfile"] = csp.OsProfile
	}
	if csp.NetworkProfile != nil {
		objectMap["networkProfile"] = csp.NetworkProfile
	}
	if csp.ExtensionProfile != nil {
		objectMap["extensionProfile"] = csp.ExtensionProfile
	}
	return json.Marshal(objectMap)
}

// CloudServiceRole describes a role of the cloud service.
type CloudServiceRole struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Resource location
	Location   *string                     `json:"location,omitempty"`
	Sku        *CloudServiceRoleSku        `json:"sku,omitempty"`
	Properties *CloudServiceRoleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudServiceRole.
func (csr CloudServiceRole) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csr.Sku != nil {
		objectMap["sku"] = csr.Sku
	}
	if csr.Properties != nil {
		objectMap["properties"] = csr.Properties
	}
	return json.Marshal(objectMap)
}

// CloudServiceRoleInstancesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CloudServiceRoleInstancesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudServiceRoleInstancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudServiceRoleInstancesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudServiceRoleInstancesDeleteFuture.Result.
func (future *CloudServiceRoleInstancesDeleteFuture) result(client CloudServiceRoleInstancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CloudServiceRoleInstancesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CloudServiceRoleInstancesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudServiceRoleInstancesRebuildFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CloudServiceRoleInstancesRebuildFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudServiceRoleInstancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudServiceRoleInstancesRebuildFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudServiceRoleInstancesRebuildFuture.Result.
func (future *CloudServiceRoleInstancesRebuildFuture) result(client CloudServiceRoleInstancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CloudServiceRoleInstancesRebuildFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CloudServiceRoleInstancesRebuildFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudServiceRoleInstancesReimageFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CloudServiceRoleInstancesReimageFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudServiceRoleInstancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudServiceRoleInstancesReimageFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudServiceRoleInstancesReimageFuture.Result.
func (future *CloudServiceRoleInstancesReimageFuture) result(client CloudServiceRoleInstancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CloudServiceRoleInstancesReimageFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CloudServiceRoleInstancesReimageFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudServiceRoleInstancesRestartFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CloudServiceRoleInstancesRestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudServiceRoleInstancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudServiceRoleInstancesRestartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudServiceRoleInstancesRestartFuture.Result.
func (future *CloudServiceRoleInstancesRestartFuture) result(client CloudServiceRoleInstancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CloudServiceRoleInstancesRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CloudServiceRoleInstancesRestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudServiceRoleListResult ...
type CloudServiceRoleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]CloudServiceRole `json:"value,omitempty"`
	NextLink          *string             `json:"nextLink,omitempty"`
}

// CloudServiceRoleListResultIterator provides access to a complete listing of CloudServiceRole values.
type CloudServiceRoleListResultIterator struct {
	i    int
	page CloudServiceRoleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudServiceRoleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudServiceRoleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CloudServiceRoleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudServiceRoleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudServiceRoleListResultIterator) Response() CloudServiceRoleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudServiceRoleListResultIterator) Value() CloudServiceRole {
	if !iter.page.NotDone() {
		return CloudServiceRole{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CloudServiceRoleListResultIterator type.
func NewCloudServiceRoleListResultIterator(page CloudServiceRoleListResultPage) CloudServiceRoleListResultIterator {
	return CloudServiceRoleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (csrlr CloudServiceRoleListResult) IsEmpty() bool {
	return csrlr.Value == nil || len(*csrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (csrlr CloudServiceRoleListResult) hasNextLink() bool {
	return csrlr.NextLink != nil && len(*csrlr.NextLink) != 0
}

// cloudServiceRoleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (csrlr CloudServiceRoleListResult) cloudServiceRoleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !csrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(csrlr.NextLink)))
}

// CloudServiceRoleListResultPage contains a page of CloudServiceRole values.
type CloudServiceRoleListResultPage struct {
	fn    func(context.Context, CloudServiceRoleListResult) (CloudServiceRoleListResult, error)
	csrlr CloudServiceRoleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudServiceRoleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudServiceRoleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.csrlr)
		if err != nil {
			return err
		}
		page.csrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CloudServiceRoleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudServiceRoleListResultPage) NotDone() bool {
	return !page.csrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudServiceRoleListResultPage) Response() CloudServiceRoleListResult {
	return page.csrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudServiceRoleListResultPage) Values() []CloudServiceRole {
	if page.csrlr.IsEmpty() {
		return nil
	}
	return *page.csrlr.Value
}

// Creates a new instance of the CloudServiceRoleListResultPage type.
func NewCloudServiceRoleListResultPage(cur CloudServiceRoleListResult, getNextPage func(context.Context, CloudServiceRoleListResult) (CloudServiceRoleListResult, error)) CloudServiceRoleListResultPage {
	return CloudServiceRoleListResultPage{
		fn:    getNextPage,
		csrlr: cur,
	}
}

// CloudServiceRoleProfile describes the role profile for the cloud service.
type CloudServiceRoleProfile struct {
	// Roles - List of roles for the cloud service.
	Roles *[]CloudServiceRoleProfileProperties `json:"roles,omitempty"`
}

// CloudServiceRoleProfileProperties describes the role properties.
type CloudServiceRoleProfileProperties struct {
	// Name - Resource name.
	Name *string              `json:"name,omitempty"`
	Sku  *CloudServiceRoleSku `json:"sku,omitempty"`
}

// CloudServiceRoleProperties ...
type CloudServiceRoleProperties struct {
	// UniqueID - READ-ONLY; Specifies the ID which uniquely identifies a cloud service role.
	UniqueID *string `json:"uniqueId,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudServiceRoleProperties.
func (csrp CloudServiceRoleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CloudServiceRoleSku describes the cloud service role sku.
type CloudServiceRoleSku struct {
	// Name - The sku name. NOTE: If the new SKU is not supported on the hardware the cloud service is currently on, you need to delete and recreate the cloud service or move back to the old sku.
	Name *string `json:"name,omitempty"`
	// Tier - Specifies the tier of the cloud service. Possible Values are <br /><br /> **Standard** <br /><br /> **Basic**
	Tier *string `json:"tier,omitempty"`
	// Capacity - Specifies the number of role instances in the cloud service.
	Capacity *int64 `json:"capacity,omitempty"`
}

// CloudServicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CloudServicesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudServicesClient) (CloudService, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudServicesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudServicesCreateOrUpdateFuture.Result.
func (future *CloudServicesCreateOrUpdateFuture) result(client CloudServicesClient) (cs CloudService, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CloudServicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cs.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CloudServicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cs.Response.Response, err = future.GetResult(sender); err == nil && cs.Response.Response.StatusCode != http.StatusNoContent {
		cs, err = client.CreateOrUpdateResponder(cs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.CloudServicesCreateOrUpdateFuture", "Result", cs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CloudServicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CloudServicesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudServicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudServicesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudServicesDeleteFuture.Result.
func (future *CloudServicesDeleteFuture) result(client CloudServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CloudServicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CloudServicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudServicesDeleteInstancesFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CloudServicesDeleteInstancesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudServicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudServicesDeleteInstancesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudServicesDeleteInstancesFuture.Result.
func (future *CloudServicesDeleteInstancesFuture) result(client CloudServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CloudServicesDeleteInstancesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CloudServicesDeleteInstancesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudServicesPowerOffFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CloudServicesPowerOffFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudServicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudServicesPowerOffFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudServicesPowerOffFuture.Result.
func (future *CloudServicesPowerOffFuture) result(client CloudServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CloudServicesPowerOffFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CloudServicesPowerOffFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudServicesRebuildFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CloudServicesRebuildFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudServicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudServicesRebuildFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudServicesRebuildFuture.Result.
func (future *CloudServicesRebuildFuture) result(client CloudServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CloudServicesRebuildFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CloudServicesRebuildFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudServicesReimageFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CloudServicesReimageFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudServicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudServicesReimageFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudServicesReimageFuture.Result.
func (future *CloudServicesReimageFuture) result(client CloudServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CloudServicesReimageFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CloudServicesReimageFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudServicesRestartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CloudServicesRestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudServicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudServicesRestartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudServicesRestartFuture.Result.
func (future *CloudServicesRestartFuture) result(client CloudServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CloudServicesRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CloudServicesRestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudServicesStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CloudServicesStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudServicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudServicesStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudServicesStartFuture.Result.
func (future *CloudServicesStartFuture) result(client CloudServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CloudServicesStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CloudServicesStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudServicesUpdateDomainWalkUpdateDomainFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type CloudServicesUpdateDomainWalkUpdateDomainFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudServicesUpdateDomainClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudServicesUpdateDomainWalkUpdateDomainFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudServicesUpdateDomainWalkUpdateDomainFuture.Result.
func (future *CloudServicesUpdateDomainWalkUpdateDomainFuture) result(client CloudServicesUpdateDomainClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CloudServicesUpdateDomainWalkUpdateDomainFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CloudServicesUpdateDomainWalkUpdateDomainFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudServicesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CloudServicesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudServicesClient) (CloudService, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudServicesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudServicesUpdateFuture.Result.
func (future *CloudServicesUpdateFuture) result(client CloudServicesClient) (cs CloudService, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.CloudServicesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cs.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.CloudServicesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cs.Response.Response, err = future.GetResult(sender); err == nil && cs.Response.Response.StatusCode != http.StatusNoContent {
		cs, err = client.UpdateResponder(cs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.CloudServicesUpdateFuture", "Result", cs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CloudServiceUpdate ...
type CloudServiceUpdate struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CloudServiceUpdate.
func (csu CloudServiceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csu.Tags != nil {
		objectMap["tags"] = csu.Tags
	}
	return json.Marshal(objectMap)
}

// CloudServiceVaultAndSecretReference ...
type CloudServiceVaultAndSecretReference struct {
	SourceVault *SubResource `json:"sourceVault,omitempty"`
	SecretURL   *string      `json:"secretUrl,omitempty"`
}

// CloudServiceVaultCertificate describes a single certificate reference in a Key Vault, and where the
// certificate should reside on the role instance.
type CloudServiceVaultCertificate struct {
	// CertificateURL - This is the URL of a certificate that has been uploaded to Key Vault as a secret.
	CertificateURL *string `json:"certificateUrl,omitempty"`
}

// CloudServiceVaultSecretGroup describes a set of certificates which are all in the same Key Vault.
type CloudServiceVaultSecretGroup struct {
	// SourceVault - The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
	SourceVault *SubResource `json:"sourceVault,omitempty"`
	// VaultCertificates - The list of key vault references in SourceVault which contain certificates.
	VaultCertificates *[]CloudServiceVaultCertificate `json:"vaultCertificates,omitempty"`
}

// CommunityGallery specifies information about the Community Gallery that you want to create or update.
type CommunityGallery struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Resource type
	Type                        *string `json:"type,omitempty"`
	*CommunityGalleryIdentifier `json:"identifier,omitempty"`
}

// MarshalJSON is the custom marshaler for CommunityGallery.
func (cg CommunityGallery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cg.CommunityGalleryIdentifier != nil {
		objectMap["identifier"] = cg.CommunityGalleryIdentifier
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CommunityGallery struct.
func (cg *CommunityGallery) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cg.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cg.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cg.Type = &typeVar
			}
		case "identifier":
			if v != nil {
				var communityGalleryIdentifier CommunityGalleryIdentifier
				err = json.Unmarshal(*v, &communityGalleryIdentifier)
				if err != nil {
					return err
				}
				cg.CommunityGalleryIdentifier = &communityGalleryIdentifier
			}
		}
	}

	return nil
}

// CommunityGalleryIdentifier the identifier information of community gallery.
type CommunityGalleryIdentifier struct {
	// UniqueID - The unique id of this community gallery.
	UniqueID *string `json:"uniqueId,omitempty"`
}

// CommunityGalleryImage specifies information about the gallery image definition that you want to create
// or update.
type CommunityGalleryImage struct {
	autorest.Response                `json:"-"`
	*CommunityGalleryImageProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Resource type
	Type                        *string `json:"type,omitempty"`
	*CommunityGalleryIdentifier `json:"identifier,omitempty"`
}

// MarshalJSON is the custom marshaler for CommunityGalleryImage.
func (cgiVar CommunityGalleryImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cgiVar.CommunityGalleryImageProperties != nil {
		objectMap["properties"] = cgiVar.CommunityGalleryImageProperties
	}
	if cgiVar.CommunityGalleryIdentifier != nil {
		objectMap["identifier"] = cgiVar.CommunityGalleryIdentifier
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CommunityGalleryImage struct.
func (cgiVar *CommunityGalleryImage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var communityGalleryImageProperties CommunityGalleryImageProperties
				err = json.Unmarshal(*v, &communityGalleryImageProperties)
				if err != nil {
					return err
				}
				cgiVar.CommunityGalleryImageProperties = &communityGalleryImageProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cgiVar.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cgiVar.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cgiVar.Type = &typeVar
			}
		case "identifier":
			if v != nil {
				var communityGalleryIdentifier CommunityGalleryIdentifier
				err = json.Unmarshal(*v, &communityGalleryIdentifier)
				if err != nil {
					return err
				}
				cgiVar.CommunityGalleryIdentifier = &communityGalleryIdentifier
			}
		}
	}

	return nil
}

// CommunityGalleryImageProperties describes the properties of a gallery image definition.
type CommunityGalleryImageProperties struct {
	// OsType - This property allows you to specify the type of the OS that is included in the disk when creating a VM from a managed image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**. Possible values include: 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// OsState - This property allows the user to specify whether the virtual machines created under this image are 'Generalized' or 'Specialized'. Possible values include: 'OperatingSystemStateTypesGeneralized', 'OperatingSystemStateTypesSpecialized'
	OsState OperatingSystemStateTypes `json:"osState,omitempty"`
	// EndOfLifeDate - The end of life date of the gallery image definition. This property can be used for decommissioning purposes. This property is updatable.
	EndOfLifeDate *date.Time                       `json:"endOfLifeDate,omitempty"`
	Identifier    *GalleryImageIdentifier          `json:"identifier,omitempty"`
	Recommended   *RecommendedMachineConfiguration `json:"recommended,omitempty"`
	Disallowed    *Disallowed                      `json:"disallowed,omitempty"`
	// HyperVGeneration - The hypervisor generation of the Virtual Machine. Applicable to OS disks only. Possible values include: 'HyperVGenerationV1', 'HyperVGenerationV2'
	HyperVGeneration HyperVGeneration `json:"hyperVGeneration,omitempty"`
	// Features - A list of gallery image features.
	Features     *[]GalleryImageFeature `json:"features,omitempty"`
	PurchasePlan *ImagePurchasePlan     `json:"purchasePlan,omitempty"`
}

// CommunityGalleryImageVersion specifies information about the gallery image version that you want to
// create or update.
type CommunityGalleryImageVersion struct {
	autorest.Response                       `json:"-"`
	*CommunityGalleryImageVersionProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Resource type
	Type                        *string `json:"type,omitempty"`
	*CommunityGalleryIdentifier `json:"identifier,omitempty"`
}

// MarshalJSON is the custom marshaler for CommunityGalleryImageVersion.
func (cgiv CommunityGalleryImageVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cgiv.CommunityGalleryImageVersionProperties != nil {
		objectMap["properties"] = cgiv.CommunityGalleryImageVersionProperties
	}
	if cgiv.CommunityGalleryIdentifier != nil {
		objectMap["identifier"] = cgiv.CommunityGalleryIdentifier
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CommunityGalleryImageVersion struct.
func (cgiv *CommunityGalleryImageVersion) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var communityGalleryImageVersionProperties CommunityGalleryImageVersionProperties
				err = json.Unmarshal(*v, &communityGalleryImageVersionProperties)
				if err != nil {
					return err
				}
				cgiv.CommunityGalleryImageVersionProperties = &communityGalleryImageVersionProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cgiv.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cgiv.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cgiv.Type = &typeVar
			}
		case "identifier":
			if v != nil {
				var communityGalleryIdentifier CommunityGalleryIdentifier
				err = json.Unmarshal(*v, &communityGalleryIdentifier)
				if err != nil {
					return err
				}
				cgiv.CommunityGalleryIdentifier = &communityGalleryIdentifier
			}
		}
	}

	return nil
}

// CommunityGalleryImageVersionProperties describes the properties of a gallery image version.
type CommunityGalleryImageVersionProperties struct {
	// PublishedDate - The published date of the gallery image version Definition. This property can be used for decommissioning purposes. This property is updatable.
	PublishedDate *date.Time `json:"publishedDate,omitempty"`
	// EndOfLifeDate - The end of life date of the gallery image version Definition. This property can be used for decommissioning purposes. This property is updatable.
	EndOfLifeDate *date.Time `json:"endOfLifeDate,omitempty"`
}

// CreationData data used when creating a disk.
type CreationData struct {
	// CreateOption - This enumerates the possible sources of a disk's creation. Possible values include: 'DiskCreateOptionEmpty', 'DiskCreateOptionAttach', 'DiskCreateOptionFromImage', 'DiskCreateOptionImport', 'DiskCreateOptionCopy', 'DiskCreateOptionRestore', 'DiskCreateOptionUpload', 'DiskCreateOptionCopyStart', 'DiskCreateOptionImportSecure', 'DiskCreateOptionUploadPreparedSecure'
	CreateOption DiskCreateOption `json:"createOption,omitempty"`
	// StorageAccountID - Required if createOption is Import. The Azure Resource Manager identifier of the storage account containing the blob to import as a disk.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// ImageReference - Disk source information.
	ImageReference *ImageDiskReference `json:"imageReference,omitempty"`
	// GalleryImageReference - Required if creating from a Gallery Image. The id of the ImageDiskReference will be the ARM id of the shared galley image version from which to create a disk.
	GalleryImageReference *ImageDiskReference `json:"galleryImageReference,omitempty"`
	// SourceURI - If createOption is Import, this is the URI of a blob to be imported into a managed disk.
	SourceURI *string `json:"sourceUri,omitempty"`
	// SourceResourceID - If createOption is Copy, this is the ARM id of the source snapshot or disk.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// SourceUniqueID - READ-ONLY; If this field is set, this is the unique id identifying the source of this resource.
	SourceUniqueID *string `json:"sourceUniqueId,omitempty"`
	// UploadSizeBytes - If createOption is Upload, this is the size of the contents of the upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
	UploadSizeBytes *int64 `json:"uploadSizeBytes,omitempty"`
	// LogicalSectorSize - Logical sector size in bytes for Ultra disks. Supported values are 512 ad 4096. 4096 is the default.
	LogicalSectorSize *int32 `json:"logicalSectorSize,omitempty"`
	// SecurityDataURI - If createOption is ImportSecure, this is the URI of a blob to be imported into VM guest state.
	SecurityDataURI *string `json:"securityDataUri,omitempty"`
}

// MarshalJSON is the custom marshaler for CreationData.
func (cd CreationData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cd.CreateOption != "" {
		objectMap["createOption"] = cd.CreateOption
	}
	if cd.StorageAccountID != nil {
		objectMap["storageAccountId"] = cd.StorageAccountID
	}
	if cd.ImageReference != nil {
		objectMap["imageReference"] = cd.ImageReference
	}
	if cd.GalleryImageReference != nil {
		objectMap["galleryImageReference"] = cd.GalleryImageReference
	}
	if cd.SourceURI != nil {
		objectMap["sourceUri"] = cd.SourceURI
	}
	if cd.SourceResourceID != nil {
		objectMap["sourceResourceId"] = cd.SourceResourceID
	}
	if cd.UploadSizeBytes != nil {
		objectMap["uploadSizeBytes"] = cd.UploadSizeBytes
	}
	if cd.LogicalSectorSize != nil {
		objectMap["logicalSectorSize"] = cd.LogicalSectorSize
	}
	if cd.SecurityDataURI != nil {
		objectMap["securityDataUri"] = cd.SecurityDataURI
	}
	return json.Marshal(objectMap)
}

// DataDisk describes a data disk.
type DataDisk struct {
	// Lun - Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
	Lun *int32 `json:"lun,omitempty"`
	// Name - The disk name.
	Name *string `json:"name,omitempty"`
	// Vhd - The virtual hard disk.
	Vhd *VirtualHardDisk `json:"vhd,omitempty"`
	// Image - The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
	Image *VirtualHardDisk `json:"image,omitempty"`
	// Caching - Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**. Possible values include: 'CachingTypesNone', 'CachingTypesReadOnly', 'CachingTypesReadWrite'
	Caching CachingTypes `json:"caching,omitempty"`
	// WriteAcceleratorEnabled - Specifies whether writeAccelerator should be enabled or disabled on the disk.
	WriteAcceleratorEnabled *bool `json:"writeAcceleratorEnabled,omitempty"`
	// CreateOption - Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described. Possible values include: 'DiskCreateOptionTypesFromImage', 'DiskCreateOptionTypesEmpty', 'DiskCreateOptionTypesAttach'
	CreateOption DiskCreateOptionTypes `json:"createOption,omitempty"`
	// DiskSizeGB - Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
	// ManagedDisk - The managed disk parameters.
	ManagedDisk *ManagedDiskParameters `json:"managedDisk,omitempty"`
	// ToBeDetached - Specifies whether the data disk is in process of detachment from the VirtualMachine/VirtualMachineScaleset
	ToBeDetached *bool `json:"toBeDetached,omitempty"`
	// DiskIOPSReadWrite - READ-ONLY; Specifies the Read-Write IOPS for the managed disk when StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be updated only via updates to the VirtualMachine Scale Set.
	DiskIOPSReadWrite *int64 `json:"diskIOPSReadWrite,omitempty"`
	// DiskMBpsReadWrite - READ-ONLY; Specifies the bandwidth in MB per second for the managed disk when StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be updated only via updates to the VirtualMachine Scale Set.
	DiskMBpsReadWrite *int64 `json:"diskMBpsReadWrite,omitempty"`
	// DetachOption - Specifies the detach behavior to be used while detaching a disk or which is already in the process of detachment from the virtual machine. Supported values: **ForceDetach**. <br><br> detachOption: **ForceDetach** is applicable only for managed data disks. If a previous detachment attempt of the data disk did not complete due to an unexpected failure from the virtual machine and the disk is still not released then use force-detach as a last resort option to detach the disk forcibly from the VM. All writes might not have been flushed when using this detach behavior. <br><br> This feature is still in preview mode and is not supported for VirtualMachineScaleSet. To force-detach a data disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'. Possible values include: 'DiskDetachOptionTypesForceDetach'
	DetachOption DiskDetachOptionTypes `json:"detachOption,omitempty"`
	// DeleteOption - Specifies whether data disk should be deleted or detached upon VM deletion.<br><br> Possible values: <br><br> **Delete** If this value is used, the data disk is deleted when VM is deleted.<br><br> **Detach** If this value is used, the data disk is retained after VM is deleted.<br><br> The default value is set to **detach**. Possible values include: 'DiskDeleteOptionTypesDelete', 'DiskDeleteOptionTypesDetach'
	DeleteOption DiskDeleteOptionTypes `json:"deleteOption,omitempty"`
}

// MarshalJSON is the custom marshaler for DataDisk.
func (dd DataDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dd.Lun != nil {
		objectMap["lun"] = dd.Lun
	}
	if dd.Name != nil {
		objectMap["name"] = dd.Name
	}
	if dd.Vhd != nil {
		objectMap["vhd"] = dd.Vhd
	}
	if dd.Image != nil {
		objectMap["image"] = dd.Image
	}
	if dd.Caching != "" {
		objectMap["caching"] = dd.Caching
	}
	if dd.WriteAcceleratorEnabled != nil {
		objectMap["writeAcceleratorEnabled"] = dd.WriteAcceleratorEnabled
	}
	if dd.CreateOption != "" {
		objectMap["createOption"] = dd.CreateOption
	}
	if dd.DiskSizeGB != nil {
		objectMap["diskSizeGB"] = dd.DiskSizeGB
	}
	if dd.ManagedDisk != nil {
		objectMap["managedDisk"] = dd.ManagedDisk
	}
	if dd.ToBeDetached != nil {
		objectMap["toBeDetached"] = dd.ToBeDetached
	}
	if dd.DetachOption != "" {
		objectMap["detachOption"] = dd.DetachOption
	}
	if dd.DeleteOption != "" {
		objectMap["deleteOption"] = dd.DeleteOption
	}
	return json.Marshal(objectMap)
}

// DataDiskImage contains the data disk images information.
type DataDiskImage struct {
	// Lun - READ-ONLY; Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
	Lun *int32 `json:"lun,omitempty"`
}

// MarshalJSON is the custom marshaler for DataDiskImage.
func (ddi DataDiskImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DataDiskImageEncryption contains encryption settings for a data disk image.
type DataDiskImageEncryption struct {
	// Lun - This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
	Lun *int32 `json:"lun,omitempty"`
	// DiskEncryptionSetID - A relative URI containing the resource ID of the disk encryption set.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`
}

// DedicatedHost specifies information about the Dedicated host.
type DedicatedHost struct {
	autorest.Response        `json:"-"`
	*DedicatedHostProperties `json:"properties,omitempty"`
	// Sku - SKU of the dedicated host for Hardware Generation and VM family. Only name is required to be set. List Microsoft.Compute SKUs for a list of possible values.
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DedicatedHost.
func (dh DedicatedHost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dh.DedicatedHostProperties != nil {
		objectMap["properties"] = dh.DedicatedHostProperties
	}
	if dh.Sku != nil {
		objectMap["sku"] = dh.Sku
	}
	if dh.Location != nil {
		objectMap["location"] = dh.Location
	}
	if dh.Tags != nil {
		objectMap["tags"] = dh.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DedicatedHost struct.
func (dh *DedicatedHost) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dedicatedHostProperties DedicatedHostProperties
				err = json.Unmarshal(*v, &dedicatedHostProperties)
				if err != nil {
					return err
				}
				dh.DedicatedHostProperties = &dedicatedHostProperties
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				dh.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dh.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dh.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dh.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dh.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dh.Tags = tags
			}
		}
	}

	return nil
}

// DedicatedHostAllocatableVM represents the dedicated host unutilized capacity in terms of a specific VM
// size.
type DedicatedHostAllocatableVM struct {
	// VMSize - VM size in terms of which the unutilized capacity is represented.
	VMSize *string `json:"vmSize,omitempty"`
	// Count - Maximum number of VMs of size vmSize that can fit in the dedicated host's remaining capacity.
	Count *float64 `json:"count,omitempty"`
}

// DedicatedHostAvailableCapacity dedicated host unutilized capacity.
type DedicatedHostAvailableCapacity struct {
	// AllocatableVMs - The unutilized capacity of the dedicated host represented in terms of each VM size that is allowed to be deployed to the dedicated host.
	AllocatableVMs *[]DedicatedHostAllocatableVM `json:"allocatableVMs,omitempty"`
}

// DedicatedHostGroup specifies information about the dedicated host group that the dedicated hosts should
// be assigned to. <br><br> Currently, a dedicated host can only be added to a dedicated host group at
// creation time. An existing dedicated host cannot be added to another dedicated host group.
type DedicatedHostGroup struct {
	autorest.Response             `json:"-"`
	*DedicatedHostGroupProperties `json:"properties,omitempty"`
	// Zones - Availability Zone to use for this host group. Only single zone is supported. The zone can be assigned only during creation. If not provided, the group supports all zones in the region. If provided, enforces each host in the group to be in the same zone.
	Zones *[]string `json:"zones,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DedicatedHostGroup.
func (dhg DedicatedHostGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dhg.DedicatedHostGroupProperties != nil {
		objectMap["properties"] = dhg.DedicatedHostGroupProperties
	}
	if dhg.Zones != nil {
		objectMap["zones"] = dhg.Zones
	}
	if dhg.Location != nil {
		objectMap["location"] = dhg.Location
	}
	if dhg.Tags != nil {
		objectMap["tags"] = dhg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DedicatedHostGroup struct.
func (dhg *DedicatedHostGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dedicatedHostGroupProperties DedicatedHostGroupProperties
				err = json.Unmarshal(*v, &dedicatedHostGroupProperties)
				if err != nil {
					return err
				}
				dhg.DedicatedHostGroupProperties = &dedicatedHostGroupProperties
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				dhg.Zones = &zones
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dhg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dhg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dhg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dhg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dhg.Tags = tags
			}
		}
	}

	return nil
}

// DedicatedHostGroupInstanceView ...
type DedicatedHostGroupInstanceView struct {
	// Hosts - List of instance view of the dedicated hosts under the dedicated host group.
	Hosts *[]DedicatedHostInstanceViewWithName `json:"hosts,omitempty"`
}

// DedicatedHostGroupListResult the List Dedicated Host Group with resource group response.
type DedicatedHostGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of dedicated host groups
	Value *[]DedicatedHostGroup `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of Dedicated Host Groups. Call ListNext() with this URI to fetch the next page of Dedicated Host Groups.
	NextLink *string `json:"nextLink,omitempty"`
}

// DedicatedHostGroupListResultIterator provides access to a complete listing of DedicatedHostGroup values.
type DedicatedHostGroupListResultIterator struct {
	i    int
	page DedicatedHostGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DedicatedHostGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DedicatedHostGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DedicatedHostGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DedicatedHostGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DedicatedHostGroupListResultIterator) Response() DedicatedHostGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DedicatedHostGroupListResultIterator) Value() DedicatedHostGroup {
	if !iter.page.NotDone() {
		return DedicatedHostGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DedicatedHostGroupListResultIterator type.
func NewDedicatedHostGroupListResultIterator(page DedicatedHostGroupListResultPage) DedicatedHostGroupListResultIterator {
	return DedicatedHostGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dhglr DedicatedHostGroupListResult) IsEmpty() bool {
	return dhglr.Value == nil || len(*dhglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dhglr DedicatedHostGroupListResult) hasNextLink() bool {
	return dhglr.NextLink != nil && len(*dhglr.NextLink) != 0
}

// dedicatedHostGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dhglr DedicatedHostGroupListResult) dedicatedHostGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dhglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dhglr.NextLink)))
}

// DedicatedHostGroupListResultPage contains a page of DedicatedHostGroup values.
type DedicatedHostGroupListResultPage struct {
	fn    func(context.Context, DedicatedHostGroupListResult) (DedicatedHostGroupListResult, error)
	dhglr DedicatedHostGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DedicatedHostGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DedicatedHostGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dhglr)
		if err != nil {
			return err
		}
		page.dhglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DedicatedHostGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DedicatedHostGroupListResultPage) NotDone() bool {
	return !page.dhglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DedicatedHostGroupListResultPage) Response() DedicatedHostGroupListResult {
	return page.dhglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DedicatedHostGroupListResultPage) Values() []DedicatedHostGroup {
	if page.dhglr.IsEmpty() {
		return nil
	}
	return *page.dhglr.Value
}

// Creates a new instance of the DedicatedHostGroupListResultPage type.
func NewDedicatedHostGroupListResultPage(cur DedicatedHostGroupListResult, getNextPage func(context.Context, DedicatedHostGroupListResult) (DedicatedHostGroupListResult, error)) DedicatedHostGroupListResultPage {
	return DedicatedHostGroupListResultPage{
		fn:    getNextPage,
		dhglr: cur,
	}
}

// DedicatedHostGroupProperties dedicated Host Group Properties.
type DedicatedHostGroupProperties struct {
	// PlatformFaultDomainCount - Number of fault domains that the host group can span.
	PlatformFaultDomainCount *int32 `json:"platformFaultDomainCount,omitempty"`
	// Hosts - READ-ONLY; A list of references to all dedicated hosts in the dedicated host group.
	Hosts *[]SubResourceReadOnly `json:"hosts,omitempty"`
	// InstanceView - READ-ONLY; The dedicated host group instance view, which has the list of instance view of the dedicated hosts under the dedicated host group.
	InstanceView *DedicatedHostGroupInstanceView `json:"instanceView,omitempty"`
	// SupportAutomaticPlacement - Specifies whether virtual machines or virtual machine scale sets can be placed automatically on the dedicated host group. Automatic placement means resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host group. The value is defaulted to 'false' when not provided. <br><br>Minimum api-version: 2020-06-01.
	SupportAutomaticPlacement *bool `json:"supportAutomaticPlacement,omitempty"`
}

// MarshalJSON is the custom marshaler for DedicatedHostGroupProperties.
func (dhgp DedicatedHostGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dhgp.PlatformFaultDomainCount != nil {
		objectMap["platformFaultDomainCount"] = dhgp.PlatformFaultDomainCount
	}
	if dhgp.SupportAutomaticPlacement != nil {
		objectMap["supportAutomaticPlacement"] = dhgp.SupportAutomaticPlacement
	}
	return json.Marshal(objectMap)
}

// DedicatedHostGroupUpdate specifies information about the dedicated host group that the dedicated host
// should be assigned to. Only tags may be updated.
type DedicatedHostGroupUpdate struct {
	*DedicatedHostGroupProperties `json:"properties,omitempty"`
	// Zones - Availability Zone to use for this host group. Only single zone is supported. The zone can be assigned only during creation. If not provided, the group supports all zones in the region. If provided, enforces each host in the group to be in the same zone.
	Zones *[]string `json:"zones,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DedicatedHostGroupUpdate.
func (dhgu DedicatedHostGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dhgu.DedicatedHostGroupProperties != nil {
		objectMap["properties"] = dhgu.DedicatedHostGroupProperties
	}
	if dhgu.Zones != nil {
		objectMap["zones"] = dhgu.Zones
	}
	if dhgu.Tags != nil {
		objectMap["tags"] = dhgu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DedicatedHostGroupUpdate struct.
func (dhgu *DedicatedHostGroupUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dedicatedHostGroupProperties DedicatedHostGroupProperties
				err = json.Unmarshal(*v, &dedicatedHostGroupProperties)
				if err != nil {
					return err
				}
				dhgu.DedicatedHostGroupProperties = &dedicatedHostGroupProperties
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				dhgu.Zones = &zones
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dhgu.Tags = tags
			}
		}
	}

	return nil
}

// DedicatedHostInstanceView the instance view of a dedicated host.
type DedicatedHostInstanceView struct {
	// AssetID - READ-ONLY; Specifies the unique id of the dedicated physical machine on which the dedicated host resides.
	AssetID *string `json:"assetId,omitempty"`
	// AvailableCapacity - Unutilized capacity of the dedicated host.
	AvailableCapacity *DedicatedHostAvailableCapacity `json:"availableCapacity,omitempty"`
	// Statuses - The resource status information.
	Statuses *[]InstanceViewStatus `json:"statuses,omitempty"`
}

// MarshalJSON is the custom marshaler for DedicatedHostInstanceView.
func (dhiv DedicatedHostInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dhiv.AvailableCapacity != nil {
		objectMap["availableCapacity"] = dhiv.AvailableCapacity
	}
	if dhiv.Statuses != nil {
		objectMap["statuses"] = dhiv.Statuses
	}
	return json.Marshal(objectMap)
}

// DedicatedHostInstanceViewWithName the instance view of a dedicated host that includes the name of the
// dedicated host. It is used for the response to the instance view of a dedicated host group.
type DedicatedHostInstanceViewWithName struct {
	// Name - READ-ONLY; The name of the dedicated host.
	Name *string `json:"name,omitempty"`
	// AssetID - READ-ONLY; Specifies the unique id of the dedicated physical machine on which the dedicated host resides.
	AssetID *string `json:"assetId,omitempty"`
	// AvailableCapacity - Unutilized capacity of the dedicated host.
	AvailableCapacity *DedicatedHostAvailableCapacity `json:"availableCapacity,omitempty"`
	// Statuses - The resource status information.
	Statuses *[]InstanceViewStatus `json:"statuses,omitempty"`
}

// MarshalJSON is the custom marshaler for DedicatedHostInstanceViewWithName.
func (dhivwn DedicatedHostInstanceViewWithName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dhivwn.AvailableCapacity != nil {
		objectMap["availableCapacity"] = dhivwn.AvailableCapacity
	}
	if dhivwn.Statuses != nil {
		objectMap["statuses"] = dhivwn.Statuses
	}
	return json.Marshal(objectMap)
}

// DedicatedHostListResult the list dedicated host operation response.
type DedicatedHostListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of dedicated hosts
	Value *[]DedicatedHost `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of dedicated hosts. Call ListNext() with this URI to fetch the next page of dedicated hosts.
	NextLink *string `json:"nextLink,omitempty"`
}

// DedicatedHostListResultIterator provides access to a complete listing of DedicatedHost values.
type DedicatedHostListResultIterator struct {
	i    int
	page DedicatedHostListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DedicatedHostListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DedicatedHostListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DedicatedHostListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DedicatedHostListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DedicatedHostListResultIterator) Response() DedicatedHostListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DedicatedHostListResultIterator) Value() DedicatedHost {
	if !iter.page.NotDone() {
		return DedicatedHost{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DedicatedHostListResultIterator type.
func NewDedicatedHostListResultIterator(page DedicatedHostListResultPage) DedicatedHostListResultIterator {
	return DedicatedHostListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dhlr DedicatedHostListResult) IsEmpty() bool {
	return dhlr.Value == nil || len(*dhlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dhlr DedicatedHostListResult) hasNextLink() bool {
	return dhlr.NextLink != nil && len(*dhlr.NextLink) != 0
}

// dedicatedHostListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dhlr DedicatedHostListResult) dedicatedHostListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dhlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dhlr.NextLink)))
}

// DedicatedHostListResultPage contains a page of DedicatedHost values.
type DedicatedHostListResultPage struct {
	fn   func(context.Context, DedicatedHostListResult) (DedicatedHostListResult, error)
	dhlr DedicatedHostListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DedicatedHostListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DedicatedHostListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dhlr)
		if err != nil {
			return err
		}
		page.dhlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DedicatedHostListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DedicatedHostListResultPage) NotDone() bool {
	return !page.dhlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DedicatedHostListResultPage) Response() DedicatedHostListResult {
	return page.dhlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DedicatedHostListResultPage) Values() []DedicatedHost {
	if page.dhlr.IsEmpty() {
		return nil
	}
	return *page.dhlr.Value
}

// Creates a new instance of the DedicatedHostListResultPage type.
func NewDedicatedHostListResultPage(cur DedicatedHostListResult, getNextPage func(context.Context, DedicatedHostListResult) (DedicatedHostListResult, error)) DedicatedHostListResultPage {
	return DedicatedHostListResultPage{
		fn:   getNextPage,
		dhlr: cur,
	}
}

// DedicatedHostProperties properties of the dedicated host.
type DedicatedHostProperties struct {
	// PlatformFaultDomain - Fault domain of the dedicated host within a dedicated host group.
	PlatformFaultDomain *int32 `json:"platformFaultDomain,omitempty"`
	// AutoReplaceOnFailure - Specifies whether the dedicated host should be replaced automatically in case of a failure. The value is defaulted to 'true' when not provided.
	AutoReplaceOnFailure *bool `json:"autoReplaceOnFailure,omitempty"`
	// HostID - READ-ONLY; A unique id generated and assigned to the dedicated host by the platform. <br><br> Does not change throughout the lifetime of the host.
	HostID *string `json:"hostId,omitempty"`
	// VirtualMachines - READ-ONLY; A list of references to all virtual machines in the Dedicated Host.
	VirtualMachines *[]SubResourceReadOnly `json:"virtualMachines,omitempty"`
	// LicenseType - Specifies the software license type that will be applied to the VMs deployed on the dedicated host. <br><br> Possible values are: <br><br> **None** <br><br> **Windows_Server_Hybrid** <br><br> **Windows_Server_Perpetual** <br><br> Default: **None**. Possible values include: 'DedicatedHostLicenseTypesNone', 'DedicatedHostLicenseTypesWindowsServerHybrid', 'DedicatedHostLicenseTypesWindowsServerPerpetual'
	LicenseType DedicatedHostLicenseTypes `json:"licenseType,omitempty"`
	// ProvisioningTime - READ-ONLY; The date when the host was first provisioned.
	ProvisioningTime *date.Time `json:"provisioningTime,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// InstanceView - READ-ONLY; The dedicated host instance view.
	InstanceView *DedicatedHostInstanceView `json:"instanceView,omitempty"`
	// TimeCreated - READ-ONLY; Specifies the time at which the Dedicated Host resource was created.<br><br>Minimum api-version: 2021-11-01.
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
}

// MarshalJSON is the custom marshaler for DedicatedHostProperties.
func (dhp DedicatedHostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dhp.PlatformFaultDomain != nil {
		objectMap["platformFaultDomain"] = dhp.PlatformFaultDomain
	}
	if dhp.AutoReplaceOnFailure != nil {
		objectMap["autoReplaceOnFailure"] = dhp.AutoReplaceOnFailure
	}
	if dhp.LicenseType != "" {
		objectMap["licenseType"] = dhp.LicenseType
	}
	return json.Marshal(objectMap)
}

// DedicatedHostsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DedicatedHostsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DedicatedHostsClient) (DedicatedHost, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DedicatedHostsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DedicatedHostsCreateOrUpdateFuture.Result.
func (future *DedicatedHostsCreateOrUpdateFuture) result(client DedicatedHostsClient) (dh DedicatedHost, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DedicatedHostsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dh.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DedicatedHostsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dh.Response.Response, err = future.GetResult(sender); err == nil && dh.Response.Response.StatusCode != http.StatusNoContent {
		dh, err = client.CreateOrUpdateResponder(dh.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.DedicatedHostsCreateOrUpdateFuture", "Result", dh.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DedicatedHostsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DedicatedHostsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DedicatedHostsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DedicatedHostsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DedicatedHostsDeleteFuture.Result.
func (future *DedicatedHostsDeleteFuture) result(client DedicatedHostsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DedicatedHostsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DedicatedHostsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DedicatedHostsRestartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DedicatedHostsRestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DedicatedHostsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DedicatedHostsRestartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DedicatedHostsRestartFuture.Result.
func (future *DedicatedHostsRestartFuture) result(client DedicatedHostsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DedicatedHostsRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DedicatedHostsRestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DedicatedHostsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DedicatedHostsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DedicatedHostsClient) (DedicatedHost, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DedicatedHostsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DedicatedHostsUpdateFuture.Result.
func (future *DedicatedHostsUpdateFuture) result(client DedicatedHostsClient) (dh DedicatedHost, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DedicatedHostsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dh.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DedicatedHostsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dh.Response.Response, err = future.GetResult(sender); err == nil && dh.Response.Response.StatusCode != http.StatusNoContent {
		dh, err = client.UpdateResponder(dh.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.DedicatedHostsUpdateFuture", "Result", dh.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DedicatedHostUpdate specifies information about the dedicated host. Only tags, autoReplaceOnFailure and
// licenseType may be updated.
type DedicatedHostUpdate struct {
	*DedicatedHostProperties `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DedicatedHostUpdate.
func (dhu DedicatedHostUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dhu.DedicatedHostProperties != nil {
		objectMap["properties"] = dhu.DedicatedHostProperties
	}
	if dhu.Tags != nil {
		objectMap["tags"] = dhu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DedicatedHostUpdate struct.
func (dhu *DedicatedHostUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dedicatedHostProperties DedicatedHostProperties
				err = json.Unmarshal(*v, &dedicatedHostProperties)
				if err != nil {
					return err
				}
				dhu.DedicatedHostProperties = &dedicatedHostProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dhu.Tags = tags
			}
		}
	}

	return nil
}

// DiagnosticsProfile specifies the boot diagnostic settings state. <br><br>Minimum api-version:
// 2015-06-15.
type DiagnosticsProfile struct {
	// BootDiagnostics - Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br>**NOTE**: If storageUri is being specified then ensure that the storage account is in the same region and subscription as the VM. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
	BootDiagnostics *BootDiagnostics `json:"bootDiagnostics,omitempty"`
}

// DiffDiskSettings describes the parameters of ephemeral disk settings that can be specified for operating
// system disk. <br><br> NOTE: The ephemeral disk settings can only be specified for managed disk.
type DiffDiskSettings struct {
	// Option - Specifies the ephemeral disk settings for operating system disk. Possible values include: 'DiffDiskOptionsLocal'
	Option DiffDiskOptions `json:"option,omitempty"`
	// Placement - Specifies the ephemeral disk placement for operating system disk.<br><br> Possible values are: <br><br> **CacheDisk** <br><br> **ResourceDisk** <br><br> Default: **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** is used.<br><br> Refer to VM size documentation for Windows VM at https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk. Possible values include: 'DiffDiskPlacementCacheDisk', 'DiffDiskPlacementResourceDisk'
	Placement DiffDiskPlacement `json:"placement,omitempty"`
}

// Disallowed describes the disallowed disk types.
type Disallowed struct {
	// DiskTypes - A list of disk types.
	DiskTypes *[]string `json:"diskTypes,omitempty"`
}

// DisallowedConfiguration specifies the disallowed configuration for a virtual machine image.
type DisallowedConfiguration struct {
	// VMDiskType - VM disk types which are disallowed. Possible values include: 'VMDiskTypesNone', 'VMDiskTypesUnmanaged'
	VMDiskType VMDiskTypes `json:"vmDiskType,omitempty"`
}

// Disk disk resource.
type Disk struct {
	autorest.Response `json:"-"`
	// ManagedBy - READ-ONLY; A relative URI containing the ID of the VM that has the disk attached.
	ManagedBy *string `json:"managedBy,omitempty"`
	// ManagedByExtended - READ-ONLY; List of relative URIs containing the IDs of the VMs that have the disk attached. maxShares should be set to a value greater than one for disks to allow attaching them to multiple VMs.
	ManagedByExtended *[]string `json:"managedByExtended,omitempty"`
	Sku               *DiskSku  `json:"sku,omitempty"`
	// Zones - The Logical zone list for Disk.
	Zones *[]string `json:"zones,omitempty"`
	// ExtendedLocation - The extended location where the disk will be created. Extended location cannot be changed.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	*DiskProperties  `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Disk.
func (d Disk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.Sku != nil {
		objectMap["sku"] = d.Sku
	}
	if d.Zones != nil {
		objectMap["zones"] = d.Zones
	}
	if d.ExtendedLocation != nil {
		objectMap["extendedLocation"] = d.ExtendedLocation
	}
	if d.DiskProperties != nil {
		objectMap["properties"] = d.DiskProperties
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Disk struct.
func (d *Disk) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				d.ManagedBy = &managedBy
			}
		case "managedByExtended":
			if v != nil {
				var managedByExtended []string
				err = json.Unmarshal(*v, &managedByExtended)
				if err != nil {
					return err
				}
				d.ManagedByExtended = &managedByExtended
			}
		case "sku":
			if v != nil {
				var sku DiskSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				d.Sku = &sku
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				d.Zones = &zones
			}
		case "extendedLocation":
			if v != nil {
				var extendedLocation ExtendedLocation
				err = json.Unmarshal(*v, &extendedLocation)
				if err != nil {
					return err
				}
				d.ExtendedLocation = &extendedLocation
			}
		case "properties":
			if v != nil {
				var diskProperties DiskProperties
				err = json.Unmarshal(*v, &diskProperties)
				if err != nil {
					return err
				}
				d.DiskProperties = &diskProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		}
	}

	return nil
}

// DiskAccess disk access resource.
type DiskAccess struct {
	autorest.Response     `json:"-"`
	*DiskAccessProperties `json:"properties,omitempty"`
	// ExtendedLocation - The extended location where the disk access will be created. Extended location cannot be changed.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DiskAccess.
func (da DiskAccess) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if da.DiskAccessProperties != nil {
		objectMap["properties"] = da.DiskAccessProperties
	}
	if da.ExtendedLocation != nil {
		objectMap["extendedLocation"] = da.ExtendedLocation
	}
	if da.Location != nil {
		objectMap["location"] = da.Location
	}
	if da.Tags != nil {
		objectMap["tags"] = da.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiskAccess struct.
func (da *DiskAccess) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diskAccessProperties DiskAccessProperties
				err = json.Unmarshal(*v, &diskAccessProperties)
				if err != nil {
					return err
				}
				da.DiskAccessProperties = &diskAccessProperties
			}
		case "extendedLocation":
			if v != nil {
				var extendedLocation ExtendedLocation
				err = json.Unmarshal(*v, &extendedLocation)
				if err != nil {
					return err
				}
				da.ExtendedLocation = &extendedLocation
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				da.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				da.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				da.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				da.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				da.Tags = tags
			}
		}
	}

	return nil
}

// DiskAccessesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DiskAccessesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskAccessesClient) (DiskAccess, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskAccessesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskAccessesCreateOrUpdateFuture.Result.
func (future *DiskAccessesCreateOrUpdateFuture) result(client DiskAccessesClient) (da DiskAccess, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DiskAccessesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		da.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DiskAccessesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if da.Response.Response, err = future.GetResult(sender); err == nil && da.Response.Response.StatusCode != http.StatusNoContent {
		da, err = client.CreateOrUpdateResponder(da.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.DiskAccessesCreateOrUpdateFuture", "Result", da.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DiskAccessesDeleteAPrivateEndpointConnectionFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DiskAccessesDeleteAPrivateEndpointConnectionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskAccessesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskAccessesDeleteAPrivateEndpointConnectionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskAccessesDeleteAPrivateEndpointConnectionFuture.Result.
func (future *DiskAccessesDeleteAPrivateEndpointConnectionFuture) result(client DiskAccessesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DiskAccessesDeleteAPrivateEndpointConnectionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DiskAccessesDeleteAPrivateEndpointConnectionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DiskAccessesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DiskAccessesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskAccessesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskAccessesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskAccessesDeleteFuture.Result.
func (future *DiskAccessesDeleteFuture) result(client DiskAccessesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DiskAccessesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DiskAccessesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DiskAccessesUpdateAPrivateEndpointConnectionFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DiskAccessesUpdateAPrivateEndpointConnectionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskAccessesClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskAccessesUpdateAPrivateEndpointConnectionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskAccessesUpdateAPrivateEndpointConnectionFuture.Result.
func (future *DiskAccessesUpdateAPrivateEndpointConnectionFuture) result(client DiskAccessesClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DiskAccessesUpdateAPrivateEndpointConnectionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DiskAccessesUpdateAPrivateEndpointConnectionFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.UpdateAPrivateEndpointConnectionResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.DiskAccessesUpdateAPrivateEndpointConnectionFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DiskAccessesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DiskAccessesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskAccessesClient) (DiskAccess, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskAccessesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskAccessesUpdateFuture.Result.
func (future *DiskAccessesUpdateFuture) result(client DiskAccessesClient) (da DiskAccess, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DiskAccessesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		da.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DiskAccessesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if da.Response.Response, err = future.GetResult(sender); err == nil && da.Response.Response.StatusCode != http.StatusNoContent {
		da, err = client.UpdateResponder(da.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.DiskAccessesUpdateFuture", "Result", da.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DiskAccessList the List disk access operation response.
type DiskAccessList struct {
	autorest.Response `json:"-"`
	// Value - A list of disk access resources.
	Value *[]DiskAccess `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of disk access resources. Call ListNext() with this to fetch the next page of disk access resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// DiskAccessListIterator provides access to a complete listing of DiskAccess values.
type DiskAccessListIterator struct {
	i    int
	page DiskAccessListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiskAccessListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskAccessListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiskAccessListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiskAccessListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiskAccessListIterator) Response() DiskAccessList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiskAccessListIterator) Value() DiskAccess {
	if !iter.page.NotDone() {
		return DiskAccess{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiskAccessListIterator type.
func NewDiskAccessListIterator(page DiskAccessListPage) DiskAccessListIterator {
	return DiskAccessListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dal DiskAccessList) IsEmpty() bool {
	return dal.Value == nil || len(*dal.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dal DiskAccessList) hasNextLink() bool {
	return dal.NextLink != nil && len(*dal.NextLink) != 0
}

// diskAccessListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dal DiskAccessList) diskAccessListPreparer(ctx context.Context) (*http.Request, error) {
	if !dal.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dal.NextLink)))
}

// DiskAccessListPage contains a page of DiskAccess values.
type DiskAccessListPage struct {
	fn  func(context.Context, DiskAccessList) (DiskAccessList, error)
	dal DiskAccessList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiskAccessListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskAccessListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dal)
		if err != nil {
			return err
		}
		page.dal = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiskAccessListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiskAccessListPage) NotDone() bool {
	return !page.dal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiskAccessListPage) Response() DiskAccessList {
	return page.dal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiskAccessListPage) Values() []DiskAccess {
	if page.dal.IsEmpty() {
		return nil
	}
	return *page.dal.Value
}

// Creates a new instance of the DiskAccessListPage type.
func NewDiskAccessListPage(cur DiskAccessList, getNextPage func(context.Context, DiskAccessList) (DiskAccessList, error)) DiskAccessListPage {
	return DiskAccessListPage{
		fn:  getNextPage,
		dal: cur,
	}
}

// DiskAccessProperties ...
type DiskAccessProperties struct {
	// PrivateEndpointConnections - READ-ONLY; A readonly collection of private endpoint connections created on the disk. Currently only one endpoint connection is supported.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// ProvisioningState - READ-ONLY; The disk access resource provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// TimeCreated - READ-ONLY; The time when the disk access was created.
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskAccessProperties.
func (dap DiskAccessProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DiskAccessUpdate used for updating a disk access resource.
type DiskAccessUpdate struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DiskAccessUpdate.
func (dau DiskAccessUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dau.Tags != nil {
		objectMap["tags"] = dau.Tags
	}
	return json.Marshal(objectMap)
}

// DiskEncryptionSet disk encryption set resource.
type DiskEncryptionSet struct {
	autorest.Response        `json:"-"`
	Identity                 *EncryptionSetIdentity `json:"identity,omitempty"`
	*EncryptionSetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DiskEncryptionSet.
func (desVar DiskEncryptionSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if desVar.Identity != nil {
		objectMap["identity"] = desVar.Identity
	}
	if desVar.EncryptionSetProperties != nil {
		objectMap["properties"] = desVar.EncryptionSetProperties
	}
	if desVar.Location != nil {
		objectMap["location"] = desVar.Location
	}
	if desVar.Tags != nil {
		objectMap["tags"] = desVar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiskEncryptionSet struct.
func (desVar *DiskEncryptionSet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity EncryptionSetIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				desVar.Identity = &identity
			}
		case "properties":
			if v != nil {
				var encryptionSetProperties EncryptionSetProperties
				err = json.Unmarshal(*v, &encryptionSetProperties)
				if err != nil {
					return err
				}
				desVar.EncryptionSetProperties = &encryptionSetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				desVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				desVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				desVar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				desVar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				desVar.Tags = tags
			}
		}
	}

	return nil
}

// DiskEncryptionSetList the List disk encryption set operation response.
type DiskEncryptionSetList struct {
	autorest.Response `json:"-"`
	// Value - A list of disk encryption sets.
	Value *[]DiskEncryptionSet `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of disk encryption sets. Call ListNext() with this to fetch the next page of disk encryption sets.
	NextLink *string `json:"nextLink,omitempty"`
}

// DiskEncryptionSetListIterator provides access to a complete listing of DiskEncryptionSet values.
type DiskEncryptionSetListIterator struct {
	i    int
	page DiskEncryptionSetListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiskEncryptionSetListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskEncryptionSetListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiskEncryptionSetListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiskEncryptionSetListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiskEncryptionSetListIterator) Response() DiskEncryptionSetList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiskEncryptionSetListIterator) Value() DiskEncryptionSet {
	if !iter.page.NotDone() {
		return DiskEncryptionSet{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiskEncryptionSetListIterator type.
func NewDiskEncryptionSetListIterator(page DiskEncryptionSetListPage) DiskEncryptionSetListIterator {
	return DiskEncryptionSetListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (desl DiskEncryptionSetList) IsEmpty() bool {
	return desl.Value == nil || len(*desl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (desl DiskEncryptionSetList) hasNextLink() bool {
	return desl.NextLink != nil && len(*desl.NextLink) != 0
}

// diskEncryptionSetListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (desl DiskEncryptionSetList) diskEncryptionSetListPreparer(ctx context.Context) (*http.Request, error) {
	if !desl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(desl.NextLink)))
}

// DiskEncryptionSetListPage contains a page of DiskEncryptionSet values.
type DiskEncryptionSetListPage struct {
	fn   func(context.Context, DiskEncryptionSetList) (DiskEncryptionSetList, error)
	desl DiskEncryptionSetList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiskEncryptionSetListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskEncryptionSetListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.desl)
		if err != nil {
			return err
		}
		page.desl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiskEncryptionSetListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiskEncryptionSetListPage) NotDone() bool {
	return !page.desl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiskEncryptionSetListPage) Response() DiskEncryptionSetList {
	return page.desl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiskEncryptionSetListPage) Values() []DiskEncryptionSet {
	if page.desl.IsEmpty() {
		return nil
	}
	return *page.desl.Value
}

// Creates a new instance of the DiskEncryptionSetListPage type.
func NewDiskEncryptionSetListPage(cur DiskEncryptionSetList, getNextPage func(context.Context, DiskEncryptionSetList) (DiskEncryptionSetList, error)) DiskEncryptionSetListPage {
	return DiskEncryptionSetListPage{
		fn:   getNextPage,
		desl: cur,
	}
}

// DiskEncryptionSetParameters describes the parameter of customer managed disk encryption set resource id
// that can be specified for disk. <br><br> NOTE: The disk encryption set resource id can only be specified
// for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more details.
type DiskEncryptionSetParameters struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// DiskEncryptionSetsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DiskEncryptionSetsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskEncryptionSetsClient) (DiskEncryptionSet, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskEncryptionSetsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskEncryptionSetsCreateOrUpdateFuture.Result.
func (future *DiskEncryptionSetsCreateOrUpdateFuture) result(client DiskEncryptionSetsClient) (desVar DiskEncryptionSet, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DiskEncryptionSetsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		desVar.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DiskEncryptionSetsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if desVar.Response.Response, err = future.GetResult(sender); err == nil && desVar.Response.Response.StatusCode != http.StatusNoContent {
		desVar, err = client.CreateOrUpdateResponder(desVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.DiskEncryptionSetsCreateOrUpdateFuture", "Result", desVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DiskEncryptionSetsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DiskEncryptionSetsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskEncryptionSetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskEncryptionSetsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskEncryptionSetsDeleteFuture.Result.
func (future *DiskEncryptionSetsDeleteFuture) result(client DiskEncryptionSetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DiskEncryptionSetsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DiskEncryptionSetsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DiskEncryptionSetsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DiskEncryptionSetsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskEncryptionSetsClient) (DiskEncryptionSet, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskEncryptionSetsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskEncryptionSetsUpdateFuture.Result.
func (future *DiskEncryptionSetsUpdateFuture) result(client DiskEncryptionSetsClient) (desVar DiskEncryptionSet, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DiskEncryptionSetsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		desVar.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DiskEncryptionSetsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if desVar.Response.Response, err = future.GetResult(sender); err == nil && desVar.Response.Response.StatusCode != http.StatusNoContent {
		desVar, err = client.UpdateResponder(desVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.DiskEncryptionSetsUpdateFuture", "Result", desVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DiskEncryptionSettings describes a Encryption Settings for a Disk
type DiskEncryptionSettings struct {
	// DiskEncryptionKey - Specifies the location of the disk encryption key, which is a Key Vault Secret.
	DiskEncryptionKey *KeyVaultSecretReference `json:"diskEncryptionKey,omitempty"`
	// KeyEncryptionKey - Specifies the location of the key encryption key in Key Vault.
	KeyEncryptionKey *KeyVaultKeyReference `json:"keyEncryptionKey,omitempty"`
	// Enabled - Specifies whether disk encryption should be enabled on the virtual machine.
	Enabled *bool `json:"enabled,omitempty"`
}

// DiskEncryptionSetUpdate disk encryption set update resource.
type DiskEncryptionSetUpdate struct {
	*DiskEncryptionSetUpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags     map[string]*string     `json:"tags"`
	Identity *EncryptionSetIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskEncryptionSetUpdate.
func (desu DiskEncryptionSetUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if desu.DiskEncryptionSetUpdateProperties != nil {
		objectMap["properties"] = desu.DiskEncryptionSetUpdateProperties
	}
	if desu.Tags != nil {
		objectMap["tags"] = desu.Tags
	}
	if desu.Identity != nil {
		objectMap["identity"] = desu.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiskEncryptionSetUpdate struct.
func (desu *DiskEncryptionSetUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diskEncryptionSetUpdateProperties DiskEncryptionSetUpdateProperties
				err = json.Unmarshal(*v, &diskEncryptionSetUpdateProperties)
				if err != nil {
					return err
				}
				desu.DiskEncryptionSetUpdateProperties = &diskEncryptionSetUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				desu.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity EncryptionSetIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				desu.Identity = &identity
			}
		}
	}

	return nil
}

// DiskEncryptionSetUpdateProperties disk encryption set resource update properties.
type DiskEncryptionSetUpdateProperties struct {
	// EncryptionType - Possible values include: 'DiskEncryptionSetTypeEncryptionAtRestWithCustomerKey', 'DiskEncryptionSetTypeEncryptionAtRestWithPlatformAndCustomerKeys', 'DiskEncryptionSetTypeConfidentialVMEncryptedWithCustomerKey'
	EncryptionType DiskEncryptionSetType    `json:"encryptionType,omitempty"`
	ActiveKey      *KeyForDiskEncryptionSet `json:"activeKey,omitempty"`
	// RotationToLatestKeyVersionEnabled - Set this flag to true to enable auto-updating of this disk encryption set to the latest key version.
	RotationToLatestKeyVersionEnabled *bool `json:"rotationToLatestKeyVersionEnabled,omitempty"`
}

// DiskImageEncryption this is the disk image encryption base class.
type DiskImageEncryption struct {
	// DiskEncryptionSetID - A relative URI containing the resource ID of the disk encryption set.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`
}

// DiskInstanceView the instance view of the disk.
type DiskInstanceView struct {
	// Name - The disk name.
	Name *string `json:"name,omitempty"`
	// EncryptionSettings - Specifies the encryption settings for the OS Disk. <br><br> Minimum api-version: 2015-06-15
	EncryptionSettings *[]DiskEncryptionSettings `json:"encryptionSettings,omitempty"`
	// Statuses - The resource status information.
	Statuses *[]InstanceViewStatus `json:"statuses,omitempty"`
}

// DiskList the List Disks operation response.
type DiskList struct {
	autorest.Response `json:"-"`
	// Value - A list of disks.
	Value *[]Disk `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of disks. Call ListNext() with this to fetch the next page of disks.
	NextLink *string `json:"nextLink,omitempty"`
}

// DiskListIterator provides access to a complete listing of Disk values.
type DiskListIterator struct {
	i    int
	page DiskListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiskListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiskListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiskListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiskListIterator) Response() DiskList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiskListIterator) Value() Disk {
	if !iter.page.NotDone() {
		return Disk{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiskListIterator type.
func NewDiskListIterator(page DiskListPage) DiskListIterator {
	return DiskListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dl DiskList) IsEmpty() bool {
	return dl.Value == nil || len(*dl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dl DiskList) hasNextLink() bool {
	return dl.NextLink != nil && len(*dl.NextLink) != 0
}

// diskListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dl DiskList) diskListPreparer(ctx context.Context) (*http.Request, error) {
	if !dl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dl.NextLink)))
}

// DiskListPage contains a page of Disk values.
type DiskListPage struct {
	fn func(context.Context, DiskList) (DiskList, error)
	dl DiskList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiskListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dl)
		if err != nil {
			return err
		}
		page.dl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiskListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiskListPage) NotDone() bool {
	return !page.dl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiskListPage) Response() DiskList {
	return page.dl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiskListPage) Values() []Disk {
	if page.dl.IsEmpty() {
		return nil
	}
	return *page.dl.Value
}

// Creates a new instance of the DiskListPage type.
func NewDiskListPage(cur DiskList, getNextPage func(context.Context, DiskList) (DiskList, error)) DiskListPage {
	return DiskListPage{
		fn: getNextPage,
		dl: cur,
	}
}

// DiskProperties disk resource properties.
type DiskProperties struct {
	// TimeCreated - READ-ONLY; The time when the disk was created.
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
	// OsType - The Operating System type. Possible values include: 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// HyperVGeneration - The hypervisor generation of the Virtual Machine. Applicable to OS disks only. Possible values include: 'HyperVGenerationV1', 'HyperVGenerationV2'
	HyperVGeneration HyperVGeneration `json:"hyperVGeneration,omitempty"`
	// PurchasePlan - Purchase plan information for the the image from which the OS disk was created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product: WindowsServer}
	PurchasePlan *PurchasePlan `json:"purchasePlan,omitempty"`
	// SupportedCapabilities - List of supported capabilities for the image from which the OS disk was created.
	SupportedCapabilities *SupportedCapabilities `json:"supportedCapabilities,omitempty"`
	// CreationData - Disk source information. CreationData information cannot be changed after the disk has been created.
	CreationData *CreationData `json:"creationData,omitempty"`
	// DiskSizeGB - If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
	// DiskSizeBytes - READ-ONLY; The size of the disk in bytes. This field is read only.
	DiskSizeBytes *int64 `json:"diskSizeBytes,omitempty"`
	// UniqueID - READ-ONLY; Unique Guid identifying the resource.
	UniqueID *string `json:"uniqueId,omitempty"`
	// EncryptionSettingsCollection - Encryption settings collection used for Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
	EncryptionSettingsCollection *EncryptionSettingsCollection `json:"encryptionSettingsCollection,omitempty"`
	// ProvisioningState - READ-ONLY; The disk provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// DiskIOPSReadWrite - The number of IOPS allowed for this disk; only settable for UltraSSD disks. One operation can transfer between 4k and 256k bytes.
	DiskIOPSReadWrite *int64 `json:"diskIOPSReadWrite,omitempty"`
	// DiskMBpsReadWrite - The bandwidth allowed for this disk; only settable for UltraSSD disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
	DiskMBpsReadWrite *int64 `json:"diskMBpsReadWrite,omitempty"`
	// DiskIOPSReadOnly - The total number of IOPS that will be allowed across all VMs mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
	DiskIOPSReadOnly *int64 `json:"diskIOPSReadOnly,omitempty"`
	// DiskMBpsReadOnly - The total throughput (MBps) that will be allowed across all VMs mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
	DiskMBpsReadOnly *int64 `json:"diskMBpsReadOnly,omitempty"`
	// DiskState - The state of the disk. Possible values include: 'DiskStateUnattached', 'DiskStateAttached', 'DiskStateReserved', 'DiskStateFrozen', 'DiskStateActiveSAS', 'DiskStateActiveSASFrozen', 'DiskStateReadyToUpload', 'DiskStateActiveUpload'
	DiskState DiskState `json:"diskState,omitempty"`
	// Encryption - Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
	Encryption *Encryption `json:"encryption,omitempty"`
	// MaxShares - The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
	MaxShares *int32 `json:"maxShares,omitempty"`
	// ShareInfo - READ-ONLY; Details of the list of all VMs that have the disk attached. maxShares should be set to a value greater than one for disks to allow attaching them to multiple VMs.
	ShareInfo *[]ShareInfoElement `json:"shareInfo,omitempty"`
	// NetworkAccessPolicy - Possible values include: 'NetworkAccessPolicyAllowAll', 'NetworkAccessPolicyAllowPrivate', 'NetworkAccessPolicyDenyAll'
	NetworkAccessPolicy NetworkAccessPolicy `json:"networkAccessPolicy,omitempty"`
	// DiskAccessID - ARM id of the DiskAccess resource for using private endpoints on disks.
	DiskAccessID *string `json:"diskAccessId,omitempty"`
	// Tier - Performance tier of the disk (e.g, P4, S10) as described here: https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra disks.
	Tier *string `json:"tier,omitempty"`
	// BurstingEnabled - Set to true to enable bursting beyond the provisioned performance target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
	BurstingEnabled *bool `json:"burstingEnabled,omitempty"`
	// PropertyUpdatesInProgress - READ-ONLY; Properties of the disk for which update is pending.
	PropertyUpdatesInProgress *PropertyUpdatesInProgress `json:"propertyUpdatesInProgress,omitempty"`
	// SupportsHibernation - Indicates the OS on a disk supports hibernation.
	SupportsHibernation *bool `json:"supportsHibernation,omitempty"`
	// SecurityProfile - Contains the security related information for the resource.
	SecurityProfile *DiskSecurityProfile `json:"securityProfile,omitempty"`
	// CompletionPercent - Percentage complete for the background copy when a resource is created via the CopyStart operation.
	CompletionPercent *float64 `json:"completionPercent,omitempty"`
	// PublicNetworkAccess - Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskProperties.
func (dp DiskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.OsType != "" {
		objectMap["osType"] = dp.OsType
	}
	if dp.HyperVGeneration != "" {
		objectMap["hyperVGeneration"] = dp.HyperVGeneration
	}
	if dp.PurchasePlan != nil {
		objectMap["purchasePlan"] = dp.PurchasePlan
	}
	if dp.SupportedCapabilities != nil {
		objectMap["supportedCapabilities"] = dp.SupportedCapabilities
	}
	if dp.CreationData != nil {
		objectMap["creationData"] = dp.CreationData
	}
	if dp.DiskSizeGB != nil {
		objectMap["diskSizeGB"] = dp.DiskSizeGB
	}
	if dp.EncryptionSettingsCollection != nil {
		objectMap["encryptionSettingsCollection"] = dp.EncryptionSettingsCollection
	}
	if dp.DiskIOPSReadWrite != nil {
		objectMap["diskIOPSReadWrite"] = dp.DiskIOPSReadWrite
	}
	if dp.DiskMBpsReadWrite != nil {
		objectMap["diskMBpsReadWrite"] = dp.DiskMBpsReadWrite
	}
	if dp.DiskIOPSReadOnly != nil {
		objectMap["diskIOPSReadOnly"] = dp.DiskIOPSReadOnly
	}
	if dp.DiskMBpsReadOnly != nil {
		objectMap["diskMBpsReadOnly"] = dp.DiskMBpsReadOnly
	}
	if dp.DiskState != "" {
		objectMap["diskState"] = dp.DiskState
	}
	if dp.Encryption != nil {
		objectMap["encryption"] = dp.Encryption
	}
	if dp.MaxShares != nil {
		objectMap["maxShares"] = dp.MaxShares
	}
	if dp.NetworkAccessPolicy != "" {
		objectMap["networkAccessPolicy"] = dp.NetworkAccessPolicy
	}
	if dp.DiskAccessID != nil {
		objectMap["diskAccessId"] = dp.DiskAccessID
	}
	if dp.Tier != nil {
		objectMap["tier"] = dp.Tier
	}
	if dp.BurstingEnabled != nil {
		objectMap["burstingEnabled"] = dp.BurstingEnabled
	}
	if dp.SupportsHibernation != nil {
		objectMap["supportsHibernation"] = dp.SupportsHibernation
	}
	if dp.SecurityProfile != nil {
		objectMap["securityProfile"] = dp.SecurityProfile
	}
	if dp.CompletionPercent != nil {
		objectMap["completionPercent"] = dp.CompletionPercent
	}
	if dp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = dp.PublicNetworkAccess
	}
	return json.Marshal(objectMap)
}

// DiskRestorePoint properties of disk restore point
type DiskRestorePoint struct {
	autorest.Response           `json:"-"`
	*DiskRestorePointProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskRestorePoint.
func (drp DiskRestorePoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if drp.DiskRestorePointProperties != nil {
		objectMap["properties"] = drp.DiskRestorePointProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiskRestorePoint struct.
func (drp *DiskRestorePoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diskRestorePointProperties DiskRestorePointProperties
				err = json.Unmarshal(*v, &diskRestorePointProperties)
				if err != nil {
					return err
				}
				drp.DiskRestorePointProperties = &diskRestorePointProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				drp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				drp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				drp.Type = &typeVar
			}
		}
	}

	return nil
}

// DiskRestorePointGrantAccessFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DiskRestorePointGrantAccessFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskRestorePointClient) (AccessURI, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskRestorePointGrantAccessFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskRestorePointGrantAccessFuture.Result.
func (future *DiskRestorePointGrantAccessFuture) result(client DiskRestorePointClient) (au AccessURI, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DiskRestorePointGrantAccessFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		au.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DiskRestorePointGrantAccessFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if au.Response.Response, err = future.GetResult(sender); err == nil && au.Response.Response.StatusCode != http.StatusNoContent {
		au, err = client.GrantAccessResponder(au.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.DiskRestorePointGrantAccessFuture", "Result", au.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DiskRestorePointInstanceView the instance view of a disk restore point.
type DiskRestorePointInstanceView struct {
	// ID - Disk restore point Id.
	ID *string `json:"id,omitempty"`
	// ReplicationStatus - The disk restore point replication status information.
	ReplicationStatus interface{} `json:"replicationStatus,omitempty"`
}

// DiskRestorePointList the List Disk Restore Points operation response.
type DiskRestorePointList struct {
	autorest.Response `json:"-"`
	// Value - A list of disk restore points.
	Value *[]DiskRestorePoint `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of disk restore points. Call ListNext() with this to fetch the next page of disk restore points.
	NextLink *string `json:"nextLink,omitempty"`
}

// DiskRestorePointListIterator provides access to a complete listing of DiskRestorePoint values.
type DiskRestorePointListIterator struct {
	i    int
	page DiskRestorePointListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiskRestorePointListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskRestorePointListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiskRestorePointListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiskRestorePointListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiskRestorePointListIterator) Response() DiskRestorePointList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiskRestorePointListIterator) Value() DiskRestorePoint {
	if !iter.page.NotDone() {
		return DiskRestorePoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiskRestorePointListIterator type.
func NewDiskRestorePointListIterator(page DiskRestorePointListPage) DiskRestorePointListIterator {
	return DiskRestorePointListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (drpl DiskRestorePointList) IsEmpty() bool {
	return drpl.Value == nil || len(*drpl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (drpl DiskRestorePointList) hasNextLink() bool {
	return drpl.NextLink != nil && len(*drpl.NextLink) != 0
}

// diskRestorePointListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (drpl DiskRestorePointList) diskRestorePointListPreparer(ctx context.Context) (*http.Request, error) {
	if !drpl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(drpl.NextLink)))
}

// DiskRestorePointListPage contains a page of DiskRestorePoint values.
type DiskRestorePointListPage struct {
	fn   func(context.Context, DiskRestorePointList) (DiskRestorePointList, error)
	drpl DiskRestorePointList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiskRestorePointListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskRestorePointListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.drpl)
		if err != nil {
			return err
		}
		page.drpl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiskRestorePointListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiskRestorePointListPage) NotDone() bool {
	return !page.drpl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiskRestorePointListPage) Response() DiskRestorePointList {
	return page.drpl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiskRestorePointListPage) Values() []DiskRestorePoint {
	if page.drpl.IsEmpty() {
		return nil
	}
	return *page.drpl.Value
}

// Creates a new instance of the DiskRestorePointListPage type.
func NewDiskRestorePointListPage(cur DiskRestorePointList, getNextPage func(context.Context, DiskRestorePointList) (DiskRestorePointList, error)) DiskRestorePointListPage {
	return DiskRestorePointListPage{
		fn:   getNextPage,
		drpl: cur,
	}
}

// DiskRestorePointProperties properties of an incremental disk restore point
type DiskRestorePointProperties struct {
	// TimeCreated - READ-ONLY; The timestamp of restorePoint creation
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
	// SourceResourceID - READ-ONLY; arm id of source disk or source disk restore point.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// OsType - READ-ONLY; The Operating System type. Possible values include: 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// HyperVGeneration - The hypervisor generation of the Virtual Machine. Applicable to OS disks only. Possible values include: 'HyperVGenerationV1', 'HyperVGenerationV2'
	HyperVGeneration HyperVGeneration `json:"hyperVGeneration,omitempty"`
	// PurchasePlan - Purchase plan information for the the image from which the OS disk was created.
	PurchasePlan *PurchasePlan `json:"purchasePlan,omitempty"`
	// SupportedCapabilities - List of supported capabilities (like accelerated networking) for the image from which the OS disk was created.
	SupportedCapabilities *SupportedCapabilities `json:"supportedCapabilities,omitempty"`
	// FamilyID - READ-ONLY; id of the backing snapshot's MIS family
	FamilyID *string `json:"familyId,omitempty"`
	// SourceUniqueID - READ-ONLY; unique incarnation id of the source disk
	SourceUniqueID *string `json:"sourceUniqueId,omitempty"`
	// Encryption - READ-ONLY; Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
	Encryption *Encryption `json:"encryption,omitempty"`
	// SupportsHibernation - Indicates the OS on a disk supports hibernation.
	SupportsHibernation *bool `json:"supportsHibernation,omitempty"`
	// NetworkAccessPolicy - Possible values include: 'NetworkAccessPolicyAllowAll', 'NetworkAccessPolicyAllowPrivate', 'NetworkAccessPolicyDenyAll'
	NetworkAccessPolicy NetworkAccessPolicy `json:"networkAccessPolicy,omitempty"`
	// PublicNetworkAccess - Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// DiskAccessID - ARM id of the DiskAccess resource for using private endpoints on disks.
	DiskAccessID *string `json:"diskAccessId,omitempty"`
	// CompletionPercent - Percentage complete for the background copy of disk restore point when source resource is from a different region.
	CompletionPercent *float64 `json:"completionPercent,omitempty"`
	// ReplicationState - READ-ONLY; Replication state of disk restore point when source resource is from a different region.
	ReplicationState *string `json:"replicationState,omitempty"`
	// SourceResourceLocation - READ-ONLY; Location of source disk or source disk restore point when source resource is from a different region.
	SourceResourceLocation *string `json:"sourceResourceLocation,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskRestorePointProperties.
func (drpp DiskRestorePointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if drpp.HyperVGeneration != "" {
		objectMap["hyperVGeneration"] = drpp.HyperVGeneration
	}
	if drpp.PurchasePlan != nil {
		objectMap["purchasePlan"] = drpp.PurchasePlan
	}
	if drpp.SupportedCapabilities != nil {
		objectMap["supportedCapabilities"] = drpp.SupportedCapabilities
	}
	if drpp.SupportsHibernation != nil {
		objectMap["supportsHibernation"] = drpp.SupportsHibernation
	}
	if drpp.NetworkAccessPolicy != "" {
		objectMap["networkAccessPolicy"] = drpp.NetworkAccessPolicy
	}
	if drpp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = drpp.PublicNetworkAccess
	}
	if drpp.DiskAccessID != nil {
		objectMap["diskAccessId"] = drpp.DiskAccessID
	}
	if drpp.CompletionPercent != nil {
		objectMap["completionPercent"] = drpp.CompletionPercent
	}
	return json.Marshal(objectMap)
}

// DiskRestorePointReplicationStatus the instance view of a disk restore point.
type DiskRestorePointReplicationStatus struct {
	// Status - The resource status information.
	Status interface{} `json:"status,omitempty"`
}

// DiskRestorePointRevokeAccessFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DiskRestorePointRevokeAccessFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskRestorePointClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskRestorePointRevokeAccessFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskRestorePointRevokeAccessFuture.Result.
func (future *DiskRestorePointRevokeAccessFuture) result(client DiskRestorePointClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DiskRestorePointRevokeAccessFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DiskRestorePointRevokeAccessFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DisksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DisksCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DisksClient) (Disk, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DisksCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DisksCreateOrUpdateFuture.Result.
func (future *DisksCreateOrUpdateFuture) result(client DisksClient) (d Disk, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DisksCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DisksCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.DisksCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DisksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DisksDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DisksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DisksDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DisksDeleteFuture.Result.
func (future *DisksDeleteFuture) result(client DisksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DisksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DisksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DiskSecurityProfile contains the security related information for the resource.
type DiskSecurityProfile struct {
	// SecurityType - Possible values include: 'DiskSecurityTypesTrustedLaunch', 'DiskSecurityTypesConfidentialVMVMGuestStateOnlyEncryptedWithPlatformKey', 'DiskSecurityTypesConfidentialVMDiskEncryptedWithPlatformKey', 'DiskSecurityTypesConfidentialVMDiskEncryptedWithCustomerKey'
	SecurityType DiskSecurityTypes `json:"securityType,omitempty"`
	// SecureVMDiskEncryptionSetID - ResourceId of the disk encryption set associated to Confidential VM supported disk encrypted with customer managed key
	SecureVMDiskEncryptionSetID *string `json:"secureVMDiskEncryptionSetId,omitempty"`
}

// DisksGrantAccessFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DisksGrantAccessFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DisksClient) (AccessURI, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DisksGrantAccessFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DisksGrantAccessFuture.Result.
func (future *DisksGrantAccessFuture) result(client DisksClient) (au AccessURI, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DisksGrantAccessFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		au.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DisksGrantAccessFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if au.Response.Response, err = future.GetResult(sender); err == nil && au.Response.Response.StatusCode != http.StatusNoContent {
		au, err = client.GrantAccessResponder(au.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.DisksGrantAccessFuture", "Result", au.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DiskSku the disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS,
// Premium_ZRS, or StandardSSD_ZRS.
type DiskSku struct {
	// Name - The sku name. Possible values include: 'DiskStorageAccountTypesStandardLRS', 'DiskStorageAccountTypesPremiumLRS', 'DiskStorageAccountTypesStandardSSDLRS', 'DiskStorageAccountTypesUltraSSDLRS', 'DiskStorageAccountTypesPremiumZRS', 'DiskStorageAccountTypesStandardSSDZRS'
	Name DiskStorageAccountTypes `json:"name,omitempty"`
	// Tier - READ-ONLY; The sku tier.
	Tier *string `json:"tier,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskSku.
func (ds DiskSku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ds.Name != "" {
		objectMap["name"] = ds.Name
	}
	return json.Marshal(objectMap)
}

// DisksRevokeAccessFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DisksRevokeAccessFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DisksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DisksRevokeAccessFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DisksRevokeAccessFuture.Result.
func (future *DisksRevokeAccessFuture) result(client DisksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DisksRevokeAccessFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DisksRevokeAccessFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DisksUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DisksUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DisksClient) (Disk, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DisksUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DisksUpdateFuture.Result.
func (future *DisksUpdateFuture) result(client DisksClient) (d Disk, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.DisksUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.DisksUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.UpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.DisksUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DiskUpdate disk update resource.
type DiskUpdate struct {
	*DiskUpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	Sku  *DiskSku           `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskUpdate.
func (du DiskUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if du.DiskUpdateProperties != nil {
		objectMap["properties"] = du.DiskUpdateProperties
	}
	if du.Tags != nil {
		objectMap["tags"] = du.Tags
	}
	if du.Sku != nil {
		objectMap["sku"] = du.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiskUpdate struct.
func (du *DiskUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diskUpdateProperties DiskUpdateProperties
				err = json.Unmarshal(*v, &diskUpdateProperties)
				if err != nil {
					return err
				}
				du.DiskUpdateProperties = &diskUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				du.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku DiskSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				du.Sku = &sku
			}
		}
	}

	return nil
}

// DiskUpdateProperties disk resource update properties.
type DiskUpdateProperties struct {
	// OsType - the Operating System type. Possible values include: 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// DiskSizeGB - If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
	// EncryptionSettingsCollection - Encryption settings collection used be Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
	EncryptionSettingsCollection *EncryptionSettingsCollection `json:"encryptionSettingsCollection,omitempty"`
	// DiskIOPSReadWrite - The number of IOPS allowed for this disk; only settable for UltraSSD disks. One operation can transfer between 4k and 256k bytes.
	DiskIOPSReadWrite *int64 `json:"diskIOPSReadWrite,omitempty"`
	// DiskMBpsReadWrite - The bandwidth allowed for this disk; only settable for UltraSSD disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
	DiskMBpsReadWrite *int64 `json:"diskMBpsReadWrite,omitempty"`
	// DiskIOPSReadOnly - The total number of IOPS that will be allowed across all VMs mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
	DiskIOPSReadOnly *int64 `json:"diskIOPSReadOnly,omitempty"`
	// DiskMBpsReadOnly - The total throughput (MBps) that will be allowed across all VMs mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
	DiskMBpsReadOnly *int64 `json:"diskMBpsReadOnly,omitempty"`
	// MaxShares - The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
	MaxShares *int32 `json:"maxShares,omitempty"`
	// Encryption - Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
	Encryption *Encryption `json:"encryption,omitempty"`
	// NetworkAccessPolicy - Possible values include: 'NetworkAccessPolicyAllowAll', 'NetworkAccessPolicyAllowPrivate', 'NetworkAccessPolicyDenyAll'
	NetworkAccessPolicy NetworkAccessPolicy `json:"networkAccessPolicy,omitempty"`
	// DiskAccessID - ARM id of the DiskAccess resource for using private endpoints on disks.
	DiskAccessID *string `json:"diskAccessId,omitempty"`
	// Tier - Performance tier of the disk (e.g, P4, S10) as described here: https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra disks.
	Tier *string `json:"tier,omitempty"`
	// BurstingEnabled - Set to true to enable bursting beyond the provisioned performance target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
	BurstingEnabled *bool `json:"burstingEnabled,omitempty"`
	// PurchasePlan - Purchase plan information to be added on the OS disk
	PurchasePlan *PurchasePlan `json:"purchasePlan,omitempty"`
	// SupportedCapabilities - List of supported capabilities (like accelerated networking) to be added on the OS disk.
	SupportedCapabilities *SupportedCapabilities `json:"supportedCapabilities,omitempty"`
	// PropertyUpdatesInProgress - READ-ONLY; Properties of the disk for which update is pending.
	PropertyUpdatesInProgress *PropertyUpdatesInProgress `json:"propertyUpdatesInProgress,omitempty"`
	// SupportsHibernation - Indicates the OS on a disk supports hibernation.
	SupportsHibernation *bool `json:"supportsHibernation,omitempty"`
	// PublicNetworkAccess - Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskUpdateProperties.
func (dup DiskUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dup.OsType != "" {
		objectMap["osType"] = dup.OsType
	}
	if dup.DiskSizeGB != nil {
		objectMap["diskSizeGB"] = dup.DiskSizeGB
	}
	if dup.EncryptionSettingsCollection != nil {
		objectMap["encryptionSettingsCollection"] = dup.EncryptionSettingsCollection
	}
	if dup.DiskIOPSReadWrite != nil {
		objectMap["diskIOPSReadWrite"] = dup.DiskIOPSReadWrite
	}
	if dup.DiskMBpsReadWrite != nil {
		objectMap["diskMBpsReadWrite"] = dup.DiskMBpsReadWrite
	}
	if dup.DiskIOPSReadOnly != nil {
		objectMap["diskIOPSReadOnly"] = dup.DiskIOPSReadOnly
	}
	if dup.DiskMBpsReadOnly != nil {
		objectMap["diskMBpsReadOnly"] = dup.DiskMBpsReadOnly
	}
	if dup.MaxShares != nil {
		objectMap["maxShares"] = dup.MaxShares
	}
	if dup.Encryption != nil {
		objectMap["encryption"] = dup.Encryption
	}
	if dup.NetworkAccessPolicy != "" {
		objectMap["networkAccessPolicy"] = dup.NetworkAccessPolicy
	}
	if dup.DiskAccessID != nil {
		objectMap["diskAccessId"] = dup.DiskAccessID
	}
	if dup.Tier != nil {
		objectMap["tier"] = dup.Tier
	}
	if dup.BurstingEnabled != nil {
		objectMap["burstingEnabled"] = dup.BurstingEnabled
	}
	if dup.PurchasePlan != nil {
		objectMap["purchasePlan"] = dup.PurchasePlan
	}
	if dup.SupportedCapabilities != nil {
		objectMap["supportedCapabilities"] = dup.SupportedCapabilities
	}
	if dup.SupportsHibernation != nil {
		objectMap["supportsHibernation"] = dup.SupportsHibernation
	}
	if dup.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = dup.PublicNetworkAccess
	}
	return json.Marshal(objectMap)
}

// Encryption encryption at rest settings for disk or snapshot
type Encryption struct {
	// DiskEncryptionSetID - ResourceId of the disk encryption set to use for enabling encryption at rest.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`
	// Type - Possible values include: 'EncryptionTypeEncryptionAtRestWithPlatformKey', 'EncryptionTypeEncryptionAtRestWithCustomerKey', 'EncryptionTypeEncryptionAtRestWithPlatformAndCustomerKeys'
	Type EncryptionType `json:"type,omitempty"`
}

// EncryptionImages optional. Allows users to provide customer managed keys for encrypting the OS and data
// disks in the gallery artifact.
type EncryptionImages struct {
	OsDiskImage *OSDiskImageEncryption `json:"osDiskImage,omitempty"`
	// DataDiskImages - A list of encryption specifications for data disk images.
	DataDiskImages *[]DataDiskImageEncryption `json:"dataDiskImages,omitempty"`
}

// EncryptionSetIdentity the managed identity for the disk encryption set. It should be given permission on
// the key vault before it can be used to encrypt disks.
type EncryptionSetIdentity struct {
	// Type - The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is supported for new creations. Disk Encryption Sets can be updated with Identity type None during migration of subscription to a new Azure Active Directory tenant; it will cause the encrypted resources to lose access to the keys. Possible values include: 'DiskEncryptionSetIdentityTypeSystemAssigned', 'DiskEncryptionSetIdentityTypeNone'
	Type DiskEncryptionSetIdentityType `json:"type,omitempty"`
	// PrincipalID - READ-ONLY; The object id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a systemAssigned(implicit) identity
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a systemAssigned(implicit) identity
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionSetIdentity.
func (esi EncryptionSetIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if esi.Type != "" {
		objectMap["type"] = esi.Type
	}
	return json.Marshal(objectMap)
}

// EncryptionSetProperties ...
type EncryptionSetProperties struct {
	// EncryptionType - Possible values include: 'DiskEncryptionSetTypeEncryptionAtRestWithCustomerKey', 'DiskEncryptionSetTypeEncryptionAtRestWithPlatformAndCustomerKeys', 'DiskEncryptionSetTypeConfidentialVMEncryptedWithCustomerKey'
	EncryptionType DiskEncryptionSetType `json:"encryptionType,omitempty"`
	// ActiveKey - The key vault key which is currently used by this disk encryption set.
	ActiveKey *KeyForDiskEncryptionSet `json:"activeKey,omitempty"`
	// PreviousKeys - READ-ONLY; A readonly collection of key vault keys previously used by this disk encryption set while a key rotation is in progress. It will be empty if there is no ongoing key rotation.
	PreviousKeys *[]KeyForDiskEncryptionSet `json:"previousKeys,omitempty"`
	// ProvisioningState - READ-ONLY; The disk encryption set provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// RotationToLatestKeyVersionEnabled - Set this flag to true to enable auto-updating of this disk encryption set to the latest key version.
	RotationToLatestKeyVersionEnabled *bool `json:"rotationToLatestKeyVersionEnabled,omitempty"`
	// LastKeyRotationTimestamp - READ-ONLY; The time when the active key of this disk encryption set was updated.
	LastKeyRotationTimestamp *date.Time `json:"lastKeyRotationTimestamp,omitempty"`
	// AutoKeyRotationError - READ-ONLY; The error that was encountered during auto-key rotation. If an error is present, then auto-key rotation will not be attempted until the error on this disk encryption set is fixed.
	AutoKeyRotationError *APIError `json:"autoKeyRotationError,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionSetProperties.
func (esp EncryptionSetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if esp.EncryptionType != "" {
		objectMap["encryptionType"] = esp.EncryptionType
	}
	if esp.ActiveKey != nil {
		objectMap["activeKey"] = esp.ActiveKey
	}
	if esp.RotationToLatestKeyVersionEnabled != nil {
		objectMap["rotationToLatestKeyVersionEnabled"] = esp.RotationToLatestKeyVersionEnabled
	}
	return json.Marshal(objectMap)
}

// EncryptionSettingsCollection encryption settings for disk or snapshot
type EncryptionSettingsCollection struct {
	// Enabled - Set this flag to true and provide DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object, the existing settings remain unchanged.
	Enabled *bool `json:"enabled,omitempty"`
	// EncryptionSettings - A collection of encryption settings, one for each disk volume.
	EncryptionSettings *[]EncryptionSettingsElement `json:"encryptionSettings,omitempty"`
	// EncryptionSettingsVersion - Describes what type of encryption is used for the disks. Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption with AAD app.'1.1' corresponds to Azure Disk Encryption.
	EncryptionSettingsVersion *string `json:"encryptionSettingsVersion,omitempty"`
}

// EncryptionSettingsElement encryption settings for one disk volume.
type EncryptionSettingsElement struct {
	// DiskEncryptionKey - Key Vault Secret Url and vault id of the disk encryption key
	DiskEncryptionKey *KeyVaultAndSecretReference `json:"diskEncryptionKey,omitempty"`
	// KeyEncryptionKey - Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
	KeyEncryptionKey *KeyVaultAndKeyReference `json:"keyEncryptionKey,omitempty"`
}

// ExtendedLocation the complex type of the extended location.
type ExtendedLocation struct {
	// Name - The name of the extended location.
	Name *string `json:"name,omitempty"`
	// Type - The type of the extended location. Possible values include: 'ExtendedLocationTypesEdgeZone'
	Type ExtendedLocationTypes `json:"type,omitempty"`
}

// Extension describes a cloud service Extension.
type Extension struct {
	// Name - The name of the extension.
	Name       *string                          `json:"name,omitempty"`
	Properties *CloudServiceExtensionProperties `json:"properties,omitempty"`
}

// GalleriesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GalleriesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GalleriesClient) (Gallery, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GalleriesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GalleriesCreateOrUpdateFuture.Result.
func (future *GalleriesCreateOrUpdateFuture) result(client GalleriesClient) (g Gallery, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GalleriesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		g.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GalleriesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if g.Response.Response, err = future.GetResult(sender); err == nil && g.Response.Response.StatusCode != http.StatusNoContent {
		g, err = client.CreateOrUpdateResponder(g.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.GalleriesCreateOrUpdateFuture", "Result", g.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GalleriesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GalleriesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GalleriesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GalleriesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GalleriesDeleteFuture.Result.
func (future *GalleriesDeleteFuture) result(client GalleriesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GalleriesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GalleriesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GalleriesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GalleriesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GalleriesClient) (Gallery, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GalleriesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GalleriesUpdateFuture.Result.
func (future *GalleriesUpdateFuture) result(client GalleriesClient) (g Gallery, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GalleriesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		g.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GalleriesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if g.Response.Response, err = future.GetResult(sender); err == nil && g.Response.Response.StatusCode != http.StatusNoContent {
		g, err = client.UpdateResponder(g.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.GalleriesUpdateFuture", "Result", g.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Gallery specifies information about the Shared Image Gallery that you want to create or update.
type Gallery struct {
	autorest.Response  `json:"-"`
	*GalleryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Gallery.
func (g Gallery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if g.GalleryProperties != nil {
		objectMap["properties"] = g.GalleryProperties
	}
	if g.Location != nil {
		objectMap["location"] = g.Location
	}
	if g.Tags != nil {
		objectMap["tags"] = g.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Gallery struct.
func (g *Gallery) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var galleryProperties GalleryProperties
				err = json.Unmarshal(*v, &galleryProperties)
				if err != nil {
					return err
				}
				g.GalleryProperties = &galleryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				g.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				g.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				g.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				g.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				g.Tags = tags
			}
		}
	}

	return nil
}

// GalleryApplication specifies information about the gallery Application Definition that you want to
// create or update.
type GalleryApplication struct {
	autorest.Response             `json:"-"`
	*GalleryApplicationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GalleryApplication.
func (ga GalleryApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ga.GalleryApplicationProperties != nil {
		objectMap["properties"] = ga.GalleryApplicationProperties
	}
	if ga.Location != nil {
		objectMap["location"] = ga.Location
	}
	if ga.Tags != nil {
		objectMap["tags"] = ga.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GalleryApplication struct.
func (ga *GalleryApplication) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var galleryApplicationProperties GalleryApplicationProperties
				err = json.Unmarshal(*v, &galleryApplicationProperties)
				if err != nil {
					return err
				}
				ga.GalleryApplicationProperties = &galleryApplicationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ga.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ga.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ga.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ga.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ga.Tags = tags
			}
		}
	}

	return nil
}

// GalleryApplicationList the List Gallery Applications operation response.
type GalleryApplicationList struct {
	autorest.Response `json:"-"`
	// Value - A list of Gallery Applications.
	Value *[]GalleryApplication `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of Application Definitions in the Application Gallery. Call ListNext() with this to fetch the next page of gallery Application Definitions.
	NextLink *string `json:"nextLink,omitempty"`
}

// GalleryApplicationListIterator provides access to a complete listing of GalleryApplication values.
type GalleryApplicationListIterator struct {
	i    int
	page GalleryApplicationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GalleryApplicationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GalleryApplicationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GalleryApplicationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GalleryApplicationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GalleryApplicationListIterator) Response() GalleryApplicationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GalleryApplicationListIterator) Value() GalleryApplication {
	if !iter.page.NotDone() {
		return GalleryApplication{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GalleryApplicationListIterator type.
func NewGalleryApplicationListIterator(page GalleryApplicationListPage) GalleryApplicationListIterator {
	return GalleryApplicationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (gal GalleryApplicationList) IsEmpty() bool {
	return gal.Value == nil || len(*gal.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (gal GalleryApplicationList) hasNextLink() bool {
	return gal.NextLink != nil && len(*gal.NextLink) != 0
}

// galleryApplicationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (gal GalleryApplicationList) galleryApplicationListPreparer(ctx context.Context) (*http.Request, error) {
	if !gal.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(gal.NextLink)))
}

// GalleryApplicationListPage contains a page of GalleryApplication values.
type GalleryApplicationListPage struct {
	fn  func(context.Context, GalleryApplicationList) (GalleryApplicationList, error)
	gal GalleryApplicationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GalleryApplicationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GalleryApplicationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.gal)
		if err != nil {
			return err
		}
		page.gal = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GalleryApplicationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GalleryApplicationListPage) NotDone() bool {
	return !page.gal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GalleryApplicationListPage) Response() GalleryApplicationList {
	return page.gal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GalleryApplicationListPage) Values() []GalleryApplication {
	if page.gal.IsEmpty() {
		return nil
	}
	return *page.gal.Value
}

// Creates a new instance of the GalleryApplicationListPage type.
func NewGalleryApplicationListPage(cur GalleryApplicationList, getNextPage func(context.Context, GalleryApplicationList) (GalleryApplicationList, error)) GalleryApplicationListPage {
	return GalleryApplicationListPage{
		fn:  getNextPage,
		gal: cur,
	}
}

// GalleryApplicationProperties describes the properties of a gallery Application Definition.
type GalleryApplicationProperties struct {
	// Description - The description of this gallery Application Definition resource. This property is updatable.
	Description *string `json:"description,omitempty"`
	// Eula - The Eula agreement for the gallery Application Definition.
	Eula *string `json:"eula,omitempty"`
	// PrivacyStatementURI - The privacy statement uri.
	PrivacyStatementURI *string `json:"privacyStatementUri,omitempty"`
	// ReleaseNoteURI - The release note uri.
	ReleaseNoteURI *string `json:"releaseNoteUri,omitempty"`
	// EndOfLifeDate - The end of life date of the gallery Application Definition. This property can be used for decommissioning purposes. This property is updatable.
	EndOfLifeDate *date.Time `json:"endOfLifeDate,omitempty"`
	// SupportedOSType - This property allows you to specify the supported type of the OS that application is built for. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**. Possible values include: 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	SupportedOSType OperatingSystemTypes `json:"supportedOSType,omitempty"`
}

// GalleryApplicationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GalleryApplicationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GalleryApplicationsClient) (GalleryApplication, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GalleryApplicationsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GalleryApplicationsCreateOrUpdateFuture.Result.
func (future *GalleryApplicationsCreateOrUpdateFuture) result(client GalleryApplicationsClient) (ga GalleryApplication, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GalleryApplicationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ga.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GalleryApplicationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ga.Response.Response, err = future.GetResult(sender); err == nil && ga.Response.Response.StatusCode != http.StatusNoContent {
		ga, err = client.CreateOrUpdateResponder(ga.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.GalleryApplicationsCreateOrUpdateFuture", "Result", ga.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GalleryApplicationsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GalleryApplicationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GalleryApplicationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GalleryApplicationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GalleryApplicationsDeleteFuture.Result.
func (future *GalleryApplicationsDeleteFuture) result(client GalleryApplicationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GalleryApplicationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GalleryApplicationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GalleryApplicationsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GalleryApplicationsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GalleryApplicationsClient) (GalleryApplication, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GalleryApplicationsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GalleryApplicationsUpdateFuture.Result.
func (future *GalleryApplicationsUpdateFuture) result(client GalleryApplicationsClient) (ga GalleryApplication, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GalleryApplicationsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ga.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GalleryApplicationsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ga.Response.Response, err = future.GetResult(sender); err == nil && ga.Response.Response.StatusCode != http.StatusNoContent {
		ga, err = client.UpdateResponder(ga.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.GalleryApplicationsUpdateFuture", "Result", ga.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GalleryApplicationUpdate specifies information about the gallery Application Definition that you want to
// update.
type GalleryApplicationUpdate struct {
	*GalleryApplicationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GalleryApplicationUpdate.
func (gau GalleryApplicationUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gau.GalleryApplicationProperties != nil {
		objectMap["properties"] = gau.GalleryApplicationProperties
	}
	if gau.Tags != nil {
		objectMap["tags"] = gau.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GalleryApplicationUpdate struct.
func (gau *GalleryApplicationUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var galleryApplicationProperties GalleryApplicationProperties
				err = json.Unmarshal(*v, &galleryApplicationProperties)
				if err != nil {
					return err
				}
				gau.GalleryApplicationProperties = &galleryApplicationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gau.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gau.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gau.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gau.Tags = tags
			}
		}
	}

	return nil
}

// GalleryApplicationVersion specifies information about the gallery Application Version that you want to
// create or update.
type GalleryApplicationVersion struct {
	autorest.Response                    `json:"-"`
	*GalleryApplicationVersionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GalleryApplicationVersion.
func (gav GalleryApplicationVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gav.GalleryApplicationVersionProperties != nil {
		objectMap["properties"] = gav.GalleryApplicationVersionProperties
	}
	if gav.Location != nil {
		objectMap["location"] = gav.Location
	}
	if gav.Tags != nil {
		objectMap["tags"] = gav.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GalleryApplicationVersion struct.
func (gav *GalleryApplicationVersion) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var galleryApplicationVersionProperties GalleryApplicationVersionProperties
				err = json.Unmarshal(*v, &galleryApplicationVersionProperties)
				if err != nil {
					return err
				}
				gav.GalleryApplicationVersionProperties = &galleryApplicationVersionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gav.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gav.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gav.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gav.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gav.Tags = tags
			}
		}
	}

	return nil
}

// GalleryApplicationVersionList the List Gallery Application version operation response.
type GalleryApplicationVersionList struct {
	autorest.Response `json:"-"`
	// Value - A list of gallery Application Versions.
	Value *[]GalleryApplicationVersion `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of gallery Application Versions. Call ListNext() with this to fetch the next page of gallery Application Versions.
	NextLink *string `json:"nextLink,omitempty"`
}

// GalleryApplicationVersionListIterator provides access to a complete listing of GalleryApplicationVersion
// values.
type GalleryApplicationVersionListIterator struct {
	i    int
	page GalleryApplicationVersionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GalleryApplicationVersionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GalleryApplicationVersionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GalleryApplicationVersionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GalleryApplicationVersionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GalleryApplicationVersionListIterator) Response() GalleryApplicationVersionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GalleryApplicationVersionListIterator) Value() GalleryApplicationVersion {
	if !iter.page.NotDone() {
		return GalleryApplicationVersion{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GalleryApplicationVersionListIterator type.
func NewGalleryApplicationVersionListIterator(page GalleryApplicationVersionListPage) GalleryApplicationVersionListIterator {
	return GalleryApplicationVersionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (gavl GalleryApplicationVersionList) IsEmpty() bool {
	return gavl.Value == nil || len(*gavl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (gavl GalleryApplicationVersionList) hasNextLink() bool {
	return gavl.NextLink != nil && len(*gavl.NextLink) != 0
}

// galleryApplicationVersionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (gavl GalleryApplicationVersionList) galleryApplicationVersionListPreparer(ctx context.Context) (*http.Request, error) {
	if !gavl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(gavl.NextLink)))
}

// GalleryApplicationVersionListPage contains a page of GalleryApplicationVersion values.
type GalleryApplicationVersionListPage struct {
	fn   func(context.Context, GalleryApplicationVersionList) (GalleryApplicationVersionList, error)
	gavl GalleryApplicationVersionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GalleryApplicationVersionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GalleryApplicationVersionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.gavl)
		if err != nil {
			return err
		}
		page.gavl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GalleryApplicationVersionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GalleryApplicationVersionListPage) NotDone() bool {
	return !page.gavl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GalleryApplicationVersionListPage) Response() GalleryApplicationVersionList {
	return page.gavl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GalleryApplicationVersionListPage) Values() []GalleryApplicationVersion {
	if page.gavl.IsEmpty() {
		return nil
	}
	return *page.gavl.Value
}

// Creates a new instance of the GalleryApplicationVersionListPage type.
func NewGalleryApplicationVersionListPage(cur GalleryApplicationVersionList, getNextPage func(context.Context, GalleryApplicationVersionList) (GalleryApplicationVersionList, error)) GalleryApplicationVersionListPage {
	return GalleryApplicationVersionListPage{
		fn:   getNextPage,
		gavl: cur,
	}
}

// GalleryApplicationVersionProperties describes the properties of a gallery image version.
type GalleryApplicationVersionProperties struct {
	PublishingProfile *GalleryApplicationVersionPublishingProfile `json:"publishingProfile,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response. Possible values include: 'ProvisioningState1Creating', 'ProvisioningState1Updating', 'ProvisioningState1Failed', 'ProvisioningState1Succeeded', 'ProvisioningState1Deleting', 'ProvisioningState1Migrating'
	ProvisioningState ProvisioningState1 `json:"provisioningState,omitempty"`
	// ReplicationStatus - READ-ONLY
	ReplicationStatus *ReplicationStatus `json:"replicationStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for GalleryApplicationVersionProperties.
func (gavp GalleryApplicationVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gavp.PublishingProfile != nil {
		objectMap["publishingProfile"] = gavp.PublishingProfile
	}
	return json.Marshal(objectMap)
}

// GalleryApplicationVersionPublishingProfile the publishing profile of a gallery image version.
type GalleryApplicationVersionPublishingProfile struct {
	Source        *UserArtifactSource `json:"source,omitempty"`
	ManageActions *UserArtifactManage `json:"manageActions,omitempty"`
	// EnableHealthCheck - Optional. Whether or not this application reports health.
	EnableHealthCheck *bool `json:"enableHealthCheck,omitempty"`
	// TargetRegions - The target regions where the Image Version is going to be replicated to. This property is updatable.
	TargetRegions *[]TargetRegion `json:"targetRegions,omitempty"`
	// ReplicaCount - The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
	ReplicaCount *int32 `json:"replicaCount,omitempty"`
	// ExcludeFromLatest - If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
	ExcludeFromLatest *bool `json:"excludeFromLatest,omitempty"`
	// PublishedDate - READ-ONLY; The timestamp for when the gallery image version is published.
	PublishedDate *date.Time `json:"publishedDate,omitempty"`
	// EndOfLifeDate - The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
	EndOfLifeDate *date.Time `json:"endOfLifeDate,omitempty"`
	// StorageAccountType - Specifies the storage account type to be used to store the image. This property is not updatable. Possible values include: 'StorageAccountTypeStandardLRS', 'StorageAccountTypeStandardZRS', 'StorageAccountTypePremiumLRS'
	StorageAccountType StorageAccountType `json:"storageAccountType,omitempty"`
	// ReplicationMode - Optional parameter which specifies the mode to be used for replication. This property is not updatable. Possible values include: 'ReplicationModeFull', 'ReplicationModeShallow'
	ReplicationMode ReplicationMode `json:"replicationMode,omitempty"`
}

// MarshalJSON is the custom marshaler for GalleryApplicationVersionPublishingProfile.
func (gavpp GalleryApplicationVersionPublishingProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gavpp.Source != nil {
		objectMap["source"] = gavpp.Source
	}
	if gavpp.ManageActions != nil {
		objectMap["manageActions"] = gavpp.ManageActions
	}
	if gavpp.EnableHealthCheck != nil {
		objectMap["enableHealthCheck"] = gavpp.EnableHealthCheck
	}
	if gavpp.TargetRegions != nil {
		objectMap["targetRegions"] = gavpp.TargetRegions
	}
	if gavpp.ReplicaCount != nil {
		objectMap["replicaCount"] = gavpp.ReplicaCount
	}
	if gavpp.ExcludeFromLatest != nil {
		objectMap["excludeFromLatest"] = gavpp.ExcludeFromLatest
	}
	if gavpp.EndOfLifeDate != nil {
		objectMap["endOfLifeDate"] = gavpp.EndOfLifeDate
	}
	if gavpp.StorageAccountType != "" {
		objectMap["storageAccountType"] = gavpp.StorageAccountType
	}
	if gavpp.ReplicationMode != "" {
		objectMap["replicationMode"] = gavpp.ReplicationMode
	}
	return json.Marshal(objectMap)
}

// GalleryApplicationVersionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type GalleryApplicationVersionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GalleryApplicationVersionsClient) (GalleryApplicationVersion, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GalleryApplicationVersionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GalleryApplicationVersionsCreateOrUpdateFuture.Result.
func (future *GalleryApplicationVersionsCreateOrUpdateFuture) result(client GalleryApplicationVersionsClient) (gav GalleryApplicationVersion, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GalleryApplicationVersionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		gav.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GalleryApplicationVersionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gav.Response.Response, err = future.GetResult(sender); err == nil && gav.Response.Response.StatusCode != http.StatusNoContent {
		gav, err = client.CreateOrUpdateResponder(gav.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.GalleryApplicationVersionsCreateOrUpdateFuture", "Result", gav.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GalleryApplicationVersionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GalleryApplicationVersionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GalleryApplicationVersionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GalleryApplicationVersionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GalleryApplicationVersionsDeleteFuture.Result.
func (future *GalleryApplicationVersionsDeleteFuture) result(client GalleryApplicationVersionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GalleryApplicationVersionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GalleryApplicationVersionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GalleryApplicationVersionsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GalleryApplicationVersionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GalleryApplicationVersionsClient) (GalleryApplicationVersion, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GalleryApplicationVersionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GalleryApplicationVersionsUpdateFuture.Result.
func (future *GalleryApplicationVersionsUpdateFuture) result(client GalleryApplicationVersionsClient) (gav GalleryApplicationVersion, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GalleryApplicationVersionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		gav.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GalleryApplicationVersionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gav.Response.Response, err = future.GetResult(sender); err == nil && gav.Response.Response.StatusCode != http.StatusNoContent {
		gav, err = client.UpdateResponder(gav.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.GalleryApplicationVersionsUpdateFuture", "Result", gav.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GalleryApplicationVersionUpdate specifies information about the gallery Application Version that you
// want to update.
type GalleryApplicationVersionUpdate struct {
	*GalleryApplicationVersionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GalleryApplicationVersionUpdate.
func (gavu GalleryApplicationVersionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gavu.GalleryApplicationVersionProperties != nil {
		objectMap["properties"] = gavu.GalleryApplicationVersionProperties
	}
	if gavu.Tags != nil {
		objectMap["tags"] = gavu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GalleryApplicationVersionUpdate struct.
func (gavu *GalleryApplicationVersionUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var galleryApplicationVersionProperties GalleryApplicationVersionProperties
				err = json.Unmarshal(*v, &galleryApplicationVersionProperties)
				if err != nil {
					return err
				}
				gavu.GalleryApplicationVersionProperties = &galleryApplicationVersionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gavu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gavu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gavu.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gavu.Tags = tags
			}
		}
	}

	return nil
}

// GalleryArtifactPublishingProfileBase describes the basic gallery artifact publishing profile.
type GalleryArtifactPublishingProfileBase struct {
	// TargetRegions - The target regions where the Image Version is going to be replicated to. This property is updatable.
	TargetRegions *[]TargetRegion `json:"targetRegions,omitempty"`
	// ReplicaCount - The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
	ReplicaCount *int32 `json:"replicaCount,omitempty"`
	// ExcludeFromLatest - If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
	ExcludeFromLatest *bool `json:"excludeFromLatest,omitempty"`
	// PublishedDate - READ-ONLY; The timestamp for when the gallery image version is published.
	PublishedDate *date.Time `json:"publishedDate,omitempty"`
	// EndOfLifeDate - The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
	EndOfLifeDate *date.Time `json:"endOfLifeDate,omitempty"`
	// StorageAccountType - Specifies the storage account type to be used to store the image. This property is not updatable. Possible values include: 'StorageAccountTypeStandardLRS', 'StorageAccountTypeStandardZRS', 'StorageAccountTypePremiumLRS'
	StorageAccountType StorageAccountType `json:"storageAccountType,omitempty"`
	// ReplicationMode - Optional parameter which specifies the mode to be used for replication. This property is not updatable. Possible values include: 'ReplicationModeFull', 'ReplicationModeShallow'
	ReplicationMode ReplicationMode `json:"replicationMode,omitempty"`
}

// MarshalJSON is the custom marshaler for GalleryArtifactPublishingProfileBase.
func (gappb GalleryArtifactPublishingProfileBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gappb.TargetRegions != nil {
		objectMap["targetRegions"] = gappb.TargetRegions
	}
	if gappb.ReplicaCount != nil {
		objectMap["replicaCount"] = gappb.ReplicaCount
	}
	if gappb.ExcludeFromLatest != nil {
		objectMap["excludeFromLatest"] = gappb.ExcludeFromLatest
	}
	if gappb.EndOfLifeDate != nil {
		objectMap["endOfLifeDate"] = gappb.EndOfLifeDate
	}
	if gappb.StorageAccountType != "" {
		objectMap["storageAccountType"] = gappb.StorageAccountType
	}
	if gappb.ReplicationMode != "" {
		objectMap["replicationMode"] = gappb.ReplicationMode
	}
	return json.Marshal(objectMap)
}

// GalleryArtifactSource the source image from which the Image Version is going to be created.
type GalleryArtifactSource struct {
	ManagedImage *ManagedArtifact `json:"managedImage,omitempty"`
}

// GalleryArtifactVersionSource the gallery artifact version source.
type GalleryArtifactVersionSource struct {
	// ID - The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
	ID *string `json:"id,omitempty"`
	// URI - The uri of the gallery artifact version source. Currently used to specify vhd/blob source.
	URI *string `json:"uri,omitempty"`
}

// GalleryDataDiskImage this is the data disk image.
type GalleryDataDiskImage struct {
	// Lun - This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
	Lun *int32 `json:"lun,omitempty"`
	// SizeInGB - READ-ONLY; This property indicates the size of the VHD to be created.
	SizeInGB *int32 `json:"sizeInGB,omitempty"`
	// HostCaching - The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'. Possible values include: 'HostCachingNone', 'HostCachingReadOnly', 'HostCachingReadWrite'
	HostCaching HostCaching                   `json:"hostCaching,omitempty"`
	Source      *GalleryArtifactVersionSource `json:"source,omitempty"`
}

// MarshalJSON is the custom marshaler for GalleryDataDiskImage.
func (gddi GalleryDataDiskImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gddi.Lun != nil {
		objectMap["lun"] = gddi.Lun
	}
	if gddi.HostCaching != "" {
		objectMap["hostCaching"] = gddi.HostCaching
	}
	if gddi.Source != nil {
		objectMap["source"] = gddi.Source
	}
	return json.Marshal(objectMap)
}

// GalleryDiskImage this is the disk image base class.
type GalleryDiskImage struct {
	// SizeInGB - READ-ONLY; This property indicates the size of the VHD to be created.
	SizeInGB *int32 `json:"sizeInGB,omitempty"`
	// HostCaching - The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'. Possible values include: 'HostCachingNone', 'HostCachingReadOnly', 'HostCachingReadWrite'
	HostCaching HostCaching                   `json:"hostCaching,omitempty"`
	Source      *GalleryArtifactVersionSource `json:"source,omitempty"`
}

// MarshalJSON is the custom marshaler for GalleryDiskImage.
func (gdi GalleryDiskImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gdi.HostCaching != "" {
		objectMap["hostCaching"] = gdi.HostCaching
	}
	if gdi.Source != nil {
		objectMap["source"] = gdi.Source
	}
	return json.Marshal(objectMap)
}

// GalleryIdentifier describes the gallery unique name.
type GalleryIdentifier struct {
	// UniqueName - READ-ONLY; The unique name of the Shared Image Gallery. This name is generated automatically by Azure.
	UniqueName *string `json:"uniqueName,omitempty"`
}

// MarshalJSON is the custom marshaler for GalleryIdentifier.
func (gi GalleryIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GalleryImage specifies information about the gallery image definition that you want to create or update.
type GalleryImage struct {
	autorest.Response       `json:"-"`
	*GalleryImageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GalleryImage.
func (gi GalleryImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gi.GalleryImageProperties != nil {
		objectMap["properties"] = gi.GalleryImageProperties
	}
	if gi.Location != nil {
		objectMap["location"] = gi.Location
	}
	if gi.Tags != nil {
		objectMap["tags"] = gi.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GalleryImage struct.
func (gi *GalleryImage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var galleryImageProperties GalleryImageProperties
				err = json.Unmarshal(*v, &galleryImageProperties)
				if err != nil {
					return err
				}
				gi.GalleryImageProperties = &galleryImageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gi.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gi.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gi.Tags = tags
			}
		}
	}

	return nil
}

// GalleryImageFeature a feature for gallery image.
type GalleryImageFeature struct {
	// Name - The name of the gallery image feature.
	Name *string `json:"name,omitempty"`
	// Value - The value of the gallery image feature.
	Value *string `json:"value,omitempty"`
}

// GalleryImageIdentifier this is the gallery image definition identifier.
type GalleryImageIdentifier struct {
	// Publisher - The name of the gallery image definition publisher.
	Publisher *string `json:"publisher,omitempty"`
	// Offer - The name of the gallery image definition offer.
	Offer *string `json:"offer,omitempty"`
	// Sku - The name of the gallery image definition SKU.
	Sku *string `json:"sku,omitempty"`
}

// GalleryImageList the List Gallery Images operation response.
type GalleryImageList struct {
	autorest.Response `json:"-"`
	// Value - A list of Shared Image Gallery images.
	Value *[]GalleryImage `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of Image Definitions in the Shared Image Gallery. Call ListNext() with this to fetch the next page of gallery image definitions.
	NextLink *string `json:"nextLink,omitempty"`
}

// GalleryImageListIterator provides access to a complete listing of GalleryImage values.
type GalleryImageListIterator struct {
	i    int
	page GalleryImageListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GalleryImageListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GalleryImageListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GalleryImageListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GalleryImageListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GalleryImageListIterator) Response() GalleryImageList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GalleryImageListIterator) Value() GalleryImage {
	if !iter.page.NotDone() {
		return GalleryImage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GalleryImageListIterator type.
func NewGalleryImageListIterator(page GalleryImageListPage) GalleryImageListIterator {
	return GalleryImageListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (gil GalleryImageList) IsEmpty() bool {
	return gil.Value == nil || len(*gil.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (gil GalleryImageList) hasNextLink() bool {
	return gil.NextLink != nil && len(*gil.NextLink) != 0
}

// galleryImageListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (gil GalleryImageList) galleryImageListPreparer(ctx context.Context) (*http.Request, error) {
	if !gil.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(gil.NextLink)))
}

// GalleryImageListPage contains a page of GalleryImage values.
type GalleryImageListPage struct {
	fn  func(context.Context, GalleryImageList) (GalleryImageList, error)
	gil GalleryImageList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GalleryImageListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GalleryImageListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.gil)
		if err != nil {
			return err
		}
		page.gil = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GalleryImageListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GalleryImageListPage) NotDone() bool {
	return !page.gil.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GalleryImageListPage) Response() GalleryImageList {
	return page.gil
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GalleryImageListPage) Values() []GalleryImage {
	if page.gil.IsEmpty() {
		return nil
	}
	return *page.gil.Value
}

// Creates a new instance of the GalleryImageListPage type.
func NewGalleryImageListPage(cur GalleryImageList, getNextPage func(context.Context, GalleryImageList) (GalleryImageList, error)) GalleryImageListPage {
	return GalleryImageListPage{
		fn:  getNextPage,
		gil: cur,
	}
}

// GalleryImageProperties describes the properties of a gallery image definition.
type GalleryImageProperties struct {
	// Description - The description of this gallery image definition resource. This property is updatable.
	Description *string `json:"description,omitempty"`
	// Eula - The Eula agreement for the gallery image definition.
	Eula *string `json:"eula,omitempty"`
	// PrivacyStatementURI - The privacy statement uri.
	PrivacyStatementURI *string `json:"privacyStatementUri,omitempty"`
	// ReleaseNoteURI - The release note uri.
	ReleaseNoteURI *string `json:"releaseNoteUri,omitempty"`
	// OsType - This property allows you to specify the type of the OS that is included in the disk when creating a VM from a managed image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**. Possible values include: 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// OsState - This property allows the user to specify whether the virtual machines created under this image are 'Generalized' or 'Specialized'. Possible values include: 'OperatingSystemStateTypesGeneralized', 'OperatingSystemStateTypesSpecialized'
	OsState OperatingSystemStateTypes `json:"osState,omitempty"`
	// HyperVGeneration - The hypervisor generation of the Virtual Machine. Applicable to OS disks only. Possible values include: 'HyperVGenerationV1', 'HyperVGenerationV2'
	HyperVGeneration HyperVGeneration `json:"hyperVGeneration,omitempty"`
	// EndOfLifeDate - The end of life date of the gallery image definition. This property can be used for decommissioning purposes. This property is updatable.
	EndOfLifeDate *date.Time                       `json:"endOfLifeDate,omitempty"`
	Identifier    *GalleryImageIdentifier          `json:"identifier,omitempty"`
	Recommended   *RecommendedMachineConfiguration `json:"recommended,omitempty"`
	Disallowed    *Disallowed                      `json:"disallowed,omitempty"`
	PurchasePlan  *ImagePurchasePlan               `json:"purchasePlan,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response. Possible values include: 'ProvisioningState2Creating', 'ProvisioningState2Updating', 'ProvisioningState2Failed', 'ProvisioningState2Succeeded', 'ProvisioningState2Deleting', 'ProvisioningState2Migrating'
	ProvisioningState ProvisioningState2 `json:"provisioningState,omitempty"`
	// Features - A list of gallery image features.
	Features *[]GalleryImageFeature `json:"features,omitempty"`
}

// MarshalJSON is the custom marshaler for GalleryImageProperties.
func (gip GalleryImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gip.Description != nil {
		objectMap["description"] = gip.Description
	}
	if gip.Eula != nil {
		objectMap["eula"] = gip.Eula
	}
	if gip.PrivacyStatementURI != nil {
		objectMap["privacyStatementUri"] = gip.PrivacyStatementURI
	}
	if gip.ReleaseNoteURI != nil {
		objectMap["releaseNoteUri"] = gip.ReleaseNoteURI
	}
	if gip.OsType != "" {
		objectMap["osType"] = gip.OsType
	}
	if gip.OsState != "" {
		objectMap["osState"] = gip.OsState
	}
	if gip.HyperVGeneration != "" {
		objectMap["hyperVGeneration"] = gip.HyperVGeneration
	}
	if gip.EndOfLifeDate != nil {
		objectMap["endOfLifeDate"] = gip.EndOfLifeDate
	}
	if gip.Identifier != nil {
		objectMap["identifier"] = gip.Identifier
	}
	if gip.Recommended != nil {
		objectMap["recommended"] = gip.Recommended
	}
	if gip.Disallowed != nil {
		objectMap["disallowed"] = gip.Disallowed
	}
	if gip.PurchasePlan != nil {
		objectMap["purchasePlan"] = gip.PurchasePlan
	}
	if gip.Features != nil {
		objectMap["features"] = gip.Features
	}
	return json.Marshal(objectMap)
}

// GalleryImagesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GalleryImagesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GalleryImagesClient) (GalleryImage, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GalleryImagesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GalleryImagesCreateOrUpdateFuture.Result.
func (future *GalleryImagesCreateOrUpdateFuture) result(client GalleryImagesClient) (gi GalleryImage, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GalleryImagesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		gi.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GalleryImagesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gi.Response.Response, err = future.GetResult(sender); err == nil && gi.Response.Response.StatusCode != http.StatusNoContent {
		gi, err = client.CreateOrUpdateResponder(gi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.GalleryImagesCreateOrUpdateFuture", "Result", gi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GalleryImagesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GalleryImagesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GalleryImagesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GalleryImagesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GalleryImagesDeleteFuture.Result.
func (future *GalleryImagesDeleteFuture) result(client GalleryImagesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GalleryImagesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GalleryImagesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GalleryImagesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GalleryImagesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GalleryImagesClient) (GalleryImage, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GalleryImagesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GalleryImagesUpdateFuture.Result.
func (future *GalleryImagesUpdateFuture) result(client GalleryImagesClient) (gi GalleryImage, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GalleryImagesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		gi.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GalleryImagesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gi.Response.Response, err = future.GetResult(sender); err == nil && gi.Response.Response.StatusCode != http.StatusNoContent {
		gi, err = client.UpdateResponder(gi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.GalleryImagesUpdateFuture", "Result", gi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GalleryImageUpdate specifies information about the gallery image definition that you want to update.
type GalleryImageUpdate struct {
	*GalleryImageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GalleryImageUpdate.
func (giu GalleryImageUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if giu.GalleryImageProperties != nil {
		objectMap["properties"] = giu.GalleryImageProperties
	}
	if giu.Tags != nil {
		objectMap["tags"] = giu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GalleryImageUpdate struct.
func (giu *GalleryImageUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var galleryImageProperties GalleryImageProperties
				err = json.Unmarshal(*v, &galleryImageProperties)
				if err != nil {
					return err
				}
				giu.GalleryImageProperties = &galleryImageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				giu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				giu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				giu.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				giu.Tags = tags
			}
		}
	}

	return nil
}

// GalleryImageVersion specifies information about the gallery image version that you want to create or
// update.
type GalleryImageVersion struct {
	autorest.Response              `json:"-"`
	*GalleryImageVersionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GalleryImageVersion.
func (giv GalleryImageVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if giv.GalleryImageVersionProperties != nil {
		objectMap["properties"] = giv.GalleryImageVersionProperties
	}
	if giv.Location != nil {
		objectMap["location"] = giv.Location
	}
	if giv.Tags != nil {
		objectMap["tags"] = giv.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GalleryImageVersion struct.
func (giv *GalleryImageVersion) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var galleryImageVersionProperties GalleryImageVersionProperties
				err = json.Unmarshal(*v, &galleryImageVersionProperties)
				if err != nil {
					return err
				}
				giv.GalleryImageVersionProperties = &galleryImageVersionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				giv.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				giv.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				giv.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				giv.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				giv.Tags = tags
			}
		}
	}

	return nil
}

// GalleryImageVersionList the List Gallery Image version operation response.
type GalleryImageVersionList struct {
	autorest.Response `json:"-"`
	// Value - A list of gallery image versions.
	Value *[]GalleryImageVersion `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of gallery image versions. Call ListNext() with this to fetch the next page of gallery image versions.
	NextLink *string `json:"nextLink,omitempty"`
}

// GalleryImageVersionListIterator provides access to a complete listing of GalleryImageVersion values.
type GalleryImageVersionListIterator struct {
	i    int
	page GalleryImageVersionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GalleryImageVersionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GalleryImageVersionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GalleryImageVersionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GalleryImageVersionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GalleryImageVersionListIterator) Response() GalleryImageVersionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GalleryImageVersionListIterator) Value() GalleryImageVersion {
	if !iter.page.NotDone() {
		return GalleryImageVersion{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GalleryImageVersionListIterator type.
func NewGalleryImageVersionListIterator(page GalleryImageVersionListPage) GalleryImageVersionListIterator {
	return GalleryImageVersionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (givl GalleryImageVersionList) IsEmpty() bool {
	return givl.Value == nil || len(*givl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (givl GalleryImageVersionList) hasNextLink() bool {
	return givl.NextLink != nil && len(*givl.NextLink) != 0
}

// galleryImageVersionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (givl GalleryImageVersionList) galleryImageVersionListPreparer(ctx context.Context) (*http.Request, error) {
	if !givl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(givl.NextLink)))
}

// GalleryImageVersionListPage contains a page of GalleryImageVersion values.
type GalleryImageVersionListPage struct {
	fn   func(context.Context, GalleryImageVersionList) (GalleryImageVersionList, error)
	givl GalleryImageVersionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GalleryImageVersionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GalleryImageVersionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.givl)
		if err != nil {
			return err
		}
		page.givl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GalleryImageVersionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GalleryImageVersionListPage) NotDone() bool {
	return !page.givl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GalleryImageVersionListPage) Response() GalleryImageVersionList {
	return page.givl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GalleryImageVersionListPage) Values() []GalleryImageVersion {
	if page.givl.IsEmpty() {
		return nil
	}
	return *page.givl.Value
}

// Creates a new instance of the GalleryImageVersionListPage type.
func NewGalleryImageVersionListPage(cur GalleryImageVersionList, getNextPage func(context.Context, GalleryImageVersionList) (GalleryImageVersionList, error)) GalleryImageVersionListPage {
	return GalleryImageVersionListPage{
		fn:   getNextPage,
		givl: cur,
	}
}

// GalleryImageVersionProperties describes the properties of a gallery image version.
type GalleryImageVersionProperties struct {
	PublishingProfile *GalleryImageVersionPublishingProfile `json:"publishingProfile,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response. Possible values include: 'ProvisioningState3Creating', 'ProvisioningState3Updating', 'ProvisioningState3Failed', 'ProvisioningState3Succeeded', 'ProvisioningState3Deleting', 'ProvisioningState3Migrating'
	ProvisioningState ProvisioningState3                 `json:"provisioningState,omitempty"`
	StorageProfile    *GalleryImageVersionStorageProfile `json:"storageProfile,omitempty"`
	// ReplicationStatus - READ-ONLY
	ReplicationStatus *ReplicationStatus `json:"replicationStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for GalleryImageVersionProperties.
func (givp GalleryImageVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if givp.PublishingProfile != nil {
		objectMap["publishingProfile"] = givp.PublishingProfile
	}
	if givp.StorageProfile != nil {
		objectMap["storageProfile"] = givp.StorageProfile
	}
	return json.Marshal(objectMap)
}

// GalleryImageVersionPublishingProfile the publishing profile of a gallery image Version.
type GalleryImageVersionPublishingProfile struct {
	// TargetRegions - The target regions where the Image Version is going to be replicated to. This property is updatable.
	TargetRegions *[]TargetRegion `json:"targetRegions,omitempty"`
	// ReplicaCount - The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
	ReplicaCount *int32 `json:"replicaCount,omitempty"`
	// ExcludeFromLatest - If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
	ExcludeFromLatest *bool `json:"excludeFromLatest,omitempty"`
	// PublishedDate - READ-ONLY; The timestamp for when the gallery image version is published.
	PublishedDate *date.Time `json:"publishedDate,omitempty"`
	// EndOfLifeDate - The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
	EndOfLifeDate *date.Time `json:"endOfLifeDate,omitempty"`
	// StorageAccountType - Specifies the storage account type to be used to store the image. This property is not updatable. Possible values include: 'StorageAccountTypeStandardLRS', 'StorageAccountTypeStandardZRS', 'StorageAccountTypePremiumLRS'
	StorageAccountType StorageAccountType `json:"storageAccountType,omitempty"`
	// ReplicationMode - Optional parameter which specifies the mode to be used for replication. This property is not updatable. Possible values include: 'ReplicationModeFull', 'ReplicationModeShallow'
	ReplicationMode ReplicationMode `json:"replicationMode,omitempty"`
}

// MarshalJSON is the custom marshaler for GalleryImageVersionPublishingProfile.
func (givpp GalleryImageVersionPublishingProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if givpp.TargetRegions != nil {
		objectMap["targetRegions"] = givpp.TargetRegions
	}
	if givpp.ReplicaCount != nil {
		objectMap["replicaCount"] = givpp.ReplicaCount
	}
	if givpp.ExcludeFromLatest != nil {
		objectMap["excludeFromLatest"] = givpp.ExcludeFromLatest
	}
	if givpp.EndOfLifeDate != nil {
		objectMap["endOfLifeDate"] = givpp.EndOfLifeDate
	}
	if givpp.StorageAccountType != "" {
		objectMap["storageAccountType"] = givpp.StorageAccountType
	}
	if givpp.ReplicationMode != "" {
		objectMap["replicationMode"] = givpp.ReplicationMode
	}
	return json.Marshal(objectMap)
}

// GalleryImageVersionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GalleryImageVersionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GalleryImageVersionsClient) (GalleryImageVersion, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GalleryImageVersionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GalleryImageVersionsCreateOrUpdateFuture.Result.
func (future *GalleryImageVersionsCreateOrUpdateFuture) result(client GalleryImageVersionsClient) (giv GalleryImageVersion, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GalleryImageVersionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		giv.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GalleryImageVersionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if giv.Response.Response, err = future.GetResult(sender); err == nil && giv.Response.Response.StatusCode != http.StatusNoContent {
		giv, err = client.CreateOrUpdateResponder(giv.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.GalleryImageVersionsCreateOrUpdateFuture", "Result", giv.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GalleryImageVersionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GalleryImageVersionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GalleryImageVersionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GalleryImageVersionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GalleryImageVersionsDeleteFuture.Result.
func (future *GalleryImageVersionsDeleteFuture) result(client GalleryImageVersionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GalleryImageVersionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GalleryImageVersionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GalleryImageVersionStorageProfile this is the storage profile of a Gallery Image Version.
type GalleryImageVersionStorageProfile struct {
	Source      *GalleryArtifactVersionSource `json:"source,omitempty"`
	OsDiskImage *GalleryOSDiskImage           `json:"osDiskImage,omitempty"`
	// DataDiskImages - A list of data disk images.
	DataDiskImages *[]GalleryDataDiskImage `json:"dataDiskImages,omitempty"`
}

// GalleryImageVersionsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GalleryImageVersionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GalleryImageVersionsClient) (GalleryImageVersion, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GalleryImageVersionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GalleryImageVersionsUpdateFuture.Result.
func (future *GalleryImageVersionsUpdateFuture) result(client GalleryImageVersionsClient) (giv GalleryImageVersion, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GalleryImageVersionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		giv.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GalleryImageVersionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if giv.Response.Response, err = future.GetResult(sender); err == nil && giv.Response.Response.StatusCode != http.StatusNoContent {
		giv, err = client.UpdateResponder(giv.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.GalleryImageVersionsUpdateFuture", "Result", giv.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GalleryImageVersionUpdate specifies information about the gallery image version that you want to update.
type GalleryImageVersionUpdate struct {
	*GalleryImageVersionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GalleryImageVersionUpdate.
func (givu GalleryImageVersionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if givu.GalleryImageVersionProperties != nil {
		objectMap["properties"] = givu.GalleryImageVersionProperties
	}
	if givu.Tags != nil {
		objectMap["tags"] = givu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GalleryImageVersionUpdate struct.
func (givu *GalleryImageVersionUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var galleryImageVersionProperties GalleryImageVersionProperties
				err = json.Unmarshal(*v, &galleryImageVersionProperties)
				if err != nil {
					return err
				}
				givu.GalleryImageVersionProperties = &galleryImageVersionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				givu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				givu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				givu.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				givu.Tags = tags
			}
		}
	}

	return nil
}

// GalleryList the List Galleries operation response.
type GalleryList struct {
	autorest.Response `json:"-"`
	// Value - A list of galleries.
	Value *[]Gallery `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of galleries. Call ListNext() with this to fetch the next page of galleries.
	NextLink *string `json:"nextLink,omitempty"`
}

// GalleryListIterator provides access to a complete listing of Gallery values.
type GalleryListIterator struct {
	i    int
	page GalleryListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GalleryListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GalleryListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GalleryListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GalleryListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GalleryListIterator) Response() GalleryList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GalleryListIterator) Value() Gallery {
	if !iter.page.NotDone() {
		return Gallery{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GalleryListIterator type.
func NewGalleryListIterator(page GalleryListPage) GalleryListIterator {
	return GalleryListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (gl GalleryList) IsEmpty() bool {
	return gl.Value == nil || len(*gl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (gl GalleryList) hasNextLink() bool {
	return gl.NextLink != nil && len(*gl.NextLink) != 0
}

// galleryListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (gl GalleryList) galleryListPreparer(ctx context.Context) (*http.Request, error) {
	if !gl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(gl.NextLink)))
}

// GalleryListPage contains a page of Gallery values.
type GalleryListPage struct {
	fn func(context.Context, GalleryList) (GalleryList, error)
	gl GalleryList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GalleryListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GalleryListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.gl)
		if err != nil {
			return err
		}
		page.gl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GalleryListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GalleryListPage) NotDone() bool {
	return !page.gl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GalleryListPage) Response() GalleryList {
	return page.gl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GalleryListPage) Values() []Gallery {
	if page.gl.IsEmpty() {
		return nil
	}
	return *page.gl.Value
}

// Creates a new instance of the GalleryListPage type.
func NewGalleryListPage(cur GalleryList, getNextPage func(context.Context, GalleryList) (GalleryList, error)) GalleryListPage {
	return GalleryListPage{
		fn: getNextPage,
		gl: cur,
	}
}

// GalleryOSDiskImage this is the OS disk image.
type GalleryOSDiskImage struct {
	// SizeInGB - READ-ONLY; This property indicates the size of the VHD to be created.
	SizeInGB *int32 `json:"sizeInGB,omitempty"`
	// HostCaching - The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'. Possible values include: 'HostCachingNone', 'HostCachingReadOnly', 'HostCachingReadWrite'
	HostCaching HostCaching                   `json:"hostCaching,omitempty"`
	Source      *GalleryArtifactVersionSource `json:"source,omitempty"`
}

// MarshalJSON is the custom marshaler for GalleryOSDiskImage.
func (godi GalleryOSDiskImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if godi.HostCaching != "" {
		objectMap["hostCaching"] = godi.HostCaching
	}
	if godi.Source != nil {
		objectMap["source"] = godi.Source
	}
	return json.Marshal(objectMap)
}

// GalleryProperties describes the properties of a Shared Image Gallery.
type GalleryProperties struct {
	// Description - The description of this Shared Image Gallery resource. This property is updatable.
	Description *string            `json:"description,omitempty"`
	Identifier  *GalleryIdentifier `json:"identifier,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateFailed', 'ProvisioningStateSucceeded', 'ProvisioningStateDeleting', 'ProvisioningStateMigrating'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	SharingProfile    *SharingProfile   `json:"sharingProfile,omitempty"`
	SoftDeletePolicy  *SoftDeletePolicy `json:"softDeletePolicy,omitempty"`
}

// MarshalJSON is the custom marshaler for GalleryProperties.
func (gp GalleryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gp.Description != nil {
		objectMap["description"] = gp.Description
	}
	if gp.Identifier != nil {
		objectMap["identifier"] = gp.Identifier
	}
	if gp.SharingProfile != nil {
		objectMap["sharingProfile"] = gp.SharingProfile
	}
	if gp.SoftDeletePolicy != nil {
		objectMap["softDeletePolicy"] = gp.SoftDeletePolicy
	}
	return json.Marshal(objectMap)
}

// GallerySharingProfileUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GallerySharingProfileUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GallerySharingProfileClient) (SharingUpdate, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GallerySharingProfileUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GallerySharingProfileUpdateFuture.Result.
func (future *GallerySharingProfileUpdateFuture) result(client GallerySharingProfileClient) (su SharingUpdate, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.GallerySharingProfileUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		su.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.GallerySharingProfileUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if su.Response.Response, err = future.GetResult(sender); err == nil && su.Response.Response.StatusCode != http.StatusNoContent {
		su, err = client.UpdateResponder(su.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.GallerySharingProfileUpdateFuture", "Result", su.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GalleryUpdate specifies information about the Shared Image Gallery that you want to update.
type GalleryUpdate struct {
	*GalleryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GalleryUpdate.
func (gu GalleryUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gu.GalleryProperties != nil {
		objectMap["properties"] = gu.GalleryProperties
	}
	if gu.Tags != nil {
		objectMap["tags"] = gu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GalleryUpdate struct.
func (gu *GalleryUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var galleryProperties GalleryProperties
				err = json.Unmarshal(*v, &galleryProperties)
				if err != nil {
					return err
				}
				gu.GalleryProperties = &galleryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gu.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gu.Tags = tags
			}
		}
	}

	return nil
}

// GrantAccessData data used for requesting a SAS.
type GrantAccessData struct {
	// Access - Possible values include: 'AccessLevelNone', 'AccessLevelRead', 'AccessLevelWrite'
	Access AccessLevel `json:"access,omitempty"`
	// DurationInSeconds - Time duration in seconds until the SAS access expires.
	DurationInSeconds *int32 `json:"durationInSeconds,omitempty"`
	// GetSecureVMGuestStateSAS - Set this flag to true to get additional SAS for VM guest state
	GetSecureVMGuestStateSAS *bool `json:"getSecureVMGuestStateSAS,omitempty"`
}

// HardwareProfile specifies the hardware settings for the virtual machine.
type HardwareProfile struct {
	// VMSize - Specifies the size of the virtual machine. <br><br> The enum data type is currently deprecated and will be removed by December 23rd 2023. <br><br> Recommended way to get the list of available sizes is using these APIs: <br><br> [List all available virtual machine sizes in an availability set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes) <br><br> [List all available virtual machine sizes in a region]( https://docs.microsoft.com/rest/api/compute/resourceskus/list) <br><br> [List all available virtual machine sizes for resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes). For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/sizes). <br><br> The available VM sizes depend on region and availability set. Possible values include: 'VirtualMachineSizeTypesBasicA0', 'VirtualMachineSizeTypesBasicA1', 'VirtualMachineSizeTypesBasicA2', 'VirtualMachineSizeTypesBasicA3', 'VirtualMachineSizeTypesBasicA4', 'VirtualMachineSizeTypesStandardA0', 'VirtualMachineSizeTypesStandardA1', 'VirtualMachineSizeTypesStandardA2', 'VirtualMachineSizeTypesStandardA3', 'VirtualMachineSizeTypesStandardA4', 'VirtualMachineSizeTypesStandardA5', 'VirtualMachineSizeTypesStandardA6', 'VirtualMachineSizeTypesStandardA7', 'VirtualMachineSizeTypesStandardA8', 'VirtualMachineSizeTypesStandardA9', 'VirtualMachineSizeTypesStandardA10', 'VirtualMachineSizeTypesStandardA11', 'VirtualMachineSizeTypesStandardA1V2', 'VirtualMachineSizeTypesStandardA2V2', 'VirtualMachineSizeTypesStandardA4V2', 'VirtualMachineSizeTypesStandardA8V2', 'VirtualMachineSizeTypesStandardA2mV2', 'VirtualMachineSizeTypesStandardA4mV2', 'VirtualMachineSizeTypesStandardA8mV2', 'VirtualMachineSizeTypesStandardB1s', 'VirtualMachineSizeTypesStandardB1ms', 'VirtualMachineSizeTypesStandardB2s', 'VirtualMachineSizeTypesStandardB2ms', 'VirtualMachineSizeTypesStandardB4ms', 'VirtualMachineSizeTypesStandardB8ms', 'VirtualMachineSizeTypesStandardD1', 'VirtualMachineSizeTypesStandardD2', 'VirtualMachineSizeTypesStandardD3', 'VirtualMachineSizeTypesStandardD4', 'VirtualMachineSizeTypesStandardD11', 'VirtualMachineSizeTypesStandardD12', 'VirtualMachineSizeTypesStandardD13', 'VirtualMachineSizeTypesStandardD14', 'VirtualMachineSizeTypesStandardD1V2', 'VirtualMachineSizeTypesStandardD2V2', 'VirtualMachineSizeTypesStandardD3V2', 'VirtualMachineSizeTypesStandardD4V2', 'VirtualMachineSizeTypesStandardD5V2', 'VirtualMachineSizeTypesStandardD2V3', 'VirtualMachineSizeTypesStandardD4V3', 'VirtualMachineSizeTypesStandardD8V3', 'VirtualMachineSizeTypesStandardD16V3', 'VirtualMachineSizeTypesStandardD32V3', 'VirtualMachineSizeTypesStandardD64V3', 'VirtualMachineSizeTypesStandardD2sV3', 'VirtualMachineSizeTypesStandardD4sV3', 'VirtualMachineSizeTypesStandardD8sV3', 'VirtualMachineSizeTypesStandardD16sV3', 'VirtualMachineSizeTypesStandardD32sV3', 'VirtualMachineSizeTypesStandardD64sV3', 'VirtualMachineSizeTypesStandardD11V2', 'VirtualMachineSizeTypesStandardD12V2', 'VirtualMachineSizeTypesStandardD13V2', 'VirtualMachineSizeTypesStandardD14V2', 'VirtualMachineSizeTypesStandardD15V2', 'VirtualMachineSizeTypesStandardDS1', 'VirtualMachineSizeTypesStandardDS2', 'VirtualMachineSizeTypesStandardDS3', 'VirtualMachineSizeTypesStandardDS4', 'VirtualMachineSizeTypesStandardDS11', 'VirtualMachineSizeTypesStandardDS12', 'VirtualMachineSizeTypesStandardDS13', 'VirtualMachineSizeTypesStandardDS14', 'VirtualMachineSizeTypesStandardDS1V2', 'VirtualMachineSizeTypesStandardDS2V2', 'VirtualMachineSizeTypesStandardDS3V2', 'VirtualMachineSizeTypesStandardDS4V2', 'VirtualMachineSizeTypesStandardDS5V2', 'VirtualMachineSizeTypesStandardDS11V2', 'VirtualMachineSizeTypesStandardDS12V2', 'VirtualMachineSizeTypesStandardDS13V2', 'VirtualMachineSizeTypesStandardDS14V2', 'VirtualMachineSizeTypesStandardDS15V2', 'VirtualMachineSizeTypesStandardDS134V2', 'VirtualMachineSizeTypesStandardDS132V2', 'VirtualMachineSizeTypesStandardDS148V2', 'VirtualMachineSizeTypesStandardDS144V2', 'VirtualMachineSizeTypesStandardE2V3', 'VirtualMachineSizeTypesStandardE4V3', 'VirtualMachineSizeTypesStandardE8V3', 'VirtualMachineSizeTypesStandardE16V3', 'VirtualMachineSizeTypesStandardE32V3', 'VirtualMachineSizeTypesStandardE64V3', 'VirtualMachineSizeTypesStandardE2sV3', 'VirtualMachineSizeTypesStandardE4sV3', 'VirtualMachineSizeTypesStandardE8sV3', 'VirtualMachineSizeTypesStandardE16sV3', 'VirtualMachineSizeTypesStandardE32sV3', 'VirtualMachineSizeTypesStandardE64sV3', 'VirtualMachineSizeTypesStandardE3216V3', 'VirtualMachineSizeTypesStandardE328sV3', 'VirtualMachineSizeTypesStandardE6432sV3', 'VirtualMachineSizeTypesStandardE6416sV3', 'VirtualMachineSizeTypesStandardF1', 'VirtualMachineSizeTypesStandardF2', 'VirtualMachineSizeTypesStandardF4', 'VirtualMachineSizeTypesStandardF8', 'VirtualMachineSizeTypesStandardF16', 'VirtualMachineSizeTypesStandardF1s', 'VirtualMachineSizeTypesStandardF2s', 'VirtualMachineSizeTypesStandardF4s', 'VirtualMachineSizeTypesStandardF8s', 'VirtualMachineSizeTypesStandardF16s', 'VirtualMachineSizeTypesStandardF2sV2', 'VirtualMachineSizeTypesStandardF4sV2', 'VirtualMachineSizeTypesStandardF8sV2', 'VirtualMachineSizeTypesStandardF16sV2', 'VirtualMachineSizeTypesStandardF32sV2', 'VirtualMachineSizeTypesStandardF64sV2', 'VirtualMachineSizeTypesStandardF72sV2', 'VirtualMachineSizeTypesStandardG1', 'VirtualMachineSizeTypesStandardG2', 'VirtualMachineSizeTypesStandardG3', 'VirtualMachineSizeTypesStandardG4', 'VirtualMachineSizeTypesStandardG5', 'VirtualMachineSizeTypesStandardGS1', 'VirtualMachineSizeTypesStandardGS2', 'VirtualMachineSizeTypesStandardGS3', 'VirtualMachineSizeTypesStandardGS4', 'VirtualMachineSizeTypesStandardGS5', 'VirtualMachineSizeTypesStandardGS48', 'VirtualMachineSizeTypesStandardGS44', 'VirtualMachineSizeTypesStandardGS516', 'VirtualMachineSizeTypesStandardGS58', 'VirtualMachineSizeTypesStandardH8', 'VirtualMachineSizeTypesStandardH16', 'VirtualMachineSizeTypesStandardH8m', 'VirtualMachineSizeTypesStandardH16m', 'VirtualMachineSizeTypesStandardH16r', 'VirtualMachineSizeTypesStandardH16mr', 'VirtualMachineSizeTypesStandardL4s', 'VirtualMachineSizeTypesStandardL8s', 'VirtualMachineSizeTypesStandardL16s', 'VirtualMachineSizeTypesStandardL32s', 'VirtualMachineSizeTypesStandardM64s', 'VirtualMachineSizeTypesStandardM64ms', 'VirtualMachineSizeTypesStandardM128s', 'VirtualMachineSizeTypesStandardM128ms', 'VirtualMachineSizeTypesStandardM6432ms', 'VirtualMachineSizeTypesStandardM6416ms', 'VirtualMachineSizeTypesStandardM12864ms', 'VirtualMachineSizeTypesStandardM12832ms', 'VirtualMachineSizeTypesStandardNC6', 'VirtualMachineSizeTypesStandardNC12', 'VirtualMachineSizeTypesStandardNC24', 'VirtualMachineSizeTypesStandardNC24r', 'VirtualMachineSizeTypesStandardNC6sV2', 'VirtualMachineSizeTypesStandardNC12sV2', 'VirtualMachineSizeTypesStandardNC24sV2', 'VirtualMachineSizeTypesStandardNC24rsV2', 'VirtualMachineSizeTypesStandardNC6sV3', 'VirtualMachineSizeTypesStandardNC12sV3', 'VirtualMachineSizeTypesStandardNC24sV3', 'VirtualMachineSizeTypesStandardNC24rsV3', 'VirtualMachineSizeTypesStandardND6s', 'VirtualMachineSizeTypesStandardND12s', 'VirtualMachineSizeTypesStandardND24s', 'VirtualMachineSizeTypesStandardND24rs', 'VirtualMachineSizeTypesStandardNV6', 'VirtualMachineSizeTypesStandardNV12', 'VirtualMachineSizeTypesStandardNV24'
	VMSize VirtualMachineSizeTypes `json:"vmSize,omitempty"`
	// VMSizeProperties - Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-07-01. <br><br> This feature is still in preview mode and is not supported for VirtualMachineScaleSet. <br><br> Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for more details.
	VMSizeProperties *VMSizeProperties `json:"vmSizeProperties,omitempty"`
}

// Image the source user image virtual hard disk. The virtual hard disk will be copied before being
// attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not
// exist.
type Image struct {
	autorest.Response `json:"-"`
	*ImageProperties  `json:"properties,omitempty"`
	// ExtendedLocation - The extended location of the Image.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Image.
func (i Image) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.ImageProperties != nil {
		objectMap["properties"] = i.ImageProperties
	}
	if i.ExtendedLocation != nil {
		objectMap["extendedLocation"] = i.ExtendedLocation
	}
	if i.Location != nil {
		objectMap["location"] = i.Location
	}
	if i.Tags != nil {
		objectMap["tags"] = i.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Image struct.
func (i *Image) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var imageProperties ImageProperties
				err = json.Unmarshal(*v, &imageProperties)
				if err != nil {
					return err
				}
				i.ImageProperties = &imageProperties
			}
		case "extendedLocation":
			if v != nil {
				var extendedLocation ExtendedLocation
				err = json.Unmarshal(*v, &extendedLocation)
				if err != nil {
					return err
				}
				i.ExtendedLocation = &extendedLocation
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				i.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				i.Tags = tags
			}
		}
	}

	return nil
}

// ImageDataDisk describes a data disk.
type ImageDataDisk struct {
	// Lun - Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
	Lun *int32 `json:"lun,omitempty"`
	// Snapshot - The snapshot.
	Snapshot *SubResource `json:"snapshot,omitempty"`
	// ManagedDisk - The managedDisk.
	ManagedDisk *SubResource `json:"managedDisk,omitempty"`
	// BlobURI - The Virtual Hard Disk.
	BlobURI *string `json:"blobUri,omitempty"`
	// Caching - Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**. Possible values include: 'CachingTypesNone', 'CachingTypesReadOnly', 'CachingTypesReadWrite'
	Caching CachingTypes `json:"caching,omitempty"`
	// DiskSizeGB - Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
	// StorageAccountType - Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Possible values include: 'StorageAccountTypesStandardLRS', 'StorageAccountTypesPremiumLRS', 'StorageAccountTypesStandardSSDLRS', 'StorageAccountTypesUltraSSDLRS', 'StorageAccountTypesPremiumZRS', 'StorageAccountTypesStandardSSDZRS'
	StorageAccountType StorageAccountTypes `json:"storageAccountType,omitempty"`
	// DiskEncryptionSet - Specifies the customer managed disk encryption set resource id for the managed image disk.
	DiskEncryptionSet *DiskEncryptionSetParameters `json:"diskEncryptionSet,omitempty"`
}

// ImageDisk describes a image disk.
type ImageDisk struct {
	// Snapshot - The snapshot.
	Snapshot *SubResource `json:"snapshot,omitempty"`
	// ManagedDisk - The managedDisk.
	ManagedDisk *SubResource `json:"managedDisk,omitempty"`
	// BlobURI - The Virtual Hard Disk.
	BlobURI *string `json:"blobUri,omitempty"`
	// Caching - Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**. Possible values include: 'CachingTypesNone', 'CachingTypesReadOnly', 'CachingTypesReadWrite'
	Caching CachingTypes `json:"caching,omitempty"`
	// DiskSizeGB - Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
	// StorageAccountType - Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Possible values include: 'StorageAccountTypesStandardLRS', 'StorageAccountTypesPremiumLRS', 'StorageAccountTypesStandardSSDLRS', 'StorageAccountTypesUltraSSDLRS', 'StorageAccountTypesPremiumZRS', 'StorageAccountTypesStandardSSDZRS'
	StorageAccountType StorageAccountTypes `json:"storageAccountType,omitempty"`
	// DiskEncryptionSet - Specifies the customer managed disk encryption set resource id for the managed image disk.
	DiskEncryptionSet *DiskEncryptionSetParameters `json:"diskEncryptionSet,omitempty"`
}

// ImageDiskReference the source image used for creating the disk.
type ImageDiskReference struct {
	// ID - A relative uri containing either a Platform Image Repository or user image reference.
	ID *string `json:"id,omitempty"`
	// Lun - If the disk is created from an image's data disk, this is an index that indicates which of the data disks in the image to use. For OS disks, this field is null.
	Lun *int32 `json:"lun,omitempty"`
}

// ImageListResult the List Image operation response.
type ImageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Images.
	Value *[]Image `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of Images. Call ListNext() with this to fetch the next page of Images.
	NextLink *string `json:"nextLink,omitempty"`
}

// ImageListResultIterator provides access to a complete listing of Image values.
type ImageListResultIterator struct {
	i    int
	page ImageListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ImageListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ImageListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ImageListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ImageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ImageListResultIterator) Response() ImageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ImageListResultIterator) Value() Image {
	if !iter.page.NotDone() {
		return Image{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ImageListResultIterator type.
func NewImageListResultIterator(page ImageListResultPage) ImageListResultIterator {
	return ImageListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ilr ImageListResult) IsEmpty() bool {
	return ilr.Value == nil || len(*ilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ilr ImageListResult) hasNextLink() bool {
	return ilr.NextLink != nil && len(*ilr.NextLink) != 0
}

// imageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilr ImageListResult) imageListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilr.NextLink)))
}

// ImageListResultPage contains a page of Image values.
type ImageListResultPage struct {
	fn  func(context.Context, ImageListResult) (ImageListResult, error)
	ilr ImageListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ImageListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ImageListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ilr)
		if err != nil {
			return err
		}
		page.ilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ImageListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ImageListResultPage) NotDone() bool {
	return !page.ilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ImageListResultPage) Response() ImageListResult {
	return page.ilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ImageListResultPage) Values() []Image {
	if page.ilr.IsEmpty() {
		return nil
	}
	return *page.ilr.Value
}

// Creates a new instance of the ImageListResultPage type.
func NewImageListResultPage(cur ImageListResult, getNextPage func(context.Context, ImageListResult) (ImageListResult, error)) ImageListResultPage {
	return ImageListResultPage{
		fn:  getNextPage,
		ilr: cur,
	}
}

// ImageOSDisk describes an Operating System disk.
type ImageOSDisk struct {
	// OsType - This property allows you to specify the type of the OS that is included in the disk if creating a VM from a custom image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**. Possible values include: 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// OsState - The OS State. Possible values include: 'OperatingSystemStateTypesGeneralized', 'OperatingSystemStateTypesSpecialized'
	OsState OperatingSystemStateTypes `json:"osState,omitempty"`
	// Snapshot - The snapshot.
	Snapshot *SubResource `json:"snapshot,omitempty"`
	// ManagedDisk - The managedDisk.
	ManagedDisk *SubResource `json:"managedDisk,omitempty"`
	// BlobURI - The Virtual Hard Disk.
	BlobURI *string `json:"blobUri,omitempty"`
	// Caching - Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**. Possible values include: 'CachingTypesNone', 'CachingTypesReadOnly', 'CachingTypesReadWrite'
	Caching CachingTypes `json:"caching,omitempty"`
	// DiskSizeGB - Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
	// StorageAccountType - Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Possible values include: 'StorageAccountTypesStandardLRS', 'StorageAccountTypesPremiumLRS', 'StorageAccountTypesStandardSSDLRS', 'StorageAccountTypesUltraSSDLRS', 'StorageAccountTypesPremiumZRS', 'StorageAccountTypesStandardSSDZRS'
	StorageAccountType StorageAccountTypes `json:"storageAccountType,omitempty"`
	// DiskEncryptionSet - Specifies the customer managed disk encryption set resource id for the managed image disk.
	DiskEncryptionSet *DiskEncryptionSetParameters `json:"diskEncryptionSet,omitempty"`
}

// ImageProperties describes the properties of an Image.
type ImageProperties struct {
	// SourceVirtualMachine - The source virtual machine from which Image is created.
	SourceVirtualMachine *SubResource `json:"sourceVirtualMachine,omitempty"`
	// StorageProfile - Specifies the storage settings for the virtual machine disks.
	StorageProfile *ImageStorageProfile `json:"storageProfile,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// HyperVGeneration - Specifies the HyperVGenerationType of the VirtualMachine created from the image. From API Version 2019-03-01 if the image source is a blob, then we need the user to specify the value, if the source is managed resource like disk or snapshot, we may require the user to specify the property if we cannot deduce it from the source managed resource. Possible values include: 'HyperVGenerationTypesV1', 'HyperVGenerationTypesV2'
	HyperVGeneration HyperVGenerationTypes `json:"hyperVGeneration,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageProperties.
func (IP ImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.SourceVirtualMachine != nil {
		objectMap["sourceVirtualMachine"] = IP.SourceVirtualMachine
	}
	if IP.StorageProfile != nil {
		objectMap["storageProfile"] = IP.StorageProfile
	}
	if IP.HyperVGeneration != "" {
		objectMap["hyperVGeneration"] = IP.HyperVGeneration
	}
	return json.Marshal(objectMap)
}

// ImagePurchasePlan describes the gallery image definition purchase plan. This is used by marketplace
// images.
type ImagePurchasePlan struct {
	// Name - The plan ID.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher ID.
	Publisher *string `json:"publisher,omitempty"`
	// Product - The product ID.
	Product *string `json:"product,omitempty"`
}

// ImageReference specifies information about the image to use. You can specify information about platform
// images, marketplace images, or virtual machine images. This element is required when you want to use a
// platform image, marketplace image, or virtual machine image, but is not used in other creation
// operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.
type ImageReference struct {
	// Publisher - The image publisher.
	Publisher *string `json:"publisher,omitempty"`
	// Offer - Specifies the offer of the platform image or marketplace image used to create the virtual machine.
	Offer *string `json:"offer,omitempty"`
	// Sku - The image SKU.
	Sku *string `json:"sku,omitempty"`
	// Version - Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
	Version *string `json:"version,omitempty"`
	// ExactVersion - READ-ONLY; Specifies in decimal numbers, the version of platform image or marketplace image used to create the virtual machine. This readonly field differs from 'version', only if the value specified in 'version' field is 'latest'.
	ExactVersion *string `json:"exactVersion,omitempty"`
	// SharedGalleryImageID - Specified the shared gallery image unique id for vm deployment. This can be fetched from shared gallery image GET call.
	SharedGalleryImageID *string `json:"sharedGalleryImageId,omitempty"`
	// CommunityGalleryImageID - Specified the community gallery image unique id for vm deployment. This can be fetched from community gallery image GET call.
	CommunityGalleryImageID *string `json:"communityGalleryImageId,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageReference.
func (ir ImageReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ir.Publisher != nil {
		objectMap["publisher"] = ir.Publisher
	}
	if ir.Offer != nil {
		objectMap["offer"] = ir.Offer
	}
	if ir.Sku != nil {
		objectMap["sku"] = ir.Sku
	}
	if ir.Version != nil {
		objectMap["version"] = ir.Version
	}
	if ir.SharedGalleryImageID != nil {
		objectMap["sharedGalleryImageId"] = ir.SharedGalleryImageID
	}
	if ir.CommunityGalleryImageID != nil {
		objectMap["communityGalleryImageId"] = ir.CommunityGalleryImageID
	}
	if ir.ID != nil {
		objectMap["id"] = ir.ID
	}
	return json.Marshal(objectMap)
}

// ImagesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ImagesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ImagesClient) (Image, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ImagesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ImagesCreateOrUpdateFuture.Result.
func (future *ImagesCreateOrUpdateFuture) result(client ImagesClient) (i Image, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.ImagesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		i.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.ImagesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if i.Response.Response, err = future.GetResult(sender); err == nil && i.Response.Response.StatusCode != http.StatusNoContent {
		i, err = client.CreateOrUpdateResponder(i.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.ImagesCreateOrUpdateFuture", "Result", i.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ImagesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ImagesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ImagesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ImagesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ImagesDeleteFuture.Result.
func (future *ImagesDeleteFuture) result(client ImagesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.ImagesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.ImagesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ImageStorageProfile describes a storage profile.
type ImageStorageProfile struct {
	// OsDisk - Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
	OsDisk *ImageOSDisk `json:"osDisk,omitempty"`
	// DataDisks - Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
	DataDisks *[]ImageDataDisk `json:"dataDisks,omitempty"`
	// ZoneResilient - Specifies whether an image is zone resilient or not. Default is false. Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
	ZoneResilient *bool `json:"zoneResilient,omitempty"`
}

// ImagesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ImagesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ImagesClient) (Image, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ImagesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ImagesUpdateFuture.Result.
func (future *ImagesUpdateFuture) result(client ImagesClient) (i Image, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.ImagesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		i.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.ImagesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if i.Response.Response, err = future.GetResult(sender); err == nil && i.Response.Response.StatusCode != http.StatusNoContent {
		i, err = client.UpdateResponder(i.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.ImagesUpdateFuture", "Result", i.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ImageUpdate the source user image virtual hard disk. Only tags may be updated.
type ImageUpdate struct {
	*ImageProperties `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ImageUpdate.
func (iu ImageUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iu.ImageProperties != nil {
		objectMap["properties"] = iu.ImageProperties
	}
	if iu.Tags != nil {
		objectMap["tags"] = iu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImageUpdate struct.
func (iu *ImageUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var imageProperties ImageProperties
				err = json.Unmarshal(*v, &imageProperties)
				if err != nil {
					return err
				}
				iu.ImageProperties = &imageProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				iu.Tags = tags
			}
		}
	}

	return nil
}

// InnerError inner error details.
type InnerError struct {
	// Exceptiontype - The exception type.
	Exceptiontype *string `json:"exceptiontype,omitempty"`
	// Errordetail - The internal error message or exception dump.
	Errordetail *string `json:"errordetail,omitempty"`
}

// InstanceSku ...
type InstanceSku struct {
	// Name - READ-ONLY; The sku name.
	Name *string `json:"name,omitempty"`
	// Tier - READ-ONLY; The tier of the cloud service role instance.
	Tier *string `json:"tier,omitempty"`
}

// MarshalJSON is the custom marshaler for InstanceSku.
func (is InstanceSku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// InstanceViewStatus instance view status.
type InstanceViewStatus struct {
	// Code - The status code.
	Code *string `json:"code,omitempty"`
	// Level - The level code. Possible values include: 'StatusLevelTypesInfo', 'StatusLevelTypesWarning', 'StatusLevelTypesError'
	Level StatusLevelTypes `json:"level,omitempty"`
	// DisplayStatus - The short localizable label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty"`
	// Message - The detailed status message, including for alerts and error messages.
	Message *string `json:"message,omitempty"`
	// Time - The time of the status.
	Time *date.Time `json:"time,omitempty"`
}

// InstanceViewStatusesSummary instance view statuses.
type InstanceViewStatusesSummary struct {
	// StatusesSummary - READ-ONLY
	StatusesSummary *[]StatusCodeCount `json:"statusesSummary,omitempty"`
}

// MarshalJSON is the custom marshaler for InstanceViewStatusesSummary.
func (ivss InstanceViewStatusesSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// KeyForDiskEncryptionSet key Vault Key Url to be used for server side encryption of Managed Disks and
// Snapshots
type KeyForDiskEncryptionSet struct {
	// SourceVault - Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
	SourceVault *SourceVault `json:"sourceVault,omitempty"`
	// KeyURL - Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is required regardless of rotationToLatestKeyVersionEnabled value.
	KeyURL *string `json:"keyUrl,omitempty"`
}

// KeyVaultAndKeyReference key Vault Key Url and vault id of KeK, KeK is optional and when provided is used
// to unwrap the encryptionKey
type KeyVaultAndKeyReference struct {
	// SourceVault - Resource id of the KeyVault containing the key or secret
	SourceVault *SourceVault `json:"sourceVault,omitempty"`
	// KeyURL - Url pointing to a key or secret in KeyVault
	KeyURL *string `json:"keyUrl,omitempty"`
}

// KeyVaultAndSecretReference key Vault Secret Url and vault id of the encryption key
type KeyVaultAndSecretReference struct {
	// SourceVault - Resource id of the KeyVault containing the key or secret
	SourceVault *SourceVault `json:"sourceVault,omitempty"`
	// SecretURL - Url pointing to a key or secret in KeyVault
	SecretURL *string `json:"secretUrl,omitempty"`
}

// KeyVaultKeyReference describes a reference to Key Vault Key
type KeyVaultKeyReference struct {
	// KeyURL - The URL referencing a key encryption key in Key Vault.
	KeyURL *string `json:"keyUrl,omitempty"`
	// SourceVault - The relative URL of the Key Vault containing the key.
	SourceVault *SubResource `json:"sourceVault,omitempty"`
}

// KeyVaultSecretReference describes a reference to Key Vault Secret
type KeyVaultSecretReference struct {
	// SecretURL - The URL referencing a secret in a Key Vault.
	SecretURL *string `json:"secretUrl,omitempty"`
	// SourceVault - The relative URL of the Key Vault containing the secret.
	SourceVault *SubResource `json:"sourceVault,omitempty"`
}

// LastPatchInstallationSummary describes the properties of the last installed patch summary.
type LastPatchInstallationSummary struct {
	// Status - READ-ONLY; The overall success or failure status of the operation. It remains "InProgress" until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded", or "CompletedWithWarnings.". Possible values include: 'PatchOperationStatusUnknown', 'PatchOperationStatusInProgress', 'PatchOperationStatusFailed', 'PatchOperationStatusSucceeded', 'PatchOperationStatusCompletedWithWarnings'
	Status PatchOperationStatus `json:"status,omitempty"`
	// InstallationActivityID - READ-ONLY; The activity ID of the operation that produced this result. It is used to correlate across CRP and extension logs.
	InstallationActivityID *string `json:"installationActivityId,omitempty"`
	// MaintenanceWindowExceeded - READ-ONLY; Describes whether the operation ran out of time before it completed all its intended actions
	MaintenanceWindowExceeded *bool `json:"maintenanceWindowExceeded,omitempty"`
	// NotSelectedPatchCount - READ-ONLY; The number of all available patches but not going to be installed because it didn't match a classification or inclusion list entry.
	NotSelectedPatchCount *int32 `json:"notSelectedPatchCount,omitempty"`
	// ExcludedPatchCount - READ-ONLY; The number of all available patches but excluded explicitly by a customer-specified exclusion list match.
	ExcludedPatchCount *int32 `json:"excludedPatchCount,omitempty"`
	// PendingPatchCount - READ-ONLY; The number of all available patches expected to be installed over the course of the patch installation operation.
	PendingPatchCount *int32 `json:"pendingPatchCount,omitempty"`
	// InstalledPatchCount - READ-ONLY; The count of patches that successfully installed.
	InstalledPatchCount *int32 `json:"installedPatchCount,omitempty"`
	// FailedPatchCount - READ-ONLY; The count of patches that failed installation.
	FailedPatchCount *int32 `json:"failedPatchCount,omitempty"`
	// StartTime - READ-ONLY; The UTC timestamp when the operation began.
	StartTime *date.Time `json:"startTime,omitempty"`
	// LastModifiedTime - READ-ONLY; The UTC timestamp when the operation began.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Error - READ-ONLY; The errors that were encountered during execution of the operation. The details array contains the list of them.
	Error *APIError `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for LastPatchInstallationSummary.
func (lpis LastPatchInstallationSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LinuxConfiguration specifies the Linux operating system settings on the virtual machine. <br><br>For a
// list of supported Linux distributions, see [Linux on Azure-Endorsed
// Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
type LinuxConfiguration struct {
	// DisablePasswordAuthentication - Specifies whether password authentication should be disabled.
	DisablePasswordAuthentication *bool `json:"disablePasswordAuthentication,omitempty"`
	// SSH - Specifies the ssh key configuration for a Linux OS.
	SSH *SSHConfiguration `json:"ssh,omitempty"`
	// ProvisionVMAgent - Indicates whether virtual machine agent should be provisioned on the virtual machine. <br><br> When this property is not specified in the request body, default behavior is to set it to true.  This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
	ProvisionVMAgent *bool `json:"provisionVMAgent,omitempty"`
	// PatchSettings - [Preview Feature] Specifies settings related to VM Guest Patching on Linux.
	PatchSettings *LinuxPatchSettings `json:"patchSettings,omitempty"`
}

// LinuxParameters input for InstallPatches on a Linux VM, as directly received by the API
type LinuxParameters struct {
	// ClassificationsToInclude - The update classifications to select when installing patches for Linux.
	ClassificationsToInclude *[]VMGuestPatchClassificationLinux `json:"classificationsToInclude,omitempty"`
	// PackageNameMasksToInclude - packages to include in the patch operation. Format: packageName_packageVersion
	PackageNameMasksToInclude *[]string `json:"packageNameMasksToInclude,omitempty"`
	// PackageNameMasksToExclude - packages to exclude in the patch operation. Format: packageName_packageVersion
	PackageNameMasksToExclude *[]string `json:"packageNameMasksToExclude,omitempty"`
	// MaintenanceRunID - This is used as a maintenance run identifier for Auto VM Guest Patching in Linux.
	MaintenanceRunID *string `json:"maintenanceRunId,omitempty"`
}

// LinuxPatchSettings specifies settings related to VM Guest Patching on Linux.
type LinuxPatchSettings struct {
	// PatchMode - Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - The virtual machine's default patching configuration is used. <br /><br /> **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform. The property provisionVMAgent must be true. Possible values include: 'LinuxVMGuestPatchModeImageDefault', 'LinuxVMGuestPatchModeAutomaticByPlatform'
	PatchMode LinuxVMGuestPatchMode `json:"patchMode,omitempty"`
	// AssessmentMode - Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine. <br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true. Possible values include: 'LinuxPatchAssessmentModeImageDefault', 'LinuxPatchAssessmentModeAutomaticByPlatform'
	AssessmentMode LinuxPatchAssessmentMode `json:"assessmentMode,omitempty"`
}

// ListUsagesResult the List Usages operation response.
type ListUsagesResult struct {
	autorest.Response `json:"-"`
	// Value - The list of compute resource usages.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of compute resource usage information. Call ListNext() with this to fetch the next page of compute resource usage information.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListUsagesResultIterator provides access to a complete listing of Usage values.
type ListUsagesResultIterator struct {
	i    int
	page ListUsagesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListUsagesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListUsagesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListUsagesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListUsagesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListUsagesResultIterator) Response() ListUsagesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListUsagesResultIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListUsagesResultIterator type.
func NewListUsagesResultIterator(page ListUsagesResultPage) ListUsagesResultIterator {
	return ListUsagesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lur ListUsagesResult) IsEmpty() bool {
	return lur.Value == nil || len(*lur.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lur ListUsagesResult) hasNextLink() bool {
	return lur.NextLink != nil && len(*lur.NextLink) != 0
}

// listUsagesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lur ListUsagesResult) listUsagesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lur.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lur.NextLink)))
}

// ListUsagesResultPage contains a page of Usage values.
type ListUsagesResultPage struct {
	fn  func(context.Context, ListUsagesResult) (ListUsagesResult, error)
	lur ListUsagesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListUsagesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListUsagesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lur)
		if err != nil {
			return err
		}
		page.lur = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListUsagesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListUsagesResultPage) NotDone() bool {
	return !page.lur.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListUsagesResultPage) Response() ListUsagesResult {
	return page.lur
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListUsagesResultPage) Values() []Usage {
	if page.lur.IsEmpty() {
		return nil
	}
	return *page.lur.Value
}

// Creates a new instance of the ListUsagesResultPage type.
func NewListUsagesResultPage(cur ListUsagesResult, getNextPage func(context.Context, ListUsagesResult) (ListUsagesResult, error)) ListUsagesResultPage {
	return ListUsagesResultPage{
		fn:  getNextPage,
		lur: cur,
	}
}

// ListVirtualMachineExtensionImage ...
type ListVirtualMachineExtensionImage struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachineExtensionImage `json:"value,omitempty"`
}

// ListVirtualMachineImageResource ...
type ListVirtualMachineImageResource struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachineImageResource `json:"value,omitempty"`
}

// LoadBalancerConfiguration describes the load balancer configuration.
type LoadBalancerConfiguration struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - The name of the Load balancer
	Name *string `json:"name,omitempty"`
	// Properties - Properties of the load balancer configuration.
	Properties *LoadBalancerConfigurationProperties `json:"properties,omitempty"`
}

// LoadBalancerConfigurationProperties ...
type LoadBalancerConfigurationProperties struct {
	// FrontendIPConfigurations - Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly one frontend IP configuration.
	FrontendIPConfigurations *[]LoadBalancerFrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
}

// LoadBalancerFrontendIPConfiguration ...
type LoadBalancerFrontendIPConfiguration struct {
	// Name - The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Properties - Properties of load balancer frontend ip configuration.
	Properties *LoadBalancerFrontendIPConfigurationProperties `json:"properties,omitempty"`
}

// LoadBalancerFrontendIPConfigurationProperties describes a cloud service IP Configuration
type LoadBalancerFrontendIPConfigurationProperties struct {
	// PublicIPAddress - The reference to the public ip address resource.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// Subnet - The reference to the virtual network subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`
	// PrivateIPAddress - The virtual network private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
}

// LogAnalyticsExportRequestRateByIntervalFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type LogAnalyticsExportRequestRateByIntervalFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LogAnalyticsClient) (LogAnalyticsOperationResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LogAnalyticsExportRequestRateByIntervalFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LogAnalyticsExportRequestRateByIntervalFuture.Result.
func (future *LogAnalyticsExportRequestRateByIntervalFuture) result(client LogAnalyticsClient) (laor LogAnalyticsOperationResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.LogAnalyticsExportRequestRateByIntervalFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		laor.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.LogAnalyticsExportRequestRateByIntervalFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if laor.Response.Response, err = future.GetResult(sender); err == nil && laor.Response.Response.StatusCode != http.StatusNoContent {
		laor, err = client.ExportRequestRateByIntervalResponder(laor.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.LogAnalyticsExportRequestRateByIntervalFuture", "Result", laor.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LogAnalyticsExportThrottledRequestsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LogAnalyticsExportThrottledRequestsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LogAnalyticsClient) (LogAnalyticsOperationResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LogAnalyticsExportThrottledRequestsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LogAnalyticsExportThrottledRequestsFuture.Result.
func (future *LogAnalyticsExportThrottledRequestsFuture) result(client LogAnalyticsClient) (laor LogAnalyticsOperationResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.LogAnalyticsExportThrottledRequestsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		laor.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.LogAnalyticsExportThrottledRequestsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if laor.Response.Response, err = future.GetResult(sender); err == nil && laor.Response.Response.StatusCode != http.StatusNoContent {
		laor, err = client.ExportThrottledRequestsResponder(laor.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.LogAnalyticsExportThrottledRequestsFuture", "Result", laor.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LogAnalyticsInputBase api input base class for LogAnalytics Api.
type LogAnalyticsInputBase struct {
	// BlobContainerSasURI - SAS Uri of the logging blob container to which LogAnalytics Api writes output logs to.
	BlobContainerSasURI *string `json:"blobContainerSasUri,omitempty"`
	// FromTime - From time of the query
	FromTime *date.Time `json:"fromTime,omitempty"`
	// ToTime - To time of the query
	ToTime *date.Time `json:"toTime,omitempty"`
	// GroupByThrottlePolicy - Group query result by Throttle Policy applied.
	GroupByThrottlePolicy *bool `json:"groupByThrottlePolicy,omitempty"`
	// GroupByOperationName - Group query result by Operation Name.
	GroupByOperationName *bool `json:"groupByOperationName,omitempty"`
	// GroupByResourceName - Group query result by Resource Name.
	GroupByResourceName *bool `json:"groupByResourceName,omitempty"`
	// GroupByClientApplicationID - Group query result by Client Application ID.
	GroupByClientApplicationID *bool `json:"groupByClientApplicationId,omitempty"`
	// GroupByUserAgent - Group query result by User Agent.
	GroupByUserAgent *bool `json:"groupByUserAgent,omitempty"`
}

// LogAnalyticsOperationResult logAnalytics operation status response
type LogAnalyticsOperationResult struct {
	autorest.Response `json:"-"`
	// Properties - READ-ONLY; LogAnalyticsOutput
	Properties *LogAnalyticsOutput `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for LogAnalyticsOperationResult.
func (laor LogAnalyticsOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LogAnalyticsOutput logAnalytics output properties
type LogAnalyticsOutput struct {
	// Output - READ-ONLY; Output file Uri path to blob container.
	Output *string `json:"output,omitempty"`
}

// MarshalJSON is the custom marshaler for LogAnalyticsOutput.
func (lao LogAnalyticsOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MaintenanceRedeployStatus maintenance Operation Status.
type MaintenanceRedeployStatus struct {
	// IsCustomerInitiatedMaintenanceAllowed - True, if customer is allowed to perform Maintenance.
	IsCustomerInitiatedMaintenanceAllowed *bool `json:"isCustomerInitiatedMaintenanceAllowed,omitempty"`
	// PreMaintenanceWindowStartTime - Start Time for the Pre Maintenance Window.
	PreMaintenanceWindowStartTime *date.Time `json:"preMaintenanceWindowStartTime,omitempty"`
	// PreMaintenanceWindowEndTime - End Time for the Pre Maintenance Window.
	PreMaintenanceWindowEndTime *date.Time `json:"preMaintenanceWindowEndTime,omitempty"`
	// MaintenanceWindowStartTime - Start Time for the Maintenance Window.
	MaintenanceWindowStartTime *date.Time `json:"maintenanceWindowStartTime,omitempty"`
	// MaintenanceWindowEndTime - End Time for the Maintenance Window.
	MaintenanceWindowEndTime *date.Time `json:"maintenanceWindowEndTime,omitempty"`
	// LastOperationResultCode - The Last Maintenance Operation Result Code. Possible values include: 'MaintenanceOperationResultCodeTypesNone', 'MaintenanceOperationResultCodeTypesRetryLater', 'MaintenanceOperationResultCodeTypesMaintenanceAborted', 'MaintenanceOperationResultCodeTypesMaintenanceCompleted'
	LastOperationResultCode MaintenanceOperationResultCodeTypes `json:"lastOperationResultCode,omitempty"`
	// LastOperationMessage - Message returned for the last Maintenance Operation.
	LastOperationMessage *string `json:"lastOperationMessage,omitempty"`
}

// ManagedArtifact the managed artifact.
type ManagedArtifact struct {
	// ID - The managed artifact id.
	ID *string `json:"id,omitempty"`
}

// ManagedDiskParameters the parameters of a managed disk.
type ManagedDiskParameters struct {
	// StorageAccountType - Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Possible values include: 'StorageAccountTypesStandardLRS', 'StorageAccountTypesPremiumLRS', 'StorageAccountTypesStandardSSDLRS', 'StorageAccountTypesUltraSSDLRS', 'StorageAccountTypesPremiumZRS', 'StorageAccountTypesStandardSSDZRS'
	StorageAccountType StorageAccountTypes `json:"storageAccountType,omitempty"`
	// DiskEncryptionSet - Specifies the customer managed disk encryption set resource id for the managed disk.
	DiskEncryptionSet *DiskEncryptionSetParameters `json:"diskEncryptionSet,omitempty"`
	// SecurityProfile - Specifies the security profile for the managed disk.
	SecurityProfile *VMDiskSecurityProfile `json:"securityProfile,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// NetworkInterfaceReference describes a network interface reference.
type NetworkInterfaceReference struct {
	*NetworkInterfaceReferenceProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkInterfaceReference.
func (nir NetworkInterfaceReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nir.NetworkInterfaceReferenceProperties != nil {
		objectMap["properties"] = nir.NetworkInterfaceReferenceProperties
	}
	if nir.ID != nil {
		objectMap["id"] = nir.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkInterfaceReference struct.
func (nir *NetworkInterfaceReference) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var networkInterfaceReferenceProperties NetworkInterfaceReferenceProperties
				err = json.Unmarshal(*v, &networkInterfaceReferenceProperties)
				if err != nil {
					return err
				}
				nir.NetworkInterfaceReferenceProperties = &networkInterfaceReferenceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nir.ID = &ID
			}
		}
	}

	return nil
}

// NetworkInterfaceReferenceProperties describes a network interface reference properties.
type NetworkInterfaceReferenceProperties struct {
	// Primary - Specifies the primary network interface in case the virtual machine has more than 1 network interface.
	Primary *bool `json:"primary,omitempty"`
	// DeleteOption - Specify what happens to the network interface when the VM is deleted. Possible values include: 'DeleteOptionsDelete', 'DeleteOptionsDetach'
	DeleteOption DeleteOptions `json:"deleteOption,omitempty"`
}

// NetworkProfile specifies the network interfaces or the networking configuration of the virtual machine.
type NetworkProfile struct {
	// NetworkInterfaces - Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
	NetworkInterfaces *[]NetworkInterfaceReference `json:"networkInterfaces,omitempty"`
	// NetworkAPIVersion - specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations. Possible values include: 'NetworkAPIVersionTwoZeroTwoZeroHyphenMinusOneOneHyphenMinusZeroOne'
	NetworkAPIVersion NetworkAPIVersion `json:"networkApiVersion,omitempty"`
	// NetworkInterfaceConfigurations - Specifies the networking configurations that will be used to create the virtual machine networking resources.
	NetworkInterfaceConfigurations *[]VirtualMachineNetworkInterfaceConfiguration `json:"networkInterfaceConfigurations,omitempty"`
}

// OperationListResult the List Compute Operation operation response.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of compute operations
	Value *[]OperationValue `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationValue describes the properties of a Compute Operation value.
type OperationValue struct {
	// Origin - READ-ONLY; The origin of the compute operation.
	Origin *string `json:"origin,omitempty"`
	// Name - READ-ONLY; The name of the compute operation.
	Name                   *string `json:"name,omitempty"`
	*OperationValueDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationValue.
func (ov OperationValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ov.OperationValueDisplay != nil {
		objectMap["display"] = ov.OperationValueDisplay
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationValue struct.
func (ov *OperationValue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				ov.Origin = &origin
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ov.Name = &name
			}
		case "display":
			if v != nil {
				var operationValueDisplay OperationValueDisplay
				err = json.Unmarshal(*v, &operationValueDisplay)
				if err != nil {
					return err
				}
				ov.OperationValueDisplay = &operationValueDisplay
			}
		}
	}

	return nil
}

// OperationValueDisplay describes the properties of a Compute Operation Value Display.
type OperationValueDisplay struct {
	// Operation - READ-ONLY; The display name of the compute operation.
	Operation *string `json:"operation,omitempty"`
	// Resource - READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty"`
	// Description - READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty"`
	// Provider - READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationValueDisplay.
func (ovd OperationValueDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OrchestrationServiceStateInput the input for OrchestrationServiceState
type OrchestrationServiceStateInput struct {
	// ServiceName - The name of the service. Possible values include: 'OrchestrationServiceNamesAutomaticRepairs'
	ServiceName OrchestrationServiceNames `json:"serviceName,omitempty"`
	// Action - The action to be performed. Possible values include: 'OrchestrationServiceStateActionResume', 'OrchestrationServiceStateActionSuspend'
	Action OrchestrationServiceStateAction `json:"action,omitempty"`
}

// OrchestrationServiceSummary summary for an orchestration service of a virtual machine scale set.
type OrchestrationServiceSummary struct {
	// ServiceName - READ-ONLY; The name of the service. Possible values include: 'OrchestrationServiceNamesAutomaticRepairs', 'OrchestrationServiceNamesDummyOrchestrationServiceName'
	ServiceName OrchestrationServiceNames `json:"serviceName,omitempty"`
	// ServiceState - READ-ONLY; The current state of the service. Possible values include: 'OrchestrationServiceStateNotRunning', 'OrchestrationServiceStateRunning', 'OrchestrationServiceStateSuspended'
	ServiceState OrchestrationServiceState `json:"serviceState,omitempty"`
}

// MarshalJSON is the custom marshaler for OrchestrationServiceSummary.
func (oss OrchestrationServiceSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OSDisk specifies information about the operating system disk used by the virtual machine. <br><br> For
// more information about disks, see [About disks and VHDs for Azure virtual
// machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
type OSDisk struct {
	// OsType - This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**. Possible values include: 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// EncryptionSettings - Specifies the encryption settings for the OS Disk. <br><br> Minimum api-version: 2015-06-15
	EncryptionSettings *DiskEncryptionSettings `json:"encryptionSettings,omitempty"`
	// Name - The disk name.
	Name *string `json:"name,omitempty"`
	// Vhd - The virtual hard disk.
	Vhd *VirtualHardDisk `json:"vhd,omitempty"`
	// Image - The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
	Image *VirtualHardDisk `json:"image,omitempty"`
	// Caching - Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None** for Standard storage. **ReadOnly** for Premium storage. Possible values include: 'CachingTypesNone', 'CachingTypesReadOnly', 'CachingTypesReadWrite'
	Caching CachingTypes `json:"caching,omitempty"`
	// WriteAcceleratorEnabled - Specifies whether writeAccelerator should be enabled or disabled on the disk.
	WriteAcceleratorEnabled *bool `json:"writeAcceleratorEnabled,omitempty"`
	// DiffDiskSettings - Specifies the ephemeral Disk Settings for the operating system disk used by the virtual machine.
	DiffDiskSettings *DiffDiskSettings `json:"diffDiskSettings,omitempty"`
	// CreateOption - Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described. Possible values include: 'DiskCreateOptionTypesFromImage', 'DiskCreateOptionTypesEmpty', 'DiskCreateOptionTypesAttach'
	CreateOption DiskCreateOptionTypes `json:"createOption,omitempty"`
	// DiskSizeGB - Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
	// ManagedDisk - The managed disk parameters.
	ManagedDisk *ManagedDiskParameters `json:"managedDisk,omitempty"`
	// DeleteOption - Specifies whether OS Disk should be deleted or detached upon VM deletion. <br><br> Possible values: <br><br> **Delete** If this value is used, the OS disk is deleted when VM is deleted.<br><br> **Detach** If this value is used, the os disk is retained after VM is deleted. <br><br> The default value is set to **detach**. For an ephemeral OS Disk, the default value is set to **Delete**. User cannot change the delete option for ephemeral OS Disk. Possible values include: 'DiskDeleteOptionTypesDelete', 'DiskDeleteOptionTypesDetach'
	DeleteOption DiskDeleteOptionTypes `json:"deleteOption,omitempty"`
}

// OSDiskImage contains the os disk image information.
type OSDiskImage struct {
	// OperatingSystem - The operating system of the osDiskImage. Possible values include: 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OperatingSystem OperatingSystemTypes `json:"operatingSystem,omitempty"`
}

// OSDiskImageEncryption contains encryption settings for an OS disk image.
type OSDiskImageEncryption struct {
	// DiskEncryptionSetID - A relative URI containing the resource ID of the disk encryption set.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`
}

// OSFamily describes a cloud service OS family.
type OSFamily struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location   *string             `json:"location,omitempty"`
	Properties *OSFamilyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OSFamily.
func (of OSFamily) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if of.Properties != nil {
		objectMap["properties"] = of.Properties
	}
	return json.Marshal(objectMap)
}

// OSFamilyListResult ...
type OSFamilyListResult struct {
	autorest.Response `json:"-"`
	Value             *[]OSFamily `json:"value,omitempty"`
	NextLink          *string     `json:"nextLink,omitempty"`
}

// OSFamilyListResultIterator provides access to a complete listing of OSFamily values.
type OSFamilyListResultIterator struct {
	i    int
	page OSFamilyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OSFamilyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OSFamilyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OSFamilyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OSFamilyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OSFamilyListResultIterator) Response() OSFamilyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OSFamilyListResultIterator) Value() OSFamily {
	if !iter.page.NotDone() {
		return OSFamily{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OSFamilyListResultIterator type.
func NewOSFamilyListResultIterator(page OSFamilyListResultPage) OSFamilyListResultIterator {
	return OSFamilyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oflr OSFamilyListResult) IsEmpty() bool {
	return oflr.Value == nil || len(*oflr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oflr OSFamilyListResult) hasNextLink() bool {
	return oflr.NextLink != nil && len(*oflr.NextLink) != 0
}

// oSFamilyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oflr OSFamilyListResult) oSFamilyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !oflr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oflr.NextLink)))
}

// OSFamilyListResultPage contains a page of OSFamily values.
type OSFamilyListResultPage struct {
	fn   func(context.Context, OSFamilyListResult) (OSFamilyListResult, error)
	oflr OSFamilyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OSFamilyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OSFamilyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oflr)
		if err != nil {
			return err
		}
		page.oflr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OSFamilyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OSFamilyListResultPage) NotDone() bool {
	return !page.oflr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OSFamilyListResultPage) Response() OSFamilyListResult {
	return page.oflr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OSFamilyListResultPage) Values() []OSFamily {
	if page.oflr.IsEmpty() {
		return nil
	}
	return *page.oflr.Value
}

// Creates a new instance of the OSFamilyListResultPage type.
func NewOSFamilyListResultPage(cur OSFamilyListResult, getNextPage func(context.Context, OSFamilyListResult) (OSFamilyListResult, error)) OSFamilyListResultPage {
	return OSFamilyListResultPage{
		fn:   getNextPage,
		oflr: cur,
	}
}

// OSFamilyProperties OS family properties.
type OSFamilyProperties struct {
	// Name - READ-ONLY; The OS family name.
	Name *string `json:"name,omitempty"`
	// Label - READ-ONLY; The OS family label.
	Label *string `json:"label,omitempty"`
	// Versions - READ-ONLY; List of OS versions belonging to this family.
	Versions *[]OSVersionPropertiesBase `json:"versions,omitempty"`
}

// MarshalJSON is the custom marshaler for OSFamilyProperties.
func (ofp OSFamilyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OSProfile specifies the operating system settings for the virtual machine. Some of the settings cannot
// be changed once VM is provisioned.
type OSProfile struct {
	// ComputerName - Specifies the host OS name of the virtual machine. <br><br> This name cannot be updated after the VM is created. <br><br> **Max-length (Windows):** 15 characters <br><br> **Max-length (Linux):** 64 characters. <br><br> For naming conventions and restrictions see [Azure infrastructure services implementation guidelines](https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules).
	ComputerName *string `json:"computerName,omitempty"`
	// AdminUsername - Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters.
	AdminUsername *string `json:"adminUsername,omitempty"`
	// AdminPassword - Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
	AdminPassword *string `json:"adminPassword,omitempty"`
	// CustomData - Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> **Note: Do not pass any secrets or passwords in customData property** <br><br> This property cannot be updated after the VM is created. <br><br> customData is passed to the VM to be saved as a file, for more information see [Custom Data on Azure VMs](https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/) <br><br> For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init)
	CustomData *string `json:"customData,omitempty"`
	// WindowsConfiguration - Specifies Windows operating system settings on the virtual machine.
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
	// LinuxConfiguration - Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
	LinuxConfiguration *LinuxConfiguration `json:"linuxConfiguration,omitempty"`
	// Secrets - Specifies set of certificates that should be installed onto the virtual machine. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
	Secrets *[]VaultSecretGroup `json:"secrets,omitempty"`
	// AllowExtensionOperations - Specifies whether extension operations should be allowed on the virtual machine. <br><br>This may only be set to False when no extensions are present on the virtual machine.
	AllowExtensionOperations *bool `json:"allowExtensionOperations,omitempty"`
	// RequireGuestProvisionSignal - Specifies whether the guest provision signal is required to infer provision success of the virtual machine.  **Note: This property is for private testing only, and all customers must not set the property to false.**
	RequireGuestProvisionSignal *bool `json:"requireGuestProvisionSignal,omitempty"`
}

// OSVersion describes a cloud service OS version.
type OSVersion struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location   *string              `json:"location,omitempty"`
	Properties *OSVersionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OSVersion.
func (ov OSVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ov.Properties != nil {
		objectMap["properties"] = ov.Properties
	}
	return json.Marshal(objectMap)
}

// OSVersionListResult ...
type OSVersionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]OSVersion `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OSVersionListResultIterator provides access to a complete listing of OSVersion values.
type OSVersionListResultIterator struct {
	i    int
	page OSVersionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OSVersionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OSVersionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OSVersionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OSVersionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OSVersionListResultIterator) Response() OSVersionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OSVersionListResultIterator) Value() OSVersion {
	if !iter.page.NotDone() {
		return OSVersion{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OSVersionListResultIterator type.
func NewOSVersionListResultIterator(page OSVersionListResultPage) OSVersionListResultIterator {
	return OSVersionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ovlr OSVersionListResult) IsEmpty() bool {
	return ovlr.Value == nil || len(*ovlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ovlr OSVersionListResult) hasNextLink() bool {
	return ovlr.NextLink != nil && len(*ovlr.NextLink) != 0
}

// oSVersionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ovlr OSVersionListResult) oSVersionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ovlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ovlr.NextLink)))
}

// OSVersionListResultPage contains a page of OSVersion values.
type OSVersionListResultPage struct {
	fn   func(context.Context, OSVersionListResult) (OSVersionListResult, error)
	ovlr OSVersionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OSVersionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OSVersionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ovlr)
		if err != nil {
			return err
		}
		page.ovlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OSVersionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OSVersionListResultPage) NotDone() bool {
	return !page.ovlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OSVersionListResultPage) Response() OSVersionListResult {
	return page.ovlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OSVersionListResultPage) Values() []OSVersion {
	if page.ovlr.IsEmpty() {
		return nil
	}
	return *page.ovlr.Value
}

// Creates a new instance of the OSVersionListResultPage type.
func NewOSVersionListResultPage(cur OSVersionListResult, getNextPage func(context.Context, OSVersionListResult) (OSVersionListResult, error)) OSVersionListResultPage {
	return OSVersionListResultPage{
		fn:   getNextPage,
		ovlr: cur,
	}
}

// OSVersionProperties OS version properties.
type OSVersionProperties struct {
	// Family - READ-ONLY; The family of this OS version.
	Family *string `json:"family,omitempty"`
	// FamilyLabel - READ-ONLY; The family label of this OS version.
	FamilyLabel *string `json:"familyLabel,omitempty"`
	// Version - READ-ONLY; The OS version.
	Version *string `json:"version,omitempty"`
	// Label - READ-ONLY; The OS version label.
	Label *string `json:"label,omitempty"`
	// IsDefault - READ-ONLY; Specifies whether this is the default OS version for its family.
	IsDefault *bool `json:"isDefault,omitempty"`
	// IsActive - READ-ONLY; Specifies whether this OS version is active.
	IsActive *bool `json:"isActive,omitempty"`
}

// MarshalJSON is the custom marshaler for OSVersionProperties.
func (ovp OSVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OSVersionPropertiesBase configuration view of an OS version.
type OSVersionPropertiesBase struct {
	// Version - READ-ONLY; The OS version.
	Version *string `json:"version,omitempty"`
	// Label - READ-ONLY; The OS version label.
	Label *string `json:"label,omitempty"`
	// IsDefault - READ-ONLY; Specifies whether this is the default OS version for its family.
	IsDefault *bool `json:"isDefault,omitempty"`
	// IsActive - READ-ONLY; Specifies whether this OS version is active.
	IsActive *bool `json:"isActive,omitempty"`
}

// MarshalJSON is the custom marshaler for OSVersionPropertiesBase.
func (ovpb OSVersionPropertiesBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PatchInstallationDetail information about a specific patch that was encountered during an installation
// action.
type PatchInstallationDetail struct {
	// PatchID - READ-ONLY; A unique identifier for the patch.
	PatchID *string `json:"patchId,omitempty"`
	// Name - READ-ONLY; The friendly name of the patch.
	Name *string `json:"name,omitempty"`
	// Version - READ-ONLY; The version string of the package. It may conform to Semantic Versioning. Only applies to Linux.
	Version *string `json:"version,omitempty"`
	// KbID - READ-ONLY; The KBID of the patch. Only applies to Windows patches.
	KbID *string `json:"kbId,omitempty"`
	// Classifications - READ-ONLY; The classification(s) of the patch as provided by the patch publisher.
	Classifications *[]string `json:"classifications,omitempty"`
	// InstallationState - READ-ONLY; The state of the patch after the installation operation completed. Possible values include: 'PatchInstallationStateUnknown', 'PatchInstallationStateInstalled', 'PatchInstallationStateFailed', 'PatchInstallationStateExcluded', 'PatchInstallationStateNotSelected', 'PatchInstallationStatePending'
	InstallationState PatchInstallationState `json:"installationState,omitempty"`
}

// MarshalJSON is the custom marshaler for PatchInstallationDetail.
func (pid PatchInstallationDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PatchSettings specifies settings related to VM Guest Patching on Windows.
type PatchSettings struct {
	// PatchMode - Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br /> **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true. Possible values include: 'WindowsVMGuestPatchModeManual', 'WindowsVMGuestPatchModeAutomaticByOS', 'WindowsVMGuestPatchModeAutomaticByPlatform'
	PatchMode WindowsVMGuestPatchMode `json:"patchMode,omitempty"`
	// EnableHotpatching - Enables customers to patch their Azure VMs without requiring a reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must be set to 'AutomaticByPlatform'.
	EnableHotpatching *bool `json:"enableHotpatching,omitempty"`
	// AssessmentMode - Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine.<br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true. Possible values include: 'WindowsPatchAssessmentModeImageDefault', 'WindowsPatchAssessmentModeAutomaticByPlatform'
	AssessmentMode WindowsPatchAssessmentMode `json:"assessmentMode,omitempty"`
}

// PirCommunityGalleryResource base information about the community gallery resource in pir.
type PirCommunityGalleryResource struct {
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Resource type
	Type                        *string `json:"type,omitempty"`
	*CommunityGalleryIdentifier `json:"identifier,omitempty"`
}

// MarshalJSON is the custom marshaler for PirCommunityGalleryResource.
func (pcgr PirCommunityGalleryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pcgr.CommunityGalleryIdentifier != nil {
		objectMap["identifier"] = pcgr.CommunityGalleryIdentifier
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PirCommunityGalleryResource struct.
func (pcgr *PirCommunityGalleryResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pcgr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pcgr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pcgr.Type = &typeVar
			}
		case "identifier":
			if v != nil {
				var communityGalleryIdentifier CommunityGalleryIdentifier
				err = json.Unmarshal(*v, &communityGalleryIdentifier)
				if err != nil {
					return err
				}
				pcgr.CommunityGalleryIdentifier = &communityGalleryIdentifier
			}
		}
	}

	return nil
}

// PirResource the Resource model definition.
type PirResource struct {
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for PirResource.
func (pr PirResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PirSharedGalleryResource base information about the shared gallery resource in pir.
type PirSharedGalleryResource struct {
	*SharedGalleryIdentifier `json:"identifier,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for PirSharedGalleryResource.
func (psgr PirSharedGalleryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if psgr.SharedGalleryIdentifier != nil {
		objectMap["identifier"] = psgr.SharedGalleryIdentifier
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PirSharedGalleryResource struct.
func (psgr *PirSharedGalleryResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identifier":
			if v != nil {
				var sharedGalleryIdentifier SharedGalleryIdentifier
				err = json.Unmarshal(*v, &sharedGalleryIdentifier)
				if err != nil {
					return err
				}
				psgr.SharedGalleryIdentifier = &sharedGalleryIdentifier
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				psgr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				psgr.Location = &location
			}
		}
	}

	return nil
}

// Plan specifies information about the marketplace image used to create the virtual machine. This element
// is only used for marketplace images. Before you can use a marketplace image from an API, you must enable
// the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use
// and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and
// then click **Save**.
type Plan struct {
	// Name - The plan ID.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher ID.
	Publisher *string `json:"publisher,omitempty"`
	// Product - Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
	Product *string `json:"product,omitempty"`
	// PromotionCode - The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`
}

// PrivateEndpoint the Private Endpoint resource.
type PrivateEndpoint struct {
	// ID - READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection the Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; private endpoint connection Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; private endpoint connection name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; private endpoint connection type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult a list of private link resources
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private endpoint connections
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of snapshots. Call ListNext() with this to fetch the next page of snapshots.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateEndpointConnectionListResultIterator provides access to a complete listing of
// PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultIterator struct {
	i    int
	page PrivateEndpointConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointConnectionListResultIterator) Response() PrivateEndpointConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointConnectionListResultIterator) Value() PrivateEndpointConnection {
	if !iter.page.NotDone() {
		return PrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointConnectionListResultIterator type.
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return PrivateEndpointConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (peclr PrivateEndpointConnectionListResult) IsEmpty() bool {
	return peclr.Value == nil || len(*peclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (peclr PrivateEndpointConnectionListResult) hasNextLink() bool {
	return peclr.NextLink != nil && len(*peclr.NextLink) != 0
}

// privateEndpointConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (peclr PrivateEndpointConnectionListResult) privateEndpointConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !peclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(peclr.NextLink)))
}

// PrivateEndpointConnectionListResultPage contains a page of PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultPage struct {
	fn    func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)
	peclr PrivateEndpointConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.peclr)
		if err != nil {
			return err
		}
		page.peclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointConnectionListResultPage) NotDone() bool {
	return !page.peclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointConnectionListResultPage) Response() PrivateEndpointConnectionListResult {
	return page.peclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointConnectionListResultPage) Values() []PrivateEndpointConnection {
	if page.peclr.IsEmpty() {
		return nil
	}
	return *page.peclr.Value
}

// Creates a new instance of the PrivateEndpointConnectionListResultPage type.
func NewPrivateEndpointConnectionListResultPage(cur PrivateEndpointConnectionListResult, getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return PrivateEndpointConnectionListResultPage{
		fn:    getNextPage,
		peclr: cur,
	}
}

// PrivateEndpointConnectionProperties properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - READ-ONLY; The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between DiskAccess and Virtual Network.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint connection resource. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionProperties.
func (pecp PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = pecp.PrivateLinkServiceConnectionState
	}
	if pecp.ProvisioningState != "" {
		objectMap["provisioningState"] = pecp.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; private link resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; private link resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; private link resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState a collection of information about the state of the connection between
// service consumer and provider.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'PrivateEndpointServiceConnectionStatusPending', 'PrivateEndpointServiceConnectionStatusApproved', 'PrivateEndpointServiceConnectionStatusRejected'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// PropertyUpdatesInProgress properties of the disk for which update is pending.
type PropertyUpdatesInProgress struct {
	// TargetTier - The target performance tier of the disk if a tier change operation is in progress.
	TargetTier *string `json:"targetTier,omitempty"`
}

// ProximityPlacementGroup specifies information about the proximity placement group.
type ProximityPlacementGroup struct {
	autorest.Response `json:"-"`
	// ProximityPlacementGroupProperties - Describes the properties of a Proximity Placement Group.
	*ProximityPlacementGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ProximityPlacementGroup.
func (ppg ProximityPlacementGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ppg.ProximityPlacementGroupProperties != nil {
		objectMap["properties"] = ppg.ProximityPlacementGroupProperties
	}
	if ppg.Location != nil {
		objectMap["location"] = ppg.Location
	}
	if ppg.Tags != nil {
		objectMap["tags"] = ppg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProximityPlacementGroup struct.
func (ppg *ProximityPlacementGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var proximityPlacementGroupProperties ProximityPlacementGroupProperties
				err = json.Unmarshal(*v, &proximityPlacementGroupProperties)
				if err != nil {
					return err
				}
				ppg.ProximityPlacementGroupProperties = &proximityPlacementGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ppg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ppg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ppg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ppg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ppg.Tags = tags
			}
		}
	}

	return nil
}

// ProximityPlacementGroupListResult the List Proximity Placement Group operation response.
type ProximityPlacementGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of proximity placement groups
	Value *[]ProximityPlacementGroup `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of proximity placement groups.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProximityPlacementGroupListResultIterator provides access to a complete listing of
// ProximityPlacementGroup values.
type ProximityPlacementGroupListResultIterator struct {
	i    int
	page ProximityPlacementGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProximityPlacementGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProximityPlacementGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProximityPlacementGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProximityPlacementGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProximityPlacementGroupListResultIterator) Response() ProximityPlacementGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProximityPlacementGroupListResultIterator) Value() ProximityPlacementGroup {
	if !iter.page.NotDone() {
		return ProximityPlacementGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProximityPlacementGroupListResultIterator type.
func NewProximityPlacementGroupListResultIterator(page ProximityPlacementGroupListResultPage) ProximityPlacementGroupListResultIterator {
	return ProximityPlacementGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ppglr ProximityPlacementGroupListResult) IsEmpty() bool {
	return ppglr.Value == nil || len(*ppglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ppglr ProximityPlacementGroupListResult) hasNextLink() bool {
	return ppglr.NextLink != nil && len(*ppglr.NextLink) != 0
}

// proximityPlacementGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ppglr ProximityPlacementGroupListResult) proximityPlacementGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ppglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ppglr.NextLink)))
}

// ProximityPlacementGroupListResultPage contains a page of ProximityPlacementGroup values.
type ProximityPlacementGroupListResultPage struct {
	fn    func(context.Context, ProximityPlacementGroupListResult) (ProximityPlacementGroupListResult, error)
	ppglr ProximityPlacementGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProximityPlacementGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProximityPlacementGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ppglr)
		if err != nil {
			return err
		}
		page.ppglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProximityPlacementGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProximityPlacementGroupListResultPage) NotDone() bool {
	return !page.ppglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProximityPlacementGroupListResultPage) Response() ProximityPlacementGroupListResult {
	return page.ppglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProximityPlacementGroupListResultPage) Values() []ProximityPlacementGroup {
	if page.ppglr.IsEmpty() {
		return nil
	}
	return *page.ppglr.Value
}

// Creates a new instance of the ProximityPlacementGroupListResultPage type.
func NewProximityPlacementGroupListResultPage(cur ProximityPlacementGroupListResult, getNextPage func(context.Context, ProximityPlacementGroupListResult) (ProximityPlacementGroupListResult, error)) ProximityPlacementGroupListResultPage {
	return ProximityPlacementGroupListResultPage{
		fn:    getNextPage,
		ppglr: cur,
	}
}

// ProximityPlacementGroupProperties describes the properties of a Proximity Placement Group.
type ProximityPlacementGroupProperties struct {
	// ProximityPlacementGroupType - Specifies the type of the proximity placement group. <br><br> Possible values are: <br><br> **Standard** : Co-locate resources within an Azure region or Availability Zone. <br><br> **Ultra** : For future use. Possible values include: 'ProximityPlacementGroupTypeStandard', 'ProximityPlacementGroupTypeUltra'
	ProximityPlacementGroupType ProximityPlacementGroupType `json:"proximityPlacementGroupType,omitempty"`
	// VirtualMachines - READ-ONLY; A list of references to all virtual machines in the proximity placement group.
	VirtualMachines *[]SubResourceWithColocationStatus `json:"virtualMachines,omitempty"`
	// VirtualMachineScaleSets - READ-ONLY; A list of references to all virtual machine scale sets in the proximity placement group.
	VirtualMachineScaleSets *[]SubResourceWithColocationStatus `json:"virtualMachineScaleSets,omitempty"`
	// AvailabilitySets - READ-ONLY; A list of references to all availability sets in the proximity placement group.
	AvailabilitySets *[]SubResourceWithColocationStatus `json:"availabilitySets,omitempty"`
	// ColocationStatus - Describes colocation status of the Proximity Placement Group.
	ColocationStatus *InstanceViewStatus `json:"colocationStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for ProximityPlacementGroupProperties.
func (ppgp ProximityPlacementGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ppgp.ProximityPlacementGroupType != "" {
		objectMap["proximityPlacementGroupType"] = ppgp.ProximityPlacementGroupType
	}
	if ppgp.ColocationStatus != nil {
		objectMap["colocationStatus"] = ppgp.ColocationStatus
	}
	return json.Marshal(objectMap)
}

// ProximityPlacementGroupUpdate specifies information about the proximity placement group.
type ProximityPlacementGroupUpdate struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ProximityPlacementGroupUpdate.
func (ppgu ProximityPlacementGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ppgu.Tags != nil {
		objectMap["tags"] = ppgu.Tags
	}
	return json.Marshal(objectMap)
}

// ProxyOnlyResource the ProxyOnly Resource model definition.
type ProxyOnlyResource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyOnlyResource.
func (por ProxyOnlyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for an Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PublicIPAddressSku describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
type PublicIPAddressSku struct {
	// Name - Specify public IP sku name. Possible values include: 'PublicIPAddressSkuNameBasic', 'PublicIPAddressSkuNameStandard'
	Name PublicIPAddressSkuName `json:"name,omitempty"`
	// Tier - Specify public IP sku tier. Possible values include: 'PublicIPAddressSkuTierRegional', 'PublicIPAddressSkuTierGlobal'
	Tier PublicIPAddressSkuTier `json:"tier,omitempty"`
}

// PurchasePlan used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
type PurchasePlan struct {
	// Publisher - The publisher ID.
	Publisher *string `json:"publisher,omitempty"`
	// Name - The plan ID.
	Name *string `json:"name,omitempty"`
	// Product - Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
	Product *string `json:"product,omitempty"`
	// PromotionCode - The Offer Promotion Code.
	PromotionCode *string `json:"promotionCode,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// RecommendedMachineConfiguration the properties describe the recommended machine configuration for this
// Image Definition. These properties are updatable.
type RecommendedMachineConfiguration struct {
	VCPUs  *ResourceRange `json:"vCPUs,omitempty"`
	Memory *ResourceRange `json:"memory,omitempty"`
}

// RecoveryWalkResponse response after calling a manual recovery walk
type RecoveryWalkResponse struct {
	autorest.Response `json:"-"`
	// WalkPerformed - READ-ONLY; Whether the recovery walk was performed
	WalkPerformed *bool `json:"walkPerformed,omitempty"`
	// NextPlatformUpdateDomain - READ-ONLY; The next update domain that needs to be walked. Null means walk spanning all update domains has been completed
	NextPlatformUpdateDomain *int32 `json:"nextPlatformUpdateDomain,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryWalkResponse.
func (rwr RecoveryWalkResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RegionalReplicationStatus this is the regional replication status.
type RegionalReplicationStatus struct {
	// Region - READ-ONLY; The region to which the gallery image version is being replicated to.
	Region *string `json:"region,omitempty"`
	// State - READ-ONLY; This is the regional replication state. Possible values include: 'ReplicationStateUnknown', 'ReplicationStateReplicating', 'ReplicationStateCompleted', 'ReplicationStateFailed'
	State ReplicationState `json:"state,omitempty"`
	// Details - READ-ONLY; The details of the replication status.
	Details *string `json:"details,omitempty"`
	// Progress - READ-ONLY; It indicates progress of the replication job.
	Progress *int32 `json:"progress,omitempty"`
}

// MarshalJSON is the custom marshaler for RegionalReplicationStatus.
func (rrs RegionalReplicationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReplicationStatus this is the replication status of the gallery image version.
type ReplicationStatus struct {
	// AggregatedState - READ-ONLY; This is the aggregated replication status based on all the regional replication status flags. Possible values include: 'AggregatedReplicationStateUnknown', 'AggregatedReplicationStateInProgress', 'AggregatedReplicationStateCompleted', 'AggregatedReplicationStateFailed'
	AggregatedState AggregatedReplicationState `json:"aggregatedState,omitempty"`
	// Summary - READ-ONLY; This is a summary of replication status for each region.
	Summary *[]RegionalReplicationStatus `json:"summary,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationStatus.
func (rs ReplicationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RequestRateByIntervalInput api request input for LogAnalytics getRequestRateByInterval Api.
type RequestRateByIntervalInput struct {
	// IntervalLength - Interval value in minutes used to create LogAnalytics call rate logs. Possible values include: 'IntervalInMinsThreeMins', 'IntervalInMinsFiveMins', 'IntervalInMinsThirtyMins', 'IntervalInMinsSixtyMins'
	IntervalLength IntervalInMins `json:"intervalLength,omitempty"`
	// BlobContainerSasURI - SAS Uri of the logging blob container to which LogAnalytics Api writes output logs to.
	BlobContainerSasURI *string `json:"blobContainerSasUri,omitempty"`
	// FromTime - From time of the query
	FromTime *date.Time `json:"fromTime,omitempty"`
	// ToTime - To time of the query
	ToTime *date.Time `json:"toTime,omitempty"`
	// GroupByThrottlePolicy - Group query result by Throttle Policy applied.
	GroupByThrottlePolicy *bool `json:"groupByThrottlePolicy,omitempty"`
	// GroupByOperationName - Group query result by Operation Name.
	GroupByOperationName *bool `json:"groupByOperationName,omitempty"`
	// GroupByResourceName - Group query result by Resource Name.
	GroupByResourceName *bool `json:"groupByResourceName,omitempty"`
	// GroupByClientApplicationID - Group query result by Client Application ID.
	GroupByClientApplicationID *bool `json:"groupByClientApplicationId,omitempty"`
	// GroupByUserAgent - Group query result by User Agent.
	GroupByUserAgent *bool `json:"groupByUserAgent,omitempty"`
}

// Resource the Resource model definition.
type Resource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceInstanceViewStatus instance view status.
type ResourceInstanceViewStatus struct {
	// Code - READ-ONLY; The status code.
	Code *string `json:"code,omitempty"`
	// DisplayStatus - READ-ONLY; The short localizable label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty"`
	// Message - READ-ONLY; The detailed status message, including for alerts and error messages.
	Message *string `json:"message,omitempty"`
	// Time - READ-ONLY; The time of the status.
	Time *date.Time `json:"time,omitempty"`
	// Level - The level code. Possible values include: 'StatusLevelTypesInfo', 'StatusLevelTypesWarning', 'StatusLevelTypesError'
	Level StatusLevelTypes `json:"level,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceInstanceViewStatus.
func (rivs ResourceInstanceViewStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rivs.Level != "" {
		objectMap["level"] = rivs.Level
	}
	return json.Marshal(objectMap)
}

// ResourceRange describes the resource range.
type ResourceRange struct {
	// Min - The minimum number of the resource.
	Min *int32 `json:"min,omitempty"`
	// Max - The maximum number of the resource.
	Max *int32 `json:"max,omitempty"`
}

// ResourceSku describes an available Compute SKU.
type ResourceSku struct {
	// ResourceType - READ-ONLY; The type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`
	// Name - READ-ONLY; The name of SKU.
	Name *string `json:"name,omitempty"`
	// Tier - READ-ONLY; Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**
	Tier *string `json:"tier,omitempty"`
	// Size - READ-ONLY; The Size of the SKU.
	Size *string `json:"size,omitempty"`
	// Family - READ-ONLY; The Family of this particular SKU.
	Family *string `json:"family,omitempty"`
	// Kind - READ-ONLY; The Kind of resources that are supported in this SKU.
	Kind *string `json:"kind,omitempty"`
	// Capacity - READ-ONLY; Specifies the number of virtual machines in the scale set.
	Capacity *ResourceSkuCapacity `json:"capacity,omitempty"`
	// Locations - READ-ONLY; The set of locations that the SKU is available.
	Locations *[]string `json:"locations,omitempty"`
	// LocationInfo - READ-ONLY; A list of locations and availability zones in those locations where the SKU is available.
	LocationInfo *[]ResourceSkuLocationInfo `json:"locationInfo,omitempty"`
	// APIVersions - READ-ONLY; The api versions that support this SKU.
	APIVersions *[]string `json:"apiVersions,omitempty"`
	// Costs - READ-ONLY; Metadata for retrieving price info.
	Costs *[]ResourceSkuCosts `json:"costs,omitempty"`
	// Capabilities - READ-ONLY; A name value pair to describe the capability.
	Capabilities *[]ResourceSkuCapabilities `json:"capabilities,omitempty"`
	// Restrictions - READ-ONLY; The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions *[]ResourceSkuRestrictions `json:"restrictions,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSku.
func (rs ResourceSku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuCapabilities describes The SKU capabilities object.
type ResourceSkuCapabilities struct {
	// Name - READ-ONLY; An invariant to describe the feature.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; An invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuCapabilities.
func (rsc ResourceSkuCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuCapacity describes scaling information of a SKU.
type ResourceSkuCapacity struct {
	// Minimum - READ-ONLY; The minimum capacity.
	Minimum *int64 `json:"minimum,omitempty"`
	// Maximum - READ-ONLY; The maximum capacity that can be set.
	Maximum *int64 `json:"maximum,omitempty"`
	// Default - READ-ONLY; The default capacity.
	Default *int64 `json:"default,omitempty"`
	// ScaleType - READ-ONLY; The scale type applicable to the sku. Possible values include: 'ResourceSkuCapacityScaleTypeAutomatic', 'ResourceSkuCapacityScaleTypeManual', 'ResourceSkuCapacityScaleTypeNone'
	ScaleType ResourceSkuCapacityScaleType `json:"scaleType,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuCapacity.
func (rsc ResourceSkuCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuCosts describes metadata for retrieving price info.
type ResourceSkuCosts struct {
	// MeterID - READ-ONLY; Used for querying price from commerce.
	MeterID *string `json:"meterID,omitempty"`
	// Quantity - READ-ONLY; The multiplier is needed to extend the base metered cost.
	Quantity *int64 `json:"quantity,omitempty"`
	// ExtendedUnit - READ-ONLY; An invariant to show the extended unit.
	ExtendedUnit *string `json:"extendedUnit,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuCosts.
func (rsc ResourceSkuCosts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuLocationInfo describes an available Compute SKU Location Information.
type ResourceSkuLocationInfo struct {
	// Location - READ-ONLY; Location of the SKU
	Location *string `json:"location,omitempty"`
	// Zones - READ-ONLY; List of availability zones where the SKU is supported.
	Zones *[]string `json:"zones,omitempty"`
	// ZoneDetails - READ-ONLY; Details of capabilities available to a SKU in specific zones.
	ZoneDetails *[]ResourceSkuZoneDetails `json:"zoneDetails,omitempty"`
	// ExtendedLocations - READ-ONLY; The names of extended locations.
	ExtendedLocations *[]string `json:"extendedLocations,omitempty"`
	// Type - READ-ONLY; The type of the extended location. Possible values include: 'ExtendedLocationTypeEdgeZone'
	Type ExtendedLocationType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuLocationInfo.
func (rsli ResourceSkuLocationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuRestrictionInfo describes an available Compute SKU Restriction Information.
type ResourceSkuRestrictionInfo struct {
	// Locations - READ-ONLY; Locations where the SKU is restricted
	Locations *[]string `json:"locations,omitempty"`
	// Zones - READ-ONLY; List of availability zones where the SKU is restricted.
	Zones *[]string `json:"zones,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuRestrictionInfo.
func (rsri ResourceSkuRestrictionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuRestrictions describes scaling information of a SKU.
type ResourceSkuRestrictions struct {
	// Type - READ-ONLY; The type of restrictions. Possible values include: 'ResourceSkuRestrictionsTypeLocation', 'ResourceSkuRestrictionsTypeZone'
	Type ResourceSkuRestrictionsType `json:"type,omitempty"`
	// Values - READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
	Values *[]string `json:"values,omitempty"`
	// RestrictionInfo - READ-ONLY; The information about the restriction where the SKU cannot be used.
	RestrictionInfo *ResourceSkuRestrictionInfo `json:"restrictionInfo,omitempty"`
	// ReasonCode - READ-ONLY; The reason for restriction. Possible values include: 'ResourceSkuRestrictionsReasonCodeQuotaID', 'ResourceSkuRestrictionsReasonCodeNotAvailableForSubscription'
	ReasonCode ResourceSkuRestrictionsReasonCode `json:"reasonCode,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuRestrictions.
func (rsr ResourceSkuRestrictions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkusResult the List Resource Skus operation response.
type ResourceSkusResult struct {
	autorest.Response `json:"-"`
	// Value - The list of skus available for the subscription.
	Value *[]ResourceSku `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of Resource Skus. Call ListNext() with this URI to fetch the next page of Resource Skus
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceSkusResultIterator provides access to a complete listing of ResourceSku values.
type ResourceSkusResultIterator struct {
	i    int
	page ResourceSkusResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceSkusResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkusResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceSkusResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceSkusResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceSkusResultIterator) Response() ResourceSkusResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceSkusResultIterator) Value() ResourceSku {
	if !iter.page.NotDone() {
		return ResourceSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceSkusResultIterator type.
func NewResourceSkusResultIterator(page ResourceSkusResultPage) ResourceSkusResultIterator {
	return ResourceSkusResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rsr ResourceSkusResult) IsEmpty() bool {
	return rsr.Value == nil || len(*rsr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rsr ResourceSkusResult) hasNextLink() bool {
	return rsr.NextLink != nil && len(*rsr.NextLink) != 0
}

// resourceSkusResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rsr ResourceSkusResult) resourceSkusResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rsr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rsr.NextLink)))
}

// ResourceSkusResultPage contains a page of ResourceSku values.
type ResourceSkusResultPage struct {
	fn  func(context.Context, ResourceSkusResult) (ResourceSkusResult, error)
	rsr ResourceSkusResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceSkusResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkusResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rsr)
		if err != nil {
			return err
		}
		page.rsr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceSkusResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceSkusResultPage) NotDone() bool {
	return !page.rsr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceSkusResultPage) Response() ResourceSkusResult {
	return page.rsr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceSkusResultPage) Values() []ResourceSku {
	if page.rsr.IsEmpty() {
		return nil
	}
	return *page.rsr.Value
}

// Creates a new instance of the ResourceSkusResultPage type.
func NewResourceSkusResultPage(cur ResourceSkusResult, getNextPage func(context.Context, ResourceSkusResult) (ResourceSkusResult, error)) ResourceSkusResultPage {
	return ResourceSkusResultPage{
		fn:  getNextPage,
		rsr: cur,
	}
}

// ResourceSkuZoneDetails describes The zonal capabilities of a SKU.
type ResourceSkuZoneDetails struct {
	// Name - READ-ONLY; The set of zones that the SKU is available in with the specified capabilities.
	Name *[]string `json:"name,omitempty"`
	// Capabilities - READ-ONLY; A list of capabilities that are available for the SKU in the specified list of zones.
	Capabilities *[]ResourceSkuCapabilities `json:"capabilities,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuZoneDetails.
func (rszd ResourceSkuZoneDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceURIList the List resources which are encrypted with the disk encryption set.
type ResourceURIList struct {
	autorest.Response `json:"-"`
	// Value - A list of IDs or Owner IDs of resources which are encrypted with the disk encryption set.
	Value *[]string `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of encrypted resources. Call ListNext() with this to fetch the next page of encrypted resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceURIListIterator provides access to a complete listing of string values.
type ResourceURIListIterator struct {
	i    int
	page ResourceURIListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceURIListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceURIListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceURIListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceURIListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceURIListIterator) Response() ResourceURIList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceURIListIterator) Value() string {
	if !iter.page.NotDone() {
		return ""
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceURIListIterator type.
func NewResourceURIListIterator(page ResourceURIListPage) ResourceURIListIterator {
	return ResourceURIListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rul ResourceURIList) IsEmpty() bool {
	return rul.Value == nil || len(*rul.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rul ResourceURIList) hasNextLink() bool {
	return rul.NextLink != nil && len(*rul.NextLink) != 0
}

// resourceURIListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rul ResourceURIList) resourceURIListPreparer(ctx context.Context) (*http.Request, error) {
	if !rul.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rul.NextLink)))
}

// ResourceURIListPage contains a page of string values.
type ResourceURIListPage struct {
	fn  func(context.Context, ResourceURIList) (ResourceURIList, error)
	rul ResourceURIList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceURIListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceURIListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rul)
		if err != nil {
			return err
		}
		page.rul = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceURIListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceURIListPage) NotDone() bool {
	return !page.rul.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceURIListPage) Response() ResourceURIList {
	return page.rul
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceURIListPage) Values() []string {
	if page.rul.IsEmpty() {
		return nil
	}
	return *page.rul.Value
}

// Creates a new instance of the ResourceURIListPage type.
func NewResourceURIListPage(cur ResourceURIList, getNextPage func(context.Context, ResourceURIList) (ResourceURIList, error)) ResourceURIListPage {
	return ResourceURIListPage{
		fn:  getNextPage,
		rul: cur,
	}
}

// RestorePoint restore Point details.
type RestorePoint struct {
	autorest.Response       `json:"-"`
	*RestorePointProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorePoint.
func (rp RestorePoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.RestorePointProperties != nil {
		objectMap["properties"] = rp.RestorePointProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorePoint struct.
func (rp *RestorePoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restorePointProperties RestorePointProperties
				err = json.Unmarshal(*v, &restorePointProperties)
				if err != nil {
					return err
				}
				rp.RestorePointProperties = &restorePointProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rp.Type = &typeVar
			}
		}
	}

	return nil
}

// RestorePointCollection create or update Restore Point collection parameters.
type RestorePointCollection struct {
	autorest.Response                 `json:"-"`
	*RestorePointCollectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RestorePointCollection.
func (RPCVar RestorePointCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if RPCVar.RestorePointCollectionProperties != nil {
		objectMap["properties"] = RPCVar.RestorePointCollectionProperties
	}
	if RPCVar.Location != nil {
		objectMap["location"] = RPCVar.Location
	}
	if RPCVar.Tags != nil {
		objectMap["tags"] = RPCVar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorePointCollection struct.
func (RPCVar *RestorePointCollection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restorePointCollectionProperties RestorePointCollectionProperties
				err = json.Unmarshal(*v, &restorePointCollectionProperties)
				if err != nil {
					return err
				}
				RPCVar.RestorePointCollectionProperties = &restorePointCollectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				RPCVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				RPCVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				RPCVar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				RPCVar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				RPCVar.Tags = tags
			}
		}
	}

	return nil
}

// RestorePointCollectionListResult the List restore point collection operation response.
type RestorePointCollectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets the list of restore point collections.
	Value *[]RestorePointCollection `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of RestorePointCollections. Call ListNext() with this to fetch the next page of RestorePointCollections
	NextLink *string `json:"nextLink,omitempty"`
}

// RestorePointCollectionListResultIterator provides access to a complete listing of RestorePointCollection
// values.
type RestorePointCollectionListResultIterator struct {
	i    int
	page RestorePointCollectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RestorePointCollectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RestorePointCollectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RestorePointCollectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RestorePointCollectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RestorePointCollectionListResultIterator) Response() RestorePointCollectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RestorePointCollectionListResultIterator) Value() RestorePointCollection {
	if !iter.page.NotDone() {
		return RestorePointCollection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RestorePointCollectionListResultIterator type.
func NewRestorePointCollectionListResultIterator(page RestorePointCollectionListResultPage) RestorePointCollectionListResultIterator {
	return RestorePointCollectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rpclr RestorePointCollectionListResult) IsEmpty() bool {
	return rpclr.Value == nil || len(*rpclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rpclr RestorePointCollectionListResult) hasNextLink() bool {
	return rpclr.NextLink != nil && len(*rpclr.NextLink) != 0
}

// restorePointCollectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rpclr RestorePointCollectionListResult) restorePointCollectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rpclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rpclr.NextLink)))
}

// RestorePointCollectionListResultPage contains a page of RestorePointCollection values.
type RestorePointCollectionListResultPage struct {
	fn    func(context.Context, RestorePointCollectionListResult) (RestorePointCollectionListResult, error)
	rpclr RestorePointCollectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RestorePointCollectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RestorePointCollectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rpclr)
		if err != nil {
			return err
		}
		page.rpclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RestorePointCollectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RestorePointCollectionListResultPage) NotDone() bool {
	return !page.rpclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RestorePointCollectionListResultPage) Response() RestorePointCollectionListResult {
	return page.rpclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RestorePointCollectionListResultPage) Values() []RestorePointCollection {
	if page.rpclr.IsEmpty() {
		return nil
	}
	return *page.rpclr.Value
}

// Creates a new instance of the RestorePointCollectionListResultPage type.
func NewRestorePointCollectionListResultPage(cur RestorePointCollectionListResult, getNextPage func(context.Context, RestorePointCollectionListResult) (RestorePointCollectionListResult, error)) RestorePointCollectionListResultPage {
	return RestorePointCollectionListResultPage{
		fn:    getNextPage,
		rpclr: cur,
	}
}

// RestorePointCollectionProperties the restore point collection properties.
type RestorePointCollectionProperties struct {
	Source *RestorePointCollectionSourceProperties `json:"source,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the restore point collection.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// RestorePointCollectionID - READ-ONLY; The unique id of the restore point collection.
	RestorePointCollectionID *string `json:"restorePointCollectionId,omitempty"`
	// RestorePoints - READ-ONLY; A list containing all restore points created under this restore point collection.
	RestorePoints *[]RestorePoint `json:"restorePoints,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorePointCollectionProperties.
func (rpcp RestorePointCollectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpcp.Source != nil {
		objectMap["source"] = rpcp.Source
	}
	return json.Marshal(objectMap)
}

// RestorePointCollectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type RestorePointCollectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RestorePointCollectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RestorePointCollectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RestorePointCollectionsDeleteFuture.Result.
func (future *RestorePointCollectionsDeleteFuture) result(client RestorePointCollectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.RestorePointCollectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.RestorePointCollectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RestorePointCollectionSourceProperties the properties of the source resource that this restore point
// collection is created from.
type RestorePointCollectionSourceProperties struct {
	// Location - READ-ONLY; Location of the source resource used to create this restore point collection.
	Location *string `json:"location,omitempty"`
	// ID - Resource Id of the source resource used to create this restore point collection
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorePointCollectionSourceProperties.
func (rpcsp RestorePointCollectionSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpcsp.ID != nil {
		objectMap["id"] = rpcsp.ID
	}
	return json.Marshal(objectMap)
}

// RestorePointCollectionUpdate update Restore Point collection parameters.
type RestorePointCollectionUpdate struct {
	*RestorePointCollectionProperties `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RestorePointCollectionUpdate.
func (rpcu RestorePointCollectionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpcu.RestorePointCollectionProperties != nil {
		objectMap["properties"] = rpcu.RestorePointCollectionProperties
	}
	if rpcu.Tags != nil {
		objectMap["tags"] = rpcu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorePointCollectionUpdate struct.
func (rpcu *RestorePointCollectionUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restorePointCollectionProperties RestorePointCollectionProperties
				err = json.Unmarshal(*v, &restorePointCollectionProperties)
				if err != nil {
					return err
				}
				rpcu.RestorePointCollectionProperties = &restorePointCollectionProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rpcu.Tags = tags
			}
		}
	}

	return nil
}

// RestorePointInstanceView the instance view of a restore point.
type RestorePointInstanceView struct {
	// DiskRestorePoints - The disk restore points information.
	DiskRestorePoints *[]DiskRestorePointInstanceView `json:"diskRestorePoints,omitempty"`
	// Statuses - The resource status information.
	Statuses *[]InstanceViewStatus `json:"statuses,omitempty"`
}

// RestorePointProperties the restore point properties.
type RestorePointProperties struct {
	// ExcludeDisks - List of disk resource ids that the customer wishes to exclude from the restore point. If no disks are specified, all disks will be included.
	ExcludeDisks *[]APIEntityReference `json:"excludeDisks,omitempty"`
	// SourceMetadata - READ-ONLY; Gets the details of the VM captured at the time of the restore point creation.
	SourceMetadata *RestorePointSourceMetadata `json:"sourceMetadata,omitempty"`
	// ProvisioningState - READ-ONLY; Gets the provisioning state of the restore point.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ConsistencyMode - READ-ONLY; Gets the consistency mode for the restore point. Please refer to https://aka.ms/RestorePoints for more details. Possible values include: 'ConsistencyModeTypesCrashConsistent', 'ConsistencyModeTypesFileSystemConsistent', 'ConsistencyModeTypesApplicationConsistent'
	ConsistencyMode ConsistencyModeTypes `json:"consistencyMode,omitempty"`
	// TimeCreated - Gets the creation time of the restore point.
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
	// SourceRestorePoint - Resource Id of the source restore point from which a copy needs to be created.
	SourceRestorePoint *APIEntityReference `json:"sourceRestorePoint,omitempty"`
	// InstanceView - READ-ONLY; The restore point instance view.
	InstanceView *RestorePointInstanceView `json:"instanceView,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorePointProperties.
func (rpp RestorePointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpp.ExcludeDisks != nil {
		objectMap["excludeDisks"] = rpp.ExcludeDisks
	}
	if rpp.TimeCreated != nil {
		objectMap["timeCreated"] = rpp.TimeCreated
	}
	if rpp.SourceRestorePoint != nil {
		objectMap["sourceRestorePoint"] = rpp.SourceRestorePoint
	}
	return json.Marshal(objectMap)
}

// RestorePointsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RestorePointsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RestorePointsClient) (RestorePoint, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RestorePointsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RestorePointsCreateFuture.Result.
func (future *RestorePointsCreateFuture) result(client RestorePointsClient) (rp RestorePoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.RestorePointsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.RestorePointsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rp.Response.Response, err = future.GetResult(sender); err == nil && rp.Response.Response.StatusCode != http.StatusNoContent {
		rp, err = client.CreateResponder(rp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.RestorePointsCreateFuture", "Result", rp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RestorePointsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RestorePointsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RestorePointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RestorePointsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RestorePointsDeleteFuture.Result.
func (future *RestorePointsDeleteFuture) result(client RestorePointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.RestorePointsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.RestorePointsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RestorePointSourceMetadata describes the properties of the Virtual Machine for which the restore point
// was created. The properties provided are a subset and the snapshot of the overall Virtual Machine
// properties captured at the time of the restore point creation.
type RestorePointSourceMetadata struct {
	// HardwareProfile - Gets the hardware profile.
	HardwareProfile *HardwareProfile `json:"hardwareProfile,omitempty"`
	// StorageProfile - Gets the storage profile.
	StorageProfile *RestorePointSourceVMStorageProfile `json:"storageProfile,omitempty"`
	// OsProfile - Gets the OS profile.
	OsProfile *OSProfile `json:"osProfile,omitempty"`
	// DiagnosticsProfile - Gets the diagnostics profile.
	DiagnosticsProfile *DiagnosticsProfile `json:"diagnosticsProfile,omitempty"`
	// LicenseType - Gets the license type, which is for bring your own license scenario.
	LicenseType *string `json:"licenseType,omitempty"`
	// VMID - Gets the virtual machine unique id.
	VMID *string `json:"vmId,omitempty"`
	// SecurityProfile - Gets the security profile.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`
	// Location - Location of the VM from which the restore point was created.
	Location *string `json:"location,omitempty"`
}

// RestorePointSourceVMDataDisk describes a data disk.
type RestorePointSourceVMDataDisk struct {
	// Lun - Gets the logical unit number.
	Lun *int32 `json:"lun,omitempty"`
	// Name - Gets the disk name.
	Name *string `json:"name,omitempty"`
	// Caching - Gets the caching type. Possible values include: 'CachingTypesNone', 'CachingTypesReadOnly', 'CachingTypesReadWrite'
	Caching CachingTypes `json:"caching,omitempty"`
	// DiskSizeGB - Gets the initial disk size in GB for blank data disks, and the new desired size for existing OS and Data disks.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
	// ManagedDisk - Gets the managed disk details
	ManagedDisk *ManagedDiskParameters `json:"managedDisk,omitempty"`
	// DiskRestorePoint - Gets the disk restore point Id.
	DiskRestorePoint *APIEntityReference `json:"diskRestorePoint,omitempty"`
}

// RestorePointSourceVMOSDisk describes an Operating System disk.
type RestorePointSourceVMOSDisk struct {
	// OsType - Gets the Operating System type. Possible values include: 'OperatingSystemTypeWindows', 'OperatingSystemTypeLinux'
	OsType OperatingSystemType `json:"osType,omitempty"`
	// EncryptionSettings - Gets the disk encryption settings.
	EncryptionSettings *DiskEncryptionSettings `json:"encryptionSettings,omitempty"`
	// Name - Gets the disk name.
	Name *string `json:"name,omitempty"`
	// Caching - Gets the caching type. Possible values include: 'CachingTypesNone', 'CachingTypesReadOnly', 'CachingTypesReadWrite'
	Caching CachingTypes `json:"caching,omitempty"`
	// DiskSizeGB - Gets the disk size in GB.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
	// ManagedDisk - Gets the managed disk details
	ManagedDisk *ManagedDiskParameters `json:"managedDisk,omitempty"`
	// DiskRestorePoint - Gets the disk restore point Id.
	DiskRestorePoint *APIEntityReference `json:"diskRestorePoint,omitempty"`
}

// RestorePointSourceVMStorageProfile describes the storage profile.
type RestorePointSourceVMStorageProfile struct {
	// OsDisk - Gets the OS disk of the VM captured at the time of the restore point creation.
	OsDisk *RestorePointSourceVMOSDisk `json:"osDisk,omitempty"`
	// DataDisks - Gets the data disks of the VM captured at the time of the restore point creation.
	DataDisks *[]RestorePointSourceVMDataDisk `json:"dataDisks,omitempty"`
}

// RetrieveBootDiagnosticsDataResult the SAS URIs of the console screenshot and serial log blobs.
type RetrieveBootDiagnosticsDataResult struct {
	autorest.Response `json:"-"`
	// ConsoleScreenshotBlobURI - READ-ONLY; The console screenshot blob URI
	ConsoleScreenshotBlobURI *string `json:"consoleScreenshotBlobUri,omitempty"`
	// SerialConsoleLogBlobURI - READ-ONLY; The serial console log blob URI.
	SerialConsoleLogBlobURI *string `json:"serialConsoleLogBlobUri,omitempty"`
}

// MarshalJSON is the custom marshaler for RetrieveBootDiagnosticsDataResult.
func (rbddr RetrieveBootDiagnosticsDataResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RoleInstance ...
type RoleInstance struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Resource Location.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags       map[string]*string      `json:"tags"`
	Sku        *InstanceSku            `json:"sku,omitempty"`
	Properties *RoleInstanceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleInstance.
func (ri RoleInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ri.Sku != nil {
		objectMap["sku"] = ri.Sku
	}
	if ri.Properties != nil {
		objectMap["properties"] = ri.Properties
	}
	return json.Marshal(objectMap)
}

// RoleInstanceInstanceView the instance view of the role instance.
type RoleInstanceInstanceView struct {
	autorest.Response `json:"-"`
	// PlatformUpdateDomain - READ-ONLY; The Update Domain.
	PlatformUpdateDomain *int32 `json:"platformUpdateDomain,omitempty"`
	// PlatformFaultDomain - READ-ONLY; The Fault Domain.
	PlatformFaultDomain *int32 `json:"platformFaultDomain,omitempty"`
	// PrivateID - READ-ONLY; Specifies a unique identifier generated internally for the cloud service associated with this role instance. <br /><br /> NOTE: If you are using Azure Diagnostics extension, this property can be used as 'DeploymentId' for querying details.
	PrivateID *string `json:"privateId,omitempty"`
	// Statuses - READ-ONLY
	Statuses *[]ResourceInstanceViewStatus `json:"statuses,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleInstanceInstanceView.
func (riiv RoleInstanceInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RoleInstanceListResult ...
type RoleInstanceListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RoleInstance `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// RoleInstanceListResultIterator provides access to a complete listing of RoleInstance values.
type RoleInstanceListResultIterator struct {
	i    int
	page RoleInstanceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleInstanceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleInstanceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleInstanceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleInstanceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleInstanceListResultIterator) Response() RoleInstanceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleInstanceListResultIterator) Value() RoleInstance {
	if !iter.page.NotDone() {
		return RoleInstance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleInstanceListResultIterator type.
func NewRoleInstanceListResultIterator(page RoleInstanceListResultPage) RoleInstanceListResultIterator {
	return RoleInstanceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rilr RoleInstanceListResult) IsEmpty() bool {
	return rilr.Value == nil || len(*rilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rilr RoleInstanceListResult) hasNextLink() bool {
	return rilr.NextLink != nil && len(*rilr.NextLink) != 0
}

// roleInstanceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rilr RoleInstanceListResult) roleInstanceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rilr.NextLink)))
}

// RoleInstanceListResultPage contains a page of RoleInstance values.
type RoleInstanceListResultPage struct {
	fn   func(context.Context, RoleInstanceListResult) (RoleInstanceListResult, error)
	rilr RoleInstanceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleInstanceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleInstanceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rilr)
		if err != nil {
			return err
		}
		page.rilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleInstanceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleInstanceListResultPage) NotDone() bool {
	return !page.rilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleInstanceListResultPage) Response() RoleInstanceListResult {
	return page.rilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleInstanceListResultPage) Values() []RoleInstance {
	if page.rilr.IsEmpty() {
		return nil
	}
	return *page.rilr.Value
}

// Creates a new instance of the RoleInstanceListResultPage type.
func NewRoleInstanceListResultPage(cur RoleInstanceListResult, getNextPage func(context.Context, RoleInstanceListResult) (RoleInstanceListResult, error)) RoleInstanceListResultPage {
	return RoleInstanceListResultPage{
		fn:   getNextPage,
		rilr: cur,
	}
}

// RoleInstanceNetworkProfile describes the network profile for the role instance.
type RoleInstanceNetworkProfile struct {
	// NetworkInterfaces - READ-ONLY; Specifies the list of resource Ids for the network interfaces associated with the role instance.
	NetworkInterfaces *[]SubResource `json:"networkInterfaces,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleInstanceNetworkProfile.
func (rinp RoleInstanceNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RoleInstanceProperties ...
type RoleInstanceProperties struct {
	NetworkProfile *RoleInstanceNetworkProfile `json:"networkProfile,omitempty"`
	InstanceView   *RoleInstanceInstanceView   `json:"instanceView,omitempty"`
}

// RoleInstances specifies a list of role instances from the cloud service.
type RoleInstances struct {
	// RoleInstances - List of cloud service role instance names. Value of '*' will signify all role instances of the cloud service.
	RoleInstances *[]string `json:"roleInstances,omitempty"`
}

// RollbackStatusInfo information about rollback on failed VM instances after a OS Upgrade operation.
type RollbackStatusInfo struct {
	// SuccessfullyRolledbackInstanceCount - READ-ONLY; The number of instances which have been successfully rolled back.
	SuccessfullyRolledbackInstanceCount *int32 `json:"successfullyRolledbackInstanceCount,omitempty"`
	// FailedRolledbackInstanceCount - READ-ONLY; The number of instances which failed to rollback.
	FailedRolledbackInstanceCount *int32 `json:"failedRolledbackInstanceCount,omitempty"`
	// RollbackError - READ-ONLY; Error details if OS rollback failed.
	RollbackError *APIError `json:"rollbackError,omitempty"`
}

// MarshalJSON is the custom marshaler for RollbackStatusInfo.
func (rsi RollbackStatusInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RollingUpgradePolicy the configuration parameters used while performing a rolling upgrade.
type RollingUpgradePolicy struct {
	// MaxBatchInstancePercent - The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
	MaxBatchInstancePercent *int32 `json:"maxBatchInstancePercent,omitempty"`
	// MaxUnhealthyInstancePercent - The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The default value for this parameter is 20%.
	MaxUnhealthyInstancePercent *int32 `json:"maxUnhealthyInstancePercent,omitempty"`
	// MaxUnhealthyUpgradedInstancePercent - The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The default value for this parameter is 20%.
	MaxUnhealthyUpgradedInstancePercent *int32 `json:"maxUnhealthyUpgradedInstancePercent,omitempty"`
	// PauseTimeBetweenBatches - The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format. The default value is 0 seconds (PT0S).
	PauseTimeBetweenBatches *string `json:"pauseTimeBetweenBatches,omitempty"`
	// EnableCrossZoneUpgrade - Allow VMSS to ignore AZ boundaries when constructing upgrade batches. Take into consideration the Update Domain and maxBatchInstancePercent to determine the batch size.
	EnableCrossZoneUpgrade *bool `json:"enableCrossZoneUpgrade,omitempty"`
	// PrioritizeUnhealthyInstances - Upgrade all unhealthy instances in a scale set before any healthy instances.
	PrioritizeUnhealthyInstances *bool `json:"prioritizeUnhealthyInstances,omitempty"`
}

// RollingUpgradeProgressInfo information about the number of virtual machine instances in each upgrade
// state.
type RollingUpgradeProgressInfo struct {
	// SuccessfulInstanceCount - READ-ONLY; The number of instances that have been successfully upgraded.
	SuccessfulInstanceCount *int32 `json:"successfulInstanceCount,omitempty"`
	// FailedInstanceCount - READ-ONLY; The number of instances that have failed to be upgraded successfully.
	FailedInstanceCount *int32 `json:"failedInstanceCount,omitempty"`
	// InProgressInstanceCount - READ-ONLY; The number of instances that are currently being upgraded.
	InProgressInstanceCount *int32 `json:"inProgressInstanceCount,omitempty"`
	// PendingInstanceCount - READ-ONLY; The number of instances that have not yet begun to be upgraded.
	PendingInstanceCount *int32 `json:"pendingInstanceCount,omitempty"`
}

// MarshalJSON is the custom marshaler for RollingUpgradeProgressInfo.
func (rupi RollingUpgradeProgressInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RollingUpgradeRunningStatus information about the current running state of the overall upgrade.
type RollingUpgradeRunningStatus struct {
	// Code - READ-ONLY; Code indicating the current status of the upgrade. Possible values include: 'RollingUpgradeStatusCodeRollingForward', 'RollingUpgradeStatusCodeCancelled', 'RollingUpgradeStatusCodeCompleted', 'RollingUpgradeStatusCodeFaulted'
	Code RollingUpgradeStatusCode `json:"code,omitempty"`
	// StartTime - READ-ONLY; Start time of the upgrade.
	StartTime *date.Time `json:"startTime,omitempty"`
	// LastAction - READ-ONLY; The last action performed on the rolling upgrade. Possible values include: 'RollingUpgradeActionTypeStart', 'RollingUpgradeActionTypeCancel'
	LastAction RollingUpgradeActionType `json:"lastAction,omitempty"`
	// LastActionTime - READ-ONLY; Last action time of the upgrade.
	LastActionTime *date.Time `json:"lastActionTime,omitempty"`
}

// MarshalJSON is the custom marshaler for RollingUpgradeRunningStatus.
func (rurs RollingUpgradeRunningStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RollingUpgradeStatusInfo the status of the latest virtual machine scale set rolling upgrade.
type RollingUpgradeStatusInfo struct {
	autorest.Response                   `json:"-"`
	*RollingUpgradeStatusInfoProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RollingUpgradeStatusInfo.
func (rusi RollingUpgradeStatusInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rusi.RollingUpgradeStatusInfoProperties != nil {
		objectMap["properties"] = rusi.RollingUpgradeStatusInfoProperties
	}
	if rusi.Location != nil {
		objectMap["location"] = rusi.Location
	}
	if rusi.Tags != nil {
		objectMap["tags"] = rusi.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RollingUpgradeStatusInfo struct.
func (rusi *RollingUpgradeStatusInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var rollingUpgradeStatusInfoProperties RollingUpgradeStatusInfoProperties
				err = json.Unmarshal(*v, &rollingUpgradeStatusInfoProperties)
				if err != nil {
					return err
				}
				rusi.RollingUpgradeStatusInfoProperties = &rollingUpgradeStatusInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rusi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rusi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rusi.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rusi.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rusi.Tags = tags
			}
		}
	}

	return nil
}

// RollingUpgradeStatusInfoProperties the status of the latest virtual machine scale set rolling upgrade.
type RollingUpgradeStatusInfoProperties struct {
	// Policy - READ-ONLY; The rolling upgrade policies applied for this upgrade.
	Policy *RollingUpgradePolicy `json:"policy,omitempty"`
	// RunningStatus - READ-ONLY; Information about the current running state of the overall upgrade.
	RunningStatus *RollingUpgradeRunningStatus `json:"runningStatus,omitempty"`
	// Progress - READ-ONLY; Information about the number of virtual machine instances in each upgrade state.
	Progress *RollingUpgradeProgressInfo `json:"progress,omitempty"`
	// Error - READ-ONLY; Error details for this upgrade, if there are any.
	Error *APIError `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for RollingUpgradeStatusInfoProperties.
func (rusip RollingUpgradeStatusInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RunCommandDocument describes the properties of a Run Command.
type RunCommandDocument struct {
	autorest.Response `json:"-"`
	// Script - The script to be executed.
	Script *[]string `json:"script,omitempty"`
	// Parameters - The parameters used by the script.
	Parameters *[]RunCommandParameterDefinition `json:"parameters,omitempty"`
	// Schema - The VM run command schema.
	Schema *string `json:"$schema,omitempty"`
	// ID - The VM run command id.
	ID *string `json:"id,omitempty"`
	// OsType - The Operating System type. Possible values include: 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// Label - The VM run command label.
	Label *string `json:"label,omitempty"`
	// Description - The VM run command description.
	Description *string `json:"description,omitempty"`
}

// RunCommandDocumentBase describes the properties of a Run Command metadata.
type RunCommandDocumentBase struct {
	// Schema - The VM run command schema.
	Schema *string `json:"$schema,omitempty"`
	// ID - The VM run command id.
	ID *string `json:"id,omitempty"`
	// OsType - The Operating System type. Possible values include: 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// Label - The VM run command label.
	Label *string `json:"label,omitempty"`
	// Description - The VM run command description.
	Description *string `json:"description,omitempty"`
}

// RunCommandInput capture Virtual Machine parameters.
type RunCommandInput struct {
	// CommandID - The run command id.
	CommandID *string `json:"commandId,omitempty"`
	// Script - Optional. The script to be executed.  When this value is given, the given script will override the default script of the command.
	Script *[]string `json:"script,omitempty"`
	// Parameters - The run command parameters.
	Parameters *[]RunCommandInputParameter `json:"parameters,omitempty"`
}

// RunCommandInputParameter describes the properties of a run command parameter.
type RunCommandInputParameter struct {
	// Name - The run command parameter name.
	Name *string `json:"name,omitempty"`
	// Value - The run command parameter value.
	Value *string `json:"value,omitempty"`
}

// RunCommandListResult the List Virtual Machine operation response.
type RunCommandListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of virtual machine run commands.
	Value *[]RunCommandDocumentBase `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of run commands. Call ListNext() with this to fetch the next page of run commands.
	NextLink *string `json:"nextLink,omitempty"`
}

// RunCommandListResultIterator provides access to a complete listing of RunCommandDocumentBase values.
type RunCommandListResultIterator struct {
	i    int
	page RunCommandListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RunCommandListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RunCommandListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RunCommandListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RunCommandListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RunCommandListResultIterator) Response() RunCommandListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RunCommandListResultIterator) Value() RunCommandDocumentBase {
	if !iter.page.NotDone() {
		return RunCommandDocumentBase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RunCommandListResultIterator type.
func NewRunCommandListResultIterator(page RunCommandListResultPage) RunCommandListResultIterator {
	return RunCommandListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rclr RunCommandListResult) IsEmpty() bool {
	return rclr.Value == nil || len(*rclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rclr RunCommandListResult) hasNextLink() bool {
	return rclr.NextLink != nil && len(*rclr.NextLink) != 0
}

// runCommandListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rclr RunCommandListResult) runCommandListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rclr.NextLink)))
}

// RunCommandListResultPage contains a page of RunCommandDocumentBase values.
type RunCommandListResultPage struct {
	fn   func(context.Context, RunCommandListResult) (RunCommandListResult, error)
	rclr RunCommandListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RunCommandListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RunCommandListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rclr)
		if err != nil {
			return err
		}
		page.rclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RunCommandListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RunCommandListResultPage) NotDone() bool {
	return !page.rclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RunCommandListResultPage) Response() RunCommandListResult {
	return page.rclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RunCommandListResultPage) Values() []RunCommandDocumentBase {
	if page.rclr.IsEmpty() {
		return nil
	}
	return *page.rclr.Value
}

// Creates a new instance of the RunCommandListResultPage type.
func NewRunCommandListResultPage(cur RunCommandListResult, getNextPage func(context.Context, RunCommandListResult) (RunCommandListResult, error)) RunCommandListResultPage {
	return RunCommandListResultPage{
		fn:   getNextPage,
		rclr: cur,
	}
}

// RunCommandParameterDefinition describes the properties of a run command parameter.
type RunCommandParameterDefinition struct {
	// Name - The run command parameter name.
	Name *string `json:"name,omitempty"`
	// Type - The run command parameter type.
	Type *string `json:"type,omitempty"`
	// DefaultValue - The run command parameter default value.
	DefaultValue *string `json:"defaultValue,omitempty"`
	// Required - The run command parameter required.
	Required *bool `json:"required,omitempty"`
}

// RunCommandResult ...
type RunCommandResult struct {
	autorest.Response `json:"-"`
	// Value - Run command operation response.
	Value *[]InstanceViewStatus `json:"value,omitempty"`
}

// ScaleInPolicy describes a scale-in policy for a virtual machine scale set.
type ScaleInPolicy struct {
	// Rules - The rules to be followed when scaling-in a virtual machine scale set. <br><br> Possible values are: <br><br> **Default** When a virtual machine scale set is scaled in, the scale set will first be balanced across zones if it is a zonal scale set. Then, it will be balanced across Fault Domains as far as possible. Within each Fault Domain, the virtual machines chosen for removal will be the newest ones that are not protected from scale-in. <br><br> **OldestVM** When a virtual machine scale set is being scaled-in, the oldest virtual machines that are not protected from scale-in will be chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced across zones. Within each zone, the oldest virtual machines that are not protected will be chosen for removal. <br><br> **NewestVM** When a virtual machine scale set is being scaled-in, the newest virtual machines that are not protected from scale-in will be chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced across zones. Within each zone, the newest virtual machines that are not protected will be chosen for removal. <br><br>
	Rules *[]VirtualMachineScaleSetScaleInRules `json:"rules,omitempty"`
	// ForceDeletion - This property allows you to specify if virtual machines chosen for removal have to be force deleted when a virtual machine scale set is being scaled-in.(Feature in Preview)
	ForceDeletion *bool `json:"forceDeletion,omitempty"`
}

// ScheduledEventsProfile ...
type ScheduledEventsProfile struct {
	// TerminateNotificationProfile - Specifies Terminate Scheduled Event related configurations.
	TerminateNotificationProfile *TerminateNotificationProfile `json:"terminateNotificationProfile,omitempty"`
}

// SecurityProfile specifies the Security profile settings for the virtual machine or virtual machine scale
// set.
type SecurityProfile struct {
	// UefiSettings - Specifies the security settings like secure boot and vTPM used while creating the virtual machine. <br><br>Minimum api-version: 2020-12-01
	UefiSettings *UefiSettings `json:"uefiSettings,omitempty"`
	// EncryptionAtHost - This property can be used by user in the request to enable or disable the Host Encryption for the virtual machine or virtual machine scale set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. <br><br> Default: The Encryption at host will be disabled unless this property is set to true for the resource.
	EncryptionAtHost *bool `json:"encryptionAtHost,omitempty"`
	// SecurityType - Specifies the SecurityType of the virtual machine. It has to be set to any specified value to enable UefiSettings. <br><br> Default: UefiSettings will not be enabled unless this property is set. Possible values include: 'SecurityTypesTrustedLaunch', 'SecurityTypesConfidentialVM'
	SecurityType SecurityTypes `json:"securityType,omitempty"`
}

// SharedGallery specifies information about the Shared Gallery that you want to create or update.
type SharedGallery struct {
	autorest.Response        `json:"-"`
	*SharedGalleryIdentifier `json:"identifier,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedGallery.
func (sg SharedGallery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sg.SharedGalleryIdentifier != nil {
		objectMap["identifier"] = sg.SharedGalleryIdentifier
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SharedGallery struct.
func (sg *SharedGallery) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identifier":
			if v != nil {
				var sharedGalleryIdentifier SharedGalleryIdentifier
				err = json.Unmarshal(*v, &sharedGalleryIdentifier)
				if err != nil {
					return err
				}
				sg.SharedGalleryIdentifier = &sharedGalleryIdentifier
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sg.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sg.Location = &location
			}
		}
	}

	return nil
}

// SharedGalleryIdentifier the identifier information of shared gallery.
type SharedGalleryIdentifier struct {
	// UniqueID - The unique id of this shared gallery.
	UniqueID *string `json:"uniqueId,omitempty"`
}

// SharedGalleryImage specifies information about the gallery image definition that you want to create or
// update.
type SharedGalleryImage struct {
	autorest.Response             `json:"-"`
	*SharedGalleryImageProperties `json:"properties,omitempty"`
	*SharedGalleryIdentifier      `json:"identifier,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedGalleryImage.
func (sgi SharedGalleryImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sgi.SharedGalleryImageProperties != nil {
		objectMap["properties"] = sgi.SharedGalleryImageProperties
	}
	if sgi.SharedGalleryIdentifier != nil {
		objectMap["identifier"] = sgi.SharedGalleryIdentifier
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SharedGalleryImage struct.
func (sgi *SharedGalleryImage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sharedGalleryImageProperties SharedGalleryImageProperties
				err = json.Unmarshal(*v, &sharedGalleryImageProperties)
				if err != nil {
					return err
				}
				sgi.SharedGalleryImageProperties = &sharedGalleryImageProperties
			}
		case "identifier":
			if v != nil {
				var sharedGalleryIdentifier SharedGalleryIdentifier
				err = json.Unmarshal(*v, &sharedGalleryIdentifier)
				if err != nil {
					return err
				}
				sgi.SharedGalleryIdentifier = &sharedGalleryIdentifier
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sgi.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sgi.Location = &location
			}
		}
	}

	return nil
}

// SharedGalleryImageList the List Shared Gallery Images operation response.
type SharedGalleryImageList struct {
	autorest.Response `json:"-"`
	// Value - A list of shared gallery images.
	Value *[]SharedGalleryImage `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of shared gallery images. Call ListNext() with this to fetch the next page of shared gallery images.
	NextLink *string `json:"nextLink,omitempty"`
}

// SharedGalleryImageListIterator provides access to a complete listing of SharedGalleryImage values.
type SharedGalleryImageListIterator struct {
	i    int
	page SharedGalleryImageListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SharedGalleryImageListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedGalleryImageListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SharedGalleryImageListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SharedGalleryImageListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SharedGalleryImageListIterator) Response() SharedGalleryImageList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SharedGalleryImageListIterator) Value() SharedGalleryImage {
	if !iter.page.NotDone() {
		return SharedGalleryImage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SharedGalleryImageListIterator type.
func NewSharedGalleryImageListIterator(page SharedGalleryImageListPage) SharedGalleryImageListIterator {
	return SharedGalleryImageListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sgil SharedGalleryImageList) IsEmpty() bool {
	return sgil.Value == nil || len(*sgil.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sgil SharedGalleryImageList) hasNextLink() bool {
	return sgil.NextLink != nil && len(*sgil.NextLink) != 0
}

// sharedGalleryImageListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sgil SharedGalleryImageList) sharedGalleryImageListPreparer(ctx context.Context) (*http.Request, error) {
	if !sgil.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sgil.NextLink)))
}

// SharedGalleryImageListPage contains a page of SharedGalleryImage values.
type SharedGalleryImageListPage struct {
	fn   func(context.Context, SharedGalleryImageList) (SharedGalleryImageList, error)
	sgil SharedGalleryImageList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SharedGalleryImageListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedGalleryImageListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sgil)
		if err != nil {
			return err
		}
		page.sgil = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SharedGalleryImageListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SharedGalleryImageListPage) NotDone() bool {
	return !page.sgil.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SharedGalleryImageListPage) Response() SharedGalleryImageList {
	return page.sgil
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SharedGalleryImageListPage) Values() []SharedGalleryImage {
	if page.sgil.IsEmpty() {
		return nil
	}
	return *page.sgil.Value
}

// Creates a new instance of the SharedGalleryImageListPage type.
func NewSharedGalleryImageListPage(cur SharedGalleryImageList, getNextPage func(context.Context, SharedGalleryImageList) (SharedGalleryImageList, error)) SharedGalleryImageListPage {
	return SharedGalleryImageListPage{
		fn:   getNextPage,
		sgil: cur,
	}
}

// SharedGalleryImageProperties describes the properties of a gallery image definition.
type SharedGalleryImageProperties struct {
	// OsType - This property allows you to specify the type of the OS that is included in the disk when creating a VM from a managed image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**. Possible values include: 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// OsState - This property allows the user to specify whether the virtual machines created under this image are 'Generalized' or 'Specialized'. Possible values include: 'OperatingSystemStateTypesGeneralized', 'OperatingSystemStateTypesSpecialized'
	OsState OperatingSystemStateTypes `json:"osState,omitempty"`
	// EndOfLifeDate - The end of life date of the gallery image definition. This property can be used for decommissioning purposes. This property is updatable.
	EndOfLifeDate *date.Time                       `json:"endOfLifeDate,omitempty"`
	Identifier    *GalleryImageIdentifier          `json:"identifier,omitempty"`
	Recommended   *RecommendedMachineConfiguration `json:"recommended,omitempty"`
	Disallowed    *Disallowed                      `json:"disallowed,omitempty"`
	// HyperVGeneration - The hypervisor generation of the Virtual Machine. Applicable to OS disks only. Possible values include: 'HyperVGenerationV1', 'HyperVGenerationV2'
	HyperVGeneration HyperVGeneration `json:"hyperVGeneration,omitempty"`
	// Features - A list of gallery image features.
	Features     *[]GalleryImageFeature `json:"features,omitempty"`
	PurchasePlan *ImagePurchasePlan     `json:"purchasePlan,omitempty"`
}

// SharedGalleryImageVersion specifies information about the gallery image version that you want to create
// or update.
type SharedGalleryImageVersion struct {
	autorest.Response                    `json:"-"`
	*SharedGalleryImageVersionProperties `json:"properties,omitempty"`
	*SharedGalleryIdentifier             `json:"identifier,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedGalleryImageVersion.
func (sgiv SharedGalleryImageVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sgiv.SharedGalleryImageVersionProperties != nil {
		objectMap["properties"] = sgiv.SharedGalleryImageVersionProperties
	}
	if sgiv.SharedGalleryIdentifier != nil {
		objectMap["identifier"] = sgiv.SharedGalleryIdentifier
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SharedGalleryImageVersion struct.
func (sgiv *SharedGalleryImageVersion) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sharedGalleryImageVersionProperties SharedGalleryImageVersionProperties
				err = json.Unmarshal(*v, &sharedGalleryImageVersionProperties)
				if err != nil {
					return err
				}
				sgiv.SharedGalleryImageVersionProperties = &sharedGalleryImageVersionProperties
			}
		case "identifier":
			if v != nil {
				var sharedGalleryIdentifier SharedGalleryIdentifier
				err = json.Unmarshal(*v, &sharedGalleryIdentifier)
				if err != nil {
					return err
				}
				sgiv.SharedGalleryIdentifier = &sharedGalleryIdentifier
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sgiv.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sgiv.Location = &location
			}
		}
	}

	return nil
}

// SharedGalleryImageVersionList the List Shared Gallery Image versions operation response.
type SharedGalleryImageVersionList struct {
	autorest.Response `json:"-"`
	// Value - A list of shared gallery images versions.
	Value *[]SharedGalleryImageVersion `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of shared gallery image versions. Call ListNext() with this to fetch the next page of shared gallery image versions.
	NextLink *string `json:"nextLink,omitempty"`
}

// SharedGalleryImageVersionListIterator provides access to a complete listing of SharedGalleryImageVersion
// values.
type SharedGalleryImageVersionListIterator struct {
	i    int
	page SharedGalleryImageVersionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SharedGalleryImageVersionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedGalleryImageVersionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SharedGalleryImageVersionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SharedGalleryImageVersionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SharedGalleryImageVersionListIterator) Response() SharedGalleryImageVersionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SharedGalleryImageVersionListIterator) Value() SharedGalleryImageVersion {
	if !iter.page.NotDone() {
		return SharedGalleryImageVersion{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SharedGalleryImageVersionListIterator type.
func NewSharedGalleryImageVersionListIterator(page SharedGalleryImageVersionListPage) SharedGalleryImageVersionListIterator {
	return SharedGalleryImageVersionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sgivl SharedGalleryImageVersionList) IsEmpty() bool {
	return sgivl.Value == nil || len(*sgivl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sgivl SharedGalleryImageVersionList) hasNextLink() bool {
	return sgivl.NextLink != nil && len(*sgivl.NextLink) != 0
}

// sharedGalleryImageVersionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sgivl SharedGalleryImageVersionList) sharedGalleryImageVersionListPreparer(ctx context.Context) (*http.Request, error) {
	if !sgivl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sgivl.NextLink)))
}

// SharedGalleryImageVersionListPage contains a page of SharedGalleryImageVersion values.
type SharedGalleryImageVersionListPage struct {
	fn    func(context.Context, SharedGalleryImageVersionList) (SharedGalleryImageVersionList, error)
	sgivl SharedGalleryImageVersionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SharedGalleryImageVersionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedGalleryImageVersionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sgivl)
		if err != nil {
			return err
		}
		page.sgivl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SharedGalleryImageVersionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SharedGalleryImageVersionListPage) NotDone() bool {
	return !page.sgivl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SharedGalleryImageVersionListPage) Response() SharedGalleryImageVersionList {
	return page.sgivl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SharedGalleryImageVersionListPage) Values() []SharedGalleryImageVersion {
	if page.sgivl.IsEmpty() {
		return nil
	}
	return *page.sgivl.Value
}

// Creates a new instance of the SharedGalleryImageVersionListPage type.
func NewSharedGalleryImageVersionListPage(cur SharedGalleryImageVersionList, getNextPage func(context.Context, SharedGalleryImageVersionList) (SharedGalleryImageVersionList, error)) SharedGalleryImageVersionListPage {
	return SharedGalleryImageVersionListPage{
		fn:    getNextPage,
		sgivl: cur,
	}
}

// SharedGalleryImageVersionProperties describes the properties of a gallery image version.
type SharedGalleryImageVersionProperties struct {
	// PublishedDate - The published date of the gallery image version Definition. This property can be used for decommissioning purposes. This property is updatable.
	PublishedDate *date.Time `json:"publishedDate,omitempty"`
	// EndOfLifeDate - The end of life date of the gallery image version Definition. This property can be used for decommissioning purposes. This property is updatable.
	EndOfLifeDate *date.Time `json:"endOfLifeDate,omitempty"`
}

// SharedGalleryList the List Shared Galleries operation response.
type SharedGalleryList struct {
	autorest.Response `json:"-"`
	// Value - A list of shared galleries.
	Value *[]SharedGallery `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of shared galleries. Call ListNext() with this to fetch the next page of shared galleries.
	NextLink *string `json:"nextLink,omitempty"`
}

// SharedGalleryListIterator provides access to a complete listing of SharedGallery values.
type SharedGalleryListIterator struct {
	i    int
	page SharedGalleryListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SharedGalleryListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedGalleryListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SharedGalleryListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SharedGalleryListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SharedGalleryListIterator) Response() SharedGalleryList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SharedGalleryListIterator) Value() SharedGallery {
	if !iter.page.NotDone() {
		return SharedGallery{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SharedGalleryListIterator type.
func NewSharedGalleryListIterator(page SharedGalleryListPage) SharedGalleryListIterator {
	return SharedGalleryListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sgl SharedGalleryList) IsEmpty() bool {
	return sgl.Value == nil || len(*sgl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sgl SharedGalleryList) hasNextLink() bool {
	return sgl.NextLink != nil && len(*sgl.NextLink) != 0
}

// sharedGalleryListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sgl SharedGalleryList) sharedGalleryListPreparer(ctx context.Context) (*http.Request, error) {
	if !sgl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sgl.NextLink)))
}

// SharedGalleryListPage contains a page of SharedGallery values.
type SharedGalleryListPage struct {
	fn  func(context.Context, SharedGalleryList) (SharedGalleryList, error)
	sgl SharedGalleryList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SharedGalleryListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedGalleryListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sgl)
		if err != nil {
			return err
		}
		page.sgl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SharedGalleryListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SharedGalleryListPage) NotDone() bool {
	return !page.sgl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SharedGalleryListPage) Response() SharedGalleryList {
	return page.sgl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SharedGalleryListPage) Values() []SharedGallery {
	if page.sgl.IsEmpty() {
		return nil
	}
	return *page.sgl.Value
}

// Creates a new instance of the SharedGalleryListPage type.
func NewSharedGalleryListPage(cur SharedGalleryList, getNextPage func(context.Context, SharedGalleryList) (SharedGalleryList, error)) SharedGalleryListPage {
	return SharedGalleryListPage{
		fn:  getNextPage,
		sgl: cur,
	}
}

// ShareInfoElement ...
type ShareInfoElement struct {
	// VMURI - READ-ONLY; A relative URI containing the ID of the VM that has the disk attached.
	VMURI *string `json:"vmUri,omitempty"`
}

// MarshalJSON is the custom marshaler for ShareInfoElement.
func (sie ShareInfoElement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SharingProfile profile for gallery sharing to subscription or tenant
type SharingProfile struct {
	// Permissions - This property allows you to specify the permission of sharing gallery. <br><br> Possible values are: <br><br> **Private** <br><br> **Groups**. Possible values include: 'GallerySharingPermissionTypesPrivate', 'GallerySharingPermissionTypesGroups'
	Permissions GallerySharingPermissionTypes `json:"permissions,omitempty"`
	// Groups - READ-ONLY; A list of sharing profile groups.
	Groups *[]SharingProfileGroup `json:"groups,omitempty"`
}

// MarshalJSON is the custom marshaler for SharingProfile.
func (sp SharingProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.Permissions != "" {
		objectMap["permissions"] = sp.Permissions
	}
	return json.Marshal(objectMap)
}

// SharingProfileGroup group of the gallery sharing profile
type SharingProfileGroup struct {
	// Type - This property allows you to specify the type of sharing group. <br><br> Possible values are: <br><br> **Subscriptions** <br><br> **AADTenants**. Possible values include: 'SharingProfileGroupTypesSubscriptions', 'SharingProfileGroupTypesAADTenants'
	Type SharingProfileGroupTypes `json:"type,omitempty"`
	// Ids - A list of subscription/tenant ids the gallery is aimed to be shared to.
	Ids *[]string `json:"ids,omitempty"`
}

// SharingUpdate specifies information about the gallery sharing profile update.
type SharingUpdate struct {
	autorest.Response `json:"-"`
	// OperationType - This property allows you to specify the operation type of gallery sharing update. <br><br> Possible values are: <br><br> **Add** <br><br> **Remove** <br><br> **Reset**. Possible values include: 'SharingUpdateOperationTypesAdd', 'SharingUpdateOperationTypesRemove', 'SharingUpdateOperationTypesReset'
	OperationType SharingUpdateOperationTypes `json:"operationType,omitempty"`
	// Groups - A list of sharing profile groups.
	Groups *[]SharingProfileGroup `json:"groups,omitempty"`
}

// Sku describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware
// the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU
// name.
type Sku struct {
	// Name - The sku name.
	Name *string `json:"name,omitempty"`
	// Tier - Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**
	Tier *string `json:"tier,omitempty"`
	// Capacity - Specifies the number of virtual machines in the scale set.
	Capacity *int64 `json:"capacity,omitempty"`
}

// Snapshot snapshot resource.
type Snapshot struct {
	autorest.Response `json:"-"`
	// ManagedBy - READ-ONLY; Unused. Always Null.
	ManagedBy *string      `json:"managedBy,omitempty"`
	Sku       *SnapshotSku `json:"sku,omitempty"`
	// ExtendedLocation - The extended location where the snapshot will be created. Extended location cannot be changed.
	ExtendedLocation    *ExtendedLocation `json:"extendedLocation,omitempty"`
	*SnapshotProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Snapshot.
func (s Snapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Sku != nil {
		objectMap["sku"] = s.Sku
	}
	if s.ExtendedLocation != nil {
		objectMap["extendedLocation"] = s.ExtendedLocation
	}
	if s.SnapshotProperties != nil {
		objectMap["properties"] = s.SnapshotProperties
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Snapshot struct.
func (s *Snapshot) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				s.ManagedBy = &managedBy
			}
		case "sku":
			if v != nil {
				var sku SnapshotSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				s.Sku = &sku
			}
		case "extendedLocation":
			if v != nil {
				var extendedLocation ExtendedLocation
				err = json.Unmarshal(*v, &extendedLocation)
				if err != nil {
					return err
				}
				s.ExtendedLocation = &extendedLocation
			}
		case "properties":
			if v != nil {
				var snapshotProperties SnapshotProperties
				err = json.Unmarshal(*v, &snapshotProperties)
				if err != nil {
					return err
				}
				s.SnapshotProperties = &snapshotProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		}
	}

	return nil
}

// SnapshotList the List Snapshots operation response.
type SnapshotList struct {
	autorest.Response `json:"-"`
	// Value - A list of snapshots.
	Value *[]Snapshot `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of snapshots. Call ListNext() with this to fetch the next page of snapshots.
	NextLink *string `json:"nextLink,omitempty"`
}

// SnapshotListIterator provides access to a complete listing of Snapshot values.
type SnapshotListIterator struct {
	i    int
	page SnapshotListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SnapshotListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SnapshotListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SnapshotListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SnapshotListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SnapshotListIterator) Response() SnapshotList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SnapshotListIterator) Value() Snapshot {
	if !iter.page.NotDone() {
		return Snapshot{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SnapshotListIterator type.
func NewSnapshotListIterator(page SnapshotListPage) SnapshotListIterator {
	return SnapshotListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl SnapshotList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sl SnapshotList) hasNextLink() bool {
	return sl.NextLink != nil && len(*sl.NextLink) != 0
}

// snapshotListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl SnapshotList) snapshotListPreparer(ctx context.Context) (*http.Request, error) {
	if !sl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// SnapshotListPage contains a page of Snapshot values.
type SnapshotListPage struct {
	fn func(context.Context, SnapshotList) (SnapshotList, error)
	sl SnapshotList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SnapshotListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SnapshotListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sl)
		if err != nil {
			return err
		}
		page.sl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SnapshotListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SnapshotListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SnapshotListPage) Response() SnapshotList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SnapshotListPage) Values() []Snapshot {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the SnapshotListPage type.
func NewSnapshotListPage(cur SnapshotList, getNextPage func(context.Context, SnapshotList) (SnapshotList, error)) SnapshotListPage {
	return SnapshotListPage{
		fn: getNextPage,
		sl: cur,
	}
}

// SnapshotProperties snapshot resource properties.
type SnapshotProperties struct {
	// TimeCreated - READ-ONLY; The time when the snapshot was created.
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
	// OsType - The Operating System type. Possible values include: 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// HyperVGeneration - The hypervisor generation of the Virtual Machine. Applicable to OS disks only. Possible values include: 'HyperVGenerationV1', 'HyperVGenerationV2'
	HyperVGeneration HyperVGeneration `json:"hyperVGeneration,omitempty"`
	// PurchasePlan - Purchase plan information for the image from which the source disk for the snapshot was originally created.
	PurchasePlan *PurchasePlan `json:"purchasePlan,omitempty"`
	// SupportedCapabilities - List of supported capabilities (like Accelerated Networking) for the image from which the source disk from the snapshot was originally created.
	SupportedCapabilities *SupportedCapabilities `json:"supportedCapabilities,omitempty"`
	// CreationData - Disk source information. CreationData information cannot be changed after the disk has been created.
	CreationData *CreationData `json:"creationData,omitempty"`
	// DiskSizeGB - If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
	// DiskSizeBytes - READ-ONLY; The size of the disk in bytes. This field is read only.
	DiskSizeBytes *int64 `json:"diskSizeBytes,omitempty"`
	// DiskState - The state of the snapshot. Possible values include: 'DiskStateUnattached', 'DiskStateAttached', 'DiskStateReserved', 'DiskStateFrozen', 'DiskStateActiveSAS', 'DiskStateActiveSASFrozen', 'DiskStateReadyToUpload', 'DiskStateActiveUpload'
	DiskState DiskState `json:"diskState,omitempty"`
	// UniqueID - READ-ONLY; Unique Guid identifying the resource.
	UniqueID *string `json:"uniqueId,omitempty"`
	// EncryptionSettingsCollection - Encryption settings collection used be Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
	EncryptionSettingsCollection *EncryptionSettingsCollection `json:"encryptionSettingsCollection,omitempty"`
	// ProvisioningState - READ-ONLY; The disk provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Incremental - Whether a snapshot is incremental. Incremental snapshots on the same disk occupy less space than full snapshots and can be diffed.
	Incremental *bool `json:"incremental,omitempty"`
	// Encryption - Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
	Encryption *Encryption `json:"encryption,omitempty"`
	// NetworkAccessPolicy - Possible values include: 'NetworkAccessPolicyAllowAll', 'NetworkAccessPolicyAllowPrivate', 'NetworkAccessPolicyDenyAll'
	NetworkAccessPolicy NetworkAccessPolicy `json:"networkAccessPolicy,omitempty"`
	// DiskAccessID - ARM id of the DiskAccess resource for using private endpoints on disks.
	DiskAccessID *string `json:"diskAccessId,omitempty"`
	// SecurityProfile - Contains the security related information for the resource.
	SecurityProfile *DiskSecurityProfile `json:"securityProfile,omitempty"`
	// SupportsHibernation - Indicates the OS on a snapshot supports hibernation.
	SupportsHibernation *bool `json:"supportsHibernation,omitempty"`
	// PublicNetworkAccess - Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// CompletionPercent - Percentage complete for the background copy when a resource is created via the CopyStart operation.
	CompletionPercent *float64 `json:"completionPercent,omitempty"`
}

// MarshalJSON is the custom marshaler for SnapshotProperties.
func (sp SnapshotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.OsType != "" {
		objectMap["osType"] = sp.OsType
	}
	if sp.HyperVGeneration != "" {
		objectMap["hyperVGeneration"] = sp.HyperVGeneration
	}
	if sp.PurchasePlan != nil {
		objectMap["purchasePlan"] = sp.PurchasePlan
	}
	if sp.SupportedCapabilities != nil {
		objectMap["supportedCapabilities"] = sp.SupportedCapabilities
	}
	if sp.CreationData != nil {
		objectMap["creationData"] = sp.CreationData
	}
	if sp.DiskSizeGB != nil {
		objectMap["diskSizeGB"] = sp.DiskSizeGB
	}
	if sp.DiskState != "" {
		objectMap["diskState"] = sp.DiskState
	}
	if sp.EncryptionSettingsCollection != nil {
		objectMap["encryptionSettingsCollection"] = sp.EncryptionSettingsCollection
	}
	if sp.Incremental != nil {
		objectMap["incremental"] = sp.Incremental
	}
	if sp.Encryption != nil {
		objectMap["encryption"] = sp.Encryption
	}
	if sp.NetworkAccessPolicy != "" {
		objectMap["networkAccessPolicy"] = sp.NetworkAccessPolicy
	}
	if sp.DiskAccessID != nil {
		objectMap["diskAccessId"] = sp.DiskAccessID
	}
	if sp.SecurityProfile != nil {
		objectMap["securityProfile"] = sp.SecurityProfile
	}
	if sp.SupportsHibernation != nil {
		objectMap["supportsHibernation"] = sp.SupportsHibernation
	}
	if sp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = sp.PublicNetworkAccess
	}
	if sp.CompletionPercent != nil {
		objectMap["completionPercent"] = sp.CompletionPercent
	}
	return json.Marshal(objectMap)
}

// SnapshotsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SnapshotsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SnapshotsClient) (Snapshot, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SnapshotsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SnapshotsCreateOrUpdateFuture.Result.
func (future *SnapshotsCreateOrUpdateFuture) result(client SnapshotsClient) (s Snapshot, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.SnapshotsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		s.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.SnapshotsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.SnapshotsCreateOrUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SnapshotsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SnapshotsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SnapshotsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SnapshotsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SnapshotsDeleteFuture.Result.
func (future *SnapshotsDeleteFuture) result(client SnapshotsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.SnapshotsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.SnapshotsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SnapshotsGrantAccessFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SnapshotsGrantAccessFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SnapshotsClient) (AccessURI, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SnapshotsGrantAccessFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SnapshotsGrantAccessFuture.Result.
func (future *SnapshotsGrantAccessFuture) result(client SnapshotsClient) (au AccessURI, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.SnapshotsGrantAccessFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		au.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.SnapshotsGrantAccessFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if au.Response.Response, err = future.GetResult(sender); err == nil && au.Response.Response.StatusCode != http.StatusNoContent {
		au, err = client.GrantAccessResponder(au.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.SnapshotsGrantAccessFuture", "Result", au.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SnapshotSku the snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an
// optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same
// sku as the previous snapshot
type SnapshotSku struct {
	// Name - The sku name. Possible values include: 'SnapshotStorageAccountTypesStandardLRS', 'SnapshotStorageAccountTypesPremiumLRS', 'SnapshotStorageAccountTypesStandardZRS'
	Name SnapshotStorageAccountTypes `json:"name,omitempty"`
	// Tier - READ-ONLY; The sku tier.
	Tier *string `json:"tier,omitempty"`
}

// MarshalJSON is the custom marshaler for SnapshotSku.
func (ss SnapshotSku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.Name != "" {
		objectMap["name"] = ss.Name
	}
	return json.Marshal(objectMap)
}

// SnapshotsRevokeAccessFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SnapshotsRevokeAccessFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SnapshotsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SnapshotsRevokeAccessFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SnapshotsRevokeAccessFuture.Result.
func (future *SnapshotsRevokeAccessFuture) result(client SnapshotsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.SnapshotsRevokeAccessFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.SnapshotsRevokeAccessFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SnapshotsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SnapshotsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SnapshotsClient) (Snapshot, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SnapshotsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SnapshotsUpdateFuture.Result.
func (future *SnapshotsUpdateFuture) result(client SnapshotsClient) (s Snapshot, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.SnapshotsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		s.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.SnapshotsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.UpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.SnapshotsUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SnapshotUpdate snapshot update resource.
type SnapshotUpdate struct {
	*SnapshotUpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	Sku  *SnapshotSku       `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for SnapshotUpdate.
func (su SnapshotUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if su.SnapshotUpdateProperties != nil {
		objectMap["properties"] = su.SnapshotUpdateProperties
	}
	if su.Tags != nil {
		objectMap["tags"] = su.Tags
	}
	if su.Sku != nil {
		objectMap["sku"] = su.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SnapshotUpdate struct.
func (su *SnapshotUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var snapshotUpdateProperties SnapshotUpdateProperties
				err = json.Unmarshal(*v, &snapshotUpdateProperties)
				if err != nil {
					return err
				}
				su.SnapshotUpdateProperties = &snapshotUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				su.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku SnapshotSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				su.Sku = &sku
			}
		}
	}

	return nil
}

// SnapshotUpdateProperties snapshot resource update properties.
type SnapshotUpdateProperties struct {
	// OsType - the Operating System type. Possible values include: 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// DiskSizeGB - If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
	// EncryptionSettingsCollection - Encryption settings collection used be Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
	EncryptionSettingsCollection *EncryptionSettingsCollection `json:"encryptionSettingsCollection,omitempty"`
	// Encryption - Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
	Encryption *Encryption `json:"encryption,omitempty"`
	// NetworkAccessPolicy - Possible values include: 'NetworkAccessPolicyAllowAll', 'NetworkAccessPolicyAllowPrivate', 'NetworkAccessPolicyDenyAll'
	NetworkAccessPolicy NetworkAccessPolicy `json:"networkAccessPolicy,omitempty"`
	// DiskAccessID - ARM id of the DiskAccess resource for using private endpoints on disks.
	DiskAccessID *string `json:"diskAccessId,omitempty"`
	// SupportsHibernation - Indicates the OS on a snapshot supports hibernation.
	SupportsHibernation *bool `json:"supportsHibernation,omitempty"`
	// PublicNetworkAccess - Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// SupportedCapabilities - List of supported capabilities (like accelerated networking) for the image from which the OS disk was created.
	SupportedCapabilities *SupportedCapabilities `json:"supportedCapabilities,omitempty"`
}

// SoftDeletePolicy contains information about the soft deletion policy of the gallery.
type SoftDeletePolicy struct {
	// IsSoftDeleteEnabled - Enables soft-deletion for resources in this gallery, allowing them to be recovered within retention time.
	IsSoftDeleteEnabled *bool `json:"isSoftDeleteEnabled,omitempty"`
}

// SourceVault the vault id is an Azure Resource Manager Resource id in the form
// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}
type SourceVault struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// SpotRestorePolicy specifies the Spot-Try-Restore properties for the virtual machine scale set. <br><br>
// With this property customer can enable or disable automatic restore of the evicted Spot VMSS VM
// instances opportunistically based on capacity availability and pricing constraint.
type SpotRestorePolicy struct {
	// Enabled - Enables the Spot-Try-Restore feature where evicted VMSS SPOT instances will be tried to be restored opportunistically based on capacity availability and pricing constraints
	Enabled *bool `json:"enabled,omitempty"`
	// RestoreTimeout - Timeout value expressed as an ISO 8601 time duration after which the platform will not try to restore the VMSS SPOT instances
	RestoreTimeout *string `json:"restoreTimeout,omitempty"`
}

// SSHConfiguration SSH configuration for Linux based VMs running on Azure
type SSHConfiguration struct {
	// PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
	PublicKeys *[]SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey contains information about SSH certificate public key and the path on the Linux VM where
// the public key is placed.
type SSHPublicKey struct {
	// Path - Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
	Path *string `json:"path,omitempty"`
	// KeyData - SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
	KeyData *string `json:"keyData,omitempty"`
}

// SSHPublicKeyGenerateKeyPairResult response from generation of an SSH key pair.
type SSHPublicKeyGenerateKeyPairResult struct {
	autorest.Response `json:"-"`
	// PrivateKey - Private key portion of the key pair used to authenticate to a virtual machine through ssh. The private key is returned in RFC3447 format and should be treated as a secret.
	PrivateKey *string `json:"privateKey,omitempty"`
	// PublicKey - Public key portion of the key pair used to authenticate to a virtual machine through ssh. The public key is in ssh-rsa format.
	PublicKey *string `json:"publicKey,omitempty"`
	// ID - The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{SshPublicKeyName}
	ID *string `json:"id,omitempty"`
}

// SSHPublicKeyResource specifies information about the SSH public key.
type SSHPublicKeyResource struct {
	autorest.Response `json:"-"`
	// SSHPublicKeyResourceProperties - Properties of the SSH public key.
	*SSHPublicKeyResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SSHPublicKeyResource.
func (spkr SSHPublicKeyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spkr.SSHPublicKeyResourceProperties != nil {
		objectMap["properties"] = spkr.SSHPublicKeyResourceProperties
	}
	if spkr.Location != nil {
		objectMap["location"] = spkr.Location
	}
	if spkr.Tags != nil {
		objectMap["tags"] = spkr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SSHPublicKeyResource struct.
func (spkr *SSHPublicKeyResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SSHPublicKeyResourceProperties SSHPublicKeyResourceProperties
				err = json.Unmarshal(*v, &SSHPublicKeyResourceProperties)
				if err != nil {
					return err
				}
				spkr.SSHPublicKeyResourceProperties = &SSHPublicKeyResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spkr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spkr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spkr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				spkr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				spkr.Tags = tags
			}
		}
	}

	return nil
}

// SSHPublicKeyResourceProperties properties of the SSH public key.
type SSHPublicKeyResourceProperties struct {
	// PublicKey - SSH public key used to authenticate to a virtual machine through ssh. If this property is not initially provided when the resource is created, the publicKey property will be populated when generateKeyPair is called. If the public key is provided upon resource creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
	PublicKey *string `json:"publicKey,omitempty"`
}

// SSHPublicKeysGroupListResult the list SSH public keys operation response.
type SSHPublicKeysGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of SSH public keys
	Value *[]SSHPublicKeyResource `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of SSH public keys. Call ListNext() with this URI to fetch the next page of SSH public keys.
	NextLink *string `json:"nextLink,omitempty"`
}

// SSHPublicKeysGroupListResultIterator provides access to a complete listing of SSHPublicKeyResource
// values.
type SSHPublicKeysGroupListResultIterator struct {
	i    int
	page SSHPublicKeysGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SSHPublicKeysGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SSHPublicKeysGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SSHPublicKeysGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SSHPublicKeysGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SSHPublicKeysGroupListResultIterator) Response() SSHPublicKeysGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SSHPublicKeysGroupListResultIterator) Value() SSHPublicKeyResource {
	if !iter.page.NotDone() {
		return SSHPublicKeyResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SSHPublicKeysGroupListResultIterator type.
func NewSSHPublicKeysGroupListResultIterator(page SSHPublicKeysGroupListResultPage) SSHPublicKeysGroupListResultIterator {
	return SSHPublicKeysGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spkglr SSHPublicKeysGroupListResult) IsEmpty() bool {
	return spkglr.Value == nil || len(*spkglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (spkglr SSHPublicKeysGroupListResult) hasNextLink() bool {
	return spkglr.NextLink != nil && len(*spkglr.NextLink) != 0
}

// sSHPublicKeysGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spkglr SSHPublicKeysGroupListResult) sSHPublicKeysGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !spkglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spkglr.NextLink)))
}

// SSHPublicKeysGroupListResultPage contains a page of SSHPublicKeyResource values.
type SSHPublicKeysGroupListResultPage struct {
	fn     func(context.Context, SSHPublicKeysGroupListResult) (SSHPublicKeysGroupListResult, error)
	spkglr SSHPublicKeysGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SSHPublicKeysGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SSHPublicKeysGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.spkglr)
		if err != nil {
			return err
		}
		page.spkglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SSHPublicKeysGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SSHPublicKeysGroupListResultPage) NotDone() bool {
	return !page.spkglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SSHPublicKeysGroupListResultPage) Response() SSHPublicKeysGroupListResult {
	return page.spkglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SSHPublicKeysGroupListResultPage) Values() []SSHPublicKeyResource {
	if page.spkglr.IsEmpty() {
		return nil
	}
	return *page.spkglr.Value
}

// Creates a new instance of the SSHPublicKeysGroupListResultPage type.
func NewSSHPublicKeysGroupListResultPage(cur SSHPublicKeysGroupListResult, getNextPage func(context.Context, SSHPublicKeysGroupListResult) (SSHPublicKeysGroupListResult, error)) SSHPublicKeysGroupListResultPage {
	return SSHPublicKeysGroupListResultPage{
		fn:     getNextPage,
		spkglr: cur,
	}
}

// SSHPublicKeyUpdateResource specifies information about the SSH public key.
type SSHPublicKeyUpdateResource struct {
	// SSHPublicKeyResourceProperties - Properties of the SSH public key.
	*SSHPublicKeyResourceProperties `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SSHPublicKeyUpdateResource.
func (spkur SSHPublicKeyUpdateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spkur.SSHPublicKeyResourceProperties != nil {
		objectMap["properties"] = spkur.SSHPublicKeyResourceProperties
	}
	if spkur.Tags != nil {
		objectMap["tags"] = spkur.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SSHPublicKeyUpdateResource struct.
func (spkur *SSHPublicKeyUpdateResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SSHPublicKeyResourceProperties SSHPublicKeyResourceProperties
				err = json.Unmarshal(*v, &SSHPublicKeyResourceProperties)
				if err != nil {
					return err
				}
				spkur.SSHPublicKeyResourceProperties = &SSHPublicKeyResourceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				spkur.Tags = tags
			}
		}
	}

	return nil
}

// StatusCodeCount ...
type StatusCodeCount struct {
	// Code - READ-ONLY; The instance view status code
	Code *string `json:"code,omitempty"`
	// Count - READ-ONLY; Number of instances having this status code
	Count *int32 `json:"count,omitempty"`
}

// MarshalJSON is the custom marshaler for StatusCodeCount.
func (scc StatusCodeCount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// StorageProfile specifies the storage settings for the virtual machine disks.
type StorageProfile struct {
	// ImageReference - Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
	ImageReference *ImageReference `json:"imageReference,omitempty"`
	// OsDisk - Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
	OsDisk *OSDisk `json:"osDisk,omitempty"`
	// DataDisks - Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
	DataDisks *[]DataDisk `json:"dataDisks,omitempty"`
}

// SubResource ...
type SubResource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// SubResourceReadOnly ...
type SubResourceReadOnly struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for SubResourceReadOnly.
func (srro SubResourceReadOnly) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SubResourceWithColocationStatus ...
type SubResourceWithColocationStatus struct {
	// ColocationStatus - Describes colocation status of a resource in the Proximity Placement Group.
	ColocationStatus *InstanceViewStatus `json:"colocationStatus,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// SupportedCapabilities list of supported capabilities (like accelerated networking) persisted on the disk
// resource for VM use.
type SupportedCapabilities struct {
	// AcceleratedNetwork - True if the image from which the OS disk is created supports accelerated networking.
	AcceleratedNetwork *bool `json:"acceleratedNetwork,omitempty"`
}

// TargetRegion describes the target region information.
type TargetRegion struct {
	// Name - The name of the region.
	Name *string `json:"name,omitempty"`
	// RegionalReplicaCount - The number of replicas of the Image Version to be created per region. This property is updatable.
	RegionalReplicaCount *int32 `json:"regionalReplicaCount,omitempty"`
	// StorageAccountType - Specifies the storage account type to be used to store the image. This property is not updatable. Possible values include: 'StorageAccountTypeStandardLRS', 'StorageAccountTypeStandardZRS', 'StorageAccountTypePremiumLRS'
	StorageAccountType StorageAccountType `json:"storageAccountType,omitempty"`
	Encryption         *EncryptionImages  `json:"encryption,omitempty"`
}

// TerminateNotificationProfile ...
type TerminateNotificationProfile struct {
	// NotBeforeTimeout - Configurable length of time a Virtual Machine being deleted will have to potentially approve the Terminate Scheduled Event before the event is auto approved (timed out). The configuration must be specified in ISO 8601 format, the default value is 5 minutes (PT5M)
	NotBeforeTimeout *string `json:"notBeforeTimeout,omitempty"`
	// Enable - Specifies whether the Terminate Scheduled event is enabled or disabled.
	Enable *bool `json:"enable,omitempty"`
}

// ThrottledRequestsInput api request input for LogAnalytics getThrottledRequests Api.
type ThrottledRequestsInput struct {
	// BlobContainerSasURI - SAS Uri of the logging blob container to which LogAnalytics Api writes output logs to.
	BlobContainerSasURI *string `json:"blobContainerSasUri,omitempty"`
	// FromTime - From time of the query
	FromTime *date.Time `json:"fromTime,omitempty"`
	// ToTime - To time of the query
	ToTime *date.Time `json:"toTime,omitempty"`
	// GroupByThrottlePolicy - Group query result by Throttle Policy applied.
	GroupByThrottlePolicy *bool `json:"groupByThrottlePolicy,omitempty"`
	// GroupByOperationName - Group query result by Operation Name.
	GroupByOperationName *bool `json:"groupByOperationName,omitempty"`
	// GroupByResourceName - Group query result by Resource Name.
	GroupByResourceName *bool `json:"groupByResourceName,omitempty"`
	// GroupByClientApplicationID - Group query result by Client Application ID.
	GroupByClientApplicationID *bool `json:"groupByClientApplicationId,omitempty"`
	// GroupByUserAgent - Group query result by User Agent.
	GroupByUserAgent *bool `json:"groupByUserAgent,omitempty"`
}

// UefiSettings specifies the security settings like secure boot and vTPM used while creating the virtual
// machine. <br><br>Minimum api-version: 2020-12-01
type UefiSettings struct {
	// SecureBootEnabled - Specifies whether secure boot should be enabled on the virtual machine. <br><br>Minimum api-version: 2020-12-01
	SecureBootEnabled *bool `json:"secureBootEnabled,omitempty"`
	// VTpmEnabled - Specifies whether vTPM should be enabled on the virtual machine. <br><br>Minimum api-version: 2020-12-01
	VTpmEnabled *bool `json:"vTpmEnabled,omitempty"`
}

// UpdateDomain defines an update domain for the cloud service.
type UpdateDomain struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateDomain.
func (ud UpdateDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UpdateDomainListResult ...
type UpdateDomainListResult struct {
	autorest.Response `json:"-"`
	Value             *[]UpdateDomain `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// UpdateDomainListResultIterator provides access to a complete listing of UpdateDomain values.
type UpdateDomainListResultIterator struct {
	i    int
	page UpdateDomainListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UpdateDomainListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UpdateDomainListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UpdateDomainListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UpdateDomainListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UpdateDomainListResultIterator) Response() UpdateDomainListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UpdateDomainListResultIterator) Value() UpdateDomain {
	if !iter.page.NotDone() {
		return UpdateDomain{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UpdateDomainListResultIterator type.
func NewUpdateDomainListResultIterator(page UpdateDomainListResultPage) UpdateDomainListResultIterator {
	return UpdateDomainListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (udlr UpdateDomainListResult) IsEmpty() bool {
	return udlr.Value == nil || len(*udlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (udlr UpdateDomainListResult) hasNextLink() bool {
	return udlr.NextLink != nil && len(*udlr.NextLink) != 0
}

// updateDomainListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (udlr UpdateDomainListResult) updateDomainListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !udlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(udlr.NextLink)))
}

// UpdateDomainListResultPage contains a page of UpdateDomain values.
type UpdateDomainListResultPage struct {
	fn   func(context.Context, UpdateDomainListResult) (UpdateDomainListResult, error)
	udlr UpdateDomainListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UpdateDomainListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UpdateDomainListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.udlr)
		if err != nil {
			return err
		}
		page.udlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UpdateDomainListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UpdateDomainListResultPage) NotDone() bool {
	return !page.udlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UpdateDomainListResultPage) Response() UpdateDomainListResult {
	return page.udlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UpdateDomainListResultPage) Values() []UpdateDomain {
	if page.udlr.IsEmpty() {
		return nil
	}
	return *page.udlr.Value
}

// Creates a new instance of the UpdateDomainListResultPage type.
func NewUpdateDomainListResultPage(cur UpdateDomainListResult, getNextPage func(context.Context, UpdateDomainListResult) (UpdateDomainListResult, error)) UpdateDomainListResultPage {
	return UpdateDomainListResultPage{
		fn:   getNextPage,
		udlr: cur,
	}
}

// UpdateResource the Update Resource model definition.
type UpdateResource struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for UpdateResource.
func (ur UpdateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ur.Tags != nil {
		objectMap["tags"] = ur.Tags
	}
	return json.Marshal(objectMap)
}

// UpdateResourceDefinition the Update Resource model definition.
type UpdateResourceDefinition struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for UpdateResourceDefinition.
func (urd UpdateResourceDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if urd.Tags != nil {
		objectMap["tags"] = urd.Tags
	}
	return json.Marshal(objectMap)
}

// UpgradeOperationHistoricalStatusInfo virtual Machine Scale Set OS Upgrade History operation response.
type UpgradeOperationHistoricalStatusInfo struct {
	// Properties - READ-ONLY; Information about the properties of the upgrade operation.
	Properties *UpgradeOperationHistoricalStatusInfoProperties `json:"properties,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for UpgradeOperationHistoricalStatusInfo.
func (uohsi UpgradeOperationHistoricalStatusInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UpgradeOperationHistoricalStatusInfoProperties describes each OS upgrade on the Virtual Machine Scale
// Set.
type UpgradeOperationHistoricalStatusInfoProperties struct {
	// RunningStatus - READ-ONLY; Information about the overall status of the upgrade operation.
	RunningStatus *UpgradeOperationHistoryStatus `json:"runningStatus,omitempty"`
	// Progress - READ-ONLY; Counts of the VMs in each state.
	Progress *RollingUpgradeProgressInfo `json:"progress,omitempty"`
	// Error - READ-ONLY; Error Details for this upgrade if there are any.
	Error *APIError `json:"error,omitempty"`
	// StartedBy - READ-ONLY; Invoker of the Upgrade Operation. Possible values include: 'UpgradeOperationInvokerUnknown', 'UpgradeOperationInvokerUser', 'UpgradeOperationInvokerPlatform'
	StartedBy UpgradeOperationInvoker `json:"startedBy,omitempty"`
	// TargetImageReference - READ-ONLY; Image Reference details
	TargetImageReference *ImageReference `json:"targetImageReference,omitempty"`
	// RollbackInfo - READ-ONLY; Information about OS rollback if performed
	RollbackInfo *RollbackStatusInfo `json:"rollbackInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for UpgradeOperationHistoricalStatusInfoProperties.
func (uohsip UpgradeOperationHistoricalStatusInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UpgradeOperationHistoryStatus information about the current running state of the overall upgrade.
type UpgradeOperationHistoryStatus struct {
	// Code - READ-ONLY; Code indicating the current status of the upgrade. Possible values include: 'UpgradeStateRollingForward', 'UpgradeStateCancelled', 'UpgradeStateCompleted', 'UpgradeStateFaulted'
	Code UpgradeState `json:"code,omitempty"`
	// StartTime - READ-ONLY; Start time of the upgrade.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; End time of the upgrade.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// MarshalJSON is the custom marshaler for UpgradeOperationHistoryStatus.
func (uohs UpgradeOperationHistoryStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UpgradePolicy describes an upgrade policy - automatic, manual, or rolling.
type UpgradePolicy struct {
	// Mode - Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time. Possible values include: 'UpgradeModeAutomatic', 'UpgradeModeManual', 'UpgradeModeRolling'
	Mode UpgradeMode `json:"mode,omitempty"`
	// RollingUpgradePolicy - The configuration parameters used while performing a rolling upgrade.
	RollingUpgradePolicy *RollingUpgradePolicy `json:"rollingUpgradePolicy,omitempty"`
	// AutomaticOSUpgradePolicy - Configuration parameters used for performing automatic OS Upgrade.
	AutomaticOSUpgradePolicy *AutomaticOSUpgradePolicy `json:"automaticOSUpgradePolicy,omitempty"`
}

// Usage describes Compute Resource Usage.
type Usage struct {
	// Unit - An enum describing the unit of usage measurement.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - The current usage of the resource.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - The maximum permitted usage of the resource.
	Limit *int64 `json:"limit,omitempty"`
	// Name - The name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// UsageName the Usage Names.
type UsageName struct {
	// Value - The name of the resource.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - The localized name of the resource.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// UserArtifactManage ...
type UserArtifactManage struct {
	// Install - Required. The path and arguments to install the gallery application. This is limited to 4096 characters.
	Install *string `json:"install,omitempty"`
	// Remove - Required. The path and arguments to remove the gallery application. This is limited to 4096 characters.
	Remove *string `json:"remove,omitempty"`
	// Update - Optional. The path and arguments to update the gallery application. If not present, then update operation will invoke remove command on the previous version and install command on the current version of the gallery application. This is limited to 4096 characters.
	Update *string `json:"update,omitempty"`
}

// UserArtifactSource the source image from which the Image Version is going to be created.
type UserArtifactSource struct {
	// MediaLink - Required. The mediaLink of the artifact, must be a readable storage page blob.
	MediaLink *string `json:"mediaLink,omitempty"`
	// DefaultConfigurationLink - Optional. The defaultConfigurationLink of the artifact, must be a readable storage page blob.
	DefaultConfigurationLink *string `json:"defaultConfigurationLink,omitempty"`
}

// VaultCertificate describes a single certificate reference in a Key Vault, and where the certificate
// should reside on the VM.
type VaultCertificate struct {
	// CertificateURL - This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
	CertificateURL *string `json:"certificateUrl,omitempty"`
	// CertificateStore - For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem formatted.
	CertificateStore *string `json:"certificateStore,omitempty"`
}

// VaultSecretGroup describes a set of certificates which are all in the same Key Vault.
type VaultSecretGroup struct {
	// SourceVault - The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
	SourceVault *SubResource `json:"sourceVault,omitempty"`
	// VaultCertificates - The list of key vault references in SourceVault which contain certificates.
	VaultCertificates *[]VaultCertificate `json:"vaultCertificates,omitempty"`
}

// VirtualHardDisk describes the uri of a disk.
type VirtualHardDisk struct {
	// URI - Specifies the virtual hard disk's uri.
	URI *string `json:"uri,omitempty"`
}

// VirtualMachine describes a Virtual Machine.
type VirtualMachine struct {
	autorest.Response `json:"-"`
	// Plan - Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
	Plan                      *Plan `json:"plan,omitempty"`
	*VirtualMachineProperties `json:"properties,omitempty"`
	// Resources - READ-ONLY; The virtual machine child extension resources.
	Resources *[]VirtualMachineExtension `json:"resources,omitempty"`
	// Identity - The identity of the virtual machine, if configured.
	Identity *VirtualMachineIdentity `json:"identity,omitempty"`
	// Zones - The virtual machine zones.
	Zones *[]string `json:"zones,omitempty"`
	// ExtendedLocation - The extended location of the Virtual Machine.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualMachine.
func (VM VirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if VM.Plan != nil {
		objectMap["plan"] = VM.Plan
	}
	if VM.VirtualMachineProperties != nil {
		objectMap["properties"] = VM.VirtualMachineProperties
	}
	if VM.Identity != nil {
		objectMap["identity"] = VM.Identity
	}
	if VM.Zones != nil {
		objectMap["zones"] = VM.Zones
	}
	if VM.ExtendedLocation != nil {
		objectMap["extendedLocation"] = VM.ExtendedLocation
	}
	if VM.Location != nil {
		objectMap["location"] = VM.Location
	}
	if VM.Tags != nil {
		objectMap["tags"] = VM.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachine struct.
func (VM *VirtualMachine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "plan":
			if v != nil {
				var plan Plan
				err = json.Unmarshal(*v, &plan)
				if err != nil {
					return err
				}
				VM.Plan = &plan
			}
		case "properties":
			if v != nil {
				var virtualMachineProperties VirtualMachineProperties
				err = json.Unmarshal(*v, &virtualMachineProperties)
				if err != nil {
					return err
				}
				VM.VirtualMachineProperties = &virtualMachineProperties
			}
		case "resources":
			if v != nil {
				var resources []VirtualMachineExtension
				err = json.Unmarshal(*v, &resources)
				if err != nil {
					return err
				}
				VM.Resources = &resources
			}
		case "identity":
			if v != nil {
				var identity VirtualMachineIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				VM.Identity = &identity
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				VM.Zones = &zones
			}
		case "extendedLocation":
			if v != nil {
				var extendedLocation ExtendedLocation
				err = json.Unmarshal(*v, &extendedLocation)
				if err != nil {
					return err
				}
				VM.ExtendedLocation = &extendedLocation
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				VM.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				VM.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				VM.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				VM.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				VM.Tags = tags
			}
		}
	}

	return nil
}

// VirtualMachineAgentInstanceView the instance view of the VM Agent running on the virtual machine.
type VirtualMachineAgentInstanceView struct {
	// VMAgentVersion - The VM Agent full version.
	VMAgentVersion *string `json:"vmAgentVersion,omitempty"`
	// ExtensionHandlers - The virtual machine extension handler instance view.
	ExtensionHandlers *[]VirtualMachineExtensionHandlerInstanceView `json:"extensionHandlers,omitempty"`
	// Statuses - The resource status information.
	Statuses *[]InstanceViewStatus `json:"statuses,omitempty"`
}

// VirtualMachineAssessPatchesResult describes the properties of an AssessPatches result.
type VirtualMachineAssessPatchesResult struct {
	autorest.Response `json:"-"`
	// Status - READ-ONLY; The overall success or failure status of the operation. It remains "InProgress" until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded", or "CompletedWithWarnings.". Possible values include: 'PatchOperationStatusUnknown', 'PatchOperationStatusInProgress', 'PatchOperationStatusFailed', 'PatchOperationStatusSucceeded', 'PatchOperationStatusCompletedWithWarnings'
	Status PatchOperationStatus `json:"status,omitempty"`
	// AssessmentActivityID - READ-ONLY; The activity ID of the operation that produced this result. It is used to correlate across CRP and extension logs.
	AssessmentActivityID *string `json:"assessmentActivityId,omitempty"`
	// RebootPending - READ-ONLY; The overall reboot status of the VM. It will be true when partially installed patches require a reboot to complete installation but the reboot has not yet occurred.
	RebootPending *bool `json:"rebootPending,omitempty"`
	// CriticalAndSecurityPatchCount - READ-ONLY; The number of critical or security patches that have been detected as available and not yet installed.
	CriticalAndSecurityPatchCount *int32 `json:"criticalAndSecurityPatchCount,omitempty"`
	// OtherPatchCount - READ-ONLY; The number of all available patches excluding critical and security.
	OtherPatchCount *int32 `json:"otherPatchCount,omitempty"`
	// StartDateTime - READ-ONLY; The UTC timestamp when the operation began.
	StartDateTime *date.Time `json:"startDateTime,omitempty"`
	// AvailablePatches - READ-ONLY; The list of patches that have been detected as available for installation.
	AvailablePatches *[]VirtualMachineSoftwarePatchProperties `json:"availablePatches,omitempty"`
	// Error - READ-ONLY; The errors that were encountered during execution of the operation. The details array contains the list of them.
	Error *APIError `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineAssessPatchesResult.
func (vmapr VirtualMachineAssessPatchesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachineCaptureParameters capture Virtual Machine parameters.
type VirtualMachineCaptureParameters struct {
	// VhdPrefix - The captured virtual hard disk's name prefix.
	VhdPrefix *string `json:"vhdPrefix,omitempty"`
	// DestinationContainerName - The destination container name.
	DestinationContainerName *string `json:"destinationContainerName,omitempty"`
	// OverwriteVhds - Specifies whether to overwrite the destination virtual hard disk, in case of conflict.
	OverwriteVhds *bool `json:"overwriteVhds,omitempty"`
}

// VirtualMachineCaptureResult output of virtual machine capture operation.
type VirtualMachineCaptureResult struct {
	autorest.Response `json:"-"`
	// Schema - READ-ONLY; the schema of the captured virtual machine
	Schema *string `json:"$schema,omitempty"`
	// ContentVersion - READ-ONLY; the version of the content
	ContentVersion *string `json:"contentVersion,omitempty"`
	// Parameters - READ-ONLY; parameters of the captured virtual machine
	Parameters interface{} `json:"parameters,omitempty"`
	// Resources - READ-ONLY; a list of resource items of the captured virtual machine
	Resources *[]interface{} `json:"resources,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineCaptureResult.
func (vmcr VirtualMachineCaptureResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmcr.ID != nil {
		objectMap["id"] = vmcr.ID
	}
	return json.Marshal(objectMap)
}

// VirtualMachineExtension describes a Virtual Machine Extension.
type VirtualMachineExtension struct {
	autorest.Response                  `json:"-"`
	*VirtualMachineExtensionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualMachineExtension.
func (vme VirtualMachineExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vme.VirtualMachineExtensionProperties != nil {
		objectMap["properties"] = vme.VirtualMachineExtensionProperties
	}
	if vme.Location != nil {
		objectMap["location"] = vme.Location
	}
	if vme.Tags != nil {
		objectMap["tags"] = vme.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineExtension struct.
func (vme *VirtualMachineExtension) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualMachineExtensionProperties VirtualMachineExtensionProperties
				err = json.Unmarshal(*v, &virtualMachineExtensionProperties)
				if err != nil {
					return err
				}
				vme.VirtualMachineExtensionProperties = &virtualMachineExtensionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vme.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vme.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vme.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vme.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vme.Tags = tags
			}
		}
	}

	return nil
}

// VirtualMachineExtensionHandlerInstanceView the instance view of a virtual machine extension handler.
type VirtualMachineExtensionHandlerInstanceView struct {
	// Type - Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`
	// TypeHandlerVersion - Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
	// Status - The extension handler status.
	Status *InstanceViewStatus `json:"status,omitempty"`
}

// VirtualMachineExtensionImage describes a Virtual Machine Extension Image.
type VirtualMachineExtensionImage struct {
	autorest.Response                       `json:"-"`
	*VirtualMachineExtensionImageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualMachineExtensionImage.
func (vmei VirtualMachineExtensionImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmei.VirtualMachineExtensionImageProperties != nil {
		objectMap["properties"] = vmei.VirtualMachineExtensionImageProperties
	}
	if vmei.Location != nil {
		objectMap["location"] = vmei.Location
	}
	if vmei.Tags != nil {
		objectMap["tags"] = vmei.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineExtensionImage struct.
func (vmei *VirtualMachineExtensionImage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualMachineExtensionImageProperties VirtualMachineExtensionImageProperties
				err = json.Unmarshal(*v, &virtualMachineExtensionImageProperties)
				if err != nil {
					return err
				}
				vmei.VirtualMachineExtensionImageProperties = &virtualMachineExtensionImageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vmei.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmei.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vmei.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vmei.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vmei.Tags = tags
			}
		}
	}

	return nil
}

// VirtualMachineExtensionImageProperties describes the properties of a Virtual Machine Extension Image.
type VirtualMachineExtensionImageProperties struct {
	// OperatingSystem - The operating system this extension supports.
	OperatingSystem *string `json:"operatingSystem,omitempty"`
	// ComputeRole - The type of role (IaaS or PaaS) this extension supports.
	ComputeRole *string `json:"computeRole,omitempty"`
	// HandlerSchema - The schema defined by publisher, where extension consumers should provide settings in a matching schema.
	HandlerSchema *string `json:"handlerSchema,omitempty"`
	// VMScaleSetEnabled - Whether the extension can be used on xRP VMScaleSets. By default existing extensions are usable on scalesets, but there might be cases where a publisher wants to explicitly indicate the extension is only enabled for CRP VMs but not VMSS.
	VMScaleSetEnabled *bool `json:"vmScaleSetEnabled,omitempty"`
	// SupportsMultipleExtensions - Whether the handler can support multiple extensions.
	SupportsMultipleExtensions *bool `json:"supportsMultipleExtensions,omitempty"`
}

// VirtualMachineExtensionInstanceView the instance view of a virtual machine extension.
type VirtualMachineExtensionInstanceView struct {
	// Name - The virtual machine extension name.
	Name *string `json:"name,omitempty"`
	// Type - Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`
	// TypeHandlerVersion - Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
	// Substatuses - The resource status information.
	Substatuses *[]InstanceViewStatus `json:"substatuses,omitempty"`
	// Statuses - The resource status information.
	Statuses *[]InstanceViewStatus `json:"statuses,omitempty"`
}

// VirtualMachineExtensionProperties describes the properties of a Virtual Machine Extension.
type VirtualMachineExtensionProperties struct {
	// ForceUpdateTag - How the extension handler should be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`
	// Publisher - The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`
	// Type - Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`
	// TypeHandlerVersion - Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
	// AutoUpgradeMinorVersion - Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`
	// EnableAutomaticUpgrade - Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
	EnableAutomaticUpgrade *bool `json:"enableAutomaticUpgrade,omitempty"`
	// Settings - Json formatted public settings for the extension.
	Settings interface{} `json:"settings,omitempty"`
	// ProtectedSettings - The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// InstanceView - The virtual machine extension instance view.
	InstanceView *VirtualMachineExtensionInstanceView `json:"instanceView,omitempty"`
	// SuppressFailures - Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
	SuppressFailures *bool `json:"suppressFailures,omitempty"`
	// ProtectedSettingsFromKeyVault - The extensions protected settings that are passed by reference, and consumed from key vault
	ProtectedSettingsFromKeyVault interface{} `json:"protectedSettingsFromKeyVault,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineExtensionProperties.
func (vmep VirtualMachineExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmep.ForceUpdateTag != nil {
		objectMap["forceUpdateTag"] = vmep.ForceUpdateTag
	}
	if vmep.Publisher != nil {
		objectMap["publisher"] = vmep.Publisher
	}
	if vmep.Type != nil {
		objectMap["type"] = vmep.Type
	}
	if vmep.TypeHandlerVersion != nil {
		objectMap["typeHandlerVersion"] = vmep.TypeHandlerVersion
	}
	if vmep.AutoUpgradeMinorVersion != nil {
		objectMap["autoUpgradeMinorVersion"] = vmep.AutoUpgradeMinorVersion
	}
	if vmep.EnableAutomaticUpgrade != nil {
		objectMap["enableAutomaticUpgrade"] = vmep.EnableAutomaticUpgrade
	}
	if vmep.Settings != nil {
		objectMap["settings"] = vmep.Settings
	}
	if vmep.ProtectedSettings != nil {
		objectMap["protectedSettings"] = vmep.ProtectedSettings
	}
	if vmep.InstanceView != nil {
		objectMap["instanceView"] = vmep.InstanceView
	}
	if vmep.SuppressFailures != nil {
		objectMap["suppressFailures"] = vmep.SuppressFailures
	}
	if vmep.ProtectedSettingsFromKeyVault != nil {
		objectMap["protectedSettingsFromKeyVault"] = vmep.ProtectedSettingsFromKeyVault
	}
	return json.Marshal(objectMap)
}

// VirtualMachineExtensionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type VirtualMachineExtensionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineExtensionsClient) (VirtualMachineExtension, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineExtensionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineExtensionsCreateOrUpdateFuture.Result.
func (future *VirtualMachineExtensionsCreateOrUpdateFuture) result(client VirtualMachineExtensionsClient) (vme VirtualMachineExtension, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineExtensionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vme.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineExtensionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vme.Response.Response, err = future.GetResult(sender); err == nil && vme.Response.Response.StatusCode != http.StatusNoContent {
		vme, err = client.CreateOrUpdateResponder(vme.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachineExtensionsCreateOrUpdateFuture", "Result", vme.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineExtensionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineExtensionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineExtensionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineExtensionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineExtensionsDeleteFuture.Result.
func (future *VirtualMachineExtensionsDeleteFuture) result(client VirtualMachineExtensionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineExtensionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineExtensionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineExtensionsListResult the List Extension operation response
type VirtualMachineExtensionsListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of extensions
	Value *[]VirtualMachineExtension `json:"value,omitempty"`
}

// VirtualMachineExtensionsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineExtensionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineExtensionsClient) (VirtualMachineExtension, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineExtensionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineExtensionsUpdateFuture.Result.
func (future *VirtualMachineExtensionsUpdateFuture) result(client VirtualMachineExtensionsClient) (vme VirtualMachineExtension, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineExtensionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vme.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineExtensionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vme.Response.Response, err = future.GetResult(sender); err == nil && vme.Response.Response.StatusCode != http.StatusNoContent {
		vme, err = client.UpdateResponder(vme.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachineExtensionsUpdateFuture", "Result", vme.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineExtensionUpdate describes a Virtual Machine Extension.
type VirtualMachineExtensionUpdate struct {
	*VirtualMachineExtensionUpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualMachineExtensionUpdate.
func (vmeu VirtualMachineExtensionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmeu.VirtualMachineExtensionUpdateProperties != nil {
		objectMap["properties"] = vmeu.VirtualMachineExtensionUpdateProperties
	}
	if vmeu.Tags != nil {
		objectMap["tags"] = vmeu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineExtensionUpdate struct.
func (vmeu *VirtualMachineExtensionUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualMachineExtensionUpdateProperties VirtualMachineExtensionUpdateProperties
				err = json.Unmarshal(*v, &virtualMachineExtensionUpdateProperties)
				if err != nil {
					return err
				}
				vmeu.VirtualMachineExtensionUpdateProperties = &virtualMachineExtensionUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vmeu.Tags = tags
			}
		}
	}

	return nil
}

// VirtualMachineExtensionUpdateProperties describes the properties of a Virtual Machine Extension.
type VirtualMachineExtensionUpdateProperties struct {
	// ForceUpdateTag - How the extension handler should be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`
	// Publisher - The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`
	// Type - Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`
	// TypeHandlerVersion - Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
	// AutoUpgradeMinorVersion - Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`
	// EnableAutomaticUpgrade - Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
	EnableAutomaticUpgrade *bool `json:"enableAutomaticUpgrade,omitempty"`
	// Settings - Json formatted public settings for the extension.
	Settings interface{} `json:"settings,omitempty"`
	// ProtectedSettings - The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`
	// SuppressFailures - Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
	SuppressFailures *bool `json:"suppressFailures,omitempty"`
	// ProtectedSettingsFromKeyVault - The extensions protected settings that are passed by reference, and consumed from key vault
	ProtectedSettingsFromKeyVault interface{} `json:"protectedSettingsFromKeyVault,omitempty"`
}

// VirtualMachineHealthStatus the health status of the VM.
type VirtualMachineHealthStatus struct {
	// Status - READ-ONLY; The health status information for the VM.
	Status *InstanceViewStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineHealthStatus.
func (vmhs VirtualMachineHealthStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachineIdentity identity for the virtual machine.
type VirtualMachineIdentity struct {
	// PrincipalID - READ-ONLY; The principal id of virtual machine identity. This property will only be provided for a system assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id associated with the virtual machine. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of identity used for the virtual machine. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine. Possible values include: 'ResourceIdentityTypeSystemAssigned', 'ResourceIdentityTypeUserAssigned', 'ResourceIdentityTypeSystemAssignedUserAssigned', 'ResourceIdentityTypeNone'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the Virtual Machine. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*VirtualMachineIdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for VirtualMachineIdentity.
func (vmi VirtualMachineIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmi.Type != "" {
		objectMap["type"] = vmi.Type
	}
	if vmi.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = vmi.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// VirtualMachineIdentityUserAssignedIdentitiesValue ...
type VirtualMachineIdentityUserAssignedIdentitiesValue struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineIdentityUserAssignedIdentitiesValue.
func (vmiAiv VirtualMachineIdentityUserAssignedIdentitiesValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachineImage describes a Virtual Machine Image.
type VirtualMachineImage struct {
	autorest.Response              `json:"-"`
	*VirtualMachineImageProperties `json:"properties,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - The supported Azure location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Specifies the tags that are assigned to the virtual machine. For more information about using tags, see [Using tags to organize your Azure resources](https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md).
	Tags map[string]*string `json:"tags"`
	// ExtendedLocation - The extended location of the Virtual Machine.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineImage.
func (vmi VirtualMachineImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmi.VirtualMachineImageProperties != nil {
		objectMap["properties"] = vmi.VirtualMachineImageProperties
	}
	if vmi.Name != nil {
		objectMap["name"] = vmi.Name
	}
	if vmi.Location != nil {
		objectMap["location"] = vmi.Location
	}
	if vmi.Tags != nil {
		objectMap["tags"] = vmi.Tags
	}
	if vmi.ExtendedLocation != nil {
		objectMap["extendedLocation"] = vmi.ExtendedLocation
	}
	if vmi.ID != nil {
		objectMap["id"] = vmi.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineImage struct.
func (vmi *VirtualMachineImage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualMachineImageProperties VirtualMachineImageProperties
				err = json.Unmarshal(*v, &virtualMachineImageProperties)
				if err != nil {
					return err
				}
				vmi.VirtualMachineImageProperties = &virtualMachineImageProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmi.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vmi.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vmi.Tags = tags
			}
		case "extendedLocation":
			if v != nil {
				var extendedLocation ExtendedLocation
				err = json.Unmarshal(*v, &extendedLocation)
				if err != nil {
					return err
				}
				vmi.ExtendedLocation = &extendedLocation
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vmi.ID = &ID
			}
		}
	}

	return nil
}

// VirtualMachineImageFeature specifies additional capabilities supported by the image
type VirtualMachineImageFeature struct {
	// Name - The name of the feature.
	Name *string `json:"name,omitempty"`
	// Value - The corresponding value for the feature.
	Value *string `json:"value,omitempty"`
}

// VirtualMachineImageProperties describes the properties of a Virtual Machine Image.
type VirtualMachineImageProperties struct {
	Plan                         *PurchasePlan                 `json:"plan,omitempty"`
	OsDiskImage                  *OSDiskImage                  `json:"osDiskImage,omitempty"`
	DataDiskImages               *[]DataDiskImage              `json:"dataDiskImages,omitempty"`
	AutomaticOSUpgradeProperties *AutomaticOSUpgradeProperties `json:"automaticOSUpgradeProperties,omitempty"`
	// HyperVGeneration - Possible values include: 'HyperVGenerationTypesV1', 'HyperVGenerationTypesV2'
	HyperVGeneration HyperVGenerationTypes `json:"hyperVGeneration,omitempty"`
	// Disallowed - Specifies disallowed configuration for the VirtualMachine created from the image
	Disallowed *DisallowedConfiguration      `json:"disallowed,omitempty"`
	Features   *[]VirtualMachineImageFeature `json:"features,omitempty"`
}

// VirtualMachineImageResource virtual machine image resource information.
type VirtualMachineImageResource struct {
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - The supported Azure location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Specifies the tags that are assigned to the virtual machine. For more information about using tags, see [Using tags to organize your Azure resources](https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md).
	Tags map[string]*string `json:"tags"`
	// ExtendedLocation - The extended location of the Virtual Machine.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineImageResource.
func (vmir VirtualMachineImageResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmir.Name != nil {
		objectMap["name"] = vmir.Name
	}
	if vmir.Location != nil {
		objectMap["location"] = vmir.Location
	}
	if vmir.Tags != nil {
		objectMap["tags"] = vmir.Tags
	}
	if vmir.ExtendedLocation != nil {
		objectMap["extendedLocation"] = vmir.ExtendedLocation
	}
	if vmir.ID != nil {
		objectMap["id"] = vmir.ID
	}
	return json.Marshal(objectMap)
}

// VirtualMachineInstallPatchesParameters input for InstallPatches as directly received by the API
type VirtualMachineInstallPatchesParameters struct {
	// MaximumDuration - Specifies the maximum amount of time that the operation will run. It must be an ISO 8601-compliant duration string such as PT4H (4 hours)
	MaximumDuration *string `json:"maximumDuration,omitempty"`
	// RebootSetting - Defines when it is acceptable to reboot a VM during a software update operation. Possible values include: 'VMGuestPatchRebootSettingIfRequired', 'VMGuestPatchRebootSettingNever', 'VMGuestPatchRebootSettingAlways'
	RebootSetting VMGuestPatchRebootSetting `json:"rebootSetting,omitempty"`
	// WindowsParameters - Input for InstallPatches on a Windows VM, as directly received by the API
	WindowsParameters *WindowsParameters `json:"windowsParameters,omitempty"`
	// LinuxParameters - Input for InstallPatches on a Linux VM, as directly received by the API
	LinuxParameters *LinuxParameters `json:"linuxParameters,omitempty"`
}

// VirtualMachineInstallPatchesResult the result summary of an installation operation.
type VirtualMachineInstallPatchesResult struct {
	autorest.Response `json:"-"`
	// Status - READ-ONLY; The overall success or failure status of the operation. It remains "InProgress" until the operation completes. At that point it will become "Failed", "Succeeded", "Unknown" or "CompletedWithWarnings.". Possible values include: 'PatchOperationStatusUnknown', 'PatchOperationStatusInProgress', 'PatchOperationStatusFailed', 'PatchOperationStatusSucceeded', 'PatchOperationStatusCompletedWithWarnings'
	Status PatchOperationStatus `json:"status,omitempty"`
	// InstallationActivityID - READ-ONLY; The activity ID of the operation that produced this result. It is used to correlate across CRP and extension logs.
	InstallationActivityID *string `json:"installationActivityId,omitempty"`
	// RebootStatus - READ-ONLY; The reboot state of the VM following completion of the operation. Possible values include: 'VMGuestPatchRebootStatusUnknown', 'VMGuestPatchRebootStatusNotNeeded', 'VMGuestPatchRebootStatusRequired', 'VMGuestPatchRebootStatusStarted', 'VMGuestPatchRebootStatusFailed', 'VMGuestPatchRebootStatusCompleted'
	RebootStatus VMGuestPatchRebootStatus `json:"rebootStatus,omitempty"`
	// MaintenanceWindowExceeded - READ-ONLY; Whether the operation ran out of time before it completed all its intended actions.
	MaintenanceWindowExceeded *bool `json:"maintenanceWindowExceeded,omitempty"`
	// ExcludedPatchCount - READ-ONLY; The number of patches that were not installed due to the user blocking their installation.
	ExcludedPatchCount *int32 `json:"excludedPatchCount,omitempty"`
	// NotSelectedPatchCount - READ-ONLY; The number of patches that were detected as available for install, but did not meet the operation's criteria.
	NotSelectedPatchCount *int32 `json:"notSelectedPatchCount,omitempty"`
	// PendingPatchCount - READ-ONLY; The number of patches that were identified as meeting the installation criteria, but were not able to be installed. Typically this happens when maintenanceWindowExceeded == true.
	PendingPatchCount *int32 `json:"pendingPatchCount,omitempty"`
	// InstalledPatchCount - READ-ONLY; The number of patches successfully installed.
	InstalledPatchCount *int32 `json:"installedPatchCount,omitempty"`
	// FailedPatchCount - READ-ONLY; The number of patches that could not be installed due to some issue. See errors for details.
	FailedPatchCount *int32 `json:"failedPatchCount,omitempty"`
	// Patches - READ-ONLY; The patches that were installed during the operation.
	Patches *[]PatchInstallationDetail `json:"patches,omitempty"`
	// StartDateTime - READ-ONLY; The UTC timestamp when the operation began.
	StartDateTime *date.Time `json:"startDateTime,omitempty"`
	// Error - READ-ONLY; The errors that were encountered during execution of the operation. The details array contains the list of them.
	Error *APIError `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineInstallPatchesResult.
func (vmipr VirtualMachineInstallPatchesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachineInstanceView the instance view of a virtual machine.
type VirtualMachineInstanceView struct {
	autorest.Response `json:"-"`
	// PlatformUpdateDomain - Specifies the update domain of the virtual machine.
	PlatformUpdateDomain *int32 `json:"platformUpdateDomain,omitempty"`
	// PlatformFaultDomain - Specifies the fault domain of the virtual machine.
	PlatformFaultDomain *int32 `json:"platformFaultDomain,omitempty"`
	// ComputerName - The computer name assigned to the virtual machine.
	ComputerName *string `json:"computerName,omitempty"`
	// OsName - The Operating System running on the virtual machine.
	OsName *string `json:"osName,omitempty"`
	// OsVersion - The version of Operating System running on the virtual machine.
	OsVersion *string `json:"osVersion,omitempty"`
	// HyperVGeneration - Specifies the HyperVGeneration Type associated with a resource. Possible values include: 'HyperVGenerationTypeV1', 'HyperVGenerationTypeV2'
	HyperVGeneration HyperVGenerationType `json:"hyperVGeneration,omitempty"`
	// RdpThumbPrint - The Remote desktop certificate thumbprint.
	RdpThumbPrint *string `json:"rdpThumbPrint,omitempty"`
	// VMAgent - The VM Agent running on the virtual machine.
	VMAgent *VirtualMachineAgentInstanceView `json:"vmAgent,omitempty"`
	// MaintenanceRedeployStatus - The Maintenance Operation status on the virtual machine.
	MaintenanceRedeployStatus *MaintenanceRedeployStatus `json:"maintenanceRedeployStatus,omitempty"`
	// Disks - The virtual machine disk information.
	Disks *[]DiskInstanceView `json:"disks,omitempty"`
	// Extensions - The extensions information.
	Extensions *[]VirtualMachineExtensionInstanceView `json:"extensions,omitempty"`
	// VMHealth - READ-ONLY; The health status for the VM.
	VMHealth *VirtualMachineHealthStatus `json:"vmHealth,omitempty"`
	// BootDiagnostics - Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
	BootDiagnostics *BootDiagnosticsInstanceView `json:"bootDiagnostics,omitempty"`
	// AssignedHost - READ-ONLY; Resource id of the dedicated host, on which the virtual machine is allocated through automatic placement, when the virtual machine is associated with a dedicated host group that has automatic placement enabled. <br><br>Minimum api-version: 2020-06-01.
	AssignedHost *string `json:"assignedHost,omitempty"`
	// Statuses - The resource status information.
	Statuses *[]InstanceViewStatus `json:"statuses,omitempty"`
	// PatchStatus - [Preview Feature] The status of virtual machine patch operations.
	PatchStatus *VirtualMachinePatchStatus `json:"patchStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineInstanceView.
func (vmiv VirtualMachineInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmiv.PlatformUpdateDomain != nil {
		objectMap["platformUpdateDomain"] = vmiv.PlatformUpdateDomain
	}
	if vmiv.PlatformFaultDomain != nil {
		objectMap["platformFaultDomain"] = vmiv.PlatformFaultDomain
	}
	if vmiv.ComputerName != nil {
		objectMap["computerName"] = vmiv.ComputerName
	}
	if vmiv.OsName != nil {
		objectMap["osName"] = vmiv.OsName
	}
	if vmiv.OsVersion != nil {
		objectMap["osVersion"] = vmiv.OsVersion
	}
	if vmiv.HyperVGeneration != "" {
		objectMap["hyperVGeneration"] = vmiv.HyperVGeneration
	}
	if vmiv.RdpThumbPrint != nil {
		objectMap["rdpThumbPrint"] = vmiv.RdpThumbPrint
	}
	if vmiv.VMAgent != nil {
		objectMap["vmAgent"] = vmiv.VMAgent
	}
	if vmiv.MaintenanceRedeployStatus != nil {
		objectMap["maintenanceRedeployStatus"] = vmiv.MaintenanceRedeployStatus
	}
	if vmiv.Disks != nil {
		objectMap["disks"] = vmiv.Disks
	}
	if vmiv.Extensions != nil {
		objectMap["extensions"] = vmiv.Extensions
	}
	if vmiv.BootDiagnostics != nil {
		objectMap["bootDiagnostics"] = vmiv.BootDiagnostics
	}
	if vmiv.Statuses != nil {
		objectMap["statuses"] = vmiv.Statuses
	}
	if vmiv.PatchStatus != nil {
		objectMap["patchStatus"] = vmiv.PatchStatus
	}
	return json.Marshal(objectMap)
}

// VirtualMachineIPTag contains the IP tag associated with the public IP address.
type VirtualMachineIPTag struct {
	// IPTagType - IP tag type. Example: FirstPartyUsage.
	IPTagType *string `json:"ipTagType,omitempty"`
	// Tag - IP tag associated with the public IP. Example: SQL, Storage etc.
	Tag *string `json:"tag,omitempty"`
}

// VirtualMachineListResult the List Virtual Machine operation response.
type VirtualMachineListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of virtual machines.
	Value *[]VirtualMachine `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of VMs. Call ListNext() with this URI to fetch the next page of Virtual Machines.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineListResultIterator provides access to a complete listing of VirtualMachine values.
type VirtualMachineListResultIterator struct {
	i    int
	page VirtualMachineListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualMachineListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualMachineListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualMachineListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualMachineListResultIterator) Response() VirtualMachineListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualMachineListResultIterator) Value() VirtualMachine {
	if !iter.page.NotDone() {
		return VirtualMachine{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualMachineListResultIterator type.
func NewVirtualMachineListResultIterator(page VirtualMachineListResultPage) VirtualMachineListResultIterator {
	return VirtualMachineListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vmlr VirtualMachineListResult) IsEmpty() bool {
	return vmlr.Value == nil || len(*vmlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vmlr VirtualMachineListResult) hasNextLink() bool {
	return vmlr.NextLink != nil && len(*vmlr.NextLink) != 0
}

// virtualMachineListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vmlr VirtualMachineListResult) virtualMachineListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vmlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vmlr.NextLink)))
}

// VirtualMachineListResultPage contains a page of VirtualMachine values.
type VirtualMachineListResultPage struct {
	fn   func(context.Context, VirtualMachineListResult) (VirtualMachineListResult, error)
	vmlr VirtualMachineListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualMachineListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vmlr)
		if err != nil {
			return err
		}
		page.vmlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualMachineListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualMachineListResultPage) NotDone() bool {
	return !page.vmlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualMachineListResultPage) Response() VirtualMachineListResult {
	return page.vmlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualMachineListResultPage) Values() []VirtualMachine {
	if page.vmlr.IsEmpty() {
		return nil
	}
	return *page.vmlr.Value
}

// Creates a new instance of the VirtualMachineListResultPage type.
func NewVirtualMachineListResultPage(cur VirtualMachineListResult, getNextPage func(context.Context, VirtualMachineListResult) (VirtualMachineListResult, error)) VirtualMachineListResultPage {
	return VirtualMachineListResultPage{
		fn:   getNextPage,
		vmlr: cur,
	}
}

// VirtualMachineNetworkInterfaceConfiguration describes a virtual machine network interface
// configurations.
type VirtualMachineNetworkInterfaceConfiguration struct {
	// Name - The network interface configuration name.
	Name                                                   *string `json:"name,omitempty"`
	*VirtualMachineNetworkInterfaceConfigurationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineNetworkInterfaceConfiguration.
func (vmnic VirtualMachineNetworkInterfaceConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmnic.Name != nil {
		objectMap["name"] = vmnic.Name
	}
	if vmnic.VirtualMachineNetworkInterfaceConfigurationProperties != nil {
		objectMap["properties"] = vmnic.VirtualMachineNetworkInterfaceConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineNetworkInterfaceConfiguration struct.
func (vmnic *VirtualMachineNetworkInterfaceConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmnic.Name = &name
			}
		case "properties":
			if v != nil {
				var virtualMachineNetworkInterfaceConfigurationProperties VirtualMachineNetworkInterfaceConfigurationProperties
				err = json.Unmarshal(*v, &virtualMachineNetworkInterfaceConfigurationProperties)
				if err != nil {
					return err
				}
				vmnic.VirtualMachineNetworkInterfaceConfigurationProperties = &virtualMachineNetworkInterfaceConfigurationProperties
			}
		}
	}

	return nil
}

// VirtualMachineNetworkInterfaceConfigurationProperties describes a virtual machine network profile's IP
// configuration.
type VirtualMachineNetworkInterfaceConfigurationProperties struct {
	// Primary - Specifies the primary network interface in case the virtual machine has more than 1 network interface.
	Primary *bool `json:"primary,omitempty"`
	// DeleteOption - Specify what happens to the network interface when the VM is deleted. Possible values include: 'DeleteOptionsDelete', 'DeleteOptionsDetach'
	DeleteOption DeleteOptions `json:"deleteOption,omitempty"`
	// EnableAcceleratedNetworking - Specifies whether the network interface is accelerated networking-enabled.
	EnableAcceleratedNetworking *bool `json:"enableAcceleratedNetworking,omitempty"`
	// EnableFpga - Specifies whether the network interface is FPGA networking-enabled.
	EnableFpga *bool `json:"enableFpga,omitempty"`
	// EnableIPForwarding - Whether IP forwarding enabled on this NIC.
	EnableIPForwarding *bool `json:"enableIPForwarding,omitempty"`
	// NetworkSecurityGroup - The network security group.
	NetworkSecurityGroup *SubResource `json:"networkSecurityGroup,omitempty"`
	// DNSSettings - The dns settings to be applied on the network interfaces.
	DNSSettings *VirtualMachineNetworkInterfaceDNSSettingsConfiguration `json:"dnsSettings,omitempty"`
	// IPConfigurations - Specifies the IP configurations of the network interface.
	IPConfigurations  *[]VirtualMachineNetworkInterfaceIPConfiguration `json:"ipConfigurations,omitempty"`
	DscpConfiguration *SubResource                                     `json:"dscpConfiguration,omitempty"`
}

// VirtualMachineNetworkInterfaceDNSSettingsConfiguration describes a virtual machines network
// configuration's DNS settings.
type VirtualMachineNetworkInterfaceDNSSettingsConfiguration struct {
	// DNSServers - List of DNS servers IP addresses
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// VirtualMachineNetworkInterfaceIPConfiguration describes a virtual machine network profile's IP
// configuration.
type VirtualMachineNetworkInterfaceIPConfiguration struct {
	// Name - The IP configuration name.
	Name                                                     *string `json:"name,omitempty"`
	*VirtualMachineNetworkInterfaceIPConfigurationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineNetworkInterfaceIPConfiguration.
func (vmniic VirtualMachineNetworkInterfaceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmniic.Name != nil {
		objectMap["name"] = vmniic.Name
	}
	if vmniic.VirtualMachineNetworkInterfaceIPConfigurationProperties != nil {
		objectMap["properties"] = vmniic.VirtualMachineNetworkInterfaceIPConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineNetworkInterfaceIPConfiguration struct.
func (vmniic *VirtualMachineNetworkInterfaceIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmniic.Name = &name
			}
		case "properties":
			if v != nil {
				var virtualMachineNetworkInterfaceIPConfigurationProperties VirtualMachineNetworkInterfaceIPConfigurationProperties
				err = json.Unmarshal(*v, &virtualMachineNetworkInterfaceIPConfigurationProperties)
				if err != nil {
					return err
				}
				vmniic.VirtualMachineNetworkInterfaceIPConfigurationProperties = &virtualMachineNetworkInterfaceIPConfigurationProperties
			}
		}
	}

	return nil
}

// VirtualMachineNetworkInterfaceIPConfigurationProperties describes a virtual machine network interface IP
// configuration properties.
type VirtualMachineNetworkInterfaceIPConfigurationProperties struct {
	// Subnet - Specifies the identifier of the subnet.
	Subnet *SubResource `json:"subnet,omitempty"`
	// Primary - Specifies the primary network interface in case the virtual machine has more than 1 network interface.
	Primary *bool `json:"primary,omitempty"`
	// PublicIPAddressConfiguration - The publicIPAddressConfiguration.
	PublicIPAddressConfiguration *VirtualMachinePublicIPAddressConfiguration `json:"publicIPAddressConfiguration,omitempty"`
	// PrivateIPAddressVersion - Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'. Possible values include: 'IPVersionsIPv4', 'IPVersionsIPv6'
	PrivateIPAddressVersion IPVersions `json:"privateIPAddressVersion,omitempty"`
	// ApplicationSecurityGroups - Specifies an array of references to application security group.
	ApplicationSecurityGroups *[]SubResource `json:"applicationSecurityGroups,omitempty"`
	// ApplicationGatewayBackendAddressPools - Specifies an array of references to backend address pools of application gateways. A virtual machine can reference backend address pools of multiple application gateways. Multiple virtual machines cannot use the same application gateway.
	ApplicationGatewayBackendAddressPools *[]SubResource `json:"applicationGatewayBackendAddressPools,omitempty"`
	// LoadBalancerBackendAddressPools - Specifies an array of references to backend address pools of load balancers. A virtual machine can reference backend address pools of one public and one internal load balancer. [Multiple virtual machines cannot use the same basic sku load balancer].
	LoadBalancerBackendAddressPools *[]SubResource `json:"loadBalancerBackendAddressPools,omitempty"`
}

// VirtualMachinePatchStatus the status of virtual machine patch operations.
type VirtualMachinePatchStatus struct {
	// AvailablePatchSummary - The available patch summary of the latest assessment operation for the virtual machine.
	AvailablePatchSummary *AvailablePatchSummary `json:"availablePatchSummary,omitempty"`
	// LastPatchInstallationSummary - The installation summary of the latest installation operation for the virtual machine.
	LastPatchInstallationSummary *LastPatchInstallationSummary `json:"lastPatchInstallationSummary,omitempty"`
	// ConfigurationStatuses - READ-ONLY; The enablement status of the specified patchMode
	ConfigurationStatuses *[]InstanceViewStatus `json:"configurationStatuses,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachinePatchStatus.
func (vmps VirtualMachinePatchStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmps.AvailablePatchSummary != nil {
		objectMap["availablePatchSummary"] = vmps.AvailablePatchSummary
	}
	if vmps.LastPatchInstallationSummary != nil {
		objectMap["lastPatchInstallationSummary"] = vmps.LastPatchInstallationSummary
	}
	return json.Marshal(objectMap)
}

// VirtualMachineProperties describes the properties of a Virtual Machine.
type VirtualMachineProperties struct {
	// HardwareProfile - Specifies the hardware settings for the virtual machine.
	HardwareProfile *HardwareProfile `json:"hardwareProfile,omitempty"`
	// StorageProfile - Specifies the storage settings for the virtual machine disks.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// AdditionalCapabilities - Specifies additional capabilities enabled or disabled on the virtual machine.
	AdditionalCapabilities *AdditionalCapabilities `json:"additionalCapabilities,omitempty"`
	// OsProfile - Specifies the operating system settings used while creating the virtual machine. Some of the settings cannot be changed once VM is provisioned.
	OsProfile *OSProfile `json:"osProfile,omitempty"`
	// NetworkProfile - Specifies the network interfaces of the virtual machine.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`
	// SecurityProfile - Specifies the Security related profile settings for the virtual machine.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`
	// DiagnosticsProfile - Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
	DiagnosticsProfile *DiagnosticsProfile `json:"diagnosticsProfile,omitempty"`
	// AvailabilitySet - Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs.microsoft.com/azure/virtual-machines/availability-set-overview). <br><br> For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates) <br><br> Currently, a VM can only be added to availability set at creation time. The availability set to which the VM is being added should be under the same resource group as the availability set resource. An existing VM cannot be added to an availability set. <br><br>This property cannot exist along with a non-null properties.virtualMachineScaleSet reference.
	AvailabilitySet *SubResource `json:"availabilitySet,omitempty"`
	// VirtualMachineScaleSet - Specifies information about the virtual machine scale set that the virtual machine should be assigned to. Virtual machines specified in the same virtual machine scale set are allocated to different nodes to maximize availability. Currently, a VM can only be added to virtual machine scale set at creation time. An existing VM cannot be added to a virtual machine scale set. <br><br>This property cannot exist along with a non-null properties.availabilitySet reference. <br><br>Minimum api‐version: 2019‐03‐01
	VirtualMachineScaleSet *SubResource `json:"virtualMachineScaleSet,omitempty"`
	// ProximityPlacementGroup - Specifies information about the proximity placement group that the virtual machine should be assigned to. <br><br>Minimum api-version: 2018-04-01.
	ProximityPlacementGroup *SubResource `json:"proximityPlacementGroup,omitempty"`
	// Priority - Specifies the priority for the virtual machine. <br><br>Minimum api-version: 2019-03-01. Possible values include: 'VirtualMachinePriorityTypesRegular', 'VirtualMachinePriorityTypesLow', 'VirtualMachinePriorityTypesSpot'
	Priority VirtualMachinePriorityTypes `json:"priority,omitempty"`
	// EvictionPolicy - Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. <br><br>For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. <br><br>For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview. Possible values include: 'VirtualMachineEvictionPolicyTypesDeallocate', 'VirtualMachineEvictionPolicyTypesDelete'
	EvictionPolicy VirtualMachineEvictionPolicyTypes `json:"evictionPolicy,omitempty"`
	// BillingProfile - Specifies the billing related details of a Azure Spot virtual machine. <br><br>Minimum api-version: 2019-03-01.
	BillingProfile *BillingProfile `json:"billingProfile,omitempty"`
	// Host - Specifies information about the dedicated host that the virtual machine resides in. <br><br>Minimum api-version: 2018-10-01.
	Host *SubResource `json:"host,omitempty"`
	// HostGroup - Specifies information about the dedicated host group that the virtual machine resides in. <br><br>Minimum api-version: 2020-06-01. <br><br>NOTE: User cannot specify both host and hostGroup properties.
	HostGroup *SubResource `json:"hostGroup,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// InstanceView - READ-ONLY; The virtual machine instance view.
	InstanceView *VirtualMachineInstanceView `json:"instanceView,omitempty"`
	// LicenseType - Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
	LicenseType *string `json:"licenseType,omitempty"`
	// VMID - READ-ONLY; Specifies the VM unique ID which is a 128-bits identifier that is encoded and stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
	VMID *string `json:"vmId,omitempty"`
	// ExtensionsTimeBudget - Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). <br><br> Minimum api-version: 2020-06-01
	ExtensionsTimeBudget *string `json:"extensionsTimeBudget,omitempty"`
	// PlatformFaultDomain - Specifies the scale set logical fault domain into which the Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned to a fault domain that best maintains balance across available fault domains.<br><li>This is applicable only if the 'virtualMachineScaleSet' property of this Virtual Machine is set.<li>The Virtual Machine Scale Set that is referenced, must have 'platformFaultDomainCount' &gt; 1.<li>This property cannot be updated once the Virtual Machine is created.<li>Fault domain assignment can be viewed in the Virtual Machine Instance View.<br><br>Minimum api‐version: 2020‐12‐01
	PlatformFaultDomain *int32 `json:"platformFaultDomain,omitempty"`
	// ScheduledEventsProfile - Specifies Scheduled Event related configurations.
	ScheduledEventsProfile *ScheduledEventsProfile `json:"scheduledEventsProfile,omitempty"`
	// UserData - UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here. <br><br>Minimum api-version: 2021-03-01
	UserData *string `json:"userData,omitempty"`
	// CapacityReservation - Specifies information about the capacity reservation that is used to allocate virtual machine. <br><br>Minimum api-version: 2021-04-01.
	CapacityReservation *CapacityReservationProfile `json:"capacityReservation,omitempty"`
	// ApplicationProfile - Specifies the gallery applications that should be made available to the VM/VMSS
	ApplicationProfile *ApplicationProfile `json:"applicationProfile,omitempty"`
	// TimeCreated - READ-ONLY; Specifies the time at which the Virtual Machine resource was created.<br><br>Minimum api-version: 2021-11-01.
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineProperties.
func (vmp VirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmp.HardwareProfile != nil {
		objectMap["hardwareProfile"] = vmp.HardwareProfile
	}
	if vmp.StorageProfile != nil {
		objectMap["storageProfile"] = vmp.StorageProfile
	}
	if vmp.AdditionalCapabilities != nil {
		objectMap["additionalCapabilities"] = vmp.AdditionalCapabilities
	}
	if vmp.OsProfile != nil {
		objectMap["osProfile"] = vmp.OsProfile
	}
	if vmp.NetworkProfile != nil {
		objectMap["networkProfile"] = vmp.NetworkProfile
	}
	if vmp.SecurityProfile != nil {
		objectMap["securityProfile"] = vmp.SecurityProfile
	}
	if vmp.DiagnosticsProfile != nil {
		objectMap["diagnosticsProfile"] = vmp.DiagnosticsProfile
	}
	if vmp.AvailabilitySet != nil {
		objectMap["availabilitySet"] = vmp.AvailabilitySet
	}
	if vmp.VirtualMachineScaleSet != nil {
		objectMap["virtualMachineScaleSet"] = vmp.VirtualMachineScaleSet
	}
	if vmp.ProximityPlacementGroup != nil {
		objectMap["proximityPlacementGroup"] = vmp.ProximityPlacementGroup
	}
	if vmp.Priority != "" {
		objectMap["priority"] = vmp.Priority
	}
	if vmp.EvictionPolicy != "" {
		objectMap["evictionPolicy"] = vmp.EvictionPolicy
	}
	if vmp.BillingProfile != nil {
		objectMap["billingProfile"] = vmp.BillingProfile
	}
	if vmp.Host != nil {
		objectMap["host"] = vmp.Host
	}
	if vmp.HostGroup != nil {
		objectMap["hostGroup"] = vmp.HostGroup
	}
	if vmp.LicenseType != nil {
		objectMap["licenseType"] = vmp.LicenseType
	}
	if vmp.ExtensionsTimeBudget != nil {
		objectMap["extensionsTimeBudget"] = vmp.ExtensionsTimeBudget
	}
	if vmp.PlatformFaultDomain != nil {
		objectMap["platformFaultDomain"] = vmp.PlatformFaultDomain
	}
	if vmp.ScheduledEventsProfile != nil {
		objectMap["scheduledEventsProfile"] = vmp.ScheduledEventsProfile
	}
	if vmp.UserData != nil {
		objectMap["userData"] = vmp.UserData
	}
	if vmp.CapacityReservation != nil {
		objectMap["capacityReservation"] = vmp.CapacityReservation
	}
	if vmp.ApplicationProfile != nil {
		objectMap["applicationProfile"] = vmp.ApplicationProfile
	}
	return json.Marshal(objectMap)
}

// VirtualMachinePublicIPAddressConfiguration describes a virtual machines IP Configuration's
// PublicIPAddress configuration
type VirtualMachinePublicIPAddressConfiguration struct {
	// Name - The publicIP address configuration name.
	Name                                                  *string `json:"name,omitempty"`
	*VirtualMachinePublicIPAddressConfigurationProperties `json:"properties,omitempty"`
	Sku                                                   *PublicIPAddressSku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachinePublicIPAddressConfiguration.
func (vmpiac VirtualMachinePublicIPAddressConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmpiac.Name != nil {
		objectMap["name"] = vmpiac.Name
	}
	if vmpiac.VirtualMachinePublicIPAddressConfigurationProperties != nil {
		objectMap["properties"] = vmpiac.VirtualMachinePublicIPAddressConfigurationProperties
	}
	if vmpiac.Sku != nil {
		objectMap["sku"] = vmpiac.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachinePublicIPAddressConfiguration struct.
func (vmpiac *VirtualMachinePublicIPAddressConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmpiac.Name = &name
			}
		case "properties":
			if v != nil {
				var virtualMachinePublicIPAddressConfigurationProperties VirtualMachinePublicIPAddressConfigurationProperties
				err = json.Unmarshal(*v, &virtualMachinePublicIPAddressConfigurationProperties)
				if err != nil {
					return err
				}
				vmpiac.VirtualMachinePublicIPAddressConfigurationProperties = &virtualMachinePublicIPAddressConfigurationProperties
			}
		case "sku":
			if v != nil {
				var sku PublicIPAddressSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				vmpiac.Sku = &sku
			}
		}
	}

	return nil
}

// VirtualMachinePublicIPAddressConfigurationProperties describes a virtual machines IP Configuration's
// PublicIPAddress configuration
type VirtualMachinePublicIPAddressConfigurationProperties struct {
	// IdleTimeoutInMinutes - The idle timeout of the public IP address.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// DeleteOption - Specify what happens to the public IP address when the VM is deleted. Possible values include: 'DeleteOptionsDelete', 'DeleteOptionsDetach'
	DeleteOption DeleteOptions `json:"deleteOption,omitempty"`
	// DNSSettings - The dns settings to be applied on the publicIP addresses .
	DNSSettings *VirtualMachinePublicIPAddressDNSSettingsConfiguration `json:"dnsSettings,omitempty"`
	// IPTags - The list of IP tags associated with the public IP address.
	IPTags *[]VirtualMachineIPTag `json:"ipTags,omitempty"`
	// PublicIPPrefix - The PublicIPPrefix from which to allocate publicIP addresses.
	PublicIPPrefix *SubResource `json:"publicIPPrefix,omitempty"`
	// PublicIPAddressVersion - Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'. Possible values include: 'IPVersionsIPv4', 'IPVersionsIPv6'
	PublicIPAddressVersion IPVersions `json:"publicIPAddressVersion,omitempty"`
	// PublicIPAllocationMethod - Specify the public IP allocation type. Possible values include: 'PublicIPAllocationMethodDynamic', 'PublicIPAllocationMethodStatic'
	PublicIPAllocationMethod PublicIPAllocationMethod `json:"publicIPAllocationMethod,omitempty"`
}

// VirtualMachinePublicIPAddressDNSSettingsConfiguration describes a virtual machines network
// configuration's DNS settings.
type VirtualMachinePublicIPAddressDNSSettingsConfiguration struct {
	// DomainNameLabel - The Domain name label prefix of the PublicIPAddress resources that will be created. The generated name label is the concatenation of the domain name label and vm network profile unique ID.
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`
}

// VirtualMachineReimageParameters parameters for Reimaging Virtual Machine. NOTE: Virtual Machine OS disk
// will always be reimaged
type VirtualMachineReimageParameters struct {
	// TempDisk - Specifies whether to reimage temp disk. Default value: false. Note: This temp disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
	TempDisk *bool `json:"tempDisk,omitempty"`
}

// VirtualMachineRunCommand describes a Virtual Machine run command.
type VirtualMachineRunCommand struct {
	autorest.Response                   `json:"-"`
	*VirtualMachineRunCommandProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualMachineRunCommand.
func (vmrc VirtualMachineRunCommand) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmrc.VirtualMachineRunCommandProperties != nil {
		objectMap["properties"] = vmrc.VirtualMachineRunCommandProperties
	}
	if vmrc.Location != nil {
		objectMap["location"] = vmrc.Location
	}
	if vmrc.Tags != nil {
		objectMap["tags"] = vmrc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineRunCommand struct.
func (vmrc *VirtualMachineRunCommand) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualMachineRunCommandProperties VirtualMachineRunCommandProperties
				err = json.Unmarshal(*v, &virtualMachineRunCommandProperties)
				if err != nil {
					return err
				}
				vmrc.VirtualMachineRunCommandProperties = &virtualMachineRunCommandProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vmrc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmrc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vmrc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vmrc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vmrc.Tags = tags
			}
		}
	}

	return nil
}

// VirtualMachineRunCommandInstanceView the instance view of a virtual machine run command.
type VirtualMachineRunCommandInstanceView struct {
	// ExecutionState - Script execution status. Possible values include: 'ExecutionStateUnknown', 'ExecutionStatePending', 'ExecutionStateRunning', 'ExecutionStateFailed', 'ExecutionStateSucceeded', 'ExecutionStateTimedOut', 'ExecutionStateCanceled'
	ExecutionState ExecutionState `json:"executionState,omitempty"`
	// ExecutionMessage - Communicate script configuration errors or execution messages.
	ExecutionMessage *string `json:"executionMessage,omitempty"`
	// ExitCode - Exit code returned from script execution.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// Output - Script output stream.
	Output *string `json:"output,omitempty"`
	// Error - Script error stream.
	Error *string `json:"error,omitempty"`
	// StartTime - Script start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Script end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Statuses - The resource status information.
	Statuses *[]InstanceViewStatus `json:"statuses,omitempty"`
}

// VirtualMachineRunCommandProperties describes the properties of a Virtual Machine run command.
type VirtualMachineRunCommandProperties struct {
	// Source - The source of the run command script.
	Source *VirtualMachineRunCommandScriptSource `json:"source,omitempty"`
	// Parameters - The parameters used by the script.
	Parameters *[]RunCommandInputParameter `json:"parameters,omitempty"`
	// ProtectedParameters - The parameters used by the script.
	ProtectedParameters *[]RunCommandInputParameter `json:"protectedParameters,omitempty"`
	// AsyncExecution - Optional. If set to true, provisioning will complete as soon as the script starts and will not wait for script to complete.
	AsyncExecution *bool `json:"asyncExecution,omitempty"`
	// RunAsUser - Specifies the user account on the VM when executing the run command.
	RunAsUser *string `json:"runAsUser,omitempty"`
	// RunAsPassword - Specifies the user account password on the VM when executing the run command.
	RunAsPassword *string `json:"runAsPassword,omitempty"`
	// TimeoutInSeconds - The timeout in seconds to execute the run command.
	TimeoutInSeconds *int32 `json:"timeoutInSeconds,omitempty"`
	// OutputBlobURI - Specifies the Azure storage blob where script output stream will be uploaded.
	OutputBlobURI *string `json:"outputBlobUri,omitempty"`
	// ErrorBlobURI - Specifies the Azure storage blob where script error stream will be uploaded.
	ErrorBlobURI *string `json:"errorBlobUri,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// InstanceView - READ-ONLY; The virtual machine run command instance view.
	InstanceView *VirtualMachineRunCommandInstanceView `json:"instanceView,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineRunCommandProperties.
func (vmrcp VirtualMachineRunCommandProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmrcp.Source != nil {
		objectMap["source"] = vmrcp.Source
	}
	if vmrcp.Parameters != nil {
		objectMap["parameters"] = vmrcp.Parameters
	}
	if vmrcp.ProtectedParameters != nil {
		objectMap["protectedParameters"] = vmrcp.ProtectedParameters
	}
	if vmrcp.AsyncExecution != nil {
		objectMap["asyncExecution"] = vmrcp.AsyncExecution
	}
	if vmrcp.RunAsUser != nil {
		objectMap["runAsUser"] = vmrcp.RunAsUser
	}
	if vmrcp.RunAsPassword != nil {
		objectMap["runAsPassword"] = vmrcp.RunAsPassword
	}
	if vmrcp.TimeoutInSeconds != nil {
		objectMap["timeoutInSeconds"] = vmrcp.TimeoutInSeconds
	}
	if vmrcp.OutputBlobURI != nil {
		objectMap["outputBlobUri"] = vmrcp.OutputBlobURI
	}
	if vmrcp.ErrorBlobURI != nil {
		objectMap["errorBlobUri"] = vmrcp.ErrorBlobURI
	}
	return json.Marshal(objectMap)
}

// VirtualMachineRunCommandsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type VirtualMachineRunCommandsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineRunCommandsClient) (VirtualMachineRunCommand, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineRunCommandsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineRunCommandsCreateOrUpdateFuture.Result.
func (future *VirtualMachineRunCommandsCreateOrUpdateFuture) result(client VirtualMachineRunCommandsClient) (vmrc VirtualMachineRunCommand, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineRunCommandsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vmrc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineRunCommandsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vmrc.Response.Response, err = future.GetResult(sender); err == nil && vmrc.Response.Response.StatusCode != http.StatusNoContent {
		vmrc, err = client.CreateOrUpdateResponder(vmrc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachineRunCommandsCreateOrUpdateFuture", "Result", vmrc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineRunCommandScriptSource describes the script sources for run command.
type VirtualMachineRunCommandScriptSource struct {
	// Script - Specifies the script content to be executed on the VM.
	Script *string `json:"script,omitempty"`
	// ScriptURI - Specifies the script download location.
	ScriptURI *string `json:"scriptUri,omitempty"`
	// CommandID - Specifies a commandId of predefined built-in script.
	CommandID *string `json:"commandId,omitempty"`
}

// VirtualMachineRunCommandsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineRunCommandsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineRunCommandsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineRunCommandsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineRunCommandsDeleteFuture.Result.
func (future *VirtualMachineRunCommandsDeleteFuture) result(client VirtualMachineRunCommandsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineRunCommandsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineRunCommandsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineRunCommandsListResult the List run command operation response
type VirtualMachineRunCommandsListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of run commands
	Value *[]VirtualMachineRunCommand `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of run commands.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineRunCommandsListResultIterator provides access to a complete listing of
// VirtualMachineRunCommand values.
type VirtualMachineRunCommandsListResultIterator struct {
	i    int
	page VirtualMachineRunCommandsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualMachineRunCommandsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineRunCommandsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualMachineRunCommandsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualMachineRunCommandsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualMachineRunCommandsListResultIterator) Response() VirtualMachineRunCommandsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualMachineRunCommandsListResultIterator) Value() VirtualMachineRunCommand {
	if !iter.page.NotDone() {
		return VirtualMachineRunCommand{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualMachineRunCommandsListResultIterator type.
func NewVirtualMachineRunCommandsListResultIterator(page VirtualMachineRunCommandsListResultPage) VirtualMachineRunCommandsListResultIterator {
	return VirtualMachineRunCommandsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vmrclr VirtualMachineRunCommandsListResult) IsEmpty() bool {
	return vmrclr.Value == nil || len(*vmrclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vmrclr VirtualMachineRunCommandsListResult) hasNextLink() bool {
	return vmrclr.NextLink != nil && len(*vmrclr.NextLink) != 0
}

// virtualMachineRunCommandsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vmrclr VirtualMachineRunCommandsListResult) virtualMachineRunCommandsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vmrclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vmrclr.NextLink)))
}

// VirtualMachineRunCommandsListResultPage contains a page of VirtualMachineRunCommand values.
type VirtualMachineRunCommandsListResultPage struct {
	fn     func(context.Context, VirtualMachineRunCommandsListResult) (VirtualMachineRunCommandsListResult, error)
	vmrclr VirtualMachineRunCommandsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualMachineRunCommandsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineRunCommandsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vmrclr)
		if err != nil {
			return err
		}
		page.vmrclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualMachineRunCommandsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualMachineRunCommandsListResultPage) NotDone() bool {
	return !page.vmrclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualMachineRunCommandsListResultPage) Response() VirtualMachineRunCommandsListResult {
	return page.vmrclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualMachineRunCommandsListResultPage) Values() []VirtualMachineRunCommand {
	if page.vmrclr.IsEmpty() {
		return nil
	}
	return *page.vmrclr.Value
}

// Creates a new instance of the VirtualMachineRunCommandsListResultPage type.
func NewVirtualMachineRunCommandsListResultPage(cur VirtualMachineRunCommandsListResult, getNextPage func(context.Context, VirtualMachineRunCommandsListResult) (VirtualMachineRunCommandsListResult, error)) VirtualMachineRunCommandsListResultPage {
	return VirtualMachineRunCommandsListResultPage{
		fn:     getNextPage,
		vmrclr: cur,
	}
}

// VirtualMachineRunCommandsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineRunCommandsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineRunCommandsClient) (VirtualMachineRunCommand, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineRunCommandsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineRunCommandsUpdateFuture.Result.
func (future *VirtualMachineRunCommandsUpdateFuture) result(client VirtualMachineRunCommandsClient) (vmrc VirtualMachineRunCommand, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineRunCommandsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vmrc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineRunCommandsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vmrc.Response.Response, err = future.GetResult(sender); err == nil && vmrc.Response.Response.StatusCode != http.StatusNoContent {
		vmrc, err = client.UpdateResponder(vmrc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachineRunCommandsUpdateFuture", "Result", vmrc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineRunCommandUpdate describes a Virtual Machine run command.
type VirtualMachineRunCommandUpdate struct {
	*VirtualMachineRunCommandProperties `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualMachineRunCommandUpdate.
func (vmrcu VirtualMachineRunCommandUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmrcu.VirtualMachineRunCommandProperties != nil {
		objectMap["properties"] = vmrcu.VirtualMachineRunCommandProperties
	}
	if vmrcu.Tags != nil {
		objectMap["tags"] = vmrcu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineRunCommandUpdate struct.
func (vmrcu *VirtualMachineRunCommandUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualMachineRunCommandProperties VirtualMachineRunCommandProperties
				err = json.Unmarshal(*v, &virtualMachineRunCommandProperties)
				if err != nil {
					return err
				}
				vmrcu.VirtualMachineRunCommandProperties = &virtualMachineRunCommandProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vmrcu.Tags = tags
			}
		}
	}

	return nil
}

// VirtualMachinesAssessPatchesFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesAssessPatchesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (VirtualMachineAssessPatchesResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesAssessPatchesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesAssessPatchesFuture.Result.
func (future *VirtualMachinesAssessPatchesFuture) result(client VirtualMachinesClient) (vmapr VirtualMachineAssessPatchesResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesAssessPatchesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vmapr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesAssessPatchesFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vmapr.Response.Response, err = future.GetResult(sender); err == nil && vmapr.Response.Response.StatusCode != http.StatusNoContent {
		vmapr, err = client.AssessPatchesResponder(vmapr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachinesAssessPatchesFuture", "Result", vmapr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineScaleSet describes a Virtual Machine Scale Set.
type VirtualMachineScaleSet struct {
	autorest.Response `json:"-"`
	// Sku - The virtual machine scale set sku.
	Sku *Sku `json:"sku,omitempty"`
	// Plan - Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
	Plan                              *Plan `json:"plan,omitempty"`
	*VirtualMachineScaleSetProperties `json:"properties,omitempty"`
	// Identity - The identity of the virtual machine scale set, if configured.
	Identity *VirtualMachineScaleSetIdentity `json:"identity,omitempty"`
	// Zones - The virtual machine scale set zones. NOTE: Availability zones can only be set when you create the scale set
	Zones *[]string `json:"zones,omitempty"`
	// ExtendedLocation - The extended location of the Virtual Machine Scale Set.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSet.
func (vmss VirtualMachineScaleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmss.Sku != nil {
		objectMap["sku"] = vmss.Sku
	}
	if vmss.Plan != nil {
		objectMap["plan"] = vmss.Plan
	}
	if vmss.VirtualMachineScaleSetProperties != nil {
		objectMap["properties"] = vmss.VirtualMachineScaleSetProperties
	}
	if vmss.Identity != nil {
		objectMap["identity"] = vmss.Identity
	}
	if vmss.Zones != nil {
		objectMap["zones"] = vmss.Zones
	}
	if vmss.ExtendedLocation != nil {
		objectMap["extendedLocation"] = vmss.ExtendedLocation
	}
	if vmss.Location != nil {
		objectMap["location"] = vmss.Location
	}
	if vmss.Tags != nil {
		objectMap["tags"] = vmss.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineScaleSet struct.
func (vmss *VirtualMachineScaleSet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				vmss.Sku = &sku
			}
		case "plan":
			if v != nil {
				var plan Plan
				err = json.Unmarshal(*v, &plan)
				if err != nil {
					return err
				}
				vmss.Plan = &plan
			}
		case "properties":
			if v != nil {
				var virtualMachineScaleSetProperties VirtualMachineScaleSetProperties
				err = json.Unmarshal(*v, &virtualMachineScaleSetProperties)
				if err != nil {
					return err
				}
				vmss.VirtualMachineScaleSetProperties = &virtualMachineScaleSetProperties
			}
		case "identity":
			if v != nil {
				var identity VirtualMachineScaleSetIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				vmss.Identity = &identity
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				vmss.Zones = &zones
			}
		case "extendedLocation":
			if v != nil {
				var extendedLocation ExtendedLocation
				err = json.Unmarshal(*v, &extendedLocation)
				if err != nil {
					return err
				}
				vmss.ExtendedLocation = &extendedLocation
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vmss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vmss.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vmss.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vmss.Tags = tags
			}
		}
	}

	return nil
}

// VirtualMachineScaleSetDataDisk describes a virtual machine scale set data disk.
type VirtualMachineScaleSetDataDisk struct {
	// Name - The disk name.
	Name *string `json:"name,omitempty"`
	// Lun - Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
	Lun *int32 `json:"lun,omitempty"`
	// Caching - Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**. Possible values include: 'CachingTypesNone', 'CachingTypesReadOnly', 'CachingTypesReadWrite'
	Caching CachingTypes `json:"caching,omitempty"`
	// WriteAcceleratorEnabled - Specifies whether writeAccelerator should be enabled or disabled on the disk.
	WriteAcceleratorEnabled *bool `json:"writeAcceleratorEnabled,omitempty"`
	// CreateOption - The create option. Possible values include: 'DiskCreateOptionTypesFromImage', 'DiskCreateOptionTypesEmpty', 'DiskCreateOptionTypesAttach'
	CreateOption DiskCreateOptionTypes `json:"createOption,omitempty"`
	// DiskSizeGB - Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
	// ManagedDisk - The managed disk parameters.
	ManagedDisk *VirtualMachineScaleSetManagedDiskParameters `json:"managedDisk,omitempty"`
	// DiskIOPSReadWrite - Specifies the Read-Write IOPS for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
	DiskIOPSReadWrite *int64 `json:"diskIOPSReadWrite,omitempty"`
	// DiskMBpsReadWrite - Specifies the bandwidth in MB per second for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
	DiskMBpsReadWrite *int64 `json:"diskMBpsReadWrite,omitempty"`
}

// VirtualMachineScaleSetExtension describes a Virtual Machine Scale Set Extension.
type VirtualMachineScaleSetExtension struct {
	autorest.Response `json:"-"`
	// Name - The name of the extension.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type                                       *string `json:"type,omitempty"`
	*VirtualMachineScaleSetExtensionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetExtension.
func (vmsse VirtualMachineScaleSetExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmsse.Name != nil {
		objectMap["name"] = vmsse.Name
	}
	if vmsse.VirtualMachineScaleSetExtensionProperties != nil {
		objectMap["properties"] = vmsse.VirtualMachineScaleSetExtensionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineScaleSetExtension struct.
func (vmsse *VirtualMachineScaleSetExtension) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmsse.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vmsse.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var virtualMachineScaleSetExtensionProperties VirtualMachineScaleSetExtensionProperties
				err = json.Unmarshal(*v, &virtualMachineScaleSetExtensionProperties)
				if err != nil {
					return err
				}
				vmsse.VirtualMachineScaleSetExtensionProperties = &virtualMachineScaleSetExtensionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vmsse.ID = &ID
			}
		}
	}

	return nil
}

// VirtualMachineScaleSetExtensionListResult the List VM scale set extension operation response.
type VirtualMachineScaleSetExtensionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of VM scale set extensions.
	Value *[]VirtualMachineScaleSetExtension `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of VM scale set extensions. Call ListNext() with this to fetch the next page of VM scale set extensions.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetExtensionListResultIterator provides access to a complete listing of
// VirtualMachineScaleSetExtension values.
type VirtualMachineScaleSetExtensionListResultIterator struct {
	i    int
	page VirtualMachineScaleSetExtensionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualMachineScaleSetExtensionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineScaleSetExtensionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualMachineScaleSetExtensionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualMachineScaleSetExtensionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualMachineScaleSetExtensionListResultIterator) Response() VirtualMachineScaleSetExtensionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualMachineScaleSetExtensionListResultIterator) Value() VirtualMachineScaleSetExtension {
	if !iter.page.NotDone() {
		return VirtualMachineScaleSetExtension{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualMachineScaleSetExtensionListResultIterator type.
func NewVirtualMachineScaleSetExtensionListResultIterator(page VirtualMachineScaleSetExtensionListResultPage) VirtualMachineScaleSetExtensionListResultIterator {
	return VirtualMachineScaleSetExtensionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vmsselr VirtualMachineScaleSetExtensionListResult) IsEmpty() bool {
	return vmsselr.Value == nil || len(*vmsselr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vmsselr VirtualMachineScaleSetExtensionListResult) hasNextLink() bool {
	return vmsselr.NextLink != nil && len(*vmsselr.NextLink) != 0
}

// virtualMachineScaleSetExtensionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vmsselr VirtualMachineScaleSetExtensionListResult) virtualMachineScaleSetExtensionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vmsselr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vmsselr.NextLink)))
}

// VirtualMachineScaleSetExtensionListResultPage contains a page of VirtualMachineScaleSetExtension values.
type VirtualMachineScaleSetExtensionListResultPage struct {
	fn      func(context.Context, VirtualMachineScaleSetExtensionListResult) (VirtualMachineScaleSetExtensionListResult, error)
	vmsselr VirtualMachineScaleSetExtensionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualMachineScaleSetExtensionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineScaleSetExtensionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vmsselr)
		if err != nil {
			return err
		}
		page.vmsselr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualMachineScaleSetExtensionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualMachineScaleSetExtensionListResultPage) NotDone() bool {
	return !page.vmsselr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualMachineScaleSetExtensionListResultPage) Response() VirtualMachineScaleSetExtensionListResult {
	return page.vmsselr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualMachineScaleSetExtensionListResultPage) Values() []VirtualMachineScaleSetExtension {
	if page.vmsselr.IsEmpty() {
		return nil
	}
	return *page.vmsselr.Value
}

// Creates a new instance of the VirtualMachineScaleSetExtensionListResultPage type.
func NewVirtualMachineScaleSetExtensionListResultPage(cur VirtualMachineScaleSetExtensionListResult, getNextPage func(context.Context, VirtualMachineScaleSetExtensionListResult) (VirtualMachineScaleSetExtensionListResult, error)) VirtualMachineScaleSetExtensionListResultPage {
	return VirtualMachineScaleSetExtensionListResultPage{
		fn:      getNextPage,
		vmsselr: cur,
	}
}

// VirtualMachineScaleSetExtensionProfile describes a virtual machine scale set extension profile.
type VirtualMachineScaleSetExtensionProfile struct {
	// Extensions - The virtual machine scale set child extension resources.
	Extensions *[]VirtualMachineScaleSetExtension `json:"extensions,omitempty"`
	// ExtensionsTimeBudget - Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). <br><br> Minimum api-version: 2020-06-01
	ExtensionsTimeBudget *string `json:"extensionsTimeBudget,omitempty"`
}

// VirtualMachineScaleSetExtensionProperties describes the properties of a Virtual Machine Scale Set
// Extension.
type VirtualMachineScaleSetExtensionProperties struct {
	// ForceUpdateTag - If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`
	// Publisher - The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`
	// Type - Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`
	// TypeHandlerVersion - Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
	// AutoUpgradeMinorVersion - Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`
	// EnableAutomaticUpgrade - Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
	EnableAutomaticUpgrade *bool `json:"enableAutomaticUpgrade,omitempty"`
	// Settings - Json formatted public settings for the extension.
	Settings interface{} `json:"settings,omitempty"`
	// ProtectedSettings - The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ProvisionAfterExtensions - Collection of extension names after which this extension needs to be provisioned.
	ProvisionAfterExtensions *[]string `json:"provisionAfterExtensions,omitempty"`
	// SuppressFailures - Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
	SuppressFailures *bool `json:"suppressFailures,omitempty"`
	// ProtectedSettingsFromKeyVault - The extensions protected settings that are passed by reference, and consumed from key vault
	ProtectedSettingsFromKeyVault interface{} `json:"protectedSettingsFromKeyVault,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetExtensionProperties.
func (vmssep VirtualMachineScaleSetExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmssep.ForceUpdateTag != nil {
		objectMap["forceUpdateTag"] = vmssep.ForceUpdateTag
	}
	if vmssep.Publisher != nil {
		objectMap["publisher"] = vmssep.Publisher
	}
	if vmssep.Type != nil {
		objectMap["type"] = vmssep.Type
	}
	if vmssep.TypeHandlerVersion != nil {
		objectMap["typeHandlerVersion"] = vmssep.TypeHandlerVersion
	}
	if vmssep.AutoUpgradeMinorVersion != nil {
		objectMap["autoUpgradeMinorVersion"] = vmssep.AutoUpgradeMinorVersion
	}
	if vmssep.EnableAutomaticUpgrade != nil {
		objectMap["enableAutomaticUpgrade"] = vmssep.EnableAutomaticUpgrade
	}
	if vmssep.Settings != nil {
		objectMap["settings"] = vmssep.Settings
	}
	if vmssep.ProtectedSettings != nil {
		objectMap["protectedSettings"] = vmssep.ProtectedSettings
	}
	if vmssep.ProvisionAfterExtensions != nil {
		objectMap["provisionAfterExtensions"] = vmssep.ProvisionAfterExtensions
	}
	if vmssep.SuppressFailures != nil {
		objectMap["suppressFailures"] = vmssep.SuppressFailures
	}
	if vmssep.ProtectedSettingsFromKeyVault != nil {
		objectMap["protectedSettingsFromKeyVault"] = vmssep.ProtectedSettingsFromKeyVault
	}
	return json.Marshal(objectMap)
}

// VirtualMachineScaleSetExtensionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type VirtualMachineScaleSetExtensionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetExtensionsClient) (VirtualMachineScaleSetExtension, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetExtensionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetExtensionsCreateOrUpdateFuture.Result.
func (future *VirtualMachineScaleSetExtensionsCreateOrUpdateFuture) result(client VirtualMachineScaleSetExtensionsClient) (vmsse VirtualMachineScaleSetExtension, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetExtensionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vmsse.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetExtensionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vmsse.Response.Response, err = future.GetResult(sender); err == nil && vmsse.Response.Response.StatusCode != http.StatusNoContent {
		vmsse, err = client.CreateOrUpdateResponder(vmsse.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetExtensionsCreateOrUpdateFuture", "Result", vmsse.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineScaleSetExtensionsDeleteFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type VirtualMachineScaleSetExtensionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetExtensionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetExtensionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetExtensionsDeleteFuture.Result.
func (future *VirtualMachineScaleSetExtensionsDeleteFuture) result(client VirtualMachineScaleSetExtensionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetExtensionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetExtensionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetExtensionsUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type VirtualMachineScaleSetExtensionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetExtensionsClient) (VirtualMachineScaleSetExtension, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetExtensionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetExtensionsUpdateFuture.Result.
func (future *VirtualMachineScaleSetExtensionsUpdateFuture) result(client VirtualMachineScaleSetExtensionsClient) (vmsse VirtualMachineScaleSetExtension, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetExtensionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vmsse.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetExtensionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vmsse.Response.Response, err = future.GetResult(sender); err == nil && vmsse.Response.Response.StatusCode != http.StatusNoContent {
		vmsse, err = client.UpdateResponder(vmsse.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetExtensionsUpdateFuture", "Result", vmsse.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineScaleSetExtensionUpdate describes a Virtual Machine Scale Set Extension.
type VirtualMachineScaleSetExtensionUpdate struct {
	// Name - READ-ONLY; The name of the extension.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type                                       *string `json:"type,omitempty"`
	*VirtualMachineScaleSetExtensionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetExtensionUpdate.
func (vmsseu VirtualMachineScaleSetExtensionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmsseu.VirtualMachineScaleSetExtensionProperties != nil {
		objectMap["properties"] = vmsseu.VirtualMachineScaleSetExtensionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineScaleSetExtensionUpdate struct.
func (vmsseu *VirtualMachineScaleSetExtensionUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmsseu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vmsseu.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var virtualMachineScaleSetExtensionProperties VirtualMachineScaleSetExtensionProperties
				err = json.Unmarshal(*v, &virtualMachineScaleSetExtensionProperties)
				if err != nil {
					return err
				}
				vmsseu.VirtualMachineScaleSetExtensionProperties = &virtualMachineScaleSetExtensionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vmsseu.ID = &ID
			}
		}
	}

	return nil
}

// VirtualMachineScaleSetHardwareProfile specifies the hardware settings for the virtual machine scale set.
type VirtualMachineScaleSetHardwareProfile struct {
	// VMSizeProperties - Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-11-01. <br><br> Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for more details.
	VMSizeProperties *VMSizeProperties `json:"vmSizeProperties,omitempty"`
}

// VirtualMachineScaleSetIdentity identity for the virtual machine scale set.
type VirtualMachineScaleSetIdentity struct {
	// PrincipalID - READ-ONLY; The principal id of virtual machine scale set identity. This property will only be provided for a system assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id associated with the virtual machine scale set. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of identity used for the virtual machine scale set. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine scale set. Possible values include: 'ResourceIdentityTypeSystemAssigned', 'ResourceIdentityTypeUserAssigned', 'ResourceIdentityTypeSystemAssignedUserAssigned', 'ResourceIdentityTypeNone'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the virtual machine scale set. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetIdentity.
func (vmssi VirtualMachineScaleSetIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmssi.Type != "" {
		objectMap["type"] = vmssi.Type
	}
	if vmssi.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = vmssi.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue ...
type VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue.
func (vmssiAiv VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachineScaleSetInstanceView the instance view of a virtual machine scale set.
type VirtualMachineScaleSetInstanceView struct {
	autorest.Response `json:"-"`
	// VirtualMachine - READ-ONLY; The instance view status summary for the virtual machine scale set.
	VirtualMachine *VirtualMachineScaleSetInstanceViewStatusesSummary `json:"virtualMachine,omitempty"`
	// Extensions - READ-ONLY; The extensions information.
	Extensions *[]VirtualMachineScaleSetVMExtensionsSummary `json:"extensions,omitempty"`
	// Statuses - The resource status information.
	Statuses *[]InstanceViewStatus `json:"statuses,omitempty"`
	// OrchestrationServices - READ-ONLY; The orchestration services information.
	OrchestrationServices *[]OrchestrationServiceSummary `json:"orchestrationServices,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetInstanceView.
func (vmssiv VirtualMachineScaleSetInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmssiv.Statuses != nil {
		objectMap["statuses"] = vmssiv.Statuses
	}
	return json.Marshal(objectMap)
}

// VirtualMachineScaleSetInstanceViewStatusesSummary instance view statuses summary for virtual machines of
// a virtual machine scale set.
type VirtualMachineScaleSetInstanceViewStatusesSummary struct {
	// StatusesSummary - READ-ONLY; The extensions information.
	StatusesSummary *[]VirtualMachineStatusCodeCount `json:"statusesSummary,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetInstanceViewStatusesSummary.
func (vmssivss VirtualMachineScaleSetInstanceViewStatusesSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachineScaleSetIPConfiguration describes a virtual machine scale set network profile's IP
// configuration.
type VirtualMachineScaleSetIPConfiguration struct {
	// Name - The IP configuration name.
	Name                                             *string `json:"name,omitempty"`
	*VirtualMachineScaleSetIPConfigurationProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetIPConfiguration.
func (vmssic VirtualMachineScaleSetIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmssic.Name != nil {
		objectMap["name"] = vmssic.Name
	}
	if vmssic.VirtualMachineScaleSetIPConfigurationProperties != nil {
		objectMap["properties"] = vmssic.VirtualMachineScaleSetIPConfigurationProperties
	}
	if vmssic.ID != nil {
		objectMap["id"] = vmssic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineScaleSetIPConfiguration struct.
func (vmssic *VirtualMachineScaleSetIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmssic.Name = &name
			}
		case "properties":
			if v != nil {
				var virtualMachineScaleSetIPConfigurationProperties VirtualMachineScaleSetIPConfigurationProperties
				err = json.Unmarshal(*v, &virtualMachineScaleSetIPConfigurationProperties)
				if err != nil {
					return err
				}
				vmssic.VirtualMachineScaleSetIPConfigurationProperties = &virtualMachineScaleSetIPConfigurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vmssic.ID = &ID
			}
		}
	}

	return nil
}

// VirtualMachineScaleSetIPConfigurationProperties describes a virtual machine scale set network profile's
// IP configuration properties.
type VirtualMachineScaleSetIPConfigurationProperties struct {
	// Subnet - Specifies the identifier of the subnet.
	Subnet *APIEntityReference `json:"subnet,omitempty"`
	// Primary - Specifies the primary network interface in case the virtual machine has more than 1 network interface.
	Primary *bool `json:"primary,omitempty"`
	// PublicIPAddressConfiguration - The publicIPAddressConfiguration.
	PublicIPAddressConfiguration *VirtualMachineScaleSetPublicIPAddressConfiguration `json:"publicIPAddressConfiguration,omitempty"`
	// PrivateIPAddressVersion - Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'. Possible values include: 'IPVersionIPv4', 'IPVersionIPv6'
	PrivateIPAddressVersion IPVersion `json:"privateIPAddressVersion,omitempty"`
	// ApplicationGatewayBackendAddressPools - Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
	ApplicationGatewayBackendAddressPools *[]SubResource `json:"applicationGatewayBackendAddressPools,omitempty"`
	// ApplicationSecurityGroups - Specifies an array of references to application security group.
	ApplicationSecurityGroups *[]SubResource `json:"applicationSecurityGroups,omitempty"`
	// LoadBalancerBackendAddressPools - Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
	LoadBalancerBackendAddressPools *[]SubResource `json:"loadBalancerBackendAddressPools,omitempty"`
	// LoadBalancerInboundNatPools - Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
	LoadBalancerInboundNatPools *[]SubResource `json:"loadBalancerInboundNatPools,omitempty"`
}

// VirtualMachineScaleSetIPTag contains the IP tag associated with the public IP address.
type VirtualMachineScaleSetIPTag struct {
	// IPTagType - IP tag type. Example: FirstPartyUsage.
	IPTagType *string `json:"ipTagType,omitempty"`
	// Tag - IP tag associated with the public IP. Example: SQL, Storage etc.
	Tag *string `json:"tag,omitempty"`
}

// VirtualMachineScaleSetListOSUpgradeHistory list of Virtual Machine Scale Set OS Upgrade History
// operation response.
type VirtualMachineScaleSetListOSUpgradeHistory struct {
	autorest.Response `json:"-"`
	// Value - The list of OS upgrades performed on the virtual machine scale set.
	Value *[]UpgradeOperationHistoricalStatusInfo `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of OS Upgrade History. Call ListNext() with this to fetch the next page of history of upgrades.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetListOSUpgradeHistoryIterator provides access to a complete listing of
// UpgradeOperationHistoricalStatusInfo values.
type VirtualMachineScaleSetListOSUpgradeHistoryIterator struct {
	i    int
	page VirtualMachineScaleSetListOSUpgradeHistoryPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualMachineScaleSetListOSUpgradeHistoryIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineScaleSetListOSUpgradeHistoryIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualMachineScaleSetListOSUpgradeHistoryIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualMachineScaleSetListOSUpgradeHistoryIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualMachineScaleSetListOSUpgradeHistoryIterator) Response() VirtualMachineScaleSetListOSUpgradeHistory {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualMachineScaleSetListOSUpgradeHistoryIterator) Value() UpgradeOperationHistoricalStatusInfo {
	if !iter.page.NotDone() {
		return UpgradeOperationHistoricalStatusInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualMachineScaleSetListOSUpgradeHistoryIterator type.
func NewVirtualMachineScaleSetListOSUpgradeHistoryIterator(page VirtualMachineScaleSetListOSUpgradeHistoryPage) VirtualMachineScaleSetListOSUpgradeHistoryIterator {
	return VirtualMachineScaleSetListOSUpgradeHistoryIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vmsslouh VirtualMachineScaleSetListOSUpgradeHistory) IsEmpty() bool {
	return vmsslouh.Value == nil || len(*vmsslouh.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vmsslouh VirtualMachineScaleSetListOSUpgradeHistory) hasNextLink() bool {
	return vmsslouh.NextLink != nil && len(*vmsslouh.NextLink) != 0
}

// virtualMachineScaleSetListOSUpgradeHistoryPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vmsslouh VirtualMachineScaleSetListOSUpgradeHistory) virtualMachineScaleSetListOSUpgradeHistoryPreparer(ctx context.Context) (*http.Request, error) {
	if !vmsslouh.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vmsslouh.NextLink)))
}

// VirtualMachineScaleSetListOSUpgradeHistoryPage contains a page of UpgradeOperationHistoricalStatusInfo
// values.
type VirtualMachineScaleSetListOSUpgradeHistoryPage struct {
	fn       func(context.Context, VirtualMachineScaleSetListOSUpgradeHistory) (VirtualMachineScaleSetListOSUpgradeHistory, error)
	vmsslouh VirtualMachineScaleSetListOSUpgradeHistory
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualMachineScaleSetListOSUpgradeHistoryPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineScaleSetListOSUpgradeHistoryPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vmsslouh)
		if err != nil {
			return err
		}
		page.vmsslouh = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualMachineScaleSetListOSUpgradeHistoryPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualMachineScaleSetListOSUpgradeHistoryPage) NotDone() bool {
	return !page.vmsslouh.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualMachineScaleSetListOSUpgradeHistoryPage) Response() VirtualMachineScaleSetListOSUpgradeHistory {
	return page.vmsslouh
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualMachineScaleSetListOSUpgradeHistoryPage) Values() []UpgradeOperationHistoricalStatusInfo {
	if page.vmsslouh.IsEmpty() {
		return nil
	}
	return *page.vmsslouh.Value
}

// Creates a new instance of the VirtualMachineScaleSetListOSUpgradeHistoryPage type.
func NewVirtualMachineScaleSetListOSUpgradeHistoryPage(cur VirtualMachineScaleSetListOSUpgradeHistory, getNextPage func(context.Context, VirtualMachineScaleSetListOSUpgradeHistory) (VirtualMachineScaleSetListOSUpgradeHistory, error)) VirtualMachineScaleSetListOSUpgradeHistoryPage {
	return VirtualMachineScaleSetListOSUpgradeHistoryPage{
		fn:       getNextPage,
		vmsslouh: cur,
	}
}

// VirtualMachineScaleSetListResult the List Virtual Machine operation response.
type VirtualMachineScaleSetListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of virtual machine scale sets.
	Value *[]VirtualMachineScaleSet `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext() with this to fetch the next page of VMSS.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetListResultIterator provides access to a complete listing of VirtualMachineScaleSet
// values.
type VirtualMachineScaleSetListResultIterator struct {
	i    int
	page VirtualMachineScaleSetListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualMachineScaleSetListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineScaleSetListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualMachineScaleSetListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualMachineScaleSetListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualMachineScaleSetListResultIterator) Response() VirtualMachineScaleSetListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualMachineScaleSetListResultIterator) Value() VirtualMachineScaleSet {
	if !iter.page.NotDone() {
		return VirtualMachineScaleSet{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualMachineScaleSetListResultIterator type.
func NewVirtualMachineScaleSetListResultIterator(page VirtualMachineScaleSetListResultPage) VirtualMachineScaleSetListResultIterator {
	return VirtualMachineScaleSetListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vmsslr VirtualMachineScaleSetListResult) IsEmpty() bool {
	return vmsslr.Value == nil || len(*vmsslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vmsslr VirtualMachineScaleSetListResult) hasNextLink() bool {
	return vmsslr.NextLink != nil && len(*vmsslr.NextLink) != 0
}

// virtualMachineScaleSetListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vmsslr VirtualMachineScaleSetListResult) virtualMachineScaleSetListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vmsslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vmsslr.NextLink)))
}

// VirtualMachineScaleSetListResultPage contains a page of VirtualMachineScaleSet values.
type VirtualMachineScaleSetListResultPage struct {
	fn     func(context.Context, VirtualMachineScaleSetListResult) (VirtualMachineScaleSetListResult, error)
	vmsslr VirtualMachineScaleSetListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualMachineScaleSetListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineScaleSetListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vmsslr)
		if err != nil {
			return err
		}
		page.vmsslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualMachineScaleSetListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualMachineScaleSetListResultPage) NotDone() bool {
	return !page.vmsslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualMachineScaleSetListResultPage) Response() VirtualMachineScaleSetListResult {
	return page.vmsslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualMachineScaleSetListResultPage) Values() []VirtualMachineScaleSet {
	if page.vmsslr.IsEmpty() {
		return nil
	}
	return *page.vmsslr.Value
}

// Creates a new instance of the VirtualMachineScaleSetListResultPage type.
func NewVirtualMachineScaleSetListResultPage(cur VirtualMachineScaleSetListResult, getNextPage func(context.Context, VirtualMachineScaleSetListResult) (VirtualMachineScaleSetListResult, error)) VirtualMachineScaleSetListResultPage {
	return VirtualMachineScaleSetListResultPage{
		fn:     getNextPage,
		vmsslr: cur,
	}
}

// VirtualMachineScaleSetListSkusResult the Virtual Machine Scale Set List Skus operation response.
type VirtualMachineScaleSetListSkusResult struct {
	autorest.Response `json:"-"`
	// Value - The list of skus available for the virtual machine scale set.
	Value *[]VirtualMachineScaleSetSku `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of Virtual Machine Scale Set Skus. Call ListNext() with this to fetch the next page of VMSS Skus.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetListSkusResultIterator provides access to a complete listing of
// VirtualMachineScaleSetSku values.
type VirtualMachineScaleSetListSkusResultIterator struct {
	i    int
	page VirtualMachineScaleSetListSkusResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualMachineScaleSetListSkusResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineScaleSetListSkusResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualMachineScaleSetListSkusResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualMachineScaleSetListSkusResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualMachineScaleSetListSkusResultIterator) Response() VirtualMachineScaleSetListSkusResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualMachineScaleSetListSkusResultIterator) Value() VirtualMachineScaleSetSku {
	if !iter.page.NotDone() {
		return VirtualMachineScaleSetSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualMachineScaleSetListSkusResultIterator type.
func NewVirtualMachineScaleSetListSkusResultIterator(page VirtualMachineScaleSetListSkusResultPage) VirtualMachineScaleSetListSkusResultIterator {
	return VirtualMachineScaleSetListSkusResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vmsslsr VirtualMachineScaleSetListSkusResult) IsEmpty() bool {
	return vmsslsr.Value == nil || len(*vmsslsr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vmsslsr VirtualMachineScaleSetListSkusResult) hasNextLink() bool {
	return vmsslsr.NextLink != nil && len(*vmsslsr.NextLink) != 0
}

// virtualMachineScaleSetListSkusResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vmsslsr VirtualMachineScaleSetListSkusResult) virtualMachineScaleSetListSkusResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vmsslsr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vmsslsr.NextLink)))
}

// VirtualMachineScaleSetListSkusResultPage contains a page of VirtualMachineScaleSetSku values.
type VirtualMachineScaleSetListSkusResultPage struct {
	fn      func(context.Context, VirtualMachineScaleSetListSkusResult) (VirtualMachineScaleSetListSkusResult, error)
	vmsslsr VirtualMachineScaleSetListSkusResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualMachineScaleSetListSkusResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineScaleSetListSkusResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vmsslsr)
		if err != nil {
			return err
		}
		page.vmsslsr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualMachineScaleSetListSkusResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualMachineScaleSetListSkusResultPage) NotDone() bool {
	return !page.vmsslsr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualMachineScaleSetListSkusResultPage) Response() VirtualMachineScaleSetListSkusResult {
	return page.vmsslsr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualMachineScaleSetListSkusResultPage) Values() []VirtualMachineScaleSetSku {
	if page.vmsslsr.IsEmpty() {
		return nil
	}
	return *page.vmsslsr.Value
}

// Creates a new instance of the VirtualMachineScaleSetListSkusResultPage type.
func NewVirtualMachineScaleSetListSkusResultPage(cur VirtualMachineScaleSetListSkusResult, getNextPage func(context.Context, VirtualMachineScaleSetListSkusResult) (VirtualMachineScaleSetListSkusResult, error)) VirtualMachineScaleSetListSkusResultPage {
	return VirtualMachineScaleSetListSkusResultPage{
		fn:      getNextPage,
		vmsslsr: cur,
	}
}

// VirtualMachineScaleSetListWithLinkResult the List Virtual Machine operation response.
type VirtualMachineScaleSetListWithLinkResult struct {
	autorest.Response `json:"-"`
	// Value - The list of virtual machine scale sets.
	Value *[]VirtualMachineScaleSet `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext() with this to fetch the next page of Virtual Machine Scale Sets.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetListWithLinkResultIterator provides access to a complete listing of
// VirtualMachineScaleSet values.
type VirtualMachineScaleSetListWithLinkResultIterator struct {
	i    int
	page VirtualMachineScaleSetListWithLinkResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualMachineScaleSetListWithLinkResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineScaleSetListWithLinkResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualMachineScaleSetListWithLinkResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualMachineScaleSetListWithLinkResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualMachineScaleSetListWithLinkResultIterator) Response() VirtualMachineScaleSetListWithLinkResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualMachineScaleSetListWithLinkResultIterator) Value() VirtualMachineScaleSet {
	if !iter.page.NotDone() {
		return VirtualMachineScaleSet{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualMachineScaleSetListWithLinkResultIterator type.
func NewVirtualMachineScaleSetListWithLinkResultIterator(page VirtualMachineScaleSetListWithLinkResultPage) VirtualMachineScaleSetListWithLinkResultIterator {
	return VirtualMachineScaleSetListWithLinkResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vmsslwlr VirtualMachineScaleSetListWithLinkResult) IsEmpty() bool {
	return vmsslwlr.Value == nil || len(*vmsslwlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vmsslwlr VirtualMachineScaleSetListWithLinkResult) hasNextLink() bool {
	return vmsslwlr.NextLink != nil && len(*vmsslwlr.NextLink) != 0
}

// virtualMachineScaleSetListWithLinkResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vmsslwlr VirtualMachineScaleSetListWithLinkResult) virtualMachineScaleSetListWithLinkResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vmsslwlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vmsslwlr.NextLink)))
}

// VirtualMachineScaleSetListWithLinkResultPage contains a page of VirtualMachineScaleSet values.
type VirtualMachineScaleSetListWithLinkResultPage struct {
	fn       func(context.Context, VirtualMachineScaleSetListWithLinkResult) (VirtualMachineScaleSetListWithLinkResult, error)
	vmsslwlr VirtualMachineScaleSetListWithLinkResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualMachineScaleSetListWithLinkResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineScaleSetListWithLinkResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vmsslwlr)
		if err != nil {
			return err
		}
		page.vmsslwlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualMachineScaleSetListWithLinkResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualMachineScaleSetListWithLinkResultPage) NotDone() bool {
	return !page.vmsslwlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualMachineScaleSetListWithLinkResultPage) Response() VirtualMachineScaleSetListWithLinkResult {
	return page.vmsslwlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualMachineScaleSetListWithLinkResultPage) Values() []VirtualMachineScaleSet {
	if page.vmsslwlr.IsEmpty() {
		return nil
	}
	return *page.vmsslwlr.Value
}

// Creates a new instance of the VirtualMachineScaleSetListWithLinkResultPage type.
func NewVirtualMachineScaleSetListWithLinkResultPage(cur VirtualMachineScaleSetListWithLinkResult, getNextPage func(context.Context, VirtualMachineScaleSetListWithLinkResult) (VirtualMachineScaleSetListWithLinkResult, error)) VirtualMachineScaleSetListWithLinkResultPage {
	return VirtualMachineScaleSetListWithLinkResultPage{
		fn:       getNextPage,
		vmsslwlr: cur,
	}
}

// VirtualMachineScaleSetManagedDiskParameters describes the parameters of a ScaleSet managed disk.
type VirtualMachineScaleSetManagedDiskParameters struct {
	// StorageAccountType - Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Possible values include: 'StorageAccountTypesStandardLRS', 'StorageAccountTypesPremiumLRS', 'StorageAccountTypesStandardSSDLRS', 'StorageAccountTypesUltraSSDLRS', 'StorageAccountTypesPremiumZRS', 'StorageAccountTypesStandardSSDZRS'
	StorageAccountType StorageAccountTypes `json:"storageAccountType,omitempty"`
	// DiskEncryptionSet - Specifies the customer managed disk encryption set resource id for the managed disk.
	DiskEncryptionSet *DiskEncryptionSetParameters `json:"diskEncryptionSet,omitempty"`
	// SecurityProfile - Specifies the security profile for the managed disk.
	SecurityProfile *VMDiskSecurityProfile `json:"securityProfile,omitempty"`
}

// VirtualMachineScaleSetNetworkConfiguration describes a virtual machine scale set network profile's
// network configurations.
type VirtualMachineScaleSetNetworkConfiguration struct {
	// Name - The network configuration name.
	Name                                                  *string `json:"name,omitempty"`
	*VirtualMachineScaleSetNetworkConfigurationProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetNetworkConfiguration.
func (vmssnc VirtualMachineScaleSetNetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmssnc.Name != nil {
		objectMap["name"] = vmssnc.Name
	}
	if vmssnc.VirtualMachineScaleSetNetworkConfigurationProperties != nil {
		objectMap["properties"] = vmssnc.VirtualMachineScaleSetNetworkConfigurationProperties
	}
	if vmssnc.ID != nil {
		objectMap["id"] = vmssnc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineScaleSetNetworkConfiguration struct.
func (vmssnc *VirtualMachineScaleSetNetworkConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmssnc.Name = &name
			}
		case "properties":
			if v != nil {
				var virtualMachineScaleSetNetworkConfigurationProperties VirtualMachineScaleSetNetworkConfigurationProperties
				err = json.Unmarshal(*v, &virtualMachineScaleSetNetworkConfigurationProperties)
				if err != nil {
					return err
				}
				vmssnc.VirtualMachineScaleSetNetworkConfigurationProperties = &virtualMachineScaleSetNetworkConfigurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vmssnc.ID = &ID
			}
		}
	}

	return nil
}

// VirtualMachineScaleSetNetworkConfigurationDNSSettings describes a virtual machines scale sets network
// configuration's DNS settings.
type VirtualMachineScaleSetNetworkConfigurationDNSSettings struct {
	// DNSServers - List of DNS servers IP addresses
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// VirtualMachineScaleSetNetworkConfigurationProperties describes a virtual machine scale set network
// profile's IP configuration.
type VirtualMachineScaleSetNetworkConfigurationProperties struct {
	// Primary - Specifies the primary network interface in case the virtual machine has more than 1 network interface.
	Primary *bool `json:"primary,omitempty"`
	// EnableAcceleratedNetworking - Specifies whether the network interface is accelerated networking-enabled.
	EnableAcceleratedNetworking *bool `json:"enableAcceleratedNetworking,omitempty"`
	// EnableFpga - Specifies whether the network interface is FPGA networking-enabled.
	EnableFpga *bool `json:"enableFpga,omitempty"`
	// NetworkSecurityGroup - The network security group.
	NetworkSecurityGroup *SubResource `json:"networkSecurityGroup,omitempty"`
	// DNSSettings - The dns settings to be applied on the network interfaces.
	DNSSettings *VirtualMachineScaleSetNetworkConfigurationDNSSettings `json:"dnsSettings,omitempty"`
	// IPConfigurations - Specifies the IP configurations of the network interface.
	IPConfigurations *[]VirtualMachineScaleSetIPConfiguration `json:"ipConfigurations,omitempty"`
	// EnableIPForwarding - Whether IP forwarding enabled on this NIC.
	EnableIPForwarding *bool `json:"enableIPForwarding,omitempty"`
	// DeleteOption - Specify what happens to the network interface when the VM is deleted. Possible values include: 'DeleteOptionsDelete', 'DeleteOptionsDetach'
	DeleteOption DeleteOptions `json:"deleteOption,omitempty"`
}

// VirtualMachineScaleSetNetworkProfile describes a virtual machine scale set network profile.
type VirtualMachineScaleSetNetworkProfile struct {
	// HealthProbe - A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The reference will be in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
	HealthProbe *APIEntityReference `json:"healthProbe,omitempty"`
	// NetworkInterfaceConfigurations - The list of network configurations.
	NetworkInterfaceConfigurations *[]VirtualMachineScaleSetNetworkConfiguration `json:"networkInterfaceConfigurations,omitempty"`
	// NetworkAPIVersion - specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations for Virtual Machine Scale Set with orchestration mode 'Flexible'. Possible values include: 'NetworkAPIVersionTwoZeroTwoZeroHyphenMinusOneOneHyphenMinusZeroOne'
	NetworkAPIVersion NetworkAPIVersion `json:"networkApiVersion,omitempty"`
}

// VirtualMachineScaleSetOSDisk describes a virtual machine scale set operating system disk.
type VirtualMachineScaleSetOSDisk struct {
	// Name - The disk name.
	Name *string `json:"name,omitempty"`
	// Caching - Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**. Possible values include: 'CachingTypesNone', 'CachingTypesReadOnly', 'CachingTypesReadWrite'
	Caching CachingTypes `json:"caching,omitempty"`
	// WriteAcceleratorEnabled - Specifies whether writeAccelerator should be enabled or disabled on the disk.
	WriteAcceleratorEnabled *bool `json:"writeAcceleratorEnabled,omitempty"`
	// CreateOption - Specifies how the virtual machines in the scale set should be created.<br><br> The only allowed value is: **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described. Possible values include: 'DiskCreateOptionTypesFromImage', 'DiskCreateOptionTypesEmpty', 'DiskCreateOptionTypesAttach'
	CreateOption DiskCreateOptionTypes `json:"createOption,omitempty"`
	// DiffDiskSettings - Specifies the ephemeral disk Settings for the operating system disk used by the virtual machine scale set.
	DiffDiskSettings *DiffDiskSettings `json:"diffDiskSettings,omitempty"`
	// DiskSizeGB - Specifies the size of the operating system disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
	// OsType - This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**. Possible values include: 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// Image - Specifies information about the unmanaged user image to base the scale set on.
	Image *VirtualHardDisk `json:"image,omitempty"`
	// VhdContainers - Specifies the container urls that are used to store operating system disks for the scale set.
	VhdContainers *[]string `json:"vhdContainers,omitempty"`
	// ManagedDisk - The managed disk parameters.
	ManagedDisk *VirtualMachineScaleSetManagedDiskParameters `json:"managedDisk,omitempty"`
}

// VirtualMachineScaleSetOSProfile describes a virtual machine scale set OS profile.
type VirtualMachineScaleSetOSProfile struct {
	// ComputerNamePrefix - Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
	ComputerNamePrefix *string `json:"computerNamePrefix,omitempty"`
	// AdminUsername - Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters
	AdminUsername *string `json:"adminUsername,omitempty"`
	// AdminPassword - Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
	AdminPassword *string `json:"adminPassword,omitempty"`
	// CustomData - Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init)
	CustomData *string `json:"customData,omitempty"`
	// WindowsConfiguration - Specifies Windows operating system settings on the virtual machine.
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
	// LinuxConfiguration - Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
	LinuxConfiguration *LinuxConfiguration `json:"linuxConfiguration,omitempty"`
	// Secrets - Specifies set of certificates that should be installed onto the virtual machines in the scale set. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
	Secrets *[]VaultSecretGroup `json:"secrets,omitempty"`
	// AllowExtensionOperations - Specifies whether extension operations should be allowed on the virtual machine scale set. <br><br>This may only be set to False when no extensions are present on the virtual machine scale set.
	AllowExtensionOperations *bool `json:"allowExtensionOperations,omitempty"`
}

// VirtualMachineScaleSetProperties describes the properties of a Virtual Machine Scale Set.
type VirtualMachineScaleSetProperties struct {
	// UpgradePolicy - The upgrade policy.
	UpgradePolicy *UpgradePolicy `json:"upgradePolicy,omitempty"`
	// AutomaticRepairsPolicy - Policy for automatic repairs.
	AutomaticRepairsPolicy *AutomaticRepairsPolicy `json:"automaticRepairsPolicy,omitempty"`
	// VirtualMachineProfile - The virtual machine profile.
	VirtualMachineProfile *VirtualMachineScaleSetVMProfile `json:"virtualMachineProfile,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Overprovision - Specifies whether the Virtual Machine Scale Set should be overprovisioned.
	Overprovision *bool `json:"overprovision,omitempty"`
	// DoNotRunExtensionsOnOverprovisionedVMs - When Overprovision is enabled, extensions are launched only on the requested number of VMs which are finally kept. This property will hence ensure that the extensions do not run on the extra overprovisioned VMs.
	DoNotRunExtensionsOnOverprovisionedVMs *bool `json:"doNotRunExtensionsOnOverprovisionedVMs,omitempty"`
	// UniqueID - READ-ONLY; Specifies the ID which uniquely identifies a Virtual Machine Scale Set.
	UniqueID *string `json:"uniqueId,omitempty"`
	// SinglePlacementGroup - When true this limits the scale set to a single placement group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
	SinglePlacementGroup *bool `json:"singlePlacementGroup,omitempty"`
	// ZoneBalance - Whether to force strictly even Virtual Machine distribution cross x-zones in case there is zone outage. zoneBalance property can only be set if the zones property of the scale set contains more than one zone. If there are no zones or only one zone specified, then zoneBalance property should not be set.
	ZoneBalance *bool `json:"zoneBalance,omitempty"`
	// PlatformFaultDomainCount - Fault Domain count for each placement group.
	PlatformFaultDomainCount *int32 `json:"platformFaultDomainCount,omitempty"`
	// ProximityPlacementGroup - Specifies information about the proximity placement group that the virtual machine scale set should be assigned to. <br><br>Minimum api-version: 2018-04-01.
	ProximityPlacementGroup *SubResource `json:"proximityPlacementGroup,omitempty"`
	// HostGroup - Specifies information about the dedicated host group that the virtual machine scale set resides in. <br><br>Minimum api-version: 2020-06-01.
	HostGroup *SubResource `json:"hostGroup,omitempty"`
	// AdditionalCapabilities - Specifies additional capabilities enabled or disabled on the Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines have the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
	AdditionalCapabilities *AdditionalCapabilities `json:"additionalCapabilities,omitempty"`
	// ScaleInPolicy - Specifies the policies applied when scaling in Virtual Machines in the Virtual Machine Scale Set.
	ScaleInPolicy *ScaleInPolicy `json:"scaleInPolicy,omitempty"`
	// OrchestrationMode - Specifies the orchestration mode for the virtual machine scale set. Possible values include: 'OrchestrationModeUniform', 'OrchestrationModeFlexible'
	OrchestrationMode OrchestrationMode `json:"orchestrationMode,omitempty"`
	// SpotRestorePolicy - Specifies the Spot Restore properties for the virtual machine scale set.
	SpotRestorePolicy *SpotRestorePolicy `json:"spotRestorePolicy,omitempty"`
	// TimeCreated - READ-ONLY; Specifies the time at which the Virtual Machine Scale Set resource was created.<br><br>Minimum api-version: 2021-11-01.
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetProperties.
func (vmssp VirtualMachineScaleSetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmssp.UpgradePolicy != nil {
		objectMap["upgradePolicy"] = vmssp.UpgradePolicy
	}
	if vmssp.AutomaticRepairsPolicy != nil {
		objectMap["automaticRepairsPolicy"] = vmssp.AutomaticRepairsPolicy
	}
	if vmssp.VirtualMachineProfile != nil {
		objectMap["virtualMachineProfile"] = vmssp.VirtualMachineProfile
	}
	if vmssp.Overprovision != nil {
		objectMap["overprovision"] = vmssp.Overprovision
	}
	if vmssp.DoNotRunExtensionsOnOverprovisionedVMs != nil {
		objectMap["doNotRunExtensionsOnOverprovisionedVMs"] = vmssp.DoNotRunExtensionsOnOverprovisionedVMs
	}
	if vmssp.SinglePlacementGroup != nil {
		objectMap["singlePlacementGroup"] = vmssp.SinglePlacementGroup
	}
	if vmssp.ZoneBalance != nil {
		objectMap["zoneBalance"] = vmssp.ZoneBalance
	}
	if vmssp.PlatformFaultDomainCount != nil {
		objectMap["platformFaultDomainCount"] = vmssp.PlatformFaultDomainCount
	}
	if vmssp.ProximityPlacementGroup != nil {
		objectMap["proximityPlacementGroup"] = vmssp.ProximityPlacementGroup
	}
	if vmssp.HostGroup != nil {
		objectMap["hostGroup"] = vmssp.HostGroup
	}
	if vmssp.AdditionalCapabilities != nil {
		objectMap["additionalCapabilities"] = vmssp.AdditionalCapabilities
	}
	if vmssp.ScaleInPolicy != nil {
		objectMap["scaleInPolicy"] = vmssp.ScaleInPolicy
	}
	if vmssp.OrchestrationMode != "" {
		objectMap["orchestrationMode"] = vmssp.OrchestrationMode
	}
	if vmssp.SpotRestorePolicy != nil {
		objectMap["spotRestorePolicy"] = vmssp.SpotRestorePolicy
	}
	return json.Marshal(objectMap)
}

// VirtualMachineScaleSetPublicIPAddressConfiguration describes a virtual machines scale set IP
// Configuration's PublicIPAddress configuration
type VirtualMachineScaleSetPublicIPAddressConfiguration struct {
	// Name - The publicIP address configuration name.
	Name                                                          *string `json:"name,omitempty"`
	*VirtualMachineScaleSetPublicIPAddressConfigurationProperties `json:"properties,omitempty"`
	Sku                                                           *PublicIPAddressSku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetPublicIPAddressConfiguration.
func (vmsspiac VirtualMachineScaleSetPublicIPAddressConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmsspiac.Name != nil {
		objectMap["name"] = vmsspiac.Name
	}
	if vmsspiac.VirtualMachineScaleSetPublicIPAddressConfigurationProperties != nil {
		objectMap["properties"] = vmsspiac.VirtualMachineScaleSetPublicIPAddressConfigurationProperties
	}
	if vmsspiac.Sku != nil {
		objectMap["sku"] = vmsspiac.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineScaleSetPublicIPAddressConfiguration struct.
func (vmsspiac *VirtualMachineScaleSetPublicIPAddressConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmsspiac.Name = &name
			}
		case "properties":
			if v != nil {
				var virtualMachineScaleSetPublicIPAddressConfigurationProperties VirtualMachineScaleSetPublicIPAddressConfigurationProperties
				err = json.Unmarshal(*v, &virtualMachineScaleSetPublicIPAddressConfigurationProperties)
				if err != nil {
					return err
				}
				vmsspiac.VirtualMachineScaleSetPublicIPAddressConfigurationProperties = &virtualMachineScaleSetPublicIPAddressConfigurationProperties
			}
		case "sku":
			if v != nil {
				var sku PublicIPAddressSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				vmsspiac.Sku = &sku
			}
		}
	}

	return nil
}

// VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings describes a virtual machines scale sets
// network configuration's DNS settings.
type VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings struct {
	// DomainNameLabel - The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`
}

// VirtualMachineScaleSetPublicIPAddressConfigurationProperties describes a virtual machines scale set IP
// Configuration's PublicIPAddress configuration
type VirtualMachineScaleSetPublicIPAddressConfigurationProperties struct {
	// IdleTimeoutInMinutes - The idle timeout of the public IP address.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// DNSSettings - The dns settings to be applied on the publicIP addresses .
	DNSSettings *VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings `json:"dnsSettings,omitempty"`
	// IPTags - The list of IP tags associated with the public IP address.
	IPTags *[]VirtualMachineScaleSetIPTag `json:"ipTags,omitempty"`
	// PublicIPPrefix - The PublicIPPrefix from which to allocate publicIP addresses.
	PublicIPPrefix *SubResource `json:"publicIPPrefix,omitempty"`
	// PublicIPAddressVersion - Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'. Possible values include: 'IPVersionIPv4', 'IPVersionIPv6'
	PublicIPAddressVersion IPVersion `json:"publicIPAddressVersion,omitempty"`
	// DeleteOption - Specify what happens to the public IP when the VM is deleted. Possible values include: 'DeleteOptionsDelete', 'DeleteOptionsDetach'
	DeleteOption DeleteOptions `json:"deleteOption,omitempty"`
}

// VirtualMachineScaleSetReimageParameters describes a Virtual Machine Scale Set VM Reimage Parameters.
type VirtualMachineScaleSetReimageParameters struct {
	// InstanceIds - The virtual machine scale set instance ids. Omitting the virtual machine scale set instance ids will result in the operation being performed on all virtual machines in the virtual machine scale set.
	InstanceIds *[]string `json:"instanceIds,omitempty"`
	// TempDisk - Specifies whether to reimage temp disk. Default value: false. Note: This temp disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
	TempDisk *bool `json:"tempDisk,omitempty"`
}

// VirtualMachineScaleSetRollingUpgradesCancelFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type VirtualMachineScaleSetRollingUpgradesCancelFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetRollingUpgradesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetRollingUpgradesCancelFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetRollingUpgradesCancelFuture.Result.
func (future *VirtualMachineScaleSetRollingUpgradesCancelFuture) result(client VirtualMachineScaleSetRollingUpgradesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetRollingUpgradesCancelFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetRollingUpgradesCancelFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetRollingUpgradesStartExtensionUpgradeFuture an abstraction for monitoring and
// retrieving the results of a long-running operation.
type VirtualMachineScaleSetRollingUpgradesStartExtensionUpgradeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetRollingUpgradesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetRollingUpgradesStartExtensionUpgradeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetRollingUpgradesStartExtensionUpgradeFuture.Result.
func (future *VirtualMachineScaleSetRollingUpgradesStartExtensionUpgradeFuture) result(client VirtualMachineScaleSetRollingUpgradesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetRollingUpgradesStartExtensionUpgradeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetRollingUpgradesStartExtensionUpgradeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetRollingUpgradesStartOSUpgradeFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type VirtualMachineScaleSetRollingUpgradesStartOSUpgradeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetRollingUpgradesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetRollingUpgradesStartOSUpgradeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetRollingUpgradesStartOSUpgradeFuture.Result.
func (future *VirtualMachineScaleSetRollingUpgradesStartOSUpgradeFuture) result(client VirtualMachineScaleSetRollingUpgradesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetRollingUpgradesStartOSUpgradeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetRollingUpgradesStartOSUpgradeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type VirtualMachineScaleSetsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetsClient) (VirtualMachineScaleSet, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetsCreateOrUpdateFuture.Result.
func (future *VirtualMachineScaleSetsCreateOrUpdateFuture) result(client VirtualMachineScaleSetsClient) (vmss VirtualMachineScaleSet, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vmss.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vmss.Response.Response, err = future.GetResult(sender); err == nil && vmss.Response.Response.StatusCode != http.StatusNoContent {
		vmss, err = client.CreateOrUpdateResponder(vmss.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsCreateOrUpdateFuture", "Result", vmss.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineScaleSetsDeallocateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetsDeallocateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetsDeallocateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetsDeallocateFuture.Result.
func (future *VirtualMachineScaleSetsDeallocateFuture) result(client VirtualMachineScaleSetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsDeallocateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetsDeallocateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetsDeleteFuture.Result.
func (future *VirtualMachineScaleSetsDeleteFuture) result(client VirtualMachineScaleSetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetsDeleteInstancesFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type VirtualMachineScaleSetsDeleteInstancesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetsDeleteInstancesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetsDeleteInstancesFuture.Result.
func (future *VirtualMachineScaleSetsDeleteInstancesFuture) result(client VirtualMachineScaleSetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsDeleteInstancesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetsDeleteInstancesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetSku describes an available virtual machine scale set sku.
type VirtualMachineScaleSetSku struct {
	// ResourceType - READ-ONLY; The type of resource the sku applies to.
	ResourceType *string `json:"resourceType,omitempty"`
	// Sku - READ-ONLY; The Sku.
	Sku *Sku `json:"sku,omitempty"`
	// Capacity - READ-ONLY; Specifies the number of virtual machines in the scale set.
	Capacity *VirtualMachineScaleSetSkuCapacity `json:"capacity,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetSku.
func (vmsss VirtualMachineScaleSetSku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachineScaleSetSkuCapacity describes scaling information of a sku.
type VirtualMachineScaleSetSkuCapacity struct {
	// Minimum - READ-ONLY; The minimum capacity.
	Minimum *int64 `json:"minimum,omitempty"`
	// Maximum - READ-ONLY; The maximum capacity that can be set.
	Maximum *int64 `json:"maximum,omitempty"`
	// DefaultCapacity - READ-ONLY; The default capacity.
	DefaultCapacity *int64 `json:"defaultCapacity,omitempty"`
	// ScaleType - READ-ONLY; The scale type applicable to the sku. Possible values include: 'VirtualMachineScaleSetSkuScaleTypeAutomatic', 'VirtualMachineScaleSetSkuScaleTypeNone'
	ScaleType VirtualMachineScaleSetSkuScaleType `json:"scaleType,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetSkuCapacity.
func (vmsssc VirtualMachineScaleSetSkuCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachineScaleSetsPerformMaintenanceFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type VirtualMachineScaleSetsPerformMaintenanceFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetsPerformMaintenanceFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetsPerformMaintenanceFuture.Result.
func (future *VirtualMachineScaleSetsPerformMaintenanceFuture) result(client VirtualMachineScaleSetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsPerformMaintenanceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetsPerformMaintenanceFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetsPowerOffFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetsPowerOffFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetsPowerOffFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetsPowerOffFuture.Result.
func (future *VirtualMachineScaleSetsPowerOffFuture) result(client VirtualMachineScaleSetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsPowerOffFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetsPowerOffFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetsRedeployFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetsRedeployFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetsRedeployFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetsRedeployFuture.Result.
func (future *VirtualMachineScaleSetsRedeployFuture) result(client VirtualMachineScaleSetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsRedeployFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetsRedeployFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetsReimageAllFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetsReimageAllFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetsReimageAllFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetsReimageAllFuture.Result.
func (future *VirtualMachineScaleSetsReimageAllFuture) result(client VirtualMachineScaleSetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsReimageAllFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetsReimageAllFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetsReimageFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetsReimageFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetsReimageFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetsReimageFuture.Result.
func (future *VirtualMachineScaleSetsReimageFuture) result(client VirtualMachineScaleSetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsReimageFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetsReimageFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetsRestartFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetsRestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetsRestartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetsRestartFuture.Result.
func (future *VirtualMachineScaleSetsRestartFuture) result(client VirtualMachineScaleSetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetsRestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetsSetOrchestrationServiceStateFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type VirtualMachineScaleSetsSetOrchestrationServiceStateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetsSetOrchestrationServiceStateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetsSetOrchestrationServiceStateFuture.Result.
func (future *VirtualMachineScaleSetsSetOrchestrationServiceStateFuture) result(client VirtualMachineScaleSetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsSetOrchestrationServiceStateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetsSetOrchestrationServiceStateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetsStartFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetsStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetsStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetsStartFuture.Result.
func (future *VirtualMachineScaleSetsStartFuture) result(client VirtualMachineScaleSetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetsStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetStorageProfile describes a virtual machine scale set storage profile.
type VirtualMachineScaleSetStorageProfile struct {
	// ImageReference - Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
	ImageReference *ImageReference `json:"imageReference,omitempty"`
	// OsDisk - Specifies information about the operating system disk used by the virtual machines in the scale set. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
	OsDisk *VirtualMachineScaleSetOSDisk `json:"osDisk,omitempty"`
	// DataDisks - Specifies the parameters that are used to add data disks to the virtual machines in the scale set. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
	DataDisks *[]VirtualMachineScaleSetDataDisk `json:"dataDisks,omitempty"`
}

// VirtualMachineScaleSetsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetsClient) (VirtualMachineScaleSet, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetsUpdateFuture.Result.
func (future *VirtualMachineScaleSetsUpdateFuture) result(client VirtualMachineScaleSetsClient) (vmss VirtualMachineScaleSet, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vmss.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vmss.Response.Response, err = future.GetResult(sender); err == nil && vmss.Response.Response.StatusCode != http.StatusNoContent {
		vmss, err = client.UpdateResponder(vmss.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsUpdateFuture", "Result", vmss.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineScaleSetsUpdateInstancesFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type VirtualMachineScaleSetsUpdateInstancesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetsUpdateInstancesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetsUpdateInstancesFuture.Result.
func (future *VirtualMachineScaleSetsUpdateInstancesFuture) result(client VirtualMachineScaleSetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetsUpdateInstancesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetsUpdateInstancesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetUpdate describes a Virtual Machine Scale Set.
type VirtualMachineScaleSetUpdate struct {
	// Sku - The virtual machine scale set sku.
	Sku *Sku `json:"sku,omitempty"`
	// Plan - The purchase plan when deploying a virtual machine scale set from VM Marketplace images.
	Plan                                    *Plan `json:"plan,omitempty"`
	*VirtualMachineScaleSetUpdateProperties `json:"properties,omitempty"`
	// Identity - The identity of the virtual machine scale set, if configured.
	Identity *VirtualMachineScaleSetIdentity `json:"identity,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetUpdate.
func (vmssu VirtualMachineScaleSetUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmssu.Sku != nil {
		objectMap["sku"] = vmssu.Sku
	}
	if vmssu.Plan != nil {
		objectMap["plan"] = vmssu.Plan
	}
	if vmssu.VirtualMachineScaleSetUpdateProperties != nil {
		objectMap["properties"] = vmssu.VirtualMachineScaleSetUpdateProperties
	}
	if vmssu.Identity != nil {
		objectMap["identity"] = vmssu.Identity
	}
	if vmssu.Tags != nil {
		objectMap["tags"] = vmssu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineScaleSetUpdate struct.
func (vmssu *VirtualMachineScaleSetUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				vmssu.Sku = &sku
			}
		case "plan":
			if v != nil {
				var plan Plan
				err = json.Unmarshal(*v, &plan)
				if err != nil {
					return err
				}
				vmssu.Plan = &plan
			}
		case "properties":
			if v != nil {
				var virtualMachineScaleSetUpdateProperties VirtualMachineScaleSetUpdateProperties
				err = json.Unmarshal(*v, &virtualMachineScaleSetUpdateProperties)
				if err != nil {
					return err
				}
				vmssu.VirtualMachineScaleSetUpdateProperties = &virtualMachineScaleSetUpdateProperties
			}
		case "identity":
			if v != nil {
				var identity VirtualMachineScaleSetIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				vmssu.Identity = &identity
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vmssu.Tags = tags
			}
		}
	}

	return nil
}

// VirtualMachineScaleSetUpdateIPConfiguration describes a virtual machine scale set network profile's IP
// configuration. NOTE: The subnet of a scale set may be modified as long as the original subnet and the
// new subnet are in the same virtual network
type VirtualMachineScaleSetUpdateIPConfiguration struct {
	// Name - The IP configuration name.
	Name                                                   *string `json:"name,omitempty"`
	*VirtualMachineScaleSetUpdateIPConfigurationProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetUpdateIPConfiguration.
func (vmssuic VirtualMachineScaleSetUpdateIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmssuic.Name != nil {
		objectMap["name"] = vmssuic.Name
	}
	if vmssuic.VirtualMachineScaleSetUpdateIPConfigurationProperties != nil {
		objectMap["properties"] = vmssuic.VirtualMachineScaleSetUpdateIPConfigurationProperties
	}
	if vmssuic.ID != nil {
		objectMap["id"] = vmssuic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineScaleSetUpdateIPConfiguration struct.
func (vmssuic *VirtualMachineScaleSetUpdateIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmssuic.Name = &name
			}
		case "properties":
			if v != nil {
				var virtualMachineScaleSetUpdateIPConfigurationProperties VirtualMachineScaleSetUpdateIPConfigurationProperties
				err = json.Unmarshal(*v, &virtualMachineScaleSetUpdateIPConfigurationProperties)
				if err != nil {
					return err
				}
				vmssuic.VirtualMachineScaleSetUpdateIPConfigurationProperties = &virtualMachineScaleSetUpdateIPConfigurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vmssuic.ID = &ID
			}
		}
	}

	return nil
}

// VirtualMachineScaleSetUpdateIPConfigurationProperties describes a virtual machine scale set network
// profile's IP configuration properties.
type VirtualMachineScaleSetUpdateIPConfigurationProperties struct {
	// Subnet - The subnet.
	Subnet *APIEntityReference `json:"subnet,omitempty"`
	// Primary - Specifies the primary IP Configuration in case the network interface has more than one IP Configuration.
	Primary *bool `json:"primary,omitempty"`
	// PublicIPAddressConfiguration - The publicIPAddressConfiguration.
	PublicIPAddressConfiguration *VirtualMachineScaleSetUpdatePublicIPAddressConfiguration `json:"publicIPAddressConfiguration,omitempty"`
	// PrivateIPAddressVersion - Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'. Possible values include: 'IPVersionIPv4', 'IPVersionIPv6'
	PrivateIPAddressVersion IPVersion `json:"privateIPAddressVersion,omitempty"`
	// ApplicationGatewayBackendAddressPools - The application gateway backend address pools.
	ApplicationGatewayBackendAddressPools *[]SubResource `json:"applicationGatewayBackendAddressPools,omitempty"`
	// ApplicationSecurityGroups - Specifies an array of references to application security group.
	ApplicationSecurityGroups *[]SubResource `json:"applicationSecurityGroups,omitempty"`
	// LoadBalancerBackendAddressPools - The load balancer backend address pools.
	LoadBalancerBackendAddressPools *[]SubResource `json:"loadBalancerBackendAddressPools,omitempty"`
	// LoadBalancerInboundNatPools - The load balancer inbound nat pools.
	LoadBalancerInboundNatPools *[]SubResource `json:"loadBalancerInboundNatPools,omitempty"`
}

// VirtualMachineScaleSetUpdateNetworkConfiguration describes a virtual machine scale set network profile's
// network configurations.
type VirtualMachineScaleSetUpdateNetworkConfiguration struct {
	// Name - The network configuration name.
	Name                                                        *string `json:"name,omitempty"`
	*VirtualMachineScaleSetUpdateNetworkConfigurationProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetUpdateNetworkConfiguration.
func (vmssunc VirtualMachineScaleSetUpdateNetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmssunc.Name != nil {
		objectMap["name"] = vmssunc.Name
	}
	if vmssunc.VirtualMachineScaleSetUpdateNetworkConfigurationProperties != nil {
		objectMap["properties"] = vmssunc.VirtualMachineScaleSetUpdateNetworkConfigurationProperties
	}
	if vmssunc.ID != nil {
		objectMap["id"] = vmssunc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineScaleSetUpdateNetworkConfiguration struct.
func (vmssunc *VirtualMachineScaleSetUpdateNetworkConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmssunc.Name = &name
			}
		case "properties":
			if v != nil {
				var virtualMachineScaleSetUpdateNetworkConfigurationProperties VirtualMachineScaleSetUpdateNetworkConfigurationProperties
				err = json.Unmarshal(*v, &virtualMachineScaleSetUpdateNetworkConfigurationProperties)
				if err != nil {
					return err
				}
				vmssunc.VirtualMachineScaleSetUpdateNetworkConfigurationProperties = &virtualMachineScaleSetUpdateNetworkConfigurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vmssunc.ID = &ID
			}
		}
	}

	return nil
}

// VirtualMachineScaleSetUpdateNetworkConfigurationProperties describes a virtual machine scale set
// updatable network profile's IP configuration.Use this object for updating network profile's IP
// Configuration.
type VirtualMachineScaleSetUpdateNetworkConfigurationProperties struct {
	// Primary - Whether this is a primary NIC on a virtual machine.
	Primary *bool `json:"primary,omitempty"`
	// EnableAcceleratedNetworking - Specifies whether the network interface is accelerated networking-enabled.
	EnableAcceleratedNetworking *bool `json:"enableAcceleratedNetworking,omitempty"`
	// EnableFpga - Specifies whether the network interface is FPGA networking-enabled.
	EnableFpga *bool `json:"enableFpga,omitempty"`
	// NetworkSecurityGroup - The network security group.
	NetworkSecurityGroup *SubResource `json:"networkSecurityGroup,omitempty"`
	// DNSSettings - The dns settings to be applied on the network interfaces.
	DNSSettings *VirtualMachineScaleSetNetworkConfigurationDNSSettings `json:"dnsSettings,omitempty"`
	// IPConfigurations - The virtual machine scale set IP Configuration.
	IPConfigurations *[]VirtualMachineScaleSetUpdateIPConfiguration `json:"ipConfigurations,omitempty"`
	// EnableIPForwarding - Whether IP forwarding enabled on this NIC.
	EnableIPForwarding *bool `json:"enableIPForwarding,omitempty"`
	// DeleteOption - Specify what happens to the network interface when the VM is deleted. Possible values include: 'DeleteOptionsDelete', 'DeleteOptionsDetach'
	DeleteOption DeleteOptions `json:"deleteOption,omitempty"`
}

// VirtualMachineScaleSetUpdateNetworkProfile describes a virtual machine scale set network profile.
type VirtualMachineScaleSetUpdateNetworkProfile struct {
	// HealthProbe - A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The reference will be in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
	HealthProbe *APIEntityReference `json:"healthProbe,omitempty"`
	// NetworkInterfaceConfigurations - The list of network configurations.
	NetworkInterfaceConfigurations *[]VirtualMachineScaleSetUpdateNetworkConfiguration `json:"networkInterfaceConfigurations,omitempty"`
	// NetworkAPIVersion - specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations for Virtual Machine Scale Set with orchestration mode 'Flexible'. Possible values include: 'NetworkAPIVersionTwoZeroTwoZeroHyphenMinusOneOneHyphenMinusZeroOne'
	NetworkAPIVersion NetworkAPIVersion `json:"networkApiVersion,omitempty"`
}

// VirtualMachineScaleSetUpdateOSDisk describes virtual machine scale set operating system disk Update
// Object. This should be used for Updating VMSS OS Disk.
type VirtualMachineScaleSetUpdateOSDisk struct {
	// Caching - The caching type. Possible values include: 'CachingTypesNone', 'CachingTypesReadOnly', 'CachingTypesReadWrite'
	Caching CachingTypes `json:"caching,omitempty"`
	// WriteAcceleratorEnabled - Specifies whether writeAccelerator should be enabled or disabled on the disk.
	WriteAcceleratorEnabled *bool `json:"writeAcceleratorEnabled,omitempty"`
	// DiskSizeGB - Specifies the size of the operating system disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
	// Image - The Source User Image VirtualHardDisk. This VirtualHardDisk will be copied before using it to attach to the Virtual Machine. If SourceImage is provided, the destination VirtualHardDisk should not exist.
	Image *VirtualHardDisk `json:"image,omitempty"`
	// VhdContainers - The list of virtual hard disk container uris.
	VhdContainers *[]string `json:"vhdContainers,omitempty"`
	// ManagedDisk - The managed disk parameters.
	ManagedDisk *VirtualMachineScaleSetManagedDiskParameters `json:"managedDisk,omitempty"`
}

// VirtualMachineScaleSetUpdateOSProfile describes a virtual machine scale set OS profile.
type VirtualMachineScaleSetUpdateOSProfile struct {
	// CustomData - A base-64 encoded string of custom data.
	CustomData *string `json:"customData,omitempty"`
	// WindowsConfiguration - The Windows Configuration of the OS profile.
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
	// LinuxConfiguration - The Linux Configuration of the OS profile.
	LinuxConfiguration *LinuxConfiguration `json:"linuxConfiguration,omitempty"`
	// Secrets - The List of certificates for addition to the VM.
	Secrets *[]VaultSecretGroup `json:"secrets,omitempty"`
}

// VirtualMachineScaleSetUpdateProperties describes the properties of a Virtual Machine Scale Set.
type VirtualMachineScaleSetUpdateProperties struct {
	// UpgradePolicy - The upgrade policy.
	UpgradePolicy *UpgradePolicy `json:"upgradePolicy,omitempty"`
	// AutomaticRepairsPolicy - Policy for automatic repairs.
	AutomaticRepairsPolicy *AutomaticRepairsPolicy `json:"automaticRepairsPolicy,omitempty"`
	// VirtualMachineProfile - The virtual machine profile.
	VirtualMachineProfile *VirtualMachineScaleSetUpdateVMProfile `json:"virtualMachineProfile,omitempty"`
	// Overprovision - Specifies whether the Virtual Machine Scale Set should be overprovisioned.
	Overprovision *bool `json:"overprovision,omitempty"`
	// DoNotRunExtensionsOnOverprovisionedVMs - When Overprovision is enabled, extensions are launched only on the requested number of VMs which are finally kept. This property will hence ensure that the extensions do not run on the extra overprovisioned VMs.
	DoNotRunExtensionsOnOverprovisionedVMs *bool `json:"doNotRunExtensionsOnOverprovisionedVMs,omitempty"`
	// SinglePlacementGroup - When true this limits the scale set to a single placement group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
	SinglePlacementGroup *bool `json:"singlePlacementGroup,omitempty"`
	// AdditionalCapabilities - Specifies additional capabilities enabled or disabled on the Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines have the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
	AdditionalCapabilities *AdditionalCapabilities `json:"additionalCapabilities,omitempty"`
	// ScaleInPolicy - Specifies the policies applied when scaling in Virtual Machines in the Virtual Machine Scale Set.
	ScaleInPolicy *ScaleInPolicy `json:"scaleInPolicy,omitempty"`
	// ProximityPlacementGroup - Specifies information about the proximity placement group that the virtual machine scale set should be assigned to. <br><br>Minimum api-version: 2018-04-01.
	ProximityPlacementGroup *SubResource `json:"proximityPlacementGroup,omitempty"`
}

// VirtualMachineScaleSetUpdatePublicIPAddressConfiguration describes a virtual machines scale set IP
// Configuration's PublicIPAddress configuration
type VirtualMachineScaleSetUpdatePublicIPAddressConfiguration struct {
	// Name - The publicIP address configuration name.
	Name                                                                *string `json:"name,omitempty"`
	*VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetUpdatePublicIPAddressConfiguration.
func (vmssupiac VirtualMachineScaleSetUpdatePublicIPAddressConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmssupiac.Name != nil {
		objectMap["name"] = vmssupiac.Name
	}
	if vmssupiac.VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties != nil {
		objectMap["properties"] = vmssupiac.VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineScaleSetUpdatePublicIPAddressConfiguration struct.
func (vmssupiac *VirtualMachineScaleSetUpdatePublicIPAddressConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmssupiac.Name = &name
			}
		case "properties":
			if v != nil {
				var virtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties
				err = json.Unmarshal(*v, &virtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties)
				if err != nil {
					return err
				}
				vmssupiac.VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties = &virtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties
			}
		}
	}

	return nil
}

// VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties describes a virtual machines scale
// set IP Configuration's PublicIPAddress configuration
type VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties struct {
	// IdleTimeoutInMinutes - The idle timeout of the public IP address.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// DNSSettings - The dns settings to be applied on the publicIP addresses .
	DNSSettings *VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings `json:"dnsSettings,omitempty"`
	// PublicIPPrefix - The PublicIPPrefix from which to allocate publicIP addresses.
	PublicIPPrefix *SubResource `json:"publicIPPrefix,omitempty"`
	// DeleteOption - Specify what happens to the public IP when the VM is deleted. Possible values include: 'DeleteOptionsDelete', 'DeleteOptionsDetach'
	DeleteOption DeleteOptions `json:"deleteOption,omitempty"`
}

// VirtualMachineScaleSetUpdateStorageProfile describes a virtual machine scale set storage profile.
type VirtualMachineScaleSetUpdateStorageProfile struct {
	// ImageReference - The image reference.
	ImageReference *ImageReference `json:"imageReference,omitempty"`
	// OsDisk - The OS disk.
	OsDisk *VirtualMachineScaleSetUpdateOSDisk `json:"osDisk,omitempty"`
	// DataDisks - The data disks.
	DataDisks *[]VirtualMachineScaleSetDataDisk `json:"dataDisks,omitempty"`
}

// VirtualMachineScaleSetUpdateVMProfile describes a virtual machine scale set virtual machine profile.
type VirtualMachineScaleSetUpdateVMProfile struct {
	// OsProfile - The virtual machine scale set OS profile.
	OsProfile *VirtualMachineScaleSetUpdateOSProfile `json:"osProfile,omitempty"`
	// StorageProfile - The virtual machine scale set storage profile.
	StorageProfile *VirtualMachineScaleSetUpdateStorageProfile `json:"storageProfile,omitempty"`
	// NetworkProfile - The virtual machine scale set network profile.
	NetworkProfile *VirtualMachineScaleSetUpdateNetworkProfile `json:"networkProfile,omitempty"`
	// SecurityProfile - The virtual machine scale set Security profile
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`
	// DiagnosticsProfile - The virtual machine scale set diagnostics profile.
	DiagnosticsProfile *DiagnosticsProfile `json:"diagnosticsProfile,omitempty"`
	// ExtensionProfile - The virtual machine scale set extension profile.
	ExtensionProfile *VirtualMachineScaleSetExtensionProfile `json:"extensionProfile,omitempty"`
	// LicenseType - The license type, which is for bring your own license scenario.
	LicenseType *string `json:"licenseType,omitempty"`
	// BillingProfile - Specifies the billing related details of a Azure Spot VMSS. <br><br>Minimum api-version: 2019-03-01.
	BillingProfile *BillingProfile `json:"billingProfile,omitempty"`
	// ScheduledEventsProfile - Specifies Scheduled Event related configurations.
	ScheduledEventsProfile *ScheduledEventsProfile `json:"scheduledEventsProfile,omitempty"`
	// UserData - UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here. <br><br>Minimum api-version: 2021-03-01
	UserData *string `json:"userData,omitempty"`
}

// VirtualMachineScaleSetVM describes a virtual machine scale set virtual machine.
type VirtualMachineScaleSetVM struct {
	autorest.Response `json:"-"`
	// InstanceID - READ-ONLY; The virtual machine instance ID.
	InstanceID *string `json:"instanceId,omitempty"`
	// Sku - READ-ONLY; The virtual machine SKU.
	Sku                                 *Sku `json:"sku,omitempty"`
	*VirtualMachineScaleSetVMProperties `json:"properties,omitempty"`
	// Plan - Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
	Plan *Plan `json:"plan,omitempty"`
	// Resources - READ-ONLY; The virtual machine child extension resources.
	Resources *[]VirtualMachineExtension `json:"resources,omitempty"`
	// Zones - READ-ONLY; The virtual machine zones.
	Zones *[]string `json:"zones,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetVM.
func (vmssv VirtualMachineScaleSetVM) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmssv.VirtualMachineScaleSetVMProperties != nil {
		objectMap["properties"] = vmssv.VirtualMachineScaleSetVMProperties
	}
	if vmssv.Plan != nil {
		objectMap["plan"] = vmssv.Plan
	}
	if vmssv.Location != nil {
		objectMap["location"] = vmssv.Location
	}
	if vmssv.Tags != nil {
		objectMap["tags"] = vmssv.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineScaleSetVM struct.
func (vmssv *VirtualMachineScaleSetVM) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "instanceId":
			if v != nil {
				var instanceID string
				err = json.Unmarshal(*v, &instanceID)
				if err != nil {
					return err
				}
				vmssv.InstanceID = &instanceID
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				vmssv.Sku = &sku
			}
		case "properties":
			if v != nil {
				var virtualMachineScaleSetVMProperties VirtualMachineScaleSetVMProperties
				err = json.Unmarshal(*v, &virtualMachineScaleSetVMProperties)
				if err != nil {
					return err
				}
				vmssv.VirtualMachineScaleSetVMProperties = &virtualMachineScaleSetVMProperties
			}
		case "plan":
			if v != nil {
				var plan Plan
				err = json.Unmarshal(*v, &plan)
				if err != nil {
					return err
				}
				vmssv.Plan = &plan
			}
		case "resources":
			if v != nil {
				var resources []VirtualMachineExtension
				err = json.Unmarshal(*v, &resources)
				if err != nil {
					return err
				}
				vmssv.Resources = &resources
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				vmssv.Zones = &zones
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vmssv.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmssv.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vmssv.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vmssv.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vmssv.Tags = tags
			}
		}
	}

	return nil
}

// VirtualMachineScaleSetVMExtension describes a VMSS VM Extension.
type VirtualMachineScaleSetVMExtension struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; The name of the extension.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type                               *string `json:"type,omitempty"`
	*VirtualMachineExtensionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetVMExtension.
func (vmssve VirtualMachineScaleSetVMExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmssve.VirtualMachineExtensionProperties != nil {
		objectMap["properties"] = vmssve.VirtualMachineExtensionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineScaleSetVMExtension struct.
func (vmssve *VirtualMachineScaleSetVMExtension) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmssve.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vmssve.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var virtualMachineExtensionProperties VirtualMachineExtensionProperties
				err = json.Unmarshal(*v, &virtualMachineExtensionProperties)
				if err != nil {
					return err
				}
				vmssve.VirtualMachineExtensionProperties = &virtualMachineExtensionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vmssve.ID = &ID
			}
		}
	}

	return nil
}

// VirtualMachineScaleSetVMExtensionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type VirtualMachineScaleSetVMExtensionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMExtensionsClient) (VirtualMachineScaleSetVMExtension, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMExtensionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMExtensionsCreateOrUpdateFuture.Result.
func (future *VirtualMachineScaleSetVMExtensionsCreateOrUpdateFuture) result(client VirtualMachineScaleSetVMExtensionsClient) (vmssve VirtualMachineScaleSetVMExtension, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMExtensionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vmssve.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMExtensionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vmssve.Response.Response, err = future.GetResult(sender); err == nil && vmssve.Response.Response.StatusCode != http.StatusNoContent {
		vmssve, err = client.CreateOrUpdateResponder(vmssve.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMExtensionsCreateOrUpdateFuture", "Result", vmssve.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineScaleSetVMExtensionsDeleteFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type VirtualMachineScaleSetVMExtensionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMExtensionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMExtensionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMExtensionsDeleteFuture.Result.
func (future *VirtualMachineScaleSetVMExtensionsDeleteFuture) result(client VirtualMachineScaleSetVMExtensionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMExtensionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMExtensionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetVMExtensionsListResult the List VMSS VM Extension operation response
type VirtualMachineScaleSetVMExtensionsListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of VMSS VM extensions
	Value *[]VirtualMachineScaleSetVMExtension `json:"value,omitempty"`
}

// VirtualMachineScaleSetVMExtensionsSummary extensions summary for virtual machines of a virtual machine
// scale set.
type VirtualMachineScaleSetVMExtensionsSummary struct {
	// Name - READ-ONLY; The extension name.
	Name *string `json:"name,omitempty"`
	// StatusesSummary - READ-ONLY; The extensions information.
	StatusesSummary *[]VirtualMachineStatusCodeCount `json:"statusesSummary,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetVMExtensionsSummary.
func (vmssves VirtualMachineScaleSetVMExtensionsSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachineScaleSetVMExtensionsUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type VirtualMachineScaleSetVMExtensionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMExtensionsClient) (VirtualMachineScaleSetVMExtension, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMExtensionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMExtensionsUpdateFuture.Result.
func (future *VirtualMachineScaleSetVMExtensionsUpdateFuture) result(client VirtualMachineScaleSetVMExtensionsClient) (vmssve VirtualMachineScaleSetVMExtension, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMExtensionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vmssve.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMExtensionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vmssve.Response.Response, err = future.GetResult(sender); err == nil && vmssve.Response.Response.StatusCode != http.StatusNoContent {
		vmssve, err = client.UpdateResponder(vmssve.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMExtensionsUpdateFuture", "Result", vmssve.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineScaleSetVMExtensionUpdate describes a VMSS VM Extension.
type VirtualMachineScaleSetVMExtensionUpdate struct {
	// Name - READ-ONLY; The name of the extension.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type                                     *string `json:"type,omitempty"`
	*VirtualMachineExtensionUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetVMExtensionUpdate.
func (vmssveu VirtualMachineScaleSetVMExtensionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmssveu.VirtualMachineExtensionUpdateProperties != nil {
		objectMap["properties"] = vmssveu.VirtualMachineExtensionUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineScaleSetVMExtensionUpdate struct.
func (vmssveu *VirtualMachineScaleSetVMExtensionUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmssveu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vmssveu.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var virtualMachineExtensionUpdateProperties VirtualMachineExtensionUpdateProperties
				err = json.Unmarshal(*v, &virtualMachineExtensionUpdateProperties)
				if err != nil {
					return err
				}
				vmssveu.VirtualMachineExtensionUpdateProperties = &virtualMachineExtensionUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vmssveu.ID = &ID
			}
		}
	}

	return nil
}

// VirtualMachineScaleSetVMInstanceIDs specifies a list of virtual machine instance IDs from the VM scale
// set.
type VirtualMachineScaleSetVMInstanceIDs struct {
	// InstanceIds - The virtual machine scale set instance ids. Omitting the virtual machine scale set instance ids will result in the operation being performed on all virtual machines in the virtual machine scale set.
	InstanceIds *[]string `json:"instanceIds,omitempty"`
}

// VirtualMachineScaleSetVMInstanceRequiredIDs specifies a list of virtual machine instance IDs from the VM
// scale set.
type VirtualMachineScaleSetVMInstanceRequiredIDs struct {
	// InstanceIds - The virtual machine scale set instance ids.
	InstanceIds *[]string `json:"instanceIds,omitempty"`
}

// VirtualMachineScaleSetVMInstanceView the instance view of a virtual machine scale set VM.
type VirtualMachineScaleSetVMInstanceView struct {
	autorest.Response `json:"-"`
	// PlatformUpdateDomain - The Update Domain count.
	PlatformUpdateDomain *int32 `json:"platformUpdateDomain,omitempty"`
	// PlatformFaultDomain - The Fault Domain count.
	PlatformFaultDomain *int32 `json:"platformFaultDomain,omitempty"`
	// RdpThumbPrint - The Remote desktop certificate thumbprint.
	RdpThumbPrint *string `json:"rdpThumbPrint,omitempty"`
	// VMAgent - The VM Agent running on the virtual machine.
	VMAgent *VirtualMachineAgentInstanceView `json:"vmAgent,omitempty"`
	// MaintenanceRedeployStatus - The Maintenance Operation status on the virtual machine.
	MaintenanceRedeployStatus *MaintenanceRedeployStatus `json:"maintenanceRedeployStatus,omitempty"`
	// Disks - The disks information.
	Disks *[]DiskInstanceView `json:"disks,omitempty"`
	// Extensions - The extensions information.
	Extensions *[]VirtualMachineExtensionInstanceView `json:"extensions,omitempty"`
	// VMHealth - READ-ONLY; The health status for the VM.
	VMHealth *VirtualMachineHealthStatus `json:"vmHealth,omitempty"`
	// BootDiagnostics - Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
	BootDiagnostics *BootDiagnosticsInstanceView `json:"bootDiagnostics,omitempty"`
	// Statuses - The resource status information.
	Statuses *[]InstanceViewStatus `json:"statuses,omitempty"`
	// AssignedHost - READ-ONLY; Resource id of the dedicated host, on which the virtual machine is allocated through automatic placement, when the virtual machine is associated with a dedicated host group that has automatic placement enabled. <br><br>Minimum api-version: 2020-06-01.
	AssignedHost *string `json:"assignedHost,omitempty"`
	// PlacementGroupID - The placement group in which the VM is running. If the VM is deallocated it will not have a placementGroupId.
	PlacementGroupID *string `json:"placementGroupId,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetVMInstanceView.
func (vmssviv VirtualMachineScaleSetVMInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmssviv.PlatformUpdateDomain != nil {
		objectMap["platformUpdateDomain"] = vmssviv.PlatformUpdateDomain
	}
	if vmssviv.PlatformFaultDomain != nil {
		objectMap["platformFaultDomain"] = vmssviv.PlatformFaultDomain
	}
	if vmssviv.RdpThumbPrint != nil {
		objectMap["rdpThumbPrint"] = vmssviv.RdpThumbPrint
	}
	if vmssviv.VMAgent != nil {
		objectMap["vmAgent"] = vmssviv.VMAgent
	}
	if vmssviv.MaintenanceRedeployStatus != nil {
		objectMap["maintenanceRedeployStatus"] = vmssviv.MaintenanceRedeployStatus
	}
	if vmssviv.Disks != nil {
		objectMap["disks"] = vmssviv.Disks
	}
	if vmssviv.Extensions != nil {
		objectMap["extensions"] = vmssviv.Extensions
	}
	if vmssviv.BootDiagnostics != nil {
		objectMap["bootDiagnostics"] = vmssviv.BootDiagnostics
	}
	if vmssviv.Statuses != nil {
		objectMap["statuses"] = vmssviv.Statuses
	}
	if vmssviv.PlacementGroupID != nil {
		objectMap["placementGroupId"] = vmssviv.PlacementGroupID
	}
	return json.Marshal(objectMap)
}

// VirtualMachineScaleSetVMListResult the List Virtual Machine Scale Set VMs operation response.
type VirtualMachineScaleSetVMListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of virtual machine scale sets VMs.
	Value *[]VirtualMachineScaleSetVM `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of Virtual Machine Scale Set VMs. Call ListNext() with this to fetch the next page of VMSS VMs
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetVMListResultIterator provides access to a complete listing of
// VirtualMachineScaleSetVM values.
type VirtualMachineScaleSetVMListResultIterator struct {
	i    int
	page VirtualMachineScaleSetVMListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualMachineScaleSetVMListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineScaleSetVMListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualMachineScaleSetVMListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualMachineScaleSetVMListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualMachineScaleSetVMListResultIterator) Response() VirtualMachineScaleSetVMListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualMachineScaleSetVMListResultIterator) Value() VirtualMachineScaleSetVM {
	if !iter.page.NotDone() {
		return VirtualMachineScaleSetVM{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualMachineScaleSetVMListResultIterator type.
func NewVirtualMachineScaleSetVMListResultIterator(page VirtualMachineScaleSetVMListResultPage) VirtualMachineScaleSetVMListResultIterator {
	return VirtualMachineScaleSetVMListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vmssvlr VirtualMachineScaleSetVMListResult) IsEmpty() bool {
	return vmssvlr.Value == nil || len(*vmssvlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vmssvlr VirtualMachineScaleSetVMListResult) hasNextLink() bool {
	return vmssvlr.NextLink != nil && len(*vmssvlr.NextLink) != 0
}

// virtualMachineScaleSetVMListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vmssvlr VirtualMachineScaleSetVMListResult) virtualMachineScaleSetVMListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vmssvlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vmssvlr.NextLink)))
}

// VirtualMachineScaleSetVMListResultPage contains a page of VirtualMachineScaleSetVM values.
type VirtualMachineScaleSetVMListResultPage struct {
	fn      func(context.Context, VirtualMachineScaleSetVMListResult) (VirtualMachineScaleSetVMListResult, error)
	vmssvlr VirtualMachineScaleSetVMListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualMachineScaleSetVMListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineScaleSetVMListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vmssvlr)
		if err != nil {
			return err
		}
		page.vmssvlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualMachineScaleSetVMListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualMachineScaleSetVMListResultPage) NotDone() bool {
	return !page.vmssvlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualMachineScaleSetVMListResultPage) Response() VirtualMachineScaleSetVMListResult {
	return page.vmssvlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualMachineScaleSetVMListResultPage) Values() []VirtualMachineScaleSetVM {
	if page.vmssvlr.IsEmpty() {
		return nil
	}
	return *page.vmssvlr.Value
}

// Creates a new instance of the VirtualMachineScaleSetVMListResultPage type.
func NewVirtualMachineScaleSetVMListResultPage(cur VirtualMachineScaleSetVMListResult, getNextPage func(context.Context, VirtualMachineScaleSetVMListResult) (VirtualMachineScaleSetVMListResult, error)) VirtualMachineScaleSetVMListResultPage {
	return VirtualMachineScaleSetVMListResultPage{
		fn:      getNextPage,
		vmssvlr: cur,
	}
}

// VirtualMachineScaleSetVMNetworkProfileConfiguration describes a virtual machine scale set VM network
// profile.
type VirtualMachineScaleSetVMNetworkProfileConfiguration struct {
	// NetworkInterfaceConfigurations - The list of network configurations.
	NetworkInterfaceConfigurations *[]VirtualMachineScaleSetNetworkConfiguration `json:"networkInterfaceConfigurations,omitempty"`
}

// VirtualMachineScaleSetVMProfile describes a virtual machine scale set virtual machine profile.
type VirtualMachineScaleSetVMProfile struct {
	// OsProfile - Specifies the operating system settings for the virtual machines in the scale set.
	OsProfile *VirtualMachineScaleSetOSProfile `json:"osProfile,omitempty"`
	// StorageProfile - Specifies the storage settings for the virtual machine disks.
	StorageProfile *VirtualMachineScaleSetStorageProfile `json:"storageProfile,omitempty"`
	// NetworkProfile - Specifies properties of the network interfaces of the virtual machines in the scale set.
	NetworkProfile *VirtualMachineScaleSetNetworkProfile `json:"networkProfile,omitempty"`
	// SecurityProfile - Specifies the Security related profile settings for the virtual machines in the scale set.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`
	// DiagnosticsProfile - Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
	DiagnosticsProfile *DiagnosticsProfile `json:"diagnosticsProfile,omitempty"`
	// ExtensionProfile - Specifies a collection of settings for extensions installed on virtual machines in the scale set.
	ExtensionProfile *VirtualMachineScaleSetExtensionProfile `json:"extensionProfile,omitempty"`
	// LicenseType - Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
	LicenseType *string `json:"licenseType,omitempty"`
	// Priority - Specifies the priority for the virtual machines in the scale set. <br><br>Minimum api-version: 2017-10-30-preview. Possible values include: 'VirtualMachinePriorityTypesRegular', 'VirtualMachinePriorityTypesLow', 'VirtualMachinePriorityTypesSpot'
	Priority VirtualMachinePriorityTypes `json:"priority,omitempty"`
	// EvictionPolicy - Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. <br><br>For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. <br><br>For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview. Possible values include: 'VirtualMachineEvictionPolicyTypesDeallocate', 'VirtualMachineEvictionPolicyTypesDelete'
	EvictionPolicy VirtualMachineEvictionPolicyTypes `json:"evictionPolicy,omitempty"`
	// BillingProfile - Specifies the billing related details of a Azure Spot VMSS. <br><br>Minimum api-version: 2019-03-01.
	BillingProfile *BillingProfile `json:"billingProfile,omitempty"`
	// ScheduledEventsProfile - Specifies Scheduled Event related configurations.
	ScheduledEventsProfile *ScheduledEventsProfile `json:"scheduledEventsProfile,omitempty"`
	// UserData - UserData for the virtual machines in the scale set, which must be base-64 encoded. Customer should not pass any secrets in here. <br><br>Minimum api-version: 2021-03-01
	UserData *string `json:"userData,omitempty"`
	// CapacityReservation - Specifies the capacity reservation related details of a scale set. <br><br>Minimum api-version: 2021-04-01.
	CapacityReservation *CapacityReservationProfile `json:"capacityReservation,omitempty"`
	// ApplicationProfile - Specifies the gallery applications that should be made available to the VM/VMSS
	ApplicationProfile *ApplicationProfile `json:"applicationProfile,omitempty"`
	// HardwareProfile - Specifies the hardware profile related details of a scale set. <br><br>Minimum api-version: 2021-11-01.
	HardwareProfile *VirtualMachineScaleSetHardwareProfile `json:"hardwareProfile,omitempty"`
}

// VirtualMachineScaleSetVMProperties describes the properties of a virtual machine scale set virtual
// machine.
type VirtualMachineScaleSetVMProperties struct {
	// LatestModelApplied - READ-ONLY; Specifies whether the latest model has been applied to the virtual machine.
	LatestModelApplied *bool `json:"latestModelApplied,omitempty"`
	// VMID - READ-ONLY; Azure VM unique ID.
	VMID *string `json:"vmId,omitempty"`
	// InstanceView - READ-ONLY; The virtual machine instance view.
	InstanceView *VirtualMachineScaleSetVMInstanceView `json:"instanceView,omitempty"`
	// HardwareProfile - Specifies the hardware settings for the virtual machine.
	HardwareProfile *HardwareProfile `json:"hardwareProfile,omitempty"`
	// StorageProfile - Specifies the storage settings for the virtual machine disks.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// AdditionalCapabilities - Specifies additional capabilities enabled or disabled on the virtual machine in the scale set. For instance: whether the virtual machine has the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
	AdditionalCapabilities *AdditionalCapabilities `json:"additionalCapabilities,omitempty"`
	// OsProfile - Specifies the operating system settings for the virtual machine.
	OsProfile *OSProfile `json:"osProfile,omitempty"`
	// SecurityProfile - Specifies the Security related profile settings for the virtual machine.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`
	// NetworkProfile - Specifies the network interfaces of the virtual machine.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`
	// NetworkProfileConfiguration - Specifies the network profile configuration of the virtual machine.
	NetworkProfileConfiguration *VirtualMachineScaleSetVMNetworkProfileConfiguration `json:"networkProfileConfiguration,omitempty"`
	// DiagnosticsProfile - Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
	DiagnosticsProfile *DiagnosticsProfile `json:"diagnosticsProfile,omitempty"`
	// AvailabilitySet - Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs.microsoft.com/azure/virtual-machines/availability-set-overview). <br><br> For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates) <br><br> Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to an availability set.
	AvailabilitySet *SubResource `json:"availabilitySet,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// LicenseType - Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
	LicenseType *string `json:"licenseType,omitempty"`
	// ModelDefinitionApplied - READ-ONLY; Specifies whether the model applied to the virtual machine is the model of the virtual machine scale set or the customized model for the virtual machine.
	ModelDefinitionApplied *string `json:"modelDefinitionApplied,omitempty"`
	// ProtectionPolicy - Specifies the protection policy of the virtual machine.
	ProtectionPolicy *VirtualMachineScaleSetVMProtectionPolicy `json:"protectionPolicy,omitempty"`
	// UserData - UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here. <br><br>Minimum api-version: 2021-03-01
	UserData *string `json:"userData,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineScaleSetVMProperties.
func (vmssvp VirtualMachineScaleSetVMProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmssvp.HardwareProfile != nil {
		objectMap["hardwareProfile"] = vmssvp.HardwareProfile
	}
	if vmssvp.StorageProfile != nil {
		objectMap["storageProfile"] = vmssvp.StorageProfile
	}
	if vmssvp.AdditionalCapabilities != nil {
		objectMap["additionalCapabilities"] = vmssvp.AdditionalCapabilities
	}
	if vmssvp.OsProfile != nil {
		objectMap["osProfile"] = vmssvp.OsProfile
	}
	if vmssvp.SecurityProfile != nil {
		objectMap["securityProfile"] = vmssvp.SecurityProfile
	}
	if vmssvp.NetworkProfile != nil {
		objectMap["networkProfile"] = vmssvp.NetworkProfile
	}
	if vmssvp.NetworkProfileConfiguration != nil {
		objectMap["networkProfileConfiguration"] = vmssvp.NetworkProfileConfiguration
	}
	if vmssvp.DiagnosticsProfile != nil {
		objectMap["diagnosticsProfile"] = vmssvp.DiagnosticsProfile
	}
	if vmssvp.AvailabilitySet != nil {
		objectMap["availabilitySet"] = vmssvp.AvailabilitySet
	}
	if vmssvp.LicenseType != nil {
		objectMap["licenseType"] = vmssvp.LicenseType
	}
	if vmssvp.ProtectionPolicy != nil {
		objectMap["protectionPolicy"] = vmssvp.ProtectionPolicy
	}
	if vmssvp.UserData != nil {
		objectMap["userData"] = vmssvp.UserData
	}
	return json.Marshal(objectMap)
}

// VirtualMachineScaleSetVMProtectionPolicy the protection policy of a virtual machine scale set VM.
type VirtualMachineScaleSetVMProtectionPolicy struct {
	// ProtectFromScaleIn - Indicates that the virtual machine scale set VM shouldn't be considered for deletion during a scale-in operation.
	ProtectFromScaleIn *bool `json:"protectFromScaleIn,omitempty"`
	// ProtectFromScaleSetActions - Indicates that model updates or actions (including scale-in) initiated on the virtual machine scale set should not be applied to the virtual machine scale set VM.
	ProtectFromScaleSetActions *bool `json:"protectFromScaleSetActions,omitempty"`
}

// VirtualMachineScaleSetVMReimageParameters describes a Virtual Machine Scale Set VM Reimage Parameters.
type VirtualMachineScaleSetVMReimageParameters struct {
	// TempDisk - Specifies whether to reimage temp disk. Default value: false. Note: This temp disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
	TempDisk *bool `json:"tempDisk,omitempty"`
}

// VirtualMachineScaleSetVMRunCommandsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type VirtualMachineScaleSetVMRunCommandsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMRunCommandsClient) (VirtualMachineRunCommand, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMRunCommandsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMRunCommandsCreateOrUpdateFuture.Result.
func (future *VirtualMachineScaleSetVMRunCommandsCreateOrUpdateFuture) result(client VirtualMachineScaleSetVMRunCommandsClient) (vmrc VirtualMachineRunCommand, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMRunCommandsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vmrc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMRunCommandsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vmrc.Response.Response, err = future.GetResult(sender); err == nil && vmrc.Response.Response.StatusCode != http.StatusNoContent {
		vmrc, err = client.CreateOrUpdateResponder(vmrc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMRunCommandsCreateOrUpdateFuture", "Result", vmrc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineScaleSetVMRunCommandsDeleteFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type VirtualMachineScaleSetVMRunCommandsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMRunCommandsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMRunCommandsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMRunCommandsDeleteFuture.Result.
func (future *VirtualMachineScaleSetVMRunCommandsDeleteFuture) result(client VirtualMachineScaleSetVMRunCommandsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMRunCommandsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMRunCommandsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetVMRunCommandsUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type VirtualMachineScaleSetVMRunCommandsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMRunCommandsClient) (VirtualMachineRunCommand, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMRunCommandsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMRunCommandsUpdateFuture.Result.
func (future *VirtualMachineScaleSetVMRunCommandsUpdateFuture) result(client VirtualMachineScaleSetVMRunCommandsClient) (vmrc VirtualMachineRunCommand, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMRunCommandsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vmrc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMRunCommandsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vmrc.Response.Response, err = future.GetResult(sender); err == nil && vmrc.Response.Response.StatusCode != http.StatusNoContent {
		vmrc, err = client.UpdateResponder(vmrc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMRunCommandsUpdateFuture", "Result", vmrc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineScaleSetVMsDeallocateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetVMsDeallocateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMsDeallocateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMsDeallocateFuture.Result.
func (future *VirtualMachineScaleSetVMsDeallocateFuture) result(client VirtualMachineScaleSetVMsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMsDeallocateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMsDeallocateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetVMsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetVMsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMsDeleteFuture.Result.
func (future *VirtualMachineScaleSetVMsDeleteFuture) result(client VirtualMachineScaleSetVMsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetVMsPerformMaintenanceFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type VirtualMachineScaleSetVMsPerformMaintenanceFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMsPerformMaintenanceFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMsPerformMaintenanceFuture.Result.
func (future *VirtualMachineScaleSetVMsPerformMaintenanceFuture) result(client VirtualMachineScaleSetVMsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMsPerformMaintenanceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMsPerformMaintenanceFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetVMsPowerOffFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetVMsPowerOffFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMsPowerOffFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMsPowerOffFuture.Result.
func (future *VirtualMachineScaleSetVMsPowerOffFuture) result(client VirtualMachineScaleSetVMsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMsPowerOffFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMsPowerOffFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetVMsRedeployFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetVMsRedeployFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMsRedeployFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMsRedeployFuture.Result.
func (future *VirtualMachineScaleSetVMsRedeployFuture) result(client VirtualMachineScaleSetVMsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMsRedeployFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMsRedeployFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetVMsReimageAllFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetVMsReimageAllFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMsReimageAllFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMsReimageAllFuture.Result.
func (future *VirtualMachineScaleSetVMsReimageAllFuture) result(client VirtualMachineScaleSetVMsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMsReimageAllFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMsReimageAllFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetVMsReimageFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetVMsReimageFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMsReimageFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMsReimageFuture.Result.
func (future *VirtualMachineScaleSetVMsReimageFuture) result(client VirtualMachineScaleSetVMsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMsReimageFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMsReimageFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetVMsRestartFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetVMsRestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMsRestartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMsRestartFuture.Result.
func (future *VirtualMachineScaleSetVMsRestartFuture) result(client VirtualMachineScaleSetVMsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMsRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMsRestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetVMsRunCommandFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetVMsRunCommandFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMsClient) (RunCommandResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMsRunCommandFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMsRunCommandFuture.Result.
func (future *VirtualMachineScaleSetVMsRunCommandFuture) result(client VirtualMachineScaleSetVMsClient) (rcr RunCommandResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMsRunCommandFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rcr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMsRunCommandFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rcr.Response.Response, err = future.GetResult(sender); err == nil && rcr.Response.Response.StatusCode != http.StatusNoContent {
		rcr, err = client.RunCommandResponder(rcr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMsRunCommandFuture", "Result", rcr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineScaleSetVMsStartFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetVMsStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMsStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMsStartFuture.Result.
func (future *VirtualMachineScaleSetVMsStartFuture) result(client VirtualMachineScaleSetVMsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMsStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineScaleSetVMsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineScaleSetVMsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineScaleSetVMsClient) (VirtualMachineScaleSetVM, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineScaleSetVMsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineScaleSetVMsUpdateFuture.Result.
func (future *VirtualMachineScaleSetVMsUpdateFuture) result(client VirtualMachineScaleSetVMsClient) (vmssv VirtualMachineScaleSetVM, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vmssv.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachineScaleSetVMsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vmssv.Response.Response, err = future.GetResult(sender); err == nil && vmssv.Response.Response.StatusCode != http.StatusNoContent {
		vmssv, err = client.UpdateResponder(vmssv.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachineScaleSetVMsUpdateFuture", "Result", vmssv.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachinesCaptureFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesCaptureFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (VirtualMachineCaptureResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesCaptureFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesCaptureFuture.Result.
func (future *VirtualMachinesCaptureFuture) result(client VirtualMachinesClient) (vmcr VirtualMachineCaptureResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesCaptureFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vmcr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesCaptureFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vmcr.Response.Response, err = future.GetResult(sender); err == nil && vmcr.Response.Response.StatusCode != http.StatusNoContent {
		vmcr, err = client.CaptureResponder(vmcr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachinesCaptureFuture", "Result", vmcr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachinesConvertToManagedDisksFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesConvertToManagedDisksFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesConvertToManagedDisksFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesConvertToManagedDisksFuture.Result.
func (future *VirtualMachinesConvertToManagedDisksFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesConvertToManagedDisksFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesConvertToManagedDisksFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (VirtualMachine, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesCreateOrUpdateFuture.Result.
func (future *VirtualMachinesCreateOrUpdateFuture) result(client VirtualMachinesClient) (VM VirtualMachine, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		VM.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if VM.Response.Response, err = future.GetResult(sender); err == nil && VM.Response.Response.StatusCode != http.StatusNoContent {
		VM, err = client.CreateOrUpdateResponder(VM.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachinesCreateOrUpdateFuture", "Result", VM.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachinesDeallocateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesDeallocateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesDeallocateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesDeallocateFuture.Result.
func (future *VirtualMachinesDeallocateFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesDeallocateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesDeallocateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesDeleteFuture.Result.
func (future *VirtualMachinesDeleteFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesInstallPatchesFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesInstallPatchesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (VirtualMachineInstallPatchesResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesInstallPatchesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesInstallPatchesFuture.Result.
func (future *VirtualMachinesInstallPatchesFuture) result(client VirtualMachinesClient) (vmipr VirtualMachineInstallPatchesResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesInstallPatchesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vmipr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesInstallPatchesFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vmipr.Response.Response, err = future.GetResult(sender); err == nil && vmipr.Response.Response.StatusCode != http.StatusNoContent {
		vmipr, err = client.InstallPatchesResponder(vmipr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachinesInstallPatchesFuture", "Result", vmipr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineSize describes the properties of a VM size.
type VirtualMachineSize struct {
	// Name - The name of the virtual machine size.
	Name *string `json:"name,omitempty"`
	// NumberOfCores - The number of cores supported by the virtual machine size. For Constrained vCPU capable VM sizes, this number represents the total vCPUs of quota that the VM uses. For accurate vCPU count, please refer to https://docs.microsoft.com/azure/virtual-machines/constrained-vcpu or https://docs.microsoft.com/rest/api/compute/resourceskus/list
	NumberOfCores *int32 `json:"numberOfCores,omitempty"`
	// OsDiskSizeInMB - The OS disk size, in MB, allowed by the virtual machine size.
	OsDiskSizeInMB *int32 `json:"osDiskSizeInMB,omitempty"`
	// ResourceDiskSizeInMB - The resource disk size, in MB, allowed by the virtual machine size.
	ResourceDiskSizeInMB *int32 `json:"resourceDiskSizeInMB,omitempty"`
	// MemoryInMB - The amount of memory, in MB, supported by the virtual machine size.
	MemoryInMB *int32 `json:"memoryInMB,omitempty"`
	// MaxDataDiskCount - The maximum number of data disks that can be attached to the virtual machine size.
	MaxDataDiskCount *int32 `json:"maxDataDiskCount,omitempty"`
}

// VirtualMachineSizeListResult the List Virtual Machine operation response.
type VirtualMachineSizeListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of virtual machine sizes.
	Value *[]VirtualMachineSize `json:"value,omitempty"`
}

// VirtualMachineSoftwarePatchProperties describes the properties of a Virtual Machine software patch.
type VirtualMachineSoftwarePatchProperties struct {
	// PatchID - READ-ONLY; A unique identifier for the patch.
	PatchID *string `json:"patchId,omitempty"`
	// Name - READ-ONLY; The friendly name of the patch.
	Name *string `json:"name,omitempty"`
	// Version - READ-ONLY; The version number of the patch. This property applies only to Linux patches.
	Version *string `json:"version,omitempty"`
	// KbID - READ-ONLY; The KBID of the patch. Only applies to Windows patches.
	KbID *string `json:"kbId,omitempty"`
	// Classifications - READ-ONLY; The classification(s) of the patch as provided by the patch publisher.
	Classifications *[]string `json:"classifications,omitempty"`
	// RebootBehavior - READ-ONLY; Describes the reboot requirements of the patch. Possible values include: 'VMGuestPatchRebootBehaviorUnknown', 'VMGuestPatchRebootBehaviorNeverReboots', 'VMGuestPatchRebootBehaviorAlwaysRequiresReboot', 'VMGuestPatchRebootBehaviorCanRequestReboot'
	RebootBehavior VMGuestPatchRebootBehavior `json:"rebootBehavior,omitempty"`
	// ActivityID - READ-ONLY; The activity ID of the operation that produced this result. It is used to correlate across CRP and extension logs.
	ActivityID *string `json:"activityId,omitempty"`
	// PublishedDate - READ-ONLY; The UTC timestamp when the repository published this patch.
	PublishedDate *date.Time `json:"publishedDate,omitempty"`
	// LastModifiedDateTime - READ-ONLY; The UTC timestamp of the last update to this patch record.
	LastModifiedDateTime *date.Time `json:"lastModifiedDateTime,omitempty"`
	// AssessmentState - READ-ONLY; Describes the availability of a given patch. Possible values include: 'PatchAssessmentStateUnknown', 'PatchAssessmentStateAvailable'
	AssessmentState PatchAssessmentState `json:"assessmentState,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineSoftwarePatchProperties.
func (vmspp VirtualMachineSoftwarePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachinesPerformMaintenanceFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesPerformMaintenanceFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesPerformMaintenanceFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesPerformMaintenanceFuture.Result.
func (future *VirtualMachinesPerformMaintenanceFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesPerformMaintenanceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesPerformMaintenanceFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesPowerOffFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesPowerOffFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesPowerOffFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesPowerOffFuture.Result.
func (future *VirtualMachinesPowerOffFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesPowerOffFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesPowerOffFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesReapplyFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesReapplyFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesReapplyFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesReapplyFuture.Result.
func (future *VirtualMachinesReapplyFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesReapplyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesReapplyFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesRedeployFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesRedeployFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesRedeployFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesRedeployFuture.Result.
func (future *VirtualMachinesRedeployFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesRedeployFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesRedeployFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesReimageFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesReimageFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesReimageFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesReimageFuture.Result.
func (future *VirtualMachinesReimageFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesReimageFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesReimageFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesRestartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesRestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesRestartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesRestartFuture.Result.
func (future *VirtualMachinesRestartFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesRestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesRunCommandFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesRunCommandFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (RunCommandResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesRunCommandFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesRunCommandFuture.Result.
func (future *VirtualMachinesRunCommandFuture) result(client VirtualMachinesClient) (rcr RunCommandResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesRunCommandFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rcr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesRunCommandFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rcr.Response.Response, err = future.GetResult(sender); err == nil && rcr.Response.Response.StatusCode != http.StatusNoContent {
		rcr, err = client.RunCommandResponder(rcr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachinesRunCommandFuture", "Result", rcr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachinesStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesStartFuture.Result.
func (future *VirtualMachinesStartFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineStatusCodeCount the status code and count of the virtual machine scale set instance view
// status summary.
type VirtualMachineStatusCodeCount struct {
	// Code - READ-ONLY; The instance view status code.
	Code *string `json:"code,omitempty"`
	// Count - READ-ONLY; The number of instances having a particular status code.
	Count *int32 `json:"count,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineStatusCodeCount.
func (vmscc VirtualMachineStatusCodeCount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachinesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (VirtualMachine, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesUpdateFuture.Result.
func (future *VirtualMachinesUpdateFuture) result(client VirtualMachinesClient) (VM VirtualMachine, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachinesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		VM.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("compute.VirtualMachinesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if VM.Response.Response, err = future.GetResult(sender); err == nil && VM.Response.Response.StatusCode != http.StatusNoContent {
		VM, err = client.UpdateResponder(VM.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.VirtualMachinesUpdateFuture", "Result", VM.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineUpdate describes a Virtual Machine Update.
type VirtualMachineUpdate struct {
	// Plan - Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
	Plan                      *Plan `json:"plan,omitempty"`
	*VirtualMachineProperties `json:"properties,omitempty"`
	// Identity - The identity of the virtual machine, if configured.
	Identity *VirtualMachineIdentity `json:"identity,omitempty"`
	// Zones - The virtual machine zones.
	Zones *[]string `json:"zones,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualMachineUpdate.
func (vmu VirtualMachineUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmu.Plan != nil {
		objectMap["plan"] = vmu.Plan
	}
	if vmu.VirtualMachineProperties != nil {
		objectMap["properties"] = vmu.VirtualMachineProperties
	}
	if vmu.Identity != nil {
		objectMap["identity"] = vmu.Identity
	}
	if vmu.Zones != nil {
		objectMap["zones"] = vmu.Zones
	}
	if vmu.Tags != nil {
		objectMap["tags"] = vmu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineUpdate struct.
func (vmu *VirtualMachineUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "plan":
			if v != nil {
				var plan Plan
				err = json.Unmarshal(*v, &plan)
				if err != nil {
					return err
				}
				vmu.Plan = &plan
			}
		case "properties":
			if v != nil {
				var virtualMachineProperties VirtualMachineProperties
				err = json.Unmarshal(*v, &virtualMachineProperties)
				if err != nil {
					return err
				}
				vmu.VirtualMachineProperties = &virtualMachineProperties
			}
		case "identity":
			if v != nil {
				var identity VirtualMachineIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				vmu.Identity = &identity
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				vmu.Zones = &zones
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vmu.Tags = tags
			}
		}
	}

	return nil
}

// VMDiskSecurityProfile specifies the security profile settings for the managed disk. <br><br> NOTE: It
// can only be set for Confidential VMs
type VMDiskSecurityProfile struct {
	// SecurityEncryptionType - Specifies the EncryptionType of the managed disk. <br> It is set to DiskWithVMGuestState for encryption of the managed disk along with VMGuestState blob, and VMGuestStateOnly for encryption of just the VMGuestState blob. <br><br> NOTE: It can be set for only Confidential VMs. Possible values include: 'SecurityEncryptionTypesVMGuestStateOnly', 'SecurityEncryptionTypesDiskWithVMGuestState'
	SecurityEncryptionType SecurityEncryptionTypes `json:"securityEncryptionType,omitempty"`
	// DiskEncryptionSet - Specifies the customer managed disk encryption set resource id for the managed disk that is used for Customer Managed Key encrypted ConfidentialVM OS Disk and VMGuest blob.
	DiskEncryptionSet *DiskEncryptionSetParameters `json:"diskEncryptionSet,omitempty"`
}

// VMGalleryApplication specifies the required information to reference a compute gallery application
// version
type VMGalleryApplication struct {
	// Tags - Optional, Specifies a passthrough value for more generic context.
	Tags *string `json:"tags,omitempty"`
	// Order - Optional, Specifies the order in which the packages have to be installed
	Order *int32 `json:"order,omitempty"`
	// PackageReferenceID - Specifies the GalleryApplicationVersion resource id on the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}
	PackageReferenceID *string `json:"packageReferenceId,omitempty"`
	// ConfigurationReference - Optional, Specifies the uri to an azure blob that will replace the default configuration for the package if provided
	ConfigurationReference *string `json:"configurationReference,omitempty"`
}

// VMScaleSetConvertToSinglePlacementGroupInput ...
type VMScaleSetConvertToSinglePlacementGroupInput struct {
	// ActivePlacementGroupID - Id of the placement group in which you want future virtual machine instances to be placed. To query placement group Id, please use Virtual Machine Scale Set VMs - Get API. If not provided, the platform will choose one with maximum number of virtual machine instances.
	ActivePlacementGroupID *string `json:"activePlacementGroupId,omitempty"`
}

// VMSizeProperties specifies VM Size Property settings on the virtual machine.
type VMSizeProperties struct {
	// VCPUsAvailable - Specifies the number of vCPUs available for the VM. <br><br> When this property is not specified in the request body the default behavior is to set it to the value of vCPUs available for that VM size exposed in api response of [List all available virtual machine sizes in a region](https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list) .
	VCPUsAvailable *int32 `json:"vCPUsAvailable,omitempty"`
	// VCPUsPerCore - Specifies the vCPU to physical core ratio. <br><br> When this property is not specified in the request body the default behavior is set to the value of vCPUsPerCore for the VM Size exposed in api response of [List all available virtual machine sizes in a region](https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list) <br><br> Setting this property to 1 also means that hyper-threading is disabled.
	VCPUsPerCore *int32 `json:"vCPUsPerCore,omitempty"`
}

// WindowsConfiguration specifies Windows operating system settings on the virtual machine.
type WindowsConfiguration struct {
	// ProvisionVMAgent - Indicates whether virtual machine agent should be provisioned on the virtual machine. <br><br> When this property is not specified in the request body, default behavior is to set it to true.  This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
	ProvisionVMAgent *bool `json:"provisionVMAgent,omitempty"`
	// EnableAutomaticUpdates - Indicates whether Automatic Updates is enabled for the Windows virtual machine. Default value is true. <br><br> For virtual machine scale sets, this property can be updated and updates will take effect on OS reprovisioning.
	EnableAutomaticUpdates *bool `json:"enableAutomaticUpdates,omitempty"`
	// TimeZone - Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time". <br><br> Possible values can be [TimeZoneInfo.Id](https://docs.microsoft.com/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id) value from time zones returned by [TimeZoneInfo.GetSystemTimeZones](https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones).
	TimeZone *string `json:"timeZone,omitempty"`
	// AdditionalUnattendContent - Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
	AdditionalUnattendContent *[]AdditionalUnattendContent `json:"additionalUnattendContent,omitempty"`
	// PatchSettings - [Preview Feature] Specifies settings related to VM Guest Patching on Windows.
	PatchSettings *PatchSettings `json:"patchSettings,omitempty"`
	// WinRM - Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.
	WinRM *WinRMConfiguration `json:"winRM,omitempty"`
}

// WindowsParameters input for InstallPatches on a Windows VM, as directly received by the API
type WindowsParameters struct {
	// ClassificationsToInclude - The update classifications to select when installing patches for Windows.
	ClassificationsToInclude *[]VMGuestPatchClassificationWindows `json:"classificationsToInclude,omitempty"`
	// KbNumbersToInclude - Kbs to include in the patch operation
	KbNumbersToInclude *[]string `json:"kbNumbersToInclude,omitempty"`
	// KbNumbersToExclude - Kbs to exclude in the patch operation
	KbNumbersToExclude *[]string `json:"kbNumbersToExclude,omitempty"`
	// ExcludeKbsRequiringReboot - Filters out Kbs that don't have an InstallationRebootBehavior of 'NeverReboots' when this is set to true.
	ExcludeKbsRequiringReboot *bool `json:"excludeKbsRequiringReboot,omitempty"`
	// MaxPatchPublishDate - This is used to install patches that were published on or before this given max published date.
	MaxPatchPublishDate *date.Time `json:"maxPatchPublishDate,omitempty"`
}

// WinRMConfiguration describes Windows Remote Management configuration of the VM
type WinRMConfiguration struct {
	// Listeners - The list of Windows Remote Management listeners
	Listeners *[]WinRMListener `json:"listeners,omitempty"`
}

// WinRMListener describes Protocol and thumbprint of Windows Remote Management listener
type WinRMListener struct {
	// Protocol - Specifies the protocol of WinRM listener. <br><br> Possible values are: <br>**http** <br><br> **https**. Possible values include: 'ProtocolTypesHTTP', 'ProtocolTypesHTTPS'
	Protocol ProtocolTypes `json:"protocol,omitempty"`
	// CertificateURL - This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
	CertificateURL *string `json:"certificateUrl,omitempty"`
}
