package bootkube

import (
	"os"
	"path/filepath"

	"github.com/openshift/installer/pkg/asset"
	"github.com/openshift/installer/pkg/asset/templates/content"
)

const (
	openshiftConfigConfigmapEtcdMetricServingCAFileName = "openshift-config-configmap-etcd-metric-serving-ca.yaml.template"
)

var _ asset.WritableAsset = (*OpenshiftConfigConfigmapEtcdMetricServingCA)(nil)

// OpenshiftConfigConfigmapEtcdMetricServingCA is the constant to represent contents of openshift-config-configmap-etcd-metric-serving-ca.yaml.template file.
type OpenshiftConfigConfigmapEtcdMetricServingCA struct {
	FileList []*asset.File
}

// Dependencies returns all of the dependencies directly needed by the asset
func (t *OpenshiftConfigConfigmapEtcdMetricServingCA) Dependencies() []asset.Asset {
	return []asset.Asset{}
}

// Name returns the human-friendly name of the asset.
func (t *OpenshiftConfigConfigmapEtcdMetricServingCA) Name() string {
	return "OpenshiftConfigConfigmapEtcdMetricServingCA"
}

// Generate generates the actual files by this asset
func (t *OpenshiftConfigConfigmapEtcdMetricServingCA) Generate(parents asset.Parents) error {
	fileName := openshiftConfigConfigmapEtcdMetricServingCAFileName
	data, err := content.GetBootkubeTemplate(fileName)
	if err != nil {
		return err
	}
	t.FileList = []*asset.File{
		{
			Filename: filepath.Join(content.TemplateDir, fileName),
			Data:     []byte(data),
		},
	}
	return nil
}

// Files returns the files generated by the asset.
func (t *OpenshiftConfigConfigmapEtcdMetricServingCA) Files() []*asset.File {
	return t.FileList
}

// Load returns the asset from disk.
func (t *OpenshiftConfigConfigmapEtcdMetricServingCA) Load(f asset.FileFetcher) (bool, error) {
	file, err := f.FetchByName(filepath.Join(content.TemplateDir, openshiftConfigConfigmapEtcdMetricServingCAFileName))
	if err != nil {
		if os.IsNotExist(err) {
			return false, nil
		}
		return false, err
	}
	t.FileList = []*asset.File{file}
	return true, nil
}
